/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.java;

import javajs.api.JSONEncodable;
import javajs.util.SB;

public class BS
implements Cloneable,
JSONEncodable {
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final long WORD_MASK = -1L;
    private long[] words;
    private transient int wordsInUse = 0;
    private transient boolean sizeIsSticky = false;
    private static final long[] emptyBitmap = new long[0];

    private static int wordIndex(int n) {
        return n >> 6;
    }

    public BS() {
        this.initWords(64);
        this.sizeIsSticky = false;
    }

    public static BS newN(int n) {
        BS bS = new BS();
        bS.init(n);
        return bS;
    }

    private void recalculateWordsInUse() {
        int n;
        for (n = this.wordsInUse - 1; n >= 0 && this.words[n] == 0L; --n) {
        }
        this.wordsInUse = n + 1;
    }

    private void init(int n) {
        if (n < 0) {
            throw new NegativeArraySizeException("nbits < 0: " + n);
        }
        this.initWords(n);
        this.sizeIsSticky = true;
    }

    private void initWords(int n) {
        this.words = new long[BS.wordIndex(n - 1) + 1];
    }

    private void ensureCapacity(int n) {
        if (this.words.length < n) {
            int n2 = Math.max(2 * this.words.length, n);
            this.setLength(n2);
            this.sizeIsSticky = false;
        }
    }

    private void expandTo(int n) {
        int n2 = n + 1;
        if (this.wordsInUse < n2) {
            this.ensureCapacity(n2);
            this.wordsInUse = n2;
        }
    }

    public void set(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n);
        }
        int n2 = BS.wordIndex(n);
        this.expandTo(n2);
        int n3 = n2;
        this.words[n3] = this.words[n3] | 1L << n;
    }

    public void setBitTo(int n, boolean bl) {
        if (bl) {
            this.set(n);
        } else {
            this.clear(n);
        }
    }

    public void setBits(int n, int n2) {
        if (n == n2) {
            return;
        }
        int n3 = BS.wordIndex(n);
        int n4 = BS.wordIndex(n2 - 1);
        this.expandTo(n4);
        long l = -1L << n;
        long l2 = -1L >>> -n2;
        if (n3 == n4) {
            int n5 = n3;
            this.words[n5] = this.words[n5] | l & l2;
        } else {
            int n6 = n3;
            this.words[n6] = this.words[n6] | l;
            for (int i = n3 + 1; i < n4; ++i) {
                this.words[i] = -1L;
            }
            int n7 = n4;
            this.words[n7] = this.words[n7] | l2;
        }
    }

    public void clear(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n);
        }
        int n2 = BS.wordIndex(n);
        if (n2 >= this.wordsInUse) {
            return;
        }
        int n3 = n2;
        this.words[n3] = this.words[n3] & (1L << n ^ 0xFFFFFFFFFFFFFFFFL);
        this.recalculateWordsInUse();
    }

    public void clearBits(int n, int n2) {
        if (n == n2) {
            return;
        }
        int n3 = BS.wordIndex(n);
        if (n3 >= this.wordsInUse) {
            return;
        }
        int n4 = BS.wordIndex(n2 - 1);
        if (n4 >= this.wordsInUse) {
            n2 = this.length();
            n4 = this.wordsInUse - 1;
        }
        long l = -1L << n;
        long l2 = -1L >>> -n2;
        if (n3 == n4) {
            int n5 = n3;
            this.words[n5] = this.words[n5] & (l & l2 ^ 0xFFFFFFFFFFFFFFFFL);
        } else {
            int n6 = n3;
            this.words[n6] = this.words[n6] & (l ^ 0xFFFFFFFFFFFFFFFFL);
            for (int i = n3 + 1; i < n4; ++i) {
                this.words[i] = 0L;
            }
            int n7 = n4;
            this.words[n7] = this.words[n7] & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
        }
        this.recalculateWordsInUse();
    }

    public void clearAll() {
        while (this.wordsInUse > 0) {
            this.words[--this.wordsInUse] = 0L;
        }
    }

    public boolean get(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n);
        }
        int n2 = BS.wordIndex(n);
        return n2 < this.wordsInUse && (this.words[n2] & 1L << n) != 0L;
    }

    public int nextSetBit(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n);
        }
        int n2 = BS.wordIndex(n);
        if (n2 >= this.wordsInUse) {
            return -1;
        }
        long l = this.words[n2] & -1L << n;
        while (l == 0L) {
            if (++n2 == this.wordsInUse) {
                return -1;
            }
            l = this.words[n2];
        }
        return n2 * 64 + Long.numberOfTrailingZeros(l);
    }

    public int nextClearBit(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n);
        }
        int n2 = BS.wordIndex(n);
        if (n2 >= this.wordsInUse) {
            return n;
        }
        long l = (this.words[n2] ^ 0xFFFFFFFFFFFFFFFFL) & -1L << n;
        while (l == 0L) {
            if (++n2 == this.wordsInUse) {
                return this.wordsInUse * 64;
            }
            l = this.words[n2] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return n2 * 64 + Long.numberOfTrailingZeros(l);
    }

    public int length() {
        if (this.wordsInUse == 0) {
            return 0;
        }
        return 64 * (this.wordsInUse - 1) + (64 - Long.numberOfLeadingZeros(this.words[this.wordsInUse - 1]));
    }

    public boolean isEmpty() {
        return this.wordsInUse == 0;
    }

    public boolean intersects(BS bS) {
        for (int i = Math.min(this.wordsInUse, bS.wordsInUse) - 1; i >= 0; --i) {
            if ((this.words[i] & bS.words[i]) == 0L) continue;
            return true;
        }
        return false;
    }

    public int cardinality() {
        int n = 0;
        for (int i = 0; i < this.wordsInUse; ++i) {
            n += Long.bitCount(this.words[i]);
        }
        return n;
    }

    public void and(BS bS) {
        if (this == bS) {
            return;
        }
        while (this.wordsInUse > bS.wordsInUse) {
            this.words[--this.wordsInUse] = 0L;
        }
        for (int i = 0; i < this.wordsInUse; ++i) {
            int n = i;
            this.words[n] = this.words[n] & bS.words[i];
        }
        this.recalculateWordsInUse();
    }

    public void or(BS bS) {
        if (this == bS) {
            return;
        }
        int n = Math.min(this.wordsInUse, bS.wordsInUse);
        if (this.wordsInUse < bS.wordsInUse) {
            this.ensureCapacity(bS.wordsInUse);
            this.wordsInUse = bS.wordsInUse;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            this.words[n2] = this.words[n2] | bS.words[i];
        }
        if (n < bS.wordsInUse) {
            System.arraycopy(bS.words, n, this.words, n, this.wordsInUse - n);
        }
    }

    public void xor(BS bS) {
        int n = Math.min(this.wordsInUse, bS.wordsInUse);
        if (this.wordsInUse < bS.wordsInUse) {
            this.ensureCapacity(bS.wordsInUse);
            this.wordsInUse = bS.wordsInUse;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            this.words[n2] = this.words[n2] ^ bS.words[i];
        }
        if (n < bS.wordsInUse) {
            System.arraycopy(bS.words, n, this.words, n, bS.wordsInUse - n);
        }
        this.recalculateWordsInUse();
    }

    public void andNot(BS bS) {
        for (int i = Math.min(this.wordsInUse, bS.wordsInUse) - 1; i >= 0; --i) {
            int n = i;
            this.words[n] = this.words[n] & (bS.words[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        this.recalculateWordsInUse();
    }

    public int hashCode() {
        long l = 1234L;
        int n = this.wordsInUse;
        while (--n >= 0) {
            l ^= this.words[n] * (long)(n + 1);
        }
        return (int)(l >> 32 ^ l);
    }

    public int size() {
        return this.words.length * 64;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BS)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        BS bS = (BS)object;
        if (this.wordsInUse != bS.wordsInUse) {
            return false;
        }
        for (int i = 0; i < this.wordsInUse; ++i) {
            if (this.words[i] == bS.words[i]) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        if (!this.sizeIsSticky && this.wordsInUse != this.words.length) {
            this.setLength(this.wordsInUse);
        }
        try {
            BS bS = (BS)super.clone();
            bS.words = bS.wordsInUse == 0 ? emptyBitmap : (long[])this.words.clone();
            return bS;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private void setLength(int n) {
        long[] lArray = new long[n];
        System.arraycopy(this.words, 0, lArray, 0, Math.min(this.wordsInUse, n));
        this.words = lArray;
    }

    public String toString() {
        int n = this.wordsInUse > 128 ? this.cardinality() : this.wordsInUse * 64;
        SB sB = SB.newN(6 * n + 2);
        sB.appendC('[');
        int n2 = this.nextSetBit(0);
        if (n2 != -1) {
            sB.appendI(n2);
            n2 = this.nextSetBit(n2 + 1);
            while (n2 >= 0) {
                int n3 = this.nextClearBit(n2);
                do {
                    sB.append(", ").appendI(n2);
                } while (++n2 < n3);
                n2 = this.nextSetBit(n2 + 1);
            }
        }
        sB.appendC(']');
        return sB.toString();
    }

    public int cardinalityN(int n) {
        int n2 = this.cardinality();
        int n3 = this.length();
        while (--n3 >= n) {
            if (!this.get(n3)) continue;
            --n2;
        }
        return n2;
    }

    @Override
    public String toJSON() {
        return this.toString();
    }
}

