/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.awt;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.List;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolViewer;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class FileDropper
implements DropTargetListener {
    private String fd_oldFileName;
    private PropertyChangeSupport fd_propSupport;
    public static final String FD_PROPERTY_INLINE = "inline";
    JmolViewer viewer;
    PropertyChangeListener pcl;
    JmolStatusListener statusListener;

    public FileDropper(JmolStatusListener jmolStatusListener, JmolViewer jmolViewer) {
        this.statusListener = jmolStatusListener;
        this.fd_oldFileName = "";
        this.fd_propSupport = new PropertyChangeSupport(this);
        this.viewer = jmolViewer;
        this.pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FileDropper.this.doDrop(propertyChangeEvent);
            }
        };
        this.addPropertyChangeListener(this.pcl);
        Component component = (Component)jmolViewer.getDisplay();
        component.setDropTarget(new DropTarget(component, this));
        component.setEnabled(true);
        System.out.println("File dropper enabled for " + component);
    }

    public void dispose() {
        this.removePropertyChangeListener(this.pcl);
        this.viewer = null;
        System.out.println("File dropper disposed.");
    }

    private void loadFile(String string) {
        if ((string = string.replace('\\', '/').trim()).indexOf("://") < 0) {
            string = (string.startsWith("/") ? "file://" : "file:///") + string;
        }
        if (this.statusListener != null) {
            try {
                String string2 = this.viewer.getEmbeddedFileState(string);
                if (string2.indexOf("preferredWidthHeight") >= 0) {
                    this.statusListener.resizeInnerPanel(string2);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.viewer.openFileAsyncSpecial(string, 1);
    }

    private void loadFiles(List<File> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            File file = list.get(i);
            String string = file.getAbsolutePath();
            string = string.replace('\\', '/').trim();
            string = (string.startsWith("/") ? "file://" : "file:///") + string;
            stringBuilder.append("load ").append(i == 0 ? "" : "APPEND ").append(Escape.eS(string)).append(";\n");
        }
        stringBuilder.append("frame *;reset;");
        this.viewer.script(stringBuilder.toString());
    }

    protected void doDrop(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == FD_PROPERTY_INLINE) {
            this.viewer.openStringInline((String)propertyChangeEvent.getNewValue());
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fd_propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fd_propSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (Logger.debugging) {
            Logger.debug("DropOver detected...");
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (Logger.debugging) {
            Logger.debug("DropEnter detected...");
        }
        dropTargetDragEvent.acceptDrag(3);
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (Logger.debugging) {
            Logger.debug("DropExit detected...");
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        System.out.println("dropactionchanged");
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Object object;
        Object object2;
        if (Logger.debugging) {
            Logger.debug("Drop detected...");
        }
        Transferable transferable = dropTargetDropEvent.getTransferable();
        boolean bl = false;
        if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            object2 = null;
            try {
                dropTargetDropEvent.acceptDrop(3);
                object2 = transferable.getTransferData(DataFlavor.javaFileListFlavor);
                bl = true;
            }
            catch (Exception exception) {
                Logger.error("transfer failed");
            }
            if (object2 instanceof List) {
                List list = (List)object2;
                int n = list.size();
                if (n == 1) {
                    object = ((File)list.get(0)).getAbsolutePath().trim();
                    if (!((String)object).endsWith(".bmp")) {
                        dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                        this.loadFile((String)object);
                        return;
                    }
                } else {
                    dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                    this.loadFiles(list);
                    return;
                }
            }
        }
        if (Logger.debugging) {
            Logger.debug("browsing supported flavours to find something useful...");
        }
        if ((object2 = transferable.getTransferDataFlavors()) == null || ((DataFlavor[])object2).length == 0) {
            return;
        }
        for (int i = 0; i < ((DataFlavor[])object2).length; ++i) {
            DataFlavor dataFlavor = object2[i];
            object = null;
            Logger.info("df " + i + " flavor " + dataFlavor);
            Logger.info("  class: " + dataFlavor.getRepresentationClass().getName());
            Logger.info("  mime : " + dataFlavor.getMimeType());
            if (dataFlavor.getMimeType().startsWith("text/uri-list") && dataFlavor.getRepresentationClass().getName().equals("java.lang.String")) {
                try {
                    if (!bl) {
                        dropTargetDropEvent.acceptDrop(3);
                    }
                    bl = true;
                    object = transferable.getTransferData(dataFlavor);
                }
                catch (Exception exception) {
                    Logger.errorEx(null, exception);
                }
                if (!(object instanceof String)) continue;
                if (Logger.debugging) {
                    Logger.debug("  String: " + object.toString());
                }
                this.loadFile(object.toString());
                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                return;
            }
            if (!dataFlavor.getMimeType().equals("application/x-java-serialized-object; class=java.lang.String")) continue;
            try {
                if (!bl) {
                    dropTargetDropEvent.acceptDrop(3);
                }
                bl = true;
                object = transferable.getTransferData(object2[i]);
            }
            catch (Exception exception) {
                Logger.errorEx(null, exception);
            }
            if (!(object instanceof String)) continue;
            String string = (String)object;
            if (Logger.debugging) {
                Logger.debug("  String: " + string);
            }
            if (string.startsWith("file:/")) {
                this.loadFile(string);
            } else {
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, FD_PROPERTY_INLINE, this.fd_oldFileName, string);
                this.fd_propSupport.firePropertyChange(propertyChangeEvent);
            }
            dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            return;
        }
        if (!bl) {
            dropTargetDropEvent.rejectDrop();
        }
    }
}

