/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Map;
import javajs.util.List;
import org.jmol.adapter.smarter.AtomIterator;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.BondIterator;
import org.jmol.adapter.smarter.Resolver;
import org.jmol.adapter.smarter.StructureIterator;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolAdapterAtomIterator;
import org.jmol.api.JmolAdapterBondIterator;
import org.jmol.api.JmolAdapterStructureIterator;
import org.jmol.api.JmolDocument;
import org.jmol.api.JmolFilesReaderInterface;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class SmarterJmolAdapter
extends JmolAdapter {
    public static final String PATH_KEY = ".PATH";
    public static final String PATH_SEPARATOR = System.getProperty("path.separator", "/");

    @Override
    public String getFileTypeName(Object object) {
        if (object instanceof AtomSetCollection) {
            return ((AtomSetCollection)object).getFileTypeName();
        }
        if (object instanceof BufferedReader) {
            return Resolver.getFileType((BufferedReader)object);
        }
        return null;
    }

    @Override
    public Object getAtomSetCollectionReader(String string, String string2, Object object, Map<String, Object> map) {
        return SmarterJmolAdapter.staticGetAtomSetCollectionReader(string, string2, object, map);
    }

    public static Object staticGetAtomSetCollectionReader(String string, String string2, Object object, Map<String, Object> map) {
        try {
            Object object2 = Resolver.getAtomCollectionReader(string, string2, object, map, -1);
            if (object2 instanceof String) {
                try {
                    SmarterJmolAdapter.close(object);
                }
                catch (Exception exception) {}
            } else {
                ((AtomSetCollectionReader)object2).setup(string, map, object);
            }
            return object2;
        }
        catch (Throwable throwable) {
            try {
                SmarterJmolAdapter.close(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = null;
            Logger.error("" + throwable);
            return "" + throwable;
        }
    }

    @Override
    public Object getAtomSetCollectionFromReader(String string, Object object, Map<String, Object> map) throws Exception {
        Object object2 = Resolver.getAtomCollectionReader(string, null, object, map, -1);
        if (object2 instanceof AtomSetCollectionReader) {
            ((AtomSetCollectionReader)object2).setup(string, map, object);
            return ((AtomSetCollectionReader)object2).readData();
        }
        return "" + object2;
    }

    @Override
    public Object getAtomSetCollection(Object object) {
        return SmarterJmolAdapter.staticGetAtomSetCollection((AtomSetCollectionReader)object);
    }

    public static Object staticGetAtomSetCollection(AtomSetCollectionReader atomSetCollectionReader) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = atomSetCollectionReader.reader;
            Object object = atomSetCollectionReader.readData();
            if (!(object instanceof AtomSetCollection)) {
                return object;
            }
            AtomSetCollection atomSetCollection = (AtomSetCollection)object;
            if (atomSetCollection.errorMessage != null) {
                return atomSetCollection.errorMessage;
            }
            return atomSetCollection;
        }
        catch (Throwable throwable) {
            try {
                System.out.println(throwable.toString());
            }
            catch (Exception exception) {
                Logger.error(throwable.toString());
            }
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            bufferedReader = null;
            Logger.error("" + throwable);
            return "" + throwable;
        }
    }

    @Override
    public Object getAtomSetCollectionReaders(JmolFilesReaderInterface jmolFilesReaderInterface, String[] stringArray, String[] stringArray2, Map<String, Object> map, boolean bl) {
        int n = stringArray.length;
        AtomSetCollectionReader[] atomSetCollectionReaderArray = bl ? new AtomSetCollectionReader[n] : null;
        AtomSetCollection[] atomSetCollectionArray = bl ? null : new AtomSetCollection[n];
        AtomSetCollectionReader atomSetCollectionReader = null;
        Viewer viewer = (Viewer)map.get("viewer");
        for (int i = 0; i < n; ++i) {
            try {
                Object object;
                if (atomSetCollectionReader != null) {
                    map.put("viewer", viewer);
                }
                if (!((object = jmolFilesReaderInterface.getBufferedReaderOrBinaryDocument(i, false)) instanceof BufferedReader) && !(object instanceof JmolDocument)) {
                    return object;
                }
                Object object2 = Resolver.getAtomCollectionReader(stringArray[i], stringArray2 == null ? null : stringArray2[i], object, map, i);
                if (!(object2 instanceof AtomSetCollectionReader)) {
                    return object2;
                }
                atomSetCollectionReader = (AtomSetCollectionReader)object2;
                atomSetCollectionReader.setup(null, null, null);
                if (atomSetCollectionReader.isBinary) {
                    atomSetCollectionReader.setup(stringArray[i], map, jmolFilesReaderInterface.getBufferedReaderOrBinaryDocument(i, true));
                } else {
                    atomSetCollectionReader.setup(stringArray[i], map, object);
                }
                if (bl) {
                    atomSetCollectionReaderArray[i] = atomSetCollectionReader;
                    continue;
                }
                object2 = atomSetCollectionReader.readData();
                if (!(object2 instanceof AtomSetCollection)) {
                    return object2;
                }
                atomSetCollectionArray[i] = (AtomSetCollection)object2;
                if (atomSetCollectionArray[i].errorMessage == null) continue;
                return atomSetCollectionArray[i].errorMessage;
            }
            catch (Throwable throwable) {
                Logger.error("" + throwable);
                if (!viewer.isJS) {
                    throwable.printStackTrace();
                }
                return "" + throwable;
            }
        }
        if (bl) {
            return atomSetCollectionReaderArray;
        }
        return this.getAtomSetCollectionFromSet(atomSetCollectionReaderArray, atomSetCollectionArray, map);
    }

    @Override
    public Object getAtomSetCollectionFromSet(Object object, Object object2, Map<String, Object> map) {
        AtomSetCollection atomSetCollection;
        AtomSetCollection[] atomSetCollectionArray;
        AtomSetCollectionReader[] atomSetCollectionReaderArray = (AtomSetCollectionReader[])object;
        AtomSetCollection[] atomSetCollectionArray2 = atomSetCollectionArray = object2 == null ? new AtomSetCollection[atomSetCollectionReaderArray.length] : (AtomSetCollection[])object2;
        if (object2 == null) {
            for (int i = 0; i < atomSetCollectionReaderArray.length; ++i) {
                try {
                    Object object3 = atomSetCollectionReaderArray[i].readData();
                    if (!(object3 instanceof AtomSetCollection)) {
                        return object3;
                    }
                    atomSetCollectionArray[i] = (AtomSetCollection)object3;
                    if (atomSetCollectionArray[i].errorMessage == null) continue;
                    return atomSetCollectionArray[i].errorMessage;
                }
                catch (Throwable throwable) {
                    Logger.error("" + throwable);
                    return "" + throwable;
                }
            }
        }
        if (map.containsKey("trajectorySteps")) {
            atomSetCollection = atomSetCollectionArray[0];
            try {
                atomSetCollection.finalizeTrajectoryAs((List)map.get("trajectorySteps"), (List)map.get("vibrationSteps"));
            }
            catch (Exception exception) {
                if (atomSetCollection.errorMessage == null) {
                    atomSetCollection.errorMessage = "" + exception;
                }
            }
        } else if (atomSetCollectionArray[0].isTrajectory) {
            atomSetCollection = atomSetCollectionArray[0];
            for (int i = 1; i < atomSetCollectionArray.length; ++i) {
                atomSetCollectionArray[0].mergeTrajectories(atomSetCollectionArray[i]);
            }
        } else {
            atomSetCollection = new AtomSetCollection("Array", null, atomSetCollectionArray, null);
        }
        return atomSetCollection.errorMessage == null ? atomSetCollection : atomSetCollection.errorMessage;
    }

    @Override
    public Object getAtomSetCollectionFromDOM(Object object, Map<String, Object> map) {
        try {
            Object object2 = Resolver.DOMResolve(object, map);
            if (!(object2 instanceof AtomSetCollectionReader)) {
                return object2;
            }
            AtomSetCollectionReader atomSetCollectionReader = (AtomSetCollectionReader)object2;
            atomSetCollectionReader.setup("DOM node", map, null);
            object2 = atomSetCollectionReader.readDataObject(object);
            if (!(object2 instanceof AtomSetCollection)) {
                return object2;
            }
            AtomSetCollection atomSetCollection = (AtomSetCollection)object2;
            if (atomSetCollection.errorMessage != null) {
                return atomSetCollection.errorMessage;
            }
            return atomSetCollection;
        }
        catch (Throwable throwable) {
            Logger.error("" + throwable);
            return "" + throwable;
        }
    }

    @Override
    public void finish(Object object) {
        ((AtomSetCollection)object).finish();
    }

    @Override
    public String getAtomSetCollectionName(Object object) {
        return ((AtomSetCollection)object).getCollectionName();
    }

    @Override
    public Map<String, Object> getAtomSetCollectionAuxiliaryInfo(Object object) {
        return ((AtomSetCollection)object).getAtomSetCollectionAuxiliaryInfoMap();
    }

    @Override
    public int getAtomSetCount(Object object) {
        return ((AtomSetCollection)object).getAtomSetCount();
    }

    @Override
    public int getAtomSetNumber(Object object, int n) {
        return ((AtomSetCollection)object).getAtomSetNumber(n);
    }

    @Override
    public String getAtomSetName(Object object, int n) {
        return ((AtomSetCollection)object).getAtomSetName(n);
    }

    @Override
    public Map<String, Object> getAtomSetAuxiliaryInfo(Object object, int n) {
        return ((AtomSetCollection)object).getAtomSetAuxiliaryInfo(n);
    }

    @Override
    public int getHydrogenAtomCount(Object object) {
        return ((AtomSetCollection)object).getHydrogenAtomCount();
    }

    @Override
    public String[][] getBondList(Object object) {
        return ((AtomSetCollection)object).getBondList();
    }

    @Override
    public int getAtomCount(Object object) {
        AtomSetCollection atomSetCollection = (AtomSetCollection)object;
        return atomSetCollection.bsAtoms == null ? atomSetCollection.getAtomCount() : atomSetCollection.bsAtoms.cardinality();
    }

    @Override
    public boolean coordinatesAreFractional(Object object) {
        return ((AtomSetCollection)object).coordinatesAreFractional;
    }

    @Override
    public float[] getNotionalUnitcell(Object object) {
        return ((AtomSetCollection)object).notionalUnitCell;
    }

    @Override
    public float[] getPdbScaleMatrix(Object object) {
        float[] fArray = ((AtomSetCollection)object).notionalUnitCell;
        if (fArray.length < 22) {
            return null;
        }
        float[] fArray2 = new float[16];
        for (int i = 0; i < 16; ++i) {
            fArray2[i] = fArray[6 + i];
        }
        return fArray2;
    }

    @Override
    public float[] getPdbScaleTranslate(Object object) {
        float[] fArray = ((AtomSetCollection)object).notionalUnitCell;
        if (fArray.length < 22) {
            return null;
        }
        float[] fArray2 = new float[]{fArray[9], fArray[13], fArray[17]};
        return fArray2;
    }

    @Override
    public JmolAdapterAtomIterator getAtomIterator(Object object) {
        return new AtomIterator((AtomSetCollection)object);
    }

    @Override
    public JmolAdapterBondIterator getBondIterator(Object object) {
        return new BondIterator((AtomSetCollection)object);
    }

    @Override
    public JmolAdapterStructureIterator getStructureIterator(Object object) {
        return ((AtomSetCollection)object).getStructureCount() == 0 ? null : new StructureIterator((AtomSetCollection)object);
    }

    public static void close(Object object) throws IOException {
        if (object instanceof BufferedReader) {
            ((BufferedReader)object).close();
        } else {
            ((JmolDocument)object).close();
        }
    }
}

