/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.api.JmolDataManager;
import org.jmol.constant.EnumVdw;
import org.jmol.java.BS;
import org.jmol.script.T;
import org.jmol.util.BSUtil;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.viewer.JmolStateCreator;
import org.jmol.viewer.Viewer;

public class DataManager
implements JmolDataManager {
    private Map<String, Object[]> dataValues = new Hashtable<String, Object[]>();
    private Viewer viewer;
    private static final int DATA_TYPE_STRING = 0;
    private static final int DATA_TYPE_AF = 1;
    private static final int DATA_ARRAY_FF = 2;
    private static final int DATA_ARRAY_FFF = 3;
    private static final int DATA_VALUE = 1;
    private static final int DATA_SELECTION_MAP = 2;
    private static final int DATA_TYPE = 3;
    private static final int DATA_SAVE_IN_STATE = 4;

    @Override
    public JmolDataManager set(Viewer viewer) {
        this.viewer = viewer;
        return this;
    }

    @Override
    public void clear() {
        this.dataValues.clear();
    }

    @Override
    public void setData(String string, Object[] objectArray, int n, int n2, int n3, int n4, int n5, int n6) {
        if (string == null) {
            this.clear();
            return;
        }
        if ((string = string.toLowerCase()).equals("element_vdw")) {
            String string2 = ((String)objectArray[1]).trim();
            if (string2.length() == 0) {
                this.viewer.userVdwMars = null;
                this.viewer.userVdws = null;
                this.viewer.bsUserVdws = null;
                return;
            }
            if (this.viewer.bsUserVdws == null) {
                this.viewer.setUserVdw(this.viewer.defaultVdw);
            }
            Parser.parseFloatArrayFromMatchAndField(string2, this.viewer.bsUserVdws, 1, 0, (int[])objectArray[2], 2, 0, this.viewer.userVdws, 1);
            int n7 = this.viewer.userVdws.length;
            while (--n7 >= 0) {
                this.viewer.userVdwMars[n7] = (int)Math.floor(this.viewer.userVdws[n7] * 1000.0f);
            }
            return;
        }
        if (objectArray[2] != null && n > 0) {
            int n8;
            BS bS;
            boolean bl = n3 != 0 || n5 != Integer.MIN_VALUE && n5 != Integer.MAX_VALUE;
            Object[] objectArray2 = this.dataValues.get(string);
            float[] fArray = objectArray2 == null || bl ? new float[n2] : AU.ensureLengthA((float[])objectArray2[1], n2);
            int n9 = (Integer)objectArray[3];
            String string3 = n9 == 0 ? (String)objectArray[1] : null;
            float[] fArray2 = n9 == 1 ? (float[])objectArray[1] : null;
            String[] stringArray = null;
            if (n5 == Integer.MIN_VALUE && (stringArray = PT.getTokens(string3)).length > 1) {
                n5 = 0;
            }
            if (n5 == Integer.MIN_VALUE) {
                bS = (BS)objectArray[2];
                DataManager.setSelectedFloats(PT.parseFloat(string3), bS, fArray);
            } else if (n5 == 0 || n5 == Integer.MAX_VALUE) {
                bS = (BS)objectArray[2];
                if (fArray2 != null) {
                    if (fArray2.length == bS.cardinality()) {
                        int n10 = bS.nextSetBit(0);
                        n8 = 0;
                        while (n10 >= 0) {
                            fArray[n10] = fArray2[n8];
                            n10 = bS.nextSetBit(n10 + 1);
                            ++n8;
                        }
                    } else {
                        int n11 = bS.nextSetBit(0);
                        while (n11 >= 0) {
                            fArray[n11] = fArray2[n11];
                            n11 = bS.nextSetBit(n11 + 1);
                        }
                    }
                } else {
                    Parser.parseFloatArrayBsData(stringArray == null ? PT.getTokens(string3) : stringArray, bS, fArray);
                }
            } else if (n3 <= 0) {
                bS = (BS)objectArray[2];
                Parser.parseFloatArrayFromMatchAndField(string3, bS, 0, 0, null, n5, n6, fArray, 1);
            } else {
                int[] nArray = (int[])objectArray[2];
                Parser.parseFloatArrayFromMatchAndField(string3, null, n3, n4, nArray, n5, n6, fArray, 1);
                bS = new BS();
                n8 = nArray.length;
                while (--n8 >= 0) {
                    if (nArray[n8] < 0) continue;
                    bS.set(nArray[n8]);
                }
            }
            if (objectArray2 != null && objectArray2[2] instanceof BS && !bl) {
                bS.or((BS)objectArray2[2]);
            }
            objectArray[3] = 1;
            objectArray[2] = bS;
            objectArray[1] = fArray;
            if (string.indexOf("property_atom.") == 0) {
                int n12 = T.getSettableTokFromString(string = string.substring(14));
                if (n12 == 0) {
                    Logger.error("Unknown atom property: " + string);
                    return;
                }
                n8 = bS.cardinality();
                float[] fArray3 = new float[n8];
                int n13 = 0;
                int n14 = bS.nextSetBit(0);
                while (n13 < n8) {
                    fArray3[n13++] = fArray[n14];
                    n14 = bS.nextSetBit(n14 + 1);
                }
                this.viewer.setAtomProperty(bS, n12, 0, 0.0f, null, fArray3, null);
                return;
            }
        }
        this.dataValues.put(string, objectArray);
    }

    private static void setSelectedFloats(float f, BS bS, float[] fArray) {
        int n;
        boolean bl = bS == null;
        int n2 = n = bl ? 0 : bS.nextSetBit(0);
        while (n2 >= 0 && n2 < fArray.length) {
            fArray[n2] = f;
            n2 = bl ? n2 + 1 : bS.nextSetBit(n2 + 1);
        }
    }

    @Override
    public Object[] getData(String string) {
        if (this.dataValues.size() == 0 || string == null) {
            return null;
        }
        if (!string.equalsIgnoreCase("types")) {
            return this.dataValues.get(string);
        }
        Object[] objectArray = new String[]{"types", ""};
        int n = 0;
        for (String string2 : this.dataValues.keySet()) {
            objectArray[1] = (String)objectArray[1] + (n++ > 0 ? "\n" : "") + string2;
        }
        return objectArray;
    }

    @Override
    public float[] getDataFloatA(String string) {
        if (this.dataValues.size() == 0) {
            return null;
        }
        Object[] objectArray = this.getData(string);
        if (objectArray == null || (Integer)objectArray[3] != 1) {
            return null;
        }
        return (float[])objectArray[1];
    }

    @Override
    public float getDataFloat(String string, int n) {
        float[] fArray;
        Object[] objectArray;
        if (this.dataValues.size() > 0 && (objectArray = this.getData(string)) != null && (Integer)objectArray[3] == 1 && n < (fArray = (float[])objectArray[1]).length) {
            return fArray[n];
        }
        return Float.NaN;
    }

    @Override
    public float[][] getDataFloat2D(String string) {
        if (this.dataValues.size() == 0) {
            return null;
        }
        Object[] objectArray = this.getData(string);
        if (objectArray == null || (Integer)objectArray[3] != 2) {
            return null;
        }
        return (float[][])objectArray[1];
    }

    @Override
    public float[][][] getDataFloat3D(String string) {
        if (this.dataValues.size() == 0) {
            return null;
        }
        Object[] objectArray = this.getData(string);
        if (objectArray == null || (Integer)objectArray[3] != 3) {
            return null;
        }
        return (float[][][])objectArray[1];
    }

    @Override
    public void deleteModelAtoms(int n, int n2, BS bS) {
        if (this.dataValues.size() == 0) {
            return;
        }
        for (String string : this.dataValues.keySet()) {
            if (string.indexOf("property_") != 0) continue;
            Object[] objectArray = this.dataValues.get(string);
            BSUtil.deleteBits((BS)objectArray[2], bS);
            switch ((Integer)objectArray[3]) {
                case 1: {
                    objectArray[1] = AU.deleteElements(objectArray[1], n, n2);
                    break;
                }
                case 2: {
                    objectArray[1] = AU.deleteElements(objectArray[1], n, n2);
                    break;
                }
            }
        }
    }

    @Override
    public String getDefaultVdwNameOrData(EnumVdw enumVdw, BS bS) {
        SB sB = new SB();
        sB.append(enumVdw.getVdwLabel()).append("\n");
        boolean bl = bS == null;
        int n = bl ? 1 : bS.nextSetBit(0);
        int n2 = bl ? Elements.elementNumberMax : bS.length();
        int n3 = n;
        while (n3 < n2 && n3 >= 0) {
            sB.appendI(n3).appendC('\t').appendF(enumVdw == EnumVdw.USER ? this.viewer.userVdws[n3] : (float)Elements.getVanderwaalsMar(n3, enumVdw) / 1000.0f).appendC('\t').append(Elements.elementSymbolFromNumber(n3)).appendC('\n');
            n3 = bl ? n3 + 1 : bS.nextSetBit(n3 + 1);
        }
        return bS == null ? sB.toString() : "\n  DATA \"element_vdw\"\n" + sB.append("  end \"element_vdw\";\n\n").toString();
    }

    @Override
    public boolean getDataState(JmolStateCreator jmolStateCreator, SB sB) {
        if (this.dataValues.size() == 0) {
            return false;
        }
        boolean bl = false;
        for (String string : this.dataValues.keySet()) {
            Object object;
            Object[] objectArray;
            if (string.indexOf("property_") == 0) {
                objectArray = this.dataValues.get(string);
                if (objectArray.length > 4 && objectArray[4] == Boolean.FALSE) continue;
                bl = true;
                object = objectArray[1];
                if (object != null && (Integer)objectArray[3] == 1) {
                    jmolStateCreator.getAtomicPropertyStateBuffer(sB, (byte)14, (BS)objectArray[2], string, (float[])object);
                    sB.append("\n");
                    continue;
                }
                sB.append("\n").append(Escape.encapsulateData(string, object, 0));
                continue;
            }
            if (string.indexOf("data2d") == 0) {
                objectArray = this.dataValues.get(string);
                object = objectArray[1];
                if (object == null || (Integer)objectArray[3] != 2) continue;
                bl = true;
                sB.append("\n").append(Escape.encapsulateData(string, object, 2));
                continue;
            }
            if (string.indexOf("data3d") != 0 || (object = (objectArray = this.dataValues.get(string))[1]) == null || (Integer)objectArray[3] != 3) continue;
            bl = true;
            sB.append("\n").append(Escape.encapsulateData(string, object, 3));
        }
        return bl;
    }
}

