/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.AU;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.api.QuantumPlaneCalculationInterface;
import org.jmol.api.VolumeDataInterface;
import org.jmol.atomdata.AtomData;
import org.jmol.java.BS;
import org.jmol.jvxl.readers.SurfaceFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;

abstract class VolumeFileReader
extends SurfaceFileReader {
    protected boolean endOfData;
    protected boolean negativeAtomCount;
    protected int atomCount;
    protected int nSurfaces;
    protected boolean isAngstroms;
    protected boolean canDownsample;
    private int[] downsampleRemainders;
    private boolean preProcessPlanes;
    private int nData;
    private boolean readerClosed;
    protected int downsampleFactor;
    private int nSkipX;
    private int nSkipY;
    private int nSkipZ;
    private float[][] yzPlanesRaw;
    private int iPlaneRaw;
    protected P3[] boundingBox;
    private boolean isScaledAlready;

    VolumeFileReader() {
    }

    @Override
    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2VFR(surfaceGenerator, bufferedReader);
    }

    void init2VFR(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2SFR(surfaceGenerator, bufferedReader);
        this.isXLowToHigh = true;
        this.isProgressive = true;
        this.canDownsample = true;
        this.jvxlData.wasCubic = true;
        this.boundingBox = this.params.boundingBox;
        if (this.params.qmOrbitalType == 4) {
            this.hasColorData = this.params.parameters == null || this.params.parameters[1] >= 0.0f;
            this.preProcessPlanes = true;
            this.params.insideOut = !this.params.insideOut;
        }
    }

    protected float recordData(float f) {
        if (Float.isNaN(f)) {
            return f;
        }
        if (f < this.dataMin) {
            this.dataMin = f;
        }
        if (f > this.dataMax) {
            this.dataMax = f;
        }
        this.dataMean += f;
        ++this.nData;
        return f;
    }

    @Override
    protected void closeReader() {
        if (this.readerClosed) {
            return;
        }
        this.readerClosed = true;
        this.closeReaderSFR();
        if (this.nData == 0 || this.dataMax == -3.4028235E38f) {
            return;
        }
        this.dataMean /= (float)this.nData;
        Logger.info((String)("VolumeFileReader closing file: " + this.nData + " points read \ndata min/max/mean = " + this.dataMin + "/" + this.dataMax + "/" + this.dataMean));
    }

    @Override
    protected boolean readVolumeParameters(boolean bl) {
        this.endOfData = false;
        this.nSurfaces = this.readVolumetricHeader();
        if (this.nSurfaces == 0) {
            return false;
        }
        if (this.nSurfaces < this.params.fileIndex) {
            Logger.warn((String)("not enough surfaces in file -- resetting params.fileIndex to " + this.nSurfaces));
            this.params.fileIndex = this.nSurfaces;
        }
        return true;
    }

    @Override
    protected boolean readVolumeData(boolean bl) {
        return this.readVolumeDataVFR(bl);
    }

    protected boolean readVolumeDataVFR(boolean bl) {
        if (!this.gotoAndReadVoxelData(bl)) {
            return false;
        }
        if (!this.vertexDataOnly) {
            Logger.info((String)("JVXL read: " + this.nPointsX + " x " + this.nPointsY + " x " + this.nPointsZ + " data points"));
        }
        return true;
    }

    private int readVolumetricHeader() {
        try {
            int n;
            boolean bl;
            this.readParameters();
            if (this.atomCount == Integer.MIN_VALUE) {
                return 0;
            }
            if (!this.vertexDataOnly) {
                Logger.info((String)("voxel grid origin:" + this.volumetricOrigin));
            }
            int n2 = this.params.downsampleFactor;
            boolean bl2 = bl = this.canDownsample && n2 > 0;
            if (bl) {
                this.downsampleRemainders = new int[3];
                Logger.info((String)("downsample factor = " + n2));
                for (n = 0; n < 3; ++n) {
                    int n3 = this.voxelCounts[n];
                    this.downsampleRemainders[n] = n3 % n2;
                    int n4 = n;
                    this.voxelCounts[n4] = this.voxelCounts[n4] / n2;
                    this.volumetricVectors[n].scale((float)n2);
                    Logger.info((String)("downsampling axis " + (n + 1) + " from " + n3 + " to " + this.voxelCounts[n]));
                }
            }
            if (!this.vertexDataOnly) {
                for (n = 0; n < 3; ++n) {
                    if (!this.isAngstroms) {
                        this.volumetricVectors[n].scale(0.5291772f);
                    }
                    this.line = this.voxelCounts[n] + " " + this.volumetricVectors[n].x + " " + this.volumetricVectors[n].y + " " + this.volumetricVectors[n].z;
                    this.jvxlFileHeaderBuffer.append(this.line).appendC('\n');
                    Logger.info((String)("voxel grid count/vector:" + this.line));
                }
            }
            this.scaleIsosurface(this.params.scale);
            this.volumeData.setVolumetricXml();
            return this.nSurfaces;
        }
        catch (Exception exception) {
            Logger.error((String)exception.toString());
            return 0;
        }
    }

    protected abstract void readParameters() throws Exception;

    protected String skipComments(boolean bl) throws Exception {
        SB sB = new SB();
        while (this.readLine() != null && (bl && this.line.length() == 0 || this.line.indexOf("#") == 0)) {
            sB.append(this.line).appendC('\n');
        }
        return sB.toString();
    }

    protected void readVoxelVector(int n) throws Exception {
        this.readLine();
        V3 v3 = this.volumetricVectors[n];
        this.voxelCounts[n] = this.parseIntStr(this.line);
        if (this.voxelCounts[n] == Integer.MIN_VALUE) {
            this.next[0] = this.line.indexOf(" ");
        }
        v3.set(this.parseFloat(), this.parseFloat(), this.parseFloat());
        if (this.isAnisotropic) {
            this.setVectorAnisotropy(v3);
        }
    }

    void initializeSurfaceData() {
        this.downsampleFactor = this.params.downsampleFactor;
        this.nSkipX = 0;
        this.nSkipY = 0;
        this.nSkipZ = 0;
        if (this.canDownsample && this.downsampleFactor > 0) {
            this.nSkipX = this.downsampleFactor - 1;
            this.nSkipZ = this.nPointsZ * this.downsampleFactor + this.downsampleRemainders[2];
            this.nSkipY = this.downsampleRemainders[2] + (this.downsampleFactor - 1) * this.nSkipZ;
            this.nSkipZ = this.downsampleRemainders[1] * this.nSkipZ + (this.downsampleFactor - 1) * this.nSkipZ * (this.nPointsY * this.downsampleFactor + this.downsampleRemainders[1]);
        }
        if (this.params.thePlane != null) {
            this.params.cutoff = 0.0f;
        } else if (this.isJvxl) {
            this.params.cutoff = this.params.isBicolorMap || this.params.colorBySign ? 0.01f : 0.5f;
        }
        this.nDataPoints = 0;
        this.next[0] = 0;
        this.line = "";
        this.jvxlNSurfaceInts = 0;
    }

    @Override
    protected void readSurfaceData(boolean bl) throws Exception {
        this.readSurfaceDataVFR(bl);
    }

    protected void readSurfaceDataVFR(boolean bl) throws Exception {
        this.initializeSurfaceData();
        if (this.isProgressive && !bl || this.isJvxl) {
            this.nDataPoints = this.volumeData.setVoxelCounts(this.nPointsX, this.nPointsY, this.nPointsZ);
            this.voxelData = null;
            if (this.isJvxl) {
                this.jvxlVoxelBitSet = this.getVoxelBitSet(this.nDataPoints);
            }
        } else if (bl && this.volumeData.hasPlane()) {
            this.volumeData.setVoxelMap();
            float f = this.volumeData.getToPlaneParameter();
            for (int i = 0; i < this.nPointsX; ++i) {
                for (int j = 0; j < this.nPointsY; ++j) {
                    for (int k = 0; k < this.nPointsZ; ++k) {
                        float f2 = this.recordData(this.getNextVoxelValue());
                        if (this.volumeData.isNearPlane(i, j, k, f)) {
                            this.volumeData.setVoxelMapValue(i, j, k, f2);
                        }
                        if (this.nSkipX == 0) continue;
                        this.skipVoxels(this.nSkipX);
                    }
                    if (this.nSkipY == 0) continue;
                    this.skipVoxels(this.nSkipY);
                }
                if (this.nSkipZ == 0) continue;
                this.skipVoxels(this.nSkipZ);
            }
        } else {
            this.voxelData = AU.newFloat3((int)this.nPointsX, (int)-1);
            for (int i = 0; i < this.nPointsX; ++i) {
                float[][] fArray = AU.newFloat2((int)this.nPointsY);
                this.voxelData[i] = fArray;
                for (int j = 0; j < this.nPointsY; ++j) {
                    float[] fArray2 = new float[this.nPointsZ];
                    fArray[j] = fArray2;
                    for (int k = 0; k < this.nPointsZ; ++k) {
                        fArray2[k] = this.recordData(this.getNextVoxelValue());
                        if (this.nSkipX == 0) continue;
                        this.skipVoxels(this.nSkipX);
                    }
                    if (this.nSkipY == 0) continue;
                    this.skipVoxels(this.nSkipY);
                }
                if (this.nSkipZ == 0) continue;
                this.skipVoxels(this.nSkipZ);
            }
        }
        this.volumeData.setVoxelDataAsArray(this.voxelData);
    }

    @Override
    public float[] getPlane(int n) {
        if (n == 0) {
            this.initPlanes();
        }
        if (this.preProcessPlanes) {
            return this.getPlaneProcessed(n);
        }
        float[] fArray = this.getPlane2(n);
        if (this.qpc == null) {
            this.getPlane(fArray, true);
        }
        return fArray;
    }

    public float[] getPlaneProcessed(int n) {
        float[] fArray;
        if (this.iPlaneRaw == 0) {
            this.qpc = (QuantumPlaneCalculationInterface)Interface.getOptionInterface((String)"quantum.NciCalculation");
            AtomData atomData = new AtomData();
            atomData.modelIndex = -1;
            atomData.bsSelected = this.params.bsSelected;
            this.sg.fillAtomData(atomData, 1);
            this.qpc.setupCalculation((VolumeDataInterface)this.volumeData, this.sg.getBsSelected(), null, null, null, atomData.atomXyz, -1, null, (float[][])null, (int[][])null, null, null, null, this.params.isSquaredLinear, (float[][])null, this.params.theProperty, true, null, this.params.parameters, this.params.testFlags);
            this.iPlaneRaw = 1;
            this.yzPlanesRaw = new float[4][this.yzCount];
            this.qpc.setPlanes(this.yzPlanesRaw);
            if (this.hasColorData) {
                this.getPlane(this.yzPlanesRaw[0], false);
                this.getPlane(this.yzPlanesRaw[1], false);
                float[] fArray2 = this.yzPlanes[0];
                for (int i = 0; i < this.yzCount; ++i) {
                    fArray2[i] = Float.NaN;
                }
                return fArray2;
            }
            this.iPlaneRaw = -1;
        }
        float f = this.qpc.getNoValue();
        int n2 = this.nPointsX - 1;
        switch (this.iPlaneRaw) {
            case -1: {
                fArray = this.yzPlanes[n % 2];
                ++n2;
                break;
            }
            case 3: {
                fArray = this.yzPlanesRaw[0];
                this.yzPlanesRaw[0] = this.yzPlanesRaw[1];
                this.yzPlanesRaw[1] = this.yzPlanesRaw[2];
                this.yzPlanesRaw[2] = this.yzPlanesRaw[3];
                this.yzPlanesRaw[3] = fArray;
                fArray = this.yzPlanesRaw[this.iPlaneRaw];
                break;
            }
            default: {
                ++this.iPlaneRaw;
                fArray = this.yzPlanesRaw[this.iPlaneRaw];
            }
        }
        if (n < n2) {
            this.getPlane(fArray, false);
            fArray = this.yzPlanes[n % 2];
            this.qpc.calcPlane(n, fArray);
            for (int i = 0; i < this.yzCount; ++i) {
                if (fArray[i] == f) continue;
                this.recordData(fArray[i]);
            }
        } else {
            for (int i = 0; i < this.yzCount; ++i) {
                fArray[i] = Float.NaN;
            }
        }
        return fArray;
    }

    private void getPlane(float[] fArray, boolean bl) {
        try {
            int n = 0;
            for (int i = 0; i < this.nPointsY; ++i) {
                for (int j = 0; j < this.nPointsZ; ++j) {
                    float f = this.getNextVoxelValue();
                    if (bl) {
                        this.recordData(f);
                    }
                    fArray[n++] = f;
                    if (this.nSkipX == 0) continue;
                    this.skipVoxels(this.nSkipX);
                }
                if (this.nSkipY == 0) continue;
                this.skipVoxels(this.nSkipY);
            }
            if (this.nSkipZ != 0) {
                this.skipVoxels(this.nSkipZ);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public float getValue(int n, int n2, int n3, int n4) {
        if (this.boundingBox != null) {
            this.volumeData.voxelPtToXYZ(n, n2, n3, this.ptTemp);
            if (this.ptTemp.x < this.boundingBox[0].x || this.ptTemp.x > this.boundingBox[1].x || this.ptTemp.y < this.boundingBox[0].y || this.ptTemp.y > this.boundingBox[1].y || this.ptTemp.z < this.boundingBox[0].z || this.ptTemp.z > this.boundingBox[1].z) {
                return Float.NaN;
            }
        }
        return this.getValue2(n, n2, n3, n4);
    }

    private void skipVoxels(int n) throws Exception {
        int n2 = n;
        while (--n2 >= 0) {
            this.getNextVoxelValue();
        }
    }

    protected BS getVoxelBitSet(int n) throws Exception {
        return null;
    }

    protected float getNextVoxelValue() throws Exception {
        float f = 0.0f;
        if (this.nSurfaces > 1 && !this.params.blockCubeData) {
            int n;
            for (n = 1; n < this.params.fileIndex; ++n) {
                this.nextVoxel();
            }
            f = this.nextVoxel();
            for (n = this.params.fileIndex; n < this.nSurfaces; ++n) {
                this.nextVoxel();
            }
        } else {
            f = this.nextVoxel();
        }
        return f;
    }

    protected float nextVoxel() throws Exception {
        float f = this.parseFloat();
        if (Float.isNaN(f)) {
            while (this.readLine() != null && Float.isNaN(f = this.parseFloatStr(this.line))) {
            }
            if (this.line == null) {
                if (!this.endOfData) {
                    Logger.warn((String)("end of file reading cube voxel data? nBytes=" + this.nBytes + " nDataPoints=" + this.nDataPoints + " (line):" + this.line));
                }
                this.endOfData = true;
                this.line = "0 0 0 0 0 0 0 0 0 0";
            }
        }
        return f;
    }

    @Override
    protected void gotoData(int n, int n2) throws Exception {
        if (!this.params.blockCubeData) {
            return;
        }
        if (n > 0) {
            Logger.info((String)("skipping " + n + " data sets, " + n2 + " points each"));
        }
        for (int i = 0; i < n; ++i) {
            this.skipData(n2);
        }
    }

    protected void skipData(int n) throws Exception {
        this.skipDataVFR(n);
    }

    protected void skipDataVFR(int n) throws Exception {
        for (int i = 0; i < n; i += this.countData(this.readLine())) {
        }
    }

    private int countData(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            char c;
            while (n2 < n3 && ((c = string.charAt(n2)) == ' ' || c == '\t')) {
                ++n2;
            }
            if (n2 < n3) {
                ++n;
            }
            while (n2 < n3 && (c = string.charAt(n2)) != ' ' && c != '\t') {
                ++n2;
            }
        }
        return n;
    }

    protected static boolean checkAtomLine(boolean bl, boolean bl2, String string, String string2, SB sB) {
        if (string2.indexOf("ANGSTROMS") >= 0) {
            bl2 = true;
        }
        int n = string == null ? Integer.MAX_VALUE : PT.parseInt((String)string);
        switch (n) {
            case -2147483648: {
                n = 0;
                string2 = " " + string2.substring(string2.indexOf(" ") + 1);
                break;
            }
            case 0x7FFFFFFF: {
                n = Integer.MIN_VALUE;
                break;
            }
            default: {
                String string3 = "" + n;
                string2 = string2.substring(string2.indexOf(string3) + string3.length());
            }
        }
        if (bl2) {
            if (string2.indexOf("ANGSTROM") < 0) {
                string2 = string2 + " ANGSTROMS";
            }
        } else if (string2.indexOf("BOHR") < 0) {
            string2 = string2 + " BOHR";
        }
        string2 = (n == Integer.MIN_VALUE ? "" : (bl ? "+" : "-") + Math.abs(n)) + string2 + "\n";
        sB.append(string2);
        return bl2;
    }

    @Override
    protected float getSurfacePointAndFraction(float f, boolean bl, float f2, float f3, P3 p3, V3 v3, int n, int n2, int n3, int n4, int n5, float[] fArray, P3 p32) {
        return this.getSPFv(f, bl, f2, f3, p3, v3, n, n2, n3, n4, n5, fArray, p32);
    }

    protected float getSPFv(float f, boolean bl, float f2, float f3, P3 p3, V3 v3, int n, int n2, int n3, int n4, int n5, float[] fArray, P3 p32) {
        float f4 = this.getSPF(f, bl, f2, f3, p3, v3, n, n2, n3, n4, n5, fArray, p32);
        if (this.qpc == null || Float.isNaN(f4) || !this.hasColorData) {
            return f4;
        }
        n4 = this.marchingCubes.getLinearOffset(n, n2, n3, n4);
        n5 = this.marchingCubes.getLinearOffset(n, n2, n3, n5);
        return this.qpc.process(n4, n5, fArray[0]);
    }

    private void scaleIsosurface(float f) {
        if (this.isScaledAlready) {
            return;
        }
        this.isScaledAlready = true;
        if (this.isAnisotropic) {
            this.setVolumetricAnisotropy();
        }
        if (Float.isNaN(f)) {
            return;
        }
        Logger.info((String)("applying scaling factor of " + f));
        this.volumetricOrigin.scaleAdd2((1.0f - f) / 2.0f, (T3)this.volumetricVectors[0], (T3)this.volumetricOrigin);
        this.volumetricOrigin.scaleAdd2((1.0f - f) / 2.0f, (T3)this.volumetricVectors[1], (T3)this.volumetricOrigin);
        this.volumetricOrigin.scaleAdd2((1.0f - f) / 2.0f, (T3)this.volumetricVectors[2], (T3)this.volumetricOrigin);
        this.volumetricVectors[0].scale(f);
        this.volumetricVectors[1].scale(f);
        this.volumetricVectors[2].scale(f);
    }
}

