/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Hashtable;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.ModulationSet;

public class Modulation {
    private static final double TWOPI = Math.PI * 2;
    private double[] qCoefs;
    private double a1;
    private double a2;
    private double center;
    private double left;
    private double right;
    private char axis;
    private final char type;
    private double[] params;
    private String utens;
    public static final char TYPE_DISP_FOURIER = 'f';
    public static final char TYPE_DISP_SAWTOOTH = 's';
    public static final char TYPE_OCC_FOURIER = 'o';
    public static final char TYPE_OCC_CRENEL = 'c';
    public static final char TYPE_U_FOURIER = 'u';

    public Modulation(char c, char c2, double[] dArray, String string, double[] dArray2) {
        if (Logger.debuggingHigh) {
            Logger.debug("MOD create " + Escape.e(dArray2) + " axis=" + c + " type=" + c2 + " params=" + Escape.e(dArray) + " utens=" + string);
        }
        this.axis = c;
        this.type = c2;
        this.utens = string;
        this.params = dArray;
        this.qCoefs = dArray2;
        switch (c2) {
            case 'f': 
            case 'o': 
            case 'u': {
                this.a1 = dArray[0];
                this.a2 = dArray[1];
                break;
            }
            case 'c': 
            case 's': {
                this.center = dArray[0];
                double d = dArray[1];
                if (d > 1.0) {
                    d = 1.0;
                }
                this.left = this.center - d / 2.0;
                this.right = this.center + d / 2.0;
                if (this.left < 0.0) {
                    this.left += 1.0;
                }
                if (this.right > 1.0) {
                    this.right -= 1.0;
                }
                if (this.left >= this.right && this.left - this.right < (double)0.01f) {
                    this.left = this.right + (double)0.01f;
                }
                this.a1 = 2.0 * dArray[2] / dArray[1];
            }
        }
    }

    void apply(ModulationSet modulationSet, double[][] dArray) {
        double d = 0.0;
        int n = this.qCoefs.length;
        while (--n >= 0) {
            d += this.qCoefs[n] * dArray[n][0];
        }
        double d2 = 0.0;
        switch (this.type) {
            case 'f': 
            case 'o': 
            case 'u': {
                double d3 = Math.PI * 2 * d;
                if (this.a1 != 0.0) {
                    d2 += this.a1 * Math.cos(d3);
                }
                if (this.a2 != 0.0) {
                    d2 += this.a2 * Math.sin(d3);
                }
                if (!Logger.debuggingHigh) break;
                Logger.debug("MOD " + modulationSet.id + " " + Escape.e(this.qCoefs) + " axis=" + this.axis + " v=" + d2 + " ccos,csin=" + this.a1 + "," + this.a2 + " / theta=" + d3);
                break;
            }
            case 'c': {
                d -= Math.floor(d);
                modulationSet.vOcc = this.range(d) ? 1 : 0;
                modulationSet.vOcc0 = Float.NaN;
                return;
            }
            case 's': {
                d -= Math.floor(d);
                if (!this.range(d)) {
                    return;
                }
                if (this.left > this.right) {
                    if (d < this.left && this.left < this.center) {
                        d += 1.0;
                    } else if (d > this.right && this.right > this.center) {
                        d -= 1.0;
                    }
                }
                d2 = this.a1 * (d - this.center);
            }
        }
        switch (this.axis) {
            case 'x': {
                modulationSet.x = (float)((double)modulationSet.x + d2);
                break;
            }
            case 'y': {
                modulationSet.y = (float)((double)modulationSet.y + d2);
                break;
            }
            case 'z': {
                modulationSet.z = (float)((double)modulationSet.z + d2);
                break;
            }
            case 'U': {
                modulationSet.addUTens(this.utens, (float)d2);
                break;
            }
            default: {
                if (Float.isNaN(modulationSet.vOcc)) {
                    modulationSet.vOcc = 0.0f;
                }
                modulationSet.vOcc += (float)d2;
            }
        }
    }

    private boolean range(double d) {
        return this.left < this.right ? this.left <= d && d <= this.right : this.left <= d || d <= this.right;
    }

    public Hashtable<String, Object> getInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("type", "" + this.type + this.axis);
        hashtable.put("params", this.params);
        hashtable.put("qCoefs", this.qCoefs);
        if (this.utens != null) {
            hashtable.put("Utens", this.utens);
        }
        return hashtable;
    }
}

