/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import javajs.util.List;
import javajs.util.P3;
import org.jmol.api.MOCalculationInterface;
import org.jmol.api.VolumeDataInterface;
import org.jmol.constant.EnumQuantumShell;
import org.jmol.java.BS;
import org.jmol.quantum.QuantumCalculation;
import org.jmol.quantum.SlaterData;
import org.jmol.util.Logger;

public class MOCalculation
extends QuantumCalculation
implements MOCalculationInterface {
    private static final double CUT = -50.0;
    private double[] CX;
    private double[] CY;
    private double[] CZ;
    private double[] DXY;
    private double[] DXZ;
    private double[] DYZ;
    private double[] EX;
    private double[] EY;
    private double[] EZ;
    private String calculationType;
    private List<int[]> shells;
    private float[][] gaussians;
    private SlaterData[] slaters;
    private float[] moCoefficients;
    private int moCoeff;
    private int gaussianPtr;
    private boolean doNormalize = true;
    private boolean nwChemMode = false;
    private int[][] dfCoefMaps = new int[][]{new int[1], new int[3], new int[4], new int[5], new int[6], new int[7], new int[10]};
    private float[] linearCombination;
    private float[][] coefs;
    private double moFactor = 1.0;
    private boolean havePoints;
    boolean testing = true;
    double sum = -1.0;
    private double c = 1.0;
    private int nGaussians;
    private boolean doShowShellType;
    private EnumQuantumShell basisType;
    private final double[] coeffs = new double[10];
    private int[] map;
    private static final double ROOT3 = 1.7320507764816284;
    private static final String[][] shellOrder = new String[][]{{"S"}, {"X", "Y", "Z"}, {"S", "X", "Y", "Z"}, {"d0/z2", "d1+/xz", "d1-/yz", "d2+/x2-y2", "d2-/xy"}, {"XX", "YY", "ZZ", "XY", "XZ", "YZ"}, {"f0/2z3-3x2z-3y2z", "f1+/4xz2-x3-xy2", "f1-/4yz2-x2y-y3", "f2+/x2z-y2z", "f2-/xyz", "f3+/x3-3xy2", "f3-/3x2y-y3"}, {"XXX", "YYY", "ZZZ", "XYY", "XXY", "XXZ", "XZZ", "YZZ", "YYZ", "XYZ"}};
    float integration = 0.0f;
    private boolean isSquaredLinear;

    @Override
    public boolean setupCalculation(VolumeDataInterface volumeDataInterface, BS bS, BS bS2, BS[] bSArray, String string, P3[] p3Array, int n, List<int[]> list, float[][] fArray, int[][] nArray, Object object, float[] fArray2, float[] fArray3, boolean bl, float[][] fArray4, float[] fArray5, boolean bl2, P3[] p3Array2, float[] fArray6, int n2) {
        this.havePoints = p3Array2 != null;
        this.calculationType = string;
        this.firstAtomOffset = n;
        this.shells = list;
        this.gaussians = fArray;
        if (nArray != null) {
            this.dfCoefMaps = nArray;
        }
        this.slaters = (SlaterData[])object;
        this.moCoefficients = fArray2;
        this.linearCombination = fArray3;
        this.isSquaredLinear = bl;
        this.coefs = fArray4;
        this.doNormalize = bl2;
        Logger.info("Normalizing AOs: " + bl2 + " slaters:" + (object != null));
        this.countsXYZ = volumeDataInterface.getVoxelCounts();
        this.initialize(this.countsXYZ[0], this.countsXYZ[1], this.countsXYZ[2], p3Array2);
        this.voxelData = volumeDataInterface.getVoxelData();
        this.voxelDataTemp = bl ? new float[this.nX][this.nY][this.nZ] : this.voxelData;
        this.setupCoordinates(volumeDataInterface.getOriginFloat(), volumeDataInterface.getVolumetricVectorLengths(), bS, p3Array, p3Array2, false);
        this.doDebug = Logger.debugging;
        return object != null || this.checkCalculationType();
    }

    @Override
    protected void initialize(int n, int n2, int n3, P3[] p3Array) {
        this.initialize0(n, n2, n3, p3Array);
        this.CX = new double[this.nX];
        this.CY = new double[this.nY];
        this.CZ = new double[this.nZ];
        this.DXY = new double[this.nX];
        this.DXZ = new double[this.nX];
        this.DYZ = new double[this.nY];
        this.EX = new double[this.nX];
        this.EY = new double[this.nY];
        this.EZ = new double[this.nZ];
    }

    @Override
    public void createCube() {
        this.setXYZBohr(this.points);
        this.processPoints();
        if (!this.isSquaredLinear && (this.doDebug || this.testing)) {
            this.calculateElectronDensity();
        }
    }

    @Override
    protected void processPoints() {
        if (this.linearCombination == null) {
            this.process();
        } else {
            int n;
            if (this.sum < 0.0) {
                this.sum = 0.0;
                for (n = 0; n < this.linearCombination.length; n += 2) {
                    this.sum += (double)(this.linearCombination[n] * this.linearCombination[n]);
                }
                this.sum = Math.sqrt(this.sum);
            }
            if (this.sum == 0.0) {
                return;
            }
            for (n = 0; n < this.linearCombination.length; n += 2) {
                this.moFactor = (double)this.linearCombination[n] / this.sum;
                if (this.moFactor == 0.0) continue;
                this.moCoefficients = this.coefs[(int)this.linearCombination[n + 1] - 1];
                this.process();
                if (!this.isSquaredLinear) continue;
                this.addValuesSquared(1.0f);
            }
        }
    }

    @Override
    protected void process() {
        this.atomIndex = this.firstAtomOffset - 1;
        this.moCoeff = 0;
        if (this.slaters == null) {
            int n;
            int n2 = this.shells.size();
            if (this.c < 0.0) {
                this.c = 0.0;
                for (n = 0; n < n2; ++n) {
                    this.c += this.normalizeShell(n);
                }
                this.c = Math.sqrt(this.c);
                this.atomIndex = this.firstAtomOffset - 1;
                this.moCoeff = 0;
            }
            for (n = 0; n < n2; ++n) {
                this.processShell(n);
            }
            return;
        }
        for (int i = 0; i < this.slaters.length && this.processSlater(i); ++i) {
        }
    }

    private boolean checkCalculationType() {
        if (this.calculationType == null) {
            Logger.warn("calculation type not identified -- continuing");
            return true;
        }
        boolean bl = this.nwChemMode = this.calculationType.indexOf("NWCHEM") >= 0;
        if (this.nwChemMode) {
            Logger.info("Normalization of contractions (NWCHEM)");
        }
        if (this.calculationType.indexOf("+") >= 0 || this.calculationType.indexOf("*") >= 0) {
            Logger.warn("polarization/diffuse wavefunctions have not been tested fully: " + this.calculationType + " -- continuing");
        }
        if (this.calculationType.indexOf("?") >= 0) {
            Logger.warn("unknown calculation type may not render correctly -- continuing");
        } else if (this.points == null) {
            Logger.info("calculation type: " + this.calculationType + " OK.");
        }
        return true;
    }

    private double normalizeShell(int n) {
        double d = 0.0;
        int[] nArray = (int[])this.shells.get(n);
        this.basisType = EnumQuantumShell.getItem(nArray[1]);
        this.gaussianPtr = nArray[2];
        this.nGaussians = nArray[3];
        this.doShowShellType = this.doDebug;
        if (!this.setCoeffs(false)) {
            return 0.0;
        }
        int n2 = this.map.length;
        while (--n2 >= 0) {
            d += this.coeffs[n2] * this.coeffs[n2];
        }
        return d;
    }

    private void processShell(int n) {
        int n2 = this.atomIndex;
        int[] nArray = (int[])this.shells.get(n);
        this.atomIndex = nArray[0] + this.firstAtomOffset;
        this.basisType = EnumQuantumShell.getItem(nArray[1]);
        this.gaussianPtr = nArray[2];
        this.nGaussians = nArray[3];
        this.doShowShellType = this.doDebug;
        if (this.atomIndex != n2 && (this.thisAtom = this.qmAtoms[this.atomIndex]) != null) {
            this.thisAtom.setXYZ(this, true);
        }
        if (!this.setCoeffs(true)) {
            return;
        }
        if (this.havePoints) {
            this.setMinMax(-1);
        }
        switch (this.basisType) {
            case S: {
                this.addDataS();
                break;
            }
            case P: {
                this.addDataP();
                break;
            }
            case SP: {
                this.addDataSP();
                break;
            }
            case D_SPHERICAL: {
                this.addData5D();
                break;
            }
            case D_CARTESIAN: {
                this.addData6D();
                break;
            }
            case F_SPHERICAL: {
                this.addData7F();
                break;
            }
            case F_CARTESIAN: {
                this.addData10F();
                break;
            }
            default: {
                Logger.warn(" Unsupported basis type for atomno=" + (this.atomIndex + 1) + ": " + this.basisType.tag);
            }
        }
    }

    private void addValuesSquared(float f) {
        int n = this.nX;
        while (--n >= 0) {
            int n2 = this.nY;
            while (--n2 >= 0) {
                int n3 = this.nZ;
                while (--n3 >= 0) {
                    float f2 = this.voxelDataTemp[n][n2][n3];
                    if (f2 == 0.0f) continue;
                    float[] fArray = this.voxelData[n][n2];
                    int n4 = n3;
                    fArray[n4] = fArray[n4] + f2 * f2 * f;
                    this.voxelDataTemp[n][n2][n3] = 0.0f;
                }
            }
        }
    }

    private double getContractionNormalization(int n, int n2) {
        double d;
        double d2 = n == 3 ? 15 : (n == 2 ? 3 : 1);
        double d3 = d2 * Math.pow(Math.PI, 1.5) / Math.pow(2.0, n);
        double d4 = 0.75 + (double)n / 2.0;
        if (this.nGaussians == 1) {
            d = Math.pow(2.0, -2.0 * d4) * Math.pow(this.gaussians[this.gaussianPtr][n2], 2.0);
        } else {
            d = 0.0;
            for (int i = 0; i < this.nGaussians; ++i) {
                double d5 = this.gaussians[this.gaussianPtr + i][0];
                double d6 = this.gaussians[this.gaussianPtr + i][n2];
                double d7 = Math.pow(d5, d4);
                for (int j = 0; j < this.nGaussians; ++j) {
                    double d8 = this.gaussians[this.gaussianPtr + j][0];
                    double d9 = this.gaussians[this.gaussianPtr + j][n2];
                    double d10 = Math.pow(d8, d4);
                    d += d6 * d7 * d9 * d10 / Math.pow(d5 + d8, 2.0 * d4);
                }
            }
        }
        d = 1.0 / Math.sqrt(d3 * d);
        if (Logger.debugging) {
            Logger.debug("\t\t\tnormalization for l=" + n + " nGaussians=" + this.nGaussians + " is " + d);
        }
        return d;
    }

    private boolean setCoeffs(boolean bl) {
        boolean bl2 = false;
        int n = this.basisType.id;
        this.map = this.dfCoefMaps[n];
        if (bl && this.thisAtom == null) {
            this.moCoeff += this.map.length;
            return false;
        }
        for (int i = 0; i < this.map.length; ++i) {
            bl2 |= (this.coeffs[i] = (double)this.moCoefficients[this.map[i] + this.moCoeff++]) != 0.0;
        }
        if ((bl2 &= this.coeffs[0] != -2.147483648E9) && this.doDebug && bl) {
            this.dumpInfo(n);
        }
        return bl2;
    }

    private void addDataS() {
        double d = this.doNormalize ? (this.nwChemMode ? this.getContractionNormalization(0, 1) : 0.7127054929733276) : 1.0;
        double d2 = this.coeffs[0];
        for (int i = 0; i < this.nGaussians; ++i) {
            double d3 = this.gaussians[this.gaussianPtr + i][0];
            double d4 = this.gaussians[this.gaussianPtr + i][1];
            double d5 = d * d2 * d4 * this.moFactor;
            if (this.doNormalize) {
                d5 *= Math.pow(d3, 0.75);
            }
            int n = this.xMax;
            while (--n >= this.xMin) {
                this.EX[n] = d5 * Math.exp((double)(-this.X2[n]) * d3);
            }
            n = this.yMax;
            while (--n >= this.yMin) {
                this.EY[n] = Math.exp((double)(-this.Y2[n]) * d3);
            }
            n = this.zMax;
            while (--n >= this.zMin) {
                this.EZ[n] = Math.exp((double)(-this.Z2[n]) * d3);
            }
            n = this.xMax;
            while (--n >= this.xMin) {
                double d6 = this.EX[n];
                if (this.havePoints) {
                    this.setMinMax(n);
                }
                int n2 = this.yMax;
                while (--n2 >= this.yMin) {
                    double d7 = d6 * this.EY[n2];
                    this.vd = this.voxelDataTemp[n][this.havePoints ? 0 : n2];
                    int n3 = this.zMax;
                    while (--n3 >= this.zMin) {
                        int n4 = this.havePoints ? 0 : n3;
                        this.vd[n4] = (float)((double)this.vd[n4] + d7 * this.EZ[n3]);
                    }
                }
            }
        }
    }

    private void addDataP() {
        double d = this.coeffs[0];
        double d2 = this.coeffs[1];
        double d3 = this.coeffs[2];
        double d4 = this.doNormalize ? (this.nwChemMode ? this.getContractionNormalization(1, 1) : (double)1.425411f) : 1.0;
        for (int i = 0; i < this.nGaussians; ++i) {
            double d5;
            double d6 = this.gaussians[this.gaussianPtr + i][0];
            double d7 = d5 = (double)this.gaussians[this.gaussianPtr + i][1];
            if (this.doNormalize) {
                d7 *= Math.pow(d6, 1.25) * d4;
            }
            this.calcSP(d6, 0.0, d7 * d, d7 * d2, d7 * d3);
        }
    }

    private void addDataSP() {
        double d;
        double d2;
        boolean bl = this.map.length == 3;
        int n = bl ? 0 : 1;
        double d3 = bl ? 0.0 : this.coeffs[0];
        double d4 = this.coeffs[n++];
        double d5 = this.coeffs[n++];
        double d6 = this.coeffs[n++];
        if (this.doNormalize) {
            if (this.nwChemMode) {
                d2 = this.getContractionNormalization(0, 1);
                d = this.getContractionNormalization(1, 2);
            } else {
                d2 = 0.7127054929733276;
                d = 1.425411f;
            }
        } else {
            d = 1.0;
            d2 = 1.0;
        }
        for (int i = 0; i < this.nGaussians; ++i) {
            double d7 = this.gaussians[this.gaussianPtr + i][0];
            double d8 = this.gaussians[this.gaussianPtr + i][1];
            double d9 = this.gaussians[this.gaussianPtr + i][2];
            double d10 = d8;
            double d11 = d9;
            if (this.doNormalize) {
                d10 *= Math.pow(d7, 0.75) * d2;
                d11 *= Math.pow(d7, 1.25) * d;
            }
            this.calcSP(d7, d10 * d3, d11 * d4, d11 * d5, d11 * d6);
        }
    }

    private void setCE(double d, double d2, double d3, double d4, double d5) {
        int n = this.xMax;
        while (--n >= this.xMin) {
            this.CX[n] = d2 + d3 * (double)this.X[n];
            this.EX[n] = Math.exp((double)(-this.X2[n]) * d) * this.moFactor;
        }
        n = this.yMax;
        while (--n >= this.yMin) {
            this.CY[n] = d4 * (double)this.Y[n];
            this.EY[n] = Math.exp((double)(-this.Y2[n]) * d);
        }
        n = this.zMax;
        while (--n >= this.zMin) {
            this.CZ[n] = d5 * (double)this.Z[n];
            this.EZ[n] = Math.exp((double)(-this.Z2[n]) * d);
        }
    }

    private void setE(double[] dArray, double d) {
        int n = this.xMax;
        while (--n >= this.xMin) {
            dArray[n] = Math.exp((double)(-this.X2[n]) * d) * this.moFactor;
        }
        n = this.yMax;
        while (--n >= this.yMin) {
            this.EY[n] = Math.exp((double)(-this.Y2[n]) * d);
        }
        n = this.zMax;
        while (--n >= this.zMin) {
            this.EZ[n] = Math.exp((double)(-this.Z2[n]) * d);
        }
    }

    private void calcSP(double d, double d2, double d3, double d4, double d5) {
        this.setCE(d, d2, d3, d4, d5);
        int n = this.xMax;
        while (--n >= this.xMin) {
            double d6 = this.EX[n];
            double d7 = this.CX[n];
            if (this.havePoints) {
                this.setMinMax(n);
            }
            int n2 = this.yMax;
            while (--n2 >= this.yMin) {
                double d8 = d6 * this.EY[n2];
                double d9 = d7 + this.CY[n2];
                this.vd = this.voxelDataTemp[n][this.havePoints ? 0 : n2];
                int n3 = this.zMax;
                while (--n3 >= this.zMin) {
                    int n4 = this.havePoints ? 0 : n3;
                    this.vd[n4] = (float)((double)this.vd[n4] + (d9 + this.CZ[n3]) * d8 * this.EZ[n3]);
                }
            }
        }
    }

    private void addData6D() {
        double d;
        double d2;
        double d3 = this.coeffs[0];
        double d4 = this.coeffs[1];
        double d5 = this.coeffs[2];
        double d6 = this.coeffs[3];
        double d7 = this.coeffs[4];
        double d8 = this.coeffs[5];
        if (this.doNormalize) {
            if (this.nwChemMode) {
                d = d2 = this.getContractionNormalization(2, 1);
            } else {
                d2 = 2.850822f;
                d = d2 / 1.7320507764816284;
            }
        } else {
            d = 0.5773502795520422;
            d2 = 1.0;
        }
        for (int i = 0; i < this.nGaussians; ++i) {
            double d9;
            double d10 = this.gaussians[this.gaussianPtr + i][0];
            double d11 = d9 = (double)this.gaussians[this.gaussianPtr + i][1];
            if (this.doNormalize) {
                d11 *= Math.pow(d10, 1.75);
            }
            double d12 = d11 * d2 * d6;
            double d13 = d11 * d2 * d7;
            double d14 = d11 * d2 * d8;
            double d15 = d11 * d * d3;
            double d16 = d11 * d * d4;
            double d17 = d11 * d * d5;
            this.setCE(d10, 0.0, d15, d16, d17);
            int n = this.xMax;
            while (--n >= this.xMin) {
                this.DXY[n] = d12 * (double)this.X[n];
                this.DXZ[n] = d13 * (double)this.X[n];
            }
            n = this.yMax;
            while (--n >= this.yMin) {
                this.DYZ[n] = d14 * (double)this.Y[n];
            }
            n = this.xMax;
            while (--n >= this.xMin) {
                double d18 = this.CX[n] * (double)this.X[n];
                double d19 = this.DXY[n];
                double d20 = this.DXZ[n];
                double d21 = this.EX[n];
                if (this.havePoints) {
                    this.setMinMax(n);
                }
                int n2 = this.yMax;
                while (--n2 >= this.yMin) {
                    double d22 = d18 + (this.CY[n2] + d19) * (double)this.Y[n2];
                    double d23 = d20 + this.DYZ[n2];
                    double d24 = d21 * this.EY[n2];
                    this.vd = this.voxelDataTemp[n][this.havePoints ? 0 : n2];
                    int n3 = this.zMax;
                    while (--n3 >= this.zMin) {
                        int n4 = this.havePoints ? 0 : n3;
                        this.vd[n4] = (float)((double)this.vd[n4] + (d22 + (this.CZ[n3] + d23) * (double)this.Z[n3]) * d24 * this.EZ[n3]);
                    }
                }
            }
        }
    }

    private void addData5D() {
        double d;
        double d2;
        double d3;
        double d4;
        if (this.doNormalize) {
            if (this.nwChemMode) {
                d4 = this.getContractionNormalization(2, 1);
                d3 = d4 * 1.7320507764816284;
                d2 = -1.0;
            } else {
                d3 = Math.pow(66.05114251919257, 0.25);
                d4 = d3 / 1.7320507764816284;
                d2 = 1.0;
            }
            d = 0.8660253882408142;
        } else {
            d2 = 1.0;
            d = 1.0;
            d4 = 1.0;
            d3 = 1.0;
        }
        double d5 = this.coeffs[0];
        double d6 = this.coeffs[1];
        double d7 = this.coeffs[2];
        double d8 = this.coeffs[3];
        double d9 = this.coeffs[4];
        for (int i = 0; i < this.nGaussians; ++i) {
            double d10;
            double d11 = this.gaussians[this.gaussianPtr + i][0];
            double d12 = d10 = (double)this.gaussians[this.gaussianPtr + i][1];
            if (this.doNormalize) {
                d12 *= Math.pow(d11, 1.75);
            }
            double d13 = d12 * d5;
            double d14 = d2 * d12 * d6;
            double d15 = d12 * d7;
            double d16 = d12 * d8;
            double d17 = d12 * d9;
            this.setE(this.EX, d11);
            int n = this.xMax;
            while (--n >= this.xMin) {
                double d18 = this.X[n];
                double d19 = this.EX[n];
                double d20 = d4 * d18 * d18;
                if (this.havePoints) {
                    this.setMinMax(n);
                }
                int n2 = this.yMax;
                while (--n2 >= this.yMin) {
                    double d21 = this.Y[n2];
                    double d22 = d19 * this.EY[n2];
                    double d23 = d4 * d21 * d21;
                    double d24 = d3 * d18 * d21;
                    this.vd = this.voxelDataTemp[n][this.havePoints ? 0 : n2];
                    int n3 = this.zMax;
                    while (--n3 >= this.zMin) {
                        double d25 = this.Z[n3];
                        double d26 = d4 * d25 * d25;
                        double d27 = d3 * d18 * d25;
                        double d28 = d3 * d21 * d25;
                        int n4 = this.havePoints ? 0 : n3;
                        this.vd[n4] = (float)((double)this.vd[n4] + (d13 * (d26 - 0.5 * (d20 + d23)) + d14 * d27 + d15 * d28 + d16 * d * (d20 - d23) + d17 * d24) * d22 * this.EZ[n3]);
                    }
                }
            }
        }
    }

    private void addData10F() {
        double d;
        double d2;
        double d3;
        if (this.doNormalize) {
            if (this.nwChemMode) {
                d2 = d3 = this.getContractionNormalization(3, 1);
                d = d3;
            } else {
                d3 = Math.pow(1056.818280307081, 0.25);
                d2 = d3 / Math.sqrt(3.0);
                d = d3 / Math.sqrt(15.0);
            }
        } else {
            d = 1.0;
            d2 = 1.0;
            d3 = 1.0;
        }
        double d4 = this.coeffs[0];
        double d5 = this.coeffs[1];
        double d6 = this.coeffs[2];
        double d7 = this.coeffs[3];
        double d8 = this.coeffs[4];
        double d9 = this.coeffs[5];
        double d10 = this.coeffs[6];
        double d11 = this.coeffs[7];
        double d12 = this.coeffs[8];
        double d13 = this.coeffs[9];
        for (int i = 0; i < this.nGaussians; ++i) {
            double d14 = this.gaussians[this.gaussianPtr + i][0];
            double d15 = this.gaussians[this.gaussianPtr + i][1];
            this.setE(this.EX, d14);
            double d16 = d15;
            if (this.doNormalize) {
                d16 *= Math.pow(d14, 2.25);
            }
            double d17 = d16 * d * d4;
            double d18 = d16 * d * d5;
            double d19 = d16 * d * d6;
            double d20 = d16 * d2 * d7;
            double d21 = d16 * d2 * d8;
            double d22 = d16 * d2 * d9;
            double d23 = d16 * d2 * d10;
            double d24 = d16 * d2 * d11;
            double d25 = d16 * d2 * d12;
            double d26 = d16 * d3 * d13;
            int n = this.xMax;
            while (--n >= this.xMin) {
                double d27 = this.X[n];
                double d28 = d27 * d27;
                double d29 = this.EX[n];
                double d30 = d17 * d28 * d27;
                if (this.havePoints) {
                    this.setMinMax(n);
                }
                int n2 = this.yMax;
                while (--n2 >= this.yMin) {
                    double d31 = this.Y[n2];
                    double d32 = d31 * d31;
                    double d33 = d29 * this.EY[n2];
                    double d34 = d18 * d32 * d31;
                    double d35 = d21 * d28 * d31;
                    double d36 = d20 * d27 * d32;
                    this.vd = this.voxelDataTemp[n][this.havePoints ? 0 : n2];
                    int n3 = this.zMax;
                    while (--n3 >= this.zMin) {
                        double d37 = this.Z[n3];
                        double d38 = d37 * d37;
                        double d39 = d19 * d38 * d37;
                        double d40 = d22 * d28 * d37;
                        double d41 = d23 * d27 * d38;
                        double d42 = d25 * d32 * d37;
                        double d43 = d24 * d31 * d38;
                        double d44 = d26 * d27 * d31 * d37;
                        int n4 = this.havePoints ? 0 : n3;
                        this.vd[n4] = (float)((double)this.vd[n4] + (d30 + d34 + d39 + d36 + d35 + d40 + d41 + d43 + d42 + d44) * d33 * this.EZ[n3]);
                    }
                }
            }
        }
    }

    private void addData7F() {
        double d;
        double d2;
        double d3;
        double d4;
        if (this.doNormalize) {
            if (this.nwChemMode) {
                d4 = this.getContractionNormalization(3, 1);
                d3 = d4 * Math.sqrt(5.0);
                d2 = d4 * Math.sqrt(15.0);
                d = -1.0;
            } else {
                d2 = Math.pow(1056.818280307081, 0.25);
                d3 = d2 / Math.sqrt(3.0);
                d4 = d2 / Math.sqrt(15.0);
                d = 1.0;
            }
        } else {
            d = 1.0;
            d4 = 1.0;
            d3 = 1.0;
            d2 = 1.0;
        }
        double d5 = 3.0 / (2.0 * Math.sqrt(5.0));
        double d6 = Math.sqrt(1.2);
        double d7 = Math.sqrt(0.375);
        double d8 = Math.sqrt(0.075);
        double d9 = d6;
        double d10 = d7;
        double d11 = d8;
        double d12 = Math.sqrt(0.75);
        double d13 = Math.sqrt(0.625);
        double d14 = 0.75 * Math.sqrt(2.0);
        double d15 = d13;
        double d16 = d14;
        double d17 = this.coeffs[0];
        double d18 = this.coeffs[1];
        double d19 = this.coeffs[2];
        double d20 = this.coeffs[3];
        double d21 = this.coeffs[4];
        double d22 = this.coeffs[5];
        double d23 = this.coeffs[6];
        for (int i = 0; i < this.nGaussians; ++i) {
            double d24;
            double d25 = this.gaussians[this.gaussianPtr + i][0];
            double d26 = d24 = (double)this.gaussians[this.gaussianPtr + i][1];
            if (this.doNormalize) {
                d26 *= Math.pow(d25, 2.25);
            }
            double d27 = d26 * d17;
            double d28 = d26 * d18;
            double d29 = d26 * d19;
            double d30 = d26 * d20;
            double d31 = d26 * d21;
            double d32 = d26 * d22;
            double d33 = d26 * d23;
            this.setE(this.EX, d25);
            int n = this.xMax;
            while (--n >= this.xMin) {
                double d34 = this.X[n];
                double d35 = d34 * d34;
                double d36 = this.EX[n];
                double d37 = d4 * d34 * d35;
                if (this.havePoints) {
                    this.setMinMax(n);
                }
                int n2 = this.yMax;
                while (--n2 >= this.yMin) {
                    double d38 = this.Y[n2];
                    double d39 = d38 * d38;
                    double d40 = d36 * this.EY[n2];
                    double d41 = d4 * d38 * d39;
                    double d42 = d3 * d34 * d39;
                    double d43 = d3 * d35 * d38;
                    this.vd = this.voxelDataTemp[n][this.havePoints ? 0 : n2];
                    int n3 = this.zMax;
                    while (--n3 >= this.zMin) {
                        double d44 = this.Z[n3];
                        double d45 = d44 * d44;
                        double d46 = d4 * d44 * d45;
                        double d47 = d3 * d35 * d44;
                        double d48 = d3 * d34 * d45;
                        double d49 = d3 * d39 * d44;
                        double d50 = d3 * d38 * d45;
                        double d51 = d2 * d34 * d38 * d44;
                        double d52 = d27 * (d46 - d5 * (d47 + d49));
                        double d53 = d * d28 * (d6 * d48 - d7 * d37 - d8 * d42);
                        double d54 = d29 * (d9 * d50 - d10 * d41 - d11 * d43);
                        double d55 = d30 * (d12 * (d47 - d49));
                        double d56 = d31 * d51;
                        double d57 = d * d32 * (d13 * d37 - d14 * d42);
                        double d58 = -d33 * (d15 * d41 - d16 * d43);
                        int n4 = this.havePoints ? 0 : n3;
                        this.vd[n4] = (float)((double)this.vd[n4] + (d52 + d53 + d54 + d55 + d56 + d57 + d58) * d40 * this.EZ[n3]);
                    }
                }
            }
        }
    }

    private boolean processSlater(int n) {
        double d;
        int n2 = this.atomIndex;
        SlaterData slaterData = this.slaters[n];
        this.atomIndex = slaterData.iAtom;
        double d2 = -slaterData.zeta;
        this.thisAtom = this.qmAtoms[this.atomIndex];
        if (this.thisAtom == null) {
            if (d2 <= 0.0) {
                ++this.moCoeff;
            }
            return true;
        }
        if (d2 > 0.0) {
            d2 = -d2;
            --this.moCoeff;
        }
        if (this.moCoeff >= this.moCoefficients.length) {
            return false;
        }
        if ((d = slaterData.coef * (double)this.moCoefficients[this.moCoeff++]) == 0.0) {
            this.atomIndex = -1;
            return true;
        }
        d *= this.moFactor;
        if (this.atomIndex != n2) {
            this.thisAtom.setXYZ(this, true);
        }
        int n3 = slaterData.x;
        int n4 = slaterData.y;
        int n5 = slaterData.z;
        int n6 = slaterData.r;
        if (n3 == -2) {
            int n7 = this.xMax;
            while (--n7 >= this.xMin) {
                double d3 = this.X2[n7];
                if (this.havePoints) {
                    this.setMinMax(n7);
                }
                int n8 = this.yMax;
                while (--n8 >= this.yMin) {
                    double d4 = this.Y2[n8];
                    double d5 = d3 + d4;
                    this.vd = this.voxelDataTemp[n7][this.havePoints ? 0 : n8];
                    int n9 = this.zMax;
                    while (--n9 >= this.zMin) {
                        double d6 = this.Z2[n9];
                        double d7 = d5 + d6;
                        double d8 = Math.sqrt(d7);
                        double d9 = d2 * d8;
                        if (d9 < -50.0) continue;
                        double d10 = d * Math.exp(d9) * (3.0 * d6 - d7);
                        switch (n6) {
                            case 3: {
                                d10 *= d8;
                            }
                            case 2: {
                                d10 *= d7;
                                break;
                            }
                            case 1: {
                                d10 *= d8;
                            }
                        }
                        int n10 = this.havePoints ? 0 : n9;
                        this.vd[n10] = (float)((double)this.vd[n10] + d10);
                    }
                }
            }
        } else if (n4 == -2) {
            int n11 = this.xMax;
            while (--n11 >= this.xMin) {
                double d11 = this.X2[n11];
                if (this.havePoints) {
                    this.setMinMax(n11);
                }
                int n12 = this.yMax;
                while (--n12 >= this.yMin) {
                    double d12 = this.Y2[n12];
                    double d13 = d11 + d12;
                    double d14 = d * (d11 - d12);
                    this.vd = this.voxelDataTemp[n11][this.havePoints ? 0 : n12];
                    int n13 = this.zMax;
                    while (--n13 >= this.zMin) {
                        double d15 = this.Z2[n13];
                        double d16 = d13 + d15;
                        double d17 = Math.sqrt(d16);
                        double d18 = d2 * d17;
                        if (d18 < -50.0) continue;
                        double d19 = d14 * Math.exp(d18);
                        switch (n6) {
                            case 3: {
                                d19 *= d17;
                            }
                            case 2: {
                                d19 *= d16;
                                break;
                            }
                            case 1: {
                                d19 *= d17;
                            }
                        }
                        int n14 = this.havePoints ? 0 : n13;
                        this.vd[n14] = (float)((double)this.vd[n14] + d19);
                    }
                }
            }
        } else {
            int n15 = this.xMax;
            while (--n15 >= this.xMin) {
                double d20 = this.X2[n15];
                double d21 = d;
                switch (n3) {
                    case 3: {
                        d21 *= (double)this.X[n15];
                    }
                    case 2: {
                        d21 *= d20;
                        break;
                    }
                    case 1: {
                        d21 *= (double)this.X[n15];
                    }
                }
                if (this.havePoints) {
                    this.setMinMax(n15);
                }
                int n16 = this.yMax;
                while (--n16 >= this.yMin) {
                    double d22 = this.Y2[n16];
                    double d23 = d20 + d22;
                    double d24 = d21;
                    switch (n4) {
                        case 3: {
                            d24 *= (double)this.Y[n16];
                        }
                        case 2: {
                            d24 *= d22;
                            break;
                        }
                        case 1: {
                            d24 *= (double)this.Y[n16];
                        }
                    }
                    this.vd = this.voxelDataTemp[n15][this.havePoints ? 0 : n16];
                    int n17 = this.zMax;
                    while (--n17 >= this.zMin) {
                        double d25 = this.Z2[n17];
                        double d26 = d23 + d25;
                        double d27 = Math.sqrt(d26);
                        double d28 = d2 * d27;
                        if (d28 < -50.0) continue;
                        double d29 = d24 * Math.exp(d28);
                        switch (n5) {
                            case 3: {
                                d29 *= (double)this.Z[n17];
                            }
                            case 2: {
                                d29 *= d25;
                                break;
                            }
                            case 1: {
                                d29 *= (double)this.Z[n17];
                            }
                        }
                        switch (n6) {
                            case 3: {
                                d29 *= d27;
                            }
                            case 2: {
                                d29 *= d26;
                                break;
                            }
                            case 1: {
                                d29 *= d27;
                            }
                        }
                        int n18 = this.havePoints ? 0 : n17;
                        this.vd[n18] = (float)((double)this.vd[n18] + d29);
                    }
                }
            }
        }
        return true;
    }

    private void dumpInfo(int n) {
        if (this.doShowShellType) {
            Logger.debug("\n\t\t\tprocessShell: " + n + " type=" + EnumQuantumShell.getQuantumShellTag(n) + " nGaussians=" + this.nGaussians + " atom=" + this.atomIndex);
            this.doShowShellType = false;
        }
        if (Logger.isActiveLevel(6)) {
            for (int i = 0; i < this.nGaussians; ++i) {
                double d = this.gaussians[this.gaussianPtr + i][0];
                double d2 = this.gaussians[this.gaussianPtr + i][1];
                Logger.debug("\t\t\tGaussian " + (i + 1) + " alpha=" + d + " c=" + d2);
            }
        }
        String[] stringArray = MOCalculation.getShellOrder(n);
        for (int i = 0; i < this.map.length; ++i) {
            double d = this.coeffs[i];
            Logger.debug("MO coeff " + (stringArray == null ? "?" : stringArray[i]) + " " + (this.map[i] + this.moCoeff - this.map.length + i + 1) + "\t" + d + "\t" + this.thisAtom.atom);
        }
    }

    private static final String[] getShellOrder(int n) {
        return n < 0 || n >= shellOrder.length ? null : shellOrder[n];
    }

    public void calculateElectronDensity() {
        if (this.points != null) {
            return;
        }
        int n = this.nX;
        while (--n >= 0) {
            int n2 = this.nY;
            while (--n2 >= 0) {
                int n3 = this.nZ;
                while (--n3 >= 0) {
                    float f = this.voxelData[n][n2][n3];
                    this.integration += f * f;
                }
            }
        }
        float f = this.stepBohr[0] * this.stepBohr[1] * this.stepBohr[2];
        this.integration *= f;
        Logger.info("Integrated density = " + this.integration);
    }
}

