/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.popup;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javajs.util.SB;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.jmol.popup.GenericPopup;
import org.jmol.util.Logger;

public abstract class SwingPopup
extends GenericPopup {
    private MenuItemListener mil;
    private CheckboxMenuItemListener cmil;
    private MenuMouseListener mfl;

    public void finalize() {
        System.out.println("SwingPopup Finalize " + this);
    }

    private void updateButton(AbstractButton abstractButton, String string, String string2) {
        String[] stringArray = new String[]{string};
        ImageIcon imageIcon = (ImageIcon)this.getEntryIcon(stringArray);
        string = stringArray[0];
        if (imageIcon != null) {
            abstractButton.setIcon(imageIcon);
        }
        if (string != null) {
            abstractButton.setText(string);
        }
        if (string2 != null) {
            abstractButton.setActionCommand(string2);
        }
    }

    @Override
    public void updateSpecialMenuItem(Object object) {
        AbstractButton abstractButton = (AbstractButton)object;
        abstractButton.setText(this.getSpecialLabel(abstractButton.getName(), abstractButton.getText()));
    }

    private Object newMenuItem(JMenuItem jMenuItem, Object object, String string, String string2, String string3) {
        this.updateButton(jMenuItem, string, string2);
        if (string3 != null && string3.startsWith("Focus")) {
            jMenuItem.addMouseListener(this.mfl);
            string3 = ((Component)object).getName() + "." + string3;
        }
        jMenuItem.setName(string3 == null ? ((Component)object).getName() + "." : string3);
        this.menuAddItem(object, jMenuItem);
        return jMenuItem;
    }

    @Override
    public void menuAddButtonGroup(Object object) {
        if (this.buttonGroup == null) {
            this.buttonGroup = new ButtonGroup();
        }
        ((ButtonGroup)this.buttonGroup).add((JMenuItem)object);
    }

    @Override
    public void menuAddItem(Object object, Object object2) {
        if (object instanceof JPopupMenu) {
            ((JPopupMenu)object).add((JComponent)object2);
        } else if (object instanceof JMenu) {
            ((JMenu)object).add((JComponent)object2);
        } else {
            Logger.warn("cannot add object to menu: " + object);
        }
    }

    @Override
    public void menuAddSeparator(Object object) {
        if (object instanceof JPopupMenu) {
            ((JPopupMenu)object).addSeparator();
        } else {
            ((JMenu)object).addSeparator();
        }
    }

    @Override
    public void menuAddSubMenu(Object object, Object object2) {
        this.menuAddItem(object, object2);
    }

    @Override
    public void menuClearListeners(Object object) {
        if (object == null) {
            return;
        }
        Component[] componentArray = object instanceof JPopupMenu ? ((JPopupMenu)object).getComponents() : ((JMenu)object).getPopupMenu().getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (component instanceof JMenu) {
                this.menuClearListeners(((JMenu)component).getPopupMenu());
                continue;
            }
            try {
                component.removeMouseListener(this.mfl);
                ((AbstractButton)component).removeActionListener(this.mil);
                ((AbstractButton)component).removeItemListener(this.cmil);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public Object menuCreateCheckboxItem(Object object, String string, String string2, String string3, boolean bl, boolean bl2) {
        JMenuItem jMenuItem;
        if (bl2) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
            jMenuItem = jRadioButtonMenuItem;
            jRadioButtonMenuItem.setArmed(bl);
        } else {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
            jMenuItem = jCheckBoxMenuItem;
            jCheckBoxMenuItem.setState(bl);
        }
        jMenuItem.setSelected(bl);
        jMenuItem.addItemListener(this.cmil);
        return this.newMenuItem(jMenuItem, object, string, string2, string3);
    }

    @Override
    public Object menuCreateItem(Object object, String string, String string2, String string3) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(this.mil);
        return this.newMenuItem(jMenuItem, object, string, string2, string3);
    }

    @Override
    public Object menuCreatePopup(String string) {
        return new JPopupMenu(string);
    }

    @Override
    public void menuEnable(Object object, boolean bl) {
        if (object instanceof JMenuItem) {
            this.menuEnableItem(object, bl);
            return;
        }
        try {
            ((JMenu)object).setEnabled(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void menuEnableItem(Object object, boolean bl) {
        try {
            ((JMenuItem)object).setEnabled(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void menuGetAsText(SB sB, int n, Object object, String string) {
        String string2 = string;
        Component[] componentArray = object instanceof JPopupMenu ? ((JPopupMenu)object).getComponents() : ((JMenu)object).getPopupMenu().getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            String string3;
            JMenuItem jMenuItem;
            Component component = componentArray[i];
            if (component instanceof JMenu) {
                jMenuItem = (JMenu)component;
                string2 = jMenuItem.getName();
                string3 = "enabled:" + jMenuItem.isEnabled();
                SwingPopup.addItemText(sB, 'M', n, string2, jMenuItem.getText(), null, string3);
                this.menuGetAsText(sB, n + 1, ((JMenu)component).getPopupMenu(), string2);
                continue;
            }
            if (component instanceof JMenuItem) {
                jMenuItem = (JMenuItem)component;
                string3 = "enabled:" + jMenuItem.isEnabled();
                if (component instanceof JCheckBoxMenuItem) {
                    string3 = string3 + ";checked:" + ((JCheckBoxMenuItem)component).getState();
                }
                String string4 = this.fixScript(jMenuItem.getName(), jMenuItem.getActionCommand());
                SwingPopup.addItemText(sB, 'I', n, jMenuItem.getName(), jMenuItem.getText(), string4, string3);
                continue;
            }
            SwingPopup.addItemText(sB, 'S', n, string2, null, null, null);
        }
    }

    @Override
    public String menuGetId(Object object) {
        return ((Component)object).getName();
    }

    @Override
    public int menuGetItemCount(Object object) {
        return ((JMenu)object).getItemCount();
    }

    @Override
    public Object menuGetParent(Object object) {
        return ((JMenu)object).getParent();
    }

    @Override
    public int menuGetPosition(Object object) {
        Object object2 = this.menuGetParent(object);
        if (object2 instanceof JPopupMenu) {
            int n = ((JPopupMenu)object2).getComponentCount();
            while (--n >= 0) {
                if (((JPopupMenu)object2).getComponent(n) != object) continue;
                return n;
            }
        } else {
            int n = ((JMenu)object2).getItemCount();
            while (--n >= 0) {
                if (((JMenu)object2).getItem(n) != object) continue;
                return n;
            }
        }
        return -1;
    }

    @Override
    public void menuInsertSubMenu(Object object, Object object2, int n) {
        if (object instanceof JPopupMenu) {
            ((JPopupMenu)object).insert((JMenu)object2, n);
        } else {
            ((JMenu)object).insert((JMenu)object2, n);
        }
    }

    @Override
    public Object menuNewSubMenu(String string, String string2) {
        JMenu jMenu = new JMenu(string);
        this.updateButton(jMenu, string, null);
        jMenu.setName(string2);
        jMenu.setAutoscrolls(true);
        return jMenu;
    }

    @Override
    public void menuRemoveAll(Object object, int n) {
        if (n > 0) {
            int n2 = this.menuGetItemCount(object);
            while (--n2 >= n) {
                ((JMenu)object).remove(n2);
            }
            return;
        }
        if (object instanceof JMenu) {
            ((JMenu)object).removeAll();
        } else {
            ((JPopupMenu)object).removeAll();
        }
    }

    @Override
    public void menuSetAutoscrolls(Object object) {
        ((JMenu)object).setAutoscrolls(true);
    }

    @Override
    public void menuSetCheckBoxState(Object object, boolean bl) {
        if (object instanceof JCheckBoxMenuItem) {
            ((JCheckBoxMenuItem)object).setState(bl);
        } else {
            ((JRadioButtonMenuItem)object).setArmed(bl);
        }
        ((JMenuItem)object).setSelected(bl);
    }

    @Override
    public String menuSetCheckBoxOption(Object object, String string, String string2) {
        return null;
    }

    @Override
    public void menuSetCheckBoxValue(Object object) {
        JMenuItem jMenuItem = (JMenuItem)object;
        this.setCheckBoxValue(jMenuItem, jMenuItem.getActionCommand(), jMenuItem.isSelected());
    }

    @Override
    public void menuSetLabel(Object object, String string) {
        if (object instanceof JMenuItem) {
            ((JMenuItem)object).setText(string);
        } else {
            ((JMenu)object).setText(string);
        }
    }

    @Override
    public void menuSetListeners() {
        this.mil = new MenuItemListener();
        this.cmil = new CheckboxMenuItemListener();
        this.mfl = new MenuMouseListener();
    }

    @Override
    public void menuShowPopup(Object object, int n, int n2) {
        try {
            ((JPopupMenu)object).show((Component)this.viewer.getDisplay(), n, n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class CheckboxMenuItemListener
    implements ItemListener {
        protected CheckboxMenuItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            SwingPopup.this.checkBoxStateChanged(itemEvent.getSource());
        }
    }

    private class MenuMouseListener
    implements MouseListener {
        protected MenuMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() instanceof JMenuItem) {
                JMenuItem jMenuItem = (JMenuItem)mouseEvent.getSource();
                SwingPopup.this.checkMenuFocus(jMenuItem.getName(), jMenuItem.getActionCommand(), true);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() instanceof JMenuItem) {
                JMenuItem jMenuItem = (JMenuItem)mouseEvent.getSource();
                SwingPopup.this.checkMenuFocus(jMenuItem.getName(), jMenuItem.getActionCommand(), false);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    private class MenuItemListener
    implements ActionListener {
        protected MenuItemListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SwingPopup.this.checkMenuClick(actionEvent.getSource(), actionEvent.getActionCommand());
        }
    }
}

