/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.util.Logger;

class DelPhiBinaryReader
extends VolumeFileReader {
    private float[] data;
    private int pt;

    DelPhiBinaryReader() {
    }

    @Override
    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        String string = (String)((Object[])surfaceGenerator.getReaderData())[0];
        this.init2VFR(surfaceGenerator, this.br);
        this.binarydoc = this.newBinaryDocument();
        this.binarydoc.setStream(surfaceGenerator.getAtomDataServer().getBufferedInputStream(string), false);
        this.nSurfaces = 1;
        if (this.params.thePlane == null) {
            this.params.insideOut = !this.params.insideOut;
        }
        this.allowSigma = false;
        this.isAngstroms = true;
    }

    @Override
    protected void readParameters() throws Exception {
        int n;
        String string = this.readString();
        Logger.info(string);
        String string2 = this.readString();
        Logger.info(string2);
        this.data = this.readFloatArray();
        Logger.info("DelPhi data length: " + this.data.length);
        String string3 = this.readString();
        Logger.info(string3);
        float[] fArray = this.readFloatArray();
        float f = fArray[0];
        Logger.info("DelPhi scale: " + f);
        float f2 = f == 1.0f ? 0.84375f : 1.0f / f;
        this.volumetricVectors[0] = V3.new3(0.0f, 0.0f, f2);
        this.volumetricVectors[1] = V3.new3(0.0f, f2, 0.0f);
        this.volumetricVectors[2] = V3.new3(f2, 0.0f, 0.0f);
        Logger.info("DelPhi resolution (pts/angstrom) set to: " + f2);
        this.voxelCounts[1] = this.voxelCounts[2] = (n = 65);
        this.voxelCounts[0] = this.voxelCounts[2];
        Logger.info("DelPhi voxel counts: " + n);
        this.volumetricOrigin.set(fArray[1], fArray[2], fArray[3]);
        Logger.info("DelPhi center " + this.volumetricOrigin);
        this.volumetricOrigin.x -= (f2 *= (float)((n - 1) / 2));
        this.volumetricOrigin.y -= f2;
        this.volumetricOrigin.z -= f2;
        this.jvxlFileHeaderBuffer = new SB();
        this.jvxlFileHeaderBuffer.append("DelPhi DATA ").append(string2.replace('\n', ' ').trim()).append("\n\n");
    }

    private String readString() throws Exception {
        int n = this.binarydoc.readInt();
        byte[] byArray = new byte[n];
        this.binarydoc.readByteArray(byArray, 0, n);
        this.binarydoc.readInt();
        return new String(byArray);
    }

    private float[] readFloatArray() throws Exception {
        int n = this.binarydoc.readInt() >> 2;
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = this.binarydoc.readFloat();
        }
        this.binarydoc.readInt();
        return fArray;
    }

    @Override
    protected float nextVoxel() throws Exception {
        this.nBytes += 4L;
        return this.data[this.pt++];
    }

    @Override
    protected void skipData(int n) throws Exception {
        this.pt += n;
    }
}

