/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize;

import java.util.Random;
import org.jmol.util.Tuple3d;
import org.jmol.util.Vector3d;

public class Util {
    public static final double RAD_TO_DEG = 57.29577951308232;
    public static final double DEG_TO_RAD = Math.PI / 180;
    static final double max_squarable_double = 1.0E150;
    static final double min_squarable_double = 1.0E-150;

    public static void sub(double[] dArray, double[] dArray2, Vector3d vector3d) {
        vector3d.set(dArray[0] - dArray2[0], dArray[1] - dArray2[1], dArray[2] - dArray2[2]);
    }

    public static void putCoord(Vector3d vector3d, double[] dArray) {
        dArray[0] = vector3d.x;
        dArray[1] = vector3d.y;
        dArray[2] = vector3d.z;
    }

    public static double distance2(double[] dArray, double[] dArray2) {
        double d = dArray[0] - dArray2[0];
        double d2 = dArray[1] - dArray2[1];
        double d3 = dArray[2] - dArray2[2];
        return d * d + d2 * d2 + d3 * d3;
    }

    public static double distance2V(Vector3d vector3d, Vector3d vector3d2) {
        double d = vector3d.x - vector3d2.x;
        double d2 = vector3d.y - vector3d2.y;
        double d3 = vector3d.z - vector3d2.z;
        return d * d + d2 * d2 + d3 * d3;
    }

    public static double getAngleRadiansABC(double[] dArray, double[] dArray2, double[] dArray3) {
        double d = Util.distance2(dArray, dArray2);
        double d2 = Util.distance2(dArray2, dArray3);
        double d3 = Util.distance2(dArray, dArray3);
        return Util.isNearZero2(d, 0.001) || Util.isNearZero2(d2, 0.001) ? 0.0 : Math.acos((d + d2 - d3) / 2.0 / Math.sqrt(d * d2));
    }

    public static boolean isApprox(Vector3d vector3d, Vector3d vector3d2, double d) {
        return Util.distance2V(vector3d, vector3d2) <= d * d * Math.min(vector3d.lengthSquared(), vector3d2.lengthSquared());
    }

    public static boolean canBeSquared(double d) {
        double d2;
        if (d == 0.0) {
            return true;
        }
        d = Math.abs(d);
        return d2 < 1.0E150 && d > 1.0E-150;
    }

    public static boolean isNegligible(double d, double d2) {
        return Util.isNegligible3(d, d2, 1.0E-11);
    }

    public static boolean isFinite(double d) {
        return !Double.isInfinite(d) && !Double.isNaN(d);
    }

    public static boolean isNegligible3(double d, double d2, double d3) {
        return Math.abs(d) <= d3 * Math.abs(d2);
    }

    public static boolean isNear(double d, double d2) {
        return Util.isNear3(d, d2, 2.0E-6);
    }

    public static boolean isNear3(double d, double d2, double d3) {
        return Math.abs(d - d2) < d3;
    }

    public static boolean isNearZero(double d) {
        return Util.isNearZero2(d, 2.0E-6);
    }

    public static boolean isNearZero2(double d, double d2) {
        return Math.abs(d) < d2;
    }

    public static boolean canBeNormalized(Vector3d vector3d) {
        if (vector3d.x == 0.0 && vector3d.y == 0.0 && vector3d.z == 0.0) {
            return false;
        }
        return Util.canBeSquared(vector3d.x) && Util.canBeSquared(vector3d.y) && Util.canBeSquared(vector3d.z);
    }

    public static double pointPlaneAngleRadians(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, Vector3d vector3d4, Vector3d vector3d5, Vector3d vector3d6, Vector3d vector3d7, boolean bl) {
        vector3d5.sub2((Tuple3d)vector3d2, (Tuple3d)vector3d3);
        vector3d6.sub2((Tuple3d)vector3d2, (Tuple3d)vector3d4);
        vector3d7.cross(vector3d5, vector3d6);
        vector3d6.add((Tuple3d)vector3d5);
        vector3d5.sub2((Tuple3d)vector3d2, (Tuple3d)vector3d);
        double d = bl ? Util.vectorAngleRadians(vector3d6, vector3d5) : Math.PI;
        double d2 = Util.vectorAngleRadians(vector3d7, vector3d5);
        if (d2 > 1.5707963267948966) {
            d2 = Math.PI - d2;
        }
        double d3 = 1.5707963267948966 + (d > 1.5707963267948966 ? -d2 : d2);
        return d3;
    }

    private static double vectorAngleRadians(Vector3d vector3d, Vector3d vector3d2) {
        double d = vector3d.length();
        double d2 = vector3d2.length();
        return Util.isNearZero(d) || Util.isNearZero(d2) ? 0.0 : Math.acos(vector3d.dot(vector3d2) / (d * d2));
    }

    public static double getTorsionAngleRadians(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        Util.sub(dArray2, dArray, vector3d);
        Util.sub(dArray3, dArray2, vector3d2);
        vector3d2.normalize();
        vector3d.cross(vector3d, vector3d2);
        Util.sub(dArray4, dArray3, vector3d3);
        vector3d3.cross(vector3d2, vector3d3);
        double d = vector3d.dot(vector3d3);
        vector3d.cross(vector3d3, vector3d);
        double d2 = Math.atan2(-vector3d2.dot(vector3d), d);
        return d2;
    }

    public static double restorativeForceAndDistance(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        vector3d3.sub2((Tuple3d)vector3d, (Tuple3d)vector3d2);
        double d = vector3d3.length();
        if (d < 0.1) {
            Util.randomizeUnitVector(vector3d3);
            d = 0.1;
        }
        vector3d3.normalize();
        vector3d.setT((Tuple3d)vector3d3);
        vector3d.scale(-1.0);
        vector3d2.setT((Tuple3d)vector3d3);
        return d;
    }

    private static void randomizeUnitVector(Vector3d vector3d) {
        double d;
        Random random = new Random();
        do {
            vector3d.set((double)random.nextFloat() - 0.5, (double)random.nextFloat() - 0.5, (double)random.nextFloat() - 0.5);
        } while ((d = vector3d.lengthSquared()) > 1.0 || d < 1.0E-4);
        vector3d.normalize();
    }

    public static double restorativeForceAndAngleRadians(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        double d;
        vector3d.sub((Tuple3d)vector3d2);
        vector3d3.sub((Tuple3d)vector3d2);
        double d2 = vector3d.length();
        double d3 = vector3d3.length();
        if (Util.isNearZero(d2) || Util.isNearZero(d3)) {
            vector3d.set(0.0, 0.0, 0.0);
            vector3d2.set(0.0, 0.0, 0.0);
            vector3d3.set(0.0, 0.0, 0.0);
            return 0.0;
        }
        double d4 = 1.0 / d2;
        double d5 = 1.0 / d3;
        vector3d.scale(d4);
        vector3d3.scale(d5);
        vector3d2.cross(vector3d, vector3d3);
        double d6 = vector3d2.length();
        if (Util.isNearZero(d6)) {
            vector3d.set(0.0, 0.0, 0.0);
            vector3d2.set(0.0, 0.0, 0.0);
            vector3d3.set(0.0, 0.0, 0.0);
            return 0.0;
        }
        vector3d2.scale(1.0 / d6);
        double d7 = vector3d.dot(vector3d3);
        if (d7 > 1.0) {
            d = 0.0;
            d7 = 1.0;
        } else if (d7 < -1.0) {
            d = Math.PI;
            d7 = -1.0;
        } else {
            d = Math.acos(d7);
        }
        vector3d.cross(vector3d, vector3d2);
        vector3d.normalize();
        vector3d2.cross(vector3d3, vector3d2);
        vector3d2.normalize();
        vector3d.scale(-d4);
        vector3d2.scale(d5);
        vector3d3.setT((Tuple3d)vector3d2);
        vector3d2.add((Tuple3d)vector3d);
        vector3d2.scale(-1.0);
        return d;
    }

    public static double restorativeForceAndOutOfPlaneAngleRadians(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, Vector3d vector3d4, Vector3d vector3d5, Vector3d vector3d6, Vector3d vector3d7) {
        vector3d.sub2((Tuple3d)vector3d, (Tuple3d)vector3d2);
        vector3d3.sub2((Tuple3d)vector3d3, (Tuple3d)vector3d2);
        vector3d4.sub2((Tuple3d)vector3d4, (Tuple3d)vector3d2);
        double d = vector3d.length();
        double d2 = vector3d3.length();
        double d3 = vector3d4.length();
        if (Util.isNearZero(d) || Util.isNearZero(d2) || Util.isNearZero(d3)) {
            vector3d.set(0.0, 0.0, 0.0);
            vector3d2.set(0.0, 0.0, 0.0);
            vector3d3.set(0.0, 0.0, 0.0);
            vector3d4.set(0.0, 0.0, 0.0);
            return 0.0;
        }
        vector3d.normalize();
        vector3d3.normalize();
        vector3d4.normalize();
        double d4 = vector3d.dot(vector3d3);
        double d5 = Math.acos(d4);
        if (Util.isNearZero(d5) || Util.isNearZero(Math.abs(d5 - Math.PI))) {
            vector3d.set(0.0, 0.0, 0.0);
            vector3d2.set(0.0, 0.0, 0.0);
            vector3d3.set(0.0, 0.0, 0.0);
            vector3d4.set(0.0, 0.0, 0.0);
            return 0.0;
        }
        double d6 = 1.0 / Math.sin(d5);
        vector3d5.cross(vector3d, vector3d3);
        vector3d6.cross(vector3d3, vector3d4);
        vector3d7.cross(vector3d4, vector3d);
        double d7 = vector3d5.dot(vector3d4) * d6;
        double d8 = Math.asin(d7);
        double d9 = Math.cos(d8);
        if (d9 < 1.0E-4 || Util.isNearZero(d8) || Util.isNearZero(Math.abs(d8 - Math.PI))) {
            vector3d.set(0.0, 0.0, 0.0);
            vector3d2.set(0.0, 0.0, 0.0);
            vector3d3.set(0.0, 0.0, 0.0);
            vector3d4.set(0.0, 0.0, 0.0);
            return d8;
        }
        vector3d4.scaleAdd(-d7 / d6, (Tuple3d)vector3d4, (Tuple3d)vector3d5);
        vector3d4.scale(d6 / d3);
        vector3d2.setT((Tuple3d)vector3d);
        vector3d.scaleAdd(-d4, (Tuple3d)vector3d3, (Tuple3d)vector3d);
        vector3d.scaleAdd(-d7 * d6, (Tuple3d)vector3d, (Tuple3d)vector3d6);
        vector3d.scale(d6 / d);
        vector3d3.scaleAdd(-d4, (Tuple3d)vector3d2, (Tuple3d)vector3d3);
        vector3d3.scaleAdd(-d7 * d6, (Tuple3d)vector3d3, (Tuple3d)vector3d7);
        vector3d3.scale(d6 / d2);
        vector3d2.setT((Tuple3d)vector3d);
        vector3d2.add((Tuple3d)vector3d3);
        vector3d2.add((Tuple3d)vector3d4);
        vector3d2.scale(-1.0);
        return d8;
    }

    public static double restorativeForceAndTorsionAngleRadians(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, Vector3d vector3d4) {
        vector3d.sub2((Tuple3d)vector3d2, (Tuple3d)vector3d);
        vector3d2.sub2((Tuple3d)vector3d3, (Tuple3d)vector3d2);
        vector3d3.sub2((Tuple3d)vector3d4, (Tuple3d)vector3d3);
        double d = vector3d.length();
        double d2 = vector3d2.length();
        double d3 = vector3d3.length();
        if (Util.isNearZero(d) || Util.isNearZero(d2) || Util.isNearZero(d3)) {
            vector3d.set(0.0, 0.0, 0.0);
            vector3d2.set(0.0, 0.0, 0.0);
            vector3d3.set(0.0, 0.0, 0.0);
            vector3d4.set(0.0, 0.0, 0.0);
            return 0.0;
        }
        double d4 = Util.vectorAngleRadians(vector3d, vector3d2);
        double d5 = Math.sin(d4);
        double d6 = Math.cos(d4);
        d4 = Util.vectorAngleRadians(vector3d2, vector3d3);
        double d7 = Math.sin(d4);
        double d8 = Math.cos(d4);
        vector3d.normalize();
        vector3d2.normalize();
        vector3d3.normalize();
        vector3d.cross(vector3d, vector3d2);
        vector3d4.cross(vector3d2, vector3d3);
        vector3d3.cross(vector3d, vector3d4);
        double d9 = -Math.atan2(vector3d3.dot(vector3d2), vector3d.dot(vector3d4));
        vector3d.scale(1.0 / d / d5 / d5);
        vector3d4.scale(-1.0 / d3 / d7 / d7);
        vector3d2.setT((Tuple3d)vector3d);
        vector3d2.scale(-d / d2 * d6 - 1.0);
        vector3d3.setT((Tuple3d)vector3d4);
        vector3d3.scale(-d3 / d2 * d8);
        vector3d2.sub((Tuple3d)vector3d3);
        vector3d3.setT((Tuple3d)vector3d);
        vector3d3.add((Tuple3d)vector3d2);
        vector3d3.add((Tuple3d)vector3d4);
        vector3d3.scale(-1.0);
        return d9;
    }
}

