/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import org.jmol.util.ArrayUtil;
import org.jmol.util.Matrix4f;
import org.jmol.util.P3;
import org.jmol.util.V3;

public class SimpleUnitCell {
    protected float[] notionalUnitcell;
    protected Matrix4f matrixCartesianToFractional;
    public Matrix4f matrixFractionalToCartesian;
    protected static final float toRadians = (float)Math.PI / 180;
    private int na;
    private int nb;
    private int nc;
    protected float a;
    protected float b;
    protected float c;
    protected float alpha;
    protected float beta;
    protected float gamma;
    protected double cosAlpha;
    protected double sinAlpha;
    protected double cosBeta;
    protected double sinBeta;
    protected double cosGamma;
    protected double sinGamma;
    protected double volume;
    protected double cA_;
    protected double cB_;
    protected double a_;
    protected double b_;
    protected double c_;
    protected int dimension;
    protected Matrix4f matrixCtoFAbsolute;
    protected Matrix4f matrixFtoCAbsolute;
    public static final int INFO_DIMENSIONS = 6;
    public static final int INFO_GAMMA = 5;
    public static final int INFO_BETA = 4;
    public static final int INFO_ALPHA = 3;
    public static final int INFO_C = 2;
    public static final int INFO_B = 1;
    public static final int INFO_A = 0;

    public boolean isSupercell() {
        return this.na > 1 || this.nb > 1 || this.nc > 1;
    }

    public static boolean isValid(float[] fArray) {
        return fArray != null && (fArray[0] > 0.0f || fArray.length > 14 && !Float.isNaN(fArray[14]));
    }

    protected SimpleUnitCell() {
    }

    public static SimpleUnitCell newA(float[] fArray) {
        SimpleUnitCell simpleUnitCell = new SimpleUnitCell();
        simpleUnitCell.set(fArray);
        return simpleUnitCell;
    }

    protected void set(float[] fArray) {
        Object object;
        if (!SimpleUnitCell.isValid(fArray)) {
            return;
        }
        this.notionalUnitcell = ArrayUtil.arrayCopyF(fArray, fArray.length);
        this.a = fArray[0];
        this.b = fArray[1];
        this.c = fArray[2];
        this.alpha = fArray[3];
        this.beta = fArray[4];
        this.gamma = fArray[5];
        this.na = Math.max(1, fArray.length >= 25 && !Float.isNaN(fArray[22]) ? (int)fArray[22] : 1);
        this.nb = Math.max(1, fArray.length >= 25 && !Float.isNaN(fArray[23]) ? (int)fArray[23] : 1);
        this.nc = Math.max(1, fArray.length >= 25 && !Float.isNaN(fArray[24]) ? (int)fArray[24] : 1);
        if (this.a <= 0.0f) {
            V3 v3 = V3.new3(fArray[6], fArray[7], fArray[8]);
            V3 v32 = V3.new3(fArray[9], fArray[10], fArray[11]);
            object = V3.new3(fArray[12], fArray[13], fArray[14]);
            this.a = v3.length();
            this.b = v32.length();
            this.c = ((V3)object).length();
            if (this.a == 0.0f) {
                return;
            }
            if (this.b == 0.0f) {
                this.c = -1.0f;
                this.b = -1.0f;
            } else if (this.c == 0.0f) {
                this.c = -1.0f;
            }
            this.alpha = this.b < 0.0f || this.c < 0.0f ? 90.0f : v32.angle((V3)object) / ((float)Math.PI / 180);
            this.beta = this.c < 0.0f ? 90.0f : v3.angle((V3)object) / ((float)Math.PI / 180);
            float f = this.gamma = this.b < 0.0f ? 90.0f : v3.angle(v32) / ((float)Math.PI / 180);
            if (this.c < 0.0f) {
                float[] fArray2 = ArrayUtil.arrayCopyF(fArray, -1);
                if (this.b < 0.0f) {
                    v32.set(0.0f, 0.0f, 1.0f);
                    v32.cross(v32, v3);
                    if (v32.length() < 0.001f) {
                        v32.set(0.0f, 1.0f, 0.0f);
                    }
                    v32.normalize();
                    fArray2[9] = v32.x;
                    fArray2[10] = v32.y;
                    fArray2[11] = v32.z;
                }
                if (this.c < 0.0f) {
                    ((V3)object).cross(v3, v32);
                    ((V3)object).normalize();
                    fArray2[12] = ((V3)object).x;
                    fArray2[13] = ((V3)object).y;
                    fArray2[14] = ((V3)object).z;
                }
                fArray = fArray2;
            }
        }
        this.a *= (float)this.na;
        if (this.b <= 0.0f) {
            this.c = 1.0f;
            this.b = 1.0f;
            this.dimension = 1;
        } else if (this.c <= 0.0f) {
            this.c = 1.0f;
            this.b *= (float)this.nb;
            this.dimension = 2;
        } else {
            this.b *= (float)this.nb;
            this.c *= (float)this.nc;
            this.dimension = 3;
        }
        this.cosAlpha = Math.cos((float)Math.PI / 180 * this.alpha);
        this.sinAlpha = Math.sin((float)Math.PI / 180 * this.alpha);
        this.cosBeta = Math.cos((float)Math.PI / 180 * this.beta);
        this.sinBeta = Math.sin((float)Math.PI / 180 * this.beta);
        this.cosGamma = Math.cos((float)Math.PI / 180 * this.gamma);
        this.sinGamma = Math.sin((float)Math.PI / 180 * this.gamma);
        double d = Math.sqrt(this.sinAlpha * this.sinAlpha + this.sinBeta * this.sinBeta + this.sinGamma * this.sinGamma + 2.0 * this.cosAlpha * this.cosBeta * this.cosGamma - 2.0);
        this.volume = (double)(this.a * this.b * this.c) * d;
        this.cA_ = (this.cosAlpha - this.cosBeta * this.cosGamma) / this.sinGamma;
        this.cB_ = d / this.sinGamma;
        this.a_ = (double)(this.b * this.c) * this.sinAlpha / this.volume;
        this.b_ = (double)(this.a * this.c) * this.sinBeta / this.volume;
        this.c_ = (double)(this.a * this.b) * this.sinGamma / this.volume;
        if (fArray.length > 21 && !Float.isNaN(fArray[21])) {
            object = new float[16];
            for (int i = 0; i < 16; ++i) {
                float f;
                switch (i % 4) {
                    case 0: {
                        f = this.na;
                        break;
                    }
                    case 1: {
                        f = this.nb;
                        break;
                    }
                    case 2: {
                        f = this.nc;
                        break;
                    }
                    default: {
                        f = 1.0f;
                    }
                }
                object[i] = fArray[6 + i] * f;
            }
            this.matrixCartesianToFractional = Matrix4f.newA((float[])object);
            this.matrixFractionalToCartesian = new Matrix4f();
            this.matrixFractionalToCartesian.invertM(this.matrixCartesianToFractional);
        } else if (fArray.length > 14 && !Float.isNaN(fArray[14])) {
            this.matrixFractionalToCartesian = new Matrix4f();
            object = this.matrixFractionalToCartesian;
            ((Matrix4f)object).setColumn4(0, fArray[6] * (float)this.na, fArray[7] * (float)this.na, fArray[8] * (float)this.na, 0.0f);
            ((Matrix4f)object).setColumn4(1, fArray[9] * (float)this.nb, fArray[10] * (float)this.nb, fArray[11] * (float)this.nb, 0.0f);
            ((Matrix4f)object).setColumn4(2, fArray[12] * (float)this.nc, fArray[13] * (float)this.nc, fArray[14] * (float)this.nc, 0.0f);
            ((Matrix4f)object).setColumn4(3, 0.0f, 0.0f, 0.0f, 1.0f);
            this.matrixCartesianToFractional = new Matrix4f();
            this.matrixCartesianToFractional.invertM(this.matrixFractionalToCartesian);
        } else {
            this.matrixFractionalToCartesian = new Matrix4f();
            object = this.matrixFractionalToCartesian;
            ((Matrix4f)object).setColumn4(0, this.a, 0.0f, 0.0f, 0.0f);
            ((Matrix4f)object).setColumn4(1, (float)((double)this.b * this.cosGamma), (float)((double)this.b * this.sinGamma), 0.0f, 0.0f);
            ((Matrix4f)object).setColumn4(2, (float)((double)this.c * this.cosBeta), (float)((double)this.c * (this.cosAlpha - this.cosBeta * this.cosGamma) / this.sinGamma), (float)(this.volume / ((double)(this.a * this.b) * this.sinGamma)), 0.0f);
            ((Matrix4f)object).setColumn4(3, 0.0f, 0.0f, 0.0f, 1.0f);
            this.matrixCartesianToFractional = new Matrix4f();
            this.matrixCartesianToFractional.invertM(this.matrixFractionalToCartesian);
        }
        this.matrixCtoFAbsolute = this.matrixCartesianToFractional;
        this.matrixFtoCAbsolute = this.matrixFractionalToCartesian;
    }

    public P3 toSupercell(P3 p3) {
        p3.x /= (float)this.na;
        p3.y /= (float)this.nb;
        p3.z /= (float)this.nc;
        return p3;
    }

    public final void toCartesian(P3 p3, boolean bl) {
        if (this.matrixFractionalToCartesian != null) {
            (bl ? this.matrixFtoCAbsolute : this.matrixFractionalToCartesian).transform(p3);
        }
    }

    public final void toFractional(P3 p3, boolean bl) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        (bl ? this.matrixCtoFAbsolute : this.matrixCartesianToFractional).transform(p3);
    }

    public boolean isPolymer() {
        return this.dimension == 1;
    }

    public boolean isSlab() {
        return this.dimension == 2;
    }

    public final float[] getNotionalUnitCell() {
        return this.notionalUnitcell;
    }

    public final float[] getUnitCellAsArray(boolean bl) {
        float[] fArray;
        Matrix4f matrix4f = this.matrixFractionalToCartesian;
        if (bl) {
            float[] fArray2 = new float[9];
            fArray2[0] = matrix4f.m00;
            fArray2[1] = matrix4f.m10;
            fArray2[2] = matrix4f.m20;
            fArray2[3] = matrix4f.m01;
            fArray2[4] = matrix4f.m11;
            fArray2[5] = matrix4f.m21;
            fArray2[6] = matrix4f.m02;
            fArray2[7] = matrix4f.m12;
            fArray = fArray2;
            fArray2[8] = matrix4f.m22;
        } else {
            float[] fArray3 = new float[17];
            fArray3[0] = this.a;
            fArray3[1] = this.b;
            fArray3[2] = this.c;
            fArray3[3] = this.alpha;
            fArray3[4] = this.beta;
            fArray3[5] = this.gamma;
            fArray3[6] = matrix4f.m00;
            fArray3[7] = matrix4f.m10;
            fArray3[8] = matrix4f.m20;
            fArray3[9] = matrix4f.m01;
            fArray3[10] = matrix4f.m11;
            fArray3[11] = matrix4f.m21;
            fArray3[12] = matrix4f.m02;
            fArray3[13] = matrix4f.m12;
            fArray3[14] = matrix4f.m22;
            fArray3[15] = this.dimension;
            fArray = fArray3;
            fArray3[16] = (float)this.volume;
        }
        return fArray;
    }

    public final float getInfo(int n) {
        switch (n) {
            case 0: {
                return this.a;
            }
            case 1: {
                return this.b;
            }
            case 2: {
                return this.c;
            }
            case 3: {
                return this.alpha;
            }
            case 4: {
                return this.beta;
            }
            case 5: {
                return this.gamma;
            }
            case 6: {
                return this.dimension;
            }
        }
        return Float.NaN;
    }

    public static void ijkToPoint3f(int n, P3 p3, int n2) {
        p3.x = n / 100 + (n2 -= 5);
        p3.y = n % 100 / 10 + n2;
        p3.z = n % 10 + n2;
    }
}

