/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.thread;

import org.jmol.api.JmolScriptEvaluator;
import org.jmol.script.ScriptContext;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public abstract class JmolThread
extends Thread {
    public String name = "JmolThread";
    private static int threadIndex;
    protected static final int INIT = -1;
    protected static final int MAIN = 0;
    protected static final int FINISH = -2;
    protected static final int CHECK1 = 1;
    protected static final int CHECK2 = 2;
    protected static final int CHECK3 = 3;
    protected Viewer viewer;
    protected JmolScriptEvaluator eval;
    protected ScriptContext sc;
    protected boolean hoverEnabled;
    protected long startTime;
    protected long targetTime;
    protected long lastRepaintTime;
    protected long currentTime;
    protected int sleepTime;
    protected boolean isJS;
    protected boolean stopped = false;
    protected boolean isReset;
    private boolean useTimeout = true;
    double junk;

    public void setViewer(Viewer viewer, String string) {
        this.setName(string);
        this.name = string + "_" + ++threadIndex;
        this.viewer = viewer;
        this.isJS = viewer.isSingleThreaded;
    }

    protected abstract void run1(int var1) throws InterruptedException;

    public void setEval(JmolScriptEvaluator jmolScriptEvaluator) {
        this.eval = jmolScriptEvaluator;
        this.sc = this.viewer.getEvalContextAndHoldQueue(jmolScriptEvaluator);
        if (this.sc != null) {
            this.useTimeout = jmolScriptEvaluator.getAllowJSThreads();
        }
    }

    public void resumeEval() {
        if (this.eval == null || !this.isJS || !this.useTimeout) {
            return;
        }
        this.sc.mustResumeEval = !this.stopped;
        this.eval.resumeEval(this.sc);
        this.eval = null;
        this.sc = null;
    }

    public synchronized void start() {
        if (this.isJS) {
            Logger.info("starting " + this.name);
            this.run();
        } else {
            super.start();
        }
    }

    public void run() {
        this.startTime = System.currentTimeMillis();
        try {
            this.run1(-1);
        }
        catch (InterruptedException interruptedException) {
            if (Logger.debugging) {
                this.oops(interruptedException);
            }
        }
        catch (Exception exception) {
            this.oops(exception);
        }
    }

    protected void oops(Exception exception) {
        System.out.println(this.name + " exception " + exception);
        exception.printStackTrace();
        this.viewer.queueOnHold = false;
    }

    protected boolean runSleep(int n, int n2) throws InterruptedException {
        if (this.isJS && !this.useTimeout) {
            return true;
        }
        if (n > 0) {
            Thread.sleep(n);
        }
        return true;
    }

    public void interrupt() {
        this.stopped = true;
        this.viewer.startHoverWatcher(true);
        if (!this.isJS) {
            super.interrupt();
        }
    }

    protected boolean checkInterrupted() {
        return super.isInterrupted();
    }

    public void reset() {
        this.isReset = true;
        this.interrupt();
    }
}

