/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.thread;

import org.jmol.thread.JmolThread;
import org.jmol.util.Logger;
import org.jmol.viewer.AnimationManager;
import org.jmol.viewer.Viewer;

public class AnimationThread
extends JmolThread {
    private final AnimationManager animationManager;
    private final int framePointer;
    private final int framePointer2;
    private int intThread;
    private boolean isFirst;

    public AnimationThread(AnimationManager animationManager, Viewer viewer, int n, int n2, int n3) {
        this.setViewer(viewer, "AnimationThread");
        this.animationManager = animationManager;
        this.framePointer = n;
        this.framePointer2 = n2;
        this.intThread = n3;
        viewer.startHoverWatcher(false);
    }

    public void interrupt() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        Logger.debug("animation thread interrupted!");
        try {
            this.animationManager.setAnimationOn(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.interrupt();
    }

    protected void run1(int n) throws InterruptedException {
        while (true) {
            switch (n) {
                case -1: {
                    if (Logger.debugging) {
                        Logger.debug("animation thread " + this.intThread + " running");
                    }
                    this.viewer.requestRepaintAndWait();
                    this.viewer.startHoverWatcher(false);
                    this.isFirst = true;
                    n = 0;
                    break;
                }
                case 0: {
                    if (this.checkInterrupted() || !this.animationManager.animationOn) {
                        n = -2;
                        break;
                    }
                    if (this.animationManager.currentFrameIs(this.framePointer)) {
                        this.targetTime += (long)this.animationManager.firstFrameDelayMs;
                        this.sleepTime = (int)(this.targetTime - (System.currentTimeMillis() - this.startTime));
                        if (!this.runSleep(this.sleepTime, 1)) {
                            return;
                        }
                    }
                    n = 1;
                    break;
                }
                case 1: {
                    if (this.animationManager.currentFrameIs(this.framePointer2)) {
                        this.targetTime += (long)this.animationManager.lastFrameDelayMs;
                        this.sleepTime = (int)(this.targetTime - (System.currentTimeMillis() - this.startTime));
                        if (!this.runSleep(this.sleepTime, 2)) {
                            return;
                        }
                    }
                    n = 2;
                    break;
                }
                case 2: {
                    if (!this.isFirst && this.animationManager.currentIsLast() && !this.animationManager.setAnimationNext()) {
                        n = -2;
                        break;
                    }
                    this.isFirst = false;
                    this.targetTime += (long)((int)(1000.0f / (float)this.animationManager.animationFps + (float)this.viewer.getFrameDelayMs(this.animationManager.getCurrentFrame())));
                    n = 3;
                    break;
                }
                case 3: {
                    while (this.animationManager.animationOn && !this.checkInterrupted() && !this.viewer.getRefreshing()) {
                        if (this.runSleep(10, 3)) continue;
                        return;
                    }
                    if (!this.viewer.getSpinOn()) {
                        this.viewer.refresh(1, "animationThread");
                    }
                    this.sleepTime = (int)(this.targetTime - (System.currentTimeMillis() - this.startTime));
                    if (!this.runSleep(this.sleepTime, 0)) {
                        return;
                    }
                    n = 0;
                    break;
                }
                case -2: {
                    Logger.debug("animation thread " + this.intThread + " exiting");
                    this.animationManager.stopThread(false);
                    return;
                }
            }
        }
    }
}

