/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import org.jmol.atomdata.RadiusData;
import org.jmol.constant.EnumPalette;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Group;
import org.jmol.shape.Shape;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.C;

public abstract class AtomShape
extends Shape {
    public short mad = (short)-1;
    public short[] mads;
    public short[] colixes;
    public byte[] paletteIDs;
    public int atomCount;
    public Atom[] atoms;
    public boolean isActive;
    public int monomerCount;
    public BS bsSizeDefault;

    public Group[] getMonomers() {
        return null;
    }

    protected void initModelSet() {
        this.atoms = this.modelSet.atoms;
        this.atomCount = this.modelSet.getAtomCount();
        if (this.mads != null) {
            this.mads = ArrayUtil.arrayCopyShort(this.mads, this.atomCount);
        }
        if (this.colixes != null) {
            this.colixes = ArrayUtil.arrayCopyShort(this.colixes, this.atomCount);
        }
        if (this.paletteIDs != null) {
            this.paletteIDs = ArrayUtil.arrayCopyByte(this.paletteIDs, this.atomCount);
        }
    }

    public int getSize(int n) {
        return this.mads == null ? 0 : this.mads[n];
    }

    protected void setSize(int n, BS bS) {
        this.setSize2(n, bS);
    }

    protected void setSize2(int n, BS bS) {
        this.setSizeRD(n == 0 ? null : new RadiusData(null, n, RadiusData.EnumType.SCREEN, null), bS);
    }

    protected void setSizeRD(RadiusData radiusData, BS bS) {
        int n;
        if (this.atoms == null) {
            return;
        }
        this.isActive = true;
        if (this.bsSizeSet == null) {
            this.bsSizeSet = new BS();
        }
        boolean bl = radiusData != null && radiusData.value != 0.0f;
        boolean bl2 = bS == null;
        int n2 = n = bl2 ? this.atomCount - 1 : bS.nextSetBit(0);
        if (this.mads == null && n >= 0) {
            this.mads = new short[this.atomCount];
        }
        int n3 = n;
        while (n3 >= 0) {
            Atom atom = this.atoms[n3];
            this.mads[n3] = atom.calculateMad(this.viewer, radiusData);
            this.bsSizeSet.setBitTo(n3, bl);
            atom.setShapeVisibility(this.myVisibilityFlag, bl);
            n3 = bl2 ? n3 - 1 : bS.nextSetBit(n3 + 1);
        }
    }

    protected void setPropAS(String string, Object object, BS bS) {
        if ("color" == string) {
            this.isActive = true;
            short s = C.getColixO(object);
            byte by = EnumPalette.pidOf(object);
            if (this.bsColixSet == null) {
                this.bsColixSet = new BS();
            }
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                this.setColixAndPalette(s, by, n);
                n = bS.nextSetBit(n + 1);
            }
            return;
        }
        if ("colors" == string) {
            this.isActive = true;
            Object[] objectArray = (Object[])object;
            short[] sArray = (short[])objectArray[0];
            float f = ((Float)objectArray[1]).floatValue();
            if (this.bsColixSet == null) {
                this.bsColixSet = new BS();
            }
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                if (n < sArray.length) {
                    short s = sArray[n];
                    if (f > 0.01f) {
                        s = C.getColixTranslucent3(s, true, f);
                    }
                    this.setColixAndPalette(s, EnumPalette.UNKNOWN.id, n);
                }
                n = bS.nextSetBit(n + 1);
            }
            return;
        }
        if ("translucency" == string) {
            this.isActive = true;
            boolean bl = object.equals("translucent");
            if (this.bsColixSet == null) {
                this.bsColixSet = new BS();
            }
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                if (this.colixes == null) {
                    this.colixes = new short[this.atomCount];
                    this.paletteIDs = new byte[this.atomCount];
                }
                this.colixes[n] = C.getColixTranslucent3(this.colixes[n], bl, this.translucentLevel);
                if (bl) {
                    this.bsColixSet.set(n);
                }
                n = bS.nextSetBit(n + 1);
            }
            return;
        }
        if (string == "deleteModelAtoms") {
            this.atoms = (Atom[])((Object[])object)[1];
            int[] nArray = (int[])((Object[])object)[2];
            this.atomCount = this.modelSet.getAtomCount();
            int n = nArray[1];
            int n2 = nArray[2];
            this.mads = (short[])ArrayUtil.deleteElements(this.mads, n, n2);
            this.colixes = (short[])ArrayUtil.deleteElements(this.colixes, n, n2);
            this.paletteIDs = (byte[])ArrayUtil.deleteElements(this.paletteIDs, n, n2);
            BSUtil.deleteBits(this.bsSizeSet, bS);
            BSUtil.deleteBits(this.bsColixSet, bS);
            return;
        }
        this.setPropS(string, object, bS);
    }

    protected void setColixAndPalette(short s, byte by, int n) {
        if (this.colixes == null || n >= this.colixes.length) {
            if (s == 0) {
                return;
            }
            this.colixes = ArrayUtil.ensureLengthShort(this.colixes, n + 1);
            this.paletteIDs = ArrayUtil.ensureLengthByte(this.paletteIDs, n + 1);
        }
        if (this.bsColixSet == null) {
            this.bsColixSet = BS.newN(this.atomCount);
        }
        this.colixes[n] = s = this.getColixI(s, by, n);
        this.bsColixSet.setBitTo(n, s != 0);
        this.paletteIDs[n] = by;
    }

    public void setModelClickability() {
        if (!this.isActive) {
            return;
        }
        int n = this.atomCount;
        while (--n >= 0) {
            Atom atom = this.atoms[n];
            if ((atom.getShapeVisibilityFlags() & this.myVisibilityFlag) == 0 || this.modelSet.isAtomHidden(n)) continue;
            atom.setClickable(this.myVisibilityFlag);
        }
    }

    public String getShapeState() {
        return this.isActive ? this.viewer.getAtomShapeState(this) : "";
    }

    public String getInfoAsString(int n) {
        return null;
    }
}

