/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export.image;

import java.awt.Image;
import java.awt.image.ImageProducer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import org.jmol.export.image.ImageEncoder;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;

public class GifEncoder
extends ImageEncoder {
    private boolean interlace = false;
    int width;
    int height;
    int[][] rgbPixels;
    Map<String, AdaptiveColorCollection> colorHash;
    int Width;
    int Height;
    boolean Interlace;
    int curx;
    int cury;
    int CountDown;
    int Pass = 0;
    static final int EOF = -1;
    static final int BITS = 12;
    static final int HSIZE = 5003;
    int n_bits;
    int maxbits = 12;
    int maxcode;
    int maxmaxcode = 4096;
    int[] htab = new int[5003];
    int[] codetab = new int[5003];
    int hsize = 5003;
    int free_ent = 0;
    boolean clear_flg = false;
    int g_init_bits;
    int ClearCode;
    int EOFCode;
    int cur_accum = 0;
    int cur_bits = 0;
    int[] masks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
    int a_count;
    byte[] accum = new byte[256];

    public static void write(Image image, OutputStream outputStream) throws IOException {
        new GifEncoder(image, outputStream).encode();
    }

    public static byte[] getBytes(Image image) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            GifEncoder.write(image, byteArrayOutputStream);
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public GifEncoder(Image image, OutputStream outputStream) {
        super(image, outputStream);
    }

    public GifEncoder(Image image, OutputStream outputStream, boolean bl) {
        super(image, outputStream);
        this.interlace = bl;
    }

    public GifEncoder(ImageProducer imageProducer, OutputStream outputStream) {
        super(imageProducer, outputStream);
    }

    public GifEncoder(ImageProducer imageProducer, OutputStream outputStream, boolean bl) {
        super(imageProducer, outputStream);
        this.interlace = bl;
    }

    void encodeStart(int n, int n2) throws IOException {
        this.width = n;
        this.height = n2;
        this.rgbPixels = new int[n2][n];
    }

    void encodePixels(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) throws IOException {
        for (int i = 0; i < n4; ++i) {
            System.arraycopy(nArray, i * n6 + n5, this.rgbPixels[n2 + i], n, n3);
        }
    }

    void encodeDone() throws IOException {
        int n;
        Object object;
        int n2;
        String string;
        int n3;
        int n4;
        int n5;
        int n6 = -1;
        int n7 = -1;
        Hashtable<String, ColorItem> hashtable = new Hashtable<String, ColorItem>();
        ColorVector colorVector = new ColorVector();
        int n8 = 0;
        for (n5 = 0; n5 < this.height; ++n5) {
            for (n4 = 0; n4 < this.width; ++n4) {
                ColorItem colorItem;
                boolean bl;
                n3 = this.rgbPixels[n5][n4];
                boolean bl2 = bl = n3 >>> 24 < 128;
                if (bl) {
                    if (n6 < 0) {
                        n6 = n8;
                        n7 = n3;
                    } else if (n3 != n7) {
                        this.rgbPixels[n5][n4] = n3 = n7;
                    }
                }
                if ((colorItem = (ColorItem)hashtable.get(string = GifEncoder.getKey(n3))) == null) {
                    if (n8 < 0) {
                        throw new IOException("too many colors for a GIF");
                    }
                    colorItem = new ColorItem(n3, 1, n8, bl);
                    ++n8;
                    hashtable.put(string, colorItem);
                    colorVector.addLast(colorItem);
                    continue;
                }
                ++colorItem.count;
            }
        }
        hashtable = null;
        colorVector.sort();
        n5 = 65793;
        n4 = n8;
        n3 = Math.max(n8 - 1, 0);
        Logger.debug("# colors = " + n4);
        do {
            n4 = n8;
            this.colorHash = new Hashtable<String, AdaptiveColorCollection>();
            for (n2 = 0; n2 < n3; ++n2) {
                int n9;
                object = (ColorItem)colorVector.get(n2);
                ((ColorItem)object).rgb2 = n9 = n4 <= 256 ? ((ColorItem)object).rgb : ((ColorItem)object).rgb & ~n5;
                string = GifEncoder.getKey(n9);
                AdaptiveColorCollection adaptiveColorCollection = this.colorHash.get(string);
                if (adaptiveColorCollection == null) {
                    adaptiveColorCollection = new AdaptiveColorCollection(n9);
                    this.colorHash.put(string, adaptiveColorCollection);
                } else {
                    --n4;
                }
                ((ColorItem)object).acc = adaptiveColorCollection;
            }
            int n10 = n5;
            n5 <<= 1;
            n5 = n10 | n5;
        } while (n4 > 256);
        int n11 = n4 <= 2 ? 1 : (n4 <= 4 ? 2 : (n4 <= 16 ? 4 : 8));
        n2 = 1 << n11;
        object = new byte[n2];
        byte[] byArray = new byte[n2];
        byte[] byArray2 = new byte[n2];
        Hashtable<String, AdaptiveColorCollection> hashtable2 = new Hashtable<String, AdaptiveColorCollection>();
        for (n = 0; n < n8; ++n) {
            ColorItem colorItem = (ColorItem)colorVector.get(n);
            int n12 = colorItem.rgb;
            int n13 = colorItem.count;
            string = GifEncoder.getKey(n12);
            if (colorItem.acc == null) {
                colorItem.acc = new AdaptiveColorCollection(n12);
                this.colorHash.put(string, colorItem.acc);
            }
            colorItem.acc.addRgb(n12, n13);
            hashtable2.put(string, colorItem.acc);
        }
        n = 0;
        for (AdaptiveColorCollection adaptiveColorCollection : this.colorHash.values()) {
            adaptiveColorCollection.index = n++;
            adaptiveColorCollection.setRgb((byte[])object, byArray, byArray2);
        }
        Logger.debug("# colors = " + n);
        this.colorHash = hashtable2;
        this.GIFEncode(this.out, this.width, this.height, this.interlace, (byte)0, n6, n11, (byte[])object, byArray, byArray2);
    }

    private static String getKey(int n) {
        return Integer.toHexString(n).substring(2);
    }

    byte GetPixel(int n, int n2) {
        int n3;
        int n4 = this.rgbPixels[n2][n];
        try {
            n3 = this.colorHash.get((Object)GifEncoder.getKey((int)n4)).index;
        }
        catch (Exception exception) {
            n3 = 0;
        }
        return (byte)n3;
    }

    static void writeString(OutputStream outputStream, String string) throws IOException {
        byte[] byArray = string.getBytes();
        outputStream.write(byArray);
    }

    void GIFEncode(OutputStream outputStream, int n, int n2, boolean bl, byte by, int n3, int n4, byte[] byArray, byte[] byArray2, byte[] byArray3) throws IOException {
        this.Width = n;
        this.Height = n2;
        this.Interlace = bl;
        int n5 = 1 << n4;
        int n6 = 0;
        int n7 = 0;
        this.CountDown = n * n2;
        this.Pass = 0;
        int n8 = n4 <= 1 ? 2 : n4;
        this.curx = 0;
        this.cury = 0;
        GifEncoder.writeString(outputStream, "GIF89a");
        this.Putword(n, outputStream);
        this.Putword(n2, outputStream);
        int n9 = -128;
        n9 = (byte)(n9 | 0x70);
        n9 = (byte)(n9 | (byte)(n4 - 1));
        this.Putbyte(n9, outputStream);
        this.Putbyte(by, outputStream);
        this.Putbyte(0, outputStream);
        for (int i = 0; i < n5; ++i) {
            this.Putbyte(byArray[i], outputStream);
            this.Putbyte(byArray2[i], outputStream);
            this.Putbyte(byArray3[i], outputStream);
        }
        if (n3 != -1) {
            this.Putbyte(33, outputStream);
            this.Putbyte(249, outputStream);
            this.Putbyte(4, outputStream);
            this.Putbyte(1, outputStream);
            this.Putbyte(0, outputStream);
            this.Putbyte(0, outputStream);
            this.Putbyte(n3, outputStream);
            this.Putbyte(0, outputStream);
        }
        this.Putbyte(44, outputStream);
        this.Putword(n7, outputStream);
        this.Putword(n6, outputStream);
        this.Putword(n, outputStream);
        this.Putword(n2, outputStream);
        if (bl) {
            this.Putbyte(64, outputStream);
        } else {
            this.Putbyte(0, outputStream);
        }
        this.Putbyte(n8, outputStream);
        this.compress(n8 + 1, outputStream);
        this.Putbyte(0, outputStream);
        this.Putbyte(59, outputStream);
    }

    void BumpPixel() {
        ++this.curx;
        if (this.curx == this.Width) {
            this.curx = 0;
            if (!this.Interlace) {
                ++this.cury;
            } else {
                switch (this.Pass) {
                    case 0: {
                        this.cury += 8;
                        if (this.cury < this.Height) break;
                        ++this.Pass;
                        this.cury = 4;
                        break;
                    }
                    case 1: {
                        this.cury += 8;
                        if (this.cury < this.Height) break;
                        ++this.Pass;
                        this.cury = 2;
                        break;
                    }
                    case 2: {
                        this.cury += 4;
                        if (this.cury < this.Height) break;
                        ++this.Pass;
                        this.cury = 1;
                        break;
                    }
                    case 3: {
                        this.cury += 2;
                    }
                }
            }
        }
    }

    int GIFNextPixel() {
        if (this.CountDown == 0) {
            return -1;
        }
        --this.CountDown;
        byte by = this.GetPixel(this.curx, this.cury);
        this.BumpPixel();
        return by & 0xFF;
    }

    void Putword(int n, OutputStream outputStream) throws IOException {
        this.Putbyte(n, outputStream);
        this.Putbyte(n >> 8, outputStream);
    }

    void Putbyte(int n, OutputStream outputStream) throws IOException {
        outputStream.write(n);
    }

    final int MAXCODE(int n) {
        return (1 << n) - 1;
    }

    void compress(int n, OutputStream outputStream) throws IOException {
        int n2;
        int n3;
        this.g_init_bits = n;
        this.clear_flg = false;
        this.n_bits = this.g_init_bits;
        this.maxcode = this.MAXCODE(this.n_bits);
        this.ClearCode = 1 << n - 1;
        this.EOFCode = this.ClearCode + 1;
        this.free_ent = this.ClearCode + 2;
        this.char_init();
        int n4 = this.GIFNextPixel();
        int n5 = 0;
        for (n3 = this.hsize; n3 < 65536; n3 *= 2) {
            ++n5;
        }
        n5 = 8 - n5;
        int n6 = this.hsize;
        this.cl_hash(n6);
        this.output(this.ClearCode, outputStream);
        block1: while ((n2 = this.GIFNextPixel()) != -1) {
            int n7 = n2 << n5 ^ n4;
            n3 = (n2 << this.maxbits) + n4;
            if (this.htab[n7] == n3) {
                n4 = this.codetab[n7];
                continue;
            }
            if (this.htab[n7] >= 0) {
                int n8 = n6 - n7;
                if (n7 == 0) {
                    n8 = 1;
                }
                do {
                    if ((n7 -= n8) < 0) {
                        n7 += n6;
                    }
                    if (this.htab[n7] != n3) continue;
                    n4 = this.codetab[n7];
                    continue block1;
                } while (this.htab[n7] >= 0);
            }
            this.output(n4, outputStream);
            n4 = n2;
            if (this.free_ent < this.maxmaxcode) {
                ++this.free_ent;
                this.htab[n7] = n3;
                continue;
            }
            this.cl_block(outputStream);
        }
        this.output(n4, outputStream);
        this.output(this.EOFCode, outputStream);
    }

    void output(int n, OutputStream outputStream) throws IOException {
        this.cur_accum &= this.masks[this.cur_bits];
        this.cur_accum = this.cur_bits > 0 ? (this.cur_accum |= n << this.cur_bits) : n;
        this.cur_bits += this.n_bits;
        while (this.cur_bits >= 8) {
            this.char_out((byte)(this.cur_accum & 0xFF), outputStream);
            this.cur_accum >>= 8;
            this.cur_bits -= 8;
        }
        if (this.free_ent > this.maxcode || this.clear_flg) {
            if (this.clear_flg) {
                this.n_bits = this.g_init_bits;
                this.maxcode = this.MAXCODE(this.n_bits);
                this.clear_flg = false;
            } else {
                ++this.n_bits;
                this.maxcode = this.n_bits == this.maxbits ? this.maxmaxcode : this.MAXCODE(this.n_bits);
            }
        }
        if (n == this.EOFCode) {
            while (this.cur_bits > 0) {
                this.char_out((byte)(this.cur_accum & 0xFF), outputStream);
                this.cur_accum >>= 8;
                this.cur_bits -= 8;
            }
            this.flush_char(outputStream);
        }
    }

    void cl_block(OutputStream outputStream) throws IOException {
        this.cl_hash(this.hsize);
        this.free_ent = this.ClearCode + 2;
        this.clear_flg = true;
        this.output(this.ClearCode, outputStream);
    }

    void cl_hash(int n) {
        for (int i = 0; i < n; ++i) {
            this.htab[i] = -1;
        }
    }

    void char_init() {
        this.a_count = 0;
    }

    void char_out(byte by, OutputStream outputStream) throws IOException {
        this.accum[this.a_count++] = by;
        if (this.a_count >= 254) {
            this.flush_char(outputStream);
        }
    }

    void flush_char(OutputStream outputStream) throws IOException {
        if (this.a_count > 0) {
            outputStream.write(this.a_count);
            outputStream.write(this.accum, 0, this.a_count);
            this.a_count = 0;
        }
    }

    static class AdaptiveColorCollection {
        int rgb;
        int index;
        long red;
        long green;
        long blue;
        int count;

        AdaptiveColorCollection(int n) {
            this.rgb = n;
        }

        void addRgb(int n, int n2) {
            this.count += n2;
            this.blue += (long)((n & 0xFF) * n2);
            this.green += (long)((n >> 8 & 0xFF) * n2);
            this.red += (long)((n >> 16 & 0xFF) * n2);
        }

        void setRgb(byte[] byArray, byte[] byArray2, byte[] byArray3) {
            byArray[this.index] = (byte)(this.red / (long)this.count & 0xFFL);
            byArray2[this.index] = (byte)(this.green / (long)this.count & 0xFFL);
            byArray3[this.index] = (byte)(this.blue / (long)this.count & 0xFFL);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ColorVector
    extends JmolList<ColorItem> {
        ColorVector() {
        }

        void sort() {
            CountComparator countComparator = new CountComparator();
            Collections.sort(this, countComparator);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class CountComparator
        implements Comparator<ColorItem> {
            CountComparator() {
            }

            @Override
            public int compare(ColorItem colorItem, ColorItem colorItem2) {
                return colorItem == null ? 1 : (colorItem2 == null ? -1 : (colorItem.count < colorItem2.count ? -1 : (colorItem.count > colorItem2.count ? 1 : 0)));
            }
        }
    }

    static class ColorItem {
        AdaptiveColorCollection acc;
        int rgb;
        int rgb2;
        int count;
        int index;
        boolean isTransparent;

        ColorItem(int n, int n2, int n3, boolean bl) {
            this.rgb = this.rgb2 = n;
            this.count = n2;
            this.index = n3;
            this.isTransparent = bl;
        }
    }
}

