/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import org.jmol.util.BoxInfo;
import org.jmol.util.Matrix3f;
import org.jmol.util.Matrix4f;
import org.jmol.util.P3;
import org.jmol.util.P3i;
import org.jmol.util.Quadric;
import org.jmol.util.SimpleUnitCell;
import org.jmol.util.Tuple3f;

class UnitCell
extends SimpleUnitCell {
    private P3[] vertices;
    private P3 cartesianOffset = new P3();
    private P3 fractionalOffset = new P3();
    private boolean allFractionalRelative = false;
    private P3 unitCellMultiplier = null;
    private static final double twoP2 = 19.739208802178716;

    UnitCell() {
    }

    static UnitCell newP(Tuple3f[] tuple3fArray) {
        UnitCell unitCell = new UnitCell();
        float[] fArray = new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, tuple3fArray[1].x, tuple3fArray[1].y, tuple3fArray[1].z, tuple3fArray[2].x, tuple3fArray[2].y, tuple3fArray[2].z, tuple3fArray[3].x, tuple3fArray[3].y, tuple3fArray[3].z};
        unitCell.set(fArray);
        unitCell.allFractionalRelative = true;
        unitCell.calcUnitcellVertices();
        unitCell.setCartesianOffset(tuple3fArray[0]);
        return unitCell;
    }

    public static UnitCell newA(float[] fArray) {
        UnitCell unitCell = new UnitCell();
        unitCell.set(fArray);
        unitCell.calcUnitcellVertices();
        return unitCell;
    }

    void setOrientation(Matrix3f matrix3f) {
        if (matrix3f == null) {
            return;
        }
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.setM3(matrix3f);
        this.matrixFractionalToCartesian.mul2(matrix4f, this.matrixFractionalToCartesian);
        this.matrixCartesianToFractional.invertM(this.matrixFractionalToCartesian);
        this.calcUnitcellVertices();
    }

    final void toUnitCell(P3 p3, P3 p32) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        if (p32 == null) {
            this.matrixCartesianToFractional.transform(p3);
            switch (this.dimension) {
                case 3: {
                    p3.z = UnitCell.toFractionalX(p3.z);
                }
                case 2: {
                    p3.y = UnitCell.toFractionalX(p3.y);
                }
                case 1: {
                    p3.x = UnitCell.toFractionalX(p3.x);
                }
            }
            this.matrixFractionalToCartesian.transform(p3);
        } else {
            this.matrixCtoFAbsolute.transform(p3);
            switch (this.dimension) {
                case 3: {
                    p3.z = UnitCell.toFractionalX(p3.z);
                }
                case 2: {
                    p3.y = UnitCell.toFractionalX(p3.y);
                }
                case 1: {
                    p3.x = UnitCell.toFractionalX(p3.x);
                }
            }
            p3.add((Tuple3f)p32);
            this.matrixFtoCAbsolute.transform(p3);
        }
    }

    void setAllFractionalRelative(boolean bl) {
        this.allFractionalRelative = bl;
    }

    void setOffset(P3 p3) {
        if (p3 == null) {
            return;
        }
        if (p3.x >= 100.0f || p3.y >= 100.0f) {
            this.unitCellMultiplier = P3.newP((Tuple3f)p3);
            return;
        }
        if (p3.x == 0.0f && p3.y == 0.0f && p3.z == 0.0f) {
            this.unitCellMultiplier = null;
        }
        this.fractionalOffset.setT((Tuple3f)p3);
        this.matrixCartesianToFractional.m03 = -p3.x;
        this.matrixCartesianToFractional.m13 = -p3.y;
        this.matrixCartesianToFractional.m23 = -p3.z;
        this.cartesianOffset.setT((Tuple3f)p3);
        this.matrixFractionalToCartesian.m03 = 0.0f;
        this.matrixFractionalToCartesian.m13 = 0.0f;
        this.matrixFractionalToCartesian.m23 = 0.0f;
        this.matrixFractionalToCartesian.transform(this.cartesianOffset);
        this.matrixFractionalToCartesian.m03 = this.cartesianOffset.x;
        this.matrixFractionalToCartesian.m13 = this.cartesianOffset.y;
        this.matrixFractionalToCartesian.m23 = this.cartesianOffset.z;
        if (this.allFractionalRelative) {
            this.matrixCtoFAbsolute.setM(this.matrixCartesianToFractional);
            this.matrixFtoCAbsolute.setM(this.matrixFractionalToCartesian);
        }
    }

    public void setCartesianOffset(Tuple3f tuple3f) {
        this.cartesianOffset.setT(tuple3f);
        this.matrixFractionalToCartesian.m03 = this.cartesianOffset.x;
        this.matrixFractionalToCartesian.m13 = this.cartesianOffset.y;
        this.matrixFractionalToCartesian.m23 = this.cartesianOffset.z;
        this.fractionalOffset.setT((Tuple3f)this.cartesianOffset);
        this.matrixCartesianToFractional.m03 = 0.0f;
        this.matrixCartesianToFractional.m13 = 0.0f;
        this.matrixCartesianToFractional.m23 = 0.0f;
        this.matrixCartesianToFractional.transform(this.fractionalOffset);
        this.matrixCartesianToFractional.m03 = -this.fractionalOffset.x;
        this.matrixCartesianToFractional.m13 = -this.fractionalOffset.y;
        this.matrixCartesianToFractional.m23 = -this.fractionalOffset.z;
        if (this.allFractionalRelative) {
            this.matrixCtoFAbsolute.setM(this.matrixCartesianToFractional);
            this.matrixFtoCAbsolute.setM(this.matrixFractionalToCartesian);
        }
    }

    void setMinMaxLatticeParameters(P3i p3i, P3i p3i2) {
        if (p3i2.x <= 555 && p3i2.y >= 555) {
            P3 p3 = new P3();
            UnitCell.ijkToPoint3f((int)p3i2.x, (P3)p3, (int)0);
            p3i.x = (int)p3.x;
            p3i.y = (int)p3.y;
            p3i.z = (int)p3.z;
            UnitCell.ijkToPoint3f((int)p3i2.y, (P3)p3, (int)1);
            p3i2.x = (int)p3.x;
            p3i2.y = (int)p3.y;
            p3i2.z = (int)p3.z;
        }
        switch (this.dimension) {
            case 1: {
                p3i.y = 0;
                p3i2.y = 1;
            }
            case 2: {
                p3i.z = 0;
                p3i2.z = 1;
            }
        }
    }

    final String dumpInfo(boolean bl) {
        return "a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", alpha=" + this.alpha + ", beta=" + this.beta + ", gamma=" + this.gamma + (bl ? "\nfractional to cartesian: " + this.matrixFractionalToCartesian + "\ncartesian to fractional: " + this.matrixCartesianToFractional : "");
    }

    P3[] getVertices() {
        return this.vertices;
    }

    P3 getCartesianOffset() {
        return this.cartesianOffset;
    }

    P3 getFractionalOffset() {
        return this.fractionalOffset;
    }

    Quadric getEllipsoid(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        if (fArray[0] == 0.0f) {
            float[] fArray2 = new float[3];
            fArray2[1] = fArray2[2] = (float)Math.sqrt(fArray[7]);
            fArray2[0] = fArray2[2];
            return new Quadric().fromVectors(null, fArray2, true);
        }
        double[] dArray = new double[6];
        int n = (int)fArray[6];
        if (n == 12) {
            dArray[0] = (double)fArray[0] * 19.739208802178716;
            dArray[1] = (double)fArray[1] * 19.739208802178716;
            dArray[2] = (double)fArray[2] * 19.739208802178716;
            dArray[3] = (double)fArray[3] * 19.739208802178716 * 2.0;
            dArray[4] = (double)fArray[4] * 19.739208802178716 * 2.0;
            dArray[5] = (double)fArray[5] * 19.739208802178716 * 2.0;
            fArray[7] = (fArray[0] + fArray[1] + fArray[3]) / 3.0f;
        } else {
            boolean bl = n == 4 || n == 5 || n == 8 || n == 9;
            double d = 2 - n % 2;
            double d2 = n == 8 || n == 9 || n == 10 ? 19.739208802178716 : (n == 4 || n == 5 ? 0.25 : (n == 2 || n == 3 ? Math.log(2.0) : 1.0));
            double d3 = (double)fArray[0] * d2 * (bl ? this.a_ * this.a_ : 1.0);
            double d4 = (double)fArray[1] * d2 * (bl ? this.b_ * this.b_ : 1.0);
            double d5 = (double)fArray[2] * d2 * (bl ? this.c_ * this.c_ : 1.0);
            double d6 = (double)fArray[3] * d2 * (bl ? this.a_ * this.b_ : 1.0) * d;
            double d7 = (double)fArray[4] * d2 * (bl ? this.a_ * this.c_ : 1.0) * d;
            double d8 = (double)fArray[5] * d2 * (bl ? this.b_ * this.c_ : 1.0) * d;
            fArray[7] = (float)Math.pow(d3 / 19.739208802178716 / this.a_ / this.a_ * d4 / 19.739208802178716 / this.b_ / this.b_ * d5 / 19.739208802178716 / this.c_ / this.c_, 0.3333);
            dArray[0] = (double)(this.a * this.a) * d3 + (double)(this.b * this.b) * this.cosGamma * this.cosGamma * d4 + (double)(this.c * this.c) * this.cosBeta * this.cosBeta * d5 + (double)(this.a * this.b) * this.cosGamma * d6 + (double)(this.b * this.c) * this.cosGamma * this.cosBeta * d8 + (double)(this.a * this.c) * this.cosBeta * d7;
            dArray[1] = (double)(this.b * this.b) * this.sinGamma * this.sinGamma * d4 + (double)(this.c * this.c) * this.cA_ * this.cA_ * d5 + (double)(this.b * this.c) * this.cA_ * this.sinGamma * d8;
            dArray[2] = (double)(this.c * this.c) * this.cB_ * this.cB_ * d5;
            dArray[3] = (double)(2.0f * this.b * this.b) * this.cosGamma * this.sinGamma * d4 + (double)(2.0f * this.c * this.c) * this.cA_ * this.cosBeta * d5 + (double)(this.a * this.b) * this.sinGamma * d6 + (double)(this.b * this.c) * (this.cA_ * this.cosGamma + this.sinGamma * this.cosBeta) * d8 + (double)(this.a * this.c) * this.cA_ * d7;
            dArray[4] = (double)(2.0f * this.c * this.c) * this.cB_ * this.cosBeta * d5 + (double)(this.b * this.c) * this.cosGamma * d8 + (double)(this.a * this.c) * this.cB_ * d7;
            dArray[5] = (double)(2.0f * this.c * this.c) * this.cA_ * this.cB_ * d5 + (double)(this.b * this.c) * this.cB_ * this.sinGamma * d8;
        }
        return new Quadric().fromBCart(dArray);
    }

    P3[] getCanonicalCopy(float f) {
        P3[] p3Array = new P3[8];
        for (int i = 0; i < 8; ++i) {
            p3Array[i] = P3.newP((Tuple3f)BoxInfo.unitCubePoints[i]);
            this.matrixFractionalToCartesian.transform(p3Array[i]);
        }
        return BoxInfo.getCanonicalCopy((P3[])p3Array, (float)f);
    }

    private static float toFractionalX(float f) {
        if ((f = (float)((double)f - Math.floor(f))) > 0.9999f || f < 1.0E-4f) {
            f = 0.0f;
        }
        return f;
    }

    private void calcUnitcellVertices() {
        if (this.matrixFractionalToCartesian == null) {
            return;
        }
        this.matrixCtoFAbsolute = Matrix4f.newM((Matrix4f)this.matrixCartesianToFractional);
        this.matrixFtoCAbsolute = Matrix4f.newM((Matrix4f)this.matrixFractionalToCartesian);
        this.vertices = new P3[8];
        int n = 8;
        while (--n >= 0) {
            this.vertices[n] = new P3();
            this.matrixFractionalToCartesian.transform2(BoxInfo.unitCubePoints[n], this.vertices[n]);
        }
    }

    public boolean checkDistance(P3 p3, P3 p32, float f, float f2, int n, int n2, int n3, P3 p33) {
        P3 p34 = P3.newP((Tuple3f)p3);
        this.toCartesian(p34, true);
        for (int i = -n; i <= n; ++i) {
            for (int j = -n2; j <= n2; ++j) {
                for (int k = -n3; k <= n3; ++k) {
                    p33.set(p32.x + (float)i, p32.y + (float)j, p32.z + (float)k);
                    this.toCartesian(p33, true);
                    float f3 = p34.distance(p33);
                    if (!(f2 > 0.0f ? Math.abs(f3 - f) <= f2 : f3 <= f && f3 > 0.1f)) continue;
                    p33.set((float)i, (float)j, (float)k);
                    return true;
                }
            }
        }
        return false;
    }

    public P3 getUnitCellMultiplier() {
        return this.unitCellMultiplier;
    }

    public P3[] getUnitCellVectors() {
        Matrix4f matrix4f = this.matrixFractionalToCartesian;
        return new P3[]{P3.newP((Tuple3f)this.cartesianOffset), P3.new3((float)matrix4f.m00, (float)matrix4f.m10, (float)matrix4f.m20), P3.new3((float)matrix4f.m01, (float)matrix4f.m11, (float)matrix4f.m21), P3.new3((float)matrix4f.m02, (float)matrix4f.m12, (float)matrix4f.m22)};
    }
}

