/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.util.Hashtable;
import org.jmol.jvxl.readers.MapFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.SB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PyMOLMeshReader
extends MapFileReader {
    private Hashtable<String, JmolList<Object>> map;
    private JmolList<Object> data;
    private JmolList<Object> surfaceList;
    private JmolList<Object> voxelList;
    private String surfaceName;
    private int pymolType;
    private boolean isMesh;
    private int pt;

    PyMOLMeshReader() {
    }

    @Override
    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        super.init2(surfaceGenerator, null);
        this.map = (Hashtable)surfaceGenerator.getReaderData();
        this.nSurfaces = 1;
        this.data = this.map.get(this.params.calculationType);
        if (this.data == null) {
            return;
        }
        this.pymolType = (int)this.getFloat(PyMOLMeshReader.getList(this.data, 0), 0);
        boolean bl = this.isMesh = this.pymolType == 3;
        if (this.isMesh) {
            this.surfaceName = (String)this.data.get(this.data.size() - 1);
            this.surfaceList = PyMOLMeshReader.getList(PyMOLMeshReader.getList(this.map.get(this.surfaceName), 2), 0);
            if (this.params.thePlane == null && this.params.cutoffAutomatic) {
                this.params.cutoff = this.getFloat(PyMOLMeshReader.getList(PyMOLMeshReader.getList(this.data, 2), 0), 8);
                this.params.cutoffAutomatic = false;
            }
        } else {
            this.surfaceList = PyMOLMeshReader.getList(PyMOLMeshReader.getList(this.data, 2), 0);
            this.surfaceName = (String)this.data.get(this.data.size() - 1);
        }
        this.voxelList = PyMOLMeshReader.getList(PyMOLMeshReader.getList(PyMOLMeshReader.getList(this.surfaceList, 14), 2), 6);
        System.out.println("Number of grid points = " + this.voxelList.size());
    }

    private static JmolList<Object> getList(JmolList<Object> jmolList, int n) {
        return (JmolList)jmolList.get(n);
    }

    @Override
    protected void readParameters() throws Exception {
        this.jvxlFileHeaderBuffer = new SB();
        this.jvxlFileHeaderBuffer.append("PyMOL surface reader\n");
        this.jvxlFileHeaderBuffer.append(this.surfaceName + " (" + this.params.calculationType + ")\n");
        JmolList<Object> jmolList = PyMOLMeshReader.getList(PyMOLMeshReader.getList(this.surfaceList, 1), 0);
        this.a = this.getFloat(jmolList, 0);
        this.b = this.getFloat(jmolList, 1);
        this.c = this.getFloat(jmolList, 2);
        jmolList = PyMOLMeshReader.getList(PyMOLMeshReader.getList(this.surfaceList, 1), 1);
        this.alpha = this.getFloat(jmolList, 0);
        this.beta = this.getFloat(jmolList, 1);
        this.gamma = this.getFloat(jmolList, 2);
        jmolList = PyMOLMeshReader.getList(this.surfaceList, 7);
        this.origin.set(this.getFloat(jmolList, 0), this.getFloat(jmolList, 1), this.getFloat(jmolList, 2));
        jmolList = PyMOLMeshReader.getList(this.surfaceList, 10);
        this.na = (int)this.getFloat(jmolList, 0);
        this.nb = (int)this.getFloat(jmolList, 1);
        this.nc = (int)this.getFloat(jmolList, 2);
        jmolList = PyMOLMeshReader.getList(this.surfaceList, 11);
        this.nxyzStart[0] = (int)this.getFloat(jmolList, 0);
        this.nxyzStart[1] = (int)this.getFloat(jmolList, 1);
        this.nxyzStart[2] = (int)this.getFloat(jmolList, 2);
        jmolList = PyMOLMeshReader.getList(this.surfaceList, 13);
        this.nz = (int)this.getFloat(jmolList, 0);
        this.ny = (int)this.getFloat(jmolList, 1);
        this.nx = (int)this.getFloat(jmolList, 2);
        if (this.na < 0 || this.nb < 0 || this.nc < 0) {
            this.na = this.nz - 1;
            this.nb = this.ny - 1;
            this.nc = this.nx - 1;
            jmolList = PyMOLMeshReader.getList(this.surfaceList, 8);
            this.a = this.getFloat(jmolList, 0) - this.origin.x;
            this.b = this.getFloat(jmolList, 1) - this.origin.y;
            this.c = this.getFloat(jmolList, 2) - this.origin.z;
        }
        this.mapc = 3;
        this.mapr = 2;
        this.maps = 1;
        this.getVectorsAndOrigin();
        this.setCutoffAutomatic();
    }

    @Override
    protected float nextVoxel() throws Exception {
        return this.getFloat(this.voxelList, this.pt++);
    }

    private float getFloat(JmolList<Object> jmolList, int n) {
        return ((Number)jmolList.get(n)).floatValue();
    }

    @Override
    protected void skipData(int n) throws Exception {
    }

    @Override
    protected void setCutoffAutomatic() {
        if (this.params.thePlane == null && this.params.cutoffAutomatic) {
            float f = this.params.cutoff = this.boundingBox == null ? 3.0f : 1.6f;
            if (this.dmin != Float.MAX_VALUE && this.params.cutoff > this.dmax) {
                this.params.cutoff = this.dmax / 4.0f;
            }
            Logger.info((String)("MapReader: setting cutoff to default value of " + this.params.cutoff + (this.boundingBox == null ? " (no BOUNDBOX parameter)\n" : "\n")));
        }
    }
}

