/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Map;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.readers.PolygonFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.ColorUtil;
import org.jmol.util.Logger;
import org.jmol.util.P3;

class NffReader
extends PolygonFileReader {
    protected int nPolygons;
    private final Map<String, Integer> vertexMap = new Hashtable<String, Integer>();
    private final P3 pt = new P3();

    NffReader() {
    }

    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        super.init2(surfaceGenerator, bufferedReader);
    }

    protected void setHeader() {
        this.jvxlFileHeaderBuffer.append("NFF file format\nvertices and triangles only\n");
        JvxlCoder.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
    }

    void getSurfaceData() throws Exception {
        if (this.readVerticesAndPolygons()) {
            Logger.info((String)("NFF file contains " + this.nVertices + " vertices and " + this.nTriangles + " triangles"));
        } else {
            Logger.error((String)(this.params.fileName + ": Error reading Nff data "));
        }
    }

    protected boolean readVerticesAndPolygons() {
        int n = 0xFF0000;
        try {
            block7: while (this.readLine() != null) {
                if (this.line.length() == 0) continue;
                String[] stringArray = this.getTokens();
                switch (this.line.charAt(0)) {
                    case '#': {
                        this.vertexMap.clear();
                        continue block7;
                    }
                    case 'f': {
                        n = ColorUtil.colorTriadToInt((float)this.parseFloatStr(stringArray[1]), (float)this.parseFloatStr(stringArray[2]), (float)this.parseFloatStr(stringArray[3]));
                        continue block7;
                    }
                    case 'p': {
                        if (!this.line.equals("pp 3")) continue block7;
                        int n2 = this.getVertex();
                        int n3 = this.getVertex();
                        int n4 = this.getVertex();
                        ++this.nTriangles;
                        this.addTriangleCheck(n2, n3, n4, 7, 0, false, n);
                        continue block7;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private int getVertex() throws Exception {
        Integer n = this.vertexMap.get(this.readLine());
        if (n == null) {
            String[] stringArray = this.getTokens();
            this.pt.set(this.parseFloatStr(stringArray[0]), this.parseFloatStr(stringArray[1]), this.parseFloatStr(stringArray[2]));
            if (!Float.isNaN(this.params.scale)) {
                this.pt.scale(this.params.scale);
            }
            if (this.isAnisotropic) {
                this.setVertexAnisotropy(this.pt);
            }
            n = this.addVertexCopy(this.pt, 0.0f, this.nVertices++);
            this.vertexMap.put(this.line, n);
        }
        return n;
    }
}

