/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.jmol.api.ApiPlatform;
import org.jmol.api.Interface;
import org.jmol.api.JmolDocument;
import org.jmol.api.JmolDomReaderInterface;
import org.jmol.api.JmolFileAdapterInterface;
import org.jmol.api.JmolFileInterface;
import org.jmol.api.JmolFilesReaderInterface;
import org.jmol.api.JmolViewer;
import org.jmol.api.ZInputStream;
import org.jmol.io.Base64;
import org.jmol.io.DataReader;
import org.jmol.io.FileReader;
import org.jmol.io.JmolBinary;
import org.jmol.util.Escape;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.SB;
import org.jmol.util.TextFormat;
import org.jmol.viewer.DataManager;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileManager {
    private Viewer viewer;
    private String pathForAllFiles = "";
    public String nameAsGiven = "zapped";
    public String fullPathName;
    public String fileName;
    private URL appletDocumentBaseURL = null;
    private String appletProxy;
    public static final int URL_LOCAL = 3;
    private static final String[] urlPrefixes = new String[]{"http:", "https:", "ftp:", "file:"};
    private static final String[] urlPrefixPairs = new String[]{"http:", "http://", "www.", "http://www.", "https:", "https://", "ftp:", "ftp://", "file:", "file:///"};
    public static String[] scriptFilePrefixes = new String[]{"/*file*/\"", "FILE0=\"", "FILE1=\""};
    public Map<String, byte[]> pngjCache;
    public Map<String, byte[]> spardirCache;
    private Map<String, Object> cache = new Hashtable<String, Object>();

    FileManager(Viewer viewer) {
        this.viewer = viewer;
        this.clear();
    }

    void clear() {
        this.fileName = this.nameAsGiven = this.viewer.getZapName();
        this.fullPathName = this.nameAsGiven;
        this.spardirCache = null;
    }

    private void setLoadState(Map<String, Object> map) {
        if (this.viewer.getPreserveState()) {
            map.put("loadState", this.viewer.getLoadState(map));
        }
    }

    String getPathForAllFiles() {
        return this.pathForAllFiles;
    }

    String setPathForAllFiles(String string) {
        if (string.length() > 0 && !string.endsWith("/") && !string.endsWith("|")) {
            string = string + "/";
        }
        this.pathForAllFiles = string;
        return this.pathForAllFiles;
    }

    void setFileInfo(String[] stringArray) {
        this.fullPathName = stringArray[0];
        this.fileName = stringArray[1];
        this.nameAsGiven = stringArray[2];
    }

    String[] getFileInfo() {
        return new String[]{this.fullPathName, this.fileName, this.nameAsGiven};
    }

    String getFullPathName() {
        return this.fullPathName != null ? this.fullPathName : this.nameAsGiven;
    }

    String getFileName() {
        return this.fileName != null ? this.fileName : this.nameAsGiven;
    }

    String getAppletDocumentBase() {
        return this.appletDocumentBaseURL == null ? "" : this.appletDocumentBaseURL.toString();
    }

    void setAppletContext(String string) {
        try {
            this.appletDocumentBaseURL = string.length() == 0 ? null : new URL((URL)null, string, null);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    void setAppletProxy(String string) {
        this.appletProxy = string == null || string.length() == 0 ? null : string;
    }

    String getFileTypeName(String string) {
        int n = string.indexOf("::");
        if (n >= 0) {
            return string.substring(0, n);
        }
        if (string.startsWith("=")) {
            return "pdb";
        }
        Object object = this.getUnzippedBufferedReaderOrErrorMessageFromName(string, null, true, false, true, true);
        if (object instanceof BufferedReader) {
            return this.viewer.getModelAdapter().getFileTypeName(object);
        }
        if (object instanceof ZInputStream) {
            String string2 = this.getZipDirectoryAsString(string);
            if (string2.indexOf("JmolManifest") >= 0) {
                return "Jmol";
            }
            return this.viewer.getModelAdapter().getFileTypeName(JmolBinary.getBufferedReaderForString(string2));
        }
        if (Escape.isAS(object)) {
            return ((String[])object)[0];
        }
        return null;
    }

    private String getZipDirectoryAsString(String string) {
        Object object = this.getBufferedInputStreamOrErrorMessageFromName(string, string, false, false, null, false);
        return JmolBinary.getZipDirectoryAsStringAndClose((BufferedInputStream)object);
    }

    Object createAtomSetCollectionFromFile(String string, Map<String, Object> map, boolean bl) {
        int n;
        if (map.get("atomDataOnly") == null) {
            this.setLoadState(map);
        }
        String string2 = (n = (string = this.viewer.resolveDatabaseFormat(string)).indexOf("::")) >= 0 ? string.substring(n + 2) : string;
        String string3 = n >= 0 ? string.substring(0, n) : null;
        Logger.info("\nFileManager.getAtomSetCollectionFromFile(" + string2 + ")" + (string.equals(string2) ? "" : " //" + string));
        String[] stringArray = this.classifyName(string2, true);
        if (stringArray.length == 1) {
            return stringArray[0];
        }
        String string4 = stringArray[0];
        String string5 = stringArray[1];
        map.put("fullPathName", (string3 == null ? "" : string3 + "::") + string4.replace('\\', '/'));
        if (this.viewer.getBoolean(603979879) && this.viewer.getBoolean(603979824)) {
            this.viewer.scriptStatus("Requesting " + string4);
        }
        FileReader fileReader = new FileReader(this, this.viewer, string5, string4, string2, string3, null, map, bl);
        fileReader.run();
        return fileReader.getAtomSetCollection();
    }

    Object createAtomSetCollectionFromFiles(String[] stringArray, Map<String, Object> map, boolean bl) {
        this.setLoadState(map);
        String[] stringArray2 = new String[stringArray.length];
        String[] stringArray3 = new String[stringArray.length];
        String[] stringArray4 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf("::");
            String string = n >= 0 ? stringArray[i].substring(n + 2) : stringArray[i];
            String string2 = n >= 0 ? stringArray[i].substring(0, n) : null;
            String[] stringArray5 = this.classifyName(string, true);
            if (stringArray5.length == 1) {
                return stringArray5[0];
            }
            stringArray2[i] = stringArray5[0];
            stringArray[i] = stringArray5[0].replace('\\', '/');
            stringArray4[i] = string2;
            stringArray3[i] = string;
        }
        map.put("fullPathNames", stringArray2);
        map.put("fileTypes", stringArray4);
        JmolFilesReaderInterface jmolFilesReaderInterface = this.newFilesReader(stringArray2, stringArray3, stringArray4, null, map, bl);
        jmolFilesReaderInterface.run();
        return jmolFilesReaderInterface.getAtomSetCollection();
    }

    Object createAtomSetCollectionFromString(String string, SB sB, Map<String, Object> map, boolean bl, boolean bl2) {
        if (!bl2) {
            DataManager.getInlineData(sB, string, bl, this.viewer.getDefaultLoadFilter());
        }
        this.setLoadState(map);
        boolean bl3 = string.indexOf("Viewer.AddHydrogens") >= 0;
        String[] stringArray = bl3 ? this.getFileInfo() : null;
        FileReader fileReader = new FileReader(this, this.viewer, "string", "string", "string", null, JmolBinary.getBufferedReaderForString(string), map, bl);
        fileReader.run();
        if (stringArray != null) {
            this.setFileInfo(stringArray);
        }
        if (!bl && !(fileReader.getAtomSetCollection() instanceof String)) {
            this.viewer.zap(false, true, false);
            this.fileName = string == "1 0 C 0 0" ? "Jmol Model Kit" : "string";
            this.fullPathName = this.fileName;
        }
        return fileReader.getAtomSetCollection();
    }

    Object createAtomSeCollectionFromStrings(String[] stringArray, SB sB, Map<String, Object> map, boolean bl) {
        Object object;
        String[] stringArray2;
        if (!map.containsKey("isData")) {
            stringArray2 = "\"" + this.viewer.getDataSeparator() + "\"";
            object = "\"" + (bl ? "append" : "model") + " inline\"";
            SB sB2 = new SB();
            sB2.append("set dataSeparator \"~~~next file~~~\";\ndata ").append((String)object);
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    sB2.append("~~~next file~~~");
                }
                sB2.append(stringArray[i]);
            }
            sB2.append("end ").append((String)object).append(";set dataSeparator ").append((String)stringArray2);
            sB.appendSB(sB2);
        }
        this.setLoadState(map);
        Logger.info("FileManager.getAtomSetCollectionFromStrings(string[])");
        stringArray2 = new String[stringArray.length];
        object = new DataReader[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = "string[" + i + "]";
            object[i] = this.newDataReader(stringArray[i]);
        }
        JmolFilesReaderInterface jmolFilesReaderInterface = this.newFilesReader(stringArray2, stringArray2, null, (DataReader[])object, map, bl);
        jmolFilesReaderInterface.run();
        return jmolFilesReaderInterface.getAtomSetCollection();
    }

    Object createAtomSeCollectionFromArrayData(List<Object> list, Map<String, Object> map, boolean bl) {
        Logger.info("FileManager.getAtomSetCollectionFromArrayData(Vector)");
        int n = list.size();
        String[] stringArray = new String[n];
        DataReader[] dataReaderArray = new DataReader[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = "String[" + i + "]";
            dataReaderArray[i] = this.newDataReader(list.get(i));
        }
        JmolFilesReaderInterface jmolFilesReaderInterface = this.newFilesReader(stringArray, stringArray, null, dataReaderArray, map, bl);
        jmolFilesReaderInterface.run();
        return jmolFilesReaderInterface.getAtomSetCollection();
    }

    private JmolFilesReaderInterface newFilesReader(String[] stringArray, String[] stringArray2, String[] stringArray3, DataReader[] dataReaderArray, Map<String, Object> map, boolean bl) {
        JmolFilesReaderInterface jmolFilesReaderInterface = (JmolFilesReaderInterface)Interface.getOptionInterface("io2.FilesReader");
        jmolFilesReaderInterface.set(this, this.viewer, stringArray, stringArray2, stringArray3, dataReaderArray, map, bl);
        return jmolFilesReaderInterface;
    }

    private DataReader newDataReader(Object object) {
        String string;
        String string2 = object instanceof String ? "String" : (Escape.isAS(object) ? "Array" : (string = object instanceof JmolList ? "List" : null));
        if (string == null) {
            return null;
        }
        DataReader dataReader = (DataReader)Interface.getOptionInterface("io2." + string + "DataReader");
        return dataReader.setData(object);
    }

    Object createAtomSetCollectionFromDOM(Object object, Map<String, Object> map) {
        JmolDomReaderInterface jmolDomReaderInterface = (JmolDomReaderInterface)Interface.getOptionInterface("io2.DOMReadaer");
        jmolDomReaderInterface.set(this, this.viewer, object, map);
        jmolDomReaderInterface.run();
        return jmolDomReaderInterface.getAtomSetCollection();
    }

    Object createAtomSetCollectionFromReader(String string, String string2, Object object, Map<String, Object> map) {
        FileReader fileReader = new FileReader(this, this.viewer, string2, string, string2, null, object, map, false);
        fileReader.run();
        return fileReader.getAtomSetCollection();
    }

    BufferedInputStream getBufferedInputStream(String string) {
        Object object = this.getBufferedReaderOrErrorMessageFromName(string, new String[2], true, true);
        return object instanceof BufferedInputStream ? (BufferedInputStream)object : null;
    }

    public Object getBufferedInputStreamOrErrorMessageFromName(String string, String string2, boolean bl, boolean bl2, byte[] byArray, boolean bl3) {
        byte[] byArray2;
        byte[] byArray3 = byArray2 = string2 == null || this.pngjCache == null ? null : JmolBinary.getCachedPngjBytes(this, string2);
        if (byArray2 == null) {
            byArray2 = (byte[])this.cacheGet(string, true);
        }
        BufferedInputStream bufferedInputStream = null;
        Object object = null;
        String string3 = null;
        try {
            if (byArray2 == null) {
                int n;
                boolean bl4;
                boolean bl5 = string.indexOf("?POST?_PNGJBIN_") >= 0;
                boolean bl6 = bl4 = bl5 || string.indexOf("?POST?_PNGJ_") >= 0;
                if (string.indexOf("?POST?_PNG_") > 0 || bl4) {
                    Object object2 = this.viewer.getImageAs(bl4 ? "PNGJ" : "PNG", -1, 0, 0, null, null);
                    if (!Escape.isAB(object2)) {
                        return object2;
                    }
                    if (bl5) {
                        byArray = (byte[])object2;
                        string = TextFormat.simpleReplace(string, "?_", "=_");
                    } else {
                        string = new SB().append(string).append("=").appendSB(Base64.getBase64((byte[])object2)).toString();
                    }
                }
                boolean bl7 = (n = FileManager.urlTypeIndex(string)) >= 0;
                String string4 = null;
                if (bl7 && (n = string.indexOf("?POST?")) >= 0) {
                    string4 = string.substring(n + 6);
                    string = string.substring(0, n);
                }
                boolean bl8 = this.appletDocumentBaseURL != null;
                JmolFileAdapterInterface jmolFileAdapterInterface = this.viewer.getFileAdapter();
                if (bl8 || bl7) {
                    URL uRL;
                    if (bl8 && bl7 && this.appletProxy != null) {
                        string = this.appletProxy + "?url=" + this.urlEncode(string);
                    }
                    URL uRL2 = uRL = bl8 ? new URL(this.appletDocumentBaseURL, string, null) : new URL((URL)null, string, null);
                    if (bl2) {
                        return null;
                    }
                    string = uRL.toString();
                    if (bl && string.toLowerCase().indexOf("password") < 0) {
                        Logger.info("FileManager opening " + string);
                    }
                    if ((object = jmolFileAdapterInterface.getBufferedURLInputStream(uRL, byArray, string4)) instanceof SB) {
                        SB sB = (SB)object;
                        if (bl3 && !JmolBinary.isBase64(sB)) {
                            return JmolBinary.getBufferedReaderForString(sB.toString());
                        }
                        object = JmolBinary.getBISForStringXBuilder(sB);
                    } else if (Escape.isAB(object)) {
                        object = new BufferedInputStream(new ByteArrayInputStream((byte[])object));
                    }
                } else {
                    byArray2 = (byte[])this.cacheGet(string, true);
                    if (byArray2 == null) {
                        if (bl) {
                            Logger.info("FileManager opening " + string);
                        }
                        object = jmolFileAdapterInterface.getBufferedFileInputStream(string);
                    }
                }
                if (object instanceof String) {
                    return object;
                }
            }
            bufferedInputStream = byArray2 == null ? (BufferedInputStream)object : new BufferedInputStream(new ByteArrayInputStream(byArray2));
            if (bl2) {
                bufferedInputStream.close();
                bufferedInputStream = null;
            }
            return bufferedInputStream;
        }
        catch (Exception exception) {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            string3 = "" + exception;
            return string3;
        }
    }

    private String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    String[] getFullPathNameOrError(String string) {
        String[] stringArray = this.classifyName(string, true);
        if (stringArray == null || stringArray[0] == null || stringArray.length < 2) {
            return new String[]{null, "cannot read file name: " + string};
        }
        String string2 = stringArray[0];
        String string3 = stringArray[0].replace('\\', '/');
        string2 = JmolBinary.getZipRoot(string2);
        Object object = this.getBufferedInputStreamOrErrorMessageFromName(string2, string3, false, true, null, false);
        return new String[]{string3, object instanceof String ? (String)object : null};
    }

    Object getBufferedReaderOrErrorMessageFromName(String string, String[] stringArray, boolean bl, boolean bl2) {
        String[] stringArray2;
        byte[] byArray;
        Object object = this.cacheGet(string, false);
        boolean bl3 = Escape.isAB(object);
        byte[] byArray2 = byArray = bl3 ? (byte[])object : null;
        if (string.startsWith("cache://")) {
            if (object == null) {
                return "cannot read " + string;
            }
            if (bl3) {
                byArray = (byte[])object;
            } else {
                return JmolBinary.getBufferedReaderForString((String)object);
            }
        }
        if ((stringArray2 = this.classifyName(string, true)) == null) {
            return "cannot read file name: " + string;
        }
        if (stringArray != null) {
            stringArray[0] = stringArray2[0].replace('\\', '/');
        }
        return this.getUnzippedBufferedReaderOrErrorMessageFromName(stringArray2[0], byArray, false, bl, false, bl2);
    }

    public String getEmbeddedFileState(String string) {
        String[] stringArray = null;
        stringArray = this.getZipDirectory(string, false);
        if (stringArray.length == 0) {
            String string2 = this.viewer.getFileAsString4(string, Integer.MAX_VALUE, false, true);
            return string2.indexOf("**** Jmol Embedded Script ****") < 0 ? "" : JmolBinary.getEmbeddedScript(string2);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf(".spt") < 0) continue;
            String[] stringArray2 = new String[]{string + "|" + stringArray[i], null};
            this.getFileDataOrErrorAsString(stringArray2, Integer.MAX_VALUE, false, false);
            return stringArray2[1];
        }
        return "";
    }

    public Object getUnzippedBufferedReaderOrErrorMessageFromName(String string, byte[] byArray, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String[] stringArray = null;
        String[] stringArray2 = byArray == null && bl4 ? this.getSpartanFileList(string) : null;
        String string2 = string;
        if (stringArray2 != null) {
            if (bl3) {
                return stringArray2;
            }
            if (stringArray2[2] != null) {
                String string3;
                Object object;
                String string4 = stringArray2[1];
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                if (stringArray2.length == 3) {
                    object = this.getObjectAsSections(stringArray2[2], string4, hashtable);
                    hashtable.put("OUTPUT", (String)object);
                    stringArray2 = JmolBinary.spartanFileList(string, (String)hashtable.get(object));
                    if (stringArray2.length == 3) {
                        object = this.getObjectAsSections(stringArray2[2], string4, hashtable);
                        hashtable.put("OUTPUT", (String)object);
                        stringArray2 = JmolBinary.spartanFileList(stringArray2[1], (String)hashtable.get(object));
                    }
                }
                object = new SB();
                if (hashtable.get("OUTPUT") != null) {
                    ((SB)object).append((String)hashtable.get(hashtable.get("OUTPUT")));
                }
                for (int i = 2; i < stringArray2.length; ++i) {
                    string = stringArray2[i];
                    string = this.getObjectAsSections(string, string4, hashtable);
                    Logger.info("reading " + string);
                    string3 = (String)hashtable.get(string);
                    ((SB)object).append(string3);
                }
                string3 = ((SB)object).toString();
                if (this.spardirCache == null) {
                    this.spardirCache = new Hashtable<String, byte[]>();
                }
                this.spardirCache.put(string2.replace('\\', '/'), string3.getBytes());
                return JmolBinary.getBufferedReaderForString(string3);
            }
        }
        if (byArray == null && this.pngjCache != null) {
            byArray = JmolBinary.getCachedPngjBytes(this, string);
        }
        String string5 = string;
        if (string.indexOf("|") >= 0) {
            stringArray = TextFormat.splitChars(string, "|");
            if (byArray == null) {
                Logger.info("FileManager opening " + string);
            }
            string = stringArray[0];
        }
        BufferedInputStream bufferedInputStream = byArray == null ? this.getBufferedInputStreamOrErrorMessageFromName(string, string5, true, false, null, !bl2) : new BufferedInputStream(new ByteArrayInputStream(byArray));
        try {
            if (bufferedInputStream instanceof String) {
                return bufferedInputStream;
            }
            if (bufferedInputStream instanceof BufferedReader) {
                return bufferedInputStream;
            }
            BufferedInputStream bufferedInputStream2 = bufferedInputStream;
            if (JmolBinary.isGzipS(bufferedInputStream2)) {
                while (JmolBinary.isGzipS(bufferedInputStream2 = new BufferedInputStream(JmolBinary.newGZIPInputStream(bufferedInputStream2)))) {
                }
            }
            if (JmolBinary.isCompoundDocumentStream(bufferedInputStream2)) {
                JmolDocument jmolDocument = (JmolDocument)Interface.getOptionInterface("io2.CompoundDocument");
                jmolDocument.setStream(bufferedInputStream2, true);
                return JmolBinary.getBufferedReaderForString(jmolDocument.getAllDataFiles("Molecule", "Input").toString());
            }
            if (JmolBinary.isZipStream(bufferedInputStream2 = JmolBinary.checkPngZipStream(bufferedInputStream2))) {
                if (bl) {
                    return JmolBinary.newZipInputStream(bufferedInputStream2);
                }
                if (bl2) {
                    return JmolBinary.getZipFileContents(bufferedInputStream2, stringArray, 1, true);
                }
                String string6 = (String)JmolBinary.getZipFileContents(bufferedInputStream2, stringArray, 1, false);
                bufferedInputStream2.close();
                return JmolBinary.getBufferedReaderForString(string6);
            }
            return bl2 ? bufferedInputStream2 : JmolBinary.getBufferedReader(bufferedInputStream2, null);
        }
        catch (Exception exception) {
            return exception.toString();
        }
    }

    private String[] getSpartanFileList(String string) {
        if (string.endsWith(".spt")) {
            return new String[]{null, null, null};
        }
        if (string.endsWith(".spardir.zip")) {
            return new String[]{"SpartanSmol", "Directory Entry ", string + "|output"};
        }
        if (!(string = string.replace('\\', '/')).endsWith(".spardir") && string.indexOf(".spardir/") < 0) {
            return null;
        }
        int n = string.lastIndexOf(".spardir");
        if (n < 0) {
            return null;
        }
        if (string.lastIndexOf("/") > n) {
            return new String[]{"SpartanSmol", "Directory Entry ", string + "/input", string + "/archive", string + "/Molecule:asBinaryString", string + "/proparc"};
        }
        return new String[]{"SpartanSmol", "Directory Entry ", string + "/output"};
    }

    private String getObjectAsSections(String string, String string2, Map<String, String> map) {
        if (string == null) {
            return null;
        }
        String[] stringArray = null;
        boolean bl = false;
        String string3 = string.replace('\\', '/');
        if (string.indexOf(":asBinaryString") >= 0) {
            bl = true;
            string = string.substring(0, string.indexOf(":asBinaryString"));
        }
        SB sB = null;
        if (map.containsKey(string3)) {
            return string3;
        }
        if (string.indexOf("#JMOL_MODEL ") >= 0) {
            map.put(string3, string3 + "\n");
            return string3;
        }
        String string4 = string;
        if (string.indexOf("|") >= 0) {
            stringArray = TextFormat.splitChars(string, "|");
            string = stringArray[0];
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            Object object = this.getBufferedInputStreamOrErrorMessageFromName(string, string4, false, false, null, false);
            if (object instanceof String) {
                map.put(string3, (String)object + "\n");
                return string3;
            }
            bufferedInputStream = (BufferedInputStream)object;
            if (JmolBinary.isCompoundDocumentStream(bufferedInputStream)) {
                JmolDocument jmolDocument = (JmolDocument)Interface.getOptionInterface("io2.CompoundDocument");
                jmolDocument.setStream(bufferedInputStream, true);
                jmolDocument.getAllDataMapped(string.replace('\\', '/'), "Molecule", map);
            } else if (JmolBinary.isZipStream(bufferedInputStream)) {
                JmolBinary.getAllZipData(bufferedInputStream, stringArray, string.replace('\\', '/'), "Molecule", map);
            } else if (bl) {
                JmolDocument jmolDocument = (JmolDocument)Interface.getOptionInterface("io2.BinaryDocument");
                jmolDocument.setStream(bufferedInputStream, false);
                sB = new SB();
                if (string2 != null) {
                    sB.append("BEGIN Directory Entry " + string3 + "\n");
                }
                try {
                    while (true) {
                        sB.append(Integer.toHexString(jmolDocument.readByte() & 0xFF)).appendC(' ');
                    }
                }
                catch (Exception exception) {
                    sB.appendC('\n');
                    if (string2 != null) {
                        sB.append("\nEND Directory Entry " + string3 + "\n");
                    }
                    map.put(string3, sB.toString());
                }
            } else {
                String string5;
                BufferedReader bufferedReader = JmolBinary.getBufferedReader(JmolBinary.isGzipS(bufferedInputStream) ? new BufferedInputStream(JmolBinary.newGZIPInputStream(bufferedInputStream)) : bufferedInputStream, null);
                sB = new SB();
                if (string2 != null) {
                    sB.append("BEGIN Directory Entry " + string3 + "\n");
                }
                while ((string5 = bufferedReader.readLine()) != null) {
                    sB.append(string5);
                    sB.appendC('\n');
                }
                bufferedReader.close();
                if (string2 != null) {
                    sB.append("\nEND Directory Entry " + string3 + "\n");
                }
                map.put(string3, sB.toString());
            }
        }
        catch (Exception exception) {
            map.put(string3, exception.toString());
        }
        if (bufferedInputStream != null) {
            try {
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!map.containsKey(string3)) {
            map.put(string3, "FILE NOT FOUND: " + string3 + "\n");
        }
        return string3;
    }

    public String[] getZipDirectory(String string, boolean bl) {
        Object object = this.getBufferedInputStreamOrErrorMessageFromName(string, string, false, false, null, false);
        return JmolBinary.getZipDirectoryAndClose((BufferedInputStream)object, bl);
    }

    public Object getFileAsBytes(String string, OutputStream outputStream, boolean bl) {
        Object object;
        if (string == null) {
            return null;
        }
        String string2 = string;
        String[] stringArray = null;
        if (string.indexOf("|") >= 0) {
            stringArray = TextFormat.splitChars(string, "|");
            string = stringArray[0];
            bl = true;
        }
        if ((object = this.getBufferedInputStreamOrErrorMessageFromName(string, string2, false, false, null, false)) instanceof String) {
            return "Error:" + object;
        }
        try {
            BufferedInputStream bufferedInputStream = (BufferedInputStream)object;
            Object object2 = outputStream != null || stringArray == null || stringArray.length <= 1 || !bl || !JmolBinary.isZipStream(bufferedInputStream) && !JmolBinary.isPngZipStream(bufferedInputStream) ? JmolBinary.getStreamAsBytes(bufferedInputStream, outputStream) : JmolBinary.getZipFileContentsAsBytes(bufferedInputStream, stringArray, 1);
            bufferedInputStream.close();
            return object2;
        }
        catch (Exception exception) {
            return exception.toString();
        }
    }

    boolean getFileDataOrErrorAsString(String[] stringArray, int n, boolean bl, boolean bl2) {
        stringArray[1] = "";
        String string = stringArray[0];
        if (string == null) {
            return false;
        }
        Object object = this.getBufferedReaderOrErrorMessageFromName(string, stringArray, false, bl);
        if (object instanceof String) {
            stringArray[1] = (String)object;
            return false;
        }
        try {
            BufferedReader bufferedReader = (BufferedReader)object;
            SB sB = SB.newN(8192);
            if (n == Integer.MAX_VALUE) {
                String string2 = bufferedReader.readLine();
                if (bl2 || string2 != null && string2.indexOf(0) < 0 && (string2.length() != 4 || string2.charAt(0) != '\ufffd' || string2.indexOf("PNG") != 1)) {
                    sB.append(string2).appendC('\n');
                    while ((string2 = bufferedReader.readLine()) != null) {
                        sB.append(string2).appendC('\n');
                    }
                }
            } else {
                String string3;
                int n2;
                for (int i = 0; i < n && (string3 = bufferedReader.readLine()) != null; i += n2 + 1) {
                    n2 = string3.length();
                    if (n - i < n2 + 1) {
                        string3 = string3.substring(0, n - i - 1);
                    }
                    sB.append(string3).appendC('\n');
                }
            }
            bufferedReader.close();
            stringArray[1] = sB.toString();
            return true;
        }
        catch (Exception exception) {
            stringArray[1] = exception.toString();
            return false;
        }
    }

    void loadImage(String string, String string2) {
        String string3;
        Object object;
        block10: {
            ApiPlatform apiPlatform;
            Object var4_4;
            block9: {
                block13: {
                    Object object2;
                    block14: {
                        String[] stringArray;
                        block12: {
                            object = null;
                            var4_4 = null;
                            string3 = "";
                            if (string == null) break block10;
                            stringArray = this.classifyName(string, true);
                            if (stringArray != null) break block12;
                            string3 = "cannot read file name: " + string;
                            break block10;
                        }
                        apiPlatform = this.viewer.apiPlatform;
                        string3 = stringArray[0].replace('\\', '/');
                        if (string3.indexOf("|") <= 0) break block13;
                        object2 = this.getFileAsBytes(string3, null, true);
                        if (Escape.isAB(object2)) break block14;
                        string3 = "" + object2;
                        break block10;
                    }
                    object = this.viewer.isJS ? object2 : apiPlatform.createImage(object2);
                    break block9;
                }
                if (!this.viewer.isJS) {
                    if (FileManager.urlTypeIndex(string3) >= 0) {
                        try {
                            object = apiPlatform.createImage(new URL((URL)null, string3, null));
                            break block9;
                        }
                        catch (Exception exception) {
                            string3 = "bad URL: " + string3;
                            break block10;
                        }
                    }
                    object = apiPlatform.createImage(string3);
                }
            }
            if (object != null) {
                block11: {
                    try {
                        if (!apiPlatform.waitForDisplay(var4_4, object)) {
                            object = null;
                        }
                        break block11;
                    }
                    catch (Exception exception) {
                        System.out.println(exception.toString());
                        string3 = exception.toString() + " opening " + string3;
                        object = null;
                    }
                    break block10;
                }
                if (apiPlatform.getImageWidth(object) < 1) {
                    string3 = "invalid or missing image " + string3;
                    object = null;
                }
            }
        }
        this.viewer.loadImageData(object, string3, string2, null);
    }

    public static int urlTypeIndex(String string) {
        for (int i = 0; i < urlPrefixes.length; ++i) {
            if (!string.startsWith(urlPrefixes[i])) continue;
            return i;
        }
        return -1;
    }

    public static boolean isLocal(String string) {
        if (string == null) {
            return false;
        }
        int n = FileManager.urlTypeIndex(string);
        return n < 0 || n == 3;
    }

    public String[] classifyName(String string, boolean bl) {
        int n;
        String string2;
        boolean bl2;
        if (string == null) {
            return new String[]{null};
        }
        boolean bl3 = bl2 = this.pathForAllFiles.length() > 0;
        if (string.startsWith("?")) {
            if ((string = this.viewer.dialogAsk("load", string.substring(1))) == null) {
                return new String[]{bl ? "#CANCELED#" : null};
            }
            bl2 = false;
        }
        JmolFileInterface jmolFileInterface = null;
        URL uRL = null;
        String[] stringArray = null;
        if (string.startsWith("cache://")) {
            stringArray = new String[3];
            stringArray[0] = stringArray[2] = string;
            stringArray[1] = FileManager.stripPath(stringArray[0]);
            return stringArray;
        }
        if ((string = this.viewer.resolveDatabaseFormat(string)).indexOf(":") < 0 && string.indexOf("/") != 0) {
            string = FileManager.addDirectory(this.viewer.getDefaultDirectory(), string);
        }
        if (this.appletDocumentBaseURL != null) {
            try {
                if (string.indexOf(":\\") == 1 || string.indexOf(":/") == 1) {
                    string = "file:/" + string;
                }
                uRL = new URL(this.appletDocumentBaseURL, string, null);
            }
            catch (MalformedURLException malformedURLException) {
                return new String[]{bl ? malformedURLException.toString() : null};
            }
        } else if (FileManager.urlTypeIndex(string) >= 0 || this.viewer.isRestricted(Viewer.ACCESS.NONE) || this.viewer.isRestricted(Viewer.ACCESS.READSPT) && !string.endsWith(".spt") && !string.endsWith("/")) {
            try {
                uRL = new URL((URL)null, string, null);
            }
            catch (MalformedURLException malformedURLException) {
                return new String[]{bl ? malformedURLException.toString() : null};
            }
        } else {
            jmolFileInterface = this.viewer.apiPlatform.newFile(string);
            stringArray = new String[]{jmolFileInterface.getAbsolutePath(), jmolFileInterface.getName(), "file:/" + jmolFileInterface.getAbsolutePath().replace('\\', '/')};
        }
        if (uRL != null) {
            stringArray = new String[3];
            stringArray[0] = stringArray[2] = uRL.toString();
            stringArray[1] = FileManager.stripPath(stringArray[0]);
        }
        if (bl2) {
            string2 = stringArray[0];
            stringArray[0] = this.pathForAllFiles + stringArray[1];
            Logger.info("FileManager substituting " + string2 + " --> " + stringArray[0]);
        }
        if (bl && (jmolFileInterface != null || FileManager.urlTypeIndex(stringArray[0]) == 3) && (n = (string2 = jmolFileInterface == null ? TextFormat.trim(stringArray[0].substring(5), "/") : stringArray[0]).length() - stringArray[1].length() - 1) > 0) {
            string2 = string2.substring(0, n);
            FileManager.setLocalPath(this.viewer, string2, true);
        }
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String addDirectory(String string, String string2) {
        String string3;
        if (string.length() == 0) {
            return string2;
        }
        int n = string2.length() > 0 ? (int)string2.charAt(0) : 32;
        String string4 = string.toLowerCase();
        if ((string4.endsWith(".zip") || string4.endsWith(".tar")) && n != 124 && n != 47) {
            string = string + "|";
        }
        StringBuilder stringBuilder = new StringBuilder().append(string);
        if (n != 47 && n != 47) {
            char c = string.charAt(string.length() - 1);
            n = c;
            if (c != '|' && n != 47) {
                string3 = "/";
                return stringBuilder.append(string3).append(string2).toString();
            }
        }
        string3 = "";
        return stringBuilder.append(string3).append(string2).toString();
    }

    String getDefaultDirectory(String string) {
        String[] stringArray = this.classifyName(string, true);
        if (stringArray == null) {
            return "";
        }
        string = FileManager.fixPath(stringArray[0]);
        return string == null ? "" : string.substring(0, string.lastIndexOf("/"));
    }

    private static String fixPath(String string) {
        string = string.replace('\\', '/');
        int n = (string = TextFormat.simpleReplace(string, "/./", "/")).lastIndexOf("//") + 1;
        if (n < 1) {
            n = string.indexOf(":/") + 1;
        }
        if (n < 1) {
            n = string.indexOf("/");
        }
        if (n < 0) {
            return null;
        }
        String string2 = string.substring(0, n);
        string = string.substring(n);
        while ((n = string.lastIndexOf("/../")) >= 0) {
            int n2 = string.substring(0, n).lastIndexOf("/");
            if (n2 < 0) {
                return TextFormat.simpleReplace(string2 + string, "/../", "/");
            }
            string = string.substring(0, n2) + string.substring(n + 3);
        }
        if (string.length() == 0) {
            string = "/";
        }
        return string2 + string;
    }

    public String getFilePath(String string, boolean bl, boolean bl2) {
        String[] stringArray = this.classifyName(string, false);
        return stringArray == null || stringArray.length == 1 ? "" : (bl2 ? stringArray[1] : (bl ? stringArray[2] : (stringArray[0] == null ? "" : stringArray[0].replace('\\', '/'))));
    }

    public static String getLocalUrl(JmolFileInterface jmolFileInterface) {
        int n;
        if (jmolFileInterface.getName().startsWith("=")) {
            return jmolFileInterface.getName();
        }
        String string = jmolFileInterface.getAbsolutePath().replace('\\', '/');
        for (n = 0; n < urlPrefixPairs.length; ++n) {
            if (string.indexOf(urlPrefixPairs[n]) != 0) continue;
            return null;
        }
        for (n = 0; n < urlPrefixPairs.length; n += 2) {
            if (string.indexOf(urlPrefixPairs[n]) <= 0) continue;
            return urlPrefixPairs[n + 1] + TextFormat.trim(string.substring(string.indexOf(urlPrefixPairs[n]) + urlPrefixPairs[n].length()), "/");
        }
        return null;
    }

    public static JmolFileInterface getLocalDirectory(JmolViewer jmolViewer, boolean bl) {
        JmolFileInterface jmolFileInterface;
        String string = (String)jmolViewer.getParameter(bl ? "currentLocalPath" : "defaultDirectoryLocal");
        if (bl && string.length() == 0) {
            string = (String)jmolViewer.getParameter("defaultDirectoryLocal");
        }
        if (string.length() == 0) {
            return jmolViewer.isApplet() ? null : jmolViewer.apiPlatform.newFile(System.getProperty("user.dir", "."));
        }
        if (jmolViewer.isApplet() && string.indexOf("file:/") == 0) {
            string = string.substring(6);
        }
        return (jmolFileInterface = jmolViewer.apiPlatform.newFile(string)).isDirectory() ? jmolFileInterface : jmolFileInterface.getParentAsFile();
    }

    public static void setLocalPath(JmolViewer jmolViewer, String string, boolean bl) {
        while (string.endsWith("/") || string.endsWith("\\")) {
            string = string.substring(0, string.length() - 1);
        }
        jmolViewer.setStringProperty("currentLocalPath", string);
        if (!bl) {
            jmolViewer.setStringProperty("defaultDirectoryLocal", string);
        }
    }

    public static String getLocalPathForWritingFile(JmolViewer jmolViewer, String string) {
        if (string.indexOf("file:/") == 0) {
            return string.substring(6);
        }
        if (string.indexOf("/") == 0 || string.indexOf(":") >= 0) {
            return string;
        }
        JmolFileInterface jmolFileInterface = FileManager.getLocalDirectory(jmolViewer, false);
        return jmolFileInterface == null ? string : FileManager.fixPath(jmolFileInterface.toString() + "/" + string);
    }

    public static String setScriptFileReferences(String string, String string2, String string3, String string4) {
        if (string2 != null) {
            string = FileManager.setScriptFileRefs(string, string2, true);
        }
        if (string3 != null) {
            string = FileManager.setScriptFileRefs(string, string3, false);
        }
        string = TextFormat.simpleReplace(string, "\u0001\"", "\"");
        if (string4 != null) {
            while (string4.endsWith("/")) {
                string4 = string4.substring(0, string4.length() - 1);
            }
            for (int i = 0; i < scriptFilePrefixes.length; ++i) {
                String string5 = scriptFilePrefixes[i];
                string = TextFormat.simpleReplace(string, string5 + ".", string5 + string4);
            }
        }
        return string;
    }

    private static String setScriptFileRefs(String string, String string2, boolean bl) {
        if (string2 == null) {
            return string;
        }
        boolean bl2 = string2.length() == 0;
        JmolList<String> jmolList = new JmolList<String>();
        JmolBinary.getFileReferences(string, jmolList);
        JmolList<String> jmolList2 = new JmolList<String>();
        JmolList<String> jmolList3 = new JmolList<String>();
        int n = jmolList.size();
        for (int i = 0; i < n; ++i) {
            String string3 = (String)jmolList.get(i);
            String string4 = string3;
            if (bl == FileManager.isLocal(string4)) {
                int n2;
                int n3 = n2 = bl2 ? -1 : string4.indexOf("/" + string2 + "/");
                if (n2 >= 0) {
                    string4 = string4.substring(n2 + 1);
                } else {
                    n2 = string4.lastIndexOf("/");
                    if (n2 < 0 && !bl2) {
                        string4 = "/" + string4;
                    }
                    if (n2 < 0 || bl2) {
                        ++n2;
                    }
                    string4 = string2 + string4.substring(n2);
                }
            }
            Logger.info("FileManager substituting " + string3 + " --> " + string4);
            jmolList2.addLast("\"" + string3 + "\"");
            jmolList3.addLast("\u0001\"" + string4 + "\"");
        }
        return TextFormat.replaceStrings(string, jmolList2, jmolList3);
    }

    public static String stripPath(String string) {
        int n = Math.max(string.lastIndexOf("|"), string.lastIndexOf("/"));
        return string.substring(n + 1);
    }

    public static String fixFileNameVariables(String string, String string2) {
        String string3 = TextFormat.simpleReplace(string, "%FILE", string2);
        if (string3.indexOf("%LC") < 0) {
            return string3;
        }
        string2 = string2.toLowerCase();
        string3 = TextFormat.simpleReplace(string3, "%LCFILE", string2);
        if (string2.length() == 4) {
            string3 = TextFormat.simpleReplace(string3, "%LC13", string2.substring(1, 3));
        }
        return string3;
    }

    public void clearPngjCache(String string) {
        if (string == null || this.pngjCache != null && this.pngjCache.containsKey(this.getCanonicalName(JmolBinary.getZipRoot(string)))) {
            this.pngjCache = null;
        }
    }

    void cachePut(String string, Object object) {
        string = string.replace('\\', '/');
        if (Logger.debugging) {
            Logger.info("cachePut " + string);
        }
        if (object == null || object.equals("")) {
            this.cache.remove(string);
        } else {
            this.cache.put(string, object);
        }
    }

    public Object cacheGet(String string, boolean bl) {
        string = string.replace('\\', '/');
        if (Logger.debugging && this.cache.containsKey(string)) {
            Logger.info("cacheGet " + string);
        }
        Object object = this.cache.get(string);
        return bl && object instanceof String ? null : object;
    }

    void cacheClear() {
        this.cache.clear();
    }

    public int cacheFileByNameAdd(String string, boolean bl) {
        Object object;
        if (string == null || !bl && string.equalsIgnoreCase("")) {
            this.cacheClear();
            return -1;
        }
        if (bl) {
            object = this.getFileAsBytes(string = this.viewer.resolveDatabaseFormat(string), null, true);
            if (object instanceof String) {
                return 0;
            }
            this.cachePut(string, object);
        } else {
            object = this.cache.remove(string.replace('\\', '/'));
        }
        return object == null ? 0 : (object instanceof String ? ((String)object).length() : ((byte[])object).length);
    }

    Map<String, Integer> cacheList() {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        for (Map.Entry<String, Object> entry : this.cache.entrySet()) {
            hashtable.put(entry.getKey(), Escape.isAB(entry.getValue()) ? ((byte[])entry.getValue()).length : entry.getValue().toString().length());
        }
        return hashtable;
    }

    public String getCanonicalName(String string) {
        String[] stringArray = this.classifyName(string, true);
        return stringArray == null ? string : stringArray[2];
    }
}

