/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import org.jmol.util.ArrayUtil;
import org.jmol.util.C;
import org.jmol.util.ColorUtil;
import org.jmol.util.Matrix4f;
import org.jmol.util.V3;

public class Shader {
    private static int shadeIndexMax = 64;
    public static int shadeIndexLast = shadeIndexMax - 1;
    public static byte shadeIndexNormal = (byte)52;
    public static byte shadeIndexNoisyLimit = (byte)56;
    private float xLight;
    private float yLight;
    private float zLight;
    V3 lightSource = new V3();
    public boolean specularOn = true;
    public boolean usePhongExponent = false;
    public int ambientPercent = 45;
    public int diffusePercent = 84;
    public int specularExponent = 6;
    public int specularPercent = 22;
    public int specularPower = 40;
    public int phongExponent = 64;
    public float ambientFraction = (float)this.ambientPercent / 100.0f;
    public float diffuseFactor = (float)this.diffusePercent / 100.0f;
    public float intenseFraction = (float)this.specularPower / 100.0f;
    public float specularFactor = (float)this.specularPercent / 100.0f;
    private int[][] ashades = ArrayUtil.newInt2(128);
    private int[][] ashadesGreyscale;
    private int rgbContrast;
    public boolean sphereShadingCalculated = false;
    public byte[] sphereShadeIndexes = new byte[65536];
    private int seed = 305419897;
    private static final int SLIM = 20;
    private static final int SDIM = 40;
    public static final int maxSphereCache = 128;
    public int[][] sphereShapeCache = ArrayUtil.newInt2(128);
    public byte[][][] ellipsoidShades;
    public int nOut;
    public int nIn;
    private boolean celOn;

    public Shader() {
        this.setLightSource(-1.0f, -1.0f, 2.5f);
    }

    private void setLightSource(float f, float f2, float f3) {
        this.lightSource.set(f, f2, f3);
        this.lightSource.normalize();
        this.xLight = this.lightSource.x;
        this.yLight = this.lightSource.y;
        this.zLight = this.lightSource.z;
    }

    public void setCel(boolean bl, int n) {
        if ((n = C.getArgb(ColorUtil.getBgContrast(n))) == -16777216) {
            n = -16514044;
        }
        if (this.celOn == bl && this.rgbContrast == n) {
            return;
        }
        this.celOn = bl;
        this.rgbContrast = n;
        this.flushCaches();
    }

    public void flushCaches() {
        this.flushShades();
        this.flushSphereCache();
    }

    public boolean getCelOn() {
        return this.celOn;
    }

    public void setLastColix(int n, boolean bl) {
        C.allocateColix(n);
        this.checkShades();
        if (bl) {
            C.setLastGrey(n);
        }
        this.ashades[2047] = this.getShades2(n, false);
    }

    public int[] getShades(short s) {
        this.checkShades();
        s = (short)(s & 0xFFFF87FF);
        int[] nArray = this.ashades[s];
        if (nArray == null) {
            this.ashades[s] = this.getShades2(C.argbs[s], false);
            nArray = this.ashades[s];
        }
        return nArray;
    }

    public int[] getShadesG(short s) {
        int[] nArray;
        this.checkShades();
        s = (short)(s & 0xFFFF87FF);
        if (this.ashadesGreyscale == null) {
            this.ashadesGreyscale = ArrayUtil.newInt2(this.ashades.length);
        }
        if ((nArray = this.ashadesGreyscale[s]) == null) {
            this.ashadesGreyscale[s] = this.getShades2(C.argbs[s], true);
            nArray = this.ashadesGreyscale[s];
        }
        return nArray;
    }

    private void checkShades() {
        if (this.ashades != null && this.ashades.length == C.colixMax) {
            return;
        }
        this.ashades = ArrayUtil.arrayCopyII(this.ashades, C.colixMax);
        if (this.ashadesGreyscale != null) {
            this.ashadesGreyscale = ArrayUtil.arrayCopyII(this.ashadesGreyscale, C.colixMax);
        }
    }

    public void flushShades() {
        this.checkShades();
        int n = C.colixMax;
        while (--n >= 0) {
            this.ashades[n] = null;
        }
        this.sphereShadingCalculated = false;
    }

    private int[] getShades2(int n, boolean bl) {
        int n2;
        float f;
        float f2;
        int[] nArray = new int[shadeIndexMax];
        if (n == 0) {
            return nArray;
        }
        float f3 = n >> 16 & 0xFF;
        float f4 = n >> 8 & 0xFF;
        float f5 = n & 0xFF;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = this.ambientFraction;
        while (true) {
            f6 = f3 * f9 + 0.5f;
            f7 = f4 * f9 + 0.5f;
            f8 = f5 * f9 + 0.5f;
            if (!(f9 > 0.0f) || !(f6 < 4.0f) || !(f7 < 4.0f) || !(f8 < 4.0f)) break;
            f3 += 1.0f;
            f4 += 1.0f;
            f5 += 1.0f;
            if (f9 < 0.1f) {
                f9 += 0.1f;
            }
            n = ColorUtil.rgb((int)Math.floor(f3), (int)Math.floor(f4), (int)Math.floor(f5));
        }
        if (this.celOn) {
            int n3 = shadeIndexMax / 2;
            f9 = (1.0f - f9) / (float)shadeIndexNormal;
            f2 = f3 * f9;
            f = f4 * f9;
            float f10 = f5 * f9;
            int n4 = ColorUtil.rgb((int)Math.floor(f6), (int)Math.floor(f7), (int)Math.floor(f8));
            for (n2 = 0; n2 < n3; ++n2) {
                nArray[n2] = n4;
            }
            n4 = ColorUtil.rgb((int)Math.floor(f6 += f2 * (float)n3), (int)Math.floor(f7 += f * (float)n3), (int)Math.floor(f8 += f10 * (float)n3));
            while (n2 < shadeIndexMax) {
                nArray[n2] = n4;
                ++n2;
            }
            nArray[0] = nArray[1] = this.rgbContrast;
        } else {
            f9 = (1.0f - f9) / (float)shadeIndexNormal;
            float f11 = f3 * f9;
            f2 = f4 * f9;
            f = f5 * f9;
            for (n2 = 0; n2 < shadeIndexNormal; ++n2) {
                nArray[n2] = ColorUtil.rgb((int)Math.floor(f6), (int)Math.floor(f7), (int)Math.floor(f8));
                f6 += f11;
                f7 += f2;
                f8 += f;
            }
            nArray[n2++] = n;
            f9 = this.intenseFraction / (float)(shadeIndexMax - n2);
            f11 = (255.5f - f6) * f9;
            f2 = (255.5f - f7) * f9;
            f = (255.5f - f8) * f9;
            while (n2 < shadeIndexMax) {
                nArray[n2] = ColorUtil.rgb((int)Math.floor(f6 += f11), (int)Math.floor(f7 += f2), (int)Math.floor(f8 += f));
                ++n2;
            }
        }
        if (bl) {
            while (--n2 >= 0) {
                nArray[n2] = ColorUtil.calcGreyscaleRgbFromRgb(nArray[n2]);
            }
        }
        return nArray;
    }

    public int getShadeIndex(float f, float f2, float f3) {
        double d = Math.sqrt(f * f + f2 * f2 + f3 * f3);
        return Math.round(this.getShadeF((float)((double)f / d), (float)((double)f2 / d), (float)((double)f3 / d)) * (float)shadeIndexLast);
    }

    public byte getShadeB(float f, float f2, float f3) {
        return (byte)Math.round(this.getShadeF(f, f2, f3) * (float)shadeIndexLast);
    }

    public int getShadeFp8(float f, float f2, float f3) {
        double d = Math.sqrt(f * f + f2 * f2 + f3 * f3);
        return (int)Math.floor(this.getShadeF((float)((double)f / d), (float)((double)f2 / d), (float)((double)f3 / d)) * (float)shadeIndexLast * 256.0f);
    }

    private float getShadeF(float f, float f2, float f3) {
        float f4;
        float f5 = f * this.xLight + f2 * this.yLight + f3 * this.zLight;
        if (f5 <= 0.0f) {
            return 0.0f;
        }
        float f6 = f5 * this.diffuseFactor;
        if (this.specularOn && (f4 = 2.0f * f5 * f3 - this.zLight) > 0.0f) {
            if (this.usePhongExponent) {
                f4 = (float)Math.pow(f4, this.phongExponent);
            } else {
                int n = this.specularExponent;
                while (--n >= 0 && f4 > 1.0E-4f) {
                    f4 *= f4;
                }
            }
            f6 += f4 * this.specularFactor;
        }
        return this.celOn && f3 < 0.5f ? 0.0f : (f6 > 1.0f ? 1.0f : f6);
    }

    public byte getShadeN(float f, float f2, float f3, float f4) {
        int n;
        int n2 = (int)Math.floor(this.getShadeF(f / f4, f2 / f4, f3 / f4) * (float)shadeIndexLast * 256.0f);
        int n3 = n2 >> 8;
        if ((n2 & 0xFF) > this.nextRandom8Bit()) {
            ++n3;
        }
        if ((n = this.seed & 0xFFFF) < 21845 && n3 > 0) {
            --n3;
        } else if (n > 43690 && n3 < shadeIndexLast) {
            ++n3;
        }
        return (byte)n3;
    }

    public synchronized void calcSphereShading() {
        float f = -127.5f;
        for (int i = 0; i < 256; ++i) {
            float f2 = -127.5f;
            for (int j = 0; j < 256; ++j) {
                byte by = 0;
                float f3 = 16900.0f - f * f - f2 * f2;
                if (f3 > 0.0f) {
                    float f4 = (float)Math.sqrt(f3);
                    by = this.getShadeN(f, f2, f4, 130.0f);
                }
                this.sphereShadeIndexes[(j << 8) + i] = by;
                f2 += 1.0f;
            }
            f += 1.0f;
        }
        this.sphereShadingCalculated = true;
    }

    public int nextRandom8Bit() {
        int n = this.seed;
        this.seed = n = (n << 16) + (n << 1) + n & Integer.MAX_VALUE;
        return n >> 23;
    }

    public int getEllipsoidShade(float f, float f2, float f3, int n, Matrix4f matrix4f) {
        boolean bl;
        float f4 = matrix4f.m00 * f + matrix4f.m01 * f2 + matrix4f.m02 * f3 + matrix4f.m03;
        float f5 = matrix4f.m10 * f + matrix4f.m11 * f2 + matrix4f.m12 * f3 + matrix4f.m13;
        float f6 = matrix4f.m20 * f + matrix4f.m21 * f2 + matrix4f.m22 * f3 + matrix4f.m23;
        float f7 = Math.min((float)n / 2.0f, 45.0f) / (float)Math.sqrt(f4 * f4 + f5 * f5 + f6 * f6);
        int n2 = (int)(-f4 * f7);
        int n3 = (int)(-f5 * f7);
        int n4 = (int)(f6 * f7);
        boolean bl2 = bl = n2 < -20 || n2 >= 20 || n3 < -20 || n3 >= 20 || n4 < 0 || n4 >= 40;
        if (bl) {
            while (n2 % 2 == 0 && n3 % 2 == 0 && n4 % 2 == 0 && n2 + n3 + n4 > 0) {
                n2 >>= 1;
                n3 >>= 1;
                n4 >>= 1;
            }
            boolean bl3 = bl = n2 < -20 || n2 >= 20 || n3 < -20 || n3 >= 20 || n4 < 0 || n4 >= 40;
        }
        if (bl) {
            ++this.nOut;
        } else {
            ++this.nIn;
        }
        return bl ? this.getShadeIndex(n2, n3, n4) : this.ellipsoidShades[n2 + 20][n3 + 20][n4];
    }

    public void createEllipsoidShades() {
        this.ellipsoidShades = new byte[40][40][40];
        for (int i = 0; i < 40; ++i) {
            for (int j = 0; j < 40; ++j) {
                for (int k = 0; k < 40; ++k) {
                    this.ellipsoidShades[i][j][k] = (byte)this.getShadeIndex(i - 20, j - 20, k);
                }
            }
        }
    }

    public synchronized void flushSphereCache() {
        int n = 128;
        while (--n >= 0) {
            this.sphereShapeCache[n] = null;
        }
        this.ellipsoidShades = null;
    }
}

