/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jmol.atomdata.RadiusData;
import org.jmol.constant.EnumVdw;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.MeasurementData;
import org.jmol.script.SV;
import org.jmol.script.ScriptEvaluator;
import org.jmol.script.ScriptException;
import org.jmol.script.T;
import org.jmol.util.ArrayUtil;
import org.jmol.util.AxisAngle4f;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.BoxInfo;
import org.jmol.util.ColorEncoder;
import org.jmol.util.ColorUtil;
import org.jmol.util.Escape;
import org.jmol.util.JmolList;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.Matrix3f;
import org.jmol.util.Matrix4f;
import org.jmol.util.Measure;
import org.jmol.util.P3;
import org.jmol.util.P4;
import org.jmol.util.Parser;
import org.jmol.util.Point3fi;
import org.jmol.util.Quaternion;
import org.jmol.util.SB;
import org.jmol.util.TextFormat;
import org.jmol.util.Tuple3f;
import org.jmol.util.V3;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ScriptMathProcessor {
    private boolean isSyntaxCheck;
    private boolean wasSyntaxCheck;
    private boolean logMessages;
    private ScriptEvaluator eval;
    private Viewer viewer;
    private T[] oStack = new T[8];
    private SV[] xStack = new SV[8];
    private char[] ifStack = new char[8];
    private int ifPt = -1;
    private int oPt = -1;
    private int xPt = -1;
    private int parenCount;
    private int squareCount;
    private int braceCount;
    private boolean wasX;
    private int incrementX;
    private boolean isArrayItem;
    private boolean asVector;
    private boolean asBitSet;
    private int ptid = 0;
    private int ptx = Integer.MAX_VALUE;
    private boolean skipping;
    private boolean haveSpaceBeforeSquare;
    private int equalCount;

    ScriptMathProcessor(ScriptEvaluator scriptEvaluator, boolean bl, boolean bl2, boolean bl3) {
        this.eval = scriptEvaluator;
        this.viewer = scriptEvaluator.viewer;
        this.logMessages = scriptEvaluator.logMessages;
        this.isSyntaxCheck = this.wasSyntaxCheck = scriptEvaluator.chk;
        this.isArrayItem = bl;
        this.asVector = bl2 || bl;
        this.asBitSet = bl3;
        this.wasX = bl;
        if (this.logMessages) {
            Logger.info("initialize RPN");
        }
    }

    SV getResult(boolean bl) throws ScriptException {
        boolean bl2 = true;
        while (bl2 && this.oPt >= 0) {
            bl2 = this.operate();
        }
        if (bl2) {
            if (this.asVector) {
                JmolList<SV> jmolList = new JmolList<SV>();
                for (int i = 0; i <= this.xPt; ++i) {
                    jmolList.addLast(SV.selectItemVar(this.xStack[i]));
                }
                return SV.newVariable(135198, jmolList);
            }
            if (this.xPt == 0) {
                SV sV = this.xStack[0];
                if (sV.tok == 10 || sV.tok == 7 || sV.tok == 4 || sV.tok == 11 || sV.tok == 12) {
                    sV = SV.selectItemVar(sV);
                }
                if (this.asBitSet && sV.tok == 7) {
                    sV = SV.newVariable(10, SV.unEscapeBitSetArray((JmolList)sV.value, false));
                }
                return sV;
            }
        }
        if (!(bl || this.xPt < 0 && this.oPt < 0)) {
            this.eval.error(22);
        }
        return null;
    }

    private void putX(SV sV) {
        if (this.skipping) {
            return;
        }
        if (++this.xPt == this.xStack.length) {
            this.xStack = (SV[])ArrayUtil.doubleLength(this.xStack);
        }
        if (this.logMessages) {
            Logger.info("\nputX: " + sV);
        }
        this.xStack[this.xPt] = sV;
        this.ptx = ++this.ptid;
    }

    private void putOp(T t) {
        if (++this.oPt >= this.oStack.length) {
            this.oStack = (T[])ArrayUtil.doubleLength(this.oStack);
        }
        this.oStack[this.oPt] = t;
        ++this.ptid;
    }

    private void putIf(char c) {
        if (++this.ifPt >= this.ifStack.length) {
            this.ifStack = (char[])ArrayUtil.doubleLength(this.ifStack);
        }
        this.ifStack[this.ifPt] = c;
    }

    boolean addXVar(SV sV) {
        this.putX(sV);
        this.wasX = true;
        return true;
    }

    boolean addXObj(Object object) {
        SV sV = SV.getVariable(object);
        if (sV == null) {
            return false;
        }
        this.putX(sV);
        this.wasX = true;
        return true;
    }

    boolean addXStr(String string) {
        this.putX(SV.newVariable(4, string));
        this.wasX = true;
        return true;
    }

    private boolean addXBool(boolean bl) {
        this.putX(SV.getBoolean(bl));
        this.wasX = true;
        return true;
    }

    private boolean addXInt(int n) {
        this.putX(SV.newScriptVariableInt(n));
        this.wasX = true;
        return true;
    }

    private boolean addXList(JmolList<?> jmolList) {
        this.putX(SV.getVariableList(jmolList));
        this.wasX = true;
        return true;
    }

    private boolean addXMap(Map<String, ?> map) {
        this.putX(SV.getVariableMap(map));
        this.wasX = true;
        return true;
    }

    private boolean addXM3(Matrix3f matrix3f) {
        this.putX(SV.newVariable(11, matrix3f));
        this.wasX = true;
        return true;
    }

    private boolean addXM4(Matrix4f matrix4f) {
        this.putX(SV.newVariable(12, matrix4f));
        this.wasX = true;
        return true;
    }

    private boolean addXFloat(float f) {
        if (Float.isNaN(f)) {
            return this.addXStr("NaN");
        }
        this.putX(SV.newVariable(3, Float.valueOf(f)));
        this.wasX = true;
        return true;
    }

    boolean addXBs(BS bS) {
        this.putX(SV.newVariable(10, bS));
        this.wasX = true;
        return true;
    }

    boolean addXPt(P3 p3) {
        this.putX(SV.newVariable(8, p3));
        this.wasX = true;
        return true;
    }

    boolean addXPt4(P4 p4) {
        this.putX(SV.newVariable(9, p4));
        this.wasX = true;
        return true;
    }

    boolean addXNum(SV sV) throws ScriptException {
        if (this.wasX) {
            switch (sV.tok) {
                case 2: {
                    if (sV.intValue >= 0) break;
                    this.addOp(T.tokenMinus);
                    sV = SV.newScriptVariableInt(-sV.intValue);
                    break;
                }
                case 3: {
                    float f = ((Float)sV.value).floatValue();
                    if (!(f < 0.0f) && (f != 0.0f || 1.0f / f != Float.NEGATIVE_INFINITY)) break;
                    this.addOp(T.tokenMinus);
                    sV = SV.newVariable(3, Float.valueOf(-f));
                }
            }
        }
        this.putX(sV);
        this.wasX = true;
        return true;
    }

    boolean addXAV(SV[] sVArray) {
        this.putX(SV.getVariableAV(sVArray));
        this.wasX = true;
        return true;
    }

    boolean addXAD(double[] dArray) {
        this.putX(SV.getVariableAD(dArray));
        this.wasX = true;
        return true;
    }

    boolean addXAS(String[] stringArray) {
        this.putX(SV.getVariableAS(stringArray));
        this.wasX = true;
        return true;
    }

    boolean addXAI(int[] nArray) {
        this.putX(SV.getVariableAI(nArray));
        this.wasX = true;
        return true;
    }

    boolean addXAII(int[][] nArray) {
        this.putX(SV.getVariableAII(nArray));
        this.wasX = true;
        return true;
    }

    boolean addXAF(float[] fArray) {
        this.putX(SV.getVariableAF(fArray));
        this.wasX = true;
        return true;
    }

    boolean addXAFF(float[][] fArray) {
        this.putX(SV.getVariableAFF(fArray));
        this.wasX = true;
        return true;
    }

    private static boolean isOpFunc(T t) {
        return T.tokAttr(t.tok, 0x8100000) && t != T.tokenArraySquare || t.tok == 0x101000D1 && T.tokAttr(t.intValue, 0x8100000);
    }

    boolean addOp(T t) throws ScriptException {
        return this.addOpAllowMath(t, true);
    }

    boolean addOpAllowMath(T t, boolean bl) throws ScriptException {
        boolean bl2;
        boolean bl3;
        if (this.logMessages) {
            Logger.info("addOp entry\naddOp: " + t);
        }
        int n = this.oPt >= 0 ? this.oStack[this.oPt].tok : 0;
        boolean bl4 = this.skipping = this.ifPt >= 0 && (this.ifStack[this.ifPt] == 'F' || this.ifStack[this.ifPt] == 'X');
        if (this.skipping) {
            switch (t.tok) {
                case 0x10100010: {
                    this.putOp(t);
                    return true;
                }
                case 0x10100022: {
                    if (n != 0x10100022 || this.ifStack[this.ifPt] == 'X') {
                        return true;
                    }
                    this.ifStack[this.ifPt] = 84;
                    this.wasX = false;
                    this.skipping = false;
                    return true;
                }
                case 0x10100011: {
                    if (n == 0x10100010) {
                        --this.oPt;
                        return true;
                    }
                    if (n != 0x10100022) {
                        this.putOp(t);
                        return true;
                    }
                    this.wasX = true;
                    --this.ifPt;
                    this.oPt -= 2;
                    this.skipping = false;
                    return true;
                }
            }
            return true;
        }
        T t2 = null;
        boolean bl5 = false;
        boolean bl6 = bl3 = t.tok == 0x101000D1;
        if (bl3 && !this.wasX) {
            return false;
        }
        boolean bl7 = bl2 = bl && ScriptMathProcessor.isOpFunc(t);
        if (this.oPt >= 1 && t.tok != 0x10100010 && n == 135266319) {
            n = this.oStack[--this.oPt].tok;
        }
        boolean bl8 = this.oPt >= 1 && n == 0x10100010;
        switch (t.tok) {
            case 1073742195: {
                this.haveSpaceBeforeSquare = true;
                return true;
            }
            case 0x10100030: {
                if (this.wasX) break;
                return false;
            }
            case 32: 
            case 64: 
            case 96: 
            case 128: 
            case 160: 
            case 192: 
            case 480: {
                int n2;
                int n3 = n2 = this.oPt < 0 ? 0 : n;
                if (!this.wasX || n2 != 0x101000D1 && n2 != 1678770178 && n2 != 0x44100001) {
                    return false;
                }
                this.oStack[this.oPt].intValue |= t.tok;
                return true;
            }
            case 0x10100040: {
                bl5 = true;
                if (this.wasX && !this.haveSpaceBeforeSquare) break;
                ++this.squareCount;
                t = t2 = T.tokenArraySquare;
                this.haveSpaceBeforeSquare = false;
                break;
            }
            case 0x10100041: {
                break;
            }
            case 0x101000C1: 
            case 269484226: {
                int n4 = this.incrementX = t.tok == 269484226 ? 1 : -1;
                if (this.ptid != this.ptx) break;
                if (this.isSyntaxCheck) {
                    return true;
                }
                SV sV = this.xStack[this.xPt];
                this.xStack[this.xPt] = SV.newVariable(4, "").setv(sV, false);
                return sV.increment(this.incrementX);
            }
            case 0x101000A0: {
                if (this.wasX) break;
                this.addXInt(0);
                t = SV.newVariable(0x101000C0, "-");
                break;
            }
            case 0x10100011: {
                if (this.wasX || this.oPt < 1 || n != 0x10100010 || ScriptMathProcessor.isOpFunc(this.oStack[this.oPt - 1])) break;
                return false;
            }
            case 0x10100010: 
            case 0x10100070: {
                bl5 = true;
            }
            default: {
                if (bl2) {
                    if (!bl3 && this.wasX && !bl8) {
                        return false;
                    }
                    t2 = t;
                    bl5 = true;
                    break;
                }
                if (this.wasX != bl5 || n == 0x101000D1) break;
                return false;
            }
        }
        while (!(this.oPt < 0 || n == 0x10100022 || bl5 && (n != 0x101000D1 || t.tok != 0x101000D1 && t.tok != 0x10100040) || T.getPrecedence(n) < T.getPrecedence(t.tok))) {
            if (this.logMessages) {
                Logger.info("\noperating, oPt=" + this.oPt + " isLeftOp=" + bl5 + " oStack[oPt]=" + T.nameOf(n) + "        prec=" + T.getPrecedence(n) + " pending op=\"" + T.nameOf(t.tok) + "\" prec=" + T.getPrecedence(t.tok));
                this.dumpStacks("operating");
            }
            if (t.tok == 0x10100011 && n == 0x10100010) {
                if (this.xPt < 0) break;
                this.xStack[this.xPt] = SV.selectItemVar(this.xStack[this.xPt]);
                break;
            }
            if (t.tok == 0x10100041 && n == 135266306) break;
            if (t.tok == 0x10100041 && n == 0x10100040) {
                if (this.isArrayItem && this.squareCount == 1 && this.equalCount == 0) {
                    this.addXVar(SV.newScriptVariableToken(T.tokenArraySelector));
                    break;
                }
                if (this.doBitsetSelect()) break;
                return false;
            }
            if (!this.operate()) {
                return false;
            }
            n = this.oPt >= 0 ? this.oStack[this.oPt].tok : 0;
        }
        if (t2 != null) {
            this.addXVar(SV.newVariable(269484436, t2));
        }
        switch (t.tok) {
            case 0x10100010: {
                ++this.parenCount;
                this.wasX = false;
                break;
            }
            case 806354977: {
                boolean bl9 = this.getX().asBoolean();
                if (n == 0x10100022) {
                    --this.ifPt;
                } else {
                    this.putOp(T.tokenColon);
                }
                this.putIf(bl9 ? (char)'T' : 'F');
                this.skipping = !bl9;
                this.wasX = false;
                return true;
            }
            case 0x10100022: {
                if (n != 0x10100022) {
                    return false;
                }
                if (this.ifPt < 0) {
                    return false;
                }
                this.ifStack[this.ifPt] = 88;
                this.wasX = false;
                this.skipping = true;
                return true;
            }
            case 0x10100011: {
                this.wasX = true;
                if (this.parenCount-- <= 0) {
                    return false;
                }
                if (n == 0x10100022) {
                    --this.ifPt;
                    --this.oPt;
                }
                --this.oPt;
                if (this.oPt < 0) {
                    return true;
                }
                if (ScriptMathProcessor.isOpFunc(this.oStack[this.oPt]) && !this.evaluateFunction(0)) {
                    return false;
                }
                this.skipping = this.ifPt >= 0 && this.ifStack[this.ifPt] == 'X';
                return true;
            }
            case 0x10100030: {
                this.wasX = false;
                return true;
            }
            case 0x10100040: {
                ++this.squareCount;
                this.wasX = false;
                break;
            }
            case 0x10100041: {
                this.wasX = true;
                if (this.squareCount-- <= 0 || this.oPt < 0) {
                    return false;
                }
                if (this.oStack[this.oPt].tok == 135266306) {
                    return this.evaluateFunction(0x10100040);
                }
                --this.oPt;
                return true;
            }
            case 0x101000D1: {
                this.wasX = !bl || !T.tokAttr(t.intValue, 0x8100000);
                break;
            }
            case 0x10000A: {
                ++this.braceCount;
                this.wasX = false;
                break;
            }
            case 0x10000E: {
                if (this.braceCount-- <= 0) {
                    return false;
                }
                this.wasX = false;
                break;
            }
            case 0x10100050: 
            case 0x10100060: {
                if (!this.wasSyntaxCheck && this.xPt < 0) {
                    return false;
                }
                if (!this.wasSyntaxCheck && this.xStack[this.xPt].tok != 10 && this.xStack[this.xPt].tok != 7) {
                    boolean bl10 = this.getX().asBoolean();
                    this.addXVar(SV.getBoolean(bl10));
                    if (bl10 == (t.tok == 0x10100050)) {
                        this.isSyntaxCheck = true;
                        t = t.tok == 0x10100050 ? T.tokenOrTRUE : T.tokenAndFALSE;
                    }
                }
                this.wasX = false;
                break;
            }
            case 269484436: {
                if (this.squareCount == 0) {
                    ++this.equalCount;
                }
                this.wasX = false;
                break;
            }
            default: {
                this.wasX = false;
            }
        }
        this.putOp(t);
        if (t.tok == 0x101000D1 && (t.intValue & 0xFFFFFE1F) == 135368713 && t.intValue != 135368713) {
            return this.evaluateFunction(0);
        }
        return true;
    }

    private boolean doBitsetSelect() {
        if (this.xPt < 0 || this.xPt == 0 && !this.isArrayItem) {
            return false;
        }
        SV sV = this.xStack[this.xPt--];
        SV sV2 = this.xStack[this.xPt];
        if (sV2.tok == 7 && sV.tok == 4 && sV2.intValue != Integer.MAX_VALUE) {
            sV2 = SV.selectItemVar2(sV2, Integer.MIN_VALUE);
        }
        if (sV2.tok == 6) {
            SV sV3 = sV2.mapValue(SV.sValue(sV));
            this.xStack[this.xPt] = sV3 == null ? SV.newVariable(4, "") : sV3;
            return true;
        }
        int n = sV.asInt();
        switch (sV2.tok) {
            default: {
                sV2 = SV.newVariable(4, SV.sValue(sV2));
            }
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
        }
        this.xStack[this.xPt] = SV.selectItemVar2(sV2, n);
        return true;
    }

    void dumpStacks(String string) {
        int n;
        Logger.info("\n\n------------------\nRPN stacks: " + string + "\n");
        for (n = 0; n <= this.xPt; ++n) {
            Logger.info("x[" + n + "]: " + this.xStack[n]);
        }
        Logger.info("\n");
        for (n = 0; n <= this.oPt; ++n) {
            Logger.info("o[" + n + "]: " + this.oStack[n] + " prec=" + T.getPrecedence(this.oStack[n].tok));
        }
        Logger.info(" ifStack = " + new String(this.ifStack).substring(0, this.ifPt + 1));
    }

    private SV getX() throws ScriptException {
        if (this.xPt < 0) {
            this.eval.error(13);
        }
        SV sV = SV.selectItemVar(this.xStack[this.xPt]);
        this.xStack[this.xPt--] = null;
        return sV;
    }

    private boolean evaluateFunction(int n) throws ScriptException {
        T t = this.oStack[this.oPt--];
        if (n == 0) {
            n = t.tok == 0x101000D1 ? t.intValue & 0xFFFFFE1F : t.tok;
        }
        int n2 = T.getMaxMathParams(n);
        int n3 = 0;
        int n4 = this.xPt;
        while (n4 >= 0 && this.xStack[n4--].value != t) {
            ++n3;
        }
        if (n2 > 0 && n3 > n2) {
            return false;
        }
        SV[] sVArray = new SV[n3];
        int n5 = n3;
        while (--n5 >= 0) {
            sVArray[n5] = this.getX();
        }
        --this.xPt;
        if (this.isSyntaxCheck) {
            return t.tok == 0x101000D1 ? true : this.addXBool(true);
        }
        switch (n) {
            case 135266318: 
            case 135266819: 
            case 135266820: 
            case 135266821: 
            case 135266822: 
            case 135266826: {
                return this.evaluateMath(sVArray, n);
            }
            case 1276117504: 
            case 1276117507: 
            case 1276117509: 
            case 1276118017: {
                return this.evaluateList(t.intValue, sVArray);
            }
            case 135266306: 
            case 0x10100040: {
                return this.evaluateArray(sVArray, n == 0x10100040);
            }
            case 135266307: 
            case 0x8101011: {
                return this.evaluateQuaternion(sVArray, n);
            }
            case 1276118529: {
                return this.evaluateBin(sVArray);
            }
            case 1276117512: 
            case 1276117513: {
                return this.evaluateRowCol(sVArray, n);
            }
            case 1766856708: {
                return this.evaluateColor(sVArray);
            }
            case 135270405: {
                return this.evaluateCompare(sVArray);
            }
            case 135266310: {
                return this.evaluateConnected(sVArray);
            }
            case 135267329: {
                return this.evaluateCross(sVArray);
            }
            case 135270407: {
                return this.evaluateData(sVArray);
            }
            case 0x8100001: 
            case 1276117505: 
            case 1276118018: 
            case 1746538509: {
                if ((n == 1276118018 || n == 1276117505) && t.tok == 0x101000D1) {
                    return this.evaluateDot(sVArray, n);
                }
                return this.evaluateMeasure(sVArray, t.tok);
            }
            case 135271426: 
            case 1229984263: {
                return this.evaluateLoad(sVArray, n);
            }
            case 1276118532: {
                return this.evaluateFind(sVArray);
            }
            case 135368713: {
                return this.evaluateUserFunction((String)t.value, sVArray, t.intValue, t.tok == 0x101000D1);
            }
            case 1288701960: 
            case 1826248715: {
                return this.evaluateLabel(t.intValue, sVArray);
            }
            case 135270410: {
                return this.evaluateGetProperty(sVArray);
            }
            case 137363468: {
                return this.evaluateHelix(sVArray);
            }
            case 135266319: 
            case 135267841: 
            case 135267842: {
                return this.evaluatePlane(sVArray, n);
            }
            case 135271429: 
            case 135287308: {
                return this.evaluateScript(sVArray, n);
            }
            case 1276117506: 
            case 1276117508: 
            case 1276117510: {
                return this.evaluateString(t.intValue, sVArray);
            }
            case 0x8100010: {
                return this.evaluatePoint(sVArray);
            }
            case 135304707: {
                return this.evaluatePrompt(sVArray);
            }
            case 135267332: {
                return this.evaluateRandom(sVArray);
            }
            case 1276118019: {
                return this.evaluateReplace(sVArray);
            }
            case 135267335: 
            case 135267336: 
            case 1238369286: {
                return this.evaluateSubstructure(sVArray, n);
            }
            case 135270422: {
                return this.evaluateCache(sVArray);
            }
            case 1276117010: 
            case 1276117011: {
                return this.evaluateSort(sVArray, n);
            }
            case 1297090050: {
                return this.evaluateSymop(sVArray, t.tok == 0x101000D1);
            }
            case 135266324: {
                return this.evaluateWithin(sVArray);
            }
            case 135402505: {
                return this.evaluateContact(sVArray);
            }
            case 135270421: {
                return this.evaluateWrite(sVArray);
            }
        }
        return false;
    }

    private boolean evaluateCache(SV[] sVArray) {
        if (sVArray.length > 0) {
            return false;
        }
        return this.addXMap(this.viewer.cacheList());
    }

    private boolean evaluateCompare(SV[] sVArray) throws ScriptException {
        if (sVArray.length < 2 || sVArray.length > 5) {
            return false;
        }
        String string = SV.sValue(sVArray[sVArray.length - 1]);
        boolean bl = string.equalsIgnoreCase("stddev");
        boolean bl2 = string.equalsIgnoreCase("ISOMER");
        boolean bl3 = !bl2 && sVArray.length > (bl ? 3 : 2);
        BS bS = sVArray[0].tok == 10 ? (BS)sVArray[0].value : null;
        BS bS2 = sVArray[1].tok == 10 ? (BS)sVArray[1].value : null;
        String string2 = bS == null ? SV.sValue(sVArray[0]) : "";
        String string3 = bS2 == null ? SV.sValue(sVArray[1]) : "";
        Matrix4f matrix4f = new Matrix4f();
        float f = Float.NaN;
        if (bl3 && (bS == null || bS2 == null)) {
            return false;
        }
        if (bl2) {
            boolean bl4;
            String string4;
            if (sVArray.length != 3) {
                return false;
            }
            if (bS == null && bS2 == null) {
                return this.addXStr(this.viewer.getSmilesMatcher().getRelationship(string2, string3).toUpperCase());
            }
            String string5 = bS == null ? this.viewer.getSmilesMatcher().getMolecularFormula(string2, false) : JmolMolecule.getMolecularFormula(this.viewer.getModelSet().atoms, bS, false);
            String string6 = string4 = bS2 == null ? this.viewer.getSmilesMatcher().getMolecularFormula(string3, false) : JmolMolecule.getMolecularFormula(this.viewer.getModelSet().atoms, bS2, false);
            if (!string5.equals(string4)) {
                return this.addXStr("NONE");
            }
            if (bS != null) {
                string2 = (String)this.eval.getSmilesMatches("", null, bS, null, false, true);
            }
            if (bS2 == null) {
                bl4 = this.viewer.getSmilesMatcher().areEqual(string3, string2) > 0;
            } else {
                boolean bl5 = bl4 = ((BS)this.eval.getSmilesMatches(string2, null, bS2, null, false, true)).nextSetBit(0) >= 0;
            }
            if (!bl4) {
                String string7 = string2 + string3;
                if (string7.indexOf("/") >= 0 || string7.indexOf("\\") >= 0 || string7.indexOf("@") >= 0) {
                    if (string2.indexOf("@") >= 0 && (bS2 != null || string3.indexOf("@") >= 0)) {
                        string2 = this.viewer.getSmilesMatcher().reverseChirality(string2);
                        if (bS2 == null) {
                            bl4 = this.viewer.getSmilesMatcher().areEqual(string2, string3) > 0;
                        } else {
                            boolean bl6 = bl4 = ((BS)this.eval.getSmilesMatches(string2, null, bS2, null, false, true)).nextSetBit(0) >= 0;
                        }
                        if (bl4) {
                            return this.addXStr("ENANTIOMERS");
                        }
                    }
                    if (bS2 == null) {
                        bl4 = this.viewer.getSmilesMatcher().areEqual("/nostereo/" + string3, string2) > 0;
                    } else {
                        Object object = this.eval.getSmilesMatches("/nostereo/" + string2, null, bS2, null, false, true);
                        boolean bl7 = bl4 = ((BS)object).nextSetBit(0) >= 0;
                    }
                    if (bl4) {
                        return this.addXStr("DIASTERIOMERS");
                    }
                }
                return this.addXStr("CONSTITUTIONAL ISOMERS");
            }
            if (bS == null || bS2 == null) {
                return this.addXStr("IDENTICAL");
            }
            f = this.eval.getSmilesCorrelation(bS, bS2, string2, null, null, null, null, false, false);
            return this.addXStr(f < 0.2f ? "IDENTICAL" : "IDENTICAL or CONFORMATIONAL ISOMERS (RMSD=" + f + ")");
        }
        if (bl3) {
            boolean bl8;
            JmolList<P3> jmolList = new JmolList<P3>();
            JmolList<P3> jmolList2 = new JmolList<P3>();
            string = SV.sValue(sVArray[2]);
            boolean bl9 = string.equalsIgnoreCase("MAP");
            bl3 = string.equalsIgnoreCase("SMILES");
            boolean bl10 = bl8 = bl9 || string.equalsIgnoreCase("SMARTS");
            if (bl3 || bl8) {
                String string8 = string = sVArray.length > 3 ? SV.sValue(sVArray[3]) : null;
            }
            if (string == null) {
                return false;
            }
            f = this.eval.getSmilesCorrelation(bS, bS2, string, jmolList, jmolList2, matrix4f, null, !bl3, bl9);
            if (bl9) {
                int n = jmolList.size();
                if (n == 0) {
                    return this.addXStr("");
                }
                int n2 = jmolList2.size() / n;
                JmolList<int[][]> jmolList3 = new JmolList<int[][]>();
                int n3 = 0;
                for (int i = 0; i < n2; ++i) {
                    int[][] nArray = ArrayUtil.newInt2(n);
                    jmolList3.addLast(nArray);
                    int n4 = 0;
                    while (n4 < n) {
                        nArray[n4] = new int[]{((Atom)jmolList.get((int)n4)).index, ((Atom)jmolList2.get((int)n3)).index};
                        ++n4;
                        ++n3;
                    }
                }
                return this.addXList(jmolList3);
            }
        } else {
            JmolList<P3> jmolList = this.eval.getPointVector(sVArray[0], 0);
            JmolList<P3> jmolList4 = this.eval.getPointVector(sVArray[1], 0);
            if (jmolList != null && jmolList4 != null) {
                f = Measure.getTransformMatrix4(jmolList, jmolList4, matrix4f, null);
            }
        }
        return bl || Float.isNaN(f) ? this.addXFloat(f) : this.addXM4(matrix4f);
    }

    private boolean evaluateSort(SV[] sVArray, int n) throws ScriptException {
        SV sV;
        if (sVArray.length > 1) {
            return false;
        }
        if (n == 1276117010) {
            int n2 = sVArray.length == 0 ? 0 : sVArray[0].asInt();
            return this.addXVar(this.getX().sortOrReverse(n2));
        }
        SV sV2 = this.getX();
        SV sV3 = sV = sVArray.length == 0 ? null : sVArray[0];
        if (sV2.tok == 4) {
            int n3;
            int n4 = 0;
            String string = SV.sValue(sV2);
            if (sV == null) {
                return this.addXInt(0);
            }
            String string2 = SV.sValue(sV);
            for (int i = 0; i < string.length() && (n3 = string.indexOf(string2, i)) >= 0; ++i) {
                ++n4;
                i = n3;
            }
            return this.addXInt(n4);
        }
        JmolList<SV> jmolList = new JmolList<SV>();
        SV sV4 = null;
        SV sV5 = null;
        JmolList<SV> jmolList2 = SV.getVariable(sV2.value).sortOrReverse(0).getList();
        if (jmolList2 == null) {
            return sV == null ? this.addXStr("") : this.addXInt(0);
        }
        int n5 = jmolList2.size();
        for (int i = 0; i <= n5; ++i) {
            SV sV6;
            SV sV7 = sV6 = i == n5 ? null : (SV)jmolList2.get(i);
            if (sV != null && sV6 != null && !SV.areEqual(sV6, sV)) continue;
            if (SV.areEqual(sV6, sV4)) {
                ++sV5.intValue;
                continue;
            }
            if (sV4 != null) {
                JmolList<SV> jmolList3 = new JmolList<SV>();
                jmolList3.addLast(sV4);
                jmolList3.addLast(sV5);
                jmolList.addLast(SV.getVariableList(jmolList3));
            }
            sV5 = SV.newScriptVariableInt(1);
            sV4 = sV6;
        }
        if (sV == null) {
            return this.addXVar(SV.getVariableList(jmolList));
        }
        if (jmolList.isEmpty()) {
            return this.addXInt(0);
        }
        return this.addXVar((SV)((SV)jmolList.get(0)).getList().get(1));
    }

    private boolean evaluateSymop(SV[] sVArray, boolean bl) throws ScriptException {
        P3 p3;
        String string;
        SV sV;
        if (sVArray.length == 0) {
            return false;
        }
        SV sV2 = sV = bl ? this.getX() : null;
        if (sV != null && sV.tok != 10) {
            return false;
        }
        BS bS = sV != null ? (BS)sV.value : (sVArray.length > 2 && sVArray[1].tok == 10 ? (BS)sVArray[1].value : this.viewer.getModelUndeletedAtomsBitSet(-1));
        switch (sVArray[0].tok) {
            case 4: {
                string = SV.sValue(sVArray[0]);
                break;
            }
            case 12: {
                string = sVArray[0].escape();
                break;
            }
            default: {
                string = null;
            }
        }
        int n = string == null ? sVArray[0].asInt() : 0;
        P3 p32 = p3 = sVArray.length > 1 ? this.ptValue(sVArray[1], true) : null;
        if (sVArray.length == 2 && !Float.isNaN(p3.x)) {
            return this.addXObj(this.viewer.getSymmetryInfo(bS, string, n, p3, null, null, 0x8100010));
        }
        String string2 = (sVArray.length == 1 ? "" : SV.sValue(sVArray[sVArray.length - 1])).toLowerCase();
        int n2 = 135176;
        if (sVArray.length == 1 || string2.equalsIgnoreCase("matrix")) {
            n2 = 12;
        } else if (string2.equalsIgnoreCase("array") || string2.equalsIgnoreCase("list")) {
            n2 = 1073742001;
        } else if (string2.equalsIgnoreCase("description")) {
            n2 = 1826248715;
        } else if (string2.equalsIgnoreCase("xyz")) {
            n2 = 1073741982;
        } else if (string2.equalsIgnoreCase("translation")) {
            n2 = 1073742178;
        } else if (string2.equalsIgnoreCase("axis")) {
            n2 = 1073741854;
        } else if (string2.equalsIgnoreCase("plane")) {
            n2 = 135266319;
        } else if (string2.equalsIgnoreCase("angle")) {
            n2 = 0x8100001;
        } else if (string2.equalsIgnoreCase("axispoint")) {
            n2 = 0x8100010;
        } else if (string2.equalsIgnoreCase("center")) {
            n2 = 12289;
        }
        return this.addXObj(this.viewer.getSymmetryInfo(bS, string, n, p3, null, string2, n2));
    }

    private boolean evaluateBin(SV[] sVArray) throws ScriptException {
        float[] fArray;
        boolean bl;
        if (sVArray.length != 3) {
            return false;
        }
        SV sV = this.getX();
        boolean bl2 = bl = sV.tok == 13;
        if (!bl && sV.tok != 7) {
            return this.addXVar(sV);
        }
        float f = SV.fValue(sVArray[0]);
        float f2 = SV.fValue(sVArray[1]);
        float f3 = SV.fValue(sVArray[2]);
        if (bl) {
            fArray = (float[])sV.value;
        } else {
            JmolList<SV> jmolList = sV.getList();
            fArray = new float[jmolList.size()];
            int n = jmolList.size();
            while (--n >= 0) {
                fArray[n] = SV.fValue((T)jmolList.get(n));
            }
        }
        int n = (int)Math.floor((f2 - f) / f3 + 0.01f);
        int[] nArray = new int[n];
        for (float f4 : fArray) {
            int n2 = (int)Math.floor((f4 - f) / f3);
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 >= n) {
                n2 = n - 1;
            }
            int n3 = n2;
            nArray[n3] = nArray[n3] + 1;
        }
        return this.addXAI(nArray);
    }

    private boolean evaluateHelix(SV[] sVArray) throws ScriptException {
        if (sVArray.length < 1 || sVArray.length > 5) {
            return false;
        }
        int n = sVArray.length > 2 ? 3 : 1;
        String string = n >= sVArray.length ? "array" : SV.sValue(sVArray[n]);
        int n2 = T.getTokFromName(string);
        if (sVArray.length > 2) {
            P3 p3 = this.ptValue(sVArray[0], true);
            P3 p32 = this.ptValue(sVArray[1], true);
            if (sVArray[2].tok != 9) {
                return false;
            }
            Quaternion quaternion = Quaternion.newP4((P4)sVArray[2].value);
            switch (n2) {
                case 0: {
                    break;
                }
                case 0x8100001: 
                case 0x8100010: 
                case 1073741854: 
                case 1666189314: 
                case 1746538509: {
                    return this.addXObj(Measure.computeHelicalAxis(null, n2, p3, p32, quaternion));
                }
                case 135266306: {
                    String[] stringArray = (String[])Measure.computeHelicalAxis(null, 1073742001, p3, p32, quaternion);
                    if (stringArray == null) {
                        return false;
                    }
                    return this.addXAS(stringArray);
                }
                default: {
                    return this.addXObj(Measure.computeHelicalAxis(string, 135176, p3, p32, quaternion));
                }
            }
        } else {
            BS bS = sVArray[0].value instanceof BS ? (BS)sVArray[0].value : this.eval.compareInt(1095761937, 269484436, sVArray[0].asInt());
            switch (n2) {
                case 0x8100010: {
                    return this.addXObj(this.viewer.getHelixData(bS, 0x8100010));
                }
                case 1073741854: {
                    return this.addXObj(this.viewer.getHelixData(bS, 1073741854));
                }
                case 1666189314: {
                    return this.addXObj(this.viewer.getHelixData(bS, 1666189314));
                }
                case 0x8100001: {
                    return this.addXFloat(((Float)this.viewer.getHelixData(bS, 0x8100001)).floatValue());
                }
                case 135176: 
                case 1746538509: {
                    return this.addXObj(this.viewer.getHelixData(bS, n2));
                }
                case 135266306: {
                    String[] stringArray = (String[])this.viewer.getHelixData(bS, 1073742001);
                    if (stringArray == null) {
                        return false;
                    }
                    return this.addXAS(stringArray);
                }
            }
        }
        return false;
    }

    private boolean evaluateDot(SV[] sVArray, int n) throws ScriptException {
        if (sVArray.length != 1) {
            return false;
        }
        SV sV = this.getX();
        SV sV2 = sVArray[0];
        P3 p3 = this.ptValue(sV2, true);
        P4 p4 = this.planeValue(sV2);
        if (sV.tok == 10 && n != 1276117505) {
            return this.addXObj(this.eval.getBitsetProperty(SV.bsSelectVar(sV), 1276118018, p3, p4, sV.value, null, false, sV.index, false));
        }
        P3 p32 = this.ptValue(sV, true);
        P4 p42 = this.planeValue(sV);
        if (n == 1276117505) {
            if (p42 != null && p4 != null) {
                return this.addXFloat(p42.x * p4.x + p42.y * p4.y + p42.z * p4.z + p42.w * p4.w);
            }
            if (p42 != null) {
                p32 = P3.new3(p42.x, p42.y, p42.z);
            }
            if (p4 != null) {
                p3 = P3.new3(p4.x, p4.y, p4.z);
            }
            return this.addXFloat(p32.x * p3.x + p32.y * p3.y + p32.z * p3.z);
        }
        if (p42 == null) {
            return this.addXFloat(p4 == null ? p3.distance(p32) : Measure.distanceToPlane(p4, p32));
        }
        return this.addXFloat(Measure.distanceToPlane(p42, p3));
    }

    public P3 ptValue(SV sV, boolean bl) throws ScriptException {
        if (this.isSyntaxCheck) {
            return new P3();
        }
        switch (sV.tok) {
            case 8: {
                return (P3)sV.value;
            }
            case 10: {
                return (P3)this.eval.getBitsetProperty(SV.bsSelectVar(sV), 1146095626, null, null, sV.value, null, false, Integer.MAX_VALUE, false);
            }
            case 4: {
                Object object = Escape.uP(SV.sValue(sV));
                if (!(object instanceof P3)) break;
                return (P3)object;
            }
            case 7: {
                Object object = Escape.uP("{" + SV.sValue(sV) + "}");
                if (!(object instanceof P3)) break;
                return (P3)object;
            }
        }
        if (!bl) {
            return null;
        }
        float f = SV.fValue(sV);
        return P3.new3(f, f, f);
    }

    private P4 planeValue(T t) {
        if (this.isSyntaxCheck) {
            return new P4();
        }
        switch (t.tok) {
            case 9: {
                return (P4)t.value;
            }
            case 4: 
            case 7: {
                Object object = Escape.uP(SV.sValue(t));
                return object instanceof P4 ? (P4)object : null;
            }
        }
        return null;
    }

    private boolean evaluateMeasure(SV[] sVArray, int n) throws ScriptException {
        int n2 = 0;
        switch (n) {
            case 1746538509: {
                JmolList<Object> jmolList = new JmolList<Object>();
                float[] fArray = new float[]{Float.MAX_VALUE, Float.MAX_VALUE};
                String string = null;
                String string2 = null;
                boolean bl = false;
                boolean bl2 = false;
                int n3 = 0;
                boolean bl3 = false;
                RadiusData radiusData = null;
                int n4 = 0;
                float f = Float.MAX_VALUE;
                boolean bl4 = false;
                block15: for (int i = 0; i < sVArray.length; ++i) {
                    switch (sVArray[i].tok) {
                        case 10: {
                            BS bS = (BS)sVArray[i].value;
                            if (bS.length() == 0) {
                                bl3 = true;
                            }
                            jmolList.addLast(bS);
                            ++n2;
                            ++n4;
                            continue block15;
                        }
                        case 8: {
                            Point3fi point3fi = new Point3fi();
                            point3fi.setT((P3)sVArray[i].value);
                            jmolList.addLast(point3fi);
                            ++n2;
                            continue block15;
                        }
                        case 2: 
                        case 3: {
                            fArray[n3++ % 2] = SV.fValue(sVArray[i]);
                            continue block15;
                        }
                        case 4: {
                            String string3 = SV.sValue(sVArray[i]);
                            if (string3.equalsIgnoreCase("vdw") || string3.equalsIgnoreCase("vanderwaals")) {
                                f = (float)(i + 1 < sVArray.length && sVArray[i + 1].tok == 2 ? sVArray[++i].asInt() : 100) / 100.0f;
                                continue block15;
                            }
                            if (string3.equalsIgnoreCase("notConnected")) {
                                bl2 = true;
                                continue block15;
                            }
                            if (string3.equalsIgnoreCase("connected")) {
                                bl = true;
                                continue block15;
                            }
                            if (string3.equalsIgnoreCase("minArray")) {
                                bl4 = n4 >= 1;
                                continue block15;
                            }
                            if (Parser.isOneOf(string3.toLowerCase(), "nm;nanometers;pm;picometers;angstroms;ang;au")) {
                                string2 = string3.toLowerCase();
                                continue block15;
                            }
                            string = n2 + ":" + string3;
                            continue block15;
                        }
                        default: {
                            return false;
                        }
                    }
                }
                if (n2 < 2 || n2 > 4 || n3 > 2 || bl2 && bl) {
                    return false;
                }
                if (bl3) {
                    return this.addXStr("");
                }
                if (f != Float.MAX_VALUE && (n4 != 2 || n2 != 2)) {
                    return this.addXStr("");
                }
                radiusData = f == Float.MAX_VALUE ? new RadiusData(fArray, 0.0f, null, null) : new RadiusData(null, f, RadiusData.EnumType.FACTOR, EnumVdw.AUTO);
                return this.addXObj(new MeasurementData(this.viewer, jmolList).set(0, radiusData, string, string2, null, bl, bl2, null, true).getMeasurements(bl4));
            }
            case 0x8100001: {
                n2 = sVArray.length;
                if (n2 == 3 || n2 == 4) break;
                return false;
            }
            default: {
                n2 = sVArray.length;
                if (n2 == 2) break;
                return false;
            }
        }
        P3[] p3Array = new P3[n2];
        for (int i = 0; i < n2; ++i) {
            p3Array[i] = this.ptValue(sVArray[i], true);
        }
        switch (n2) {
            case 2: {
                return this.addXFloat(p3Array[0].distance(p3Array[1]));
            }
            case 3: {
                return this.addXFloat(Measure.computeAngleABC(p3Array[0], p3Array[1], p3Array[2], true));
            }
            case 4: {
                return this.addXFloat(Measure.computeTorsion(p3Array[0], p3Array[1], p3Array[2], p3Array[3], true));
            }
        }
        return false;
    }

    private boolean evaluateUserFunction(String string, SV[] sVArray, int n, boolean bl) throws ScriptException {
        SV sV = null;
        if (bl) {
            sV = this.getX();
            if (sV.tok != 10) {
                return false;
            }
        }
        this.wasX = false;
        JmolList<SV> jmolList = new JmolList<SV>();
        for (int i = 0; i < sVArray.length; ++i) {
            jmolList.addLast(sVArray[i]);
        }
        if (bl) {
            return this.addXObj(this.eval.getBitsetProperty(SV.bsSelectVar(sV), n, null, null, sV.value, new Object[]{string, jmolList}, false, sV.index, false));
        }
        SV sV2 = this.eval.runFunctionRet(null, string, jmolList, null, true, true, false);
        return sV2 == null ? false : this.addXVar(sV2);
    }

    private boolean evaluateFind(SV[] sVArray) throws ScriptException {
        boolean bl;
        if (sVArray.length == 0) {
            return false;
        }
        SV sV = this.getX();
        String string = SV.sValue(sVArray[0]);
        String string2 = sVArray.length > 1 && sVArray[1].tok != 0x10000D && sVArray[1].tok != 0x10000C ? SV.sValue(sVArray[1]) : "";
        boolean bl2 = string.equalsIgnoreCase("SEQUENCE");
        boolean bl3 = string.equalsIgnoreCase("SMILES");
        boolean bl4 = string.equalsIgnoreCase("SMARTS");
        boolean bl5 = string.equalsIgnoreCase("MF");
        if (bl3 || bl4 || sV.tok == 10) {
            int n = bl3 || bl4 ? 2 : 1;
            BS bS = n < sVArray.length && sVArray[n].tok == 10 ? (BS)sVArray[n++].value : null;
            boolean bl6 = sVArray[sVArray.length - 1].tok == 0x10000D;
            Object object = null;
            switch (sV.tok) {
                case 4: {
                    String string3 = SV.sValue(sV);
                    if (bS != null) {
                        return false;
                    }
                    if (string2.equalsIgnoreCase("mf")) {
                        object = this.viewer.getSmilesMatcher().getMolecularFormula(string3, bl4);
                        if (object != null) break;
                        this.eval.evalError(this.viewer.getSmilesMatcher().getLastException(), null);
                        break;
                    }
                    object = this.eval.getSmilesMatches(string2, string3, null, null, bl4, !bl6);
                    break;
                }
                case 10: {
                    if (bl5) {
                        return this.addXStr(JmolMolecule.getMolecularFormula(this.viewer.getModelSet().atoms, (BS)sV.value, false));
                    }
                    if (bl2) {
                        return this.addXStr(this.viewer.getSmiles(-1, -1, (BS)sV.value, true, bl6, bl6, false));
                    }
                    if (bl3 || bl4) {
                        string = string2;
                    }
                    BS bS2 = bS;
                    object = this.eval.getSmilesMatches(string, null, (BS)sV.value, bS2, !bl3, !bl6);
                }
            }
            if (object == null) {
                this.eval.error(22);
            }
            return this.addXObj(object);
        }
        boolean bl7 = string2.indexOf("v") >= 0;
        boolean bl8 = string2.indexOf("i") >= 0;
        boolean bl9 = string2.indexOf("m") >= 0;
        boolean bl10 = sV.tok == 7;
        boolean bl11 = bl = sVArray.length == 2;
        if (bl10 || bl) {
            Pattern pattern = null;
            try {
                pattern = Pattern.compile(string, bl8 ? 2 : 0);
            }
            catch (Exception exception) {
                this.eval.evalError(exception.toString(), null);
            }
            String[] stringArray = SV.listValue(sV);
            if (Logger.debugging) {
                Logger.debug("finding " + string);
            }
            BS bS = new BS();
            int n = 0;
            int n2 = 0;
            Matcher matcher = null;
            JmolList<String> jmolList = bl9 ? new JmolList<String>() : null;
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i];
                matcher = pattern.matcher(string4);
                boolean bl12 = matcher.find();
                if ((!bl9 || !bl12) && (bl9 || bl12 != !bl7)) continue;
                ++n2;
                n = i;
                bS.set(i);
                if (!bl9) continue;
                jmolList.addLast(bl7 ? string4.substring(0, matcher.start()) + string4.substring(matcher.end()) : matcher.group());
            }
            if (!bl10) {
                return bl9 ? this.addXStr(jmolList.size() == 1 ? (String)jmolList.get(0) : "") : (bl7 ? this.addXBool(n2 == 1) : (bl9 ? this.addXStr(n2 == 0 ? "" : matcher.group()) : this.addXInt(n2 == 0 ? 0 : matcher.start() + 1)));
            }
            if (n2 == 1) {
                return this.addXStr(bl9 ? (String)jmolList.get(0) : stringArray[n]);
            }
            String[] stringArray2 = new String[n2];
            if (n2 > 0) {
                int n3 = stringArray.length;
                while (--n3 >= 0) {
                    if (!bS.get(n3)) continue;
                    String string5 = bl9 ? (String)jmolList.get(--n2) : stringArray[n3];
                    stringArray2[n2] = string5;
                }
            }
            return this.addXAS(stringArray2);
        }
        return this.addXInt(SV.sValue(sV).indexOf(string) + 1);
    }

    private boolean evaluateGetProperty(SV[] sVArray) {
        String string;
        Object object;
        String string2;
        int n = 0;
        String string3 = string2 = sVArray.length > n ? SV.sValue(sVArray[n++]).toLowerCase() : "";
        if (string2.startsWith("$")) {
            // empty if block
        }
        if (string2.equalsIgnoreCase("fileContents") && sVArray.length > 2) {
            object = SV.sValue(sVArray[1]);
            for (int i = 2; i < sVArray.length; ++i) {
                object = (String)object + "|" + SV.sValue(sVArray[i]);
            }
            string = object;
            n = sVArray.length;
        } else {
            string = sVArray.length > n && sVArray[n].tok == 10 ? SV.bsSelectVar(sVArray[n++]) : (sVArray.length > n && sVArray[n].tok == 4 && this.viewer.checkPropertyParameter(string2) ? sVArray[n++].value : "");
        }
        object = this.viewer.getProperty(null, string2, string);
        if (n < sVArray.length) {
            object = this.viewer.extractProperty(object, sVArray, n);
        }
        return this.addXObj(SV.isVariableType(object) ? object : Escape.toReadable(string2, object));
    }

    private boolean evaluatePlane(SV[] sVArray, int n) throws ScriptException {
        block31: {
            if (n == 135267841 && sVArray.length != 3 || n == 135267842 && sVArray.length != 2 && sVArray.length != 3 || sVArray.length == 0 || sVArray.length > 4) {
                return false;
            }
            switch (sVArray.length) {
                case 1: {
                    Object object;
                    if (sVArray[0].tok == 10 && ((BS)(object = SV.getBitSet(sVArray[0], false))).cardinality() == 3) {
                        JmolList<P3> jmolList = this.viewer.getAtomPointVector((BS)object);
                        V3 v3 = new V3();
                        V3 v32 = new V3();
                        V3 v33 = new V3();
                        P4 p4 = new P4();
                        Measure.getPlaneThroughPoints((P3)jmolList.get(0), (P3)jmolList.get(1), (P3)jmolList.get(2), v3, v32, v33, p4);
                        return this.addXPt4(p4);
                    }
                    object = Escape.uP(SV.sValue(sVArray[0]));
                    if (object instanceof P4) {
                        return this.addXPt4((P4)object);
                    }
                    return this.addXStr("" + object);
                }
                case 2: {
                    if (n == 135267842) {
                        if (sVArray[1].tok != 9) {
                            return false;
                        }
                        P3 p3 = new P3();
                        V3 v3 = new V3();
                        V3 v34 = new V3();
                        P4 p4 = (P4)sVArray[1].value;
                        if (sVArray[0].tok == 9) {
                            JmolList<Object> jmolList = Measure.getIntersectionPP((P4)sVArray[0].value, p4);
                            if (jmolList == null) {
                                return this.addXStr("");
                            }
                            return this.addXList(jmolList);
                        }
                        P3 p32 = this.ptValue(sVArray[0], false);
                        if (p32 == null) {
                            return this.addXStr("");
                        }
                        return this.addXPt(Measure.getIntersection(p32, null, p4, p3, v3, v34));
                    }
                }
                case 3: 
                case 4: {
                    switch (n) {
                        case 135267841: {
                            return this.addXPt4(this.eval.getHklPlane(P3.new3(SV.fValue(sVArray[0]), SV.fValue(sVArray[1]), SV.fValue(sVArray[2]))));
                        }
                        case 135267842: {
                            P3 p3 = this.ptValue(sVArray[0], false);
                            P3 p33 = this.ptValue(sVArray[1], false);
                            if (p3 == null || p33 == null) {
                                return this.addXStr("");
                            }
                            V3 v3 = V3.newV(p33);
                            v3.normalize();
                            if (sVArray[2].tok == 9) {
                                P3 p34 = new P3();
                                V3 v35 = new V3();
                                V3 v36 = new V3();
                                if ((p3 = Measure.getIntersection(p3, v3, (P4)sVArray[2].value, p34, v35, v36)) == null) {
                                    return this.addXStr("");
                                }
                                return this.addXPt(p3);
                            }
                            P3 p35 = this.ptValue(sVArray[2], false);
                            if (p35 == null) {
                                return this.addXStr("");
                            }
                            V3 v37 = new V3();
                            Measure.projectOntoAxis(p35, p3, v3, v37);
                            return this.addXPt(p35);
                        }
                    }
                    switch (sVArray[0].tok) {
                        case 2: 
                        case 3: {
                            if (sVArray.length == 3) {
                                float f = SV.fValue(sVArray[0]);
                                float f2 = SV.fValue(sVArray[1]);
                                float f3 = SV.fValue(sVArray[2]);
                                V3 v3 = V3.new3(0.0f, 0.0f, 1.0f);
                                P3 p3 = P3.new3(0.0f, 1.0f, 0.0f);
                                Quaternion quaternion = Quaternion.newVA(p3, f3);
                                quaternion.getMatrix().transform(v3);
                                p3.set(0.0f, 0.0f, 1.0f);
                                quaternion = Quaternion.newVA(p3, f2);
                                quaternion.getMatrix().transform(v3);
                                p3.setT(v3);
                                p3.scale(f);
                                P4 p4 = new P4();
                                Measure.getPlaneThroughPoint(p3, v3, p4);
                                return this.addXPt4(p4);
                            }
                            break block31;
                        }
                        case 8: 
                        case 10: {
                            P3 p3 = this.ptValue(sVArray[0], false);
                            P3 p36 = this.ptValue(sVArray[1], false);
                            if (p36 == null) {
                                return false;
                            }
                            P3 p37 = sVArray.length > 2 && (sVArray[2].tok == 10 || sVArray[2].tok == 8) ? this.ptValue(sVArray[2], false) : null;
                            V3 v3 = V3.newV(p36);
                            if (p37 == null) {
                                P4 p4 = new P4();
                                if (sVArray.length == 2 || !sVArray[2].asBoolean()) {
                                    p37 = P3.newP(p3);
                                    p37.add(p36);
                                    p37.scale(0.5f);
                                    v3.sub(p3);
                                    v3.normalize();
                                } else {
                                    p37 = p3;
                                }
                                Measure.getPlaneThroughPoint(p37, v3, p4);
                                return this.addXPt4(p4);
                            }
                            V3 v38 = new V3();
                            V3 v39 = new V3();
                            float f = Measure.getDirectedNormalThroughPoints(p3, p36, p37, sVArray.length == 4 ? this.ptValue(sVArray[3], true) : null, v3, v38, v39);
                            return this.addXPt4(P4.new4(v3.x, v3.y, v3.z, f));
                        }
                    }
                }
            }
        }
        if (sVArray.length != 4) {
            return false;
        }
        float f = SV.fValue(sVArray[0]);
        float f4 = SV.fValue(sVArray[1]);
        float f5 = SV.fValue(sVArray[2]);
        float f6 = SV.fValue(sVArray[3]);
        return this.addXPt4(P4.new4(f, f4, f5, f6));
    }

    private boolean evaluatePoint(SV[] sVArray) {
        if (sVArray.length != 1 && sVArray.length != 3 && sVArray.length != 4) {
            return false;
        }
        switch (sVArray.length) {
            case 1: {
                Object object;
                if (sVArray[0].tok == 3 || sVArray[0].tok == 2) {
                    return this.addXInt(sVArray[0].asInt());
                }
                String string = SV.sValue(sVArray[0]);
                if (sVArray[0].tok == 7) {
                    string = "{" + string + "}";
                }
                if ((object = Escape.uP(string)) instanceof P3) {
                    return this.addXPt((P3)object);
                }
                return this.addXStr("" + object);
            }
            case 3: {
                return this.addXPt(P3.new3(sVArray[0].asFloat(), sVArray[1].asFloat(), sVArray[2].asFloat()));
            }
            case 4: {
                return this.addXPt4(P4.new4(sVArray[0].asFloat(), sVArray[1].asFloat(), sVArray[2].asFloat(), sVArray[3].asFloat()));
            }
        }
        return false;
    }

    private boolean evaluatePrompt(SV[] sVArray) {
        boolean bl;
        if (sVArray.length != 1 && sVArray.length != 2 && sVArray.length != 3) {
            return false;
        }
        String string = SV.sValue(sVArray[0]);
        String[] stringArray = sVArray.length > 1 && sVArray[1].tok == 7 ? SV.listValue(sVArray[1]) : null;
        boolean bl2 = bl = stringArray != null || sVArray.length == 1 || sVArray.length == 3 && sVArray[2].asBoolean();
        String string2 = stringArray != null ? null : (sVArray.length >= 2 ? SV.sValue(sVArray[1]) : "OK");
        String string3 = this.viewer.prompt(string, string2, stringArray, bl);
        return bl && stringArray != null ? this.addXInt(Integer.parseInt(string3) + 1) : this.addXStr(string3);
    }

    private boolean evaluateReplace(SV[] sVArray) throws ScriptException {
        String string;
        if (sVArray.length != 2) {
            return false;
        }
        SV sV = this.getX();
        String string2 = SV.sValue(sVArray[0]);
        String string3 = SV.sValue(sVArray[1]);
        String string4 = string = sV.tok == 7 ? null : SV.sValue(sV);
        if (string != null) {
            return this.addXStr(TextFormat.simpleReplace(string, string2, string3));
        }
        String[] stringArray = SV.listValue(sV);
        int n = stringArray.length;
        while (--n >= 0) {
            stringArray[n] = TextFormat.simpleReplace(stringArray[n], string2, string3);
        }
        return this.addXAS(stringArray);
    }

    private boolean evaluateString(int n, SV[] sVArray) throws ScriptException {
        String string;
        if (sVArray.length > 1) {
            return false;
        }
        SV sV = this.getX();
        String string2 = string = n == 1276117508 && sV.tok == 10 || n == 1276117510 && sV.tok == 7 ? null : SV.sValue(sV);
        String string3 = sVArray.length == 1 ? SV.sValue(sVArray[0]) : (n == 1276117510 ? "" : "\n");
        switch (n) {
            case 1276117508: {
                if (sV.tok == 10) {
                    BS bS = SV.bsSelectVar(sV);
                    string3 = "\n";
                    int n2 = this.viewer.getModelCount();
                    string = "";
                    for (int i = 0; i < n2; ++i) {
                        string = string + (i == 0 ? "" : "\n");
                        BS bS2 = this.viewer.getModelUndeletedAtomsBitSet(i);
                        bS2.and(bS);
                        string = string + Escape.eBS(bS2);
                    }
                }
                return this.addXAS(TextFormat.splitChars(string, string3));
            }
            case 1276117506: {
                if (string.length() > 0 && string.charAt(string.length() - 1) == '\n') {
                    string = string.substring(0, string.length() - 1);
                }
                return this.addXStr(TextFormat.simpleReplace(string, "\n", string3));
            }
            case 1276117510: {
                if (string != null) {
                    return this.addXStr(TextFormat.trim(string, string3));
                }
                String[] stringArray = SV.listValue(sV);
                int n3 = stringArray.length;
                while (--n3 >= 0) {
                    stringArray[n3] = TextFormat.trim(stringArray[n3], string3);
                }
                return this.addXAS(stringArray);
            }
        }
        return this.addXStr("");
    }

    private boolean evaluateList(int n, SV[] sVArray) throws ScriptException {
        int n2;
        boolean bl;
        if (sVArray.length != 1 && (n != 1276118017 || sVArray.length != 0 && sVArray.length != 2)) {
            return false;
        }
        SV sV = this.getX();
        String[] stringArray = null;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        if (sVArray.length == 2) {
            int n3 = sVArray[0].tok == 4 ? 0 : 1;
            String string = SV.sValue(sVArray[n3]);
            stringArray = sV.tok == 7 ? SV.listValue(sV) : TextFormat.split(SV.sValue(sV), '\n');
            SV sV2 = sVArray[1 - n3];
            stringArray2 = sV2.tok == 7 ? SV.listValue(sV2) : TextFormat.split(SV.sValue(sV2), '\n');
            int n4 = Math.max(stringArray.length, stringArray2.length);
            stringArray3 = new String[n4];
            for (int i = 0; i < n4; ++i) {
                stringArray3[i] = (i >= stringArray.length ? "" : stringArray[i]) + string + (i >= stringArray2.length ? "" : stringArray2[i]);
            }
            return this.addXAS(stringArray3);
        }
        SV sV3 = sVArray.length == 0 ? SV.newVariable(0x100003, "all") : sVArray[0];
        boolean bl2 = bl = sV3.tok == 0x100003;
        if (sV.tok != 7 && sV.tok != 4) {
            this.wasX = false;
            this.addOp(T.tokenLeftParen);
            this.addXVar(sV);
            switch (n) {
                case 1276118017: {
                    this.addOp(T.tokenPlus);
                    break;
                }
                case 1276117509: {
                    this.addOp(T.tokenMinus);
                    break;
                }
                case 1276117507: {
                    this.addOp(T.tokenTimes);
                    break;
                }
                case 1276117504: {
                    this.addOp(T.tokenDivide);
                }
            }
            this.addXVar(sV3);
            return this.addOp(T.tokenRightParen);
        }
        boolean bl3 = sV3.tok != 7 && SV.sValue(sV3).indexOf("\n") < 0;
        float[] fArray = null;
        float[] fArray2 = null;
        JmolList<SV> jmolList = sV.getList();
        JmolList<SV> jmolList2 = sV3.getList();
        if (sV.tok == 7) {
            n2 = jmolList.size();
        } else {
            stringArray = TextFormat.splitChars((String)sV.value, "\n");
            n2 = stringArray.length;
            fArray = new float[n2];
            Parser.parseFloatArrayData(stringArray, fArray);
        }
        if (bl) {
            float f = 0.0f;
            if (sV.tok == 7) {
                int n5 = n2;
                while (--n5 >= 0) {
                    f += SV.fValue((T)jmolList.get(n5));
                }
            } else {
                int n6 = n2;
                while (--n6 >= 0) {
                    f += fArray[n6];
                }
            }
            return this.addXFloat(f);
        }
        SV sV4 = null;
        if (bl3) {
            sV4 = sV3;
        } else if (sV3.tok == 7) {
            n2 = Math.min(n2, jmolList2.size());
        } else {
            stringArray2 = TextFormat.splitChars((String)sV3.value, "\n");
            fArray2 = new float[stringArray2.length];
            Parser.parseFloatArrayData(stringArray2, fArray2);
            n2 = Math.min(fArray.length, fArray2.length);
        }
        T t = null;
        switch (n) {
            case 1276118017: {
                t = T.tokenPlus;
                break;
            }
            case 1276117509: {
                t = T.tokenMinus;
                break;
            }
            case 1276117507: {
                t = T.tokenTimes;
                break;
            }
            case 1276117504: {
                t = T.tokenDivide;
            }
        }
        SV[] sVArray2 = new SV[n2];
        for (int i = 0; i < n2; ++i) {
            if (sV.tok == 7) {
                this.addXVar((SV)jmolList.get(i));
            } else if (Float.isNaN(fArray[i])) {
                this.addXObj(SV.unescapePointOrBitsetAsVariable(stringArray[i]));
            } else {
                this.addXFloat(fArray[i]);
            }
            if (bl3) {
                this.addXVar(sV4);
            } else if (sV3.tok == 7) {
                this.addXVar((SV)jmolList2.get(i));
            } else if (Float.isNaN(fArray2[i])) {
                this.addXObj(SV.unescapePointOrBitsetAsVariable(stringArray2[i]));
            } else {
                this.addXFloat(fArray2[i]);
            }
            if (!this.addOp(t) || !this.operate()) {
                return false;
            }
            sVArray2[i] = this.xStack[this.xPt--];
        }
        return this.addXAV(sVArray2);
    }

    private boolean evaluateRowCol(SV[] sVArray, int n) throws ScriptException {
        if (sVArray.length != 1) {
            return false;
        }
        int n2 = sVArray[0].asInt() - 1;
        SV sV = this.getX();
        switch (sV.tok) {
            case 11: {
                if (n2 < 0 || n2 > 2) {
                    return false;
                }
                Matrix3f matrix3f = (Matrix3f)sV.value;
                switch (n) {
                    case 1276117513: {
                        float[] fArray = new float[3];
                        matrix3f.getRow(n2, fArray);
                        return this.addXAF(fArray);
                    }
                }
                float[] fArray = new float[3];
                matrix3f.getColumn(n2, fArray);
                return this.addXAF(fArray);
            }
            case 12: {
                if (n2 < 0 || n2 > 2) {
                    return false;
                }
                Matrix4f matrix4f = (Matrix4f)sV.value;
                switch (n) {
                    case 1276117513: {
                        float[] fArray = new float[4];
                        matrix4f.getRow(n2, fArray);
                        return this.addXAF(fArray);
                    }
                }
                float[] fArray = new float[4];
                matrix4f.getColumn(n2, fArray);
                return this.addXAF(fArray);
            }
        }
        return false;
    }

    private boolean evaluateArray(SV[] sVArray, boolean bl) {
        int n;
        int n2 = sVArray.length;
        if (bl && (n2 == 4 || n2 == 3)) {
            boolean bl2 = true;
            for (n = 0; n < n2 && bl2; ++n) {
                bl2 = sVArray[n].tok == 7 && sVArray[n].getList().size() == n2;
            }
            if (bl2) {
                float[] fArray = new float[n2 * n2];
                int n3 = 0;
                block1: for (int i = 0; i < n2 && bl2; ++i) {
                    JmolList<SV> jmolList = sVArray[i].getList();
                    for (int j = 0; j < n2; ++j) {
                        float f = SV.fValue((T)jmolList.get(j));
                        if (Float.isNaN(f)) {
                            bl2 = false;
                            continue block1;
                        }
                        fArray[n3++] = f;
                    }
                }
                if (bl2) {
                    if (n2 == 3) {
                        return this.addXM3(Matrix3f.newA(fArray));
                    }
                    return this.addXM4(Matrix4f.newA(fArray));
                }
            }
        }
        SV[] sVArray2 = new SV[sVArray.length];
        n = sVArray2.length;
        while (--n >= 0) {
            sVArray2[n] = SV.newScriptVariableToken(sVArray[n]);
        }
        return this.addXAV(sVArray2);
    }

    private boolean evaluateMath(SV[] sVArray, int n) {
        if (n == 135266318) {
            if (sVArray.length == 1 && sVArray[0].tok == 4) {
                return this.addXStr(new Date() + "\t" + SV.sValue(sVArray[0]));
            }
            return this.addXInt(((int)System.currentTimeMillis() & Integer.MAX_VALUE) - (sVArray.length == 0 ? 0 : sVArray[0].asInt()));
        }
        if (sVArray.length != 1) {
            return false;
        }
        if (n == 135266826) {
            if (sVArray[0].tok == 2) {
                return this.addXInt(Math.abs(sVArray[0].asInt()));
            }
            return this.addXFloat(Math.abs(sVArray[0].asFloat()));
        }
        double d = SV.fValue(sVArray[0]);
        switch (n) {
            case 135266819: {
                return this.addXFloat((float)(Math.acos(d) * 180.0 / Math.PI));
            }
            case 135266821: {
                return this.addXFloat((float)Math.cos(d * Math.PI / 180.0));
            }
            case 135266820: {
                return this.addXFloat((float)Math.sin(d * Math.PI / 180.0));
            }
            case 135266822: {
                return this.addXFloat((float)Math.sqrt(d));
            }
        }
        return false;
    }

    private boolean evaluateQuaternion(SV[] sVArray, int n) throws ScriptException {
        Object object;
        P3 p3 = null;
        int n2 = sVArray.length;
        int n3 = Integer.MAX_VALUE;
        boolean bl = false;
        if (n == 0x8101011) {
            if (n2 > 1 && sVArray[n2 - 1].tok == 4 && ((String)sVArray[n2 - 1].value).equalsIgnoreCase("relative")) {
                --n2;
                bl = true;
            }
            if (n2 > 1 && sVArray[n2 - 1].tok == 2 && sVArray[0].tok == 10) {
                n3 = sVArray[n2 - 1].asInt();
                if (n3 <= 0) {
                    n3 = 0x7FFFFFFE;
                }
                --n2;
            }
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                if (n == 0x8101011 && (sVArray[0].tok == 7 && sVArray[1].tok == 7 || sVArray[0].tok == 10 && (sVArray[1].tok == 2 || sVArray[1].tok == 10)) || (p3 = this.ptValue(sVArray[0], false)) != null && (n == 0x8101011 || sVArray[1].tok != 8)) break;
                return false;
            }
            case 3: {
                if (n != 0x8101011) {
                    return false;
                }
                if (sVArray[0].tok == 9) {
                    if (sVArray[2].tok == 8 || sVArray[2].tok == 10) break;
                    return false;
                }
                for (int i = 0; i < 3; ++i) {
                    if (sVArray[i].tok == 8 || sVArray[i].tok == 10) continue;
                    return false;
                }
                break;
            }
            default: {
                return false;
            }
        }
        Quaternion quaternion = null;
        Quaternion[] quaternionArray = null;
        P4 p4 = null;
        switch (n2) {
            case 0: {
                return this.addXPt4(Quaternion.newQ(this.viewer.getRotationQuaternion()).toPoint4f());
            }
            default: {
                Object object2;
                if (n == 0x8101011 && sVArray[0].tok == 7) {
                    object = ScriptMathProcessor.getQuaternionArray(sVArray[0].getList(), 1073742001);
                    object2 = Quaternion.sphereMean((Quaternion[])object, null, 1.0E-4f);
                    quaternion = object2 instanceof Quaternion ? (Quaternion)object2 : null;
                    break;
                }
                if (n == 0x8101011 && sVArray[0].tok == 10) {
                    quaternionArray = this.viewer.getAtomGroupQuaternions((BS)sVArray[0].value, n3);
                } else if (sVArray[0].tok == 11) {
                    quaternion = Quaternion.newM((Matrix3f)sVArray[0].value);
                } else if (sVArray[0].tok == 9) {
                    p4 = (P4)sVArray[0].value;
                } else {
                    object = Escape.uP(SV.sValue(sVArray[0]));
                    if (!(object instanceof P4)) {
                        return false;
                    }
                    p4 = (P4)object;
                }
                if (n != 135266307) break;
                quaternion = Quaternion.newVA(P3.new3(p4.x, p4.y, p4.z), p4.w);
                break;
            }
            case 2: {
                Object object2;
                if (n == 0x8101011) {
                    if (sVArray[0].tok == 7 && sVArray[1].tok == 7) {
                        object = ScriptMathProcessor.getQuaternionArray(sVArray[0].getList(), 1073742001);
                        object2 = ScriptMathProcessor.getQuaternionArray(sVArray[1].getList(), 1073742001);
                        quaternionArray = Quaternion.div((Quaternion[])object2, (Quaternion[])object, n3, bl);
                        break;
                    }
                    if (sVArray[0].tok == 10 && sVArray[1].tok == 10) {
                        object = this.viewer.getAtomGroupQuaternions((BS)sVArray[0].value, Integer.MAX_VALUE);
                        object2 = this.viewer.getAtomGroupQuaternions((BS)sVArray[1].value, Integer.MAX_VALUE);
                        quaternionArray = Quaternion.div((Quaternion[])object2, (Quaternion[])object, n3, bl);
                        break;
                    }
                }
                object = this.ptValue(sVArray[1], false);
                p4 = this.planeValue(sVArray[0]);
                if (object != null) {
                    quaternion = Quaternion.getQuaternionFrame(P3.new3(0.0f, 0.0f, 0.0f), p3, (Tuple3f)object);
                    break;
                }
                quaternion = Quaternion.newVA(p3, SV.fValue(sVArray[1]));
                break;
            }
            case 3: {
                if (sVArray[0].tok == 9) {
                    P3 p32 = sVArray[2].tok == 8 ? (P3)sVArray[2].value : this.viewer.getAtomSetCenter((BS)sVArray[2].value);
                    return this.addXStr(Quaternion.newP4((P4)sVArray[0].value).draw("q", SV.sValue(sVArray[1]), p32, 1.0f));
                }
                Object object2 = new P3[3];
                for (int i = 0; i < 3; ++i) {
                    object2[i] = sVArray[i].tok == 8 ? (P3)sVArray[i].value : this.viewer.getAtomSetCenter((BS)sVArray[i].value);
                }
                quaternion = Quaternion.getQuaternionFrame(object2[0], object2[1], object2[2]);
                break;
            }
            case 4: {
                if (n == 0x8101011) {
                    p4 = P4.new4(SV.fValue(sVArray[1]), SV.fValue(sVArray[2]), SV.fValue(sVArray[3]), SV.fValue(sVArray[0]));
                    break;
                }
                quaternion = Quaternion.newVA(P3.new3(SV.fValue(sVArray[0]), SV.fValue(sVArray[1]), SV.fValue(sVArray[2])), SV.fValue(sVArray[3]));
            }
        }
        if (quaternionArray != null) {
            if (n3 != Integer.MAX_VALUE) {
                object = new JmolList();
                for (int i = 0; i < quaternionArray.length; ++i) {
                    ((JmolList)object).addLast(quaternionArray[i].toPoint4f());
                }
                return this.addXList((JmolList<?>)object);
            }
            quaternion = quaternionArray.length > 0 ? quaternionArray[0] : null;
        }
        return this.addXPt4((quaternion == null ? Quaternion.newP4(p4) : quaternion).toPoint4f());
    }

    private boolean evaluateRandom(SV[] sVArray) {
        if (sVArray.length > 2) {
            return false;
        }
        float f = sVArray.length < 2 ? 0.0f : SV.fValue(sVArray[0]);
        float f2 = sVArray.length == 0 ? 1.0f : SV.fValue(sVArray[sVArray.length - 1]);
        return this.addXFloat((float)(Math.random() * (double)(f2 -= f)) + f);
    }

    private boolean evaluateCross(SV[] sVArray) {
        if (sVArray.length != 2) {
            return false;
        }
        SV sV = sVArray[0];
        SV sV2 = sVArray[1];
        if (sV.tok != 8 || sV2.tok != 8) {
            return false;
        }
        V3 v3 = V3.newV((P3)sV.value);
        V3 v32 = V3.newV((P3)sV2.value);
        v3.cross(v3, v32);
        return this.addXPt(P3.newP(v3));
    }

    private boolean evaluateLoad(SV[] sVArray, int n) {
        if (sVArray.length > 2 || sVArray.length < 1) {
            return false;
        }
        String string = SV.sValue(sVArray[0]);
        int n2 = sVArray.length == 2 ? sVArray[1].asInt() : Integer.MAX_VALUE;
        return this.addXStr(n == 135271426 ? this.viewer.getFileAsString4(string, n2, false, false) : this.viewer.getFilePath(string, false));
    }

    private boolean evaluateWrite(SV[] sVArray) throws ScriptException {
        if (sVArray.length == 0) {
            return false;
        }
        return this.addXStr(this.eval.write(sVArray));
    }

    private boolean evaluateScript(SV[] sVArray, int n) throws ScriptException {
        if (n == 135287308 && sVArray.length != 1 || sVArray.length == 0 || sVArray.length > 2) {
            return false;
        }
        String string = SV.sValue(sVArray[0]);
        SB sB = new SB();
        switch (n) {
            case 135271429: {
                String string2;
                String string3 = string2 = sVArray.length == 2 ? SV.sValue(sVArray[1]) : ".";
                if (!string2.equals(".")) {
                    sB.append(this.viewer.jsEval(string2 + "\u0001" + string));
                }
                if (!string2.equals(".") && !string2.equals("*")) break;
                this.eval.runScriptBuffer(string, sB);
                break;
            }
            case 135287308: {
                sB.append(this.viewer.jsEval(string));
            }
        }
        string = sB.toString();
        float f = Parser.parseFloatStrict(string);
        return Float.isNaN(f) ? this.addXStr(string) : (string.indexOf(".") >= 0 ? this.addXFloat(f) : this.addXInt(Parser.parseInt(string)));
    }

    private boolean evaluateData(SV[] sVArray) {
        String string;
        if (sVArray.length != 1 && sVArray.length != 2 && sVArray.length != 4) {
            return false;
        }
        String string2 = SV.sValue(sVArray[0]);
        String string3 = string = sVArray.length == 2 ? SV.sValue(sVArray[1]) : "";
        if (sVArray.length == 4) {
            int n = sVArray[1].asInt();
            int n2 = sVArray[2].asInt();
            int n3 = sVArray[3].asInt();
            float[] fArray = Parser.extractData(string2, n, n2, n3);
            return this.addXStr(Escape.escapeFloatA(fArray, false));
        }
        if (string2.indexOf("data2d_") == 0) {
            float[][] fArray = this.viewer.getDataFloat2D(string2);
            if (fArray == null) {
                return this.addXStr("");
            }
            if (sVArray.length == 2 && sVArray[1].tok == 2) {
                int n = sVArray[1].intValue;
                if (n < 0) {
                    n += fArray.length;
                }
                if (n >= 0 && n < fArray.length) {
                    return this.addXStr(Escape.escapeFloatA(fArray[n], false));
                }
                return this.addXStr("");
            }
            return this.addXStr(Escape.escapeFloatAA(fArray, false));
        }
        if (string2.indexOf("property_") == 0) {
            float[] fArray;
            float[] fArray2 = this.viewer.getDataFloat(string2);
            if (fArray2 == null) {
                return this.addXStr("");
            }
            float[] fArray3 = fArray = string.indexOf("property_") == 0 ? this.viewer.getDataFloat(string) : null;
            if (fArray != null) {
                fArray2 = ArrayUtil.arrayCopyF(fArray2, -1);
                int n = Math.min(fArray2.length, fArray.length);
                while (--n >= 0) {
                    int n4 = n;
                    fArray2[n4] = fArray2[n4] + fArray[n];
                }
            }
            return this.addXStr(Escape.escapeFloatA(fArray2, false));
        }
        if (sVArray.length == 1) {
            Object[] objectArray = this.viewer.getData(string2);
            return this.addXStr(objectArray == null ? "" : "" + objectArray[1]);
        }
        return this.addXStr(this.viewer.getData(string2, string));
    }

    private boolean evaluateLabel(int n, SV[] sVArray) throws ScriptException {
        SV sV = sVArray.length < 2 ? this.getX() : null;
        String string = sVArray.length == 0 ? "%U" : SV.sValue(sVArray[0]);
        boolean bl = T.tokAttr(n, 480);
        if (sV == null) {
            return this.addXStr(SV.sprintfArray(sVArray));
        }
        BS bS = SV.getBitSet(sV, true);
        if (bS == null) {
            return this.addXObj(SV.sprintf(TextFormat.formatCheck(string), sV));
        }
        return this.addXObj(this.eval.getBitsetIdent(bS, string, sV.value, true, sV.index, bl));
    }

    private boolean evaluateWithin(SV[] sVArray) throws ScriptException {
        BS bS;
        Object object;
        boolean bl;
        if (sVArray.length < 1 || sVArray.length > 5) {
            return false;
        }
        int n = sVArray.length;
        float f = 0.0f;
        Object object2 = sVArray[0].value;
        String string = "" + object2;
        int n2 = sVArray[0].tok;
        if (n2 == 4) {
            n2 = T.getTokFromName(string);
        }
        boolean bl2 = bl = n2 == 1649412112;
        if (bl) {
            f = 100.0f;
            object2 = null;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = bl || n2 == 3 || n2 == 2;
        RadiusData radiusData = null;
        switch (n2) {
            case 0x100004: {
                if (n != 3 || !(sVArray[1].value instanceof BS) || !(sVArray[2].value instanceof BS)) {
                    return false;
                }
                return this.addXBs(this.viewer.getBranchBitSet(((BS)sVArray[2].value).nextSetBit(0), ((BS)sVArray[1].value).nextSetBit(0)));
            }
            case 135267335: 
            case 135267336: 
            case 1238369286: {
                BS bS2 = null;
                boolean bl6 = true;
                switch (n) {
                    case 2: {
                        break;
                    }
                    case 3: {
                        boolean bl7 = bl6 = sVArray[2].tok == 10;
                        if (!bl6) break;
                        bS2 = (BS)sVArray[2].value;
                        break;
                    }
                    default: {
                        bl6 = false;
                    }
                }
                if (!bl6) {
                    this.eval.error(22);
                }
                return this.addXObj(this.eval.getSmilesMatches(SV.sValue(sVArray[1]), null, bS2, null, n2 == 135267335, this.asBitSet));
            }
        }
        if (object2 instanceof String) {
            if (n2 == 0) {
                n2 = 1048614;
                if (n > 2) {
                    return false;
                }
                n = 2;
            }
        } else if (bl5) {
            if (!bl) {
                f = SV.fValue(sVArray[0]);
            }
            if (n < 2) {
                return false;
            }
            n2 = sVArray[1].tok;
            switch (n2) {
                case 0x10000C: 
                case 0x10000D: {
                    bl3 = sVArray[1].asBoolean();
                    n = 0;
                    break;
                }
                case 4: {
                    object = SV.sValue(sVArray[1]);
                    if (((String)object).startsWith("$")) {
                        return this.addXBs(this.eval.getAtomsNearSurface(f, ((String)object).substring(1)));
                    }
                    bl4 = ((String)object).equalsIgnoreCase("group");
                    bl = ((String)object).equalsIgnoreCase("vanderwaals");
                    if (bl) {
                        object2 = null;
                        n2 = 1649412112;
                        break;
                    }
                    n2 = 1087373318;
                }
            }
        } else {
            return false;
        }
        object = null;
        P4 p4 = null;
        block12 : switch (n) {
            case 1: {
                switch (n2) {
                    case 0x300020: 
                    case 137363468: 
                    case 1679429641: {
                        return this.addXBs(this.viewer.getAtomBits(n2, null));
                    }
                    case 1073741864: {
                        return this.addXBs(this.viewer.getAtomBits(n2, ""));
                    }
                    case 1048614: {
                        return this.addXBs(this.viewer.getAtomBits(1087373320, string));
                    }
                }
                return false;
            }
            case 2: {
                switch (n2) {
                    case 1048614: {
                        n2 = 1087373320;
                        break block12;
                    }
                    case 1073741864: 
                    case 1087373320: 
                    case 1087375361: 
                    case 1087375362: {
                        return this.addXBs(this.viewer.getAtomBits(n2, SV.sValue(sVArray[sVArray.length - 1])));
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 0x100006: 
                    case 0x10000C: 
                    case 0x10000D: 
                    case 135266319: 
                    case 135267841: 
                    case 1087373318: 
                    case 1649412112: {
                        break block12;
                    }
                    case 1087373320: {
                        string = SV.sValue(sVArray[2]);
                        break block12;
                    }
                }
                return false;
            }
        }
        n = sVArray.length - 1;
        if (sVArray[n].value instanceof P4) {
            p4 = (P4)sVArray[n].value;
        } else if (sVArray[n].value instanceof P3) {
            object = (P3)sVArray[n].value;
            if (SV.sValue(sVArray[1]).equalsIgnoreCase("hkl")) {
                p4 = this.eval.getHklPlane((P3)object);
            }
        }
        if (n > 0 && p4 == null && object == null && !(sVArray[n].value instanceof BS)) {
            return false;
        }
        if (p4 != null) {
            return this.addXBs(this.viewer.getAtomsNearPlane(f, p4));
        }
        if (object != null) {
            return this.addXBs(this.viewer.getAtomsNearPt(f, (P3)object));
        }
        BS bS3 = bS = sVArray[n].tok == 10 ? SV.bsSelectVar(sVArray[n]) : null;
        if (n2 == 1087373320) {
            return this.addXBs(this.viewer.getSequenceBits(string, bS));
        }
        if (bS == null) {
            bS = new BS();
        }
        if (!bl5) {
            return this.addXBs(this.viewer.getAtomBits(n2, bS));
        }
        if (bl4) {
            return this.addXBs(this.viewer.getGroupsWithin((int)f, bS));
        }
        if (bl) {
            radiusData = new RadiusData(null, f > 10.0f ? f / 100.0f : f, f > 10.0f ? RadiusData.EnumType.FACTOR : RadiusData.EnumType.OFFSET, EnumVdw.AUTO);
        }
        return this.addXBs(this.viewer.getAtomsWithinRadius(f, bS, bl3, radiusData));
    }

    private boolean evaluateContact(SV[] sVArray) {
        if (sVArray.length < 1 || sVArray.length > 3) {
            return false;
        }
        int n = 0;
        float f = 100.0f;
        int n2 = sVArray[0].tok;
        switch (n2) {
            case 2: 
            case 3: {
                f = SV.fValue(sVArray[n++]);
                break;
            }
            case 10: {
                break;
            }
            default: {
                return false;
            }
        }
        if (n == sVArray.length || !(sVArray[n].value instanceof BS)) {
            return false;
        }
        BS bS = BSUtil.copy(SV.bsSelectVar(sVArray[n++]));
        if (this.isSyntaxCheck) {
            return this.addXBs(new BS());
        }
        BS bS2 = n < sVArray.length ? BSUtil.copy(SV.bsSelectVar(sVArray[n])) : null;
        RadiusData radiusData = new RadiusData(null, f > 10.0f ? f / 100.0f : f, f > 10.0f ? RadiusData.EnumType.FACTOR : RadiusData.EnumType.OFFSET, EnumVdw.AUTO);
        bS2 = this.eval.setContactBitSets(bS, bS2, true, Float.NaN, radiusData, false);
        bS2.or(bS);
        return this.addXBs(bS2);
    }

    private boolean evaluateColor(SV[] sVArray) {
        Object object;
        boolean bl;
        ColorEncoder colorEncoder;
        String string;
        String string2 = string = sVArray.length > 0 ? SV.sValue(sVArray[0]) : "";
        if (string.equalsIgnoreCase("hsl") && sVArray.length == 2) {
            P3 p3 = P3.newP(SV.ptValue(sVArray[1]));
            float[] fArray = new float[3];
            ColorEncoder.RGBtoHSL(p3.x, p3.y, p3.z, fArray);
            p3.set(fArray[0] * 360.0f, fArray[1] * 100.0f, fArray[2] * 100.0f);
            return this.addXPt(p3);
        }
        boolean bl2 = string.startsWith("$");
        ColorEncoder colorEncoder2 = colorEncoder = bl2 ? null : this.viewer.getColorEncoder(string);
        if (!bl2 && colorEncoder == null) {
            return this.addXStr("");
        }
        float f = sVArray.length > 1 ? SV.fValue(sVArray[1]) : Float.MAX_VALUE;
        Object object2 = sVArray.length > 2 ? SV.fValue(sVArray[2]) : Float.MAX_VALUE;
        float f2 = sVArray.length > 3 ? SV.fValue(sVArray[3]) : Float.MAX_VALUE;
        boolean bl3 = f2 != Float.MAX_VALUE || f != Float.MAX_VALUE && object2 == Float.MAX_VALUE;
        boolean bl4 = bl = object2 != Float.MAX_VALUE;
        if (!bl && string.length() == 0) {
            f2 = f;
            object = this.viewer.getCurrentColorRange();
            f = (float)object[0];
            object2 = object[1];
        }
        if (bl2) {
            object = string.substring(1);
            Object[] objectArray = new Object[]{object, null};
            if (!this.viewer.getShapePropertyData(24, "colorEncoder", objectArray)) {
                return this.addXStr("");
            }
            colorEncoder = (ColorEncoder)objectArray[1];
        } else {
            colorEncoder.setRange(f, (float)object2, f > object2);
        }
        object = colorEncoder.getColorKey();
        if (bl3) {
            return this.addXPt(ColorUtil.colorPointFromInt2(colorEncoder.getArgb(object2 == Float.MAX_VALUE ? f : f2)));
        }
        return this.addXVar(SV.getVariableMap(object));
    }

    private boolean evaluateConnected(SV[] sVArray) {
        if (sVArray.length > 5) {
            return false;
        }
        float f = -2.1474836E9f;
        float f2 = 2.1474836E9f;
        float f3 = 0.0f;
        float f4 = Float.MAX_VALUE;
        int n = 65535;
        BS bS = null;
        BS bS2 = null;
        boolean bl = false;
        boolean bl2 = false;
        block5: for (int i = 0; i < sVArray.length; ++i) {
            SV sV = sVArray[i];
            switch (sV.tok) {
                case 10: {
                    bl2 = sV.value instanceof Bond.BondSet;
                    if (bl2 && bS != null) {
                        return false;
                    }
                    if (bS == null) {
                        bS = SV.bsSelectVar(sV);
                        continue block5;
                    }
                    if (bS2 == null) {
                        bS2 = SV.bsSelectVar(sV);
                        continue block5;
                    }
                    return false;
                }
                case 4: {
                    String string = SV.sValue(sV);
                    n = string.equalsIgnoreCase("hbond") ? 30720 : ScriptEvaluator.getBondOrderFromString(string);
                    if (n != 131071) continue block5;
                    return false;
                }
                case 3: {
                    bl = true;
                }
                default: {
                    int n2 = sV.asInt();
                    float f5 = sV.asFloat();
                    if (f2 != 2.1474836E9f) {
                        return false;
                    }
                    if (f == -2.1474836E9f) {
                        f = Math.max(n2, 0);
                        f3 = f5;
                        continue block5;
                    }
                    f2 = n2;
                    f4 = f5;
                }
            }
        }
        if (f == -2.1474836E9f) {
            f = 1.0f;
            f2 = 100.0f;
            f3 = 0.1f;
            f4 = 1.0E8f;
        } else if (f2 == 2.1474836E9f) {
            f2 = f;
            f4 = f3;
            f3 = 0.1f;
        }
        if (bS == null) {
            bS = this.viewer.getModelUndeletedAtomsBitSet(-1);
        }
        if (bl && bS2 == null) {
            bS2 = bS;
        }
        if (bS2 != null) {
            BS bS3 = new BS();
            this.viewer.makeConnections(f3, f4, n, 1087373321, bS, bS2, bS3, bl2, false, 0.0f);
            return this.addXVar(SV.newVariable(10, new Bond.BondSet(bS3, this.viewer.getAtomIndices(this.viewer.getAtomBits(1678770178, bS3)))));
        }
        return this.addXBs(this.viewer.getAtomsConnected(f, f2, n, bS));
    }

    private boolean evaluateSubstructure(SV[] sVArray, int n) throws ScriptException {
        if (sVArray.length == 0) {
            return false;
        }
        BS bS = new BS();
        String string = SV.sValue(sVArray[0]);
        if (string.length() > 0) {
            try {
                BS bS2 = sVArray.length == 2 && sVArray[1].tok == 10 ? SV.bsSelectVar(sVArray[1]) : null;
                bS = this.viewer.getSmilesMatcher().getSubstructureSet(string, this.viewer.getModelSet().atoms, this.viewer.getAtomCount(), bS2, n != 135267336 && n != 1238369286, false);
            }
            catch (Exception exception) {
                this.eval.evalError(exception.toString(), null);
            }
        }
        return this.addXBs(bS);
    }

    private boolean operate() throws ScriptException {
        T t = this.oStack[this.oPt--];
        if (this.logMessages) {
            this.dumpStacks("operate: " + t);
        }
        if (this.isArrayItem && this.squareCount == 0 && this.equalCount == 1 && this.oPt < 0 && t.tok == 269484436) {
            return true;
        }
        SV sV = this.getX();
        if (sV == T.tokenArraySelector) {
            return false;
        }
        if (sV.tok == 7 || sV.tok == 11 || sV.tok == 12) {
            sV = SV.selectItemVar(sV);
        }
        if (t.tok == 0x101000C1 || t.tok == 269484226) {
            if (!this.isSyntaxCheck && !sV.increment(this.incrementX)) {
                return false;
            }
            this.wasX = true;
            this.putX(sV);
            return true;
        }
        if (t.tok == 0x10100070) {
            if (this.isSyntaxCheck) {
                return this.addXBool(true);
            }
            switch (sV.tok) {
                case 9: {
                    return this.addXPt4(Quaternion.newP4((P4)sV.value).inv().toPoint4f());
                }
                case 11: {
                    Matrix3f matrix3f = Matrix3f.newM((Matrix3f)sV.value);
                    matrix3f.invert();
                    return this.addXM3(matrix3f);
                }
                case 12: {
                    Matrix4f matrix4f = Matrix4f.newM((Matrix4f)sV.value);
                    matrix4f.invert();
                    return this.addXM4(matrix4f);
                }
                case 10: {
                    return this.addXBs(BSUtil.copyInvert(SV.bsSelectVar(sV), sV.value instanceof Bond.BondSet ? this.viewer.getBondCount() : this.viewer.getAtomCount()));
                }
            }
            return this.addXBool(!sV.asBoolean());
        }
        int n = t.intValue & 0xFFFFFE1F;
        if (t.tok == 0x101000D1) {
            switch (n) {
                case 0x40000000: {
                    return this.getAllProperties(sV, (String)t.value);
                }
                case 1141899267: 
                case 1141899270: 
                case 1276117011: {
                    if (n == 1141899267 && sV.value instanceof Bond.BondSet) break;
                    return this.addXInt(SV.sizeOf(sV));
                }
                case 1141899272: {
                    return this.addXStr(ScriptMathProcessor.typeOf(sV));
                }
                case 0x44100011: {
                    if (sV.tok != 6) {
                        return this.addXStr("");
                    }
                    Set set = ((Map)sV.value).keySet();
                    Object[] objectArray = set.toArray(new String[set.size()]);
                    Arrays.sort(objectArray);
                    return this.addXAS((String[])objectArray);
                }
                case 0x44100004: {
                    String string;
                    switch (sV.tok) {
                        case 11: 
                        case 12: {
                            string = SV.sValue(sV);
                            string = TextFormat.simpleReplace(string.substring(1, string.length() - 1), "],[", "]\n[");
                            break;
                        }
                        case 4: {
                            string = (String)sV.value;
                            break;
                        }
                        default: {
                            string = SV.sValue(sV);
                        }
                    }
                    string = TextFormat.simpleReplace(string, "\n\r", "\n").replace('\r', '\n');
                    return this.addXAS(TextFormat.split(string, '\n'));
                }
                case 1766856708: {
                    switch (sV.tok) {
                        case 4: 
                        case 7: {
                            String string = SV.sValue(sV);
                            P3 p3 = new P3();
                            return this.addXPt(ColorUtil.colorPointFromString(string, p3));
                        }
                        case 2: 
                        case 3: {
                            return this.addXPt(this.viewer.getColorPointForPropertyValue(SV.fValue(sV)));
                        }
                        case 8: {
                            return this.addXStr(Escape.escapeColor(ColorUtil.colorPtToInt((P3)((P3)sV.value))));
                        }
                    }
                    break;
                }
                case 1679429641: {
                    return this.isSyntaxCheck ? this.addXStr("x") : this.getBoundBox(sV);
                }
            }
            if (this.isSyntaxCheck) {
                return this.addXStr(SV.sValue(sV));
            }
            if (sV.tok == 4) {
                Object object = SV.unescapePointOrBitsetAsVariable(SV.sValue(sV));
                if (!(object instanceof SV)) {
                    return false;
                }
                sV = (SV)object;
            }
            if (t.tok == sV.tok) {
                sV = this.getX();
            }
            return this.getPointOrBitsetOperation(t, sV);
        }
        SV sV2 = this.getX();
        if (this.isSyntaxCheck) {
            if (t == T.tokenAndFALSE || t == T.tokenOrTRUE) {
                this.isSyntaxCheck = false;
            }
            return this.addXVar(SV.newScriptVariableToken(sV2));
        }
        switch (t.tok) {
            case 0x10100060: 
            case 0x10100080: {
                switch (sV2.tok) {
                    case 10: {
                        BS bS = SV.bsSelectVar(sV2);
                        switch (sV.tok) {
                            case 10: {
                                bS = BSUtil.copy(bS);
                                bS.and(SV.bsSelectVar(sV));
                                return this.addXBs(bS);
                            }
                            case 2: {
                                int n2 = sV.asInt();
                                return this.addXBool(n2 < 0 ? false : bS.get(n2));
                            }
                        }
                    }
                }
                return this.addXBool(sV2.asBoolean() && sV.asBoolean());
            }
            case 0x10100050: {
                switch (sV2.tok) {
                    case 10: {
                        BS bS = BSUtil.copy(SV.bsSelectVar(sV2));
                        switch (sV.tok) {
                            case 10: {
                                bS.or(SV.bsSelectVar(sV));
                                return this.addXBs(bS);
                            }
                            case 2: {
                                int n3 = sV.asInt();
                                if (n3 < 0) break;
                                bS.set(n3);
                                return this.addXBs(bS);
                            }
                            case 7: {
                                JmolList jmolList = (JmolList)sV.value;
                                int n4 = jmolList.size();
                                while (--n4 >= 0) {
                                    int n5 = ((SV)jmolList.get(n4)).asInt();
                                    if (n5 < 0) continue;
                                    bS.set(n5);
                                }
                                return this.addXBs(bS);
                            }
                        }
                        break;
                    }
                    case 7: {
                        return this.addXVar(SV.concatList(sV2, sV, false));
                    }
                }
                return this.addXBool(sV2.asBoolean() || sV.asBoolean());
            }
            case 0x10100051: {
                if (sV2.tok == 10 && sV.tok == 10) {
                    BS bS = BSUtil.copy(SV.bsSelectVar(sV2));
                    bS.xor(SV.bsSelectVar(sV));
                    return this.addXBs(bS);
                }
                boolean bl = sV2.asBoolean();
                boolean bl2 = sV.asBoolean();
                return this.addXBool(bl && !bl2 || bl2 && !bl);
            }
            case 269484114: {
                if (sV2.tok != 10 || sV.tok != 10) {
                    return false;
                }
                return this.addXBs(BSUtil.toggleInPlace(BSUtil.copy(SV.bsSelectVar(sV2)), SV.bsSelectVar(sV)));
            }
            case 269484434: {
                return this.addXBool(sV2.asFloat() <= sV.asFloat());
            }
            case 0x10100191: {
                return this.addXBool(sV2.asFloat() >= sV.asFloat());
            }
            case 0x10100190: {
                return this.addXBool(sV2.asFloat() > sV.asFloat());
            }
            case 269484435: {
                return this.addXBool(sV2.asFloat() < sV.asFloat());
            }
            case 269484436: {
                return this.addXBool(SV.areEqual(sV2, sV));
            }
            case 269484438: {
                return this.addXBool(!SV.areEqual(sV2, sV));
            }
            case 0x101000A1: {
                switch (sV2.tok) {
                    default: {
                        return this.addXFloat(sV2.asFloat() + sV.asFloat());
                    }
                    case 7: {
                        return this.addXVar(SV.concatList(sV2, sV, true));
                    }
                    case 2: {
                        switch (sV.tok) {
                            case 4: {
                                String string = SV.sValue(sV).trim();
                                if (string.indexOf(".") >= 0 || string.indexOf("+") > 0 || string.lastIndexOf("-") > 0) break;
                                return this.addXInt(sV2.intValue + sV.asInt());
                            }
                            case 3: {
                                return this.addXFloat((float)sV2.intValue + sV.asFloat());
                            }
                        }
                        return this.addXInt(sV2.intValue + sV.asInt());
                    }
                    case 4: {
                        return this.addXVar(SV.newVariable(4, SV.sValue(sV2) + SV.sValue(sV)));
                    }
                    case 9: {
                        Quaternion quaternion = Quaternion.newP4((P4)sV2.value);
                        switch (sV.tok) {
                            default: {
                                return this.addXPt4(quaternion.add(sV.asFloat()).toPoint4f());
                            }
                            case 9: 
                        }
                        return this.addXPt4(quaternion.mulQ(Quaternion.newP4((P4)sV.value)).toPoint4f());
                    }
                    case 8: {
                        P3 p3 = P3.newP((P3)sV2.value);
                        switch (sV.tok) {
                            case 8: {
                                p3.add((P3)sV.value);
                                return this.addXPt(p3);
                            }
                            case 9: {
                                P4 p4 = (P4)sV.value;
                                p3.add(P3.new3(p4.x, p4.y, p4.z));
                                return this.addXPt(p3);
                            }
                        }
                        float f = sV.asFloat();
                        return this.addXPt(P3.new3(p3.x + f, p3.y + f, p3.z + f));
                    }
                    case 11: 
                }
                switch (sV.tok) {
                    default: {
                        return this.addXFloat(sV2.asFloat() + sV.asFloat());
                    }
                    case 11: {
                        Matrix3f matrix3f = Matrix3f.newM((Matrix3f)sV2.value);
                        matrix3f.add((Matrix3f)sV.value);
                        return this.addXM3(matrix3f);
                    }
                    case 8: 
                }
                return this.addXM4(ScriptMathProcessor.getMatrix4f((Matrix3f)sV2.value, (P3)sV.value));
            }
            case 0x101000A0: {
                String string;
                if (sV2.tok == 2 && (sV.tok == 4 ? (string = SV.sValue(sV).trim()).indexOf(".") < 0 && string.indexOf("+") <= 0 && string.lastIndexOf("-") <= 0 : sV.tok != 3)) {
                    return this.addXInt(sV2.intValue - sV.asInt());
                }
                if (sV2.tok == 4 && sV.tok == 2 && (string = SV.sValue(sV2).trim()).indexOf(".") < 0 && string.indexOf("+") <= 0 && string.lastIndexOf("-") <= 0) {
                    return this.addXInt(sV2.asInt() - sV.intValue);
                }
                switch (sV2.tok) {
                    default: {
                        return this.addXFloat(sV2.asFloat() - sV.asFloat());
                    }
                    case 6: {
                        Hashtable hashtable = new Hashtable((Map)sV2.value);
                        hashtable.remove(SV.sValue(sV));
                        return this.addXVar(SV.getVariableMap(hashtable));
                    }
                    case 11: {
                        switch (sV.tok) {
                            default: {
                                return this.addXFloat(sV2.asFloat() - sV.asFloat());
                            }
                            case 11: 
                        }
                        Matrix3f matrix3f = Matrix3f.newM((Matrix3f)sV2.value);
                        matrix3f.sub((Matrix3f)sV.value);
                        return this.addXM3(matrix3f);
                    }
                    case 12: {
                        switch (sV.tok) {
                            default: {
                                return this.addXFloat(sV2.asFloat() - sV.asFloat());
                            }
                            case 12: 
                        }
                        Matrix4f matrix4f = Matrix4f.newM((Matrix4f)sV2.value);
                        matrix4f.sub((Matrix4f)sV.value);
                        return this.addXM4(matrix4f);
                    }
                    case 8: {
                        P3 p3 = P3.newP((P3)sV2.value);
                        switch (sV.tok) {
                            default: {
                                float f = sV.asFloat();
                                return this.addXPt(P3.new3(p3.x - f, p3.y - f, p3.z - f));
                            }
                            case 8: {
                                p3.sub((P3)sV.value);
                                return this.addXPt(p3);
                            }
                            case 9: 
                        }
                        P4 p4 = (P4)sV.value;
                        p3.sub(P3.new3(p4.x, p4.y, p4.z));
                        return this.addXPt(p3);
                    }
                    case 9: 
                }
                Quaternion quaternion = Quaternion.newP4((P4)sV2.value);
                switch (sV.tok) {
                    default: {
                        return this.addXPt4(quaternion.add(-sV.asFloat()).toPoint4f());
                    }
                    case 9: 
                }
                Quaternion quaternion2 = Quaternion.newP4((P4)sV.value);
                return this.addXPt4(quaternion2.mulQ(quaternion.inv()).toPoint4f());
            }
            case 0x101000C0: {
                switch (sV.tok) {
                    default: {
                        return this.addXFloat(-sV.asFloat());
                    }
                    case 2: {
                        return this.addXInt(-sV.asInt());
                    }
                    case 8: {
                        P3 p3 = P3.newP((P3)sV.value);
                        p3.scale(-1.0f);
                        return this.addXPt(p3);
                    }
                    case 9: {
                        P4 p4 = P4.newPt((P4)sV.value);
                        p4.scale(-1.0f);
                        return this.addXPt4(p4);
                    }
                    case 11: {
                        Matrix3f matrix3f = Matrix3f.newM((Matrix3f)sV.value);
                        matrix3f.transpose();
                        return this.addXM3(matrix3f);
                    }
                    case 12: {
                        Matrix4f matrix4f = Matrix4f.newM((Matrix4f)sV.value);
                        matrix4f.transpose();
                        return this.addXM4(matrix4f);
                    }
                    case 10: 
                }
                return this.addXBs(BSUtil.copyInvert(SV.bsSelectVar(sV), sV.value instanceof Bond.BondSet ? this.viewer.getBondCount() : this.viewer.getAtomCount()));
            }
            case 0x101000B1: {
                P3 p3;
                if (sV2.tok == 2 && sV.tok != 3) {
                    return this.addXInt(sV2.intValue * sV.asInt());
                }
                P3 p32 = sV2.tok == 11 ? this.ptValue(sV, false) : (p3 = sV.tok == 11 ? this.ptValue(sV2, false) : null);
                P4 p4 = sV2.tok == 12 ? this.planeValue(sV) : (sV.tok == 12 ? this.planeValue(sV2) : null);
                switch (sV.tok) {
                    case 11: {
                        if (p3 != null) {
                            Matrix3f matrix3f = Matrix3f.newM((Matrix3f)sV.value);
                            matrix3f.transpose();
                            matrix3f.transform(p3);
                            if (sV2.tok == 7) {
                                return this.addXVar(SV.getVariableAF(new float[]{p3.x, p3.y, p3.z}));
                            }
                            return this.addXPt(p3);
                        }
                        if (p4 == null) break;
                        return this.addXPt4(Quaternion.newP4(p4).mulQ(Quaternion.newM((Matrix3f)sV.value)).toPoint4f());
                    }
                    case 12: {
                        if (p4 == null) break;
                        Matrix4f matrix4f = Matrix4f.newM((Matrix4f)sV.value);
                        matrix4f.transpose();
                        matrix4f.transform4(p4);
                        if (sV2.tok == 7) {
                            return this.addXVar(SV.getVariableAF(new float[]{p4.x, p4.y, p4.z, p4.w}));
                        }
                        return this.addXPt4(p4);
                    }
                }
                switch (sV2.tok) {
                    default: {
                        return this.addXFloat(sV2.asFloat() * sV.asFloat());
                    }
                    case 11: {
                        Matrix3f matrix3f = (Matrix3f)sV2.value;
                        if (p3 != null) {
                            matrix3f.transform(p3);
                            if (sV.tok == 7) {
                                return this.addXVar(SV.getVariableAF(new float[]{p3.x, p3.y, p3.z}));
                            }
                            return this.addXPt(p3);
                        }
                        switch (sV.tok) {
                            case 11: {
                                Matrix3f matrix3f2 = Matrix3f.newM((Matrix3f)sV.value);
                                matrix3f2.mul2(matrix3f, matrix3f2);
                                return this.addXM3(matrix3f2);
                            }
                            case 9: {
                                return this.addXM3(Quaternion.newM(matrix3f).mulQ(Quaternion.newP4((P4)sV.value)).getMatrix());
                            }
                        }
                        float f = sV.asFloat();
                        AxisAngle4f axisAngle4f = new AxisAngle4f();
                        axisAngle4f.setM(matrix3f);
                        axisAngle4f.angle *= f;
                        Matrix3f matrix3f3 = new Matrix3f();
                        matrix3f3.setAA(axisAngle4f);
                        return this.addXM3(matrix3f3);
                    }
                    case 12: {
                        Matrix4f matrix4f = (Matrix4f)sV2.value;
                        if (p3 != null) {
                            matrix4f.transform(p3);
                            if (sV.tok == 7) {
                                return this.addXVar(SV.getVariableAF(new float[]{p3.x, p3.y, p3.z}));
                            }
                            return this.addXPt(p3);
                        }
                        if (p4 != null) {
                            matrix4f.transform4(p4);
                            if (sV.tok == 7) {
                                return this.addXVar(SV.getVariableAF(new float[]{p4.x, p4.y, p4.z, p4.w}));
                            }
                            return this.addXPt4(p4);
                        }
                        switch (sV.tok) {
                            case 12: {
                                Matrix4f matrix4f2 = Matrix4f.newM((Matrix4f)sV.value);
                                matrix4f2.mul2(matrix4f, matrix4f2);
                                return this.addXM4(matrix4f2);
                            }
                        }
                        return this.addXStr("NaN");
                    }
                    case 8: {
                        p3 = P3.newP((P3)sV2.value);
                        switch (sV.tok) {
                            case 8: {
                                P3 p33 = (P3)sV.value;
                                return this.addXFloat(p3.x * p33.x + p3.y * p33.y + p3.z * p33.z);
                            }
                        }
                        float f = sV.asFloat();
                        return this.addXPt(P3.new3(p3.x * f, p3.y * f, p3.z * f));
                    }
                    case 9: 
                }
                switch (sV.tok) {
                    case 9: {
                        return this.addXPt4(Quaternion.newP4((P4)sV2.value).mulQ(Quaternion.newP4((P4)sV.value)).toPoint4f());
                    }
                }
                return this.addXPt4(Quaternion.newP4((P4)sV2.value).mul(sV.asFloat()).toPoint4f());
            }
            case 269484210: {
                String string = null;
                int n6 = sV.asInt();
                switch (sV2.tok) {
                    default: {
                        if (n6 == 0) {
                            return this.addXInt(0);
                        }
                        return this.addXInt(sV2.asInt() % n6);
                    }
                    case 3: {
                        float f = sV2.asFloat();
                        if (n6 == 0) {
                            return this.addXInt(Math.round(f));
                        }
                        string = TextFormat.formatDecimal(f, n6);
                        return this.addXStr(string);
                    }
                    case 4: {
                        string = (String)sV2.value;
                        if (n6 == 0) {
                            return this.addXStr(TextFormat.trim(string, "\n\t "));
                        }
                        if (n6 == 9999) {
                            return this.addXStr(string.toUpperCase());
                        }
                        if (n6 == -9999) {
                            return this.addXStr(string.toLowerCase());
                        }
                        if (n6 > 0) {
                            return this.addXStr(TextFormat.formatS(string, n6, n6, false, false));
                        }
                        return this.addXStr(TextFormat.formatS(string, n6, n6 - 1, true, false));
                    }
                    case 7: {
                        String[] stringArray = SV.listValue(sV2);
                        for (int i = 0; i < stringArray.length; ++i) {
                            stringArray[i] = n6 == 0 ? stringArray[i].trim() : (n6 > 0 ? TextFormat.formatS(stringArray[i], n6, n6, true, false) : TextFormat.formatS(string, -n6, n6, false, false));
                        }
                        return this.addXAS(stringArray);
                    }
                    case 8: {
                        P3 p3 = P3.newP((P3)sV2.value);
                        this.viewer.toUnitCell(p3, P3.new3(n6, n6, n6));
                        return this.addXPt(p3);
                    }
                    case 9: {
                        P4 p4 = (P4)sV2.value;
                        if (sV.tok == 8) {
                            return this.addXPt(Quaternion.newP4(p4).transformPt((P3)sV.value));
                        }
                        if (sV.tok == 9) {
                            P4 p42 = P4.newPt((P4)sV.value);
                            Quaternion.newP4(p4).getThetaDirected(p42);
                            return this.addXPt4(p42);
                        }
                        switch (n6) {
                            case 0: {
                                return this.addXFloat(p4.w);
                            }
                            case 1: {
                                return this.addXFloat(p4.x);
                            }
                            case 2: {
                                return this.addXFloat(p4.y);
                            }
                            case 3: {
                                return this.addXFloat(p4.z);
                            }
                            case 4: {
                                return this.addXPt(P3.newP(Quaternion.newP4(p4).getNormal()));
                            }
                            case -1: {
                                return this.addXPt(P3.newP(Quaternion.newP4(p4).getVector(-1)));
                            }
                            case -2: {
                                return this.addXFloat(Quaternion.newP4(p4).getTheta());
                            }
                            case -3: {
                                return this.addXPt(P3.newP(Quaternion.newP4(p4).getVector(0)));
                            }
                            case -4: {
                                return this.addXPt(P3.newP(Quaternion.newP4(p4).getVector(1)));
                            }
                            case -5: {
                                return this.addXPt(P3.newP(Quaternion.newP4(p4).getVector(2)));
                            }
                            case -6: {
                                AxisAngle4f axisAngle4f = Quaternion.newP4(p4).toAxisAngle4f();
                                return this.addXPt4(P4.new4(axisAngle4f.x, axisAngle4f.y, axisAngle4f.z, (float)((double)(axisAngle4f.angle * 180.0f) / Math.PI)));
                            }
                            case -9: {
                                return this.addXM3(Quaternion.newP4(p4).getMatrix());
                            }
                        }
                        return this.addXPt4(p4);
                    }
                    case 12: {
                        Matrix4f matrix4f = (Matrix4f)sV2.value;
                        switch (n6) {
                            case 1: {
                                Matrix3f matrix3f = new Matrix3f();
                                matrix4f.getRotationScale(matrix3f);
                                return this.addXM3(matrix3f);
                            }
                            case 2: {
                                V3 v3 = new V3();
                                matrix4f.get(v3);
                                return this.addXPt(P3.newP(v3));
                            }
                        }
                        return false;
                    }
                    case 10: 
                }
                return this.addXBs(SV.bsSelectRange(sV2, n6));
            }
            case 0x101000B0: {
                if (sV2.tok == 2 && sV.tok == 2 && sV.intValue != 0) {
                    return this.addXInt(sV2.intValue / sV.intValue);
                }
                float f = sV.asFloat();
                switch (sV2.tok) {
                    default: {
                        float f2 = sV2.asFloat();
                        return this.addXFloat(f2 / f);
                    }
                    case 8: {
                        P3 p3 = P3.newP((P3)sV2.value);
                        if (f == 0.0f) {
                            return this.addXPt(P3.new3(Float.NaN, Float.NaN, Float.NaN));
                        }
                        return this.addXPt(P3.new3(p3.x / f, p3.y / f, p3.z / f));
                    }
                    case 9: 
                }
                if (sV.tok == 9) {
                    return this.addXPt4(Quaternion.newP4((P4)sV2.value).div(Quaternion.newP4((P4)sV.value)).toPoint4f());
                }
                if (f == 0.0f) {
                    return this.addXPt4(P4.new4(Float.NaN, Float.NaN, Float.NaN, Float.NaN));
                }
                return this.addXPt4(Quaternion.newP4((P4)sV2.value).mul(1.0f / f).toPoint4f());
            }
            case 269484211: {
                float f = sV.asFloat();
                switch (sV2.tok) {
                    default: {
                        return this.addXInt(f == 0.0f ? 0 : (int)Math.floor(sV2.asFloat() / sV.asFloat()));
                    }
                    case 9: 
                }
                if (f == 0.0f) {
                    return this.addXPt4(P4.new4(Float.NaN, Float.NaN, Float.NaN, Float.NaN));
                }
                if (sV.tok == 9) {
                    return this.addXPt4(Quaternion.newP4((P4)sV2.value).divLeft(Quaternion.newP4((P4)sV.value)).toPoint4f());
                }
                return this.addXPt4(Quaternion.newP4((P4)sV2.value).mul(1.0f / f).toPoint4f());
            }
            case 269484227: {
                float f = (float)Math.pow(sV2.asFloat(), sV.asFloat());
                return sV2.tok == 2 && sV.tok == 2 ? this.addXInt((int)f) : this.addXFloat(f);
            }
        }
        return true;
    }

    private static String typeOf(SV sV) {
        int n = sV == null ? 0 : sV.tok;
        switch (n) {
            case 0x10000C: 
            case 0x10000D: {
                return "boolean";
            }
            case 10: {
                return sV.value instanceof Bond.BondSet ? "bondset" : "bitset";
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                return T.astrType[n];
            }
        }
        return "?";
    }

    private boolean getAllProperties(SV sV, String string) throws ScriptException {
        JmolList<T> jmolList;
        if (sV.tok != 10) {
            return false;
        }
        if (this.isSyntaxCheck) {
            return this.addXStr("");
        }
        BS bS = SV.bsSelectVar(sV);
        int n = bS.cardinality();
        if (n == 0 || (jmolList = T.getAtomPropertiesLike(string.substring(0, string.length() - 1))) == null) {
            return this.addXStr("");
        }
        Hashtable<String, SV> hashtable = new Hashtable<String, SV>();
        int n2 = n == 1 ? bS.nextSetBit(0) : Integer.MAX_VALUE;
        int n3 = jmolList.size();
        block3: while (--n3 >= 0) {
            T t = (T)jmolList.get(n3);
            int n4 = t.tok;
            switch (n4) {
                case 1095761925: 
                case 1095766022: {
                    continue block3;
                }
            }
            if (n2 == Integer.MAX_VALUE) {
                n4 |= 0x1E0;
            }
            hashtable.put((String)t.value, SV.getVariable(this.eval.getBitsetProperty(bS, n4, null, null, null, null, false, n2, true)));
        }
        return this.addXMap(hashtable);
    }

    static Matrix4f getMatrix4f(Matrix3f matrix3f, Tuple3f tuple3f) {
        return Matrix4f.newMV(matrix3f, tuple3f == null ? new V3() : V3.newV(tuple3f));
    }

    private boolean getBoundBox(SV sV) {
        if (sV.tok != 10) {
            return false;
        }
        if (this.isSyntaxCheck) {
            return this.addXStr("");
        }
        BoxInfo boxInfo = this.viewer.getBoxInfo(SV.bsSelectVar(sV), 1.0f);
        P3[] p3Array = boxInfo.getBoundBoxPoints(true);
        JmolList<P3> jmolList = new JmolList<P3>();
        for (int i = 0; i < 4; ++i) {
            jmolList.addLast(p3Array[i]);
        }
        return this.addXList(jmolList);
    }

    private boolean getPointOrBitsetOperation(T t, SV sV) throws ScriptException {
        switch (sV.tok) {
            case 7: {
                switch (t.intValue) {
                    case 32: 
                    case 64: 
                    case 96: 
                    case 128: 
                    case 160: 
                    case 192: {
                        return this.addXObj(ScriptMathProcessor.getMinMax(sV.getList(), t.intValue));
                    }
                    case 1141899269: 
                    case 1276117010: {
                        return this.addXVar(sV.sortOrReverse(t.intValue == 1141899269 ? Integer.MIN_VALUE : 1));
                    }
                }
                SV[] sVArray = new SV[sV.getList().size()];
                for (int i = 0; i < sVArray.length; ++i) {
                    Object object = SV.unescapePointOrBitsetAsVariable(sV.getList().get(i));
                    if (!(object instanceof SV) || !this.getPointOrBitsetOperation(t, (SV)object)) {
                        return false;
                    }
                    sVArray[i] = this.xStack[this.xPt--];
                }
                return this.addXAV(sVArray);
            }
            case 8: {
                switch (t.intValue) {
                    case 1112541185: 
                    case 1112541205: {
                        return this.addXFloat(((P3)sV.value).x);
                    }
                    case 1112541186: 
                    case 1112541206: {
                        return this.addXFloat(((P3)sV.value).y);
                    }
                    case 1112541187: 
                    case 1112541207: {
                        return this.addXFloat(((P3)sV.value).z);
                    }
                    case 1146095626: {
                        P3 p3 = P3.newP((P3)sV.value);
                        this.viewer.toCartesian(p3, true);
                        return this.addXPt(p3);
                    }
                    case 1112541188: 
                    case 1112541189: 
                    case 1112541190: 
                    case 1146095627: {
                        P3 p3 = P3.newP((P3)sV.value);
                        this.viewer.toFractional(p3, true);
                        return t.intValue == 1146095627 ? this.addXPt(p3) : this.addXFloat(t.intValue == 1112541188 ? p3.x : (t.intValue == 1112541189 ? p3.y : p3.z));
                    }
                    case 1112541191: 
                    case 1112541192: 
                    case 1112541193: 
                    case 1146095629: {
                        P3 p3 = P3.newP((P3)sV.value);
                        this.viewer.toFractional(p3, false);
                        return t.intValue == 1146095627 ? this.addXPt(p3) : this.addXFloat(t.intValue == 1112541191 ? p3.x : (t.intValue == 1112541192 ? p3.y : p3.z));
                    }
                    case 1112539151: 
                    case 1112539152: 
                    case 1112539153: 
                    case 1146093582: {
                        P3 p3 = P3.newP((P3)sV.value);
                        this.viewer.toUnitCell(p3, null);
                        this.viewer.toFractional(p3, false);
                        return t.intValue == 1146093582 ? this.addXPt(p3) : this.addXFloat(t.intValue == 1112539151 ? p3.x : (t.intValue == 1112539152 ? p3.y : p3.z));
                    }
                }
                break;
            }
            case 9: {
                switch (t.intValue) {
                    case 1112541185: 
                    case 1112541205: {
                        return this.addXFloat(((P4)sV.value).x);
                    }
                    case 1112541186: 
                    case 1112541206: {
                        return this.addXFloat(((P4)sV.value).y);
                    }
                    case 1112541187: 
                    case 1112541207: {
                        return this.addXFloat(((P4)sV.value).z);
                    }
                    case 0x44100010: {
                        return this.addXFloat(((P4)sV.value).w);
                    }
                }
                break;
            }
            case 10: {
                if (t.intValue == 1678770178 && sV.value instanceof Bond.BondSet) {
                    return this.addXVar(sV);
                }
                BS bS = SV.bsSelectVar(sV);
                if (bS.cardinality() == 1 && (t.intValue & 0x1E0) == 0) {
                    t.intValue |= 0x20;
                }
                Object object = this.eval.getBitsetProperty(bS, t.intValue, null, null, sV.value, t.value, false, sV.index, true);
                if (t.intValue != 1678770178) {
                    return this.addXObj(object);
                }
                return this.addXVar(SV.newVariable(10, new Bond.BondSet((BS)object, this.viewer.getAtomIndices(bS))));
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object getMinMax(Object object, int n) {
        double d;
        float[] fArray = null;
        JmolList jmolList = null;
        int n2 = 0;
        if (Escape.isAF(object)) {
            fArray = (float[])object;
            n2 = fArray.length;
            if (n2 == 0) {
                return "NaN";
            }
        } else {
            if (!(object instanceof JmolList) || (n2 = (jmolList = (JmolList)object).size()) == 0) return "NaN";
            SV sV = (SV)jmolList.get(0);
            if (sV.tok == 4 && ((String)sV.value).startsWith("{")) {
                P3 p3 = SV.ptValue(sV);
                if (p3 instanceof P3) {
                    return ScriptMathProcessor.getMinMaxPoint(jmolList, n);
                }
                if (!(p3 instanceof P4)) return "NaN";
                return ScriptMathProcessor.getMinMaxQuaternion(jmolList, n);
            }
        }
        switch (n) {
            case 32: {
                d = 3.4028234663852886E38;
                break;
            }
            case 64: {
                d = -3.4028234663852886E38;
                break;
            }
            default: {
                d = 0.0;
            }
        }
        double d2 = 0.0;
        int n3 = 0;
        int n4 = n2;
        while (--n4 >= 0) {
            float f;
            float f2 = f = fArray == null ? SV.fValue((T)jmolList.get(n4)) : fArray[n4];
            if (Float.isNaN(f)) continue;
            ++n3;
            switch (n) {
                case 160: 
                case 192: {
                    d2 += (double)f * (double)f;
                }
                case 96: 
                case 128: {
                    d += (double)f;
                    break;
                }
                case 32: {
                    if (!((double)f < d)) break;
                    d = f;
                    break;
                }
                case 64: {
                    if (!((double)f > d)) break;
                    d = f;
                }
            }
        }
        if (n3 == 0) return "NaN";
        switch (n) {
            case 96: {
                d /= (double)n3;
                return Float.valueOf((float)d);
            }
            case 192: {
                if (n3 == 1) return Float.valueOf((float)d);
                d = Math.sqrt((d2 - d * d / (double)n3) / (double)(n3 - 1));
                return Float.valueOf((float)d);
            }
            case 32: 
            case 64: 
            case 128: {
                return Float.valueOf((float)d);
            }
            case 160: {
                d = d2;
            }
        }
        return Float.valueOf((float)d);
    }

    private static Object getMinMaxPoint(Object object, int n) {
        P3[] p3Array = null;
        JmolList jmolList = null;
        int n2 = 0;
        if (object instanceof Quaternion[]) {
            p3Array = (P3[])object;
            n2 = p3Array.length;
        } else if (object instanceof JmolList) {
            jmolList = (JmolList)object;
            n2 = jmolList.size();
        }
        if (jmolList != null || p3Array != null) {
            P3 p3 = new P3();
            float[] fArray = new float[n2];
            boolean bl = true;
            block10: for (int i = 0; i < 3 && bl; ++i) {
                Object object2;
                block11: for (int j = 0; j < n2; ++j) {
                    P3 p32;
                    P3 p33 = p32 = p3Array == null ? SV.ptValue((SV)jmolList.get(j)) : p3Array[j];
                    if (p32 == null) {
                        bl = false;
                        break;
                    }
                    switch (i) {
                        case 0: {
                            fArray[j] = p32.x;
                            continue block11;
                        }
                        case 1: {
                            fArray[j] = p32.y;
                            continue block11;
                        }
                        case 2: {
                            fArray[j] = p32.z;
                        }
                    }
                }
                if (!bl || !((object2 = ScriptMathProcessor.getMinMax(fArray, n)) instanceof Float)) break;
                float f = ((Float)object2).floatValue();
                switch (i) {
                    case 0: {
                        p3.x = f;
                        continue block10;
                    }
                    case 1: {
                        p3.y = f;
                        continue block10;
                    }
                    case 2: {
                        p3.z = f;
                    }
                }
            }
            return p3;
        }
        return "NaN";
    }

    private static Object getMinMaxQuaternion(JmolList<SV> jmolList, int n) {
        block7: {
            switch (n) {
                case 32: 
                case 64: 
                case 128: 
                case 160: {
                    return "NaN";
                }
            }
            Quaternion[] quaternionArray = ScriptMathProcessor.getQuaternionArray(jmolList, 1073742001);
            if (quaternionArray == null) break block7;
            float[] fArray = new float[1];
            Quaternion quaternion = Quaternion.sphereMean(quaternionArray, fArray, 1.0E-4f);
            switch (n) {
                case 96: {
                    return quaternion;
                }
                case 192: {
                    return Float.valueOf(fArray[0]);
                }
            }
        }
        return "NaN";
    }

    protected static Quaternion[] getQuaternionArray(Object object, int n) {
        Quaternion[] quaternionArray;
        switch (n) {
            case 0x8101011: {
                quaternionArray = (Quaternion[])object;
                break;
            }
            case 9: {
                P4[] p4Array = (P4[])object;
                quaternionArray = new Quaternion[p4Array.length];
                for (int i = 0; i < p4Array.length; ++i) {
                    quaternionArray[i] = Quaternion.newP4(p4Array[i]);
                }
                break;
            }
            case 1073742001: {
                JmolList jmolList = (JmolList)object;
                quaternionArray = new Quaternion[jmolList.size()];
                for (int i = 0; i < jmolList.size(); ++i) {
                    P4 p4 = SV.pt4Value((SV)jmolList.get(i));
                    if (p4 == null) {
                        return null;
                    }
                    quaternionArray[i] = Quaternion.newP4(p4);
                }
                break;
            }
            default: {
                return null;
            }
        }
        return quaternionArray;
    }
}

