/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.api;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Map;
import org.jmol.api.JmolAdapterAtomIterator;
import org.jmol.api.JmolAdapterBondIterator;
import org.jmol.api.JmolAdapterStructureIterator;
import org.jmol.api.JmolFilesReaderInterface;
import org.jmol.api.JmolViewer;
import org.jmol.constant.EnumQuantumShell;
import org.jmol.modelset.Group;
import org.jmol.modelset.ModelSet;
import org.jmol.util.Elements;
import org.jmol.viewer.JC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JmolAdapter {
    public static final short ORDER_COVALENT_SINGLE = 1;
    public static final short ORDER_COVALENT_DOUBLE = 2;
    public static final short ORDER_COVALENT_TRIPLE = 3;
    public static final short ORDER_AROMATIC = 515;
    public static final short ORDER_AROMATIC_SINGLE = 513;
    public static final short ORDER_AROMATIC_DOUBLE = 514;
    public static final short ORDER_HBOND = 2048;
    public static final short ORDER_STEREO_NEAR = 1025;
    public static final short ORDER_STEREO_FAR = 1041;
    public static final short ORDER_PARTIAL01 = 33;
    public static final short ORDER_PARTIAL12 = 66;
    public static final short ORDER_PARTIAL23 = 97;
    public static final short ORDER_PARTIAL32 = 100;
    public static final short ORDER_UNSPECIFIED = 17;
    public static final int SHELL_S = EnumQuantumShell.S.id;
    public static final int SHELL_P = EnumQuantumShell.P.id;
    public static final int SHELL_SP = EnumQuantumShell.SP.id;
    public static final int SHELL_L = EnumQuantumShell.SP.id;
    public static final int SHELL_D_SPHERICAL = EnumQuantumShell.D_SPHERICAL.id;
    public static final int SHELL_D_CARTESIAN = EnumQuantumShell.D_CARTESIAN.id;
    public static final int SHELL_F_SPHERICAL = EnumQuantumShell.F_SPHERICAL.id;
    public static final int SHELL_F_CARTESIAN = EnumQuantumShell.F_CARTESIAN.id;
    public static final String SUPPORTED_BASIS_FUNCTIONS = "SPLDF";
    public static final String NOTE_SCRIPT_FILE = "NOTE: file recognized as a script file: ";
    String adapterName;
    public static final String[] cellParamNames = new String[]{"_cell_length_a", "_cell_length_b", "_cell_length_c", "_cell_angle_alpha", "_cell_angle_beta", "_cell_angle_gamma"};

    public static final EnumQuantumShell getShellEnumeration(int n) {
        return EnumQuantumShell.getItem(n);
    }

    public static final int[][] getNewDfCoefMap() {
        return EnumQuantumShell.getNewDfCoefMap();
    }

    public static String getElementSymbol(int n) {
        return Elements.elementSymbolFromNumber(n);
    }

    public static short getElementNumber(String string) {
        return Elements.elementNumberFromSymbol(string, false);
    }

    public static int getNaturalIsotope(int n) {
        return Elements.getNaturalIsotope(n);
    }

    public static boolean isHetero(String string) {
        return JC.isHetero(string);
    }

    public static int getQuantumShellTagID(String string) {
        return EnumQuantumShell.getQuantumShellTagID(string);
    }

    public static int getQuantumShellTagIDSpherical(String string) {
        return EnumQuantumShell.getQuantumShellTagIDSpherical(string);
    }

    public static final short lookupGroupID(String string) {
        return Group.lookupGroupID(string);
    }

    public static float getBondingRadiusFloat(short s, int n) {
        return Elements.getBondingRadiusFloat(s, n);
    }

    public JmolAdapter(String string) {
        this.adapterName = string;
    }

    public String getAdapterName() {
        return this.adapterName;
    }

    public abstract Object getAtomSetCollectionReader(String var1, String var2, Object var3, Map<String, Object> var4);

    public abstract Object getAtomSetCollection(Object var1);

    public abstract Object getAtomSetCollectionReaders(JmolFilesReaderInterface var1, String[] var2, String[] var3, Map<String, Object> var4, boolean var5);

    public abstract Object getAtomSetCollectionFromSet(Object var1, Object var2, Map<String, Object> var3);

    public Object getAtomSetCollectionFromReader(String string, String string2, Object object, Map<String, Object> map) {
        Object object2;
        if (map == null) {
            map = new Hashtable<String, Object>();
        }
        if (!map.containsKey("viewer")) {
            map.put("viewer", JmolViewer.allocateViewer(null, this));
        }
        if ((object2 = this.getAtomSetCollectionReader(string, string2, object, map)) instanceof String) {
            return object2;
        }
        return this.getAtomSetCollection(object2);
    }

    public Object openBufferedReader(String string, BufferedReader bufferedReader) {
        return this.getAtomSetCollectionFromReader(string, null, bufferedReader, null);
    }

    public Object openBufferedReader(String string, BufferedReader bufferedReader, Map<String, Object> map) {
        return this.getAtomSetCollectionFromReader(string, null, bufferedReader, map);
    }

    public Object openBufferedReader(String string, String string2, BufferedReader bufferedReader) {
        return this.getAtomSetCollectionFromReader(string, string2, bufferedReader, null);
    }

    public abstract Object getAtomSetCollectionFromDOM(Object var1, Map<String, Object> var2);

    public abstract void finish(Object var1, ModelSet var2, int var3, int var4);

    public abstract String getFileTypeName(Object var1);

    public abstract String getAtomSetCollectionName(Object var1);

    public abstract Map<String, Object> getAtomSetCollectionAuxiliaryInfo(Object var1);

    public abstract int getAtomSetCount(Object var1);

    public abstract int getAtomSetNumber(Object var1, int var2);

    public abstract String getAtomSetName(Object var1, int var2);

    public abstract Map<String, Object> getAtomSetAuxiliaryInfo(Object var1, int var2);

    public abstract int getAtomCount(Object var1);

    public abstract int getHydrogenAtomCount(Object var1);

    public abstract String[][] getBondList(Object var1);

    public abstract boolean coordinatesAreFractional(Object var1);

    public abstract float[] getNotionalUnitcell(Object var1);

    public abstract float[] getPdbScaleMatrix(Object var1);

    public abstract float[] getPdbScaleTranslate(Object var1);

    public abstract JmolAdapterAtomIterator getAtomIterator(Object var1);

    public abstract JmolAdapterBondIterator getBondIterator(Object var1);

    public abstract JmolAdapterStructureIterator getStructureIterator(Object var1);

    public static final char canonizeAlphaDigit(char c) {
        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
            return c;
        }
        return '\u0000';
    }

    public static final char canonizeChainID(char c) {
        return JmolAdapter.canonizeAlphaDigit(c);
    }

    public static final char canonizeInsertionCode(char c) {
        return JmolAdapter.canonizeAlphaDigit(c);
    }

    public static final char canonizeAlternateLocationID(char c) {
        return JmolAdapter.canonizeAlphaDigit(c);
    }

    public abstract Object getAtomSetCollectionFromReader(String var1, Object var2, Map<String, Object> var3) throws Exception;
}

