/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import org.jmol.api.ApiPlatform;
import org.jmol.util.ArrayUtil;

public final class JmolFont {
    public final byte fid;
    public final String fontFace;
    public final String fontStyle;
    public final float fontSizeNominal;
    public final int idFontFace;
    public final int idFontStyle;
    public final float fontSize;
    public final Object font;
    private final Object fontMetrics;
    private ApiPlatform apiPlatform;
    private int ascent;
    private int descent;
    private boolean isBold;
    private boolean isItalic;
    private static final int FONT_ALLOCATION_UNIT = 8;
    private static int fontkeyCount = 1;
    private static int[] fontkeys = new int[8];
    private static JmolFont[] font3ds = new JmolFont[8];
    public static final int FONT_FACE_SANS = 0;
    public static final int FONT_FACE_SERIF = 1;
    public static final int FONT_FACE_MONO = 2;
    private static final String[] fontFaces = new String[]{"SansSerif", "Serif", "Monospaced", ""};
    public static final int FONT_STYLE_PLAIN = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLDITALIC = 3;
    private static final String[] fontStyles = new String[]{"Plain", "Bold", "Italic", "BoldItalic"};

    private JmolFont(ApiPlatform apiPlatform, byte by, int n, int n2, float f, float f2, Object object) {
        this.apiPlatform = apiPlatform;
        this.fid = by;
        this.fontFace = fontFaces[n];
        this.fontStyle = fontStyles[n2];
        this.idFontFace = n;
        this.idFontStyle = n2;
        this.fontSize = f;
        this.isBold = (n2 & 1) == 1;
        this.isItalic = (n2 & 2) == 2;
        this.fontSizeNominal = f2;
        this.font = apiPlatform.newFont(fontFaces[n], this.isBold, this.isItalic, f);
        this.fontMetrics = apiPlatform.getFontMetrics(this, object);
        this.descent = apiPlatform.getFontDescent(this.fontMetrics);
        this.ascent = apiPlatform.getFontAscent(this.fontMetrics);
    }

    public static JmolFont getFont3D(byte by) {
        return font3ds[by & 0xFF];
    }

    public static synchronized JmolFont createFont3D(int n, int n2, float f, float f2, ApiPlatform apiPlatform, Object object) {
        JmolFont jmolFont;
        if (f > 255.0f) {
            f = 255.0f;
        }
        int n3 = (int)f << 4;
        int n4 = n & 3 | (n2 & 3) << 2 | n3 << 4;
        int n5 = fontkeyCount;
        while (--n5 > 0) {
            if (n4 != fontkeys[n5] || JmolFont.font3ds[n5].fontSizeNominal != f2) continue;
            return font3ds[n5];
        }
        if ((n5 = fontkeyCount++) == fontkeys.length) {
            fontkeys = ArrayUtil.arrayCopyI(fontkeys, n5 + 8);
        }
        font3ds = (JmolFont[])ArrayUtil.arrayCopyObject(font3ds, n5 + 8);
        JmolFont.font3ds[n5] = jmolFont = new JmolFont(apiPlatform, (byte)n5, n, n2, f, f2, object);
        JmolFont.fontkeys[n5] = n4;
        return jmolFont;
    }

    public static int getFontFaceID(String string) {
        return "Monospaced".equalsIgnoreCase(string) ? 2 : ("Serif".equalsIgnoreCase(string) ? 1 : 0);
    }

    public static int getFontStyleID(String string) {
        int n = 4;
        while (--n >= 0) {
            if (!fontStyles[n].equalsIgnoreCase(string)) continue;
            return n;
        }
        return -1;
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    public int getHeight() {
        return this.getAscent() + this.getDescent();
    }

    public int stringWidth(String string) {
        return this.apiPlatform.fontStringWidth(this, this.fontMetrics, string);
    }
}

