/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.thread;

import org.jmol.thread.JmolThread;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

public class VibrationThread
extends JmolThread {
    private final TransformManager transformManager;

    public VibrationThread(TransformManager transformManager, Viewer viewer) {
        this.setViewer(viewer, "VibrationThread");
        this.transformManager = transformManager;
    }

    protected void run1(int n) throws InterruptedException {
        while (true) {
            switch (n) {
                case -1: {
                    this.lastRepaintTime = this.startTime = System.currentTimeMillis();
                    this.viewer.startHoverWatcher(false);
                    n = 0;
                    break;
                }
                case 0: {
                    int n2 = (int)(System.currentTimeMillis() - this.lastRepaintTime);
                    this.sleepTime = 33 - n2;
                    if (!this.runSleep(this.sleepTime, 1)) {
                        return;
                    }
                    n = 1;
                    break;
                }
                case 1: {
                    this.lastRepaintTime = System.currentTimeMillis();
                    int n2 = (int)(this.lastRepaintTime - this.startTime);
                    float f = (float)(n2 % this.transformManager.vibrationPeriodMs) / (float)this.transformManager.vibrationPeriodMs;
                    this.transformManager.setVibrationT(f);
                    this.viewer.refresh(3, "VibrationThread:run()");
                    n = this.checkInterrupted() ? -2 : 0;
                    break;
                }
                case -2: {
                    this.viewer.startHoverWatcher(true);
                    return;
                }
            }
        }
    }
}

