/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.thread;

import org.jmol.thread.JmolThread;
import org.jmol.util.AxisAngle4f;
import org.jmol.util.Logger;
import org.jmol.util.Matrix3f;
import org.jmol.util.P3;
import org.jmol.util.V3;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

public class MoveToThread
extends JmolThread {
    private final TransformManager transformManager;
    private final V3 aaStepCenter = new V3();
    private final V3 aaStepNavCenter = new V3();
    private final AxisAngle4f aaStep = new AxisAngle4f();
    private final AxisAngle4f aaTotal = new AxisAngle4f();
    private final Matrix3f matrixStart = new Matrix3f();
    private final Matrix3f matrixStartInv = new Matrix3f();
    private final Matrix3f matrixStep = new Matrix3f();
    private final Matrix3f matrixEnd = new Matrix3f();
    private P3 center;
    private float zoom;
    private float xTrans;
    private float yTrans;
    private P3 navCenter;
    private float xNav;
    private float yNav;
    private float navDepth;
    private P3 ptMoveToCenter;
    private float startRotationRadius;
    private float targetPixelScale;
    private int totalSteps;
    private float startPixelScale;
    private float targetRotationRadius;
    private int fps;
    private float rotationRadiusDelta;
    private float pixelScaleDelta;
    private float zoomStart;
    private float zoomDelta;
    private float xTransStart;
    private float xTransDelta;
    private float yTransStart;
    private float yTransDelta;
    private float xNavTransStart;
    private float xNavTransDelta;
    private float yNavTransDelta;
    private float yNavTransStart;
    private float navDepthStart;
    private float navDepthDelta;
    private long frameTimeMillis;
    private int iStep;
    private boolean doEndMove;
    private float floatSecondsTotal;

    public MoveToThread(TransformManager transformManager, Viewer viewer) {
        this.setViewer(viewer, "MoveToThread");
        this.transformManager = transformManager;
    }

    public int set(float f, P3 p3, Matrix3f matrix3f, float f2, float f3, float f4, float f5, P3 p32, float f6, float f7, float f8) {
        this.center = p3;
        this.matrixEnd.setM(matrix3f);
        this.zoom = f2;
        this.xTrans = f3;
        this.yTrans = f4;
        this.navCenter = p32;
        this.xNav = f6;
        this.yNav = f7;
        this.navDepth = f8;
        this.ptMoveToCenter = p3 == null ? this.transformManager.fixedRotationCenter : p3;
        this.startRotationRadius = this.transformManager.modelRadius;
        this.targetRotationRadius = p3 == null || Float.isNaN(f5) ? this.transformManager.modelRadius : (f5 <= 0.0f ? this.viewer.calcRotationRadius(p3) : f5);
        this.startPixelScale = this.transformManager.scaleDefaultPixelsPerAngstrom;
        float f9 = this.targetPixelScale = p3 == null ? this.startPixelScale : this.transformManager.defaultScaleToScreen(this.targetRotationRadius);
        if (Float.isNaN(f2)) {
            f2 = this.transformManager.zoomPercent;
        }
        this.transformManager.getRotation(this.matrixStart);
        this.matrixStartInv.invertM(this.matrixStart);
        this.matrixStep.mul2(this.matrixEnd, this.matrixStartInv);
        this.aaTotal.setM(this.matrixStep);
        this.fps = 30;
        this.floatSecondsTotal = f;
        this.totalSteps = (int)(f * (float)this.fps);
        if (this.totalSteps == 0) {
            return 0;
        }
        this.frameTimeMillis = 1000 / this.fps;
        this.targetTime = System.currentTimeMillis();
        this.zoomStart = this.transformManager.zoomPercent;
        this.zoomDelta = f2 - this.zoomStart;
        this.xTransStart = this.transformManager.getTranslationXPercent();
        this.xTransDelta = f3 - this.xTransStart;
        this.yTransStart = this.transformManager.getTranslationYPercent();
        this.yTransDelta = f4 - this.yTransStart;
        this.aaStepCenter.setT(this.ptMoveToCenter);
        this.aaStepCenter.sub(this.transformManager.fixedRotationCenter);
        this.aaStepCenter.scale(1.0f / (float)this.totalSteps);
        this.pixelScaleDelta = this.targetPixelScale - this.startPixelScale;
        this.rotationRadiusDelta = this.targetRotationRadius - this.startRotationRadius;
        if (p32 != null && this.transformManager.mode == 1) {
            this.aaStepNavCenter.setT(p32);
            this.aaStepNavCenter.sub(this.transformManager.navigationCenter);
            this.aaStepNavCenter.scale(1.0f / (float)this.totalSteps);
        }
        float f10 = this.transformManager.getNavigationOffsetPercent('X');
        this.xNavTransDelta = f6 - f10;
        this.yNavTransStart = this.transformManager.getNavigationOffsetPercent('Y');
        this.yNavTransDelta = f7 - this.yNavTransStart;
        float f11 = this.transformManager.getNavigationDepthPercent();
        this.navDepthDelta = f8 - f11;
        return this.totalSteps;
    }

    protected void run1(int n) throws InterruptedException {
        while (true) {
            switch (n) {
                case -1: {
                    if (this.totalSteps > 0) {
                        this.viewer.setInMotion(true);
                    }
                    n = 0;
                    break;
                }
                case 0: {
                    boolean bl;
                    if (this.stopped || ++this.iStep >= this.totalSteps) {
                        n = -2;
                        break;
                    }
                    this.doStepTransform();
                    this.doEndMove = true;
                    this.targetTime += this.frameTimeMillis;
                    this.currentTime = System.currentTimeMillis();
                    boolean bl2 = bl = this.currentTime < this.targetTime;
                    if (!bl && this.isJS) {
                        this.targetTime = this.currentTime;
                        bl = true;
                    }
                    if (bl) {
                        this.viewer.requestRepaintAndWait();
                    }
                    if (this.transformManager.motion == null || !this.isJS && this.eval != null && !this.viewer.isScriptExecuting()) {
                        this.stopped = true;
                        break;
                    }
                    this.currentTime = System.currentTimeMillis();
                    int n2 = (int)(this.targetTime - this.currentTime);
                    if (!this.runSleep(n2, 0)) {
                        return;
                    }
                    n = 0;
                    break;
                }
                case -2: {
                    if (this.totalSteps <= 0 || this.doEndMove && !this.stopped) {
                        this.doFinalTransform();
                    }
                    if (this.totalSteps > 0) {
                        this.viewer.setInMotion(false);
                    }
                    this.viewer.moveUpdate(this.floatSecondsTotal);
                    if (this.transformManager.motion != null && !this.stopped) {
                        this.transformManager.motion = null;
                        this.viewer.finalizeTransformParameters();
                    }
                    this.resumeEval();
                    return;
                }
            }
        }
    }

    private void doStepTransform() {
        if (!Float.isNaN(this.matrixEnd.m00)) {
            this.transformManager.getRotation(this.matrixStart);
            this.matrixStartInv.invertM(this.matrixStart);
            this.matrixStep.mul2(this.matrixEnd, this.matrixStartInv);
            this.aaTotal.setM(this.matrixStep);
            this.aaStep.setAA(this.aaTotal);
            this.aaStep.angle /= (float)(this.totalSteps - this.iStep);
            if (this.aaStep.angle == 0.0f) {
                this.matrixStep.setIdentity();
            } else {
                this.matrixStep.setAA(this.aaStep);
            }
            this.matrixStep.mul(this.matrixStart);
        }
        float f = (float)this.iStep / ((float)this.totalSteps - 1.0f);
        this.transformManager.modelRadius = this.startRotationRadius + this.rotationRadiusDelta * f;
        this.transformManager.scaleDefaultPixelsPerAngstrom = this.startPixelScale + this.pixelScaleDelta * f;
        if (!Float.isNaN(this.xTrans)) {
            this.transformManager.zoomToPercent(this.zoomStart + this.zoomDelta * f);
            this.transformManager.translateToPercent('x', this.xTransStart + this.xTransDelta * f);
            this.transformManager.translateToPercent('y', this.yTransStart + this.yTransDelta * f);
        }
        this.transformManager.setRotation(this.matrixStep);
        if (this.center != null) {
            this.transformManager.fixedRotationCenter.add(this.aaStepCenter);
        }
        if (this.navCenter != null && this.transformManager.mode == 1) {
            P3 p3 = P3.newP(this.transformManager.navigationCenter);
            p3.add(this.aaStepNavCenter);
            this.transformManager.setNavigatePt(p3);
            if (!Float.isNaN(this.xNav) && !Float.isNaN(this.yNav)) {
                this.transformManager.navTranslatePercentOrTo(0.0f, this.xNavTransStart + this.xNavTransDelta * f, this.yNavTransStart + this.yNavTransDelta * f);
            }
            if (!Float.isNaN(this.navDepth)) {
                this.transformManager.setNavigationDepthPercent(this.navDepthStart + this.navDepthDelta * f);
            }
        }
    }

    private void doFinalTransform() {
        this.transformManager.setRotationRadius(this.targetRotationRadius, true);
        this.transformManager.scaleDefaultPixelsPerAngstrom = this.targetPixelScale;
        if (this.center != null) {
            this.transformManager.moveRotationCenter(this.center, !this.transformManager.windowCentered);
        }
        if (!Float.isNaN(this.xTrans)) {
            this.transformManager.zoomToPercent(this.zoom);
            this.transformManager.translateToPercent('x', this.xTrans);
            this.transformManager.translateToPercent('y', this.yTrans);
        }
        this.transformManager.setRotation(this.matrixEnd);
        if (this.navCenter != null && this.transformManager.mode == 1) {
            this.transformManager.navigationCenter.setT(this.navCenter);
            if (!Float.isNaN(this.xNav) && !Float.isNaN(this.yNav)) {
                this.transformManager.navTranslatePercentOrTo(0.0f, this.xNav, this.yNav);
            }
            if (!Float.isNaN(this.navDepth)) {
                this.transformManager.setNavigationDepthPercent(this.navDepth);
            }
        }
    }

    public void interrupt() {
        Logger.debug("moveto thread interrupted!");
        this.doEndMove = false;
        super.interrupt();
    }
}

