/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Hashtable;
import java.util.Map;
import org.jmol.api.SymmetryInterface;
import org.jmol.modelset.Atom;
import org.jmol.modelset.ModelSet;
import org.jmol.symmetry.PointGroup;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.SymmetryInfo;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.BS;
import org.jmol.util.Escape;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.Matrix3f;
import org.jmol.util.Matrix4f;
import org.jmol.util.P3;
import org.jmol.util.P3i;
import org.jmol.util.Quadric;
import org.jmol.util.SB;
import org.jmol.util.SimpleUnitCell;
import org.jmol.util.Tuple3f;
import org.jmol.util.V3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Symmetry
implements SymmetryInterface {
    private PointGroup pointGroup;
    private SpaceGroup spaceGroup;
    private SymmetryInfo symmetryInfo;
    private UnitCell unitCell;

    @Override
    public SymmetryInterface setPointGroup(SymmetryInterface symmetryInterface, Atom[] atomArray, BS bS, boolean bl, float f, float f2) {
        this.pointGroup = PointGroup.getPointGroup(symmetryInterface == null ? null : ((Symmetry)symmetryInterface).pointGroup, atomArray, bS, bl, f, f2);
        return this;
    }

    @Override
    public String getPointGroupName() {
        return this.pointGroup.getName();
    }

    @Override
    public Object getPointGroupInfo(int n, boolean bl, boolean bl2, String string, int n2, float f) {
        if (!bl && !bl2 && this.pointGroup.textInfo != null) {
            return this.pointGroup.textInfo;
        }
        if (bl && this.pointGroup.isDrawType(string, n2, f)) {
            return this.pointGroup.drawInfo;
        }
        if (bl2 && this.pointGroup.info != null) {
            return this.pointGroup.info;
        }
        return this.pointGroup.getInfo(n, bl, bl2, string, n2, f);
    }

    @Override
    public void setSpaceGroup(boolean bl) {
        if (this.spaceGroup == null) {
            this.spaceGroup = new SpaceGroup(null).set(bl);
        }
    }

    @Override
    public int addSpaceGroupOperation(String string, int n) {
        return this.spaceGroup.addSymmetry(string, n);
    }

    @Override
    public void addSpaceGroupOperationM(Matrix4f matrix4f) {
        this.spaceGroup.addSymmetry("=" + SymmetryOperation.getXYZFromMatrix(matrix4f, false, false, false), 0);
    }

    @Override
    public void setLattice(int n) {
        this.spaceGroup.setLatticeParam(n);
    }

    @Override
    public String getSpaceGroupName() {
        return this.symmetryInfo != null ? this.symmetryInfo.spaceGroup : (this.spaceGroup != null ? this.spaceGroup.getName() : "");
    }

    @Override
    public Object getSpaceGroup() {
        return this.spaceGroup;
    }

    @Override
    public void setSpaceGroupS(SymmetryInterface symmetryInterface) {
        this.spaceGroup = symmetryInterface == null ? null : (SpaceGroup)symmetryInterface.getSpaceGroup();
    }

    @Override
    public boolean createSpaceGroup(int n, String string, float[] fArray) {
        this.spaceGroup = SpaceGroup.createSpaceGroup(n, string, fArray);
        if (this.spaceGroup != null && Logger.debugging) {
            Logger.debug("using generated space group " + this.spaceGroup.dumpInfo(null));
        }
        return this.spaceGroup != null;
    }

    @Override
    public boolean haveSpaceGroup() {
        return this.spaceGroup != null;
    }

    @Override
    public String getSpaceGroupInfo(String string, SymmetryInterface symmetryInterface) {
        return SpaceGroup.getInfo(string, symmetryInterface);
    }

    @Override
    public Object getLatticeDesignation() {
        return this.spaceGroup.getLatticeDesignation();
    }

    @Override
    public void setFinalOperations(P3[] p3Array, int n, int n2, boolean bl) {
        this.spaceGroup.setFinalOperations(p3Array, n, n2, bl);
    }

    @Override
    public int getSpaceGroupOperationCount() {
        return this.spaceGroup.finalOperations.length;
    }

    @Override
    public Matrix4f getSpaceGroupOperation(int n) {
        return this.spaceGroup.finalOperations[n];
    }

    @Override
    public String getSpaceGroupXyz(int n, boolean bl) {
        return this.spaceGroup.finalOperations[n].getXyz(bl);
    }

    @Override
    public void newSpaceGroupPoint(int n, P3 p3, P3 p32, int n2, int n3, int n4) {
        if (this.spaceGroup.finalOperations == null) {
            if (!this.spaceGroup.operations[n].isFinalized) {
                this.spaceGroup.operations[n].doFinalize();
            }
            this.spaceGroup.operations[n].newPoint(p3, p32, n2, n3, n4);
            return;
        }
        this.spaceGroup.finalOperations[n].newPoint(p3, p32, n2, n3, n4);
    }

    @Override
    public V3[] rotateEllipsoid(int n, P3 p3, V3[] v3Array, P3 p32, P3 p33) {
        return this.spaceGroup.finalOperations[n].rotateEllipsoid(p3, v3Array, this.unitCell, p32, p33);
    }

    @Override
    public Object[] getSymmetryOperationDescription(int n, SymmetryInterface symmetryInterface, P3 p3, P3 p32, String string) {
        return this.spaceGroup.operations[n].getDescription(symmetryInterface, p3, p32, string);
    }

    @Override
    public String fcoord(Tuple3f tuple3f) {
        return SymmetryOperation.fcoord(tuple3f);
    }

    @Override
    public String getMatrixFromString(String string, float[] fArray, boolean bl) {
        return SymmetryOperation.getMatrixFromString(string, fArray, false, bl);
    }

    @Override
    public P3 ijkToPoint3f(int n) {
        P3 p3 = new P3();
        SimpleUnitCell.ijkToPoint3f(n, p3, 0);
        return p3;
    }

    @Override
    public boolean getCoordinatesAreFractional() {
        return this.symmetryInfo.coordinatesAreFractional;
    }

    @Override
    public int[] getCellRange() {
        return this.symmetryInfo.cellRange;
    }

    @Override
    public String getSymmetryInfoString() {
        return this.symmetryInfo.symmetryInfoString;
    }

    @Override
    public String[] getSymmetryOperations() {
        return this.symmetryInfo.symmetryOperations;
    }

    @Override
    public boolean isPeriodic() {
        return this.symmetryInfo == null || this.symmetryInfo.isPeriodic();
    }

    @Override
    public void setSymmetryInfo(int n, Map<String, Object> map) {
        Matrix3f matrix3f;
        this.symmetryInfo = new SymmetryInfo();
        float[] fArray = this.symmetryInfo.setSymmetryInfo(map);
        if (fArray == null) {
            return;
        }
        this.setUnitCell(fArray);
        map.put("infoUnitCell", this.getUnitCellAsArray(false));
        this.setOffsetPt((P3)map.get("unitCellOffset"));
        if (map.containsKey("jmolData")) {
            this.setUnitCellAllFractionalRelative(true);
        }
        if ((matrix3f = (Matrix3f)map.get("matUnitCellOrientation")) != null) {
            this.setUnitCellOrientation(matrix3f);
        }
        if (Logger.debugging) {
            Logger.debug("symmetryInfos[" + n + "]:\n" + this.unitCell.dumpInfo(true));
        }
    }

    @Override
    public void setUnitCell(float[] fArray) {
        this.unitCell = UnitCell.newA(fArray);
    }

    @Override
    public boolean haveUnitCell() {
        return this.unitCell != null;
    }

    public String getUnitsymmetryInfo() {
        return this.unitCell.dumpInfo(false);
    }

    @Override
    public void setUnitCellOrientation(Matrix3f matrix3f) {
        this.unitCell.setOrientation(matrix3f);
    }

    @Override
    public void toUnitCell(P3 p3, P3 p32) {
        this.unitCell.toUnitCell(p3, p32);
    }

    @Override
    public void toCartesian(P3 p3, boolean bl) {
        this.unitCell.toCartesian(p3, bl);
    }

    @Override
    public P3 toSupercell(P3 p3) {
        return this.unitCell.toSupercell(p3);
    }

    @Override
    public void toFractional(P3 p3, boolean bl) {
        this.unitCell.toFractional(p3, bl);
    }

    @Override
    public float[] getNotionalUnitCell() {
        return this.unitCell.getNotionalUnitCell();
    }

    @Override
    public float[] getUnitCellAsArray(boolean bl) {
        return this.unitCell.getUnitCellAsArray(bl);
    }

    @Override
    public Quadric getEllipsoid(float[] fArray) {
        if (this.unitCell == null) {
            this.unitCell = UnitCell.newA(new float[]{1.0f, 1.0f, 1.0f, 90.0f, 90.0f, 90.0f});
        }
        return this.unitCell.getEllipsoid(fArray);
    }

    @Override
    public P3[] getUnitCellVertices() {
        return this.unitCell.getVertices();
    }

    @Override
    public P3 getCartesianOffset() {
        return this.unitCell.getCartesianOffset();
    }

    @Override
    public void setCartesianOffset(Tuple3f tuple3f) {
        this.unitCell.setCartesianOffset(tuple3f);
    }

    @Override
    public P3 getFractionalOffset() {
        return this.unitCell.getFractionalOffset();
    }

    @Override
    public void setOffsetPt(P3 p3) {
        this.unitCell.setOffset(p3);
    }

    @Override
    public void setOffset(int n) {
        this.unitCell.setOffset(this.ijkToPoint3f(n));
    }

    @Override
    public P3 getUnitCellMultiplier() {
        return this.unitCell.getUnitCellMultiplier();
    }

    @Override
    public P3[] getCanonicalCopy(float f) {
        return this.unitCell.getCanonicalCopy(f);
    }

    @Override
    public float getUnitCellInfoType(int n) {
        return this.unitCell.getInfo(n);
    }

    @Override
    public String getUnitCellInfo() {
        return this.unitCell.dumpInfo(false);
    }

    @Override
    public boolean isSlab() {
        return this.unitCell.isSlab();
    }

    @Override
    public boolean isPolymer() {
        return this.unitCell.isPolymer();
    }

    @Override
    public void setMinMaxLatticeParameters(P3i p3i, P3i p3i2) {
        this.unitCell.setMinMaxLatticeParameters(p3i, p3i2);
    }

    @Override
    public void setUnitCellAllFractionalRelative(boolean bl) {
        this.unitCell.setAllFractionalRelative(bl);
    }

    @Override
    public boolean checkDistance(P3 p3, P3 p32, float f, float f2, int n, int n2, int n3, P3 p33) {
        return this.unitCell.checkDistance(p3, p32, f, f2, n, n2, n3, p33);
    }

    @Override
    public P3[] getUnitCellVectors() {
        return this.unitCell.getUnitCellVectors();
    }

    @Override
    public SymmetryInterface getUnitCell(Tuple3f[] tuple3fArray) {
        Symmetry symmetry = new Symmetry();
        symmetry.unitCell = UnitCell.newP(tuple3fArray);
        return symmetry;
    }

    @Override
    public boolean isSupercell() {
        return this.unitCell.isSupercell();
    }

    @Override
    public String getSymmetryOperationInfo(Map<String, Object> map, int n, String string, boolean bl) {
        Object[][] objectArray = (Object[][])map.get("operations");
        if (objectArray == null) {
            return "";
        }
        SB sB = new SB();
        --n;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null || n >= 0 && n != i) continue;
            if (string != null) {
                return (String)objectArray[i][3];
            }
            if (sB.length() > 0) {
                sB.appendC('\n');
            }
            if (!bl) {
                if (n < 0) {
                    sB.appendI(i + 1).append("\t");
                }
                sB.append((String)objectArray[i][0]).append("\t");
            }
            sB.append((String)objectArray[i][2]);
        }
        if (sB.length() == 0 && string != null) {
            sB.append("draw " + string + "* delete");
        }
        return sB.toString();
    }

    @Override
    public Map<String, Object> getSpaceGroupInfo(ModelSet modelSet, int n, String string, int n2, P3 p3, P3 p32, String string2) {
        Object object;
        String string3 = null;
        Map<String, Object> map = null;
        SymmetryInterface symmetryInterface = null;
        Object[][] objectArray = null;
        if (string == null) {
            if (n <= 0) {
                int n3 = n = p3 instanceof Atom ? ((Atom)p3).modelIndex : modelSet.viewer.getCurrentModelIndex();
            }
            if (n < 0) {
                string3 = "no single current model";
            } else {
                symmetryInterface = modelSet.getUnitCell(n);
                if (symmetryInterface == null) {
                    string3 = "not applicable";
                }
            }
            if (string3 != null) {
                map = new Hashtable();
                map.put("spaceGroupInfo", string3);
                map.put("symmetryInfo", "");
            } else if (p3 == null && string2 == null && n2 != 0) {
                map = (Map)modelSet.getModelAuxiliaryInfoValue(n, "spaceGroupInfo");
            }
            if (map != null) {
                return map;
            }
            map = new Hashtable();
            if (p3 == null && string2 == null && n2 == 0) {
                modelSet.setModelAuxiliaryInfo(n, "spaceGroupInfo", map);
            }
            string = symmetryInterface.getSpaceGroupName();
            object = symmetryInterface.getSymmetryOperations();
            if (object == null) {
                string3 = "\n no symmetry operations employed";
            } else {
                this.setSpaceGroup(false);
                string3 = "\n" + ((String[])object).length + " symmetry operations employed:";
                objectArray = new Object[((String[])object).length][];
                for (int i = 0; i < ((String[])object).length; ++i) {
                    int n4 = this.addSpaceGroupOperation("=" + object[i], i + 1);
                    if (n4 < 0) continue;
                    Object[] objectArray2 = objectArray[i] = n2 > 0 && n2 - 1 != n4 ? null : this.getSymmetryOperationDescription(n4, symmetryInterface, p3, p32, string2);
                    if (objectArray[i] == null) continue;
                    string3 = string3 + "\n" + (i + 1) + "\t" + objectArray[i][0] + "\t" + objectArray[i][2];
                }
            }
        } else {
            map = new Hashtable<String, Object>();
        }
        map.put("spaceGroupName", string);
        object = this.getSpaceGroupInfo(string, symmetryInterface);
        if (objectArray != null) {
            map.put("operations", objectArray);
            map.put("symmetryInfo", string3);
        }
        if (object == null) {
            object = "could not identify space group from name: " + string + "\nformat: show spacegroup \"2\" or \"P 2c\" " + "or \"C m m m\" or \"x, y, z;-x ,-y, -z\"";
        }
        map.put("spaceGroupInfo", object);
        return map;
    }

    @Override
    public Object getSymmetryInfo(ModelSet modelSet, int n, int n2, SymmetryInterface symmetryInterface, String object, int n3, P3 p3, P3 p32, String string, int n4) {
        Object object2;
        if (p32 != null) {
            return modelSet.getSymmetryOperation(n, null, n3, p3, p32, string == null ? "sym" : string, n4 == 1826248715);
        }
        if (object == null) {
            object2 = symmetryInterface.getSymmetryOperations();
            if (object2 == null || n3 == 0 || Math.abs(n3) > ((Object)object2).length) {
                return "";
            }
            object = n3 > 0 ? object2[n3 - 1] : object2[-1 - n3];
        } else {
            n3 = 0;
        }
        object2 = modelSet.getSymTemp(false);
        object2.setSpaceGroup(false);
        int n5 = object2.addSpaceGroupOperation((n3 < 0 ? "!" : "=") + (String)object, Math.abs(n3));
        if (n5 < 0) {
            return "";
        }
        object2.setUnitCell(symmetryInterface.getNotionalUnitCell());
        p3 = P3.newP(p3 == null ? modelSet.atoms[n2] : p3);
        if (n4 == 0x8100010) {
            symmetryInterface.toFractional(p3, false);
            if (Float.isNaN(p3.x)) {
                return "";
            }
            P3 p33 = new P3();
            object2.newSpaceGroupPoint(n5, p3, p33, 0, 0, 0);
            object2.toCartesian(p33, false);
            return p33;
        }
        Object[] objectArray = object2.getSymmetryOperationDescription(n5, symmetryInterface, p3, p32, string == null ? "sym" : string);
        int n6 = (Integer)objectArray[9];
        switch (n4) {
            case 135266306: {
                return objectArray;
            }
            case 1073742001: {
                String[] stringArray = new String[]{(String)objectArray[0], (String)objectArray[1], (String)objectArray[2], Escape.eP((V3)objectArray[4]), Escape.eP((V3)objectArray[5]), Escape.eP((P3)objectArray[6]), Escape.eP((P3)objectArray[7]), Escape.eP((V3)objectArray[8]), "" + objectArray[9], "" + Escape.e(objectArray[10])};
                return stringArray;
            }
            case 1073741982: {
                return objectArray[0];
            }
            default: {
                return objectArray[2];
            }
            case 135176: {
                return objectArray[3];
            }
            case 1073742178: {
                return objectArray[5];
            }
            case 12289: {
                return objectArray[6];
            }
            case 0x8100010: {
                return objectArray[7];
            }
            case 135266319: 
            case 1073741854: {
                return n6 == 0 == (n4 == 135266319) ? (V3)objectArray[8] : null;
            }
            case 0x8100001: {
                return objectArray[9];
            }
            case 12: 
        }
        return objectArray[10];
    }

    @Override
    public void setCentroid(ModelSet modelSet, int n, int n2, int[] nArray) {
        try {
            BS bS = new BS();
            JmolMolecule[] jmolMoleculeArray = modelSet.getMolecules();
            int n3 = jmolMoleculeArray.length;
            Atom[] atomArray = modelSet.atoms;
            boolean bl = jmolMoleculeArray[n3 - 1].firstAtomIndex == modelSet.models[atomArray[n2].modelIndex].firstAtomIndex;
            P3 p3 = new P3();
            boolean bl2 = nArray[6] == 1;
            int n4 = n3;
            block2: while (--n4 >= 0 && jmolMoleculeArray[n4].firstAtomIndex >= n && jmolMoleculeArray[n4].firstAtomIndex < n2) {
                BS bS2 = jmolMoleculeArray[n4].atomList;
                p3.set(0.0f, 0.0f, 0.0f);
                int n5 = 0;
                int n6 = bS2.nextSetBit(0);
                while (n6 >= 0) {
                    if (bl || bl2) {
                        p3.setT(atomArray[n6]);
                        if (this.isNotCentroid(p3, 1, nArray, bl2)) {
                            if (bl) {
                                bS.set(n6);
                            }
                        } else if (!bl) {
                            continue block2;
                        }
                    } else {
                        p3.add(atomArray[n6]);
                        ++n5;
                    }
                    n6 = bS2.nextSetBit(n6 + 1);
                }
                if (!bl2 && (n5 <= 0 || !this.isNotCentroid(p3, n5, nArray, false))) continue;
                bS.or(bS2);
            }
            if (bS.nextSetBit(0) >= 0) {
                modelSet.viewer.deleteAtoms(bS, false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isNotCentroid(P3 p3, int n, int[] nArray, boolean bl) {
        p3.scale(1.0f / (float)n);
        this.toFractional(p3, false);
        if (bl) {
            return p3.x + 5.0E-6f <= (float)nArray[0] || p3.x - 5.0E-6f > (float)nArray[3] || p3.y + 5.0E-6f <= (float)nArray[1] || p3.y - 5.0E-6f > (float)nArray[4] || p3.z + 5.0E-6f <= (float)nArray[2] || p3.z - 5.0E-6f > (float)nArray[5];
        }
        return p3.x + 5.0E-6f <= (float)nArray[0] || p3.x + 1.0E-5f > (float)nArray[3] || p3.y + 5.0E-6f <= (float)nArray[1] || p3.y + 1.0E-5f > (float)nArray[4] || p3.z + 5.0E-6f <= (float)nArray[2] || p3.z + 1.0E-5f > (float)nArray[5];
    }
}

