/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import org.jmol.symmetry.HallRotation;
import org.jmol.symmetry.HallTranslation;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.util.Logger;
import org.jmol.util.Matrix4f;
import org.jmol.util.P3i;
import org.jmol.util.SB;

class HallInfo {
    String hallSymbol;
    String primitiveHallSymbol;
    char latticeCode = '\u0000';
    String latticeExtension;
    boolean isCentrosymmetric;
    int nRotations;
    RotationTerm[] rotationTerms = new RotationTerm[16];
    P3i vector12ths;
    String vectorCode;

    HallInfo(String string) {
        try {
            String string2 = this.hallSymbol = string.trim();
            string2 = this.extractLatticeInfo(string2);
            if (HallTranslation.getLatticeIndex(this.latticeCode) == 0) {
                return;
            }
            this.latticeExtension = HallTranslation.getLatticeExtension(this.latticeCode, this.isCentrosymmetric);
            string2 = this.extractVectorInfo(string2) + this.latticeExtension;
            if (Logger.debugging) {
                Logger.info("Hallinfo: " + string + " " + string2);
            }
            int n = 0;
            char c = '\u0000';
            this.primitiveHallSymbol = "P";
            while (string2.length() > 0 && this.nRotations < 16) {
                string2 = this.extractRotationInfo(string2, n, c);
                RotationTerm rotationTerm = this.rotationTerms[this.nRotations - 1];
                n = rotationTerm.order;
                c = rotationTerm.axisType;
                this.primitiveHallSymbol = this.primitiveHallSymbol + " " + rotationTerm.primitiveCode;
            }
            this.primitiveHallSymbol = this.primitiveHallSymbol + this.vectorCode;
        }
        catch (Exception exception) {
            Logger.error("Invalid Hall symbol");
            this.nRotations = 0;
        }
    }

    String dumpInfo() {
        SB sB = new SB();
        sB.append("\nHall symbol: ").append(this.hallSymbol).append("\nprimitive Hall symbol: ").append(this.primitiveHallSymbol).append("\nlattice type: ").append(this.getLatticeDesignation());
        for (int i = 0; i < this.nRotations; ++i) {
            sB.append("\n\nrotation term ").appendI(i + 1).append(this.rotationTerms[i].dumpInfo());
        }
        return sB.toString();
    }

    private String getLatticeDesignation() {
        return HallTranslation.getLatticeDesignation2(this.latticeCode, this.isCentrosymmetric);
    }

    private String extractLatticeInfo(String string) {
        int n = string.indexOf(" ");
        if (n < 0) {
            return "";
        }
        String string2 = string.substring(0, n).toUpperCase();
        this.latticeCode = string2.charAt(0);
        if (this.latticeCode == '-') {
            this.isCentrosymmetric = true;
            this.latticeCode = string2.charAt(1);
        }
        return string.substring(n + 1).trim();
    }

    private String extractVectorInfo(String string) {
        this.vector12ths = new P3i();
        this.vectorCode = "";
        int n = string.indexOf("(");
        int n2 = string.indexOf(")", n);
        if (n > 0 && n2 > n) {
            String string2 = string.substring(n + 1, n2);
            this.vectorCode = " (" + string2 + ")";
            string = string.substring(0, n).trim();
            n = string2.indexOf(" ");
            if (n >= 0) {
                this.vector12ths.x = Integer.parseInt(string2.substring(0, n));
                if ((n = (string2 = string2.substring(n + 1).trim()).indexOf(" ")) >= 0) {
                    this.vector12ths.y = Integer.parseInt(string2.substring(0, n));
                    string2 = string2.substring(n + 1).trim();
                }
            }
            this.vector12ths.z = Integer.parseInt(string2);
        }
        return string;
    }

    private String extractRotationInfo(String string, int n, char c) {
        String string2;
        int n2 = string.indexOf(" ");
        if (n2 >= 0) {
            string2 = string.substring(0, n2);
            string = string.substring(n2 + 1).trim();
        } else {
            string2 = string;
            string = "";
        }
        this.rotationTerms[this.nRotations] = new RotationTerm(string2, n, c);
        ++this.nRotations;
        return string;
    }

    class RotationTerm {
        String inputCode;
        String primitiveCode;
        String lookupCode;
        String translationString;
        HallRotation rotation;
        HallTranslation translation;
        Matrix4f seitzMatrix12ths = new Matrix4f();
        boolean isImproper;
        int order;
        char axisType = '\u0000';
        char diagonalReferenceAxis = '\u0000';
        boolean allPositive = true;

        RotationTerm(String string, int n, char c) {
            this.inputCode = string;
            string = string + "   ";
            if (string.charAt(0) == '-') {
                this.isImproper = true;
                string = string.substring(1);
            }
            this.primitiveCode = "";
            this.order = string.charAt(0) - 48;
            this.diagonalReferenceAxis = '\u0000';
            this.axisType = '\u0000';
            int n2 = 2;
            char c2 = string.charAt(1);
            block0 : switch (c2) {
                case 'x': 
                case 'y': 
                case 'z': {
                    switch (string.charAt(2)) {
                        case '\"': 
                        case '\'': {
                            this.diagonalReferenceAxis = c2;
                            c2 = string.charAt(2);
                            ++n2;
                        }
                    }
                }
                case '*': {
                    this.axisType = c2;
                    break;
                }
                case '\"': 
                case '\'': {
                    this.axisType = c2;
                    switch (string.charAt(2)) {
                        case 'x': 
                        case 'y': 
                        case 'z': {
                            this.diagonalReferenceAxis = string.charAt(2);
                            ++n2;
                            break block0;
                        }
                    }
                    this.diagonalReferenceAxis = c;
                    break;
                }
                default: {
                    this.axisType = (char)(this.order == 1 ? 95 : (HallInfo.this.nRotations == 0 ? 122 : (HallInfo.this.nRotations == 2 ? 42 : (n == 2 || n == 4 ? 120 : 39))));
                    string = string.substring(0, 1) + this.axisType + string.substring(1);
                }
            }
            this.primitiveCode = this.primitiveCode + (this.axisType == '_' ? "1" : string.substring(0, 2));
            if (this.diagonalReferenceAxis != '\u0000') {
                string = string.substring(0, 1) + this.diagonalReferenceAxis + this.axisType + string.substring(n2);
                this.primitiveCode = this.primitiveCode + this.diagonalReferenceAxis;
                n2 = 3;
            }
            this.lookupCode = string.substring(0, n2);
            this.rotation = HallRotation.lookup(this.lookupCode);
            if (this.rotation == null) {
                Logger.error("Rotation lookup could not find " + this.inputCode + " ? " + this.lookupCode);
                return;
            }
            this.translation = new HallTranslation('\u0000', null);
            this.translationString = "";
            int n3 = string.length();
            for (int i = n2; i < n3; ++i) {
                char c3 = string.charAt(i);
                HallTranslation hallTranslation = new HallTranslation(c3, P3i.new3(this.order, -1, -1));
                if (hallTranslation.translationCode == '\u0000') continue;
                this.translationString = this.translationString + "" + hallTranslation.translationCode;
                this.translation.rotationShift12ths += hallTranslation.rotationShift12ths;
                this.translation.vectorShift12ths.add(hallTranslation.vectorShift12ths);
            }
            this.primitiveCode = (this.isImproper ? "-" : "") + this.primitiveCode + this.translationString;
            if (this.isImproper) {
                this.seitzMatrix12ths.setM(this.rotation.seitzMatrixInv);
            } else {
                this.seitzMatrix12ths.setM(this.rotation.seitzMatrix);
            }
            this.seitzMatrix12ths.m03 = this.translation.vectorShift12ths.x;
            this.seitzMatrix12ths.m13 = this.translation.vectorShift12ths.y;
            this.seitzMatrix12ths.m23 = this.translation.vectorShift12ths.z;
            switch (this.axisType) {
                case 'x': {
                    this.seitzMatrix12ths.m03 += (float)this.translation.rotationShift12ths;
                    break;
                }
                case 'y': {
                    this.seitzMatrix12ths.m13 += (float)this.translation.rotationShift12ths;
                    break;
                }
                case 'z': {
                    this.seitzMatrix12ths.m23 += (float)this.translation.rotationShift12ths;
                }
            }
            if (HallInfo.this.vectorCode.length() > 0) {
                Matrix4f matrix4f = new Matrix4f();
                Matrix4f matrix4f2 = new Matrix4f();
                matrix4f.setIdentity();
                matrix4f2.setIdentity();
                matrix4f.m03 = HallInfo.this.vector12ths.x;
                matrix4f.m13 = HallInfo.this.vector12ths.y;
                matrix4f.m23 = HallInfo.this.vector12ths.z;
                matrix4f2.m03 = -HallInfo.this.vector12ths.x;
                matrix4f2.m13 = -HallInfo.this.vector12ths.y;
                matrix4f2.m23 = -HallInfo.this.vector12ths.z;
                this.seitzMatrix12ths.mul2(matrix4f, this.seitzMatrix12ths);
                this.seitzMatrix12ths.mulM4(matrix4f2);
            }
            if (Logger.debugging) {
                Logger.debug("code = " + string + "; primitive code =" + this.primitiveCode + "\n Seitz Matrix(12ths):" + this.seitzMatrix12ths);
            }
        }

        String dumpInfo() {
            SB sB = new SB();
            sB.append("\ninput code: ").append(this.inputCode).append("; primitive code: ").append(this.primitiveCode).append("\norder: ").appendI(this.order).append(this.isImproper ? " (improper axis)" : "");
            if (this.axisType != '_') {
                sB.append("; axisType: ").appendC(this.axisType);
                if (this.diagonalReferenceAxis != '\u0000') {
                    sB.appendC(this.diagonalReferenceAxis);
                }
            }
            if (this.translationString.length() > 0) {
                sB.append("; translation: ").append(this.translationString);
            }
            if (HallInfo.this.vectorCode.length() > 0) {
                sB.append("; vector offset:").append(HallInfo.this.vectorCode);
            }
            if (this.rotation != null) {
                sB.append("\noperator: ").append(this.getXYZ(this.allPositive)).append("\nSeitz matrix:\n").append(SymmetryOperation.dumpSeitz(this.seitzMatrix12ths));
            }
            return sB.toString();
        }

        String getXYZ(boolean bl) {
            return SymmetryOperation.getXYZFromMatrix(this.seitzMatrix12ths, true, bl, true);
        }
    }
}

