/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderspecial;

import org.jmol.modelset.Atom;
import org.jmol.render.ShapeRenderer;
import org.jmol.shape.Shape;
import org.jmol.shapespecial.Ellipsoids;
import org.jmol.util.BS;
import org.jmol.util.Matrix3f;
import org.jmol.util.Matrix4f;
import org.jmol.util.Normix;
import org.jmol.util.P3;
import org.jmol.util.P3i;
import org.jmol.util.Quadric;
import org.jmol.util.V3;
import org.jmol.viewer.JC;

public class EllipsoidsRenderer
extends ShapeRenderer {
    private Ellipsoids ellipsoids;
    private boolean drawDots;
    private boolean drawArcs;
    private boolean drawAxes;
    private boolean drawFill;
    private boolean drawBall;
    private boolean wireframeOnly;
    private int dotCount;
    private int[] coords;
    private V3[] axes;
    private final float[] factoredLengths = new float[3];
    private int diameter;
    private int diameter0;
    private int selectedOctant = -1;
    private P3i[] selectedPoints = new P3i[3];
    private int iCutout = -1;
    private Matrix3f mat = new Matrix3f();
    private Matrix3f mTemp = new Matrix3f();
    private Matrix4f mDeriv = new Matrix4f();
    private Matrix3f matScreenToCartesian = new Matrix3f();
    private Matrix3f matScreenToEllipsoid = new Matrix3f();
    private Matrix3f matEllipsoidToScreen = new Matrix3f();
    private double[] coef = new double[10];
    private final V3 v1 = new V3();
    private final V3 v2 = new V3();
    private final V3 v3 = new V3();
    private final P3 pt1 = new P3();
    private final P3 pt2 = new P3();
    private final P3i s0 = new P3i();
    private final P3i s1 = new P3i();
    private final P3i s2 = new P3i();
    private int dotScale;
    private static final float toRadians = (float)Math.PI / 180;
    private static final float[] cossin = new float[36];
    private boolean isSet;
    private final P3i[] screens = new P3i[32];
    private final P3[] points = new P3[6];
    private static int[] axisPoints;
    private static int[] octants;
    private int dx;
    private float perspectiveFactor;
    private P3 center;
    private static final V3[] unitVectors;
    private static final V3[] unitAxisVectors;
    private boolean fillArc;
    private BS bsTemp;

    public EllipsoidsRenderer() {
        int n;
        for (n = 0; n < this.points.length; ++n) {
            this.points[n] = new P3();
        }
        for (n = 0; n < this.screens.length; ++n) {
            this.screens[n] = new P3i();
        }
        this.bsTemp = new BS();
    }

    protected boolean render() {
        this.isSet = false;
        this.ellipsoids = (Ellipsoids)this.shape;
        if (this.ellipsoids.madset == null && !this.ellipsoids.haveEllipsoids) {
            return false;
        }
        boolean bl = false;
        Atom[] atomArray = this.modelSet.atoms;
        int n = this.modelSet.getAtomCount();
        while (--n >= 0) {
            Quadric[] quadricArray;
            Atom object = atomArray[n];
            if (!object.isVisible(this.myVisibilityFlag) || object.screenZ <= 1 || (quadricArray = object.getEllipsoid()) == null) continue;
            for (int i = 0; i < quadricArray.length; ++i) {
                if (quadricArray[i] == null || this.ellipsoids.madset[i] == null || this.ellipsoids.madset[i][n] == 0) continue;
                this.colix = Shape.getColix(this.ellipsoids.colixset[i], n, object);
                if (this.g3d.setColix(this.colix)) {
                    this.render1(object, quadricArray[i]);
                    continue;
                }
                bl = true;
            }
        }
        if (this.ellipsoids.haveEllipsoids) {
            for (Ellipsoids.Ellipsoid ellipsoid : this.ellipsoids.htEllipsoids.values()) {
                if (!ellipsoid.visible || !ellipsoid.isValid) continue;
                this.colix = ellipsoid.colix;
                if (this.g3d.setColix(this.colix)) {
                    this.renderEllipsoid(ellipsoid);
                    continue;
                }
                bl = true;
            }
        }
        this.coords = null;
        return bl;
    }

    private void renderEllipsoid(Ellipsoids.Ellipsoid ellipsoid) {
        if (!this.isSet) {
            this.isSet = this.setGlobals();
        }
        this.axes = ellipsoid.axes;
        for (int i = 0; i < 3; ++i) {
            this.factoredLengths[i] = ellipsoid.lengths[i];
        }
        this.viewer.transformPtScr(ellipsoid.center, this.s0);
        this.setMatrices();
        this.center = ellipsoid.center;
        this.setAxes();
        this.renderOne(this.s0.z, true);
    }

    private boolean setGlobals() {
        this.wireframeOnly = this.viewer.getBoolean(603979976) && this.viewer.getInMotion();
        this.drawAxes = this.viewer.getBooleanProperty("ellipsoidAxes");
        this.drawArcs = this.viewer.getBooleanProperty("ellipsoidArcs");
        this.drawBall = this.viewer.getBooleanProperty("ellipsoidBall") && !this.wireframeOnly;
        this.drawDots = this.viewer.getBooleanProperty("ellipsoidDots") && !this.wireframeOnly;
        this.drawFill = this.viewer.getBooleanProperty("ellipsoidFill") && !this.wireframeOnly;
        this.fillArc = this.drawFill && !this.drawBall;
        this.diameter0 = Math.round(((Float)this.viewer.getParameter("ellipsoidAxisDiameter")).floatValue() * 1000.0f);
        if (this.drawBall) {
            this.drawDots = false;
        }
        if (!(this.drawDots || this.drawArcs || this.drawBall)) {
            this.drawAxes = true;
        }
        if (this.drawDots) {
            this.drawArcs = false;
            this.drawFill = false;
            this.dotScale = this.viewer.getInt(0x21000010);
        }
        if (this.drawDots) {
            this.dotCount = (Integer)this.viewer.getParameter("ellipsoidDotCount");
            if (this.coords == null || this.coords.length != this.dotCount * 3) {
                this.coords = new int[this.dotCount * 3];
            }
        }
        Matrix4f matrix4f = this.viewer.getMatrixtransform();
        this.mat.setRow(0, matrix4f.m00, matrix4f.m01, matrix4f.m02);
        this.mat.setRow(1, matrix4f.m10, matrix4f.m11, matrix4f.m12);
        this.mat.setRow(2, matrix4f.m20, matrix4f.m21, matrix4f.m22);
        this.matScreenToCartesian.invertM(this.mat);
        return true;
    }

    private void render1(Atom atom, Quadric quadric) {
        if (!this.isSet) {
            this.isSet = this.setGlobals();
        }
        this.s0.set(atom.screenX, atom.screenY, atom.screenZ);
        boolean bl = true;
        int n = 3;
        while (--n >= 0) {
            this.factoredLengths[n] = quadric.lengths[n] * quadric.scale;
            if (Float.isNaN(this.factoredLengths[n])) {
                bl = false;
                continue;
            }
            if (!(this.factoredLengths[n] < 0.02f)) continue;
            this.factoredLengths[n] = 0.02f;
        }
        this.axes = quadric.vectors;
        if (this.axes == null) {
            this.axes = unitVectors;
        }
        this.setMatrices();
        this.center = atom;
        this.setAxes();
        if (this.g3d.isClippedXY(this.dx + this.dx, atom.screenX, atom.screenY)) {
            return;
        }
        this.renderOne(atom.screenZ, bl);
    }

    private void renderOne(int n, boolean bl) {
        this.diameter = (int)this.viewer.scaleToScreen(n, this.wireframeOnly ? 1 : this.diameter0);
        if (!bl || this.drawBall) {
            this.renderBall();
            if (!bl) {
                return;
            }
            if (this.drawArcs || this.drawAxes) {
                this.g3d.setColix(this.viewer.getColixBackgroundContrast());
                if (this.drawAxes) {
                    this.renderAxes();
                }
                if (this.drawArcs) {
                    this.renderArcs();
                }
                this.g3d.setColix(this.colix);
            }
        } else {
            if (this.drawAxes) {
                this.renderAxes();
            }
            if (this.drawArcs) {
                this.renderArcs();
            }
        }
        if (this.drawDots) {
            this.renderDots();
        }
    }

    private void setMatrices() {
        Quadric.setEllipsoidMatrix(this.axes, this.factoredLengths, this.v1, this.mat);
        this.matScreenToEllipsoid.mul2(this.mat, this.matScreenToCartesian);
        this.matEllipsoidToScreen.invertM(this.matScreenToEllipsoid);
        this.perspectiveFactor = this.viewer.scaleToPerspective(this.s0.z, 1.0f);
        this.matScreenToEllipsoid.mulf(1.0f / this.perspectiveFactor);
    }

    private void setAxes() {
        for (int i = 0; i < 6; ++i) {
            int n = axisPoints[i];
            int n2 = Math.abs(n) - 1;
            this.points[i].scaleAdd2(this.factoredLengths[n2] * (float)(n < 0 ? -1 : 1), this.axes[n2], this.center);
            this.pt1.setT(unitAxisVectors[i]);
            this.matEllipsoidToScreen.transform(this.pt1);
            this.screens[i].set(Math.round((float)this.s0.x + this.pt1.x * this.perspectiveFactor), Math.round((float)this.s0.y + this.pt1.y * this.perspectiveFactor), Math.round(this.pt1.z + (float)this.s0.z));
        }
        this.dx = 2 + (int)this.viewer.scaleToScreen(this.s0.z, Math.round((Float.isNaN(this.factoredLengths[2]) ? 1.0f : this.factoredLengths[2]) * 1000.0f));
    }

    private void renderBall() {
        this.setSelectedOctant();
        Quadric.getEquationForQuadricWithCenter(this.s0.x, this.s0.y, this.s0.z, this.matScreenToEllipsoid, this.v1, this.mTemp, this.coef, this.mDeriv);
        this.g3d.fillEllipsoid(this.center, this.points, this.s0.x, this.s0.y, this.s0.z, this.dx + this.dx, this.matScreenToEllipsoid, this.coef, this.mDeriv, this.selectedOctant, this.selectedOctant >= 0 ? this.selectedPoints : null);
    }

    private void renderAxes() {
        if (this.drawBall && this.drawFill) {
            this.g3d.fillCylinder((byte)2, this.diameter, this.s0, this.selectedPoints[0]);
            this.g3d.fillCylinder((byte)2, this.diameter, this.s0, this.selectedPoints[1]);
            this.g3d.fillCylinder((byte)2, this.diameter, this.s0, this.selectedPoints[2]);
            return;
        }
        this.g3d.fillCylinder((byte)2, this.diameter, this.screens[0], this.screens[1]);
        this.g3d.fillCylinder((byte)2, this.diameter, this.screens[2], this.screens[3]);
        this.g3d.fillCylinder((byte)2, this.diameter, this.screens[4], this.screens[5]);
    }

    private void renderDots() {
        int n = 0;
        while (n < this.coords.length) {
            float f;
            float f2 = (float)Math.random();
            float f3 = (float)Math.random();
            if (Float.isNaN(f = (float)Math.sqrt(1.0f - (f2 *= (float)(Math.random() > 0.5 ? -1 : 1)) * f2 - (f3 *= (float)(Math.random() > 0.5 ? -1 : 1)) * f3))) continue;
            f = (float)(Math.random() > 0.5 ? -1 : 1) * f;
            this.pt1.scaleAdd2(f2 * this.factoredLengths[0], this.axes[0], this.center);
            this.pt1.scaleAdd2(f3 * this.factoredLengths[1], this.axes[1], this.pt1);
            this.pt1.scaleAdd2(f * this.factoredLengths[2], this.axes[2], this.pt1);
            this.viewer.transformPtScr(this.pt1, this.s1);
            this.coords[n++] = this.s1.x;
            this.coords[n++] = this.s1.y;
            this.coords[n++] = this.s1.z;
        }
        this.g3d.drawPoints(this.dotCount, this.coords, this.dotScale);
    }

    private void renderArcs() {
        if (this.g3d.drawEllipse(this.center, this.points[0], this.points[2], this.fillArc, this.wireframeOnly)) {
            this.g3d.drawEllipse(this.center, this.points[2], this.points[5], this.fillArc, this.wireframeOnly);
            this.g3d.drawEllipse(this.center, this.points[5], this.points[0], this.fillArc, this.wireframeOnly);
            return;
        }
        for (int i = 1; i < 8; i += 2) {
            int n = i * 3;
            this.renderArc(octants[n], octants[n + 1]);
            this.renderArc(octants[n + 1], octants[n + 2]);
            this.renderArc(octants[n + 2], octants[n]);
        }
    }

    private void renderArc(int n, int n2) {
        this.v1.setT(this.points[n]);
        this.v1.sub(this.center);
        this.v2.setT(this.points[n2]);
        this.v2.sub(this.center);
        float f = this.v1.length();
        float f2 = this.v2.length();
        this.v1.normalize();
        this.v2.normalize();
        this.v3.cross(this.v1, this.v2);
        this.pt1.setT(this.points[n]);
        this.s1.setT(this.screens[n]);
        short s = Normix.get2SidedNormix(this.v3, this.bsTemp);
        if (!this.fillArc && !this.wireframeOnly) {
            this.screens[6].setT(this.s1);
        }
        int n3 = 0;
        int n4 = 0;
        while (n3 < 18) {
            this.pt2.scaleAdd2(cossin[n4] * f, this.v1, this.center);
            this.pt2.scaleAdd2(cossin[n4 + 1] * f2, this.v2, this.pt2);
            this.viewer.transformPtScr(this.pt2, this.s2);
            if (this.fillArc) {
                this.g3d.fillTriangle3CN(this.s0, this.colix, s, this.s1, this.colix, s, this.s2, this.colix, s);
            } else if (this.wireframeOnly) {
                this.g3d.fillCylinder((byte)2, this.diameter, this.s1, this.s2);
            } else {
                this.screens[n3 + 7].setT(this.s2);
            }
            this.pt1.setT(this.pt2);
            this.s1.setT(this.s2);
            ++n3;
            n4 += 2;
        }
        if (!this.fillArc && !this.wireframeOnly) {
            for (n3 = 0; n3 < 18; ++n3) {
                this.g3d.fillHermite(5, this.diameter, this.diameter, this.diameter, this.screens[n3 == 0 ? n3 + 6 : n3 + 5], this.screens[n3 + 6], this.screens[n3 + 7], this.screens[n3 == 17 ? n3 + 7 : n3 + 8]);
            }
        }
    }

    private void setSelectedOctant() {
        int n = Integer.MAX_VALUE;
        this.selectedOctant = -1;
        this.iCutout = -1;
        if (this.drawFill) {
            for (int i = 0; i < 8; ++i) {
                int n2 = octants[i * 3];
                int n3 = octants[i * 3 + 1];
                int n4 = octants[i * 3 + 2];
                int n5 = this.screens[n2].z + this.screens[n3].z + this.screens[n4].z;
                if (n5 >= n) continue;
                n = n5;
                this.iCutout = i;
            }
            this.selectedPoints[0] = this.screens[octants[this.iCutout * 3]];
            this.s1.setT(this.selectedPoints[0]);
            this.selectedPoints[1] = this.screens[octants[this.iCutout * 3 + 1]];
            this.s1.add(this.selectedPoints[1]);
            this.selectedPoints[2] = this.screens[octants[this.iCutout * 3 + 2]];
            this.s1.add(this.selectedPoints[2]);
            this.s1.scaleAdd(-3, this.s0, this.s1);
            this.pt1.set(this.s1.x, this.s1.y, this.s1.z);
            this.matScreenToEllipsoid.transform(this.pt1);
            this.selectedOctant = Quadric.getOctant(this.pt1);
        }
    }

    static {
        int n = 0;
        for (int i = 5; i <= 90; i += 5) {
            EllipsoidsRenderer.cossin[n++] = (float)Math.cos((float)i * ((float)Math.PI / 180));
            EllipsoidsRenderer.cossin[n++] = (float)Math.sin((float)i * ((float)Math.PI / 180));
        }
        axisPoints = new int[]{-1, 1, -2, 2, -3, 3};
        octants = new int[]{5, 0, 3, 5, 2, 0, 4, 0, 2, 4, 3, 0, 5, 2, 1, 5, 1, 3, 4, 3, 1, 4, 1, 2};
        unitVectors = new V3[]{JC.axisX, JC.axisY, JC.axisZ};
        unitAxisVectors = new V3[]{JC.axisNX, JC.axisX, JC.axisNY, JC.axisY, JC.axisNZ, JC.axisZ};
    }
}

