/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderbio;

import org.jmol.renderbio.BioShapeRenderer;
import org.jmol.shapebio.BioShape;
import org.jmol.shapebio.Strands;
import org.jmol.util.P3i;

public class StrandsRenderer
extends BioShapeRenderer {
    protected int strandCount;
    protected float strandSeparation;
    protected float baseOffset;

    protected void renderBioShape(BioShape bioShape) {
        if (!this.setStrandCount()) {
            return;
        }
        this.render1();
    }

    protected boolean setStrandCount() {
        if (this.wingVectors == null) {
            return false;
        }
        this.strandCount = this.viewer.getStrandCount(((Strands)this.shape).shapeID);
        this.strandSeparation = this.strandCount <= 1 ? 0.0f : 1.0f / (float)(this.strandCount - 1);
        this.baseOffset = (this.strandCount & 1) == 0 ? this.strandSeparation / 2.0f : this.strandSeparation;
        return true;
    }

    protected void render1() {
        P3i[] p3iArray;
        int n = this.strandCount >> 1;
        while (--n >= 0) {
            float f = (float)n * this.strandSeparation + this.baseOffset;
            p3iArray = this.calcScreens(f);
            this.render1Strand(p3iArray);
            this.viewer.freeTempScreens(p3iArray);
            p3iArray = this.calcScreens(-f);
            this.render1Strand(p3iArray);
            this.viewer.freeTempScreens(p3iArray);
        }
        if (this.strandCount % 2 == 1) {
            p3iArray = this.calcScreens(0.0f);
            this.render1Strand(p3iArray);
            this.viewer.freeTempScreens(p3iArray);
        }
    }

    private void render1Strand(P3i[] p3iArray) {
        int n = this.bsVisible.nextSetBit(0);
        while (n >= 0) {
            this.renderHermiteCylinder(p3iArray, n);
            n = this.bsVisible.nextSetBit(n + 1);
        }
    }
}

