/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.constant;

import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Group;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EnumHBondType {
    NOT,
    ACCEPTOR,
    DONOR,
    UNKNOWN;


    public static EnumHBondType getType(Atom atom) {
        Group group = atom.getGroup();
        short s = group.getGroupID();
        boolean bl = !atom.isHetero();
        switch (atom.getElementNumber()) {
            default: {
                return NOT;
            }
            case 1: {
                if (atom.getCovalentBondCount() == 0) {
                    return DONOR;
                }
                Bond[] bondArray = atom.getBonds();
                if (bondArray == null) {
                    return NOT;
                }
                switch (bondArray[0].getOtherAtom(atom).getElementNumber()) {
                    case 7: 
                    case 8: 
                    case 16: {
                        return DONOR;
                    }
                }
                return NOT;
            }
            case 7: {
                if (atom == group.getNitrogenAtom()) {
                    return DONOR;
                }
                if (s == 9) {
                    return UNKNOWN;
                }
                if (atom.getCovalentHydrogenCount() > 0) {
                    return DONOR;
                }
                if (bl) {
                    return ACCEPTOR;
                }
                switch (s) {
                    case 2: 
                    case 3: 
                    case 6: 
                    case 12: 
                    case 19: {
                        return DONOR;
                    }
                }
                return UNKNOWN;
            }
            case 8: 
        }
        if (atom == group.getCarbonylOxygenAtom() || atom.getFormalCharge() == -1) {
            return ACCEPTOR;
        }
        if (atom.getCovalentBondCount() == 0 || atom.getCovalentHydrogenCount() > 0) {
            return UNKNOWN;
        }
        if (bl) {
            return ACCEPTOR;
        }
        switch (s) {
            case 4: 
            case 7: {
                return ACCEPTOR;
            }
        }
        return UNKNOWN;
    }

    public static boolean isPossibleHBond(EnumHBondType enumHBondType, EnumHBondType enumHBondType2) {
        return enumHBondType == NOT || enumHBondType2 == NOT ? false : enumHBondType == UNKNOWN || enumHBondType != enumHBondType2;
    }
}

