/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Logger;

public class ShelxReader
extends AtomSetCollectionReader {
    private String[] sfacElementSymbols;
    private boolean isCmdf;
    String[] tokens;
    private static final String unsupportedRecordTypes = ";ZERR;DISP;UNIT;LAUE;REM;MORE;TIME;HKLF;OMIT;SHEL;BASF;TWIN;EXTI;SWAT;HOPE;MERG;SPEC;RESI;MOVE;ANIS;AFIX;HFIX;FRAG;FEND;EXYZ;EXTI;EADP;EQIV;CONN;PART;BIND;FREE;DFIX;DANG;BUMP;SAME;SADI;CHIV;FLAT;DELU;SIMU;DEFS;ISOR;NCSY;SUMP;L.S.;CGLS;BLOC;DAMP;STIR;WGHT;FVAR;BOND;CONF;MPLA;RTAB;HTAB;LIST;ACTA;SIZE;TEMP;WPDB;FMAP;GRID;PLAN;MOLE;";
    private static final String[] supportedRecordTypes = new String[]{"TITL", "CELL", "SPGR", "SFAC", "LATT", "SYMM", "NOTE", "ATOM", "END"};

    public void initializeReader() {
        this.setFractionalCoordinates(true);
    }

    protected boolean checkLine() throws Exception {
        int n;
        while ((n = (this.line = this.line.trim()).length()) > 0 && this.line.charAt(n - 1) == '=') {
            this.line = this.line.substring(0, n - 1) + this.readLine();
        }
        this.tokens = this.getTokens();
        if (this.tokens.length == 0) {
            return true;
        }
        String string = this.tokens[0].toUpperCase();
        if (string.equals("TITL")) {
            if (!this.doGetModel(++this.modelNumber, null)) {
                return this.checkLastModel();
            }
            this.sfacElementSymbols = null;
            this.applySymmetryAndSetTrajectory();
            this.setFractionalCoordinates(true);
            this.atomSetCollection.newAtomSet();
            this.atomSetCollection.setAtomSetName(this.line.substring(4).trim());
            return true;
        }
        if (!this.doProcessLines || n < 3) {
            return true;
        }
        if (unsupportedRecordTypes.indexOf(";" + string + ";") >= 0) {
            return true;
        }
        int n2 = supportedRecordTypes.length;
        while (--n2 >= 0) {
            if (!string.equals(supportedRecordTypes[n2])) continue;
            this.processSupportedRecord(n2);
            return true;
        }
        if (!this.isCmdf) {
            this.assumeAtomRecord();
        }
        return true;
    }

    private void processSupportedRecord(int n) throws Exception {
        switch (n) {
            case 0: 
            case 8: {
                break;
            }
            case 1: {
                this.cell();
                this.setSymmetryOperator("x,y,z");
                break;
            }
            case 2: {
                this.setSpaceGroupName(ShelxReader.parseTrimmedAt(this.line, 4));
                break;
            }
            case 3: {
                this.parseSfacRecord();
                break;
            }
            case 4: {
                this.parseLattRecord();
                break;
            }
            case 5: {
                this.parseSymmRecord();
                break;
            }
            case 6: {
                this.isCmdf = true;
                break;
            }
            case 7: {
                this.isCmdf = true;
                this.processCmdfAtoms();
            }
        }
    }

    private void parseLattRecord() throws Exception {
        this.parseTokenStr(this.line);
        int n = this.parseInt();
        this.atomSetCollection.setLatticeParameter(n);
    }

    private void parseSymmRecord() throws Exception {
        this.setSymmetryOperator(this.line.substring(4).trim());
    }

    private void cell() throws Exception {
        int n = this.tokens.length - 6;
        if (n == 2) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("wavelength", Float.valueOf(this.parseFloatStr(this.tokens[1])));
        }
        for (int i = 0; i < 6; ++i) {
            this.setUnitCellItem(i, this.parseFloatStr(this.tokens[i + n]));
        }
    }

    private void parseSfacRecord() {
        boolean bl = true;
        int n = this.tokens.length;
        while (bl && --n >= 1) {
            String string = this.tokens[n];
            bl = Atom.isValidElementSymbolNoCaseSecondChar(string);
        }
        String[] stringArray = ShelxReader.getTokensStr(this.line.substring(4));
        if (bl) {
            this.parseSfacElementSymbols(stringArray);
        } else {
            this.parseSfacCoefficients(stringArray);
        }
    }

    private void parseSfacElementSymbols(String[] stringArray) {
        if (this.sfacElementSymbols == null) {
            this.sfacElementSymbols = stringArray;
        } else {
            int n = this.sfacElementSymbols.length;
            int n2 = stringArray.length;
            this.sfacElementSymbols = ArrayUtil.arrayCopyS(this.sfacElementSymbols, n + n2);
            int n3 = n2;
            while (--n3 >= 0) {
                this.sfacElementSymbols[n + n3] = stringArray[n3];
            }
        }
    }

    private void parseSfacCoefficients(String[] stringArray) {
        float f = this.parseFloatStr(stringArray[1]);
        float f2 = this.parseFloatStr(stringArray[3]);
        float f3 = this.parseFloatStr(stringArray[5]);
        float f4 = this.parseFloatStr(stringArray[7]);
        float f5 = this.parseFloatStr(stringArray[9]);
        int n = Math.round(f + f2 + f3 + f4 + f5);
        String string = ShelxReader.getElementSymbol(n);
        int n2 = 0;
        if (this.sfacElementSymbols == null) {
            this.sfacElementSymbols = new String[1];
        } else {
            n2 = this.sfacElementSymbols.length;
            this.sfacElementSymbols = ArrayUtil.arrayCopyS(this.sfacElementSymbols, n2 + 1);
            this.sfacElementSymbols[n2] = string;
        }
        this.sfacElementSymbols[n2] = string;
    }

    private void assumeAtomRecord() throws Exception {
        String string = this.tokens[0];
        int n = this.parseIntStr(this.tokens[1]);
        float f = this.parseFloatStr(this.tokens[2]);
        float f2 = this.parseFloatStr(this.tokens[3]);
        float f3 = this.parseFloatStr(this.tokens[4]);
        if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3)) {
            Logger.error("skipping line " + this.line);
            return;
        }
        Atom atom = this.atomSetCollection.addNewAtom();
        atom.atomName = string;
        if (this.sfacElementSymbols != null && --n >= 0 && n < this.sfacElementSymbols.length) {
            atom.elementSymbol = this.sfacElementSymbols[n];
        }
        this.setAtomCoordXYZ(atom, f, f2, f3);
        if (this.tokens.length == 12) {
            float[] fArray = new float[8];
            fArray[0] = this.parseFloatStr(this.tokens[6]);
            fArray[1] = this.parseFloatStr(this.tokens[7]);
            fArray[2] = this.parseFloatStr(this.tokens[8]);
            fArray[3] = this.parseFloatStr(this.tokens[11]);
            fArray[4] = this.parseFloatStr(this.tokens[10]);
            fArray[5] = this.parseFloatStr(this.tokens[9]);
            for (int i = 0; i < 6; ++i) {
                if (!Float.isNaN(fArray[i])) continue;
                Logger.error("Bad anisotropic Uij data: " + this.line);
                return;
            }
            this.atomSetCollection.setAnisoBorU(atom, fArray, 8);
        }
    }

    private void processCmdfAtoms() throws Exception {
        while (this.readLine() != null && this.line.length() > 10) {
            Atom atom = this.atomSetCollection.addNewAtom();
            this.tokens = this.getTokens();
            atom.elementSymbol = this.getSymbol(this.tokens[0]);
            atom.atomName = this.tokens[1];
            this.setAtomCoordXYZ(atom, this.parseFloatStr(this.tokens[2]), this.parseFloatStr(this.tokens[3]), this.parseFloatStr(this.tokens[4]));
        }
    }

    private String getSymbol(String string) {
        if (string == null) {
            return "Xx";
        }
        int n = string.length();
        if (n < 2) {
            return string;
        }
        char c = string.charAt(1);
        if (c >= 'a' && c <= 'z') {
            return string.substring(0, 2);
        }
        return "" + string.charAt(0);
    }
}

