/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.List;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class TlsDataOnlyReader
extends AtomSetCollectionReader {
    private List<Map<String, Object>> vTlsModels;
    private SB sbTlsErrors;
    private int tlsGroupID;
    private static final String[] TLnn = new String[]{"11", "22", "33", "12", "13", "23"};
    private static final String[] Snn = new String[]{"22", "11", "12", "13", "23", "21", "31", "32"};

    protected void initializeReader() throws Exception {
        this.readTlsData();
        this.continuing = false;
    }

    private void readTlsData() throws Exception {
        Object object;
        this.vTlsModels = new List();
        Hashtable<String, Object> hashtable = null;
        List list = null;
        Hashtable<String, Object> hashtable2 = null;
        List list2 = new List();
        while (this.rd() != null) {
            int n;
            int n2;
            char c;
            object = TlsDataOnlyReader.getTokensStr((String)this.line.replace('\'', ' '));
            if (((String[])object).length == 0) continue;
            if (object[0].equals("TLS")) {
                hashtable = new Hashtable<String, Object>();
                list = new List();
                hashtable.put("ranges", list);
                list2.addLast(hashtable);
                hashtable.put("id", ++this.tlsGroupID);
                continue;
            }
            if (object[0].equals("RANGE")) {
                hashtable2 = new Hashtable<String, Object>();
                c = ((String)object[1]).charAt(0);
                char c2 = ((String)object[3]).charAt(0);
                int n3 = PT.parseInt((String)object[2]);
                n2 = PT.parseInt((String)object[4]);
                if (c == c2) {
                    hashtable2.put("chains", "" + c + c2);
                    if (n3 <= n2) {
                        hashtable2.put("residues", new int[]{n3, n2});
                        list.addLast(hashtable2);
                        continue;
                    }
                    this.tlsAddError(" TLS group residues are not in order (range ignored)");
                    continue;
                }
                this.tlsAddError(" TLS group chains are different (range ignored)");
                continue;
            }
            if (((String)object[0]).equals("ORIGIN")) {
                P3 p3 = new P3();
                hashtable.put("origin", p3);
                p3.set(this.parseFloatStr((String)object[1]), this.parseFloatStr((String)object[2]), this.parseFloatStr((String)object[3]));
                if (!Float.isNaN(p3.x) && !Float.isNaN(p3.y) && !Float.isNaN(p3.z)) continue;
                p3.set(Float.NaN, Float.NaN, Float.NaN);
                this.tlsAddError("invalid origin: " + this.line);
                continue;
            }
            if (!((String)object[0]).equals("T") && !((String)object[0]).equals("L") && !((String)object[0]).equals("S")) continue;
            c = ((String)object[0]).charAt(0);
            String[] stringArray = c == 'S' ? Snn : TLnn;
            float[][] fArray = new float[3][3];
            hashtable.put("t" + c, fArray);
            for (n2 = 1; n2 < ((Object)object).length; ++n2) {
                n = stringArray[n2].charAt(0) - 49;
                int n4 = stringArray[n2].charAt(1) - 49;
                fArray[n][n4] = this.parseFloatStr((String)object[++n2]);
                if (n >= n4) continue;
                fArray[n4][n] = fArray[n][n4];
            }
            if (c == 'S') {
                fArray[0][0] = -fArray[0][0];
            }
            for (n2 = 0; n2 < 3; ++n2) {
                for (n = 0; n < 3; ++n) {
                    if (!Float.isNaN(fArray[n2][n])) continue;
                    this.tlsAddError("invalid tensor: " + Escape.escapeFloatAA((float[][])fArray, (boolean)false));
                }
            }
        }
        Logger.info((String)(this.tlsGroupID + " TLS groups read"));
        object = new Hashtable();
        ((Hashtable)object).put("groupCount", this.tlsGroupID);
        ((Hashtable)object).put("groups", list2);
        this.vTlsModels.addLast(object);
        this.htParams.put("vTlsModels", this.vTlsModels);
    }

    private void tlsAddError(String string) {
        if (this.sbTlsErrors == null) {
            this.sbTlsErrors = new SB();
        }
        this.sbTlsErrors.append(this.fileName).appendC('\t').append("TLS group ").appendI(this.tlsGroupID).appendC('\t').append(string).appendC('\n');
    }
}

