/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.CU;
import javajs.util.List;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.java.BS;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.modelset.Atom;
import org.jmol.script.T;
import org.jmol.shape.Mesh;
import org.jmol.util.BSUtil;
import org.jmol.util.BoxInfo;
import org.jmol.util.C;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.MeshSurface;
import org.jmol.viewer.Viewer;

public class IsosurfaceMesh
extends Mesh {
    public JvxlData jvxlData = new JvxlData();
    public int vertexIncrement = 1;
    public int firstRealVertex = -1;
    public int dataType;
    public boolean hasGridPoints;
    Object calculatedArea;
    Object calculatedVolume;
    Object info;
    private Map<Integer, Integer> assocGridPointMap;
    private Map<Integer, V3> assocGridPointNormals;
    private int mergeAssociatedNormalCount;
    P3[] centers;
    float[] contourValues;
    short[] contourColixes;
    public ColorEncoder colorEncoder;
    BS bsVdw;
    public boolean colorPhased;

    IsosurfaceMesh(String string, short s, int n) {
        this.mesh1(string, s, n);
        this.checkByteCount = 2;
        this.jvxlData.version = Viewer.getJmolVersion();
    }

    void clearType(String string, boolean bl) {
        this.clear(string);
        this.jvxlData.clear();
        this.assocGridPointMap = null;
        this.assocGridPointNormals = null;
        this.bsVdw = null;
        this.calculatedVolume = null;
        this.calculatedArea = null;
        this.centers = null;
        this.colorEncoder = null;
        this.colorPhased = false;
        this.firstRealVertex = -1;
        this.hasGridPoints = bl;
        this.isColorSolid = true;
        this.mergeAssociatedNormalCount = 0;
        this.nSets = 0;
        this.polygonColixes = null;
        this.showPoints = bl;
        this.surfaceSet = null;
        this.vertexColixes = null;
        this.vertexColorMap = null;
        this.vertexIncrement = 1;
        this.vertexSets = null;
        this.vertexValues = null;
    }

    void allocVertexColixes() {
        if (this.vertexColixes == null) {
            this.vertexColixes = new short[this.vertexCount];
            int n = this.vertexCount;
            while (--n >= 0) {
                this.vertexColixes[n] = this.colix;
            }
        }
        this.isColorSolid = false;
    }

    int addVertexCopy(P3 p3, float f, int n, boolean bl) {
        int n2 = this.addVCVal(p3, f);
        switch (n) {
            case -1: {
                if (this.firstRealVertex >= 0) break;
                this.firstRealVertex = n2;
                break;
            }
            case -2: {
                this.hasGridPoints = true;
                break;
            }
            case -3: {
                this.vertexIncrement = 3;
                break;
            }
            default: {
                if (this.firstRealVertex < 0) {
                    this.firstRealVertex = n2;
                }
                if (!bl) break;
                if (this.assocGridPointMap == null) {
                    this.assocGridPointMap = new Hashtable<Integer, Integer>();
                }
                this.assocGridPointMap.put(n2, n + this.mergeAssociatedNormalCount);
            }
        }
        return n2;
    }

    public void setTranslucent(boolean bl, float f) {
        this.colix = C.getColixTranslucent3((short)this.colix, (boolean)bl, (float)f);
        if (this.vertexColixes != null) {
            int n = this.vertexCount;
            while (--n >= 0) {
                this.vertexColixes[n] = C.getColixTranslucent3((short)this.vertexColixes[n], (boolean)bl, (float)f);
            }
        }
    }

    public void setMerged(boolean bl) {
        this.isMerged = bl;
        this.mergePolygonCount0 = bl ? this.polygonCount : 0;
        int n = this.mergeVertexCount0 = bl ? this.vertexCount : 0;
        if (bl) {
            this.mergeAssociatedNormalCount += this.jvxlData.nPointsX * this.jvxlData.nPointsY * this.jvxlData.nPointsZ;
            this.assocGridPointNormals = null;
        }
    }

    protected void sumVertexNormals(P3[] p3Array, V3[] v3Array) {
        this.sumVertexNormals2(p3Array, v3Array);
        if (this.assocGridPointMap != null && v3Array.length > 0 && !this.isMerged) {
            if (this.assocGridPointNormals == null) {
                this.assocGridPointNormals = new Hashtable<Integer, V3>();
            }
            for (Map.Entry<Integer, Integer> entry : this.assocGridPointMap.entrySet()) {
                Integer n = entry.getValue();
                if (!this.assocGridPointNormals.containsKey(n)) {
                    this.assocGridPointNormals.put(n, V3.new3((float)0.0f, (float)0.0f, (float)0.0f));
                }
                this.assocGridPointNormals.get(n).add((T3)v3Array[entry.getKey()]);
            }
            for (Map.Entry<Integer, Integer> entry : this.assocGridPointMap.entrySet()) {
                v3Array[entry.getKey().intValue()] = this.assocGridPointNormals.get(entry.getValue());
            }
        }
    }

    P3[] getCenters() {
        if (this.centers != null) {
            return this.centers;
        }
        this.centers = new P3[this.polygonCount];
        for (int i = 0; i < this.polygonCount; ++i) {
            int[] nArray = this.polygonIndexes[i];
            if (nArray == null) continue;
            P3 p3 = this.centers[i] = P3.newP((T3)this.vertices[nArray[0]]);
            p3.add((T3)this.vertices[nArray[1]]);
            p3.add((T3)this.vertices[nArray[2]]);
            p3.scale(0.33333334f);
        }
        return this.centers;
    }

    P4 getFacePlane(int n, V3 v3) {
        P4 p4 = new P4();
        Measure.getPlaneThroughPoints((P3)this.vertices[this.polygonIndexes[n][0]], (P3)this.vertices[this.polygonIndexes[n][1]], (P3)this.vertices[this.polygonIndexes[n][2]], (V3)v3, (V3)this.vAB, (V3)this.vAC, (P4)p4);
        return p4;
    }

    public List<Object>[] getContours() {
        int n;
        List<Object>[] listArray;
        int n2 = this.jvxlData.nContours;
        if (n2 == 0 || this.polygonIndexes == null) {
            return null;
        }
        boolean bl = this.havePlanarContours = this.jvxlData.jvxlPlane != null;
        if (this.havePlanarContours) {
            return null;
        }
        if (n2 < 0) {
            n2 = -1 - n2;
        }
        if ((listArray = this.jvxlData.vContours) != null) {
            for (int i = 0; i < n2; ++i) {
                if (listArray[i].size() > 6) {
                    return this.jvxlData.vContours;
                }
                JvxlCoder.set3dContourVector(listArray[i], this.polygonIndexes, this.vertices);
            }
            return this.jvxlData.vContours;
        }
        listArray = new List[n2];
        for (n = 0; n < n2; ++n) {
            listArray[n] = new List();
        }
        if (this.jvxlData.contourValuesUsed == null) {
            float f = (this.jvxlData.valueMappedToBlue - this.jvxlData.valueMappedToRed) / (float)(n2 + 1);
            for (int i = 0; i < n2; ++i) {
                float f2 = this.jvxlData.valueMappedToRed + (float)(i + 1) * f;
                this.get3dContour(listArray[i], f2, this.jvxlData.contourColixes[i]);
            }
            Logger.info((String)(n2 + " contour lines; separation = " + f));
        } else {
            for (n = 0; n < n2; ++n) {
                float f = this.jvxlData.contourValuesUsed[n];
                this.get3dContour(listArray[n], f, this.jvxlData.contourColixes[n]);
            }
        }
        this.jvxlData.contourColixes = new short[n2];
        this.jvxlData.contourValues = new float[n2];
        for (int i = 0; i < n2; ++i) {
            this.jvxlData.contourValues[i] = ((Float)listArray[i].get(2)).floatValue();
            this.jvxlData.contourColixes[i] = ((short[])listArray[i].get(3))[0];
        }
        this.jvxlData.vContours = listArray;
        return listArray;
    }

    private void get3dContour(List<Object> list, float f, short s) {
        BS bS = BSUtil.newBitSet((int)this.polygonCount);
        SB sB = new SB();
        int n = C.getArgb((short)s);
        IsosurfaceMesh.setContourVector(list, this.polygonCount, bS, f, s, n, sB);
        for (int i = 0; i < this.polygonCount; ++i) {
            if (!this.setABC(i)) continue;
            IsosurfaceMesh.addContourPoints(list, bS, i, sB, this.vertices, this.vertexValues, this.iA, this.iB, this.iC, f);
        }
    }

    public static void setContourVector(List<Object> list, int n, BS bS, float f, short s, int n2, SB sB) {
        list.add(0, (Object)n);
        list.add(1, (Object)bS);
        list.add(2, (Object)Float.valueOf(f));
        list.add(3, (Object)new short[]{s});
        list.add(4, (Object)new int[]{n2});
        list.add(5, (Object)sB);
    }

    public static void addContourPoints(List<Object> list, BS bS, int n, SB sB, P3[] p3Array, float[] fArray, int n2, int n3, int n4, float f) {
        float f2;
        P3 p3 = null;
        P3 p32 = null;
        int n5 = 0;
        float f3 = IsosurfaceMesh.checkPt(fArray, n2, n3, f);
        if (!Float.isNaN(f3)) {
            p3 = IsosurfaceMesh.getContourPoint(p3Array, n2, n3, f3);
            n5 |= 1;
        }
        float f4 = f2 = f3 == 1.0f ? Float.NaN : IsosurfaceMesh.checkPt(fArray, n3, n4, f);
        if (!Float.isNaN(f2)) {
            p32 = IsosurfaceMesh.getContourPoint(p3Array, n3, n4, f2);
            if (n5 == 0) {
                p3 = p32;
                f3 = f2;
            }
            n5 |= 2;
        }
        switch (n5) {
            case 0: {
                return;
            }
            case 1: {
                if (f3 == 0.0f) {
                    return;
                }
            }
            case 2: {
                float f5 = f2 = f2 == 1.0f ? Float.NaN : IsosurfaceMesh.checkPt(fArray, n4, n2, f);
                if (Float.isNaN(f2)) break;
                p32 = IsosurfaceMesh.getContourPoint(p3Array, n4, n2, f2);
                n5 |= 4;
            }
        }
        switch (n5) {
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                return;
            }
        }
        bS.set(n);
        JvxlCoder.appendContourTriangleIntersection(n5, f3, f2, sB);
        list.addLast((Object)p3);
        list.addLast((Object)p32);
    }

    private static float checkPt(float[] fArray, int n, int n2, float f) {
        float f2;
        float f3 = fArray[n];
        return f == f3 ? 0.0f : (f == (f2 = fArray[n2]) ? 1.0f : (f3 < f == f < f2 ? (f - f3) / (f2 - f3) : Float.NaN));
    }

    private static P3 getContourPoint(P3[] p3Array, int n, int n2, float f) {
        P3 p3 = new P3();
        p3.sub2((T3)p3Array[n2], (T3)p3Array[n]);
        p3.scaleAdd2(f, (T3)p3, (T3)p3Array[n]);
        return p3;
    }

    public void setDiscreteColixes(float[] fArray, short[] sArray) {
        if (fArray != null) {
            this.jvxlData.contourValues = fArray;
        }
        if (fArray == null || fArray.length == 0) {
            this.jvxlData.contourValues = this.jvxlData.contourValuesUsed;
            fArray = this.jvxlData.contourValuesUsed;
        }
        if (sArray == null && this.jvxlData.contourColixes != null) {
            sArray = this.jvxlData.contourColixes;
        } else {
            this.jvxlData.contourColixes = sArray;
            this.jvxlData.contourColors = C.getHexCodes((short[])sArray);
        }
        if (this.vertices == null || this.vertexValues == null || fArray == null) {
            return;
        }
        int n = fArray.length;
        float f = fArray[n - 1];
        this.colorCommand = null;
        boolean bl = sArray != null && sArray.length > 0;
        boolean bl2 = this.isColorSolid = bl && this.jvxlData.jvxlPlane != null;
        if (this.jvxlData.vContours != null) {
            if (bl) {
                for (int i = 0; i < this.jvxlData.vContours.length; ++i) {
                    short s;
                    ((short[])this.jvxlData.vContours[i].get((int)3))[0] = s = sArray[i % sArray.length];
                    ((int[])this.jvxlData.vContours[i].get((int)4))[0] = C.getArgb((short)s);
                }
            }
            return;
        }
        short s = 0;
        this.polygonColixes = new short[this.polygonCount];
        block1: for (int i = 0; i < this.polygonCount; ++i) {
            int[] nArray = this.polygonIndexes[i];
            if (nArray == null) continue;
            this.polygonColixes[i] = s;
            float f2 = (this.vertexValues[nArray[0]] + this.vertexValues[nArray[1]] + this.vertexValues[nArray[2]]) / 3.0f;
            int n2 = n;
            while (--n2 >= 0) {
                if (!(f2 >= fArray[n2]) || !(f2 < f)) continue;
                this.polygonColixes[i] = bl ? sArray[n2 % sArray.length] : (short)0;
                continue block1;
            }
        }
    }

    Map<String, Object> getContourList(Viewer viewer) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("values", this.jvxlData.contourValuesUsed == null ? this.jvxlData.contourValues : this.jvxlData.contourValuesUsed);
        List list = new List();
        if (this.jvxlData.contourColixes != null) {
            for (int i = 0; i < this.jvxlData.contourColixes.length; ++i) {
                list.addLast((Object)CU.colorPtFromInt2((int)C.getArgb((short)this.jvxlData.contourColixes[i])));
            }
            hashtable.put("colors", list);
        }
        return hashtable;
    }

    void deleteContours() {
        this.jvxlData.contourValuesUsed = null;
        this.jvxlData.contourValues = null;
        this.jvxlData.contourColixes = null;
        this.jvxlData.vContours = null;
    }

    void setVertexColorMap() {
        this.vertexColorMap = new Hashtable();
        short s = -999;
        BS bS = null;
        int n = this.vertexCount;
        while (--n >= 0) {
            String string;
            short s2 = this.vertexColixes[n];
            if (s2 != s && (bS = (BS)this.vertexColorMap.get(string = C.getHexCode((short)(s = s2)))) == null) {
                bS = new BS();
                this.vertexColorMap.put(string, bS);
            }
            bS.set(n);
        }
    }

    void setVertexColixesForAtoms(Viewer viewer, short[] sArray, int[] nArray, BS bS) {
        this.jvxlData.vertexDataOnly = true;
        this.jvxlData.vertexColors = new int[this.vertexCount];
        this.jvxlData.nVertexColors = this.vertexCount;
        Atom[] atomArray = viewer.modelSet.atoms;
        for (int i = this.mergeVertexCount0; i < this.vertexCount; ++i) {
            short s;
            int n = this.vertexSource[i];
            if (n < 0 || !bS.get(n)) continue;
            this.vertexColixes[i] = C.copyColixTranslucency((short)this.colix, (short)atomArray[n].getColix());
            this.jvxlData.vertexColors[i] = viewer.getColorArgbOrGray(this.vertexColixes[i]);
            short s2 = s = sArray == null ? (short)0 : sArray[nArray[n]];
            if (s == 0) {
                s = atomArray[n].getColix();
            }
            this.vertexColixes[i] = C.copyColixTranslucency((short)this.colix, (short)s);
        }
    }

    void colorVertices(short s, BS bS, boolean bl) {
        int n;
        if (this.vertexSource == null) {
            return;
        }
        s = C.copyColixTranslucency((short)this.colix, (short)s);
        BS bS2 = bl ? new BS() : bS;
        this.checkAllocColixes();
        if (bl) {
            for (n = 0; n < this.vertexCount; ++n) {
                int n2 = this.vertexSource[n];
                if (n2 < 0 || !bS.get(n2)) continue;
                this.vertexColixes[n] = s;
                if (bS2 == null) continue;
                bS2.set(n);
            }
        } else {
            for (n = 0; n < this.vertexCount; ++n) {
                if (!bS2.get(n)) continue;
                this.vertexColixes[n] = s;
            }
        }
        if (!bl) {
            return;
        }
        String string = C.getHexCode((short)s);
        if (this.vertexColorMap == null) {
            this.vertexColorMap = new Hashtable();
        }
        IsosurfaceMesh.addColorToMap(this.vertexColorMap, string, bS);
    }

    void checkAllocColixes() {
        if (this.vertexColixes == null || this.vertexColorMap == null && this.isColorSolid) {
            this.allocVertexColixes();
        }
        this.isColorSolid = false;
    }

    private static void addColorToMap(Map<String, BS> map, String string, BS bS) {
        BS bS2 = null;
        for (Map.Entry<String, BS> entry : map.entrySet()) {
            if (entry.getKey() == string) {
                bS2 = entry.getValue();
                bS2.or(bS);
                continue;
            }
            entry.getValue().andNot(bS);
        }
        if (bS2 == null) {
            map.put(string, bS);
        }
    }

    void setJvxlColorMap(boolean bl) {
        this.jvxlData.diameter = this.diameter;
        this.jvxlData.color = C.getHexCode((short)this.colix);
        this.jvxlData.meshColor = this.meshColix == 0 ? null : C.getHexCode((short)this.meshColix);
        this.jvxlData.translucency = C.getColixTranslucencyFractional((short)this.colix);
        this.jvxlData.rendering = this.getRendering().substring(1);
        String string = this.jvxlData.colorScheme = this.colorEncoder == null ? null : this.colorEncoder.getColorScheme();
        if (this.jvxlData.vertexColors == null) {
            int n = this.jvxlData.nVertexColors = this.vertexColorMap == null ? 0 : this.vertexColorMap.size();
        }
        if (this.vertexColorMap == null || this.vertexSource == null || !bl) {
            return;
        }
        if (this.jvxlData.vertexColorMap == null) {
            this.jvxlData.vertexColorMap = new Hashtable<String, BS>();
        }
        for (Map.Entry entry : this.vertexColorMap.entrySet()) {
            BS bS = (BS)entry.getValue();
            if (bS.isEmpty()) continue;
            String string2 = (String)entry.getKey();
            BS bS2 = new BS();
            for (int i = 0; i < this.vertexCount; ++i) {
                if (!bS.get(this.vertexSource[i])) continue;
                bS2.set(i);
            }
            IsosurfaceMesh.addColorToMap(this.jvxlData.vertexColorMap, string2, bS2);
        }
        this.jvxlData.nVertexColors = this.jvxlData.vertexColorMap.size();
        if (this.jvxlData.vertexColorMap.size() == 0) {
            this.jvxlData.vertexColorMap = null;
        }
    }

    void setColorCommand() {
        if (this.colorEncoder == null) {
            return;
        }
        this.colorCommand = this.colorEncoder.getColorScheme();
        if (this.colorCommand.equals("inherit")) {
            this.colorCommand = "#inherit;";
            return;
        }
        if (this.colorCommand == null) {
            return;
        }
        this.colorCommand = "color $" + (Character.isLetter(this.thisID.charAt(0)) && this.thisID.indexOf(" ") < 0 ? this.thisID : "\"" + this.thisID + "\"") + " \"" + this.colorCommand + "\" range " + (this.jvxlData.isColorReversed ? this.jvxlData.valueMappedToBlue + " " + this.jvxlData.valueMappedToRed : this.jvxlData.valueMappedToRed + " " + this.jvxlData.valueMappedToBlue);
    }

    void setColorsFromJvxlData(int n) {
        this.diameter = this.jvxlData.diameter;
        if (n != -1) {
            if (n != Integer.MIN_VALUE && n != Integer.MAX_VALUE) {
                this.colix = C.getColix((int)n);
            } else if (this.jvxlData.color != null) {
                this.colix = C.getColixS((String)this.jvxlData.color);
            }
        }
        if (this.colix == 0) {
            this.colix = (short)5;
        }
        this.colix = C.getColixTranslucent3((short)this.colix, (this.jvxlData.translucency != 0.0f ? 1 : 0) != 0, (float)this.jvxlData.translucency);
        if (this.jvxlData.meshColor != null) {
            this.meshColix = C.getColixS((String)this.jvxlData.meshColor);
        }
        this.setJvxlDataRendering();
        boolean bl = this.isColorSolid = !this.jvxlData.isBicolorMap && this.jvxlData.vertexColors == null && this.jvxlData.vertexColorMap == null;
        if (this.colorEncoder != null) {
            if (this.jvxlData.vertexColorMap == null) {
                if (this.jvxlData.colorScheme != null) {
                    String string = this.jvxlData.colorScheme;
                    boolean bl2 = string.startsWith("translucent ");
                    if (bl2) {
                        string = string.substring(12);
                    }
                    this.colorEncoder.setColorScheme(string, bl2);
                    this.remapColors(null, null, Float.NaN);
                }
            } else {
                if (this.jvxlData.baseColor != null) {
                    int n2 = this.vertexCount;
                    while (--n2 >= 0) {
                        this.vertexColixes[n2] = this.colix;
                    }
                }
                for (Map.Entry<String, BS> entry : this.jvxlData.vertexColorMap.entrySet()) {
                    BS bS = entry.getValue();
                    short s = C.copyColixTranslucency((short)this.colix, (short)C.getColixS((String)entry.getKey()));
                    int n3 = bS.nextSetBit(0);
                    while (n3 >= 0) {
                        this.vertexColixes[n3] = s;
                        n3 = bS.nextSetBit(n3 + 1);
                    }
                }
            }
        }
    }

    void setJvxlDataRendering() {
        if (this.jvxlData.rendering != null) {
            String[] stringArray = PT.getTokens((String)this.jvxlData.rendering);
            for (int i = 0; i < stringArray.length; ++i) {
                this.setTokenProperty(T.getTokFromName((String)stringArray[i]), true);
            }
        }
    }

    void remapColors(Viewer viewer, ColorEncoder colorEncoder, float f) {
        int n;
        if (colorEncoder == null) {
            colorEncoder = this.colorEncoder;
        }
        if (colorEncoder == null) {
            colorEncoder = this.colorEncoder = new ColorEncoder(null);
        }
        this.colorEncoder = colorEncoder;
        this.setColorCommand();
        if (Float.isNaN(f)) {
            f = C.getColixTranslucencyLevel((short)this.colix);
        } else {
            this.colix = C.getColixTranslucent3((short)this.colix, (boolean)true, (float)f);
        }
        float f2 = colorEncoder.lo;
        float f3 = colorEncoder.hi;
        boolean bl = this.vertexSource != null && colorEncoder.currentPalette == 15;
        this.vertexColorMap = null;
        this.polygonColixes = null;
        this.jvxlData.baseColor = null;
        this.jvxlData.vertexCount = this.vertexCount;
        if (this.vertexValues == null || this.jvxlData.vertexCount == 0) {
            return;
        }
        if (this.vertexColixes == null || this.vertexColixes.length != this.vertexCount) {
            this.allocVertexColixes();
        }
        if (bl) {
            this.jvxlData.vertexDataOnly = true;
            this.jvxlData.vertexColors = new int[this.vertexCount];
            this.jvxlData.nVertexColors = this.vertexCount;
            Atom[] atomArray = viewer.getModelSet().atoms;
            for (int i = this.mergeVertexCount0; i < this.vertexCount; ++i) {
                int n2 = this.vertexSource[i];
                if (n2 >= atomArray.length) continue;
                this.vertexColixes[i] = C.copyColixTranslucency((short)this.colix, (short)atomArray[n2].getColix());
                this.jvxlData.vertexColors[i] = viewer.getColorArgbOrGray(this.vertexColixes[i]);
            }
            return;
        }
        this.jvxlData.vertexColors = null;
        this.jvxlData.vertexColorMap = null;
        if (this.jvxlData.isBicolorMap) {
            for (int i = this.mergeVertexCount0; i < this.vertexCount; ++i) {
                this.vertexColixes[i] = C.copyColixTranslucency((short)this.colix, (short)(this.vertexValues[i] < 0.0f ? this.jvxlData.minColorIndex : this.jvxlData.maxColorIndex));
            }
            return;
        }
        this.jvxlData.isColorReversed = colorEncoder.isReversed;
        if (f3 != Float.MAX_VALUE) {
            this.jvxlData.valueMappedToRed = f2;
            this.jvxlData.valueMappedToBlue = f3;
        }
        colorEncoder.setRange(this.jvxlData.valueMappedToRed, this.jvxlData.valueMappedToBlue, this.jvxlData.isColorReversed);
        boolean bl2 = C.isColixTranslucent((short)this.colix);
        if (colorEncoder.isTranslucent) {
            if (!bl2) {
                this.colix = C.getColixTranslucent3((short)this.colix, (boolean)true, (float)0.5f);
            }
            bl2 = false;
        }
        int n3 = this.vertexCount;
        while (--n3 >= this.mergeVertexCount0) {
            this.vertexColixes[n3] = colorEncoder.getColorIndex(this.vertexValues[n3]);
        }
        this.setTranslucent(bl2, f);
        this.colorEncoder = colorEncoder;
        List<Object>[] listArray = this.getContours();
        if (listArray != null) {
            n = listArray.length;
            while (--n >= 0) {
                float f4 = ((Float)listArray[n].get(2)).floatValue();
                short[] sArray = (short[])listArray[n].get(3);
                sArray[0] = colorEncoder.getColorIndex(f4);
                int[] nArray = (int[])listArray[n].get(4);
                nArray[0] = C.getArgb((short)sArray[0]);
            }
        }
        if (this.contourValues != null) {
            this.contourColixes = new short[this.contourValues.length];
            for (n = 0; n < this.contourValues.length; ++n) {
                this.contourColixes[n] = colorEncoder.getColorIndex(this.contourValues[n]);
            }
            this.setDiscreteColixes(null, null);
        }
        this.jvxlData.isJvxlPrecisionColor = true;
        JvxlCoder.jvxlCreateColorData(this.jvxlData, this.vertexValues);
        this.setColorCommand();
        this.isColorSolid = false;
    }

    public void reinitializeLightingAndColor(Viewer viewer) {
        this.initialize(this.lighting, null, null);
        if (this.colorEncoder != null || this.jvxlData.isBicolorMap) {
            this.vertexColixes = null;
            this.remapColors(viewer, null, Float.NaN);
        }
    }

    public P3[] getBoundingBox() {
        return this.jvxlData.boundingBox;
    }

    private void resetBoundingBox() {
        BoxInfo boxInfo = new BoxInfo();
        if (this.polygonCount == 0) {
            int n = this.vertexCount;
            while (--n >= 0) {
                boxInfo.addBoundBoxPoint(this.vertices[n]);
            }
        } else {
            BS bS = new BS();
            int n = this.polygonCount;
            while (--n >= 0) {
                if (!this.setABC(n)) continue;
                if (!bS.get(this.iA)) {
                    boxInfo.addBoundBoxPoint(this.vertices[this.iA]);
                    bS.set(this.iA);
                }
                if (!bS.get(this.iB)) {
                    boxInfo.addBoundBoxPoint(this.vertices[this.iB]);
                    bS.set(this.iB);
                }
                if (bS.get(this.iC)) continue;
                boxInfo.addBoundBoxPoint(this.vertices[this.iC]);
                bS.set(this.iC);
            }
        }
        this.jvxlData.boundingBox = boxInfo.getBoundBoxPoints(false);
    }

    protected void merge(MeshData meshData) {
        int n = this.vertexCount + (meshData == null ? 0 : meshData.vertexCount);
        if (this.polygonIndexes == null) {
            this.polygonIndexes = new int[0][0];
        }
        if (meshData != null && meshData.polygonIndexes == null) {
            meshData.polygonIndexes = new int[0][0];
        }
        int n2 = (this.bsSlabDisplay == null || this.polygonCount == 0 ? this.polygonCount : this.bsSlabDisplay.cardinality()) + (meshData == null || meshData.polygonCount == 0 ? 0 : (meshData.bsSlabDisplay == null ? meshData.polygonCount : meshData.bsSlabDisplay.cardinality()));
        if (this.vertices == null) {
            this.vertices = new P3[0];
        }
        this.vertices = (P3[])AU.ensureLength((Object)this.vertices, (int)n);
        this.vertexValues = AU.ensureLengthA((float[])this.vertexValues, (int)n);
        boolean bl = this.vertexSource != null && (meshData == null || meshData.vertexSource != null);
        this.vertexSource = AU.ensureLengthI((int[])this.vertexSource, (int)n);
        int[][] nArray = AU.newInt2((int)n2);
        int n3 = IsosurfaceMesh.mergePolygons((MeshSurface)this, 0, 0, nArray);
        if (meshData != null) {
            n3 = IsosurfaceMesh.mergePolygons(meshData, n3, this.vertexCount, nArray);
            int n4 = 0;
            while (n4 < meshData.vertexCount) {
                this.vertices[this.vertexCount] = meshData.vertices[n4];
                this.vertexValues[this.vertexCount] = meshData.vertexValues[n4];
                if (bl) {
                    this.vertexSource[this.vertexCount] = meshData.vertexSource[n4];
                }
                ++n4;
                ++this.vertexCount;
            }
        }
        this.polygonCount = this.polygonCount0 = n2;
        this.vertexCount = this.vertexCount0 = n;
        if (n2 > 0) {
            this.resetSlab();
        }
        this.polygonIndexes = nArray;
    }

    private static int mergePolygons(MeshSurface meshSurface, int n, int n2, int[][] nArray) {
        for (int i = 0; i < meshSurface.polygonCount; ++i) {
            int[] nArray2 = meshSurface.polygonIndexes[i];
            if (nArray2 == null || meshSurface.bsSlabDisplay != null && !meshSurface.bsSlabDisplay.get(i)) continue;
            nArray[n++] = meshSurface.polygonIndexes[i];
            if (n2 <= 0) continue;
            int n3 = 0;
            while (n3 < 3) {
                int n4 = n3++;
                nArray2[n4] = nArray2[n4] + n2;
            }
        }
        return n;
    }

    public SymmetryInterface getUnitCell() {
        return this.spanningVectors == null ? null : ((SymmetryInterface)Interface.getOptionInterface((String)"symmetry.Symmetry")).getUnitCell((T3[])this.spanningVectors, true);
    }

    protected void slabBrillouin(P3[] p3Array) {
        P3[] p3Array2;
        Object[] objectArray = p3Array2 = p3Array == null ? this.spanningVectors : p3Array;
        if (p3Array2 == null) {
            return;
        }
        P3[] p3Array3 = new P3[27];
        p3Array3[0] = P3.newP((T3)p3Array2[0]);
        int n = 0;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    if (i == 0 && j == 0 && k == 0) continue;
                    p3Array3[++n] = P3.newP((T3)p3Array3[0]);
                    p3Array3[n].scaleAdd2((float)i, (T3)p3Array2[1], (T3)p3Array3[n]);
                    p3Array3[n].scaleAdd2((float)j, (T3)p3Array2[2], (T3)p3Array3[n]);
                    p3Array3[n].scaleAdd2((float)k, (T3)p3Array2[3], (T3)p3Array3[n]);
                }
            }
        }
        System.out.println("draw line1 {0 0 0} color red" + Escape.eP((T3)this.spanningVectors[1]));
        System.out.println("draw line2 {0 0 0} color green" + Escape.eP((T3)this.spanningVectors[2]));
        System.out.println("draw line3 {0 0 0} color blue" + Escape.eP((T3)this.spanningVectors[3]));
        P3 p3 = new P3();
        P4 p4 = new P4();
        V3 v3 = new V3();
        V3 v32 = new V3();
        BS bS = new BS();
        Hashtable hashtable = new Hashtable();
        this.bsSlabGhost = new BS();
        for (int i = 1; i < 27; ++i) {
            v3.setT((T3)p3Array3[i]);
            Measure.getBisectingPlane((P3)p3Array3[0], (V3)v3, (P3)p3, (V3)v32, (P4)p4);
            this.getIntersection(1.0f, p4, null, null, null, null, null, false, false, 135266319, true);
            bS.clearAll();
            hashtable.clear();
            int n2 = this.bsSlabGhost.nextSetBit(0);
            while (n2 >= 0) {
                if (this.setABC(n2)) {
                    int n3;
                    int[] nArray = AU.arrayCopyRangeI((int[])this.polygonIndexes[n2], (int)0, (int)-1);
                    for (n3 = 0; n3 < 3; ++n3) {
                        int n4 = nArray[n3];
                        nArray[n3] = this.addIntersectionVertex(this.vertices[n4], this.vertexValues[n4], this.vertexSource == null ? 0 : this.vertexSource[n4], this.vertexSets == null ? 0 : this.vertexSets[n4], hashtable, 0, n4);
                        if (n4 == nArray[n3] || !bS.get(n4)) continue;
                        bS.set(nArray[n3]);
                    }
                    this.addPolygonC(nArray, 0, this.bsSlabDisplay);
                    for (n3 = 0; n3 < 3; ++n3) {
                        if (bS.get(nArray[n3])) continue;
                        bS.set(nArray[n3]);
                        this.vertices[nArray[n3]].sub((T3)v3);
                    }
                }
                n2 = this.bsSlabGhost.nextSetBit(n2 + 1);
            }
            if (this.bsSlabGhost.nextSetBit(0) < 0) continue;
            this.bsSlabGhost.clearAll();
            i = 0;
        }
        this.bsSlabGhost = null;
        this.resetBoundingBox();
    }

    protected float getMinDistance2ForVertexGrouping() {
        float f;
        if (this.jvxlData.boundingBox != null && this.jvxlData.boundingBox[0] != null && (f = this.jvxlData.boundingBox[1].distanceSquared((T3)this.jvxlData.boundingBox[0])) < 5.0f) {
            return 1.0E-10f;
        }
        return 1.0E-8f;
    }

    public BS getVisibleVertexBitSet() {
        BS bS = this.getVisibleVBS();
        if (this.jvxlData.thisSet >= 0) {
            for (int i = 0; i < this.vertexCount; ++i) {
                if (this.vertexSets[i] == this.jvxlData.thisSet) continue;
                bS.clear(i);
            }
        }
        return bS;
    }

    public void updateCoordinates(M4 m4, BS bS) {
        boolean bl;
        boolean bl2 = bl = bS == null;
        if (!bl) {
            for (int i = 0; i < this.connections.length; ++i) {
                if (this.connections[i] < 0 || !bS.get(this.connections[i])) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            return;
        }
        if (this.mat4 == null) {
            this.mat4 = M4.newM(null);
        }
        this.mat4.mul2(m4, this.mat4);
        this.recalcAltVertices = true;
    }
}

