/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.CU;
import javajs.util.P3;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.readers.PolygonFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;

class EfvetReader
extends PolygonFileReader {
    private int[] vertexMap;

    EfvetReader() {
    }

    @Override
    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2PFR(surfaceGenerator, bufferedReader);
        this.jvxlFileHeaderBuffer.append("efvet file format\nvertices and triangles only\n");
        JvxlCoder.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
        this.hasColorData = true;
    }

    @Override
    void getSurfaceData() throws Exception {
        this.getHeader();
        this.getVertices();
        this.getTriangles();
        Logger.info((String)("efvet file contains " + this.nVertices + " vertices and " + this.nTriangles + " triangles"));
    }

    private void getHeader() throws Exception {
        this.skipTo("<efvet", null);
        while (this.readLine().length() > 0 && this.line.indexOf(">") < 0) {
            this.jvxlFileHeaderBuffer.append("# " + this.line + "\n");
        }
        Logger.info((String)this.jvxlFileHeaderBuffer.toString());
    }

    private void getVertices() throws Exception {
        P3 p3 = new P3();
        float f = 0.0f;
        this.skipTo("<vertices", "count");
        this.jvxlData.vertexCount = this.nVertices = this.parseInt();
        this.vertexMap = new int[this.nVertices + 1];
        this.jvxlData.vertexColors = null;
        if (this.params.fileIndex == 0) {
            this.jvxlData.vertexColors = new int[this.nVertices];
            this.jvxlData.nVertexColors = 0;
        }
        float[] fArray = new float[this.jvxlData.vertexColors == null ? 3 : 9];
        this.skipTo("property=", null);
        this.line = this.line.replace('\"', ' ');
        String[] stringArray = this.getTokens();
        int n = this.params.fileIndex;
        if (n > 0 && n < stringArray.length) {
            Logger.info((String)("property " + stringArray[n]));
        } else {
            Logger.info((String)this.line);
        }
        for (int i = 0; i < this.nVertices; ++i) {
            int n2;
            this.skipTo("<vertex", "image");
            this.parseFloatArray(fArray, null, ">");
            p3.set(fArray[0], fArray[1], fArray[2]);
            this.skipTo(null, "property");
            for (n2 = 0; n2 < n; ++n2) {
                f = this.parseFloat();
            }
            if (this.isAnisotropic) {
                this.setVertexAnisotropy(p3);
            }
            if ((n2 = (this.vertexMap[i + 1] = this.addVC(p3, f, i))) < 0 || this.jvxlData.vertexColors == null) continue;
            this.jvxlData.vertexColors[n2] = CU.colorTriadToFFRGB((float)fArray[6], (float)fArray[7], (float)fArray[8]);
            ++this.jvxlData.nVertexColors;
        }
    }

    private void getTriangles() throws Exception {
        this.skipTo("<triangle_array", "count");
        this.nTriangles = this.parseInt();
        for (int i = 0; i < this.nTriangles; ++i) {
            this.skipTo("<triangle", "vertex");
            int n = this.getInt();
            int n2 = this.getInt();
            int n3 = this.getInt();
            if (n < 0 || n2 < 0 || n3 < 0) continue;
            this.addTriangleCheck(n, n2, n3, 7, 0, false, 0);
        }
    }

    private int getInt() {
        return this.vertexMap[this.parseInt()];
    }
}

