/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import javajs.util.List;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Matrix;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.SymmetryInterface;
import org.jmol.modelset.ModelSet;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.Parser;
import org.jmol.util.Quaternion;

class SymmetryOperation
extends M4 {
    String xyzOriginal;
    String xyz;
    private boolean doNormalize = true;
    boolean isFinalized;
    private int opId;
    private P3 atomTest;
    private P3 temp3;
    private String[] myLabels;
    int modDim;
    float[] linearRotTrans;
    Matrix rsvs;
    private boolean isBio;
    private static final String[] twelfths = new String[]{"0", "1/12", "1/6", "1/4", "1/3", "5/12", "1/2", "7/12", "2/3", "3/4", "5/6", "11/12"};
    static final String[] labelsXYZ = new String[]{"x", "y", "z"};
    static final String[] labelsXn = new String[]{"x1", "x2", "x3", "x4", "x5", "x6", "x7", "x8", "x9", "x10", "x11", "x12", "x13"};
    static final String[] labelsXnSub = new String[]{"x", "y", "z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j"};

    SymmetryOperation(SymmetryOperation symmetryOperation, P3[] p3Array, int n, int n2, boolean bl) {
        this.doNormalize = bl;
        if (symmetryOperation == null) {
            this.opId = n2;
            return;
        }
        this.xyzOriginal = symmetryOperation.xyzOriginal;
        this.xyz = symmetryOperation.xyz;
        this.opId = symmetryOperation.opId;
        this.modDim = symmetryOperation.modDim;
        this.myLabels = symmetryOperation.myLabels;
        this.setM(symmetryOperation);
        this.linearRotTrans = symmetryOperation.linearRotTrans;
        if (this.linearRotTrans.length > 16) {
            this.setGamma();
        }
        if (!symmetryOperation.isFinalized) {
            this.doFinalize();
        }
        if (bl) {
            this.setOffset(p3Array, n, n2);
        }
    }

    private void setGamma() {
        int n;
        int n2;
        int n3 = 3 + this.modDim;
        this.rsvs = new Matrix((double[][])null, n3 + 1, n3 + 1);
        double[][] dArray = this.rsvs.getArray();
        int n4 = 0;
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 3; ++n) {
                dArray[n2][n] = this.linearRotTrans[n4++];
            }
            dArray[n2][n3] = this.linearRotTrans[n4++];
        }
        n4 += 4;
        for (n2 = 3; n2 < 3 + this.modDim; ++n2) {
            for (n = 3; n < 3 + this.modDim; ++n) {
                dArray[n2][n] = this.linearRotTrans[n4++];
            }
            dArray[n2][n3] = this.linearRotTrans[n4++];
        }
        dArray[n3][n3] = 1.0;
    }

    void doFinalize() {
        this.m03 /= 12.0f;
        this.m13 /= 12.0f;
        this.m23 /= 12.0f;
        if (this.modDim > 0) {
            double[][] dArray = this.rsvs.getArray();
            int n = dArray.length - 1;
            while (--n >= 0) {
                double[] dArray2 = dArray[n];
                int n2 = 3 + this.modDim;
                dArray2[n2] = dArray2[n2] / 12.0;
            }
        }
        this.isFinalized = true;
    }

    String getXyz(boolean bl) {
        return bl && this.modDim == 0 || this.xyzOriginal == null ? this.xyz : this.xyzOriginal;
    }

    void newPoint(P3 p3, P3 p32, int n, int n2, int n3) {
        if (this.temp3 == null) {
            this.temp3 = new P3();
        }
        this.temp3.setT((T3)p3);
        this.transform2((T3)this.temp3, (T3)this.temp3);
        p32.set(this.temp3.x + (float)n, this.temp3.y + (float)n2, this.temp3.z + (float)n3);
    }

    String dumpInfo() {
        return "\n" + this.xyz + "\ninternal matrix representation:\n" + this.toString();
    }

    static final String dumpSeitz(M4 m4) {
        return new SB().append("{\t").appendI((int)m4.m00).append("\t").appendI((int)m4.m01).append("\t").appendI((int)m4.m02).append("\t").append(SymmetryOperation.twelfthsOf(m4.m03)).append("\t}\n").append("{\t").appendI((int)m4.m10).append("\t").appendI((int)m4.m11).append("\t").appendI((int)m4.m12).append("\t").append(SymmetryOperation.twelfthsOf(m4.m13)).append("\t}\n").append("{\t").appendI((int)m4.m20).append("\t").appendI((int)m4.m21).append("\t").appendI((int)m4.m22).append("\t").append(SymmetryOperation.twelfthsOf(m4.m23)).append("\t}\n").append("{\t0\t0\t0\t1\t}\n").toString();
    }

    static final String dumpCanonicalSeitz(M4 m4) {
        return new SB().append("{\t").appendI((int)m4.m00).append("\t").appendI((int)m4.m01).append("\t").appendI((int)m4.m02).append("\t").append(SymmetryOperation.twelfthsOf((m4.m03 + 12.0f) % 12.0f)).append("\t}\n").append("{\t").appendI((int)m4.m10).append("\t").appendI((int)m4.m11).append("\t").appendI((int)m4.m12).append("\t").append(SymmetryOperation.twelfthsOf((m4.m13 + 12.0f) % 12.0f)).append("\t}\n").append("{\t").appendI((int)m4.m20).append("\t").appendI((int)m4.m21).append("\t").appendI((int)m4.m22).append("\t").append(SymmetryOperation.twelfthsOf((m4.m23 + 12.0f) % 12.0f)).append("\t}\n").append("{\t0\t0\t0\t1\t}\n").toString();
    }

    boolean setMatrixFromXYZ(String string, int n) {
        if (string == null) {
            return false;
        }
        this.xyzOriginal = string;
        string = string.toLowerCase();
        int n2 = 16;
        this.modDim = n;
        if (n > 0) {
            n2 = 16 + (n + 1) * (n + 1);
            this.myLabels = labelsXn;
        }
        this.linearRotTrans = new float[n2];
        boolean bl = string.startsWith("!");
        if (bl) {
            string = string.substring(1);
        }
        if (string.indexOf("xyz matrix:") == 0) {
            this.xyz = string;
            Parser.parseStringInfestedFloatArray((String)string, null, (float[])this.linearRotTrans);
            return this.setFromMatrix(null, bl);
        }
        if (string.indexOf("[[") == 0) {
            string = string.replace('[', ' ').replace(']', ' ').replace(',', ' ');
            Parser.parseStringInfestedFloatArray((String)string, null, (float[])this.linearRotTrans);
            for (int i = 0; i < n2; ++i) {
                float f = this.linearRotTrans[i];
                if (!Float.isNaN(f)) continue;
                return false;
            }
            this.setA(this.linearRotTrans, 0);
            if (n2 > 16) {
                this.setGamma();
            }
            this.isFinalized = true;
            if (bl) {
                this.invertM(this);
            }
            this.isBio = string.indexOf("bio") >= 0;
            this.xyz = this.isBio ? this.toString() : SymmetryOperation.getXYZFromMatrix(this, false, false, false);
            return true;
        }
        String string2 = SymmetryOperation.getMatrixFromString(this, string, this.linearRotTrans, false);
        if (string2 == null) {
            return false;
        }
        this.setA(this.linearRotTrans, 0);
        if (n2 > 16) {
            this.setGamma();
        }
        if (bl) {
            this.invertM(this);
            this.xyz = SymmetryOperation.getXYZFromMatrix(this, true, false, false);
        } else {
            this.xyz = string2;
        }
        if (Logger.debugging) {
            Logger.debug((String)("" + (Object)((Object)this)));
        }
        return true;
    }

    boolean setFromMatrix(float[] fArray, boolean bl) {
        float f = 0.0f;
        int n = 0;
        this.myLabels = this.modDim == 0 ? labelsXYZ : labelsXn;
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.modDim + 3) {
            boolean bl2;
            if (Float.isNaN(this.linearRotTrans[n3])) {
                return false;
            }
            f = this.linearRotTrans[n3];
            if (Math.abs(f) < 1.0E-5f) {
                f = 0.0f;
            }
            boolean bl3 = n3 < 16 ? n3 % 4 == 3 : (bl2 = (n3 - 16) % (this.modDim + 1) == this.modDim);
            if (bl2) {
                if (fArray != null) {
                    f /= 12.0f;
                    if (n < fArray.length) {
                        f += fArray[n++];
                    }
                }
                f = SymmetryOperation.normalizeTwelfths((float)((f < 0.0f ? -1 : 1) * Math.round(Math.abs(f * 12.0f))) / 12.0f, this.doNormalize);
                ++n2;
            }
            this.linearRotTrans[n3] = f;
            if (n3 == 11) {
                n3 += 4;
            }
            ++n3;
        }
        this.linearRotTrans[15] = 1.0f;
        this.setA(this.linearRotTrans, 0);
        if (this.linearRotTrans.length > 16) {
            this.setGamma();
        }
        boolean bl4 = this.isFinalized = fArray == null;
        if (bl) {
            this.invertM(this);
        }
        this.xyz = SymmetryOperation.getXYZFromMatrix(this, true, false, false);
        return true;
    }

    static String getMatrixFromString(SymmetryOperation symmetryOperation, String string, float[] fArray, boolean bl) {
        int n;
        String[] stringArray;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = symmetryOperation == null ? 0 : symmetryOperation.modDim;
        int n3 = 4 + n2;
        boolean bl5 = symmetryOperation != null && symmetryOperation.doNormalize;
        fArray[15] = 1.0f;
        if (n2 > 0) {
            fArray[fArray.length - 1] = 1.0f;
        }
        String[] stringArray2 = stringArray = symmetryOperation == null || n2 == 0 ? null : symmetryOperation.myLabels;
        if (stringArray == null) {
            stringArray = labelsXYZ;
        }
        string = string.toLowerCase();
        string = string + ",";
        if (n2 > 0) {
            n = labelsXn.length;
            while (--n >= 0) {
                string = PT.simpleReplace((String)string, (String)labelsXn[n], (String)labelsXnSub[n]);
            }
        }
        n = 0;
        int n4 = 0;
        int n5 = 0;
        float f = 0.0f;
        float f2 = 1.0f;
        String string2 = "";
        String string3 = "";
        block11: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': 
                case '!': 
                case '\'': 
                case '{': 
                case '}': {
                    continue block11;
                }
                case '-': {
                    bl4 = true;
                    continue block11;
                }
                case '+': {
                    bl4 = false;
                    continue block11;
                }
                case '/': {
                    bl2 = true;
                    continue block11;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'x': 
                case 'y': 
                case 'z': {
                    int n6;
                    int n7 = n6 = bl4 ? -1 : 1;
                    if (bl && f != 0.0f) {
                        n6 = (int)((float)n6 * f);
                        f = 0.0f;
                    }
                    n = n5 < 3 ? n5 * 4 : 16 + (n5 - 3) * (n2 + 1);
                    n4 = n;
                    int n8 = c - (c >= 'x' ? 120 : 97);
                    fArray[n + n8] = n6;
                    string2 = string2 + SymmetryOperation.plusMinus(string2, n6, stringArray[n8 + (n5 < 3 ? 0 : 3)]);
                    break;
                }
                case ',': {
                    f = SymmetryOperation.normalizeTwelfths(f, bl5);
                    n4 = n + (n5 > 2 ? n2 : 3);
                    fArray[n4] = f;
                    string2 = string2 + SymmetryOperation.xyzFraction(f, false, true);
                    string3 = string3 + (string3 == "" ? "" : ",") + string2;
                    if (n5 == n3 - 2) {
                        return string3;
                    }
                    f = 0.0f;
                    string2 = "";
                    if (n5++ <= 2 || n2 != 0) break;
                    Logger.warn((String)("Symmetry Operation? " + string));
                    return null;
                }
                case '.': {
                    bl3 = true;
                    f2 = 1.0f;
                    continue block11;
                }
                case '0': {
                    if (!bl3 && (bl2 || !bl)) continue block11;
                }
                default: {
                    int n9 = c - 48;
                    if (bl3 && n9 >= 0 && n9 <= 9) {
                        f2 /= 10.0f;
                        if (f < 0.0f) {
                            bl4 = true;
                        }
                        f += f2 * (float)n9 * (float)(bl4 ? -1 : 1);
                        continue block11;
                    }
                    if (n9 >= 0 && n9 <= 9) {
                        if (bl2) {
                            f /= (float)n9;
                            break;
                        }
                        f = f * 10.0f + (float)((bl4 ? -1 : 1) * n9);
                        bl4 = false;
                        break;
                    }
                    Logger.warn((String)("symmetry character?" + c));
                }
            }
            bl4 = false;
            bl2 = false;
            bl3 = false;
        }
        return null;
    }

    private static final String xyzFraction(float f, boolean bl, boolean bl2) {
        String string;
        if (bl) {
            for (f = (float)Math.round(f); f < 0.0f; f += 12.0f) {
            }
        } else if (bl2 && f > 6.0f) {
            f -= 12.0f;
        }
        return (string = SymmetryOperation.twelfthsOf(f)).charAt(0) == '0' ? "" : (f > 0.0f ? "+" + string : string);
    }

    private static final String twelfthsOf(float f) {
        int n;
        String string = "";
        int n2 = Math.round(f);
        if (n2 == 12) {
            return "1";
        }
        if (n2 == -12) {
            return "-1";
        }
        if (n2 < 0 && (n2 = -n2) % 12 != 0) {
            string = "-";
        }
        if ((n = n2 / 12) < 1) {
            return string + twelfths[n2 % 12];
        }
        int n3 = 0;
        switch (n2 % 12) {
            case 0: {
                return string + n;
            }
            case 1: 
            case 5: 
            case 7: 
            case 11: {
                n3 = 12;
                break;
            }
            case 2: 
            case 10: {
                n3 = 6;
                break;
            }
            case 3: 
            case 9: {
                n3 = 4;
                break;
            }
            case 4: 
            case 8: {
                n3 = 3;
                break;
            }
            case 6: {
                n3 = 2;
            }
        }
        return string + n2 * n3 / 12 + "/" + n3;
    }

    private static String plusMinus(String string, float f, String string2) {
        return f == 0.0f ? "" : (f < 0.0f ? "-" : (string.length() == 0 ? "" : "+")) + string2;
    }

    private static float normalizeTwelfths(float f, boolean bl) {
        f *= 12.0f;
        if (bl) {
            while (f > 6.0f) {
                f -= 12.0f;
            }
            while (f <= -6.0f) {
                f += 12.0f;
            }
        }
        return f;
    }

    static final String getXYZFromMatrix(M4 m4, boolean bl, boolean bl2, boolean bl3) {
        SymmetryOperation symmetryOperation;
        String string = "";
        SymmetryOperation symmetryOperation2 = symmetryOperation = m4 instanceof SymmetryOperation ? (SymmetryOperation)m4 : null;
        if (symmetryOperation != null && symmetryOperation.modDim > 0) {
            return SymmetryOperation.getXYZFromRsVs(symmetryOperation.rsvs.getRotation(), symmetryOperation.rsvs.getTranslation(), bl);
        }
        float[] fArray = new float[4];
        for (int i = 0; i < 3; ++i) {
            int n = i < 3 ? 0 : 3;
            m4.getRow(i, fArray);
            String string2 = "";
            for (int j = 0; j < 3; ++j) {
                if (fArray[j] == 0.0f) continue;
                string2 = string2 + SymmetryOperation.plusMinus(string2, fArray[j], labelsXYZ[j + n]);
            }
            string2 = string2 + SymmetryOperation.xyzFraction(bl ? fArray[3] : fArray[3] * 12.0f, bl2, bl3);
            string = string + "," + string2;
        }
        return string.substring(1);
    }

    private void setOffset(P3[] p3Array, int n, int n2) {
        int n3 = n;
        int n4 = n3 + n2;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.atomTest == null) {
            this.atomTest = new P3();
        }
        for (int i = n3; i < n4; ++i) {
            this.newPoint(p3Array[i], this.atomTest, 0, 0, 0);
            f += this.atomTest.x;
            f2 += this.atomTest.y;
            f3 += this.atomTest.z;
        }
        while ((double)f < -0.001 || (double)f >= (double)n2 + 0.001) {
            this.m03 += (float)(f < 0.0f ? 1 : -1);
            f += (float)(f < 0.0f ? n2 : -n2);
        }
        while ((double)f2 < -0.001 || (double)f2 >= (double)n2 + 0.001) {
            this.m13 += (float)(f2 < 0.0f ? 1 : -1);
            f2 += (float)(f2 < 0.0f ? n2 : -n2);
        }
        while ((double)f3 < -0.001 || (double)f3 >= (double)n2 + 0.001) {
            this.m23 += (float)(f3 < 0.0f ? 1 : -1);
            f3 += (float)(f3 < 0.0f ? n2 : -n2);
        }
    }

    V3[] rotateAxes(V3[] v3Array, UnitCell unitCell, P3 p3, M3 m3) {
        V3[] v3Array2 = new V3[3];
        this.getRotationScale(m3);
        int n = v3Array.length;
        while (--n >= 0) {
            p3.setT((T3)v3Array[n]);
            unitCell.toFractional((T3)p3, true);
            m3.transform((T3)p3);
            unitCell.toCartesian((T3)p3, true);
            v3Array2[n] = V3.newV((T3)p3);
        }
        return v3Array2;
    }

    Object[] getDescription(ModelSet modelSet, SymmetryInterface symmetryInterface, P3 p3, P3 p32, String string) {
        float f;
        float f2;
        String string2;
        V3 v3;
        boolean bl;
        boolean bl2;
        if (!this.isFinalized) {
            this.doFinalize();
        }
        V3 v32 = new V3();
        P3 p33 = new P3();
        P3 p34 = new P3();
        P3 p35 = new P3();
        P3 p36 = new P3();
        V3 v33 = new V3();
        V3 v34 = new V3();
        String string3 = this.isBio ? this.xyzOriginal : SymmetryOperation.getXYZFromMatrix(this, false, false, false);
        boolean bl3 = bl2 = string == null;
        if (p3 == null || Float.isNaN(p3.x)) {
            p3 = new P3();
        }
        if (p32 != null) {
            p34.setT((T3)p3);
            p35.setT((T3)p32);
            symmetryInterface.toUnitCell(p34, p33);
            symmetryInterface.toUnitCell(p35, p33);
            symmetryInterface.toFractional((T3)p34, false);
            this.transform((T3)p34);
            symmetryInterface.toCartesian((T3)p34, false);
            symmetryInterface.toUnitCell(p34, p33);
            if (p34.distance((T3)p35) > 0.1f) {
                return null;
            }
            p34.setT((T3)p3);
            p35.setT((T3)p32);
            symmetryInterface.toFractional((T3)p34, false);
            symmetryInterface.toFractional((T3)p35, false);
            this.transform((T3)p34);
            v34.sub2((T3)p35, (T3)p34);
            p34.set(0.0f, 0.0f, 0.0f);
            p35.set(0.0f, 0.0f, 0.0f);
        }
        p36.z = 1.0f;
        p35.y = 1.0f;
        p34.x = 1.0f;
        p34.add((T3)p3);
        p35.add((T3)p3);
        p36.add((T3)p3);
        P3 p37 = P3.newP((T3)p3);
        P3 p38 = P3.newP((T3)p34);
        P3 p39 = P3.newP((T3)p35);
        P3 p310 = P3.newP((T3)p36);
        symmetryInterface.toFractional((T3)p37, false);
        symmetryInterface.toFractional((T3)p38, false);
        symmetryInterface.toFractional((T3)p39, false);
        symmetryInterface.toFractional((T3)p310, false);
        this.transform2((T3)p37, (T3)p37);
        this.transform2((T3)p38, (T3)p38);
        this.transform2((T3)p39, (T3)p39);
        this.transform2((T3)p310, (T3)p310);
        p37.add((T3)v34);
        p38.add((T3)v34);
        p39.add((T3)v34);
        p310.add((T3)v34);
        SymmetryOperation.approx((T3)v34);
        symmetryInterface.toCartesian((T3)p37, false);
        symmetryInterface.toCartesian((T3)p38, false);
        symmetryInterface.toCartesian((T3)p39, false);
        symmetryInterface.toCartesian((T3)p310, false);
        V3 v35 = new V3();
        v35.sub2((T3)p38, (T3)p37);
        V3 v36 = new V3();
        v36.sub2((T3)p39, (T3)p37);
        V3 v37 = new V3();
        v37.sub2((T3)p310, (T3)p37);
        v32.cross(v35, v36);
        boolean bl4 = bl = v32.dot((T3)v37) < 0.0f;
        if (bl) {
            p38.scaleAdd2(-2.0f, (T3)v35, (T3)p38);
            p39.scaleAdd2(-2.0f, (T3)v36, (T3)p39);
            p310.scaleAdd2(-2.0f, (T3)v37, (T3)p310);
        }
        Object[] objectArray = (Object[])Measure.computeHelicalAxis(null, (int)135266306, (P3)p3, (P3)p37, (Quaternion)Quaternion.getQuaternionFrame((P3)p37, (T3)p38, (T3)p39).div(Quaternion.getQuaternionFrame((P3)p3, (T3)p34, (T3)p35)));
        P3 p311 = (P3)objectArray[0];
        V3 v38 = (V3)objectArray[1];
        int n = (int)Math.abs(PT.approx((float)((P3)objectArray[3]).x, (float)1.0f));
        float f3 = SymmetryOperation.approxF(((P3)objectArray[3]).y);
        if (bl) {
            p38.scaleAdd2(2.0f, (T3)v35, (T3)p38);
            p39.scaleAdd2(2.0f, (T3)v36, (T3)p39);
            p310.scaleAdd2(2.0f, (T3)v37, (T3)p310);
        }
        if ((v3 = V3.newVsub((T3)p37, (T3)p3)).length() < 0.1f) {
            v3 = null;
        }
        P3 p312 = null;
        P3 p313 = null;
        P3 p314 = null;
        boolean bl5 = n == 0;
        boolean bl6 = !bl5;
        boolean bl7 = false;
        boolean bl8 = false;
        if (bl6 || bl) {
            v3 = null;
        }
        if (bl && bl5) {
            p313 = P3.newP((T3)p3);
            p313.add((T3)p37);
            p313.scale(0.5f);
            p312 = p37;
            bl7 = true;
        } else if (bl) {
            V3 v39 = f3 == 0.0f ? new V3() : v38;
            float f4 = 0.0f;
            switch (n) {
                case 60: {
                    f4 = 0.6666667f;
                    break;
                }
                case 120: {
                    f4 = 2.0f;
                    break;
                }
                case 90: {
                    f4 = 1.0f;
                    break;
                }
                case 180: {
                    p314 = P3.newP((T3)p3);
                    p314.add((T3)v39);
                    p311.scaleAdd2(0.5f, (T3)v39, (T3)p3);
                    if (p314.distance((T3)p37) > 0.1f) {
                        v3 = V3.newVsub((T3)p37, (T3)p314);
                        p33.setT((T3)v3);
                        symmetryInterface.toFractional((T3)p33, false);
                        v33.setT((T3)p33);
                    } else {
                        v3 = null;
                    }
                    bl6 = false;
                    bl = false;
                    bl8 = true;
                }
            }
            if (f4 != 0.0f) {
                v32.sub2((T3)p3, (T3)p311);
                v32.add((T3)p37);
                v32.sub((T3)p311);
                v32.sub((T3)v39);
                v32.scale(f4);
                p311.add((T3)v32);
                p313 = new P3();
                p313.scaleAdd2(0.5f, (T3)v39, (T3)p311);
                p312 = new P3();
                p312.scaleAdd2(-2.0f, (T3)p313, (T3)p3);
                p312.scale(-1.0f);
            }
        } else if (v3 != null) {
            p33.setT((T3)v3);
            symmetryInterface.toFractional((T3)p33, false);
            if (SymmetryOperation.approxF(p33.x) == 1.0f) {
                p33.x = 0.0f;
            }
            if (SymmetryOperation.approxF(p33.y) == 1.0f) {
                p33.y = 0.0f;
            }
            if (SymmetryOperation.approxF(p33.z) == 1.0f) {
                p33.z = 0.0f;
            }
            v33.setT((T3)p33);
            symmetryInterface.toCartesian((T3)p33, false);
            v3.setT((T3)p33);
        }
        int n2 = n;
        SymmetryOperation.approx0((T3)v38);
        if (bl6) {
            P3 p315 = new P3();
            v32.setT((T3)v38);
            int n3 = n;
            if (bl) {
                p315.add2((T3)p311, (T3)v32);
                n3 = Math.round(Measure.computeTorsion((T3)p312, (T3)p311, (T3)p315, (T3)p37, (boolean)true));
            } else if (f3 == 0.0f) {
                p315.setT((T3)p311);
                p33.scaleAdd2(1.0f, (T3)p315, (T3)v32);
                n3 = Math.round(Measure.computeTorsion((T3)p3, (T3)p311, (T3)p33, (T3)p37, (boolean)true));
            } else {
                p33.add2((T3)p311, (T3)v32);
                p315.scaleAdd2(0.5f, (T3)v32, (T3)p311);
                n3 = Math.round(Measure.computeTorsion((T3)p3, (T3)p311, (T3)p33, (T3)p37, (boolean)true));
            }
            if (n3 != 0) {
                n = n3;
            }
        }
        if (bl6 && !bl && f3 == 0.0f && (v38.z < 0.0f || v38.z == 0.0f && (v38.y < 0.0f || v38.y == 0.0f && v38.x < 0.0f))) {
            v38.scale(-1.0f);
            n = -n;
        }
        String string4 = "identity";
        SB sB = new SB();
        if (bl7) {
            p33.setT((T3)p313);
            symmetryInterface.toFractional((T3)p33, false);
            string4 = "inversion center|" + this.coord((T3)p33);
        } else if (bl6) {
            if (bl) {
                string4 = "" + 360 / n2 + "-bar axis";
            } else if (f3 != 0.0f) {
                string4 = "" + 360 / n2 + "-fold screw axis";
                p33.setT((T3)v38);
                symmetryInterface.toFractional((T3)p33, false);
                string4 = string4 + "|translation: " + this.coord((T3)p33);
            } else {
                string4 = "C" + 360 / n2 + " axis";
            }
        } else if (v3 != null) {
            string2 = " " + this.coord((T3)v33);
            if (bl5) {
                string4 = "translation:" + string2;
            } else if (bl8) {
                float f5 = SymmetryOperation.approxF(v33.x);
                f2 = SymmetryOperation.approxF(v33.y);
                f = SymmetryOperation.approxF(v33.z);
                string2 = " " + this.coord((T3)v33);
                string4 = f5 != 0.0f && f2 != 0.0f && f != 0.0f ? "d-" : (f5 != 0.0f && f2 != 0.0f || f2 != 0.0f && f != 0.0f || f != 0.0f && f5 != 0.0f ? "n-" : (f5 != 0.0f ? "a-" : (f2 != 0.0f ? "b-" : "c-")));
                string4 = string4 + "glide plane |translation:" + string2;
            }
        } else if (bl8) {
            string4 = "mirror plane";
        }
        if (bl && !bl7) {
            p33.setT((T3)p313);
            symmetryInterface.toFractional((T3)p33, false);
            string4 = string4 + "|inversion center at " + this.coord((T3)p33);
        }
        string2 = null;
        if (!bl2) {
            String string5 = "\ndraw ID " + string + "_";
            sB = new SB();
            sB.append(("// " + this.xyzOriginal + "|" + string3 + "|" + string4).replace('\n', ' ')).append("\n");
            sB.append(string5).append("* delete");
            SymmetryOperation.drawLine(sB, string5 + "frame1X", 0.15f, p3, p34, "red");
            SymmetryOperation.drawLine(sB, string5 + "frame1Y", 0.15f, p3, p35, "green");
            SymmetryOperation.drawLine(sB, string5 + "frame1Z", 0.15f, p3, p36, "blue");
            p33.sub2((T3)p38, (T3)p37);
            p33.scaleAdd2(0.9f, (T3)p33, (T3)p37);
            SymmetryOperation.drawLine(sB, string5 + "frame2X", 0.2f, p37, p33, "red");
            p33.sub2((T3)p39, (T3)p37);
            p33.scaleAdd2(0.9f, (T3)p33, (T3)p37);
            SymmetryOperation.drawLine(sB, string5 + "frame2Y", 0.2f, p37, p33, "green");
            p33.sub2((T3)p310, (T3)p37);
            p33.scaleAdd2(0.9f, (T3)p33, (T3)p37);
            SymmetryOperation.drawLine(sB, string5 + "frame2Z", 0.2f, p37, p33, "purple");
            if (bl6) {
                P3 p316 = new P3();
                String string6 = "red";
                n2 = n;
                f = 1.0f;
                v32.setT((T3)v38);
                if (bl) {
                    p316.add2((T3)p311, (T3)v32);
                    if (f3 == 0.0f) {
                        p316.setT((T3)p313);
                        v32.scale(3.0f);
                        p33.scaleAdd2(-1.0f, (T3)v32, (T3)p311);
                        sB.append(string5).append("rotVector2 diameter 0.1 ").append(Escape.eP((T3)p311)).append(Escape.eP((T3)p33)).append(" color red");
                    }
                    f = p37.distance((T3)p316);
                    sB.append(string5).append("rotLine1 ").append(Escape.eP((T3)p316)).append(Escape.eP((T3)p312)).append(" color red");
                    sB.append(string5).append("rotLine2 ").append(Escape.eP((T3)p316)).append(Escape.eP((T3)p37)).append(" color red");
                } else if (f3 == 0.0f) {
                    boolean bl9;
                    boolean bl10 = bl9 = p3.distance((T3)p37) < 0.2f;
                    if (!bl9) {
                        sB.append(string5).append("rotLine1 ").append(Escape.eP((T3)p3)).append(Escape.eP((T3)p311)).append(" color red");
                        sB.append(string5).append("rotLine2 ").append(Escape.eP((T3)p37)).append(Escape.eP((T3)p311)).append(" color red");
                    }
                    v32.scale(3.0f);
                    p33.scaleAdd2(-1.0f, (T3)v32, (T3)p311);
                    sB.append(string5).append("rotVector2 diameter 0.1 ").append(Escape.eP((T3)p311)).append(Escape.eP((T3)p33)).append(" color red");
                    p316.setT((T3)p311);
                    if (f3 == 0.0f && (double)p3.distance((T3)p37) < 0.2) {
                        p316.scaleAdd2(0.5f, (T3)p316, (T3)v32);
                    }
                } else {
                    string6 = "orange";
                    sB.append(string5).append("rotLine1 ").append(Escape.eP((T3)p3)).append(Escape.eP((T3)p311)).append(" color red");
                    p33.add2((T3)p311, (T3)v32);
                    sB.append(string5).append("rotLine2 ").append(Escape.eP((T3)p37)).append(Escape.eP((T3)p33)).append(" color red");
                    p316.scaleAdd2(0.5f, (T3)v32, (T3)p311);
                }
                p33.add2((T3)p316, (T3)v32);
                if (bl && f3 != 0.0f) {
                    sB.append(string5).append("rotRotLine1").append(Escape.eP((T3)p316)).append(Escape.eP((T3)p312)).append(" color red");
                    sB.append(string5).append("rotRotLine2").append(Escape.eP((T3)p316)).append(Escape.eP((T3)p37)).append(" color red");
                }
                sB.append(string5).append("rotRotArrow arrow width 0.10 scale " + f + " arc ").append(Escape.eP((T3)p316)).append(Escape.eP((T3)p33));
                p33.setT((T3)(bl ? p312 : p3));
                if (p33.distance((T3)p37) < 0.1f) {
                    p33.set((float)Math.random(), (float)Math.random(), (float)Math.random());
                }
                sB.append(Escape.eP((T3)p33));
                p33.set(0.0f, (float)n2, 0.0f);
                sB.append(Escape.eP((T3)p33)).append(" color red");
                sB.append(string5).append("rotVector1 vector diameter 0.1 ").append(Escape.eP((T3)p311)).append(Escape.eP((T3)v32)).append("color ").append(string6);
            }
            if (bl8) {
                if ((double)p3.distance((T3)p314) > 0.2) {
                    sB.append(string5).append("planeVector arrow ").append(Escape.eP((T3)p3)).append(Escape.eP((T3)p314)).append(" color indigo");
                }
                if (v3 != null) {
                    p33.scaleAdd2(-1.0f, (T3)p37, (T3)p38);
                    p33.add((T3)p314);
                    SymmetryOperation.drawLine(sB, string5 + "planeFrameX", 0.15f, p314, p33, "translucent red");
                    p33.scaleAdd2(-1.0f, (T3)p37, (T3)p39);
                    p33.add((T3)p314);
                    SymmetryOperation.drawLine(sB, string5 + "planeFrameY", 0.15f, p314, p33, "translucent green");
                    p33.scaleAdd2(-1.0f, (T3)p37, (T3)p310);
                    p33.add((T3)p314);
                    SymmetryOperation.drawLine(sB, string5 + "planeFrameZ", 0.15f, p314, p33, "translucent blue");
                }
                String string7 = v3 == null ? "green" : "blue";
                v32.setT((T3)v38);
                v32.normalize();
                f2 = -v32.x * p311.x - v32.y * p311.y - v32.z * p311.z;
                P4 p4 = P4.new4((float)v32.x, (float)v32.y, (float)v32.z, (float)f2);
                List list = new List();
                list.addLast((Object)symmetryInterface.getCanonicalCopy(1.05f, false));
                modelSet.intersectPlane(p4, list, 3);
                int n4 = list.size();
                while (--n4 >= 0) {
                    P3[] p3Array = (P3[])list.get(n4);
                    sB.append(string5).append("planep").appendI(n4).append(" ").append(Escape.eP((T3)p3Array[0])).append(Escape.eP((T3)p3Array[1]));
                    if (p3Array.length == 3) {
                        sB.append(Escape.eP((T3)p3Array[2]));
                    }
                    sB.append(" color translucent ").append(string7);
                }
                if (list.size() == 0) {
                    p33.add2((T3)p311, (T3)v38);
                    sB.append(string5).append("planeCircle scale 2.0 circle ").append(Escape.eP((T3)p311)).append(Escape.eP((T3)p33)).append(" color translucent ").append(string7).append(" mesh fill");
                }
            }
            if (bl) {
                sB.append(string5).append("invPoint diameter 0.4 ").append(Escape.eP((T3)p313));
                sB.append(string5).append("invArrow arrow ").append(Escape.eP((T3)p3)).append(Escape.eP((T3)p312)).append(" color indigo");
                if (!bl7) {
                    p33.add2((T3)p312, (T3)p3);
                    p33.sub((T3)p34);
                    SymmetryOperation.drawLine(sB, string5 + "invFrameX", 0.15f, p312, p33, "translucent red");
                    p33.add2((T3)p312, (T3)p3);
                    p33.sub((T3)p35);
                    SymmetryOperation.drawLine(sB, string5 + "invFrameY", 0.15f, p312, p33, "translucent green");
                    p33.add2((T3)p312, (T3)p3);
                    p33.sub((T3)p36);
                    SymmetryOperation.drawLine(sB, string5 + "invFrameZ", 0.15f, p312, p33, "translucent blue");
                }
            }
            if (v3 != null) {
                if (p314 == null) {
                    p314 = P3.newP((T3)p3);
                }
                sB.append(string5).append("transVector vector ").append(Escape.eP((T3)p314)).append(Escape.eP((T3)v3));
            }
            sB.append("\nvar pt00 = " + Escape.eP((T3)p3));
            sB.append("\nvar p0 = " + Escape.eP((T3)p37));
            sB.append("\nif (within(0.2,p0).length == 0) {");
            sB.append("\nvar set2 = within(0.2,p0.uxyz.xyz)");
            sB.append("\nif (set2) {");
            sB.append(string5).append("cellOffsetVector arrow @p0 @set2 color grey");
            sB.append(string5).append("offsetFrameX diameter 0.20 @{set2.xyz} @{set2.xyz + ").append(Escape.eP((T3)v35)).append("*0.9} color red");
            sB.append(string5).append("offsetFrameY diameter 0.20 @{set2.xyz} @{set2.xyz + ").append(Escape.eP((T3)v36)).append("*0.9} color green");
            sB.append(string5).append("offsetFrameZ diameter 0.20 @{set2.xyz} @{set2.xyz + ").append(Escape.eP((T3)v37)).append("*0.9} color purple");
            sB.append("\n}}\n");
            string2 = sB.toString();
            sB = null;
            string5 = null;
        }
        if (v3 == null) {
            v33 = null;
        }
        if (bl6 && !bl && f3 != 0.0f) {
            v3 = V3.newV((T3)v38);
            p33.setT((T3)v3);
            symmetryInterface.toFractional((T3)p33, false);
            v33 = V3.newV((T3)p33);
        }
        if (bl8) {
            n = 0;
        }
        if (bl) {
            if (bl7) {
                p311 = null;
                v38 = null;
                v3 = null;
                v33 = null;
            }
        } else if (bl5) {
            p311 = null;
            v38 = null;
        }
        if (v38 != null) {
            v38.normalize();
        }
        M4 m4 = null;
        m4 = M4.newM((M4)this);
        if (v34.length() != 0.0f) {
            m4.m03 += v34.x;
            m4.m13 += v34.y;
            m4.m23 += v34.z;
        }
        string3 = this.isBio ? m4.toString() : SymmetryOperation.getXYZFromMatrix(m4, false, false, false);
        return new Object[]{string3, this.xyzOriginal, string4, string2, SymmetryOperation.approx0((T3)v33), SymmetryOperation.approx0((T3)v3), SymmetryOperation.approx0((T3)p313), SymmetryOperation.approx0((T3)p311), SymmetryOperation.approx0((T3)v38), n, m4, v34};
    }

    private String coord(T3 t3) {
        SymmetryOperation.approx0(t3);
        return this.isBio ? t3.x + " " + t3.y + " " + t3.z : SymmetryOperation.fcoord(t3);
    }

    private static void drawLine(SB sB, String string, float f, P3 p3, P3 p32, String string2) {
        sB.append(string).append(" diameter ").appendF(f).append(Escape.eP((T3)p3)).append(Escape.eP((T3)p32)).append(" color ").append(string2);
    }

    static String fcoord(T3 t3) {
        return SymmetryOperation.fc(t3.x) + " " + SymmetryOperation.fc(t3.y) + " " + SymmetryOperation.fc(t3.z);
    }

    private static String fc(float f) {
        String string;
        float f2 = Math.abs(f);
        int n = (int)SymmetryOperation.approxF(f2 * 24.0f);
        String string2 = string = f < 0.0f ? "-" : "";
        if (n % 8 != 0) {
            return string + SymmetryOperation.twelfthsOf(n >> 1);
        }
        return n == 0 ? "0" : (n == 24 ? string + "1" : string + n / 8 + "/3");
    }

    private static T3 approx0(T3 t3) {
        if (t3 != null) {
            if (Math.abs(t3.x) < 1.0E-4f) {
                t3.x = 0.0f;
            }
            if (Math.abs(t3.y) < 1.0E-4f) {
                t3.y = 0.0f;
            }
            if (Math.abs(t3.z) < 1.0E-4f) {
                t3.z = 0.0f;
            }
        }
        return t3;
    }

    private static T3 approx(T3 t3) {
        if (t3 != null) {
            t3.x = SymmetryOperation.approxF(t3.x);
            t3.y = SymmetryOperation.approxF(t3.y);
            t3.z = SymmetryOperation.approxF(t3.z);
        }
        return t3;
    }

    private static float approxF(float f) {
        return PT.approx((float)f, (float)100.0f);
    }

    public static void normalizeTranslation(M4 m4) {
        m4.m03 = ((int)m4.m03 + 12) % 12;
        m4.m13 = ((int)m4.m13 + 12) % 12;
        m4.m23 = ((int)m4.m23 + 12) % 12;
    }

    public static String getXYZFromRsVs(Matrix matrix, Matrix matrix2, boolean bl) {
        double[][] dArray = matrix.getArray();
        double[][] dArray2 = matrix2.getArray();
        int n = dArray.length;
        String string = "";
        block0: for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (dArray[i][j] == 0.0) continue;
                string = string + (dArray[i][j] > 0.0 ? "," : ",-") + "x" + (j + 1);
                string = string + SymmetryOperation.xyzFraction((int)(dArray2[i][0] * (double)(bl ? 1 : 12)), false, true);
                continue block0;
            }
        }
        return string.substring(1);
    }

    public String toString() {
        return this.rsvs == null ? super.toString() : this.rsvs.toString();
    }
}

