/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import javajs.util.List;
import javajs.util.Matrix;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.adapter.readers.cif.MSReader;
import org.jmol.api.SymmetryInterface;
import org.jmol.util.Logger;

class Subsystem {
    private MSReader msReader;
    private String code;
    private int d;
    private Matrix w;
    private SymmetryInterface symmetry;
    private Matrix[] modMatrices;

    Subsystem(MSReader mSReader, String string, Matrix matrix) {
        this.msReader = mSReader;
        this.code = string;
        this.w = matrix;
        this.d = matrix.getArray().length - 3;
    }

    public SymmetryInterface getSymmetry() {
        if (this.modMatrices == null) {
            this.setSymmetry();
        }
        return this.symmetry;
    }

    public Matrix[] getModMatrices() {
        if (this.modMatrices == null) {
            this.setSymmetry();
        }
        return this.modMatrices;
    }

    private void setSymmetry() {
        Matrix matrix = this.w.getSubmatrix(0, 0, 3, 3);
        Matrix matrix2 = this.w.getSubmatrix(3, 0, this.d, 3);
        Matrix matrix3 = this.w.getSubmatrix(0, 3, 3, this.d);
        Matrix matrix4 = this.w.getSubmatrix(3, 3, this.d, this.d);
        Matrix matrix5 = this.msReader.getSigma();
        Matrix matrix6 = matrix4.mul(matrix5).add(matrix2).mul(matrix3.mul(matrix5).add(matrix).inverse());
        Matrix matrix7 = matrix4.sub(matrix6.mul(matrix3));
        this.modMatrices = new Matrix[]{matrix6, matrix7};
        SymmetryInterface symmetryInterface = this.msReader.cr.atomSetCollection.symmetry;
        V3[] v3Array = symmetryInterface.getUnitCellVectors();
        V3[] v3Array2 = this.reciprocalsOf(v3Array);
        Matrix matrix8 = new Matrix((double[][])null, 3 + this.d, 3);
        Matrix matrix9 = new Matrix((double[][])null, 3, 3);
        double[][] dArray = matrix8.getArray();
        double[][] dArray2 = matrix9.getArray();
        for (int i = 0; i < 3; ++i) {
            dArray2[i] = new double[]{v3Array2[i + 1].x, v3Array2[i + 1].y, v3Array2[i + 1].z};
            dArray[i] = dArray2[i];
        }
        Matrix matrix10 = matrix5.mul(matrix9);
        double[][] dArray3 = matrix10.getArray();
        for (int i = 0; i < this.d; ++i) {
            dArray[i + 3] = dArray3[i];
        }
        dArray3 = this.w.mul(matrix8).getArray();
        V3[] v3Array3 = new V3[4];
        v3Array3[0] = v3Array[0];
        for (int i = 0; i < 3; ++i) {
            v3Array3[i + 1] = V3.new3((float)((float)dArray3[i][0]), (float)((float)dArray3[i][1]), (float)((float)dArray3[i][2]));
        }
        v3Array3 = this.reciprocalsOf(v3Array3);
        this.symmetry = this.msReader.cr.symmetry.getUnitCell((T3[])v3Array3, false);
        Matrix matrix11 = this.w.inverse();
        Logger.info((String)("[subsystem " + this.code + "]"));
        this.symmetry.createSpaceGroup(-1, "[subsystem " + this.code + "]", (Object)new List());
        int n = symmetryInterface.getSpaceGroupOperationCount();
        for (int i = 0; i < n; ++i) {
            Matrix matrix12 = symmetryInterface.getOperationRsVs(i);
            Matrix matrix13 = this.w.mul(matrix12.getRotation()).mul(matrix11);
            Matrix matrix14 = this.w.mul(matrix12.getTranslation());
            String string = this.symmetry.addOp(matrix13, matrix14);
            Logger.info((String)string);
        }
    }

    private V3[] reciprocalsOf(V3[] v3Array) {
        V3[] v3Array2 = new V3[4];
        v3Array2[0] = v3Array[0];
        for (int i = 0; i < 3; ++i) {
            v3Array2[i + 1] = new V3();
            v3Array2[i + 1].cross(v3Array[(i + 1) % 3 + 1], v3Array[(i + 2) % 3 + 1]);
            v3Array2[i + 1].scale(1.0f / v3Array[i + 1].dot((T3)v3Array2[i + 1]));
        }
        return v3Array2;
    }

    public String toString() {
        return "Subsystem " + this.code + "\n" + this.w;
    }
}

