/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.popup;

import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javajs.api.GenericMenuInterface;
import javajs.util.List;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.i18n.GT;
import org.jmol.i18n.Language;
import org.jmol.java.BS;
import org.jmol.popup.JmolAbstractMenu;
import org.jmol.popup.MainPopupResourceBundle;
import org.jmol.popup.PopupResource;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public abstract class GenericPopup
implements GenericMenuInterface,
JmolAbstractMenu {
    protected static final int UPDATE_NEVER = -1;
    private static final int UPDATE_ALL = 0;
    private static final int UPDATE_CONFIG = 1;
    private static final int UPDATE_SHOW = 2;
    protected Viewer viewer;
    protected Map<String, Object> htCheckbox = new Hashtable<String, Object>();
    protected Properties menuText = new Properties();
    protected Object buttonGroup;
    protected String currentMenuItemId;
    protected String strMenuStructure;
    protected int updateMode;
    protected String menuName;
    private Object frankPopup;
    private Object popupMenu;
    protected Object thisPopup;
    private int nFrankList = 0;
    private int itemMax = 25;
    private int titleWidthMax = 20;
    private int thisx;
    private int thisy;
    private String nullModelSetName;
    private String modelSetName;
    private String modelSetFileName;
    private String modelSetRoot;
    private String currentFrankId = null;
    private String configurationSelected = "";
    private String altlocs;
    private Object[][] frankList = new Object[10][];
    private Map<String, Object> modelSetInfo;
    private Map<String, Object> modelInfo;
    private Map<String, Object> htMenus = new Hashtable<String, Object>();
    private List<Object> NotPDB = new List();
    private List<Object> PDBOnly = new List();
    private List<Object> FileUnitOnly = new List();
    private List<Object> FileMolOnly = new List();
    private List<Object> UnitcellOnly = new List();
    private List<Object> SingleModelOnly = new List();
    private List<Object> FramesOnly = new List();
    private List<Object> VibrationOnly = new List();
    private List<Object> SymmetryOnly = new List();
    private List<Object> SignedOnly = new List();
    private List<Object> AppletOnly = new List();
    private List<Object> ChargesOnly = new List();
    private List<Object> TemperatureOnly = new List();
    private List<Object> Special = new List();
    private boolean allowSignedFeatures;
    private boolean isJS;
    private boolean fileHasUnitCell;
    private boolean haveBFactors;
    private boolean haveCharges;
    private boolean isApplet;
    private boolean isLastFrame;
    private boolean isMultiConfiguration;
    private boolean isMultiFrame;
    private boolean isPDB;
    private boolean isSigned;
    private boolean isSymmetry;
    private boolean isUnitCell;
    private boolean isVibration;
    private boolean isZapped;
    private int modelIndex;
    private int modelCount;
    private int atomCount;
    private int aboutComputedMenuBaseCount;
    private String group3List;
    private int[] group3Counts;
    private List<String> cnmrPeaks;
    private List<String> hnmrPeaks;
    private static final int MENUITEM_HEIGHT = 20;

    public void jpiDispose() {
        this.menuClearListeners(this.popupMenu);
        this.menuClearListeners(this.frankPopup);
        this.thisPopup = null;
        this.frankPopup = null;
        this.popupMenu = null;
    }

    public Object jpiGetMenuAsObject() {
        return this.popupMenu;
    }

    public String jpiGetMenuAsString(String string) {
        this.updateForShow();
        int n = string.indexOf("|");
        if (n >= 0) {
            String string2 = string.substring(n);
            string = string.substring(0, n);
            if (string2.indexOf("current") >= 0) {
                SB sB = new SB();
                Object object = this.htMenus.get(this.menuName);
                this.menuGetAsText(sB, 0, object, "PopupMenu");
                return sB.toString();
            }
        }
        return new MainPopupResourceBundle(this.strMenuStructure, null).getMenuAsText(string);
    }

    public void jpiShow(int n, int n2) {
        if (!this.viewer.haveDisplay) {
            return;
        }
        this.show(n, n2, false);
        if (n < 0) {
            this.getViewerData();
            this.setFrankMenu(this.currentMenuItemId);
            this.thisx = -n - 50;
            if (this.nFrankList > 1) {
                this.thisy = n2 - this.nFrankList * 20;
                this.menuShowPopup(this.frankPopup, this.thisx, this.thisy);
                return;
            }
        }
        this.restorePopupMenu();
        this.menuShowPopup(this.popupMenu, this.thisx, this.thisy);
    }

    public void jpiUpdateComputedMenus() {
        if (this.updateMode == -1) {
            return;
        }
        this.updateMode = 0;
        this.getViewerData();
        this.updateSelectMenu();
        this.updateFileMenu();
        this.updateElementsComputedMenu(this.viewer.getElementsPresentBitSet(this.modelIndex));
        this.updateHeteroComputedMenu(this.viewer.getHeteroList(this.modelIndex));
        this.updateSurfMoComputedMenu((Map)this.modelInfo.get("moData"));
        this.updateFileTypeDependentMenus();
        this.updatePDBComputedMenus();
        this.updateMode = 1;
        this.updateConfigurationComputedMenu();
        this.updateSYMMETRYComputedMenus();
        this.updateFRAMESbyModelComputedMenu();
        this.updateModelSetComputedMenu();
        this.updateLanguageSubmenu();
        this.updateAboutSubmenu();
    }

    protected Object getEntryIcon(String[] stringArray) {
        String string = stringArray[0];
        if (!string.startsWith("<")) {
            return null;
        }
        int n = string.indexOf(">");
        stringArray[0] = string.substring(n + 1);
        String string2 = string.substring(1, n);
        return this.getImageIcon(string2);
    }

    protected Object getImageIcon(String string) {
        return null;
    }

    protected void checkMenuFocus(String string, String string2, boolean bl) {
        if (string.indexOf("Focus") < 0) {
            return;
        }
        if (bl) {
            this.viewer.script("selectionHalos ON;" + string2);
        } else {
            this.viewer.script("selectionHalos OFF");
        }
    }

    protected void checkBoxStateChanged(Object object) {
        this.restorePopupMenu();
        this.menuSetCheckBoxValue(object);
        String string = this.menuGetId(object);
        if (string != null) {
            this.currentMenuItemId = string;
        }
    }

    protected static void addItemText(SB sB, char c, int n, String string, String string2, String string3, String string4) {
        sB.appendC(c).appendI(n).appendC('\t').append(string);
        if (string2 == null) {
            sB.append(".\n");
            return;
        }
        sB.append("\t").append(string2).append("\t").append(string3 == null || string3.length() == 0 ? "-" : string3).append("\t").append(string4).append("\n");
    }

    protected String fixScript(String string, String string2) {
        if (string2 == "" || string.endsWith("Checkbox")) {
            return string2;
        }
        if (string2.indexOf("SELECT") == 0) {
            return "select thisModel and (" + string2.substring(6) + ")";
        }
        int n = string.lastIndexOf("[");
        if (n >= 0) {
            if ((n = (string = string.substring(n + 1)).indexOf("]")) >= 0) {
                string = string.substring(0, n);
            }
            string = string.replace('_', ' ');
            if (string2.indexOf("[]") < 0) {
                string2 = "[] " + string2;
            }
            return PT.simpleReplace((String)string2, (String)"[]", (String)string);
        }
        if (string2.indexOf("?FILEROOT?") >= 0) {
            string2 = PT.simpleReplace((String)string2, (String)"FILEROOT?", (String)this.modelSetRoot);
        } else if (string2.indexOf("?FILE?") >= 0) {
            string2 = PT.simpleReplace((String)string2, (String)"FILE?", (String)this.modelSetFileName);
        } else if (string2.indexOf("?PdbId?") >= 0) {
            string2 = PT.simpleReplace((String)string2, (String)"PdbId?", (String)"=xxxx");
        }
        return string2;
    }

    protected void initialize(Viewer viewer, PopupResource popupResource, String string) {
        this.viewer = viewer;
        this.menuName = string;
        this.thisPopup = this.popupMenu = this.menuCreatePopup(string);
        this.menuSetListeners();
        this.htMenus.put(string, this.popupMenu);
        this.isJS = viewer.isJS;
        this.allowSignedFeatures = !viewer.isApplet() || viewer.getBooleanProperty("_signedApplet");
        this.addMenuItems("", string, this.popupMenu, popupResource);
        try {
            this.jpiUpdateComputedMenus();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected void restorePopupMenu() {
        this.thisPopup = this.popupMenu;
        if (this.nFrankList < 2) {
            return;
        }
        int n = this.nFrankList;
        while (--n > 0) {
            Object[] objectArray = this.frankList[n];
            this.menuInsertSubMenu(objectArray[0], objectArray[1], (Integer)objectArray[2]);
        }
        this.nFrankList = 1;
    }

    protected void setCheckBoxValue(Object object, String string, boolean bl) {
        this.checkForCheckBoxScript(object, string, bl);
        if (string.indexOf("#CONFIG") >= 0) {
            this.configurationSelected = string;
            this.updateConfigurationComputedMenu();
            this.updateModelSetComputedMenu();
            return;
        }
    }

    private static boolean checkBoolean(Map<String, Object> map, String string) {
        return map != null && map.get(string) == Boolean.TRUE;
    }

    private void getViewerData() {
        this.isApplet = this.viewer.isApplet();
        this.isSigned = this.viewer.getBooleanProperty("_signedApplet");
        this.modelSetName = this.viewer.getModelSetName();
        this.modelSetFileName = this.viewer.getModelSetFileName();
        int n = this.modelSetFileName.lastIndexOf(".");
        this.isZapped = "zapped".equals(this.modelSetName);
        if (this.isZapped || "string".equals(this.modelSetFileName) || "files".equals(this.modelSetFileName) || "string[]".equals(this.modelSetFileName)) {
            this.modelSetFileName = "";
        }
        this.modelSetRoot = this.modelSetFileName.substring(0, n < 0 ? this.modelSetFileName.length() : n);
        if (this.modelSetRoot.length() == 0) {
            this.modelSetRoot = "Jmol";
        }
        this.modelIndex = this.viewer.getDisplayModelIndex();
        this.modelCount = this.viewer.getModelCount();
        this.atomCount = this.viewer.getAtomCountInModel(this.modelIndex);
        this.modelSetInfo = this.viewer.getModelSetAuxiliaryInfo();
        this.modelInfo = this.viewer.getModelAuxiliaryInfo(this.modelIndex);
        if (this.modelInfo == null) {
            this.modelInfo = new Hashtable<String, Object>();
        }
        this.isPDB = GenericPopup.checkBoolean(this.modelSetInfo, "isPDB");
        this.isMultiFrame = this.modelCount > 1;
        this.isSymmetry = GenericPopup.checkBoolean(this.modelInfo, "hasSymmetry");
        this.isUnitCell = this.modelInfo.containsKey("notionalUnitcell");
        this.fileHasUnitCell = this.isPDB && this.isUnitCell || GenericPopup.checkBoolean(this.modelInfo, "fileHasUnitCell");
        this.isLastFrame = this.modelIndex == this.modelCount - 1;
        this.altlocs = this.viewer.getAltLocListInModel(this.modelIndex);
        this.isMultiConfiguration = this.altlocs.length() > 0;
        this.isVibration = this.viewer.modelHasVibrationVectors(this.modelIndex);
        this.haveCharges = this.viewer.havePartialCharges();
        this.haveBFactors = this.viewer.getBooleanProperty("haveBFactors");
        this.cnmrPeaks = (List)this.modelInfo.get("jdxAtomSelect_13CNMR");
        this.hnmrPeaks = (List)this.modelInfo.get("jdxAtomSelect_1HNMR");
    }

    private void updateFileTypeDependentMenus() {
        int n = this.NotPDB.size();
        while (--n >= 0) {
            this.menuEnable(this.NotPDB.get(n), !this.isPDB);
        }
        n = this.PDBOnly.size();
        while (--n >= 0) {
            this.menuEnable(this.PDBOnly.get(n), this.isPDB);
        }
        n = this.UnitcellOnly.size();
        while (--n >= 0) {
            this.menuEnable(this.UnitcellOnly.get(n), this.isUnitCell);
        }
        n = this.FileUnitOnly.size();
        while (--n >= 0) {
            this.menuEnable(this.FileUnitOnly.get(n), this.isUnitCell || this.fileHasUnitCell);
        }
        n = this.FileMolOnly.size();
        while (--n >= 0) {
            this.menuEnable(this.FileMolOnly.get(n), this.isUnitCell || this.fileHasUnitCell);
        }
        n = this.SingleModelOnly.size();
        while (--n >= 0) {
            this.menuEnable(this.SingleModelOnly.get(n), this.isLastFrame);
        }
        n = this.FramesOnly.size();
        while (--n >= 0) {
            this.menuEnable(this.FramesOnly.get(n), this.isMultiFrame);
        }
        n = this.VibrationOnly.size();
        while (--n >= 0) {
            this.menuEnable(this.VibrationOnly.get(n), this.isVibration);
        }
        n = this.SymmetryOnly.size();
        while (--n >= 0) {
            this.menuEnable(this.SymmetryOnly.get(n), this.isSymmetry && this.isUnitCell);
        }
        n = this.SignedOnly.size();
        while (--n >= 0) {
            this.menuEnable(this.SignedOnly.get(n), this.isSigned || !this.isApplet);
        }
        n = this.AppletOnly.size();
        while (--n >= 0) {
            this.menuEnable(this.AppletOnly.get(n), this.isApplet);
        }
        n = this.ChargesOnly.size();
        while (--n >= 0) {
            this.menuEnable(this.ChargesOnly.get(n), this.haveCharges);
        }
        n = this.TemperatureOnly.size();
        while (--n >= 0) {
            this.menuEnable(this.TemperatureOnly.get(n), this.haveBFactors);
        }
    }

    private void addMenuItems(String string, String string2, Object object, PopupResource popupResource) {
        String string3;
        String string4;
        String string5 = string + "." + string2;
        String string6 = popupResource.getStructure(string2);
        if (Logger.debugging) {
            Logger.debug((String)(string5 + " --- " + string6));
        }
        if (string6 == null) {
            this.menuCreateItem(object, "#" + string2, "", "");
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string6);
        while (string6.indexOf("@") >= 0) {
            string4 = "";
            while (stringTokenizer.hasMoreTokens()) {
                string4 = string4 + " " + ((string3 = stringTokenizer.nextToken()).startsWith("@") ? popupResource.getStructure(string3) : string3);
            }
            string6 = string4.substring(1);
            stringTokenizer = new StringTokenizer(string6);
        }
        while (stringTokenizer.hasMoreTokens()) {
            Object object2;
            string3 = stringTokenizer.nextToken();
            if (!this.checkKey(string3)) continue;
            string4 = popupResource.getWord(string3);
            Object object3 = null;
            String string7 = "";
            boolean bl = false;
            if (string4.equals("null")) continue;
            if (string3.indexOf("Menu") >= 0) {
                if (string3.indexOf("more") < 0) {
                    this.buttonGroup = null;
                }
                object2 = this.menuNewSubMenu(string4, string5 + "." + string3);
                this.menuAddSubMenu(object, object2);
                this.htMenus.put(string3, object2);
                if (string3.indexOf("Computed") < 0) {
                    this.addMenuItems(string5, string3, object2, popupResource);
                }
                this.checkSpecialMenu(string3, object2, string4);
                object3 = object2;
            } else {
                if ("-".equals(string3)) {
                    this.menuAddSeparator(object);
                    continue;
                }
                if (string3.endsWith("Checkbox") || (bl = string3.endsWith("CB") || string3.endsWith("RD"))) {
                    boolean bl2;
                    string7 = popupResource.getStructure(string3);
                    object2 = string3.substring(0, string3.length() - (!bl ? 8 : 2));
                    boolean bl3 = bl2 = bl && string3.endsWith("RD");
                    if (string7 == null || string7.length() == 0 && !bl2) {
                        string7 = "set " + (String)object2 + " T/F";
                    }
                    object3 = this.menuCreateCheckboxItem(object, string4, (String)object2 + ":" + string7, string5 + "." + string3, false, bl2);
                    this.rememberCheckbox((String)object2, object3);
                    if (bl2) {
                        this.menuAddButtonGroup(object3);
                    }
                } else {
                    string7 = popupResource.getStructure(string3);
                    if (string7 == null) {
                        string7 = string3;
                    }
                    if (!this.isJS && string3.startsWith("JS")) continue;
                    object3 = this.menuCreateItem(object, string4, string7, string5 + "." + string3);
                }
            }
            if (!this.allowSignedFeatures && string3.startsWith("SIGNED")) {
                this.menuEnable(object3, false);
            }
            if (string3.indexOf("VARIABLE") >= 0) {
                this.htMenus.put(string3, object3);
            }
            if (string3.indexOf("!PDB") >= 0) {
                this.NotPDB.addLast(object3);
            } else if (string3.indexOf("PDB") >= 0) {
                this.PDBOnly.addLast(object3);
            }
            if (string3.indexOf("URL") >= 0) {
                this.AppletOnly.addLast(object3);
            } else if (string3.indexOf("CHARGE") >= 0) {
                this.ChargesOnly.addLast(object3);
            } else if (string3.indexOf("BFACTORS") >= 0) {
                this.TemperatureOnly.addLast(object3);
            } else if (string3.indexOf("UNITCELL") >= 0) {
                this.UnitcellOnly.addLast(object3);
            } else if (string3.indexOf("FILEUNIT") >= 0) {
                this.FileUnitOnly.addLast(object3);
            } else if (string3.indexOf("FILEMOL") >= 0) {
                this.FileMolOnly.addLast(object3);
            }
            if (string3.indexOf("!FRAMES") >= 0) {
                this.SingleModelOnly.addLast(object3);
            } else if (string3.indexOf("FRAMES") >= 0) {
                this.FramesOnly.addLast(object3);
            }
            if (string3.indexOf("VIBRATION") >= 0) {
                this.VibrationOnly.addLast(object3);
            } else if (string3.indexOf("SYMMETRY") >= 0) {
                this.SymmetryOnly.addLast(object3);
            }
            if (string3.startsWith("SIGNED")) {
                this.SignedOnly.addLast(object3);
            }
            if (string3.indexOf("SPECIAL") < 0) continue;
            this.Special.addLast(object3);
        }
    }

    private boolean checkKey(String string) {
        return true;
    }

    private void rememberCheckbox(String string, Object object) {
        this.htCheckbox.put(string + "::" + this.htCheckbox.size(), object);
    }

    private void checkForCheckBoxScript(Object object, String string, boolean bl) {
        if (string.indexOf("##") < 0) {
            int n = string.indexOf(":");
            if (n < 0) {
                Logger.error((String)("check box " + object + " IS " + string));
                return;
            }
            String string2 = string.substring(0, n);
            if (this.viewer.getBooleanProperty(string2) == bl) {
                return;
            }
            if (string2.endsWith("P!")) {
                if (string2.indexOf("??") >= 0) {
                    string = this.menuSetCheckBoxOption(object, string2, string);
                } else {
                    if (!bl) {
                        return;
                    }
                    string = "set picking " + string2.substring(0, string2.length() - 2);
                }
            } else {
                if ((n = (string = string.substring(n + 1)).indexOf("|")) >= 0) {
                    string = (bl ? string.substring(0, n) : string.substring(n + 1)).trim();
                }
                string = PT.simpleReplace((String)string, (String)"T/F", (String)(bl ? " TRUE" : " FALSE"));
            }
        }
        this.viewer.evalStringQuiet(string);
    }

    @Override
    public void checkMenuClick(Object object, String string) {
        this.checkMenuClickGP(object, string);
    }

    protected void checkMenuClickGP(Object object, String string) {
        this.restorePopupMenu();
        if (string == null || string.length() == 0) {
            return;
        }
        if (string.equals("MAIN")) {
            this.show(this.thisx, this.thisy, true);
            return;
        }
        String string2 = this.menuGetId(object);
        if (string2 != null) {
            string = this.fixScript(string2, string);
            this.currentMenuItemId = string2;
        }
        this.viewer.evalStringQuiet(string);
    }

    private Object addMenuItem(Object object, String string) {
        return this.menuCreateItem(object, string, "", null);
    }

    private void checkSpecialMenu(String string, Object object, String string2) {
        if ("aboutComputedMenu".equals(string)) {
            this.aboutComputedMenuBaseCount = this.menuGetItemCount(object);
        } else if ("modelSetMenu".equals(string)) {
            this.nullModelSetName = string2;
            this.menuEnable(object, false);
        }
    }

    private void updateFileMenu() {
        Object object = this.htMenus.get("fileMenu");
        if (object == null) {
            return;
        }
        String string = this.getMenuText("writeFileTextVARIABLE");
        object = this.htMenus.get("writeFileTextVARIABLE");
        if (this.modelSetFileName.equals("zapped") || this.modelSetFileName.equals("")) {
            this.menuSetLabel(object, GT._((String)"No atoms loaded"));
            this.menuEnableItem(object, false);
        } else {
            this.menuSetLabel(object, GT.o((String)GT._((String)string), (Object)this.modelSetFileName));
            this.menuEnableItem(object, true);
        }
    }

    private String getMenuText(String string) {
        String string2 = this.menuText.getProperty(string);
        return string2 == null ? string : string2;
    }

    private void updateSelectMenu() {
        Object object = this.htMenus.get("selectMenuText");
        if (object == null) {
            return;
        }
        this.menuEnable(object, this.atomCount != 0);
        this.menuSetLabel(object, this.gti("selectMenuText", this.viewer.getSelectionCount()));
    }

    private void updateElementsComputedMenu(BS bS) {
        String string;
        String string2;
        Object object = this.htMenus.get("elementsComputedMenu");
        if (object == null) {
            return;
        }
        this.menuRemoveAll(object, 0);
        this.menuEnable(object, false);
        if (bS == null) {
            return;
        }
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            String string3 = Elements.elementNameFromNumber((int)n);
            string2 = Elements.elementSymbolFromNumber((int)n);
            string = string2 + " - " + string3;
            this.menuCreateItem(object, string, "SELECT " + string3, null);
            n = bS.nextSetBit(n + 1);
        }
        for (n = 4; n < Elements.altElementMax; ++n) {
            int n2 = Elements.elementNumberMax + n;
            if (!bS.get(n2)) continue;
            n2 = Elements.altElementNumberFromIndex((int)n);
            string2 = Elements.elementNameFromNumber((int)n2);
            string = Elements.elementSymbolFromNumber((int)n2);
            String string4 = string + " - " + string2;
            this.menuCreateItem(object, string4, "SELECT " + string2, null);
        }
        this.menuEnable(object, true);
    }

    private void updateSpectraMenu() {
        Object object;
        Object object2 = this.htMenus.get("hnmrMenu");
        Object object3 = this.htMenus.get("cnmrMenu");
        if (object2 != null) {
            this.menuRemoveAll(object2, 0);
        }
        if (object3 != null) {
            this.menuRemoveAll(object3, 0);
        }
        if ((object = this.htMenus.get("spectraMenu")) == null) {
            return;
        }
        this.menuRemoveAll(object, 0);
        boolean bl = this.setSpectraMenu(object2, this.hnmrPeaks) | this.setSpectraMenu(object3, this.cnmrPeaks);
        if (bl) {
            if (object2 != null) {
                this.menuAddSubMenu(object, object2);
            }
            if (object3 != null) {
                this.menuAddSubMenu(object, object3);
            }
        }
        this.menuEnable(object, bl);
    }

    private boolean setSpectraMenu(Object object, List<String> list) {
        int n;
        if (object == null) {
            return false;
        }
        this.menuEnable(object, false);
        int n2 = n = list == null ? 0 : list.size();
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            String string = (String)list.get(i);
            String string2 = PT.getQuotedAttribute((String)string, (String)"title");
            String string3 = PT.getQuotedAttribute((String)string, (String)"atoms");
            if (string3 == null) continue;
            this.menuCreateItem(object, string2, "select visible & (@" + PT.simpleReplace((String)string3, (String)",", (String)" or @") + ")", "Focus" + i);
        }
        this.menuEnable(object, true);
        return true;
    }

    private void updateHeteroComputedMenu(Map<String, String> map) {
        Object object = this.htMenus.get("PDBheteroComputedMenu");
        if (object == null) {
            return;
        }
        this.menuRemoveAll(object, 0);
        this.menuEnable(object, false);
        if (map == null) {
            return;
        }
        int n = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (string2.length() > 20) {
                string2 = string2.substring(0, 20) + "...";
            }
            String string3 = string + " - " + string2;
            this.menuCreateItem(object, string3, "SELECT [" + string + "]", null);
            ++n;
        }
        this.menuEnable(object, n > 0);
    }

    private void updateSurfMoComputedMenu(Map<String, Object> map) {
        Object object = this.htMenus.get("surfMoComputedMenuText");
        if (object == null) {
            return;
        }
        this.menuRemoveAll(object, 0);
        List list = map == null ? null : (List)map.get("mos");
        int n = list == null ? 0 : list.size();
        String string = this.getMenuText("surfMoComputedMenuText");
        if (n == 0) {
            this.menuSetLabel(object, GT.o((String)GT._((String)string), (Object)""));
            this.menuEnable(object, false);
            return;
        }
        this.menuSetLabel(object, GT.i((String)GT._((String)string), (int)n));
        this.menuEnable(object, true);
        Object object2 = object;
        int n2 = n % this.itemMax;
        if (n2 == 0) {
            n2 = this.itemMax;
        }
        int n3 = n > this.itemMax ? 0 : Integer.MIN_VALUE;
        int n4 = n;
        while (--n4 >= 0) {
            Object object3;
            if (n3 >= 0 && n3++ % n2 == 0) {
                if (n3 == n2 + 1) {
                    n2 = this.itemMax;
                }
                object3 = "mo" + n3 + "Menu";
                object2 = this.menuNewSubMenu(Math.max(n4 + 2 - n2, 1) + "..." + (n4 + 1), this.menuGetId(object) + "." + (String)object3);
                this.menuAddSubMenu(object, object2);
                this.htMenus.put((String)object3, object2);
                n3 = 1;
            }
            object3 = (Map)list.get(n4);
            String string2 = "#" + (n4 + 1) + " " + (object3.containsKey("type") ? (String)object3.get("type") + " " : "") + (object3.containsKey("symmetry") ? (String)object3.get("symmetry") + " " : "") + (object3.containsKey("energy") ? object3.get("energy") : "");
            String string3 = "mo " + (n4 + 1);
            this.menuCreateItem(object2, string2, string3, null);
        }
    }

    private void updateSceneComputedMenu() {
        Object object = this.htMenus.get("sceneComputedMenu");
        if (object == null) {
            return;
        }
        this.menuRemoveAll(object, 0);
        this.menuEnable(object, false);
        String[] stringArray = this.viewer.getSceneList();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.menuCreateItem(object, stringArray[i], "restore scene " + Escape.eS((String)stringArray[i]) + " 1.0", null);
        }
        this.menuEnable(object, true);
    }

    private void updatePDBComputedMenus() {
        Object object = this.htMenus.get("PDBaaResiduesComputedMenu");
        if (object == null) {
            return;
        }
        this.menuRemoveAll(object, 0);
        this.menuEnable(object, false);
        Object object2 = this.htMenus.get("PDBnucleicResiduesComputedMenu");
        if (object2 == null) {
            return;
        }
        this.menuRemoveAll(object2, 0);
        this.menuEnable(object2, false);
        Object object3 = this.htMenus.get("PDBcarboResiduesComputedMenu");
        if (object3 == null) {
            return;
        }
        this.menuRemoveAll(object3, 0);
        this.menuEnable(object3, false);
        if (this.modelSetInfo == null) {
            return;
        }
        int n = this.modelIndex < 0 ? 0 : this.modelIndex + 1;
        String[] stringArray = (String[])this.modelSetInfo.get("group3Lists");
        this.group3List = stringArray == null ? null : stringArray[n];
        int[] nArray = this.group3Counts = stringArray == null ? null : ((int[][])this.modelSetInfo.get("group3Counts"))[n];
        if (this.group3List == null) {
            return;
        }
        int n2 = 0;
        for (int i = 1; i < 24; ++i) {
            n2 += this.updateGroup3List(object, JC.predefinedGroup3Names[i]);
        }
        this.menuEnable(object, (n2 += this.augmentGroup3List(object, "p>", true)) > 0);
        this.menuEnable(this.htMenus.get("PDBproteinMenu"), n2 > 0);
        n2 = this.augmentGroup3List(object2, "n>", false);
        this.menuEnable(object2, n2 > 0);
        this.menuEnable(this.htMenus.get("PDBnucleicMenu"), n2 > 0);
        n2 = this.augmentGroup3List(object3, "c>", false);
        this.menuEnable(object3, n2 > 0);
        this.menuEnable(this.htMenus.get("PDBcarboMenu"), n2 > 0);
    }

    private int updateGroup3List(Object object, String string) {
        int n = 0;
        int n2 = this.group3Counts[this.group3List.indexOf(string) / 6];
        String string2 = null;
        if (n2 > 0) {
            string2 = "SELECT " + string;
            string = string + "  (" + n2 + ")";
            ++n;
        }
        Object object2 = this.menuCreateItem(object, string, string2, this.menuGetId(object) + "." + string);
        if (n2 == 0) {
            this.menuEnableItem(object2, false);
        }
        return n;
    }

    private int augmentGroup3List(Object object, String string, boolean bl) {
        int n = 138;
        int n2 = 0;
        while ((n = this.group3List.indexOf(string, n)) >= 0) {
            if (n2++ == 0 && bl) {
                this.menuAddSeparator(object);
            }
            int n3 = this.group3Counts[n / 6];
            String string2 = this.group3List.substring(n + 2, n + 5);
            String string3 = string2 + "  (" + n3 + ")";
            this.menuCreateItem(object, string3, "SELECT [" + string2 + "]", this.menuGetId(object) + "." + string3);
            ++n;
        }
        return n2;
    }

    private void updateSYMMETRYComputedMenus() {
        this.updateSYMMETRYSelectComputedMenu();
        this.updateSYMMETRYShowComputedMenu();
    }

    private void updateSYMMETRYShowComputedMenu() {
        Object object = this.htMenus.get("SYMMETRYShowComputedMenu");
        if (object == null) {
            return;
        }
        this.menuRemoveAll(object, 0);
        this.menuEnable(object, false);
        if (!this.isSymmetry || this.modelIndex < 0) {
            return;
        }
        Map map = (Map)this.viewer.getProperty("DATA_API", "spaceGroupInfo", null);
        if (map == null) {
            return;
        }
        Object[][] objectArray = (Object[][])map.get("operations");
        if (objectArray == null) {
            return;
        }
        String string = (String)map.get("spaceGroupName");
        this.menuSetLabel(object, string == null ? GT._((String)"Space Group") : string);
        Object object2 = object;
        int n = this.itemMax;
        int n2 = objectArray.length > this.itemMax ? 0 : Integer.MIN_VALUE;
        for (int i = 0; i < objectArray.length; ++i) {
            String string2;
            if (n2 >= 0 && n2++ % n == 0) {
                string2 = "drawsymop" + n2 + "Menu";
                object2 = this.menuNewSubMenu(i + 1 + "..." + Math.min(i + this.itemMax, objectArray.length), this.menuGetId(object) + "." + string2);
                this.menuAddSubMenu(object, object2);
                this.htMenus.put(string2, object2);
                n2 = 1;
            }
            if ((string2 = (String)objectArray[i][1]).indexOf("x1") < 0) {
                string2 = (String)objectArray[i][0];
            }
            String string3 = i + 1 + " " + objectArray[i][2] + " (" + string2 + ")";
            this.menuEnableItem(this.menuCreateItem(object2, string3, "draw SYMOP " + (i + 1), null), true);
        }
        this.menuEnable(object, true);
    }

    private void updateSYMMETRYSelectComputedMenu() {
        Object object = this.htMenus.get("SYMMETRYSelectComputedMenu");
        if (object == null) {
            return;
        }
        this.menuRemoveAll(object, 0);
        this.menuEnable(object, false);
        if (!this.isSymmetry || this.modelIndex < 0) {
            return;
        }
        String[] stringArray = (String[])this.modelInfo.get("symmetryOperations");
        if (stringArray == null) {
            return;
        }
        int[] nArray = (int[])this.modelInfo.get("unitCellRange");
        boolean bl = nArray != null;
        Object object2 = object;
        int n = this.itemMax;
        int n2 = stringArray.length > this.itemMax ? 0 : Integer.MIN_VALUE;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (n2 >= 0 && n2++ % n == 0) {
                string = "symop" + n2 + "Menu";
                object2 = this.menuNewSubMenu(i + 1 + "..." + Math.min(i + this.itemMax, stringArray.length), this.menuGetId(object) + "." + string);
                this.menuAddSubMenu(object, object2);
                this.htMenus.put(string, object2);
                n2 = 1;
            }
            string = "symop=" + (i + 1) + " # " + stringArray[i];
            this.menuEnableItem(this.menuCreateItem(object2, string, "SELECT symop=" + (i + 1), null), bl);
        }
        this.menuEnable(object, true);
    }

    private void updateFRAMESbyModelComputedMenu() {
        Object object = this.htMenus.get("FRAMESbyModelComputedMenu");
        if (object == null) {
            return;
        }
        this.menuEnable(object, this.modelCount > 0);
        this.menuSetLabel(object, this.modelIndex < 0 ? this.gti("allModelsText", this.modelCount) : this.gto("modelMenuText", this.modelIndex + 1 + "/" + this.modelCount));
        this.menuRemoveAll(object, 0);
        if (this.modelCount < 1) {
            return;
        }
        if (this.modelCount > 1) {
            this.menuCreateCheckboxItem(object, GT._((String)"All"), "frame 0 ##", null, this.modelIndex < 0, false);
        }
        Object object2 = object;
        int n = this.itemMax;
        int n2 = this.modelCount > this.itemMax ? 0 : Integer.MIN_VALUE;
        for (int i = 0; i < this.modelCount; ++i) {
            String string;
            if (n2 >= 0 && n2++ % n == 0) {
                string = "model" + n2 + "Menu";
                object2 = this.menuNewSubMenu(i + 1 + "..." + Math.min(i + this.itemMax, this.modelCount), this.menuGetId(object) + "." + string);
                this.menuAddSubMenu(object, object2);
                this.htMenus.put(string, object2);
                n2 = 1;
            }
            string = "" + this.viewer.getModelNumberDotted(i);
            String string2 = this.viewer.getModelName(i);
            String string3 = (String)this.viewer.getModelAuxiliaryInfoValue(i, "spectrumTypes");
            if (string3 != null && string2.startsWith(string3)) {
                string3 = null;
            }
            if (!string2.equals(string)) {
                int n3 = string2.indexOf(";PATH");
                if (n3 >= 0) {
                    string2 = string2.substring(0, n3);
                }
                if (string2.indexOf("Model[") == 0 && (n3 = string2.indexOf("]:")) >= 0) {
                    string2 = string2.substring(n3 + 2);
                }
                string2 = string + ": " + string2;
            }
            if (string2.length() > 60) {
                string2 = string2.substring(0, 55) + "...";
            }
            if (string3 != null) {
                string2 = string2 + " (" + string3 + ")";
            }
            this.menuCreateCheckboxItem(object2, string2, "model " + string + " ##", null, this.modelIndex == i, false);
        }
    }

    private void updateConfigurationComputedMenu() {
        Object object = this.htMenus.get("configurationComputedMenu");
        if (object == null) {
            return;
        }
        this.menuEnable(object, this.isMultiConfiguration);
        if (!this.isMultiConfiguration) {
            return;
        }
        int n = this.altlocs.length();
        this.menuSetLabel(object, this.gti("configurationMenuText", n));
        this.menuRemoveAll(object, 0);
        String string = "hide none ##CONFIG";
        this.menuCreateCheckboxItem(object, GT._((String)"All"), string, null, this.updateMode == 1 && this.configurationSelected.equals(string), false);
        for (int i = 0; i < n; ++i) {
            string = "configuration " + (i + 1) + "; hide thisModel and not selected ##CONFIG";
            String string2 = "" + (i + 1) + " -- \"" + this.altlocs.charAt(i) + "\"";
            this.menuCreateCheckboxItem(object, string2, string, null, this.updateMode == 1 && this.configurationSelected.equals(string), false);
        }
    }

    private void updateModelSetComputedMenu() {
        Object object = this.htMenus.get("modelSetMenu");
        if (object == null) {
            return;
        }
        this.menuRemoveAll(object, 0);
        this.menuSetLabel(object, this.nullModelSetName);
        this.menuEnable(object, false);
        this.menuEnable(this.htMenus.get("surfaceMenu"), !this.isZapped);
        this.menuEnable(this.htMenus.get("measureMenu"), !this.isZapped);
        this.menuEnable(this.htMenus.get("pickingMenu"), !this.isZapped);
        this.menuEnable(this.htMenus.get("computationMenu"), !this.isZapped);
        if (this.modelSetName == null || this.isZapped) {
            return;
        }
        if (this.isMultiFrame) {
            this.modelSetName = this.gti("modelSetCollectionText", this.modelCount);
            if (this.modelSetName.length() > this.titleWidthMax) {
                this.modelSetName = this.modelSetName.substring(0, this.titleWidthMax) + "...";
            }
        } else if (this.viewer.getBooleanProperty("hideNameInPopup")) {
            this.modelSetName = this.getMenuText("hiddenModelSetText");
        } else if (this.modelSetName.length() > this.titleWidthMax) {
            this.modelSetName = this.modelSetName.substring(0, this.titleWidthMax) + "...";
        }
        this.menuSetLabel(object, this.modelSetName);
        this.menuEnable(object, true);
        this.menuEnable(this.htMenus.get("computationMenu"), this.atomCount <= 100);
        this.addMenuItem(object, this.gti("atomsText", this.atomCount));
        this.addMenuItem(object, this.gti("bondsText", this.viewer.getBondCountInModel(this.modelIndex)));
        if (this.isPDB) {
            List list;
            this.menuAddSeparator(object);
            this.addMenuItem(object, this.gti("groupsText", this.viewer.getGroupCountInModel(this.modelIndex)));
            this.addMenuItem(object, this.gti("chainsText", this.viewer.getChainCountInModel(this.modelIndex)));
            this.addMenuItem(object, this.gti("polymersText", this.viewer.getPolymerCountInModel(this.modelIndex)));
            Object object2 = this.htMenus.get("BiomoleculesMenu");
            if (object2 == null) {
                object2 = this.menuNewSubMenu(GT._((String)this.getMenuText("biomoleculesMenuText")), this.menuGetId(object) + ".biomolecules");
                this.menuAddSubMenu(object, object2);
            }
            this.menuRemoveAll(object2, 0);
            this.menuEnable(object2, false);
            if (this.modelIndex >= 0 && (list = (List)this.viewer.getModelAuxiliaryInfoValue(this.modelIndex, "biomolecules")) != null) {
                this.menuEnable(object2, true);
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    String string = this.isMultiFrame ? "" : "save orientation;load \"\" FILTER \"biomolecule " + (i + 1) + "\";restore orientation;";
                    int n2 = (Integer)((Map)list.get(i)).get("atomCount");
                    String string2 = this.gto(this.isMultiFrame ? "biomoleculeText" : "loadBiomoleculeText", new Object[]{i + 1, n2});
                    this.menuCreateItem(object2, string2, string, null);
                }
            }
        }
        if (this.isApplet && !this.viewer.getBooleanProperty("hideNameInPopup")) {
            this.menuAddSeparator(object);
            this.menuCreateItem(object, this.gto("viewMenuText", this.modelSetFileName), "show url", null);
        }
    }

    private String gti(String string, int n) {
        return GT.i((String)GT._((String)this.getMenuText(string)), (int)n);
    }

    private String gto(String string, Object object) {
        return GT.o((String)GT._((String)this.getMenuText(string)), (Object)object);
    }

    private void updateAboutSubmenu() {
        Object object = this.htMenus.get("aboutComputedMenu");
        if (object == null) {
            return;
        }
        this.menuRemoveAll(object, this.aboutComputedMenuBaseCount);
        Object object2 = this.menuNewSubMenu("About molecule", "modelSetMenu");
        this.menuAddSubMenu(object, object2);
        this.htMenus.put("modelSetMenu", object2);
        this.updateModelSetComputedMenu();
        object2 = this.menuNewSubMenu("Jmol " + JC.version + (this.viewer.isWebGL ? " (WebGL)" : (this.viewer.isJS ? " (HTML5)" : (this.isSigned ? " (signed)" : ""))), "aboutJmolMenu");
        this.menuAddSubMenu(object, object2);
        this.htMenus.put("aboutJmolMenu", object2);
        this.addMenuItem(object2, JC.date);
        this.menuCreateItem(object2, "http://www.jmol.org", "show url \"http://www.jmol.org\"", null);
        this.menuCreateItem(object2, GT._((String)"Mouse Manual"), "show url \"http://wiki.jmol.org/index.php/Mouse_Manual\"", null);
        this.menuCreateItem(object2, GT._((String)"Translations"), "show url \"http://wiki.jmol.org/index.php/Internationalisation\"", null);
        object2 = this.menuNewSubMenu(GT._((String)"System"), "systemMenu");
        this.menuAddSubMenu(object, object2);
        this.htMenus.put("systemMenu", object2);
        this.addMenuItem(object2, this.viewer.getOperatingSystemName());
        this.menuAddSeparator(object2);
        this.addMenuItem(object2, GT._((String)"Java version:"));
        this.addMenuItem(object2, this.viewer.getJavaVendor());
        this.addMenuItem(object2, this.viewer.getJavaVersion());
        Runtime runtime = Runtime.getRuntime();
        int n = runtime.availableProcessors();
        if (n > 0) {
            this.addMenuItem(object2, n == 1 ? GT._((String)"1 processor") : GT.i((String)GT._((String)"{0} processors"), (int)n));
        } else {
            this.addMenuItem(object2, GT._((String)"unknown processor count"));
        }
        this.addMenuItem(object2, GT._((String)"Java memory usage:"));
        int n2 = this.convertToMegabytes(runtime.totalMemory());
        int n3 = this.convertToMegabytes(runtime.freeMemory());
        int n4 = this.convertToMegabytes(runtime.maxMemory());
        this.addMenuItem(object2, GT.i((String)GT._((String)"{0} MB total"), (int)n2));
        this.addMenuItem(object2, GT.i((String)GT._((String)"{0} MB free"), (int)n3));
        if (n4 > 0) {
            this.addMenuItem(object2, GT.i((String)GT._((String)"{0} MB maximum"), (int)n4));
        }
    }

    private void updateLanguageSubmenu() {
        Object object = this.htMenus.get("languageComputedMenu");
        if (object == null) {
            return;
        }
        this.menuRemoveAll(object, 0);
        String string = GT.getLanguage();
        String string2 = this.menuGetId(object);
        Language[] languageArray = GT.getLanguageList(null);
        int n = 0;
        for (int i = 0; i < languageArray.length; ++i) {
            if (string.equals(languageArray[i].code)) {
                languageArray[i].display = true;
            }
            if (!languageArray[i].display) continue;
            String string3 = languageArray[i].code;
            String string4 = languageArray[i].language;
            String string5 = languageArray[i].nativeLanguage;
            String string6 = string3 + " - " + GT._((String)string4);
            if (string5 != null && !string5.equals(GT._((String)string4))) {
                string6 = string6 + " - " + string5;
            }
            if (n++ > 0 && n % 4 == 1) {
                this.menuAddSeparator(object);
            }
            this.menuCreateCheckboxItem(object, string6, "language = \"" + string3 + "\" ##" + string4, string2 + "." + string3, string.equals(string3), false);
        }
    }

    private int convertToMegabytes(long l) {
        if (l <= 0x7FFFFFFFFFF7FFFFL) {
            l += 524288L;
        }
        return (int)(l / 0x100000L);
    }

    private void updateForShow() {
        if (this.updateMode == -1) {
            return;
        }
        this.getViewerData();
        this.updateMode = 2;
        this.updateSelectMenu();
        this.updateSpectraMenu();
        this.updateFRAMESbyModelComputedMenu();
        this.updateSceneComputedMenu();
        this.updateModelSetComputedMenu();
        this.updateAboutSubmenu();
        int n = this.Special.size();
        while (--n >= 0) {
            this.updateSpecialMenuItem(this.Special.get(n));
        }
    }

    private void setFrankMenu(String string) {
        int n;
        if (this.currentFrankId != null && this.currentFrankId == string && this.nFrankList > 0) {
            return;
        }
        if (this.frankPopup == null) {
            this.frankPopup = this.menuCreatePopup("Frank");
        }
        this.thisPopup = this.frankPopup;
        this.menuRemoveAll(this.frankPopup, 0);
        if (string == null) {
            return;
        }
        this.currentFrankId = string;
        this.nFrankList = 0;
        this.frankList[this.nFrankList++] = new Object[]{null, null, null};
        this.menuCreateItem(this.frankPopup, this.getMenuText("mainMenuText"), "MAIN", "");
        int n2 = string.indexOf(".", 2) + 1;
        while ((n = string.indexOf(".", n2)) >= 0) {
            String string2 = string.substring(n2, n);
            Object object = this.htMenus.get(string2);
            this.frankList[this.nFrankList++] = new Object[]{this.menuGetParent(object), object, this.menuGetPosition(object)};
            this.menuAddSubMenu(this.frankPopup, object);
            n2 = n + 1;
        }
        this.thisPopup = this.popupMenu;
    }

    private void show(int n, int n2, boolean bl) {
        this.thisx = n;
        this.thisy = n2;
        this.updateForShow();
        for (Map.Entry<String, Object> entry : this.htCheckbox.entrySet()) {
            String string = entry.getKey();
            Object object = entry.getValue();
            String string2 = string.substring(0, string.indexOf(":"));
            boolean bl2 = this.viewer.getBooleanProperty(string2);
            this.menuSetCheckBoxState(object, bl2);
        }
        if (bl) {
            this.menuShowPopup(this.popupMenu, this.thisx, this.thisy);
        }
    }

    protected String getSpecialLabel(String string, String string2) {
        int n = string2.indexOf(" (");
        if (n < 0) {
            n = string2.length();
        }
        String string3 = null;
        if (string.indexOf("captureLooping") >= 0) {
            string3 = this.viewer.getAnimationReplayMode().name().equals("ONCE") ? "ONCE" : "LOOP";
        } else if (string.indexOf("captureFps") >= 0) {
            string3 = "" + this.viewer.getInt(553648132);
        } else if (string.indexOf("captureMenu") >= 0) {
            string3 = this.viewer.captureParams == null ? GT._((String)"not capturing") : this.viewer.getFilePath((String)this.viewer.captureParams.get("captureFileName"), true) + " " + this.viewer.captureParams.get("captureCount");
        }
        return string3 == null ? string2 : string2.substring(0, n) + " (" + string3 + ")";
    }
}

