/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.pymol;

import java.util.Map;
import org.jmol.adapter.readers.pymol.PyMOLReader;
import org.jmol.atomdata.RadiusData;
import org.jmol.constant.EnumVdw;
import org.jmol.modelset.Atom;
import org.jmol.modelset.MeasurementData;
import org.jmol.modelset.ModelSet;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;
import org.jmol.util.JmolList;
import org.jmol.util.P3;
import org.jmol.util.Point3fi;
import org.jmol.util.SB;
import org.jmol.util.Tuple3f;
import org.jmol.viewer.ShapeManager;

public class ModelSettings {
    static final int cPuttyTransformNormalizedNonlinear = 0;
    static final int cPuttyTransformRelativeNonlinear = 1;
    static final int cPuttyTransformScaledNonlinear = 2;
    static final int cPuttyTransformAbsoluteNonlinear = 3;
    static final int cPuttyTransformNormalizedLinear = 4;
    static final int cPuttyTransformRelativeLinear = 5;
    static final int cPuttyTransformScaledLinear = 6;
    static final int cPuttyTransformAbsoluteLinear = 7;
    static final int cPuttyTransformImpliedRMS = 8;
    private int id;
    private BS bsAtoms;
    private Object info;
    private int size = -1;
    private short[] colixes;
    private Object[] colors;
    public int argb;
    public float translucency = 0.0f;
    public RadiusData rd;

    public ModelSettings(int n, BS bS, Object object) {
        this.id = n;
        this.bsAtoms = bS;
        this.info = object;
    }

    public void offset(int n, int n2) {
        if (n2 <= 0) {
            return;
        }
        if (this.id == 0x400000D0) {
            Map map = (Map)this.info;
            map.put("baseModel", n);
            JmolList jmolList = (JmolList)map.get("states");
            int n3 = jmolList.size();
            while (--n3 >= 0) {
                BSUtil.offset((BS)((BS)jmolList.get(n3)), (int)0, (int)n2);
            }
            return;
        }
        if (this.id == 1060866) {
            JmolList jmolList = (JmolList)this.info;
            int n4 = jmolList.size();
            while (--n4 >= 0) {
                BSUtil.offset((BS)((BS)jmolList.get(n4)), (int)0, (int)n2);
            }
            return;
        }
        if (this.bsAtoms != null) {
            BSUtil.offset((BS)this.bsAtoms, (int)0, (int)n2);
        }
        if (this.colixes != null) {
            short[] sArray = new short[this.colixes.length + n2];
            System.arraycopy(this.colixes, 0, sArray, n2, this.colixes.length);
            this.colixes = sArray;
        }
    }

    public void createShape(ModelSet modelSet, BS bS) {
        ShapeManager shapeManager = modelSet.shapeManager;
        int n = this.getModelIndex(modelSet);
        String string = null;
        switch (this.id) {
            case 0x400000D0: {
                shapeManager.viewer.setMovie((Map)this.info);
                return;
            }
            case 4115: {
                int n2 = (Integer)this.info;
                if (n2 > 0) {
                    shapeManager.viewer.setCurrentModelIndex(n2 + n - 1);
                } else {
                    shapeManager.viewer.setAnimationRange(-1, -1);
                    shapeManager.viewer.setCurrentModelIndex(-1);
                }
                return;
            }
            case 3145770: {
                shapeManager.viewer.displayAtoms(this.bsAtoms, false, false, Boolean.TRUE, true);
                return;
            }
            case 1060866: {
                shapeManager.viewer.defineAtomSets((Map)this.info);
                return;
            }
            case 5: {
                shapeManager.loadShape(this.id);
                shapeManager.setShapePropertyBs(this.id, "textLabels", this.info, this.bsAtoms);
                return;
            }
            case 6: {
                if (n < 0) {
                    return;
                }
                shapeManager.loadShape(this.id);
                MeasurementData measurementData = (MeasurementData)this.info;
                measurementData.setModelSet(modelSet);
                JmolList jmolList = measurementData.points;
                int n3 = jmolList.size();
                while (--n3 >= 0) {
                    ((Point3fi)jmolList.get((int)n3)).modelIndex = (short)n;
                }
                shapeManager.setShapePropertyBs(this.id, "measure", (Object)measurementData, this.bsAtoms);
                if (this.size != -1) {
                    shapeManager.setShapeSizeBs(this.id, this.size, null, null);
                }
                return;
            }
            case 1: {
                break;
            }
            case 0: {
                break;
            }
            case 23: {
                shapeManager.viewer.setCGO((JmolList)this.info);
                break;
            }
            case 0x400000C0: {
                JmolList jmolList = (JmolList)this.info;
                String string2 = jmolList.get(jmolList.size() - 2).toString();
                String string3 = jmolList.get(jmolList.size() - 1).toString();
                float f = PyMOLReader.floatAt(PyMOLReader.listAt((JmolList<Object>)jmolList, 3), 0);
                float f2 = PyMOLReader.floatAt(PyMOLReader.listAt((JmolList<Object>)jmolList, 3), 2);
                SB sB = new SB();
                sB.append("set isosurfacekey true;isosurface ID ").append(Escape.eS((String)string2)).append(" map \"\" ").append(Escape.eS((String)string3)).append(";color isosurface range " + f + " " + f2 + ";isosurface colorscheme rwb");
                string = sB.toString();
                break;
            }
            case 1073742018: {
                n = shapeManager.viewer.getCurrentModelIndex();
                JmolList jmolList = (JmolList)this.info;
                String string4 = jmolList.get(jmolList.size() - 2).toString();
                SB sB = new SB();
                sB.append("isosurface ID ").append(Escape.eS((String)string4)).append(" model ").append(modelSet.models[n].getModelNumberDotted()).append(" color ").append(Escape.escapeColor((int)this.argb)).append(" \"\" ").append(Escape.eS((String)string4)).append(" mesh nofill frontonly");
                float f = PyMOLReader.floatAt(PyMOLReader.listAt(PyMOLReader.listAt((JmolList<Object>)jmolList, 2), 0), 11);
                JmolList<Object> jmolList2 = PyMOLReader.listAt(PyMOLReader.listAt(PyMOLReader.listAt((JmolList<Object>)jmolList, 2), 0), 12);
                if (f > 0.0f) {
                    P3 p3 = new P3();
                    sB.append(";isosurface slab within ").appendF(f).append(" [ ");
                    for (int i = jmolList2.size() - 3; i >= 0; i -= 3) {
                        PyMOLReader.pointAt(jmolList2, i, p3);
                        sB.append(Escape.eP((Tuple3f)p3));
                    }
                    sB.append(" ]");
                }
                sB.append(";set meshScale ").appendI(this.size / 500);
                string = sB.toString();
                break;
            }
            case 24: {
                if (n < 0) {
                    return;
                }
                if (this.argb == 0) {
                    shapeManager.setShapePropertyBs(0, "colors", (Object)this.colors, this.bsAtoms);
                }
                string = ((String[])this.info)[0].toString().replace('\'', '_').replace('\"', '_');
                String string5 = ((String[])this.info)[1];
                String string6 = "";
                if (string5 == null) {
                    string5 = "mesh nofill";
                    string6 = " resolution 1.5";
                }
                string = "isosurface ID \"" + string + "\"" + " model " + modelSet.models[n].getModelNumberDotted() + string6 + " select (" + Escape.eBS((BS)this.bsAtoms) + ") only solvent " + (float)this.size / 1000.0f;
                string = this.argb == 0 ? string + " map property color" : string + " color " + Escape.escapeColor((int)this.argb);
                string = string + " frontOnly " + string5;
                if (!(this.translucency > 0.0f)) break;
                string = string + " translucent " + this.translucency;
                break;
            }
            case 9: 
            case 10: {
                BSUtil.andNot((BS)this.bsAtoms, (BS)bS);
                break;
            }
            case 16: {
                shapeManager.loadShape(this.id);
                shapeManager.setShapePropertyBs(this.id, "ignore", (Object)BSUtil.copyInvert((BS)this.bsAtoms, (int)shapeManager.viewer.getAtomCount()), null);
                break;
            }
            case 13: {
                float f;
                this.id = 10;
                float[] fArray = new float[this.bsAtoms.length()];
                this.rd = new RadiusData(fArray, 0.0f, RadiusData.EnumType.ABSOLUTE, EnumVdw.AUTO);
                Atom[] atomArray = shapeManager.viewer.modelSet.atoms;
                double d = 0.0;
                double d2 = 0.0;
                float f3 = Float.MAX_VALUE;
                float f4 = 0.0f;
                int n4 = this.bsAtoms.cardinality();
                int n5 = this.bsAtoms.nextSetBit(0);
                while (n5 >= 0) {
                    f = Atom.atomPropertyFloat(null, (Atom)atomArray[n5], (int)1112541199);
                    d += (double)f;
                    d2 += (double)(f * f);
                    if (f < f3) {
                        f3 = f;
                    }
                    if (f > f4) {
                        f4 = f;
                    }
                    n5 = this.bsAtoms.nextSetBit(n5 + 1);
                }
                float f5 = (float)(d / (double)n4);
                f = (float)Math.sqrt((d2 - d * d / (double)n4) / (double)n4);
                float f6 = ((float[])this.info)[1];
                float f7 = ((float[])this.info)[2];
                float f8 = ((float[])this.info)[3];
                float f9 = ((float[])this.info)[4];
                float f10 = ((float[])this.info)[5];
                int n6 = (int)((float[])this.info)[6];
                float f11 = f4 - f3;
                boolean bl = false;
                switch (n6) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        bl = true;
                    }
                }
                int n7 = this.bsAtoms.nextSetBit(0);
                int n8 = 0;
                while (n7 >= 0) {
                    float f12 = Atom.atomPropertyFloat(null, (Atom)atomArray[n7], (int)1112541199);
                    switch (n6) {
                        default: {
                            break;
                        }
                        case 0: 
                        case 4: {
                            f12 = 1.0f + (f12 - f5) / f7 / f;
                            break;
                        }
                        case 1: 
                        case 5: {
                            f12 = (f12 - f3) / f11 / f7;
                            break;
                        }
                        case 2: 
                        case 6: {
                            f12 /= f7;
                            break;
                        }
                        case 8: {
                            if (f12 < 0.0f) {
                                f12 = 0.0f;
                            }
                            f12 = (float)(Math.sqrt((double)f12 / 8.0) / Math.PI);
                        }
                    }
                    if (f12 < 0.0f) {
                        f12 = 0.0f;
                    }
                    if (bl) {
                        f12 = (float)Math.pow(f12, f10);
                    }
                    if (f12 < f8 && (double)f8 >= 0.0) {
                        f12 = f8;
                    }
                    if (f12 > f9 && (double)f9 >= 0.0) {
                        f12 = f9;
                    }
                    fArray[n7] = f12 * f6;
                    n7 = this.bsAtoms.nextSetBit(n7 + 1);
                    ++n8;
                }
                break;
            }
        }
        if (string != null) {
            shapeManager.viewer.runScript(string);
            return;
        }
        if (this.size != -1 || this.rd != null) {
            shapeManager.setShapeSizeBs(this.id, this.size, this.rd, this.bsAtoms);
        }
        if (this.translucency > 0.0f) {
            shapeManager.setShapePropertyBs(this.id, "translucentLevel", (Object)Float.valueOf(this.translucency), this.bsAtoms);
            shapeManager.setShapePropertyBs(this.id, "translucency", (Object)"translucent", this.bsAtoms);
        }
        if (this.argb != 0) {
            shapeManager.setShapePropertyBs(this.id, "color", (Object)this.argb, this.bsAtoms);
        } else if (this.colors != null) {
            shapeManager.setShapePropertyBs(this.id, "colors", (Object)this.colors, this.bsAtoms);
        }
    }

    private int getModelIndex(ModelSet modelSet) {
        if (this.bsAtoms == null) {
            return -1;
        }
        int n = this.bsAtoms.nextSetBit(0);
        return n < 0 ? -1 : (int)modelSet.atoms[n].modelIndex;
    }

    public void setColors(short[] sArray, float f) {
        this.colixes = sArray;
        this.colors = new Object[]{sArray, Float.valueOf(f)};
    }

    public void setSize(float f) {
        this.size = (int)(f * 1000.0f);
    }
}

