/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.jmol.api.JmolPropertyManager;
import org.jmol.api.SymmetryInterface;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.script.SV;
import org.jmol.script.T;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.JmolEdge;
import org.jmol.util.JmolList;
import org.jmol.util.JmolMolecule;
import org.jmol.util.JmolNode;
import org.jmol.util.Logger;
import org.jmol.util.Matrix3f;
import org.jmol.util.P3;
import org.jmol.util.Parser;
import org.jmol.util.Quaternion;
import org.jmol.util.SB;
import org.jmol.util.TextFormat;
import org.jmol.util.V3;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyManager
implements JmolPropertyManager {
    Viewer viewer;
    private Map<String, Integer> map = new Hashtable<String, Integer>();
    private static final String atomExpression = "<atom selection>";
    private static final String[] propertyTypes = new String[]{"appletInfo", "", "", "fileName", "", "", "fileHeader", "", "", "fileContents", "<pathname>", "", "fileContents", "", "", "animationInfo", "", "", "modelInfo", "<atom selection>", "{*}", "ligandInfo", "<atom selection>", "{*}", "shapeInfo", "", "", "measurementInfo", "", "", "centerInfo", "", "", "orientationInfo", "", "", "transformInfo", "", "", "atomList", "<atom selection>", "(visible)", "atomInfo", "<atom selection>", "(visible)", "bondInfo", "<atom selection>", "(visible)", "chainInfo", "<atom selection>", "(visible)", "polymerInfo", "<atom selection>", "(visible)", "moleculeInfo", "<atom selection>", "(visible)", "stateInfo", "<state type>", "all", "extractModel", "<atom selection>", "(visible)", "jmolStatus", "statusNameList", "", "jmolViewer", "", "", "messageQueue", "", "", "auxiliaryInfo", "<atom selection>", "{*}", "boundBoxInfo", "", "", "dataInfo", "<data type>", "types", "image", "", "", "evaluate", "<expression>", "", "menu", "<type>", "current", "minimizationInfo", "", "", "pointGroupInfo", "<atom selection>", "(visible)", "fileInfo", "<type>", "", "errorMessage", "", "", "mouseInfo", "", "", "isosurfaceInfo", "", "", "isosurfaceData", "", "", "consoleText", "", "", "jspecView", "<key>", ""};
    private static final int PROP_APPLET_INFO = 0;
    private static final int PROP_FILENAME = 1;
    private static final int PROP_FILEHEADER = 2;
    private static final int PROP_FILECONTENTS_PATH = 3;
    private static final int PROP_FILECONTENTS = 4;
    private static final int PROP_ANIMATION_INFO = 5;
    private static final int PROP_MODEL_INFO = 6;
    private static final int PROP_LIGAND_INFO = 7;
    private static final int PROP_SHAPE_INFO = 8;
    private static final int PROP_MEASUREMENT_INFO = 9;
    private static final int PROP_CENTER_INFO = 10;
    private static final int PROP_ORIENTATION_INFO = 11;
    private static final int PROP_TRANSFORM_INFO = 12;
    private static final int PROP_ATOM_LIST = 13;
    private static final int PROP_ATOM_INFO = 14;
    private static final int PROP_BOND_INFO = 15;
    private static final int PROP_CHAIN_INFO = 16;
    private static final int PROP_POLYMER_INFO = 17;
    private static final int PROP_MOLECULE_INFO = 18;
    private static final int PROP_STATE_INFO = 19;
    private static final int PROP_EXTRACT_MODEL = 20;
    private static final int PROP_JMOL_STATUS = 21;
    private static final int PROP_JMOL_VIEWER = 22;
    private static final int PROP_MESSAGE_QUEUE = 23;
    private static final int PROP_AUXILIARY_INFO = 24;
    private static final int PROP_BOUNDBOX_INFO = 25;
    private static final int PROP_DATA_INFO = 26;
    private static final int PROP_IMAGE = 27;
    private static final int PROP_EVALUATE = 28;
    private static final int PROP_MENU = 29;
    private static final int PROP_MINIMIZATION_INFO = 30;
    private static final int PROP_POINTGROUP_INFO = 31;
    private static final int PROP_FILE_INFO = 32;
    private static final int PROP_ERROR_MESSAGE = 33;
    private static final int PROP_MOUSE_INFO = 34;
    private static final int PROP_ISOSURFACE_INFO = 35;
    private static final int PROP_ISOSURFACE_DATA = 36;
    private static final int PROP_CONSOLE_TEXT = 37;
    private static final int PROP_JSPECVIEW = 38;
    private static final int PROP_COUNT = 39;
    private static final String[] readableTypes = new String[]{"", "stateinfo", "extractmodel", "filecontents", "fileheader", "image", "menu", "minimizationInfo"};

    @Override
    public void setViewer(Viewer viewer) {
        this.viewer = viewer;
        int n = 0;
        for (int i = 0; i < propertyTypes.length; i += 3) {
            this.map.put(propertyTypes[i].toLowerCase(), n++);
        }
    }

    @Override
    public int getPropertyNumber(String string) {
        Integer n = this.map.get(string == null ? "" : string.toLowerCase());
        return n == null ? -1 : n;
    }

    @Override
    public String getDefaultPropertyParam(int n) {
        return n < 0 ? "" : propertyTypes[n * 3 + 2];
    }

    @Override
    public boolean checkPropertyParameter(String string) {
        int n = this.getPropertyNumber(string);
        String string2 = PropertyManager.getParamType(n);
        return string2.length() > 0 && string2 != atomExpression;
    }

    @Override
    public Object getProperty(String string, String string2, Object object) {
        if (propertyTypes.length != 117) {
            Logger.warn("propertyTypes is not the right length: " + propertyTypes.length + " != " + 117);
        }
        Object object2 = string2.indexOf(".") >= 0 || string2.indexOf("[") >= 0 ? this.getModelProperty(string2, object) : this.getPropertyAsObject(string2, object, string);
        if (string == null) {
            return object2;
        }
        boolean bl = string.equalsIgnoreCase("readable");
        if (bl) {
            String string3 = string = PropertyManager.isReadableAsString(string2) ? "String" : "JSON";
        }
        if (string.equalsIgnoreCase("String")) {
            return object2 == null ? "" : object2.toString();
        }
        if (bl) {
            return Escape.toReadable(string2, object2);
        }
        if (string.equalsIgnoreCase("JSON")) {
            return "{" + Escape.toJSON(string2, object2) + "}";
        }
        return object2;
    }

    private Object getModelProperty(String string, Object object) {
        string = string.replace(']', ' ').replace('[', ' ').replace('.', ' ');
        string = TextFormat.simpleReplace(string, "  ", " ");
        String[] stringArray = TextFormat.splitChars(TextFormat.trim(string, " "), " ");
        SV[] sVArray = new SV[stringArray.length];
        string = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            int n = Parser.parseInt(stringArray[i]);
            sVArray[i] = n != Integer.MIN_VALUE ? SV.newScriptVariableInt(n) : SV.newVariable(4, stringArray[i]);
        }
        return this.extractProperty(this.getProperty(null, string, object), sVArray, 1);
    }

    @Override
    public Object extractProperty(Object object, SV[] sVArray, int n) {
        if (n >= sVArray.length) {
            return object;
        }
        SV sV = sVArray[n++];
        switch (sV.tok) {
            case 2: {
                int n2 = sV.asInt() - 1;
                if (object instanceof JmolList) {
                    JmolList jmolList = (JmolList)object;
                    if (n2 < 0) {
                        n2 += jmolList.size();
                    }
                    if (n2 >= 0 && n2 < jmolList.size()) {
                        return this.extractProperty(jmolList.get(n2), sVArray, n);
                    }
                    return "";
                }
                if (object instanceof Matrix3f) {
                    Matrix3f matrix3f = (Matrix3f)object;
                    float[][] fArrayArray = new float[][]{{matrix3f.m00, matrix3f.m01, matrix3f.m02}, {matrix3f.m10, matrix3f.m11, matrix3f.m12}, {matrix3f.m20, matrix3f.m21, matrix3f.m22}};
                    if (n2 < 0) {
                        n2 += 3;
                    }
                    if (n2 >= 0 && n2 < 3) {
                        return this.extractProperty(fArrayArray, sVArray, --n);
                    }
                    return "";
                }
                if (Escape.isAI(object)) {
                    int[] nArray = (int[])object;
                    if (n2 < 0) {
                        n2 += nArray.length;
                    }
                    if (n2 >= 0 && n2 < nArray.length) {
                        return nArray[n2];
                    }
                    return "";
                }
                if (Escape.isAF(object)) {
                    float[] fArray = (float[])object;
                    if (n2 < 0) {
                        n2 += fArray.length;
                    }
                    if (n2 >= 0 && n2 < fArray.length) {
                        return Float.valueOf(fArray[n2]);
                    }
                    return "";
                }
                if (Escape.isAII(object)) {
                    int[][] nArray = (int[][])object;
                    if (n2 < 0) {
                        n2 += nArray.length;
                    }
                    if (n2 >= 0 && n2 < nArray.length) {
                        return this.extractProperty(nArray[n2], sVArray, n);
                    }
                    return "";
                }
                if (Escape.isAFF(object)) {
                    float[][] fArray = (float[][])object;
                    if (n2 < 0) {
                        n2 += fArray.length;
                    }
                    if (n2 >= 0 && n2 < fArray.length) {
                        return this.extractProperty(fArray[n2], sVArray, n);
                    }
                    return "";
                }
                if (Escape.isAS(object)) {
                    String[] stringArray = (String[])object;
                    if (n2 < 0) {
                        n2 += stringArray.length;
                    }
                    if (n2 >= 0 && n2 < stringArray.length) {
                        return stringArray[n2];
                    }
                    return "";
                }
                if (!(object instanceof Object[])) break;
                Object[] objectArray = (Object[])object;
                if (n2 < 0) {
                    n2 += objectArray.length;
                }
                if (n2 >= 0 && n2 < objectArray.length) {
                    return objectArray[n2];
                }
                return "";
            }
            case 4: {
                String string = sV.asString();
                if (object instanceof Map) {
                    Map map = (Map)object;
                    if (string.equalsIgnoreCase("keys")) {
                        JmolList jmolList = new JmolList();
                        Iterator iterator = map.keySet().iterator();
                        while (iterator.hasNext()) {
                            jmolList.addLast(iterator.next());
                        }
                        return this.extractProperty(jmolList, sVArray, n);
                    }
                    if (!map.containsKey(string)) {
                        Iterator iterator = map.keySet().iterator();
                        String string2 = "";
                        while (iterator.hasNext()) {
                            string2 = (String)iterator.next();
                            if (!string2.equalsIgnoreCase(string)) continue;
                            string = string2;
                            break;
                        }
                    }
                    if (map.containsKey(string)) {
                        return this.extractProperty(map.get(string), sVArray, n);
                    }
                    return "";
                }
                if (!(object instanceof JmolList)) break;
                JmolList jmolList = (JmolList)object;
                JmolList<Object> jmolList2 = new JmolList<Object>();
                --n;
                for (int i = 0; i < jmolList.size(); ++i) {
                    Object e = jmolList.get(i);
                    if (!(e instanceof Map)) continue;
                    jmolList2.addLast(this.extractProperty(e, sVArray, n));
                }
                return jmolList2;
            }
        }
        return object;
    }

    private static String getPropertyName(int n) {
        return n < 0 ? "" : propertyTypes[n * 3];
    }

    private static String getParamType(int n) {
        return n < 0 ? "" : propertyTypes[n * 3 + 1];
    }

    private static boolean isReadableAsString(String string) {
        int n = readableTypes.length;
        while (--n >= 0) {
            if (!string.equalsIgnoreCase(readableTypes[n])) continue;
            return true;
        }
        return false;
    }

    private Object getPropertyAsObject(String string, Object object, String string2) {
        if (string.equals("tokenList")) {
            return T.getTokensLike((String)object);
        }
        int n = this.getPropertyNumber(string);
        boolean bl = object != null && object.toString().length() > 0;
        Object object2 = bl ? object : this.getDefaultPropertyParam(n);
        switch (n) {
            case 0: {
                return this.viewer.getAppletInfo();
            }
            case 5: {
                return this.viewer.getAnimationInfo();
            }
            case 13: {
                return this.viewer.getAtomBitSetVector(object2);
            }
            case 14: {
                return this.viewer.getAllAtomInfo(object2);
            }
            case 24: {
                return this.viewer.getAuxiliaryInfo(object2);
            }
            case 15: {
                return this.viewer.getAllBondInfo(object2);
            }
            case 25: {
                return this.viewer.getBoundBoxInfo();
            }
            case 10: {
                return this.viewer.getRotationCenter();
            }
            case 16: {
                return this.viewer.getAllChainInfo(object2);
            }
            case 37: {
                return this.viewer.getProperty("DATA_API", "consoleText", null);
            }
            case 38: {
                return this.viewer.getJspecViewProperties(object2);
            }
            case 26: {
                return this.viewer.getData(object2.toString());
            }
            case 33: {
                return this.viewer.getErrorMessageUn();
            }
            case 28: {
                return this.viewer.evaluateExpression(object2.toString());
            }
            case 20: {
                return this.viewer.getModelExtract(object2, true, false, "MOL");
            }
            case 32: {
                return PropertyManager.getFileInfo(this.viewer.getFileData(), object2.toString());
            }
            case 1: {
                return this.viewer.getFullPathName();
            }
            case 2: {
                return this.viewer.getFileHeader();
            }
            case 3: 
            case 4: {
                if (bl) {
                    return this.viewer.getFileAsString(object2.toString());
                }
                return this.viewer.getCurrentFileAsString();
            }
            case 27: {
                String string3 = object2.toString();
                int n2 = -1;
                int n3 = -1;
                int n4 = string3.indexOf("height=");
                if (n4 >= 0) {
                    n2 = Parser.parseInt(string3.substring(n4 + 7));
                }
                if ((n4 = string3.indexOf("width=")) >= 0) {
                    n3 = Parser.parseInt(string3.substring(n4 + 6));
                }
                if (n3 < 0 && n2 < 0) {
                    n3 = -1;
                    n2 = -1;
                } else if (n3 < 0) {
                    n3 = n2;
                } else {
                    n2 = n3;
                }
                return this.viewer.getImageAs(string2 == null ? "JPEG" : "JPG64", -1, n3, n2, null, null);
            }
            case 35: {
                return this.viewer.getShapeProperty(24, "getInfo");
            }
            case 36: {
                return this.viewer.getShapeProperty(24, "getData");
            }
            case 21: {
                return this.viewer.getStatusChanged(object2.toString());
            }
            case 22: {
                return this.viewer;
            }
            case 7: {
                return this.viewer.getLigandInfo(object2);
            }
            case 9: {
                return this.viewer.getMeasurementInfo();
            }
            case 29: {
                return this.viewer.getMenu(object2.toString());
            }
            case 23: {
                return this.viewer.getMessageQueue();
            }
            case 30: {
                return this.viewer.getMinimizationInfo();
            }
            case 6: {
                return this.viewer.getModelInfo(object2);
            }
            case 18: {
                return this.viewer.getMoleculeInfo(object2);
            }
            case 34: {
                return this.viewer.getMouseInfo();
            }
            case 11: {
                return this.viewer.getOrientationInfo();
            }
            case 31: {
                return this.viewer.getPointGroupInfo(object2);
            }
            case 17: {
                return this.viewer.getAllPolymerInfo(object2);
            }
            case 8: {
                return this.viewer.getShapeInfo();
            }
            case 19: {
                return this.viewer.getStateInfo3(object2.toString(), 0, 0);
            }
            case 12: {
                return this.viewer.getMatrixRotate();
            }
        }
        Object[] objectArray = new String[39];
        for (int i = 0; i < 39; ++i) {
            String string4 = PropertyManager.getParamType(i);
            String string5 = this.getDefaultPropertyParam(i);
            String string6 = PropertyManager.getPropertyName(i);
            objectArray[i] = string6.charAt(0) == 'X' ? "" : string6 + (string4 != "" ? " " + PropertyManager.getParamType(i) + (string5 != "" ? " #default: " + this.getDefaultPropertyParam(i) : "") : "");
        }
        Arrays.sort(objectArray);
        SB sB = new SB();
        sB.append("getProperty ERROR\n").append(string).append("?\nOptions include:\n");
        for (int i = 0; i < 39; ++i) {
            if (((String)objectArray[i]).length() <= 0) continue;
            sB.append("\n getProperty ").append((String)objectArray[i]);
        }
        return sB.toString();
    }

    static Object getFileInfo(Object object, String string) {
        boolean bl;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (object == null) {
            return hashtable;
        }
        boolean bl2 = bl = string != null && string.length() > 0;
        if (object instanceof Map) {
            return bl ? ((Map)object).get(string) : object;
        }
        String[] stringArray = TextFormat.split((String)object, '\n');
        if (stringArray.length == 0 || stringArray[0].length() < 6 || stringArray[0].charAt(6) != ' ' || !stringArray[0].substring(0, 6).equals(stringArray[0].substring(0, 6).toUpperCase())) {
            hashtable.put("fileHeader", (String)object);
            return hashtable;
        }
        String string2 = "";
        SB sB = new SB();
        if (bl) {
            string = string.toUpperCase();
        }
        String string3 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (string4.length() < 12) continue;
            string3 = string4.substring(0, 6).trim();
            String string5 = string4.substring(7, 10).trim();
            if (string3.equals("REMARK")) {
                string3 = string3 + string5;
            }
            if (!string3.equals(string2)) {
                if (bl && string2.equals(string)) {
                    return sB.toString();
                }
                if (!bl) {
                    hashtable.put(string2, sB.toString());
                    sB = new SB();
                }
                string2 = string3;
            }
            if (bl && !string3.equals(string)) continue;
            sB.append(string4.substring(10).trim()).appendC('\n');
        }
        if (!bl) {
            hashtable.put(string2, sB.toString());
        }
        if (bl) {
            return string3.equals(string) ? sB.toString() : "";
        }
        return hashtable;
    }

    @Override
    public JmolList<Map<String, Object>> getMoleculeInfo(ModelSet modelSet, Object object) {
        BS bS = this.viewer.getAtomBitSet(object);
        JmolMolecule[] jmolMoleculeArray = this.viewer.modelSet.getMolecules();
        JmolList<Map<String, Object>> jmolList = new JmolList<Map<String, Object>>();
        BS bS2 = new BS();
        for (int i = 0; i < jmolMoleculeArray.length; ++i) {
            bS2 = BSUtil.copy(bS);
            JmolMolecule jmolMolecule = jmolMoleculeArray[i];
            bS2.and(jmolMolecule.atomList);
            if (bS2.length() <= 0) continue;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("mf", jmolMolecule.getMolecularFormula(false));
            hashtable.put("number", jmolMolecule.moleculeIndex + 1);
            hashtable.put("modelNumber", modelSet.getModelNumberDotted(jmolMolecule.modelIndex));
            hashtable.put("numberInModel", jmolMolecule.indexInModel + 1);
            hashtable.put("nAtoms", jmolMolecule.atomCount);
            hashtable.put("nElements", jmolMolecule.nElements);
            jmolList.addLast((Map<String, Object>)hashtable);
        }
        return jmolList;
    }

    @Override
    public Map<String, Object> getModelInfo(Object object) {
        BS bS = this.viewer.getModelBitSet(this.viewer.getAtomBitSet(object), false);
        ModelSet modelSet = this.viewer.getModelSet();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("modelSetName", modelSet.modelSetName);
        hashtable.put("modelCount", modelSet.modelCount);
        hashtable.put("isTainted", modelSet.tainted != null);
        hashtable.put("canSkipLoad", modelSet.canSkipLoad);
        hashtable.put("modelSetHasVibrationVectors", modelSet.modelSetHasVibrationVectors());
        if (modelSet.modelSetProperties != null) {
            hashtable.put("modelSetProperties", modelSet.modelSetProperties);
        }
        hashtable.put("modelCountSelected", BSUtil.cardinalityOf(bS));
        hashtable.put("modelsSelected", bS);
        JmolList jmolList = new JmolList();
        modelSet.getMolecules();
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            Float f;
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            hashtable2.put("_ipt", n);
            hashtable2.put("num", modelSet.getModelNumber(n));
            hashtable2.put("file_model", modelSet.getModelNumberDotted(n));
            hashtable2.put("name", modelSet.getModelName(n));
            String string = modelSet.getModelTitle(n);
            if (string != null) {
                hashtable2.put("title", string);
            }
            if ((string = modelSet.getModelFileName(n)) != null) {
                hashtable2.put("file", string);
            }
            if ((string = (String)modelSet.getModelAuxiliaryInfoValue(n, "modelID")) != null) {
                hashtable2.put("id", string);
            }
            hashtable2.put("vibrationVectors", modelSet.modelHasVibrationVectors(n));
            Model model = modelSet.models[n];
            hashtable2.put("atomCount", model.atomCount);
            hashtable2.put("bondCount", model.getBondCount());
            hashtable2.put("groupCount", model.getGroupCount());
            hashtable2.put("moleculeCount", model.moleculeCount);
            hashtable2.put("polymerCount", model.getBioPolymerCount());
            hashtable2.put("chainCount", modelSet.getChainCountInModel(n, true));
            if (model.properties != null) {
                hashtable2.put("modelProperties", model.properties);
            }
            if ((f = (Float)modelSet.getModelAuxiliaryInfoValue(n, "Energy")) != null) {
                hashtable2.put("energy", f);
            }
            hashtable2.put("atomCount", model.atomCount);
            jmolList.addLast(hashtable2);
            n = bS.nextSetBit(n + 1);
        }
        hashtable.put("models", jmolList);
        return hashtable;
    }

    @Override
    public Map<String, Object> getLigandInfo(Object object) {
        BS bS = this.viewer.getAtomBitSet(object);
        BS bS2 = this.viewer.getAtomBitSet("solvent");
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        JmolList jmolList = new JmolList();
        hashtable.put("ligands", jmolList);
        ModelSet modelSet = this.viewer.modelSet;
        BS bS3 = BSUtil.copyInvert(bS, modelSet.atomCount);
        bS3.or(bS2);
        JmolNode[] jmolNodeArray = modelSet.atoms;
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            if (jmolNodeArray[n].isProtein() || jmolNodeArray[n].isNucleic()) {
                bS3.set(n);
            }
            n = bS.nextSetBit(n + 1);
        }
        BS[] bSArray = new BS[modelSet.modelCount];
        int n2 = modelSet.modelCount;
        while (--n2 >= 0) {
            bSArray[n2] = this.viewer.getModelUndeletedAtomsBitSet(n2);
            bSArray[n2].andNot(bS3);
        }
        JmolMolecule[] jmolMoleculeArray = JmolMolecule.getMolecules(jmolNodeArray, bSArray, null, bS3);
        for (int i = 0; i < jmolMoleculeArray.length; ++i) {
            BS bS4 = jmolMoleculeArray[i].atomList;
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            jmolList.addLast(hashtable2);
            hashtable2.put("atoms", Escape.eBS(bS4));
            String string = "";
            String string2 = "";
            Group group = null;
            char c = '\u0000';
            String string3 = "";
            String string4 = "";
            int n3 = Integer.MAX_VALUE;
            int n4 = Integer.MAX_VALUE;
            int n5 = bS4.nextSetBit(0);
            while (n5 >= 0) {
                JmolNode jmolNode = jmolNodeArray[n5];
                if (group != ((Atom)jmolNode).group) {
                    group = ((Atom)jmolNode).group;
                    int n6 = ((Atom)jmolNode).getResno();
                    char c2 = ((Atom)jmolNode).getChainID();
                    if (n3 != n6 - 1) {
                        if (string3.length() != 0 && n3 != n4) {
                            string3 = string3 + "-" + n3;
                        }
                        c2 = '\u0001';
                        n4 = n6;
                    }
                    string4 = "/" + modelSet.getModelNumberDotted(((Atom)jmolNode).modelIndex);
                    if (c != '\u0000' && c2 != c) {
                        string3 = string3 + ":" + c + string4;
                    }
                    if (c2 == '\u0001') {
                        string3 = string3 + " " + n6;
                    }
                    n3 = n6;
                    c = ((Atom)jmolNode).getChainID();
                    string = string + string2 + ((Atom)jmolNode).getGroup3(false);
                    string2 = "-";
                }
                n5 = bS4.nextSetBit(n5 + 1);
            }
            string3 = string3 + (n4 == n3 ? "" : "-" + n3) + (c == '\u0000' ? "" : ":" + c) + string4;
            hashtable2.put("groupNames", string);
            hashtable2.put("residueList", string3.substring(1));
        }
        return hashtable;
    }

    @Override
    public Object getSymmetryInfo(BS bS, String string, int n, P3 p3, P3 p32, String string2, int n2) {
        int n3;
        int n4 = -1;
        if (bS == null) {
            n4 = this.viewer.getCurrentModelIndex();
            if (n4 < 0) {
                return "";
            }
            bS = this.viewer.getModelUndeletedAtomsBitSet(n4);
        }
        if ((n3 = bS.nextSetBit(0)) < 0) {
            return "";
        }
        n4 = this.viewer.modelSet.atoms[n3].modelIndex;
        SymmetryInterface symmetryInterface = this.viewer.modelSet.getUnitCell(n4);
        if (symmetryInterface == null) {
            return "";
        }
        return symmetryInterface.getSymmetryInfo(this.viewer.modelSet, n4, n3, symmetryInterface, string, n, p3, p32, string2, n2);
    }

    @Override
    public String getModelExtract(BS bS, boolean bl, boolean bl2, String string) {
        Quaternion quaternion;
        int n;
        int n2;
        Cloneable cloneable;
        Object object;
        boolean bl3 = string.equalsIgnoreCase("V3000");
        boolean bl4 = string.equalsIgnoreCase("SDF");
        boolean bl5 = string.equalsIgnoreCase("XYZVIB");
        boolean bl6 = string.equalsIgnoreCase("CD");
        SB sB = new SB();
        ModelSet modelSet = this.viewer.modelSet;
        if (!bl5 && !bl6) {
            sB.append(bl2 ? "Jmol Model Kit" : this.viewer.getFullPathName().replace('\\', '/'));
            object = Viewer.getJmolVersion();
            sB.append("\n__Jmol-").append(((String)object).substring(0, 2));
            cloneable = Calendar.getInstance();
            int n3 = ((Calendar)cloneable).get(2);
            n2 = ((Calendar)cloneable).get(5);
            n = ((Calendar)cloneable).get(1);
            int n4 = ((Calendar)cloneable).get(11);
            int n5 = ((Calendar)cloneable).get(12);
            TextFormat.rFill(sB, "_00", "" + (1 + n3));
            TextFormat.rFill(sB, "00", "" + n2);
            sB.append(("" + n).substring(2, 4));
            TextFormat.rFill(sB, "00", "" + n4);
            TextFormat.rFill(sB, "00", "" + n5);
            sB.append("3D 1   1.00000     0.00000     0");
            sB.append("\nJmol version ").append(Viewer.getJmolVersion()).append(" EXTRACT: ").append(Escape.eBS(bS)).append("\n");
        }
        object = BSUtil.copy(bS);
        Atom[] atomArray = modelSet.atoms;
        n2 = bS.nextSetBit(0);
        while (n2 >= 0) {
            if (bl && atomArray[n2].isDeleted()) {
                ((BS)object).clear(n2);
            }
            n2 = bS.nextSetBit(n2 + 1);
        }
        BS bS2 = PropertyManager.getCovalentBondsForAtoms(modelSet.bonds, modelSet.bondCount, (BS)object);
        if (!bl5 && ((BS)object).cardinality() == 0) {
            return "";
        }
        n = 1;
        Quaternion quaternion2 = quaternion = bl ? this.viewer.getRotationQuaternion() : null;
        if (bl4) {
            String string2 = sB.toString();
            sB = new SB();
            cloneable = this.viewer.getModelBitSet((BS)object, true);
            int n6 = ((BS)cloneable).nextSetBit(0);
            while (n6 >= 0) {
                sB.append(string2);
                BS bS3 = BSUtil.copy((BS)object);
                bS3.and(modelSet.getModelAtomBitSetIncludingDeleted(n6, false));
                bS2 = PropertyManager.getCovalentBondsForAtoms(modelSet.bonds, modelSet.bondCount, bS3);
                boolean bl7 = this.addMolFile(sB, bS3, bS2, false, false, quaternion);
                n = bl7 ? 1 : 0;
                if (bl7) {
                    sB.append("$$$$\n");
                    n6 = ((BS)cloneable).nextSetBit(n6 + 1);
                    continue;
                }
                break;
            }
        } else if (bl5) {
            LabelToken[] labelTokenArray = LabelToken.compile(this.viewer, "%-2e %10.5x %10.5y %10.5z %10.5vx %10.5vy %10.5vz\n", '\u0000', null);
            cloneable = LabelToken.compile(this.viewer, "%-2e %10.5x %10.5y %10.5z\n", '\u0000', null);
            BS bS4 = this.viewer.getModelBitSet((BS)object, true);
            int n7 = bS4.nextSetBit(0);
            while (n7 >= 0) {
                BS bS5 = BSUtil.copy((BS)object);
                bS5.and(modelSet.getModelAtomBitSetIncludingDeleted(n7, false));
                if (bS5.cardinality() != 0) {
                    sB.appendI(bS5.cardinality()).appendC('\n');
                    Properties properties = modelSet.models[n7].properties;
                    sB.append("Model[" + (n7 + 1) + "]: ");
                    if (modelSet.frameTitles[n7] != null && modelSet.frameTitles[n7].length() > 0) {
                        sB.append(modelSet.frameTitles[n7].replace('\n', ' '));
                    } else if (properties == null) {
                        sB.append("Jmol " + Viewer.getJmolVersion());
                    } else {
                        SB sB2 = new SB();
                        Enumeration<?> enumeration = properties.propertyNames();
                        String string3 = null;
                        while (enumeration.hasMoreElements()) {
                            String string4 = (String)enumeration.nextElement();
                            if (string4.equals(".PATH")) {
                                string3 = properties.getProperty(string4);
                                continue;
                            }
                            sB2.append(";").append(string4).append("=").append(properties.getProperty(string4));
                        }
                        if (string3 != null) {
                            sB2.append(";PATH=").append(string3);
                        }
                        string3 = sB2.substring(sB2.length() > 0 ? 1 : 0);
                        sB.append(string3.replace('\n', ' '));
                    }
                    sB.appendC('\n');
                    int n8 = bS5.nextSetBit(0);
                    while (n8 >= 0) {
                        sB.append(LabelToken.formatLabelAtomArray(this.viewer, atomArray[n8], (LabelToken[])(modelSet.getVibrationVector(n8, false) == null ? cloneable : labelTokenArray), '\u0000', null));
                        n8 = bS5.nextSetBit(n8 + 1);
                    }
                }
                n7 = bS4.nextSetBit(n7 + 1);
            }
        } else {
            n = this.addMolFile(sB, (BS)object, bS2, bl3, bl6, quaternion) ? 1 : 0;
        }
        return n != 0 ? sB.toString() : "ERROR: Too many atoms or bonds -- use V3000 format.";
    }

    private boolean addMolFile(SB sB, BS bS, BS bS2, boolean bl, boolean bl2, Quaternion quaternion) {
        float[] fArray;
        int n = bS.cardinality();
        int n2 = bS2.cardinality();
        if (!(bl || bl2 || n <= 999 && n2 <= 999)) {
            return false;
        }
        ModelSet modelSet = this.viewer.modelSet;
        int[] nArray = new int[modelSet.atomCount];
        P3 p3 = new P3();
        if (bl) {
            sB.append("  0  0  0  0  0  0            999 V3000");
        } else if (bl2) {
            sB.append("{\"mol\":{\"scaling\":[20,-20,20],\"a\":[");
        } else {
            TextFormat.rFill(sB, "   ", "" + n);
            TextFormat.rFill(sB, "   ", "" + n2);
            sB.append("  0  0  0  0              1 V2000");
        }
        if (!bl2) {
            sB.append("\n");
        }
        if (bl) {
            sB.append("M  V30 BEGIN CTAB\nM  V30 COUNTS ").appendI(n).append(" ").appendI(n2).append(" 0 0 0\n").append("M  V30 BEGIN ATOM\n");
        }
        P3 p32 = new P3();
        int n3 = bS.nextSetBit(0);
        int n4 = 0;
        while (n3 >= 0) {
            nArray[n3] = ++n4;
            this.getAtomRecordMOL(modelSet, sB, nArray[n3], modelSet.atoms[n3], quaternion, p3, p32, bl, bl2);
            n3 = bS.nextSetBit(n3 + 1);
        }
        if (bl) {
            sB.append("M  V30 END ATOM\nM  V30 BEGIN BOND\n");
        } else if (bl2) {
            sB.append("],\"b\":[");
        }
        n3 = bS2.nextSetBit(0);
        n4 = 0;
        while (n3 >= 0) {
            this.getBondRecordMOL(sB, ++n4, modelSet.bonds[n3], nArray, bl, bl2);
            n3 = bS2.nextSetBit(n3 + 1);
        }
        if (bl) {
            sB.append("M  V30 END BOND\nM  V30 END CTAB\n");
        }
        if (bl2) {
            sB.append("]}}");
        } else {
            sB.append("M  END\n");
        }
        if (!bl2 && !bl && (fArray = modelSet.getPartialCharges()) != null) {
            sB.append("> <JMOL_PARTIAL_CHARGES>\n").appendI(n).appendC('\n');
            n4 = bS.nextSetBit(0);
            int n5 = 0;
            while (n4 >= 0) {
                sB.appendI(++n5).append(" ").appendF(fArray[n4]).appendC('\n');
                n4 = bS.nextSetBit(n4 + 1);
            }
        }
        return true;
    }

    private static BS getCovalentBondsForAtoms(Bond[] bondArray, int n, BS bS) {
        BS bS2 = new BS();
        for (int i = 0; i < n; ++i) {
            Bond bond = bondArray[i];
            if (!bS.get(bond.atom1.index) || !bS.get(bond.atom2.index) || !bond.isCovalent()) continue;
            bS2.set(i);
        }
        return bS2;
    }

    private void getAtomRecordMOL(ModelSet modelSet, SB sB, int n, Atom atom, Quaternion quaternion, P3 p3, P3 p32, boolean bl, boolean bl2) {
        if (modelSet.models[atom.modelIndex].isTrajectory) {
            atom.setFractionalCoordPt(p32, ((P3[])modelSet.trajectorySteps.get(atom.modelIndex))[atom.index - modelSet.models[atom.modelIndex].firstAtomIndex], true);
        } else {
            p3.setT(atom);
        }
        if (quaternion != null) {
            quaternion.transformP2(p3, p3);
        }
        short s = atom.getElementNumber();
        String string = atom.isDeleted() ? "Xx" : Elements.elementSymbolFromNumber(s);
        int n2 = atom.getIsotopeNumber();
        int n3 = atom.getFormalCharge();
        if (bl) {
            sB.append("M  V30 ").appendI(n).append(" ").append(string).append(" ").appendF(p3.x).append(" ").appendF(p3.y).append(" ").appendF(p3.z).append(" 0");
            if (n3 != 0) {
                sB.append(" CHG=").appendI(n3);
            }
            if (n2 != 0) {
                sB.append(" MASS=").appendI(n2);
            }
            sB.append("\n");
        } else if (bl2) {
            if (n != 1) {
                sB.append(",");
            }
            sB.append("{");
            if (atom.getElementNumber() != 6) {
                sB.append("\"l\":\"").append(atom.getElementSymbol()).append("\",");
            }
            if (n3 != 0) {
                sB.append("\"c\":").appendI(n3).append(",");
            }
            if (n2 != 0 && n2 != Elements.getNaturalIsotope(s)) {
                sB.append("\"m\":").appendI(n2).append(",");
            }
            sB.append("\"x\":").appendF(atom.x * 20.0f).append(",\"y\":").appendF(-atom.y * 20.0f).append(",\"z\":").appendF(atom.z * 20.0f).append("}");
        } else {
            sB.append(TextFormat.sprintf("%10.5p%10.5p%10.5p", "p", new Object[]{p3}));
            sB.append(" ").append(string);
            if (string.length() == 1) {
                sB.append(" ");
            }
            if (n2 > 0) {
                n2 -= Elements.getNaturalIsotope(atom.getElementNumber());
            }
            sB.append(" ");
            TextFormat.rFill(sB, "  ", "" + n2);
            TextFormat.rFill(sB, "   ", "" + (n3 == 0 ? 0 : 4 - n3));
            sB.append("  0  0  0  0\n");
        }
    }

    private void getBondRecordMOL(SB sB, int n, Bond bond, int[] nArray, boolean bl, boolean bl2) {
        int n2 = nArray[bond.atom1.index];
        int n3 = nArray[bond.atom2.index];
        int n4 = bond.getValence();
        if (n4 > 3) {
            n4 = 1;
        }
        switch (bond.order & 0xFFFDFFFF) {
            case 515: {
                n4 = bl2 ? 2 : 4;
                break;
            }
            case 66: {
                n4 = bl2 ? 1 : 5;
                break;
            }
            case 513: {
                n4 = bl2 ? 1 : 6;
                break;
            }
            case 514: {
                n4 = bl2 ? 2 : 7;
                break;
            }
            case 33: {
                int n5 = n4 = bl2 ? 1 : 8;
            }
        }
        if (bl) {
            sB.append("M  V30 ").appendI(n).append(" ").appendI(n4).append(" ").appendI(n2).append(" ").appendI(n3).appendC('\n');
        } else if (bl2) {
            if (n != 1) {
                sB.append(",");
            }
            sB.append("{\"b\":").appendI(n2 - 1).append(",\"e\":").appendI(n3 - 1);
            if (n4 != 1) {
                sB.append(",\"o\":").appendI(n4);
            }
            sB.append("}");
        } else {
            TextFormat.rFill(sB, "   ", "" + n2);
            TextFormat.rFill(sB, "   ", "" + n3);
            sB.append("  ").appendI(n4).append("  0  0  0\n");
        }
    }

    @Override
    public String getChimeInfo(int n, BS bS) {
        switch (n) {
            case 1073741982: {
                break;
            }
            case 1073741864: {
                return this.getBasePairInfo(bS);
            }
            default: {
                return this.getChimeInfoA(this.viewer.modelSet.atoms, n, bS);
            }
        }
        SB sB = new SB();
        this.viewer.modelSet.models[0].getChimeInfo(sB, 0);
        return sB.appendC('\n').toString().substring(1);
    }

    private String getChimeInfoA(Atom[] atomArray, int n, BS bS) {
        SB sB;
        block15: {
            sB = new SB();
            sB.append("\n");
            String string = "";
            Chain chain = null;
            Group group = null;
            int n2 = -1;
            int n3 = 0;
            if (bS == null) break block15;
            int n4 = bS.nextSetBit(0);
            while (n4 >= 0) {
                block16: {
                    char c = atomArray[n4].getChainID();
                    string = c == '\u0000' ? " " : "" + c;
                    switch (n) {
                        case 0x40D00004: {
                            break;
                        }
                        case 1114638350: {
                            string = atomArray[n4].getInfo();
                            break;
                        }
                        case 0x44100001: {
                            string = "" + atomArray[n4].getAtomNumber();
                            break;
                        }
                        case 1087373318: {
                            string = atomArray[n4].getGroup3(false);
                            break;
                        }
                        case 1073742120: {
                            string = "[" + atomArray[n4].getGroup3(false) + "]" + atomArray[n4].getSeqcodeString() + ":" + string;
                            break;
                        }
                        case 1087373320: {
                            Group group2;
                            if (atomArray[n4].getModelIndex() != n2) {
                                sB.appendC('\n');
                                n3 = 0;
                                n2 = atomArray[n4].getModelIndex();
                                sB.append("Model " + atomArray[n4].getModelNumber());
                                group = null;
                                chain = null;
                            }
                            if (atomArray[n4].getChain() != chain) {
                                sB.appendC('\n');
                                n3 = 0;
                                chain = atomArray[n4].getChain();
                                sB.append("Chain " + string + ":\n");
                                group = null;
                            }
                            if ((group2 = atomArray[n4].getGroup()) != group) {
                                if (n3++ % 5 == 0 && n3 > 1) {
                                    sB.appendC('\n');
                                }
                                TextFormat.lFill(sB, "          ", "[" + atomArray[n4].getGroup3(false) + "]" + atomArray[n4].getResno() + " ");
                                group = group2;
                            }
                            break block16;
                        }
                        default: {
                            return "";
                        }
                    }
                    if (sB.indexOf("\n" + string + "\n") < 0) {
                        sB.append(string).appendC('\n');
                    }
                }
                n4 = bS.nextSetBit(n4 + 1);
            }
        }
        if (n == 1087373320) {
            sB.appendC('\n');
        }
        return sB.toString().substring(1);
    }

    @Override
    public String getModelFileInfo(BS bS) {
        ModelSet modelSet = this.viewer.modelSet;
        SB sB = new SB();
        for (int i = 0; i < modelSet.modelCount; ++i) {
            if (bS != null && !bS.get(i)) continue;
            String string = "[\"" + modelSet.getModelNumberDotted(i) + "\"] = ";
            sB.append("\n\nfile").append(string).append(Escape.eS(modelSet.getModelFileName(i)));
            String string2 = (String)modelSet.getModelAuxiliaryInfoValue(i, "modelID");
            if (string2 != null) {
                sB.append("\nid").append(string).append(Escape.eS(string2));
            }
            sB.append("\ntitle").append(string).append(Escape.eS(modelSet.getModelTitle(i)));
            sB.append("\nname").append(string).append(Escape.eS(modelSet.getModelName(i)));
        }
        return sB.toString();
    }

    @Override
    public JmolList<Map<String, Object>> getAllAtomInfo(BS bS) {
        JmolList<Map<String, Object>> jmolList = new JmolList<Map<String, Object>>();
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            jmolList.addLast(this.getAtomInfoLong(n));
            n = bS.nextSetBit(n + 1);
        }
        return jmolList;
    }

    @Override
    public void getAtomIdentityInfo(int n, Map<String, Object> map) {
        ModelSet modelSet = this.viewer.modelSet;
        map.put("_ipt", n);
        map.put("atomIndex", n);
        map.put("atomno", modelSet.getAtomNumber(n));
        map.put("info", modelSet.getAtomInfo(n, null));
        map.put("sym", modelSet.getElementSymbol(n));
    }

    private Map<String, Object> getAtomInfoLong(int n) {
        ModelSet modelSet = this.viewer.modelSet;
        Atom atom = modelSet.atoms[n];
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        this.getAtomIdentityInfo(n, hashtable);
        hashtable.put("element", modelSet.getElementName(n));
        hashtable.put("elemno", modelSet.getElementNumber(n));
        hashtable.put("x", Float.valueOf(atom.x));
        hashtable.put("y", Float.valueOf(atom.y));
        hashtable.put("z", Float.valueOf(atom.z));
        hashtable.put("coord", P3.newP(atom));
        if (modelSet.vibrationVectors != null && modelSet.vibrationVectors[n] != null) {
            hashtable.put("vibVector", V3.newV(modelSet.vibrationVectors[n]));
        }
        hashtable.put("bondCount", atom.getCovalentBondCount());
        hashtable.put("radius", Float.valueOf((float)((double)atom.getRasMolRadius() / 120.0)));
        hashtable.put("model", atom.getModelNumberForLabel());
        hashtable.put("shape", Atom.atomPropertyString(this.viewer, atom, 1087373323));
        hashtable.put("visible", atom.isVisible(0));
        hashtable.put("clickabilityFlags", atom.clickabilityFlags);
        hashtable.put("visibilityFlags", atom.shapeVisibilityFlags);
        hashtable.put("spacefill", Float.valueOf(atom.getRadius()));
        String string = Escape.escapeColor(this.viewer.getColorArgbOrGray(atom.colixAtom));
        if (string != null) {
            hashtable.put("color", string);
        }
        hashtable.put("colix", atom.colixAtom);
        boolean bl = atom.isTranslucent();
        if (bl) {
            hashtable.put("translucent", bl);
        }
        hashtable.put("formalCharge", atom.getFormalCharge());
        hashtable.put("partialCharge", Float.valueOf(atom.getPartialCharge()));
        float f = (float)atom.getSurfaceDistance100() / 100.0f;
        if (f >= 0.0f) {
            hashtable.put("surfaceDistance", Float.valueOf(f));
        }
        if (modelSet.models[atom.modelIndex].isBioModel) {
            hashtable.put("resname", atom.getGroup3(false));
            int n2 = atom.getSeqNumber();
            char c = atom.getInsertionCode();
            if (n2 > 0) {
                hashtable.put("resno", n2);
            }
            if (c != '\u0000') {
                hashtable.put("insertionCode", "" + c);
            }
            char c2 = atom.getChainID();
            hashtable.put("name", modelSet.getAtomName(n));
            hashtable.put("chain", c2 == '\u0000' ? "" : "" + c2);
            hashtable.put("atomID", atom.atomID);
            hashtable.put("groupID", atom.getGroupID());
            if (atom.alternateLocationID != '\u0000') {
                hashtable.put("altLocation", "" + atom.alternateLocationID);
            }
            hashtable.put("structure", atom.getProteinStructureType().getId());
            hashtable.put("polymerLength", atom.getPolymerLength());
            hashtable.put("occupancy", atom.getOccupancy100());
            int n3 = atom.getBfactor100();
            hashtable.put("temp", n3 / 100);
        }
        return hashtable;
    }

    @Override
    public JmolList<Map<String, Object>> getAllBondInfo(BS bS) {
        JmolList<Map<String, Object>> jmolList = new JmolList<Map<String, Object>>();
        ModelSet modelSet = this.viewer.modelSet;
        int n = modelSet.bondCount;
        if (bS instanceof Bond.BondSet) {
            int n2 = bS.nextSetBit(0);
            while (n2 >= 0 && n2 < n) {
                jmolList.addLast(this.getBondInfo(n2));
                n2 = bS.nextSetBit(n2 + 1);
            }
            return jmolList;
        }
        int n3 = bS.cardinality() == 1 ? bS.nextSetBit(0) : -1;
        Bond[] bondArray = modelSet.bonds;
        for (int i = 0; i < n; ++i) {
            if (!(n3 >= 0 ? bondArray[i].atom1.index == n3 || bondArray[i].atom2.index == n3 : bS.get(bondArray[i].atom1.index) && bS.get(bondArray[i].atom2.index))) continue;
            jmolList.addLast(this.getBondInfo(i));
        }
        return jmolList;
    }

    private Map<String, Object> getBondInfo(int n) {
        Bond bond = this.viewer.modelSet.bonds[n];
        Atom atom = bond.atom1;
        Atom atom2 = bond.atom2;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("_bpt", n);
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        this.getAtomIdentityInfo(atom.index, hashtable2);
        Hashtable<String, Object> hashtable3 = new Hashtable<String, Object>();
        this.getAtomIdentityInfo(atom2.index, hashtable3);
        hashtable.put("atom1", hashtable2);
        hashtable.put("atom2", hashtable3);
        hashtable.put("order", Float.valueOf(Parser.fVal(JmolEdge.getBondOrderNumberFromOrder(bond.order))));
        hashtable.put("radius", Float.valueOf((float)((double)bond.mad / 2000.0)));
        hashtable.put("length_Ang", Float.valueOf(atom.distance(atom2)));
        hashtable.put("visible", bond.shapeVisibilityFlags != 0);
        String string = Escape.escapeColor(this.viewer.getColorArgbOrGray(bond.colix));
        if (string != null) {
            hashtable.put("color", string);
        }
        hashtable.put("colix", Integer.valueOf(bond.colix));
        boolean bl = bond.isTranslucent();
        if (bl) {
            hashtable.put("translucent", bl);
        }
        return hashtable;
    }

    @Override
    public Map<String, JmolList<Map<String, Object>>> getAllChainInfo(BS bS) {
        Hashtable<String, JmolList<Map<String, Object>>> hashtable = new Hashtable<String, JmolList<Map<String, Object>>>();
        JmolList jmolList = new JmolList();
        int n = this.viewer.modelSet.modelCount;
        for (int i = 0; i < n; ++i) {
            Hashtable<String, Serializable> hashtable2 = new Hashtable<String, Serializable>();
            JmolList<Map<String, JmolList<Map<String, Object>>>> jmolList2 = this.getChainInfo(i, bS);
            if (jmolList2.size() <= 0) continue;
            hashtable2.put("modelIndex", Integer.valueOf(i));
            hashtable2.put("chains", jmolList2);
            jmolList.addLast(hashtable2);
        }
        hashtable.put("models", jmolList);
        return hashtable;
    }

    private JmolList<Map<String, JmolList<Map<String, Object>>>> getChainInfo(int n, BS bS) {
        Model model = this.viewer.modelSet.models[n];
        int n2 = model.getChainCount(true);
        JmolList<Map<String, JmolList<Map<String, Object>>>> jmolList = new JmolList<Map<String, JmolList<Map<String, Object>>>>();
        for (int i = 0; i < n2; ++i) {
            Chain chain = model.getChainAt(i);
            JmolList<Map<String, Object>> jmolList2 = new JmolList<Map<String, Object>>();
            int n3 = chain.getGroupCount();
            Hashtable<String, JmolList<Map<String, Object>>> hashtable = new Hashtable<String, JmolList<Map<String, Object>>>();
            for (int j = 0; j < n3; ++j) {
                Group group = chain.getGroup(j);
                if (!bS.get(group.firstAtomIndex)) continue;
                jmolList2.addLast(group.getGroupInfo(j));
            }
            if (jmolList2.isEmpty()) continue;
            hashtable.put("residues", jmolList2);
            jmolList.addLast((Map<String, JmolList<Map<String, Object>>>)hashtable);
        }
        return jmolList;
    }

    public Map<String, JmolList<Map<String, Object>>> getAllPolymerInfo(BS bS) {
        Hashtable<String, JmolList<Map<String, Object>>> hashtable = new Hashtable<String, JmolList<Map<String, Object>>>();
        JmolList<Map<String, Object>> jmolList = new JmolList<Map<String, Object>>();
        int n = this.viewer.modelSet.modelCount;
        Model[] modelArray = this.viewer.modelSet.models;
        for (int i = 0; i < n; ++i) {
            if (!modelArray[i].isBioModel) continue;
            modelArray[i].getAllPolymerInfo(bS, hashtable, jmolList);
        }
        hashtable.put("models", jmolList);
        return hashtable;
    }

    private String getBasePairInfo(BS bS) {
        SB sB = new SB();
        JmolList<Bond> jmolList = new JmolList<Bond>();
        this.viewer.modelSet.calcRasmolHydrogenBonds(bS, bS, jmolList, true, 1, false, null);
        int n = jmolList.size();
        while (--n >= 0) {
            Bond bond = (Bond)jmolList.get(n);
            PropertyManager.getAtomResidueInfo(sB, bond.atom1);
            sB.append(" - ");
            PropertyManager.getAtomResidueInfo(sB, bond.atom2);
            sB.append("\n");
        }
        return sB.toString();
    }

    private static void getAtomResidueInfo(SB sB, Atom atom) {
        sB.append("[").append(atom.getGroup3(false)).append("]").append(atom.getSeqcodeString()).append(":");
        char c = atom.getChainID();
        sB.append(c == '\u0000' ? " " : "" + c);
    }
}

