/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Map;
import org.jmol.constant.EnumAnimationMode;
import org.jmol.modelset.ModelSet;
import org.jmol.thread.AnimationThread;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.JmolList;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimationManager {
    protected Viewer viewer;
    EnumAnimationMode animationReplayMode = EnumAnimationMode.ONCE;
    public boolean animationOn;
    boolean animationPaused;
    boolean inMotion;
    public int animationFps;
    int animationDirection = 1;
    int currentDirection = 1;
    public int currentModelIndex;
    private int currentFrameIndex;
    int firstFrameIndex;
    int lastFrameIndex;
    int frameStep;
    float currentMorphFrame;
    public int morphCount;
    public int firstFrameDelayMs;
    public int lastFrameDelayMs;
    private int lastFramePainted;
    private AnimationThread animationThread;
    int backgroundModelIndex = -1;
    final BS bsVisibleFrames = new BS();
    BS bsDisplay;
    float firstFrameDelay;
    private int intAnimThread;
    float lastFrameDelay = 1.0f;
    private Map<String, Object> movie;

    AnimationManager(Viewer viewer) {
        this.viewer = viewer;
    }

    void clear() {
        this.setMovie(null);
        this.initializePointers(0);
        this.setAnimationOn(false);
        this.setCurrentModelIndex(0, true);
        this.currentDirection = 1;
        this.setAnimationDirection(1);
        this.setAnimationFps(10);
        this.setAnimationReplayMode(EnumAnimationMode.ONCE, 0.0f, 0.0f);
        this.initializePointers(0);
    }

    private void setFrame(int n) {
        this.setCurrentFrame(n, true);
    }

    private void setCurrentFrame(int n, boolean bl) {
        if (this.movie == null) {
            this.setCurrentModelIndex(n, true);
            return;
        }
        if (n == -1) {
            n = (Integer)this.movie.get("currentFrame");
        }
        this.currentFrameIndex = n;
        int n2 = this.getMovieState(n);
        if (n2 < 0) {
            return;
        }
        this.setModelIndex(n2, true);
        JmolList jmolList = (JmolList)this.movie.get("states");
        if (jmolList == null || n2 < 0 || n2 >= jmolList.size()) {
            return;
        }
        BS bS = (BS)jmolList.get(n2);
        if (this.bsDisplay != null) {
            bS = BSUtil.copy(bS);
            bS.and(this.bsDisplay);
        }
        this.viewer.displayAtoms(bS, true, false, null, true);
    }

    private int getMovieState(int n) {
        JmolList jmolList = (JmolList)this.movie.get("frames");
        return jmolList == null || n >= jmolList.size() ? -1 : (Integer)jmolList.get(n);
    }

    public void morph(float f) {
        int n;
        System.out.println("morph " + f);
        int n2 = (int)f;
        if (Math.abs((float)n2 - f) < 0.001f) {
            f = n2;
        } else if (Math.abs((float)n2 - f) > 0.999f) {
            f = ++n2;
        }
        float f2 = f - (float)n2;
        --n2;
        if (f2 == 0.0f) {
            this.currentMorphFrame = n2;
            this.setFrame(n2);
            return;
        }
        if (this.movie == null) {
            this.setCurrentModelIndex(n2, true);
            n = n2 + 1;
            this.currentMorphFrame = (float)n2 + f2;
        } else {
            this.setCurrentFrame(n2, false);
            this.currentMorphFrame = (float)n2 + f2;
            n2 = this.getMovieState(n2);
            n = this.getMovieState(this.getFrameStep(this.animationDirection) + this.getCurrentFrame());
        }
        if (n == n2 || n < 0 || n2 < 0) {
            return;
        }
        this.viewer.modelSet.morphTrajectories(n2, n, f2);
    }

    void setCurrentModelIndex(int n, boolean bl) {
        if (this.movie != null) {
            this.setFrame(n);
            return;
        }
        this.currentFrameIndex = 0;
        this.setModelIndex(n, bl);
    }

    private void setModelIndex(int n, boolean bl) {
        int n2;
        if (n < 0) {
            this.stopThread(false);
        }
        int n3 = this.currentModelIndex;
        ModelSet modelSet = this.viewer.getModelSet();
        int n4 = n2 = modelSet == null ? 0 : modelSet.modelCount;
        if (n2 == 1) {
            n = 0;
            this.currentModelIndex = 0;
        } else if (n < 0 || n >= n2) {
            n = -1;
        }
        String string = null;
        boolean bl2 = false;
        if (this.currentModelIndex != n) {
            if (n2 > 0) {
                boolean bl3 = this.isJmolDataFrameForModel(n);
                boolean bl4 = this.isJmolDataFrameForModel(this.currentModelIndex);
                if (bl4) {
                    this.viewer.setJmolDataFrame(null, -1, this.currentModelIndex);
                }
                if (this.currentModelIndex != -1) {
                    this.viewer.saveModelOrientation();
                }
                if (bl4 || bl3) {
                    string = this.viewer.getJmolFrameType(n) + " " + n + " <-- " + " " + this.currentModelIndex + " " + this.viewer.getJmolFrameType(this.currentModelIndex);
                    bl2 = this.viewer.getJmolDataSourceFrame(n) == this.viewer.getJmolDataSourceFrame(this.currentModelIndex);
                }
            }
            this.currentModelIndex = n;
            if (string != null) {
                if (n >= 0) {
                    this.viewer.restoreModelOrientation(n);
                }
                if (bl2 && string.indexOf("quaternion") >= 0 && string.indexOf("plot") < 0 && string.indexOf("ramachandran") < 0 && string.indexOf(" property ") < 0) {
                    this.viewer.restoreModelRotation(n3);
                }
            }
        }
        this.setViewer(bl);
    }

    private void setViewer(boolean bl) {
        this.viewer.setTrajectory(this.currentModelIndex);
        this.viewer.setFrameOffset(this.currentModelIndex);
        if (this.currentModelIndex == -1 && bl) {
            this.setBackgroundModelIndex(-1);
        }
        this.viewer.setTainted(true);
        this.setFrameRangeVisible();
        this.viewer.setStatusFrameChanged(false);
        if (this.viewer.modelSet != null && !this.viewer.global.selectAllModels) {
            this.viewer.setSelectionSubset(this.viewer.getModelUndeletedAtomsBitSet(this.currentModelIndex));
        }
    }

    private boolean isJmolDataFrameForModel(int n) {
        return this.movie == null && this.viewer.isJmolDataFrameForModel(n);
    }

    void setBackgroundModelIndex(int n) {
        ModelSet modelSet = this.viewer.getModelSet();
        if (modelSet == null || n < 0 || n >= modelSet.modelCount) {
            n = -1;
        }
        this.backgroundModelIndex = n;
        if (n >= 0) {
            this.viewer.setTrajectory(n);
        }
        this.viewer.setTainted(true);
        this.setFrameRangeVisible();
    }

    private void setFrameRangeVisible() {
        this.bsVisibleFrames.clearAll();
        if (this.movie != null) {
            this.bsVisibleFrames.setBits(0, this.viewer.getModelCount());
            return;
        }
        if (this.backgroundModelIndex >= 0) {
            this.bsVisibleFrames.set(this.backgroundModelIndex);
        }
        if (this.currentModelIndex >= 0) {
            this.bsVisibleFrames.set(this.currentModelIndex);
            return;
        }
        if (this.frameStep == 0) {
            return;
        }
        int n = 0;
        int n2 = 0;
        for (int i = this.firstFrameIndex; i != this.lastFrameIndex; i += this.frameStep) {
            if (this.isJmolDataFrameForModel(i)) continue;
            this.bsVisibleFrames.set(i);
            ++n;
            n2 = i;
        }
        if (this.firstFrameIndex == this.lastFrameIndex || !this.isJmolDataFrameForModel(this.lastFrameIndex) || n == 0) {
            this.bsVisibleFrames.set(this.lastFrameIndex);
            if (n == 0) {
                this.firstFrameIndex = this.lastFrameIndex;
            }
            n = 0;
        }
        if (n == 1 && this.currentModelIndex < 0) {
            this.setFrame(n2);
        }
    }

    void initializePointers(int n) {
        this.firstFrameIndex = 0;
        this.lastFrameIndex = (n == 0 ? 0 : this.getFrameCount()) - 1;
        this.frameStep = n;
        this.viewer.setFrameVariables();
    }

    int getFrameCount() {
        return this.movie == null ? this.viewer.getModelCount() : ((Integer)this.movie.get("frameCount")).intValue();
    }

    void setAnimationDirection(int n) {
        this.animationDirection = n;
    }

    void setAnimationFps(int n) {
        this.animationFps = n;
    }

    void setAnimationReplayMode(EnumAnimationMode enumAnimationMode, float f, float f2) {
        this.firstFrameDelay = f > 0.0f ? f : 0.0f;
        this.firstFrameDelayMs = (int)(this.firstFrameDelay * 1000.0f);
        this.lastFrameDelay = f2 > 0.0f ? f2 : 0.0f;
        this.lastFrameDelayMs = (int)(this.lastFrameDelay * 1000.0f);
        this.animationReplayMode = enumAnimationMode;
        this.viewer.setFrameVariables();
    }

    void setAnimationRange(int n, int n2) {
        int n3 = this.getFrameCount();
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = n3;
        }
        if (n >= n3) {
            n = n3 - 1;
        }
        if (n2 >= n3) {
            n2 = n3 - 1;
        }
        this.firstFrameIndex = n;
        this.lastFrameIndex = n2;
        this.frameStep = n2 < n ? -1 : 1;
        this.rewindAnimation();
    }

    private void animation(boolean bl) {
        this.animationOn = bl;
        this.viewer.setBooleanProperty("_animating", bl);
    }

    public void setAnimationOn(boolean bl) {
        if (!bl || !this.viewer.haveModelSet() || this.viewer.isHeadless()) {
            this.stopThread(false);
            return;
        }
        if (!this.viewer.getSpinOn()) {
            this.viewer.refresh(3, "Viewer:setAnimationOn");
        }
        this.setAnimationRange(-1, -1);
        this.resumeAnimation();
    }

    public void stopThread(boolean bl) {
        if (this.animationThread != null) {
            this.animationThread.interrupt();
            this.animationThread = null;
        }
        this.animationPaused = bl;
        if (!this.viewer.getSpinOn()) {
            this.viewer.refresh(3, "Viewer:setAnimationOff");
        }
        this.animation(false);
        this.viewer.setStatusFrameChanged(false);
    }

    void pauseAnimation() {
        this.stopThread(true);
    }

    void reverseAnimation() {
        this.currentDirection = -this.currentDirection;
        if (!this.animationOn) {
            this.resumeAnimation();
        }
    }

    void repaintDone() {
        this.lastFramePainted = this.getCurrentFrame();
    }

    void resumeAnimation() {
        if (this.currentModelIndex < 0) {
            this.setAnimationRange(this.firstFrameIndex, this.lastFrameIndex);
        }
        if (this.getFrameCount() <= 1) {
            this.animation(false);
            return;
        }
        this.animation(true);
        this.animationPaused = false;
        if (this.animationThread == null) {
            ++this.intAnimThread;
            this.animationThread = new AnimationThread(this, this.viewer, this.firstFrameIndex, this.lastFrameIndex, this.intAnimThread);
            this.animationThread.start();
        }
    }

    public boolean setAnimationNext() {
        return this.setAnimationRelative(this.animationDirection);
    }

    void setAnimationLast() {
        this.setFrame(this.animationDirection > 0 ? this.lastFrameIndex : this.firstFrameIndex);
    }

    void rewindAnimation() {
        this.setFrame(this.animationDirection > 0 ? this.firstFrameIndex : this.lastFrameIndex);
        this.currentDirection = 1;
        this.viewer.setFrameVariables();
    }

    boolean setAnimationPrevious() {
        return this.setAnimationRelative(-this.animationDirection);
    }

    private boolean setAnimationRelative(int n) {
        boolean bl;
        int n2 = this.getFrameStep(n);
        int n3 = this.getCurrentFrame();
        int n4 = n3 + n2;
        float f = 0.0f;
        float f2 = 0.0f;
        if (this.morphCount > 0) {
            f = 1.0f / (float)(this.morphCount + 1);
            f2 = this.currentMorphFrame + (float)n2 * f;
            bl = this.isNotInRange(f2);
        } else {
            bl = this.isNotInRange(n4);
        }
        if (bl) {
            switch (this.animationReplayMode) {
                case ONCE: {
                    return false;
                }
                case LOOP: {
                    n4 = this.animationDirection == this.currentDirection ? this.firstFrameIndex : this.lastFrameIndex;
                    f2 = n4;
                    break;
                }
                case PALINDROME: {
                    this.currentDirection = -this.currentDirection;
                    n4 -= 2 * n2;
                    f2 -= (float)(2 * n2) * f;
                }
            }
        }
        if (this.morphCount < 1) {
            if (n4 < 0 || n4 >= this.getFrameCount()) {
                return false;
            }
            this.setFrame(n4);
            return true;
        }
        this.morph(f2 + 1.0f);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isNotInRange(float f) {
        float f2;
        float f3 = f - 0.001f;
        if (f3 > (float)this.firstFrameIndex) {
            if (f3 > (float)this.lastFrameIndex) return true;
        }
        f3 = f + 0.001f;
        if (!(f2 < (float)this.firstFrameIndex)) return false;
        if (!(f3 < (float)this.lastFrameIndex)) return false;
        return true;
    }

    private int getFrameStep(int n) {
        return this.frameStep * n * this.currentDirection;
    }

    float getAnimRunTimeSeconds() {
        int n = this.getFrameCount();
        if (this.firstFrameIndex == this.lastFrameIndex || this.lastFrameIndex < 0 || this.firstFrameIndex < 0 || this.lastFrameIndex >= n || this.firstFrameIndex >= n) {
            return 0.0f;
        }
        int n2 = Math.min(this.firstFrameIndex, this.lastFrameIndex);
        int n3 = Math.max(this.firstFrameIndex, this.lastFrameIndex);
        float f = 1.0f * (float)(n3 - n2) / (float)this.animationFps + this.firstFrameDelay + this.lastFrameDelay;
        for (int i = n2; i <= n3; ++i) {
            f += (float)this.viewer.getFrameDelayMs(i) / 1000.0f;
        }
        return f;
    }

    public void setMovie(Map<String, Object> map) {
        this.movie = map;
        this.viewer.setBooleanProperty("_ismovie", this.movie != null);
        if (this.movie == null) {
            this.bsDisplay = null;
            this.morphCount = 0;
            this.currentMorphFrame = 0;
        } else {
            this.setFrame(-1);
        }
    }

    public int getCurrentFrame() {
        return this.movie == null ? this.currentModelIndex : this.currentFrameIndex;
    }

    public boolean isMovie() {
        return this.movie != null;
    }

    public boolean currentIsLast() {
        return this.lastFramePainted == this.getCurrentFrame();
    }

    public String getModelNumber(int n) {
        switch (n) {
            case -1: {
                n = this.firstFrameIndex;
                break;
            }
            case 0: {
                if (this.morphCount > 0) {
                    return "-" + (1.0f + this.currentMorphFrame);
                }
                n = this.getCurrentFrame();
                break;
            }
            case 1: {
                n = this.lastFrameIndex;
            }
        }
        return this.movie == null ? this.viewer.getModelNumberDotted(n) : "" + (n + 1);
    }

    public void setDisplay(BS bS) {
        this.bsDisplay = bS == null || bS.cardinality() == 0 ? null : BSUtil.copy(bS);
    }

    public boolean currentFrameIs(int n) {
        int n2 = this.getCurrentFrame();
        return this.morphCount == 0 ? n2 == n : Math.abs(this.currentMorphFrame - (float)n) < 0.001f;
    }
}

