/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.List;
import org.jmol.util.P3;
import org.jmol.util.P4;
import org.jmol.util.Parser;
import org.jmol.util.SB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextFormat {
    private static final String[] formattingStrings = new String[]{"0", "0.0", "0.00", "0.000", "0.0000", "0.00000", "0.000000", "0.0000000", "0.00000000", "0.000000000"};
    private static final String zeros = "0000000000000000000000000000000000000000";
    private static final float[] formatAdds = new float[]{0.5f, 0.05f, 0.005f, 5.0E-4f, 5.0E-5f, 5.0E-6f, 5.0E-7f, 5.0E-8f, 5.0E-9f, 5.0E-10f};
    private static final Boolean[] useNumberLocalization = new Boolean[1];

    public TextFormat() {
        TextFormat.useNumberLocalization[0] = Boolean.TRUE;
    }

    public static void setUseNumberLocalization(boolean bl) {
        TextFormat.useNumberLocalization[0] = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public static String formatDecimal(float f, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        String string;
        boolean bl;
        if (n == Integer.MAX_VALUE || f == Float.NEGATIVE_INFINITY || f == Float.POSITIVE_INFINITY || Float.isNaN(f)) {
            return "" + f;
        }
        if (n < 0) {
            double d;
            if ((n = -n) > formattingStrings.length) {
                n = formattingStrings.length;
            }
            if (f == 0.0f) {
                return formattingStrings[n] + "E+0";
            }
            int n6 = 0;
            if (Math.abs(f) < 1.0f) {
                n6 = 10;
                d = (double)f * 1.0E-10;
            } else {
                n6 = -10;
                d = (double)f * 1.0E10;
            }
            String string2 = ("" + d).toUpperCase();
            int n7 = string2.indexOf("E");
            n6 = Parser.parseInt(string2.substring(n7 + 1)) + n6;
            return n7 < 0 ? "" + f : TextFormat.formatDecimal(Parser.parseFloatStr(string2.substring(0, n7)), n - 1) + "E" + (n6 >= 0 ? "+" : "") + n6;
        }
        if (n >= formattingStrings.length) {
            n = formattingStrings.length - 1;
        }
        if (bl = (string = ("" + f).toUpperCase()).startsWith("-")) {
            string = string.substring(1);
        }
        if ((n5 = string.indexOf(".")) < 0) {
            return string + formattingStrings[n].substring(1);
        }
        int n8 = string.indexOf("E-");
        if (n8 > 0) {
            n4 = Parser.parseInt(string.substring(n8 + 1));
            string = "0." + zeros.substring(0, -n4 - 1) + string.substring(0, 1) + string.substring(2, n8);
            n5 = 1;
        }
        if ((n8 = string.indexOf("E")) > 0) {
            n4 = Parser.parseInt(string.substring(n8 + 1));
            string = string.substring(0, 1) + string.substring(2, n8) + zeros;
            string = string.substring(0, n4 + 1) + "." + string.substring(n4 + 1);
            n5 = string.indexOf(".");
        }
        if ((n3 = n + n5 + 1) < (n2 = string.length()) && string.charAt(n3) >= '5') {
            return TextFormat.formatDecimal(f + (float)(bl ? -1 : 1) * formatAdds[n], n);
        }
        SB sB = SB.newS(string.substring(0, n == 0 ? n5 : ++n5));
        int n9 = 0;
        while (n9 < n) {
            if (n5 < n2) {
                sB.appendC(string.charAt(n5));
            } else {
                sB.appendC('0');
            }
            ++n9;
            ++n5;
        }
        string = (bl ? "-" : "") + sB;
        return Boolean.TRUE.equals(useNumberLocalization[0]) ? string : string.replace(',', '.');
    }

    public static String formatF(float f, int n, int n2, boolean bl, boolean bl2) {
        return TextFormat.formatS(TextFormat.formatDecimal(f, n2), n, 0, bl, bl2);
    }

    public static String formatD(double d, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        return TextFormat.formatS(TextFormat.formatDecimal((float)d, -1 - n2), n, 0, bl, bl2);
    }

    public static String formatS(String string, int n, int n2, boolean bl, boolean bl2) {
        if (string == null) {
            return "";
        }
        int n3 = string.length();
        if (n2 != Integer.MAX_VALUE && n2 > 0 && n2 < n3) {
            string = string.substring(0, n2);
        } else if (n2 < 0 && n3 + n2 >= 0) {
            string = string.substring(n3 + n2 + 1);
        }
        int n4 = n - string.length();
        if (n4 <= 0) {
            return string;
        }
        boolean bl3 = bl2 && !bl && string.charAt(0) == '-';
        char c = bl2 ? (char)'0' : ' ';
        char c2 = bl3 ? (char)'-' : c;
        SB sB = new SB();
        if (bl) {
            sB.append(string);
        }
        sB.appendC(c2);
        int n5 = n4;
        while (--n5 > 0) {
            sB.appendC(c);
        }
        if (!bl) {
            sB.append(bl3 ? c + string.substring(1) : string);
        }
        return sB.toString();
    }

    public static String formatStringS(String string, String string2, String string3) {
        return TextFormat.formatString(string, string2, string3, Float.NaN, Double.NaN, false);
    }

    public static String formatStringF(String string, String string2, float f) {
        return TextFormat.formatString(string, string2, null, f, Double.NaN, false);
    }

    public static String formatStringI(String string, String string2, int n) {
        return TextFormat.formatString(string, string2, "" + n, Float.NaN, Double.NaN, false);
    }

    public static String sprintf(String string, String string2, Object[] objectArray) {
        if (objectArray == null) {
            return string;
        }
        int n = string2.length();
        if (n == objectArray.length) {
            try {
                block14: for (int i = 0; i < n; ++i) {
                    if (objectArray[i] == null) continue;
                    switch (string2.charAt(i)) {
                        case 's': {
                            string = TextFormat.formatString(string, "s", (String)objectArray[i], Float.NaN, Double.NaN, true);
                            continue block14;
                        }
                        case 'f': {
                            string = TextFormat.formatString(string, "f", null, ((Float)objectArray[i]).floatValue(), Double.NaN, true);
                            continue block14;
                        }
                        case 'i': {
                            string = TextFormat.formatString(string, "d", "" + objectArray[i], Float.NaN, Double.NaN, true);
                            string = TextFormat.formatString(string, "i", "" + objectArray[i], Float.NaN, Double.NaN, true);
                            continue block14;
                        }
                        case 'd': {
                            string = TextFormat.formatString(string, "e", null, Float.NaN, (Double)objectArray[i], true);
                            continue block14;
                        }
                        case 'p': {
                            P3 p3 = (P3)objectArray[i];
                            string = TextFormat.formatString(string, "p", null, p3.x, Double.NaN, true);
                            string = TextFormat.formatString(string, "p", null, p3.y, Double.NaN, true);
                            string = TextFormat.formatString(string, "p", null, p3.z, Double.NaN, true);
                            continue block14;
                        }
                        case 'q': {
                            P4 p4 = (P4)objectArray[i];
                            string = TextFormat.formatString(string, "q", null, p4.x, Double.NaN, true);
                            string = TextFormat.formatString(string, "q", null, p4.y, Double.NaN, true);
                            string = TextFormat.formatString(string, "q", null, p4.z, Double.NaN, true);
                            string = TextFormat.formatString(string, "q", null, p4.w, Double.NaN, true);
                            continue block14;
                        }
                        case 'S': {
                            String[] stringArray = (String[])objectArray[i];
                            for (int j = 0; j < stringArray.length; ++j) {
                                string = TextFormat.formatString(string, "s", stringArray[j], Float.NaN, Double.NaN, true);
                            }
                            continue block14;
                        }
                        case 'F': {
                            float[] fArray = (float[])objectArray[i];
                            for (int j = 0; j < fArray.length; ++j) {
                                string = TextFormat.formatString(string, "f", null, fArray[j], Double.NaN, true);
                            }
                            continue block14;
                        }
                        case 'I': {
                            int n2;
                            int[] nArray = (int[])objectArray[i];
                            for (n2 = 0; n2 < nArray.length; ++n2) {
                                string = TextFormat.formatString(string, "d", "" + nArray[n2], Float.NaN, Double.NaN, true);
                            }
                            for (n2 = 0; n2 < nArray.length; ++n2) {
                                string = TextFormat.formatString(string, "i", "" + nArray[n2], Float.NaN, Double.NaN, true);
                            }
                            continue block14;
                        }
                        case 'D': {
                            double[] dArray = (double[])objectArray[i];
                            for (int j = 0; j < dArray.length; ++j) {
                                string = TextFormat.formatString(string, "e", null, Float.NaN, dArray[j], true);
                            }
                            continue block14;
                        }
                    }
                }
                return TextFormat.simpleReplace(string, "%%", "%");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println("TextFormat.sprintf error " + string2 + " " + string);
        return TextFormat.simpleReplace(string, "%", "?");
    }

    private static String formatString(String string, String string2, String string3, float f, double d, boolean bl) {
        int n;
        int n2;
        if (string == null) {
            return null;
        }
        if ("".equals(string)) {
            return "";
        }
        int n3 = string2.length();
        if (string.indexOf("%") < 0 || n3 == 0 || string.indexOf(string2) < 0) {
            return string;
        }
        String string4 = "";
        int n4 = 0;
        while ((n2 = string.indexOf(37, n4)) >= 0 && (n = string.indexOf(string2, n2 + 1)) >= 0) {
            if (n4 != n2) {
                string4 = string4 + string.substring(n4, n2);
            }
            n4 = n2 + 1;
            if (n > n2 + 6) {
                string4 = string4 + '%';
                continue;
            }
            try {
                String string5;
                char c;
                boolean bl2 = false;
                if (string.charAt(n4) == '-') {
                    bl2 = true;
                    ++n4;
                }
                boolean bl3 = false;
                if (string.charAt(n4) == '0') {
                    bl3 = true;
                    ++n4;
                }
                int n5 = 0;
                while ((c = string.charAt(n4)) >= '0' && c <= '9') {
                    n5 = 10 * n5 + (c - 48);
                    ++n4;
                }
                int n6 = Integer.MAX_VALUE;
                boolean bl4 = false;
                if (string.charAt(n4) == '.') {
                    if ((c = string.charAt(++n4)) == '-') {
                        bl4 = true;
                        ++n4;
                    }
                    if ((c = string.charAt(n4)) >= '0' && c <= '9') {
                        n6 = c - 48;
                        ++n4;
                    }
                    if (bl4) {
                        n6 = -n6 - (string3 == null ? 1 : 0);
                    }
                }
                if (!(string5 = string.substring(n4, n4 + n3)).equals(string2)) {
                    n4 = n2 + 1;
                    string4 = string4 + '%';
                    continue;
                }
                n4 += n3;
                if (!Float.isNaN(f)) {
                    string4 = string4 + TextFormat.formatF(f, n5, n6, bl2, bl3);
                } else if (string3 != null) {
                    string4 = string4 + TextFormat.formatS(string3, n5, n6, bl2, bl3);
                } else if (!Double.isNaN(d)) {
                    string4 = string4 + TextFormat.formatD(d, n5, n6, bl2, bl3, true);
                }
                if (!bl) continue;
                break;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                n4 = n2;
                break;
            }
        }
        string4 = string4 + string.substring(n4);
        return string4;
    }

    public static String formatCheck(String string) {
        if (string == null || string.indexOf(112) < 0 && string.indexOf(113) < 0) {
            return string;
        }
        string = TextFormat.simpleReplace(string, "%%", "\u0001");
        string = TextFormat.simpleReplace(string, "%p", "%6.2p");
        string = TextFormat.simpleReplace(string, "%q", "%6.2q");
        String[] stringArray = TextFormat.split(string, '%');
        SB sB = new SB();
        sB.append(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            String string2 = "%" + stringArray[i];
            if (string2.length() >= 3) {
                int n = string2.indexOf(112);
                if (n >= 0) {
                    string2 = TextFormat.fdup(string2, n, 3);
                }
                if ((n = string2.indexOf(113)) >= 0) {
                    string2 = TextFormat.fdup(string2, n, 4);
                }
            }
            sB.append(string2);
        }
        return sB.toString().replace('\u0001', '%');
    }

    private static String fdup(String string, int n, int n2) {
        int n3 = 0;
        int n4 = n;
        block4: while (--n4 >= 1) {
            char c = string.charAt(n4);
            if (Character.isDigit(c)) continue;
            switch (c) {
                case '.': {
                    if (n3++ == 0) continue block4;
                    return string;
                }
                case '-': {
                    if (n4 == 1) continue block4;
                    return string;
                }
            }
            return string;
        }
        String string2 = string.substring(0, n + 1);
        SB sB = new SB();
        for (int i = 0; i < n2; ++i) {
            sB.append(string2);
        }
        sB.append(string.substring(n + 1));
        return sB.toString();
    }

    public static String[] splitChars(String string, String string2) {
        if (string.length() == 0) {
            return new String[0];
        }
        int n = 1;
        int n2 = string.indexOf(string2);
        int n3 = string2.length();
        if (n2 < 0 || n3 == 0) {
            String[] stringArray = new String[]{string};
            return stringArray;
        }
        int n4 = string.length() - n3;
        while (n2 >= 0 && n2 < n4) {
            n2 = string.indexOf(string2, n2 + n3);
            ++n;
        }
        String[] stringArray = new String[n];
        n2 = 0;
        int n5 = 0;
        int n6 = 0;
        while ((n5 = string.indexOf(string2, n2)) >= 0 && n6 + 1 < n) {
            stringArray[n6++] = string.substring(n2, n5);
            n2 = n5 + n3;
        }
        if (string.indexOf(string2, n4) != n4) {
            n4 += n3;
        }
        stringArray[n6] = string.substring(n2, n4);
        return stringArray;
    }

    public static String replaceAllCharacters(String string, String string2, String string3) {
        int n = string2.length();
        while (--n >= 0) {
            String string4 = string2.substring(n, n + 1);
            string = TextFormat.simpleReplace(string, string4, string3);
        }
        return string;
    }

    public static String replaceAllCharacter(String string, String string2, char c) {
        if (string == null) {
            return null;
        }
        int n = string2.length();
        while (--n >= 0) {
            string = string.replace(string2.charAt(n), c);
        }
        return string;
    }

    public static String simpleReplace(String string, String string2, String string3) {
        boolean bl;
        if (string == null || string.indexOf(string2) < 0 || string2.equals(string3)) {
            return string;
        }
        int n = string2.length();
        if (n == 0) {
            return string;
        }
        boolean bl2 = bl = string3.indexOf(string2) >= 0;
        while (string.indexOf(string2) >= 0) {
            int n2;
            SB sB = new SB();
            int n3 = 0;
            while ((n2 = string.indexOf(string2, n3)) >= 0) {
                sB.append(string.substring(n3, n2)).append(string3);
                n3 = n2 + n;
            }
            sB.append(string.substring(n3));
            string = sB.toString();
            if (!bl) continue;
            break;
        }
        return string;
    }

    public static String trim(String string, String string2) {
        int n;
        int n2;
        if (string2.length() == 0) {
            return string.trim();
        }
        int n3 = string.length();
        for (n2 = 0; n2 < n3 && string2.indexOf(string.charAt(n2)) >= 0; ++n2) {
        }
        for (n = string.length() - 1; n > n2 && string2.indexOf(string.charAt(n)) >= 0; --n) {
        }
        return string.substring(n2, n + 1);
    }

    public static String[] split(String string, char c) {
        return TextFormat.splitChars(string, "" + c);
    }

    public static void lFill(SB sB, String string, String string2) {
        sB.append(string2);
        int n = string.length() - string2.length();
        if (n > 0) {
            sB.append(string.substring(0, n));
        }
    }

    public static void rFill(SB sB, String string, String string2) {
        int n = string.length() - string2.length();
        if (n > 0) {
            sB.append(string.substring(0, n));
        }
        sB.append(string2);
    }

    public static String safeTruncate(float f, int n) {
        if ((double)f > -0.001 && (double)f < 0.001) {
            f = 0.0f;
        }
        return (f + "         ").substring(0, n);
    }

    public static boolean isWild(String string) {
        return string != null && (string.indexOf("*") >= 0 || string.indexOf("?") >= 0);
    }

    public static boolean isMatch(String string, String string2, boolean bl, boolean bl2) {
        boolean bl3;
        int n = 0;
        int n2 = string2.length();
        int n3 = string.length();
        if (n3 == 0 || n2 == 0) {
            return n3 == n2 || n2 == 1 && string2.charAt(0) == '*';
        }
        boolean bl4 = bl && bl2 ? string2.charAt(0) == '*' : (bl3 = false);
        if (bl3 && string2.charAt(n2 - 1) == '*') {
            return n2 < 3 || string.indexOf(string2.substring(1, n2 - 1)) >= 0;
        }
        String string3 = "????";
        while (string3.length() < string.length()) {
            string3 = string3 + string3;
        }
        if (bl) {
            if (bl2 && bl3) {
                string2 = string3 + string2.substring(1);
            }
            if (string2.charAt(n = string2.length() - 1) == '*') {
                string2 = string2.substring(0, n) + string3;
            }
            n2 = string2.length();
        }
        if (n2 < n3) {
            return false;
        }
        n = 0;
        while (n2 > n3) {
            if (bl2 && string2.charAt(n) == '?') {
                ++n;
            } else if (string2.charAt(n + n2 - 1) != '?') {
                return false;
            }
            --n2;
        }
        int n4 = n3;
        while (--n4 >= 0) {
            char c = string2.charAt(n + n4);
            if (c == '?' || c == string.charAt(n4) || c == '\u0001' && string.charAt(n4) == '?') continue;
            return false;
        }
        return true;
    }

    public static String join(String[] stringArray, char c, int n) {
        if (stringArray.length < n) {
            return null;
        }
        SB sB = new SB();
        sB.append(stringArray[n++]);
        for (int i = n; i < stringArray.length; ++i) {
            sB.appendC(c).append(stringArray[i]);
        }
        return sB.toString();
    }

    public static String replaceQuotedStrings(String string, List<String> list, List<String> list2) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string2 = list.get(i);
            String string3 = list2.get(i);
            if (string3.equals(string2)) continue;
            string = TextFormat.simpleReplace(string, "\"" + string2 + "\"", "\"" + string3 + "\"");
        }
        return string;
    }

    public static String replaceStrings(String string, List<String> list, List<String> list2) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string2 = list.get(i);
            String string3 = list2.get(i);
            if (string3.equals(string2)) continue;
            string = TextFormat.simpleReplace(string, string2, string3);
        }
        return string;
    }

    public static int ichMathTerminator(String string, int n, int n2) {
        int n3 = 1;
        char c = '\u0000';
        int n4 = 0;
        while (n3 > 0 && ++n < n2) {
            char c2 = string.charAt(n);
            if (c != '\u0000') {
                if (n4 == 92) {
                    c2 = '\u0000';
                } else if (c2 == c) {
                    c = '\u0000';
                }
                n4 = c2;
                continue;
            }
            switch (c2) {
                case '\"': 
                case '\'': {
                    c = c2;
                    break;
                }
                case '{': {
                    ++n3;
                    break;
                }
                case '}': {
                    --n3;
                }
            }
        }
        return n;
    }
}

