/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import org.jmol.constant.EnumStructure;
import org.jmol.util.P3;
import org.jmol.util.P3i;

public class TempArray {
    private static final int freePointsSize = 6;
    private final int[] lengthsFreePoints = new int[6];
    private final P3[][] freePoints = new P3[6][];
    private static final int freeScreensSize = 6;
    private final int[] lengthsFreeScreens = new int[6];
    private final P3i[][] freeScreens = new P3i[6][];
    private static final int freeEnumSize = 2;
    private final int[] lengthsFreeEnum = new int[2];
    private final EnumStructure[][] freeEnum = new EnumStructure[2][];

    public void clear() {
        this.clearTempPoints();
        this.clearTempScreens();
    }

    private static int findBestFit(int n, int[] nArray) {
        int n2 = -1;
        int n3 = Integer.MAX_VALUE;
        int n4 = nArray.length;
        while (--n4 >= 0) {
            int n5 = nArray[n4];
            if (n5 < n || n5 >= n3) continue;
            n3 = n5;
            n2 = n4;
        }
        if (n2 >= 0) {
            nArray[n2] = 0;
        }
        return n2;
    }

    private static int findShorter(int n, int[] nArray) {
        int n2 = nArray.length;
        while (--n2 >= 0) {
            if (nArray[n2] != 0) continue;
            nArray[n2] = n;
            return n2;
        }
        n2 = 0;
        int n3 = nArray[0];
        int n4 = nArray.length;
        while (--n4 > 0) {
            if (nArray[n4] >= n3) continue;
            n3 = nArray[n4];
            n2 = n4;
        }
        if (n3 < n) {
            nArray[n2] = n;
            return n2;
        }
        return -1;
    }

    private void clearTempPoints() {
        for (int i = 0; i < 6; ++i) {
            this.lengthsFreePoints[i] = 0;
            this.freePoints[i] = null;
        }
    }

    public P3[] allocTempPoints(int n) {
        P3[] p3Array;
        int n2 = TempArray.findBestFit(n, this.lengthsFreePoints);
        if (n2 > 0) {
            p3Array = this.freePoints[n2];
        } else {
            p3Array = new P3[n];
            int n3 = n;
            while (--n3 >= 0) {
                p3Array[n3] = new P3();
            }
        }
        return p3Array;
    }

    public void freeTempPoints(P3[] p3Array) {
        int n;
        for (n = 0; n < this.freePoints.length; ++n) {
            if (this.freePoints[n] != p3Array) continue;
            this.lengthsFreePoints[n] = p3Array.length;
            return;
        }
        n = TempArray.findShorter(p3Array.length, this.lengthsFreePoints);
        if (n >= 0) {
            this.freePoints[n] = p3Array;
        }
    }

    private void clearTempScreens() {
        for (int i = 0; i < 6; ++i) {
            this.lengthsFreeScreens[i] = 0;
            this.freeScreens[i] = null;
        }
    }

    public P3i[] allocTempScreens(int n) {
        P3i[] p3iArray;
        int n2 = TempArray.findBestFit(n, this.lengthsFreeScreens);
        if (n2 > 0) {
            p3iArray = this.freeScreens[n2];
        } else {
            p3iArray = new P3i[n];
            int n3 = n;
            while (--n3 >= 0) {
                p3iArray[n3] = new P3i();
            }
        }
        return p3iArray;
    }

    public void freeTempScreens(P3i[] p3iArray) {
        int n;
        for (n = 0; n < this.freeScreens.length; ++n) {
            if (this.freeScreens[n] != p3iArray) continue;
            this.lengthsFreeScreens[n] = p3iArray.length;
            return;
        }
        n = TempArray.findShorter(p3iArray.length, this.lengthsFreeScreens);
        if (n >= 0) {
            this.freeScreens[n] = p3iArray;
        }
    }

    public EnumStructure[] allocTempEnum(int n) {
        int n2 = TempArray.findBestFit(n, this.lengthsFreeEnum);
        EnumStructure[] enumStructureArray = n2 > 0 ? this.freeEnum[n2] : new EnumStructure[n];
        return enumStructureArray;
    }

    public void freeTempEnum(EnumStructure[] enumStructureArray) {
        int n;
        for (n = 0; n < this.freeEnum.length; ++n) {
            if (this.freeEnum[n] != enumStructureArray) continue;
            this.lengthsFreeEnum[n] = enumStructureArray.length;
            return;
        }
        n = TempArray.findShorter(enumStructureArray.length, this.lengthsFreeEnum);
        if (n >= 0) {
            this.freeEnum[n] = enumStructureArray;
        }
    }
}

