/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.io.Serializable;
import org.jmol.util.AxisAngle4f;
import org.jmol.util.Matrix3f;
import org.jmol.util.P3;
import org.jmol.util.Tuple3f;
import org.jmol.util.Tuple4f;
import org.jmol.util.V3;

public class Matrix4f
implements Serializable {
    public float m00;
    public float m01;
    public float m02;
    public float m03;
    public float m10;
    public float m11;
    public float m12;
    public float m13;
    public float m20;
    public float m21;
    public float m22;
    public float m23;
    public float m30;
    public float m31;
    public float m32;
    public float m33;

    public static Matrix4f newA(float[] fArray) {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.m00 = fArray[0];
        matrix4f.m01 = fArray[1];
        matrix4f.m02 = fArray[2];
        matrix4f.m03 = fArray[3];
        matrix4f.m10 = fArray[4];
        matrix4f.m11 = fArray[5];
        matrix4f.m12 = fArray[6];
        matrix4f.m13 = fArray[7];
        matrix4f.m20 = fArray[8];
        matrix4f.m21 = fArray[9];
        matrix4f.m22 = fArray[10];
        matrix4f.m23 = fArray[11];
        matrix4f.m30 = fArray[12];
        matrix4f.m31 = fArray[13];
        matrix4f.m32 = fArray[14];
        matrix4f.m33 = fArray[15];
        return matrix4f;
    }

    public static Matrix4f newM(Matrix4f matrix4f) {
        Matrix4f matrix4f2 = new Matrix4f();
        matrix4f2.m00 = matrix4f.m00;
        matrix4f2.m01 = matrix4f.m01;
        matrix4f2.m02 = matrix4f.m02;
        matrix4f2.m03 = matrix4f.m03;
        matrix4f2.m10 = matrix4f.m10;
        matrix4f2.m11 = matrix4f.m11;
        matrix4f2.m12 = matrix4f.m12;
        matrix4f2.m13 = matrix4f.m13;
        matrix4f2.m20 = matrix4f.m20;
        matrix4f2.m21 = matrix4f.m21;
        matrix4f2.m22 = matrix4f.m22;
        matrix4f2.m23 = matrix4f.m23;
        matrix4f2.m30 = matrix4f.m30;
        matrix4f2.m31 = matrix4f.m31;
        matrix4f2.m32 = matrix4f.m32;
        matrix4f2.m33 = matrix4f.m33;
        return matrix4f2;
    }

    public static Matrix4f newMV(Matrix3f matrix3f, V3 v3) {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.setMV(matrix3f, v3);
        return matrix4f;
    }

    public void setMV(Matrix3f matrix3f, V3 v3) {
        this.setM3(matrix3f);
        this.setTranslation(v3);
    }

    public final void setAA(AxisAngle4f axisAngle4f) {
        this.setFromAxisAngle(axisAngle4f.x, axisAngle4f.y, axisAngle4f.z, axisAngle4f.angle);
    }

    private void setFromAxisAngle(double d, double d2, double d3, double d4) {
        double d5 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        d5 = 1.0 / d5;
        d *= d5;
        d2 *= d5;
        d3 *= d5;
        double d6 = Math.cos(d4);
        double d7 = Math.sin(d4);
        double d8 = 1.0 - d6;
        this.m00 = (float)(d6 + d * d * d8);
        this.m11 = (float)(d6 + d2 * d2 * d8);
        this.m22 = (float)(d6 + d3 * d3 * d8);
        double d9 = d * d2 * d8;
        double d10 = d3 * d7;
        this.m01 = (float)(d9 - d10);
        this.m10 = (float)(d9 + d10);
        d9 = d * d3 * d8;
        d10 = d2 * d7;
        this.m02 = (float)(d9 + d10);
        this.m20 = (float)(d9 - d10);
        d9 = d2 * d3 * d8;
        d10 = d * d7;
        this.m12 = (float)(d9 - d10);
        this.m21 = (float)(d9 + d10);
    }

    public final void setM(Matrix4f matrix4f) {
        this.m00 = matrix4f.m00;
        this.m01 = matrix4f.m01;
        this.m02 = matrix4f.m02;
        this.m03 = matrix4f.m03;
        this.m10 = matrix4f.m10;
        this.m11 = matrix4f.m11;
        this.m12 = matrix4f.m12;
        this.m13 = matrix4f.m13;
        this.m20 = matrix4f.m20;
        this.m21 = matrix4f.m21;
        this.m22 = matrix4f.m22;
        this.m23 = matrix4f.m23;
        this.m30 = matrix4f.m30;
        this.m31 = matrix4f.m31;
        this.m32 = matrix4f.m32;
        this.m33 = matrix4f.m33;
    }

    public String toString() {
        return "[\n  [" + this.m00 + "\t" + this.m01 + "\t" + this.m02 + "\t" + this.m03 + "]" + "\n  [" + this.m10 + "\t" + this.m11 + "\t" + this.m12 + "\t" + this.m13 + "]" + "\n  [" + this.m20 + "\t" + this.m21 + "\t" + this.m22 + "\t" + this.m23 + "]" + "\n  [" + this.m30 + "\t" + this.m31 + "\t" + this.m32 + "\t" + this.m33 + "] ]";
    }

    public final void setIdentity() {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setElement(int n, int n2, float f) {
        if (n == 0) {
            if (n2 == 0) {
                this.m00 = f;
                return;
            } else if (n2 == 1) {
                this.m01 = f;
                return;
            } else if (n2 == 2) {
                this.m02 = f;
                return;
            } else {
                if (n2 != 3) throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n2);
                this.m03 = f;
            }
            return;
        } else if (n == 1) {
            if (n2 == 0) {
                this.m10 = f;
                return;
            } else if (n2 == 1) {
                this.m11 = f;
                return;
            } else if (n2 == 2) {
                this.m12 = f;
                return;
            } else {
                if (n2 != 3) throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n2);
                this.m13 = f;
            }
            return;
        } else if (n == 2) {
            if (n2 == 0) {
                this.m20 = f;
                return;
            } else if (n2 == 1) {
                this.m21 = f;
                return;
            } else if (n2 == 2) {
                this.m22 = f;
                return;
            } else {
                if (n2 != 3) throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n2);
                this.m23 = f;
            }
            return;
        } else {
            if (n != 3) throw new ArrayIndexOutOfBoundsException("row must be 0 to 2 and is " + n);
            if (n2 == 0) {
                this.m30 = f;
                return;
            } else if (n2 == 1) {
                this.m31 = f;
                return;
            } else if (n2 == 2) {
                this.m32 = f;
                return;
            } else {
                if (n2 != 3) throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n2);
                this.m33 = f;
            }
        }
    }

    public final float getElement(int n, int n2) {
        if (n == 0) {
            if (n2 == 0) {
                return this.m00;
            }
            if (n2 == 1) {
                return this.m01;
            }
            if (n2 == 2) {
                return this.m02;
            }
            if (n2 == 3) {
                return this.m03;
            }
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n2);
        }
        if (n == 1) {
            if (n2 == 0) {
                return this.m10;
            }
            if (n2 == 1) {
                return this.m11;
            }
            if (n2 == 2) {
                return this.m12;
            }
            if (n2 == 3) {
                return this.m13;
            }
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n2);
        }
        if (n == 2) {
            if (n2 == 0) {
                return this.m20;
            }
            if (n2 == 1) {
                return this.m21;
            }
            if (n2 == 2) {
                return this.m22;
            }
            if (n2 == 3) {
                return this.m23;
            }
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n2);
        }
        if (n == 3) {
            if (n2 == 0) {
                return this.m30;
            }
            if (n2 == 1) {
                return this.m31;
            }
            if (n2 == 2) {
                return this.m32;
            }
            if (n2 == 3) {
                return this.m33;
            }
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n2);
        }
        throw new ArrayIndexOutOfBoundsException("row must be 0 to 3 and is " + n);
    }

    public final void get(V3 v3) {
        v3.x = this.m03;
        v3.y = this.m13;
        v3.z = this.m23;
    }

    public final void getRotationScale(Matrix3f matrix3f) {
        matrix3f.m00 = this.m00;
        matrix3f.m01 = this.m01;
        matrix3f.m02 = this.m02;
        matrix3f.m10 = this.m10;
        matrix3f.m11 = this.m11;
        matrix3f.m12 = this.m12;
        matrix3f.m20 = this.m20;
        matrix3f.m21 = this.m21;
        matrix3f.m22 = this.m22;
    }

    public final void setRotationScale(Matrix3f matrix3f) {
        this.m00 = matrix3f.m00;
        this.m01 = matrix3f.m01;
        this.m02 = matrix3f.m02;
        this.m10 = matrix3f.m10;
        this.m11 = matrix3f.m11;
        this.m12 = matrix3f.m12;
        this.m20 = matrix3f.m20;
        this.m21 = matrix3f.m21;
        this.m22 = matrix3f.m22;
    }

    public final void setRow(int n, float[] fArray) {
        if (n == 0) {
            this.m00 = fArray[0];
            this.m01 = fArray[1];
            this.m02 = fArray[2];
            this.m03 = fArray[3];
        } else if (n == 1) {
            this.m10 = fArray[0];
            this.m11 = fArray[1];
            this.m12 = fArray[2];
            this.m13 = fArray[3];
        } else if (n == 2) {
            this.m20 = fArray[0];
            this.m21 = fArray[1];
            this.m22 = fArray[2];
            this.m23 = fArray[3];
        } else if (n == 3) {
            this.m30 = fArray[0];
            this.m31 = fArray[1];
            this.m32 = fArray[2];
            this.m33 = fArray[3];
        } else {
            throw new ArrayIndexOutOfBoundsException("row must be 0 to 3 and is " + n);
        }
    }

    public final void getRow(int n, float[] fArray) {
        if (n == 0) {
            fArray[0] = this.m00;
            fArray[1] = this.m01;
            fArray[2] = this.m02;
            fArray[3] = this.m03;
        } else if (n == 1) {
            fArray[0] = this.m10;
            fArray[1] = this.m11;
            fArray[2] = this.m12;
            fArray[3] = this.m13;
        } else if (n == 2) {
            fArray[0] = this.m20;
            fArray[1] = this.m21;
            fArray[2] = this.m22;
            fArray[3] = this.m23;
        } else if (n == 3) {
            fArray[0] = this.m30;
            fArray[1] = this.m31;
            fArray[2] = this.m32;
            fArray[3] = this.m33;
        } else {
            throw new ArrayIndexOutOfBoundsException("row must be 0 to 3 and is " + n);
        }
    }

    public final void setColumn4(int n, float f, float f2, float f3, float f4) {
        if (n == 0) {
            this.m00 = f;
            this.m10 = f2;
            this.m20 = f3;
            this.m30 = f4;
        } else if (n == 1) {
            this.m01 = f;
            this.m11 = f2;
            this.m21 = f3;
            this.m31 = f4;
        } else if (n == 2) {
            this.m02 = f;
            this.m12 = f2;
            this.m22 = f3;
            this.m32 = f4;
        } else if (n == 3) {
            this.m03 = f;
            this.m13 = f2;
            this.m23 = f3;
            this.m33 = f4;
        } else {
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n);
        }
    }

    public final void setColumn(int n, float[] fArray) {
        if (n == 0) {
            this.m00 = fArray[0];
            this.m10 = fArray[1];
            this.m20 = fArray[2];
            this.m30 = fArray[3];
        } else if (n == 1) {
            this.m01 = fArray[0];
            this.m11 = fArray[1];
            this.m21 = fArray[2];
            this.m31 = fArray[3];
        } else if (n == 2) {
            this.m02 = fArray[0];
            this.m12 = fArray[1];
            this.m22 = fArray[2];
            this.m32 = fArray[3];
        } else if (n == 3) {
            this.m03 = fArray[0];
            this.m13 = fArray[1];
            this.m23 = fArray[2];
            this.m33 = fArray[3];
        } else {
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n);
        }
    }

    public final void getColumn(int n, float[] fArray) {
        if (n == 0) {
            fArray[0] = this.m00;
            fArray[1] = this.m10;
            fArray[2] = this.m20;
            fArray[3] = this.m30;
        } else if (n == 1) {
            fArray[0] = this.m01;
            fArray[1] = this.m11;
            fArray[2] = this.m21;
            fArray[3] = this.m31;
        } else if (n == 2) {
            fArray[0] = this.m02;
            fArray[1] = this.m12;
            fArray[2] = this.m22;
            fArray[3] = this.m32;
        } else if (n == 3) {
            fArray[0] = this.m03;
            fArray[1] = this.m13;
            fArray[2] = this.m23;
            fArray[3] = this.m33;
        } else {
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n);
        }
    }

    public final void sub(Matrix4f matrix4f) {
        this.m00 -= matrix4f.m00;
        this.m01 -= matrix4f.m01;
        this.m02 -= matrix4f.m02;
        this.m03 -= matrix4f.m03;
        this.m10 -= matrix4f.m10;
        this.m11 -= matrix4f.m11;
        this.m12 -= matrix4f.m12;
        this.m13 -= matrix4f.m13;
        this.m20 -= matrix4f.m20;
        this.m21 -= matrix4f.m21;
        this.m22 -= matrix4f.m22;
        this.m23 -= matrix4f.m23;
        this.m30 -= matrix4f.m30;
        this.m31 -= matrix4f.m31;
        this.m32 -= matrix4f.m32;
        this.m33 -= matrix4f.m33;
    }

    public final void transpose() {
        float f = this.m01;
        this.m01 = this.m10;
        this.m10 = f;
        f = this.m02;
        this.m02 = this.m20;
        this.m20 = f;
        f = this.m03;
        this.m03 = this.m30;
        this.m30 = f;
        f = this.m12;
        this.m12 = this.m21;
        this.m21 = f;
        f = this.m13;
        this.m13 = this.m31;
        this.m31 = f;
        f = this.m23;
        this.m23 = this.m32;
        this.m32 = f;
    }

    public final void invertM(Matrix4f matrix4f) {
        this.setM(matrix4f);
        this.invert();
    }

    public final void invert() {
        float f = this.determinant();
        if ((double)f == 0.0) {
            return;
        }
        f = 1.0f / f;
        this.set(this.m11 * (this.m22 * this.m33 - this.m23 * this.m32) + this.m12 * (this.m23 * this.m31 - this.m21 * this.m33) + this.m13 * (this.m21 * this.m32 - this.m22 * this.m31), this.m21 * (this.m02 * this.m33 - this.m03 * this.m32) + this.m22 * (this.m03 * this.m31 - this.m01 * this.m33) + this.m23 * (this.m01 * this.m32 - this.m02 * this.m31), this.m31 * (this.m02 * this.m13 - this.m03 * this.m12) + this.m32 * (this.m03 * this.m11 - this.m01 * this.m13) + this.m33 * (this.m01 * this.m12 - this.m02 * this.m11), this.m01 * (this.m13 * this.m22 - this.m12 * this.m23) + this.m02 * (this.m11 * this.m23 - this.m13 * this.m21) + this.m03 * (this.m12 * this.m21 - this.m11 * this.m22), this.m12 * (this.m20 * this.m33 - this.m23 * this.m30) + this.m13 * (this.m22 * this.m30 - this.m20 * this.m32) + this.m10 * (this.m23 * this.m32 - this.m22 * this.m33), this.m22 * (this.m00 * this.m33 - this.m03 * this.m30) + this.m23 * (this.m02 * this.m30 - this.m00 * this.m32) + this.m20 * (this.m03 * this.m32 - this.m02 * this.m33), this.m32 * (this.m00 * this.m13 - this.m03 * this.m10) + this.m33 * (this.m02 * this.m10 - this.m00 * this.m12) + this.m30 * (this.m03 * this.m12 - this.m02 * this.m13), this.m02 * (this.m13 * this.m20 - this.m10 * this.m23) + this.m03 * (this.m10 * this.m22 - this.m12 * this.m20) + this.m00 * (this.m12 * this.m23 - this.m13 * this.m22), this.m13 * (this.m20 * this.m31 - this.m21 * this.m30) + this.m10 * (this.m21 * this.m33 - this.m23 * this.m31) + this.m11 * (this.m23 * this.m30 - this.m20 * this.m33), this.m23 * (this.m00 * this.m31 - this.m01 * this.m30) + this.m20 * (this.m01 * this.m33 - this.m03 * this.m31) + this.m21 * (this.m03 * this.m30 - this.m00 * this.m33), this.m33 * (this.m00 * this.m11 - this.m01 * this.m10) + this.m30 * (this.m01 * this.m13 - this.m03 * this.m11) + this.m31 * (this.m03 * this.m10 - this.m00 * this.m13), this.m03 * (this.m11 * this.m20 - this.m10 * this.m21) + this.m00 * (this.m13 * this.m21 - this.m11 * this.m23) + this.m01 * (this.m10 * this.m23 - this.m13 * this.m20), this.m10 * (this.m22 * this.m31 - this.m21 * this.m32) + this.m11 * (this.m20 * this.m32 - this.m22 * this.m30) + this.m12 * (this.m21 * this.m30 - this.m20 * this.m31), this.m20 * (this.m02 * this.m31 - this.m01 * this.m32) + this.m21 * (this.m00 * this.m32 - this.m02 * this.m30) + this.m22 * (this.m01 * this.m30 - this.m00 * this.m31), this.m30 * (this.m02 * this.m11 - this.m01 * this.m12) + this.m31 * (this.m00 * this.m12 - this.m02 * this.m10) + this.m32 * (this.m01 * this.m10 - this.m00 * this.m11), this.m00 * (this.m11 * this.m22 - this.m12 * this.m21) + this.m01 * (this.m12 * this.m20 - this.m10 * this.m22) + this.m02 * (this.m10 * this.m21 - this.m11 * this.m20));
        this.mul(f);
    }

    public final float determinant() {
        return (this.m00 * this.m11 - this.m01 * this.m10) * (this.m22 * this.m33 - this.m23 * this.m32) - (this.m00 * this.m12 - this.m02 * this.m10) * (this.m21 * this.m33 - this.m23 * this.m31) + (this.m00 * this.m13 - this.m03 * this.m10) * (this.m21 * this.m32 - this.m22 * this.m31) + (this.m01 * this.m12 - this.m02 * this.m11) * (this.m20 * this.m33 - this.m23 * this.m30) - (this.m01 * this.m13 - this.m03 * this.m11) * (this.m20 * this.m32 - this.m22 * this.m30) + (this.m02 * this.m13 - this.m03 * this.m12) * (this.m20 * this.m31 - this.m21 * this.m30);
    }

    public final void setM3(Matrix3f matrix3f) {
        this.m00 = matrix3f.m00;
        this.m01 = matrix3f.m01;
        this.m02 = matrix3f.m02;
        this.m03 = 0.0f;
        this.m10 = matrix3f.m10;
        this.m11 = matrix3f.m11;
        this.m12 = matrix3f.m12;
        this.m13 = 0.0f;
        this.m20 = matrix3f.m20;
        this.m21 = matrix3f.m21;
        this.m22 = matrix3f.m22;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void setA(float[] fArray) {
        this.m00 = fArray[0];
        this.m01 = fArray[1];
        this.m02 = fArray[2];
        this.m03 = fArray[3];
        this.m10 = fArray[4];
        this.m11 = fArray[5];
        this.m12 = fArray[6];
        this.m13 = fArray[7];
        this.m20 = fArray[8];
        this.m21 = fArray[9];
        this.m22 = fArray[10];
        this.m23 = fArray[11];
        this.m30 = fArray[12];
        this.m31 = fArray[13];
        this.m32 = fArray[14];
        this.m33 = fArray[15];
    }

    public void setTranslation(V3 v3) {
        this.m03 = v3.x;
        this.m13 = v3.y;
        this.m23 = v3.z;
    }

    public final void rotX(float f) {
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = f2;
        this.m12 = -f3;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = f3;
        this.m22 = f2;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void rotY(float f) {
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        this.m00 = f2;
        this.m01 = 0.0f;
        this.m02 = f3;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = -f3;
        this.m21 = 0.0f;
        this.m22 = f2;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public final void rotZ(float f) {
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        this.m00 = f2;
        this.m01 = -f3;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = f3;
        this.m11 = f2;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    private final void mul(float f) {
        this.m00 *= f;
        this.m01 *= f;
        this.m02 *= f;
        this.m03 *= f;
        this.m10 *= f;
        this.m11 *= f;
        this.m12 *= f;
        this.m13 *= f;
        this.m20 *= f;
        this.m21 *= f;
        this.m22 *= f;
        this.m23 *= f;
        this.m30 *= f;
        this.m31 *= f;
        this.m32 *= f;
        this.m33 *= f;
    }

    public final void mulM4(Matrix4f matrix4f) {
        this.mul2(this, matrix4f);
    }

    public final void mul2(Matrix4f matrix4f, Matrix4f matrix4f2) {
        this.set(matrix4f.m00 * matrix4f2.m00 + matrix4f.m01 * matrix4f2.m10 + matrix4f.m02 * matrix4f2.m20 + matrix4f.m03 * matrix4f2.m30, matrix4f.m00 * matrix4f2.m01 + matrix4f.m01 * matrix4f2.m11 + matrix4f.m02 * matrix4f2.m21 + matrix4f.m03 * matrix4f2.m31, matrix4f.m00 * matrix4f2.m02 + matrix4f.m01 * matrix4f2.m12 + matrix4f.m02 * matrix4f2.m22 + matrix4f.m03 * matrix4f2.m32, matrix4f.m00 * matrix4f2.m03 + matrix4f.m01 * matrix4f2.m13 + matrix4f.m02 * matrix4f2.m23 + matrix4f.m03 * matrix4f2.m33, matrix4f.m10 * matrix4f2.m00 + matrix4f.m11 * matrix4f2.m10 + matrix4f.m12 * matrix4f2.m20 + matrix4f.m13 * matrix4f2.m30, matrix4f.m10 * matrix4f2.m01 + matrix4f.m11 * matrix4f2.m11 + matrix4f.m12 * matrix4f2.m21 + matrix4f.m13 * matrix4f2.m31, matrix4f.m10 * matrix4f2.m02 + matrix4f.m11 * matrix4f2.m12 + matrix4f.m12 * matrix4f2.m22 + matrix4f.m13 * matrix4f2.m32, matrix4f.m10 * matrix4f2.m03 + matrix4f.m11 * matrix4f2.m13 + matrix4f.m12 * matrix4f2.m23 + matrix4f.m13 * matrix4f2.m33, matrix4f.m20 * matrix4f2.m00 + matrix4f.m21 * matrix4f2.m10 + matrix4f.m22 * matrix4f2.m20 + matrix4f.m23 * matrix4f2.m30, matrix4f.m20 * matrix4f2.m01 + matrix4f.m21 * matrix4f2.m11 + matrix4f.m22 * matrix4f2.m21 + matrix4f.m23 * matrix4f2.m31, matrix4f.m20 * matrix4f2.m02 + matrix4f.m21 * matrix4f2.m12 + matrix4f.m22 * matrix4f2.m22 + matrix4f.m23 * matrix4f2.m32, matrix4f.m20 * matrix4f2.m03 + matrix4f.m21 * matrix4f2.m13 + matrix4f.m22 * matrix4f2.m23 + matrix4f.m23 * matrix4f2.m33, matrix4f.m30 * matrix4f2.m00 + matrix4f.m31 * matrix4f2.m10 + matrix4f.m32 * matrix4f2.m20 + matrix4f.m33 * matrix4f2.m30, matrix4f.m30 * matrix4f2.m01 + matrix4f.m31 * matrix4f2.m11 + matrix4f.m32 * matrix4f2.m21 + matrix4f.m33 * matrix4f2.m31, matrix4f.m30 * matrix4f2.m02 + matrix4f.m31 * matrix4f2.m12 + matrix4f.m32 * matrix4f2.m22 + matrix4f.m33 * matrix4f2.m32, matrix4f.m30 * matrix4f2.m03 + matrix4f.m31 * matrix4f2.m13 + matrix4f.m32 * matrix4f2.m23 + matrix4f.m33 * matrix4f2.m33);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Matrix4f)) {
            return false;
        }
        Matrix4f matrix4f = (Matrix4f)object;
        return this.m00 == matrix4f.m00 && this.m01 == matrix4f.m01 && this.m02 == matrix4f.m02 && this.m03 == matrix4f.m03 && this.m10 == matrix4f.m10 && this.m11 == matrix4f.m11 && this.m12 == matrix4f.m12 && this.m13 == matrix4f.m13 && this.m20 == matrix4f.m20 && this.m21 == matrix4f.m21 && this.m22 == matrix4f.m22 && this.m23 == matrix4f.m23 && this.m30 == matrix4f.m30 && this.m31 == matrix4f.m31 && this.m32 == matrix4f.m32 && this.m33 == matrix4f.m33;
    }

    public int hashCode() {
        return Tuple3f.floatToIntBits0(this.m00) ^ Tuple3f.floatToIntBits0(this.m01) ^ Tuple3f.floatToIntBits0(this.m02) ^ Tuple3f.floatToIntBits0(this.m03) ^ Tuple3f.floatToIntBits0(this.m10) ^ Tuple3f.floatToIntBits0(this.m11) ^ Tuple3f.floatToIntBits0(this.m12) ^ Tuple3f.floatToIntBits0(this.m13) ^ Tuple3f.floatToIntBits0(this.m20) ^ Tuple3f.floatToIntBits0(this.m21) ^ Tuple3f.floatToIntBits0(this.m22) ^ Tuple3f.floatToIntBits0(this.m23) ^ Tuple3f.floatToIntBits0(this.m30) ^ Tuple3f.floatToIntBits0(this.m31) ^ Tuple3f.floatToIntBits0(this.m32) ^ Tuple3f.floatToIntBits0(this.m33);
    }

    public final void transformT2(Tuple4f tuple4f, Tuple4f tuple4f2) {
        tuple4f2.set(this.m00 * tuple4f.x + this.m01 * tuple4f.y + this.m02 * tuple4f.z + this.m03 * tuple4f.w, this.m10 * tuple4f.x + this.m11 * tuple4f.y + this.m12 * tuple4f.z + this.m13 * tuple4f.w, this.m20 * tuple4f.x + this.m21 * tuple4f.y + this.m22 * tuple4f.z + this.m23 * tuple4f.w, this.m30 * tuple4f.x + this.m31 * tuple4f.y + this.m32 * tuple4f.z + this.m33 * tuple4f.w);
    }

    public final void transform4(Tuple4f tuple4f) {
        this.transformT2(tuple4f, tuple4f);
    }

    public final void transform2(P3 p3, P3 p32) {
        try {
            p32.set(this.m00 * p3.x + this.m01 * p3.y + this.m02 * p3.z + this.m03, this.m10 * p3.x + this.m11 * p3.y + this.m12 * p3.z + this.m13, this.m20 * p3.x + this.m21 * p3.y + this.m22 * p3.z + this.m23);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public final void transform(P3 p3) {
        this.transform2(p3, p3);
    }

    public final void transformV2(V3 v3, V3 v32) {
        v32.set(this.m00 * v3.x + this.m01 * v3.y + this.m02 * v3.z, this.m10 * v3.x + this.m11 * v3.y + this.m12 * v3.z, this.m20 * v3.x + this.m21 * v3.y + this.m22 * v3.z);
    }

    public final void transformV(V3 v3) {
        this.transformV2(v3, v3);
    }

    public final void setZero() {
        this.m00 = 0.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 0.0f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 0.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 0.0f;
    }

    private void set(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.m00 = f;
        this.m01 = f2;
        this.m02 = f3;
        this.m03 = f4;
        this.m10 = f5;
        this.m11 = f6;
        this.m12 = f7;
        this.m13 = f8;
        this.m20 = f9;
        this.m21 = f10;
        this.m22 = f11;
        this.m23 = f12;
        this.m30 = f13;
        this.m31 = f14;
        this.m32 = f15;
        this.m33 = f16;
    }
}

