/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.io.PrintStream;
import org.jmol.util.Logger;
import org.jmol.util.LoggerInterface;

public class DefaultLogger
implements LoggerInterface {
    protected void log(PrintStream printStream, int n, String string, Throwable throwable) {
        if (printStream == System.err) {
            System.out.flush();
        }
        if (printStream != null && (string != null || throwable != null)) {
            StackTraceElement[] stackTraceElementArray;
            string = string != null ? string : "";
            printStream.println((Logger.logLevel() ? "[" + Logger.getLevel(n) + "] " : "") + string + (throwable != null ? ": " + throwable.toString() : ""));
            if (throwable != null && (stackTraceElementArray = throwable.getStackTrace()) != null) {
                for (int i = 0; i < stackTraceElementArray.length; ++i) {
                    printStream.println(stackTraceElementArray[i].getClassName() + " - " + stackTraceElementArray[i].getLineNumber() + " - " + stackTraceElementArray[i].getMethodName());
                }
            }
        }
        if (printStream == System.err) {
            System.err.flush();
        }
    }

    public void debug(String string) {
        this.log(System.out, 5, string, null);
    }

    public void info(String string) {
        this.log(System.out, 4, string, null);
    }

    public void warn(String string) {
        this.log(System.out, 3, string, null);
    }

    public void warnEx(String string, Throwable throwable) {
        this.log(System.out, 3, string, throwable);
    }

    public void error(String string) {
        this.log(System.err, 2, string, null);
    }

    public void errorEx(String string, Throwable throwable) {
        this.log(System.err, 2, string, throwable);
    }

    public void fatal(String string) {
        this.log(System.err, 1, string, null);
    }

    public void fatalEx(String string, Throwable throwable) {
        this.log(System.err, 1, string, throwable);
    }
}

