/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import org.jmol.util.SB;

public class BitSet32
implements Cloneable {
    private static final int ADDRESS_BITS_PER_WORD = 5;
    private static final int BITS_PER_WORD = 32;
    private static final int WORD_MASK = -1;
    private int[] words;
    private transient int wordsInUse = 0;
    private transient boolean sizeIsSticky = false;
    private static final long serialVersionUID = 7997698588986878753L;
    private static final int[] emptyBitmap = new int[0];

    private static int wordIndex(int n) {
        return n >> 5;
    }

    private void recalculateWordsInUse() {
        int n;
        for (n = this.wordsInUse - 1; n >= 0 && this.words[n] == 0; --n) {
        }
        this.wordsInUse = n + 1;
    }

    public BitSet32() {
        this.initWords(32);
        this.sizeIsSticky = false;
    }

    public static BitSet32 newN(int n) {
        BitSet32 bitSet32 = new BitSet32();
        bitSet32.init(n);
        return bitSet32;
    }

    private void init(int n) {
        if (n < 0) {
            throw new NegativeArraySizeException("nbits < 0: " + n);
        }
        this.initWords(n);
        this.sizeIsSticky = true;
    }

    private void initWords(int n) {
        this.words = new int[BitSet32.wordIndex(n - 1) + 1];
    }

    private void ensureCapacity(int n) {
        if (this.words.length < n) {
            int n2 = Math.max(2 * this.words.length, n);
            this.setLength(n2);
            this.sizeIsSticky = false;
        }
    }

    private void expandTo(int n) {
        int n2 = n + 1;
        if (this.wordsInUse < n2) {
            this.ensureCapacity(n2);
            this.wordsInUse = n2;
        }
    }

    public void set(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n);
        }
        int n2 = BitSet32.wordIndex(n);
        this.expandTo(n2);
        int n3 = n2;
        this.words[n3] = this.words[n3] | 1 << n;
    }

    public void setBitTo(int n, boolean bl) {
        if (bl) {
            this.set(n);
        } else {
            this.clear(n);
        }
    }

    public void setBits(int n, int n2) {
        if (n == n2) {
            return;
        }
        int n3 = BitSet32.wordIndex(n);
        int n4 = BitSet32.wordIndex(n2 - 1);
        this.expandTo(n4);
        int n5 = -1 << n;
        int n6 = -1 >>> -n2;
        if (n3 == n4) {
            int n7 = n3;
            this.words[n7] = this.words[n7] | n5 & n6;
        } else {
            int n8 = n3;
            this.words[n8] = this.words[n8] | n5;
            for (int i = n3 + 1; i < n4; ++i) {
                this.words[i] = -1;
            }
            int n9 = n4;
            this.words[n9] = this.words[n9] | n6;
        }
    }

    public void clear(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n);
        }
        int n2 = BitSet32.wordIndex(n);
        if (n2 >= this.wordsInUse) {
            return;
        }
        int n3 = n2;
        this.words[n3] = this.words[n3] & ~(1 << n);
        this.recalculateWordsInUse();
    }

    public void clearBits(int n, int n2) {
        if (n == n2) {
            return;
        }
        int n3 = BitSet32.wordIndex(n);
        if (n3 >= this.wordsInUse) {
            return;
        }
        int n4 = BitSet32.wordIndex(n2 - 1);
        if (n4 >= this.wordsInUse) {
            n2 = this.length();
            n4 = this.wordsInUse - 1;
        }
        int n5 = -1 << n;
        int n6 = -1 >>> -n2;
        if (n3 == n4) {
            int n7 = n3;
            this.words[n7] = this.words[n7] & ~(n5 & n6);
        } else {
            int n8 = n3;
            this.words[n8] = this.words[n8] & ~n5;
            for (int i = n3 + 1; i < n4; ++i) {
                this.words[i] = 0;
            }
            int n9 = n4;
            this.words[n9] = this.words[n9] & ~n6;
        }
        this.recalculateWordsInUse();
    }

    public void clearAll() {
        while (this.wordsInUse > 0) {
            this.words[--this.wordsInUse] = 0;
        }
    }

    public boolean get(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n);
        }
        int n2 = BitSet32.wordIndex(n);
        return n2 < this.wordsInUse && (this.words[n2] & 1 << n) != 0;
    }

    public int nextSetBit(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n);
        }
        int n2 = BitSet32.wordIndex(n);
        if (n2 >= this.wordsInUse) {
            return -1;
        }
        int n3 = this.words[n2] & -1 << n;
        while (n3 == 0) {
            if (++n2 == this.wordsInUse) {
                return -1;
            }
            n3 = this.words[n2];
        }
        return n2 * 32 + Integer.numberOfTrailingZeros(n3);
    }

    public int nextClearBit(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n);
        }
        int n2 = BitSet32.wordIndex(n);
        if (n2 >= this.wordsInUse) {
            return n;
        }
        int n3 = ~this.words[n2] & -1 << n;
        while (n3 == 0) {
            if (++n2 == this.wordsInUse) {
                return this.wordsInUse * 32;
            }
            n3 = ~this.words[n2];
        }
        return n2 * 32 + Integer.numberOfTrailingZeros(n3);
    }

    public int length() {
        if (this.wordsInUse == 0) {
            return 0;
        }
        return 32 * (this.wordsInUse - 1) + (32 - Integer.numberOfLeadingZeros(this.words[this.wordsInUse - 1]));
    }

    public boolean isEmpty() {
        return this.wordsInUse == 0;
    }

    public boolean intersects(BitSet32 bitSet32) {
        for (int i = Math.min(this.wordsInUse, bitSet32.wordsInUse) - 1; i >= 0; --i) {
            if ((this.words[i] & bitSet32.words[i]) == 0) continue;
            return true;
        }
        return false;
    }

    public int cardinality() {
        int n = 0;
        for (int i = 0; i < this.wordsInUse; ++i) {
            n += Integer.bitCount(this.words[i]);
        }
        return n;
    }

    public void and(BitSet32 bitSet32) {
        if (this == bitSet32) {
            return;
        }
        while (this.wordsInUse > bitSet32.wordsInUse) {
            this.words[--this.wordsInUse] = 0;
        }
        for (int i = 0; i < this.wordsInUse; ++i) {
            int n = i;
            this.words[n] = this.words[n] & bitSet32.words[i];
        }
        this.recalculateWordsInUse();
    }

    public void or(BitSet32 bitSet32) {
        if (this == bitSet32) {
            return;
        }
        int n = Math.min(this.wordsInUse, bitSet32.wordsInUse);
        if (this.wordsInUse < bitSet32.wordsInUse) {
            this.ensureCapacity(bitSet32.wordsInUse);
            this.wordsInUse = bitSet32.wordsInUse;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            this.words[n2] = this.words[n2] | bitSet32.words[i];
        }
        if (n < bitSet32.wordsInUse) {
            System.arraycopy(bitSet32.words, n, this.words, n, this.wordsInUse - n);
        }
    }

    public void xor(BitSet32 bitSet32) {
        int n = Math.min(this.wordsInUse, bitSet32.wordsInUse);
        if (this.wordsInUse < bitSet32.wordsInUse) {
            this.ensureCapacity(bitSet32.wordsInUse);
            this.wordsInUse = bitSet32.wordsInUse;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            this.words[n2] = this.words[n2] ^ bitSet32.words[i];
        }
        if (n < bitSet32.wordsInUse) {
            System.arraycopy(bitSet32.words, n, this.words, n, bitSet32.wordsInUse - n);
        }
        this.recalculateWordsInUse();
    }

    public void andNot(BitSet32 bitSet32) {
        for (int i = Math.min(this.wordsInUse, bitSet32.wordsInUse) - 1; i >= 0; --i) {
            int n = i;
            this.words[n] = this.words[n] & ~bitSet32.words[i];
        }
        this.recalculateWordsInUse();
    }

    public int hashCode() {
        long l = 1234L;
        int n = this.wordsInUse;
        while (--n >= 0) {
            l ^= (long)(this.words[n] * (n + 1));
        }
        return (int)(l >> 32 ^ l);
    }

    public int size() {
        return this.words.length * 32;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BitSet32)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        BitSet32 bitSet32 = (BitSet32)object;
        if (this.wordsInUse != bitSet32.wordsInUse) {
            return false;
        }
        for (int i = 0; i < this.wordsInUse; ++i) {
            if (this.words[i] == bitSet32.words[i]) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        if (!this.sizeIsSticky && this.wordsInUse != this.words.length) {
            this.setLength(this.wordsInUse);
        }
        return BitSet32.copy(this);
    }

    private void setLength(int n) {
        int[] nArray = new int[n];
        System.arraycopy(this.words, 0, nArray, 0, Math.min(this.wordsInUse, n));
        this.words = nArray;
    }

    public String toString() {
        int n = this.wordsInUse > 128 ? this.cardinality() : this.wordsInUse * 32;
        SB sB = SB.newN(6 * n + 2);
        sB.appendC('{');
        int n2 = this.nextSetBit(0);
        if (n2 != -1) {
            sB.appendI(n2);
            n2 = this.nextSetBit(n2 + 1);
            while (n2 >= 0) {
                int n3 = this.nextClearBit(n2);
                do {
                    sB.append(", ").appendI(n2);
                } while (++n2 < n3);
                n2 = this.nextSetBit(n2 + 1);
            }
        }
        sB.appendC('}');
        return sB.toString();
    }

    public static BitSet32 copy(BitSet32 bitSet32) {
        BitSet32 bitSet322 = null;
        bitSet322 = new BitSet32();
        int n = bitSet32.wordsInUse;
        if (n == 0) {
            bitSet322.words = emptyBitmap;
        } else {
            bitSet322.words = new int[n];
            System.arraycopy(bitSet32.words, 0, bitSet322.words, 0, n);
        }
        return bitSet322;
    }

    public int cardinalityN(int n) {
        int n2 = this.cardinality();
        int n3 = this.length();
        while (--n3 >= n) {
            if (!this.get(n3)) continue;
            --n2;
        }
        return n2;
    }
}

