/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.thread;

import org.jmol.thread.JmolThread;
import org.jmol.util.BS;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.P3;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpinThread
extends JmolThread {
    private final TransformManager transformManager;
    private float endDegrees;
    private JmolList<P3> endPositions;
    private float nDegrees;
    private BS bsAtoms;
    private boolean isNav;
    private boolean isGesture;
    private float myFps;
    private float angle;
    private boolean haveNotified;
    private int index;

    public boolean isGesture() {
        return this.isGesture;
    }

    public SpinThread(TransformManager transformManager, Viewer viewer, float f, JmolList<P3> jmolList, BS bS, boolean bl, boolean bl2) {
        this.setViewer(viewer, "SpinThread");
        this.transformManager = transformManager;
        this.endDegrees = Math.abs(f);
        this.endPositions = jmolList;
        this.bsAtoms = bS;
        this.isNav = bl;
        this.isGesture = bl2;
    }

    @Override
    protected void run1(int n) throws InterruptedException {
        while (true) {
            switch (n) {
                case -1: {
                    this.myFps = this.isNav ? this.transformManager.navFps : this.transformManager.spinFps;
                    this.viewer.getGlobalSettings().setB(this.isNav ? "_navigating" : "_spinning", true);
                    this.viewer.startHoverWatcher(false);
                    n = 0;
                    break;
                }
                case 0: {
                    boolean bl;
                    if (this.isReset || this.checkInterrupted()) {
                        n = -2;
                        break;
                    }
                    if (this.isNav && this.myFps != this.transformManager.navFps) {
                        this.myFps = this.transformManager.navFps;
                        this.index = 0;
                        this.startTime = System.currentTimeMillis();
                    } else if (!this.isNav && this.myFps != this.transformManager.spinFps && this.bsAtoms == null) {
                        this.myFps = this.transformManager.spinFps;
                        this.index = 0;
                        this.startTime = System.currentTimeMillis();
                    }
                    if (this.myFps == 0.0f || !(!this.isNav ? this.transformManager.spinOn : this.transformManager.navOn)) {
                        n = -2;
                        break;
                    }
                    boolean bl2 = this.isNav ? this.transformManager.navX != 0.0f || this.transformManager.navY != 0.0f || this.transformManager.navZ != 0.0f : this.transformManager.isSpinInternal && this.transformManager.internalRotationAxis.angle != 0.0f || this.transformManager.isSpinFixed && this.transformManager.fixedRotationAxis.angle != 0.0f || !this.transformManager.isSpinFixed && !this.transformManager.isSpinInternal && (this.transformManager.spinX != 0.0f || this.transformManager.spinY != 0.0f || this.transformManager.spinZ != 0.0f);
                    this.targetTime = (long)((float)(++this.index * 1000) / this.myFps);
                    this.currentTime = System.currentTimeMillis() - this.startTime;
                    this.sleepTime = (int)(this.targetTime - this.currentTime);
                    if (this.sleepTime < 0) {
                        if (!this.haveNotified) {
                            Logger.info("spinFPS is set too fast (" + this.myFps + ") -- can't keep up!");
                        }
                        this.haveNotified = true;
                        this.startTime -= (long)this.sleepTime;
                        this.sleepTime = 0;
                    }
                    boolean bl3 = bl = this.bsAtoms == null && this.viewer.getInMotion();
                    if (bl) {
                        if (this.isGesture) {
                            n = -2;
                            break;
                        }
                        this.sleepTime += 1000;
                    }
                    if (bl2 && !bl && (this.transformManager.spinOn || this.transformManager.navOn)) {
                        this.doTransform();
                    }
                    n = 1;
                    break;
                }
                case 1: {
                    while (!this.checkInterrupted() && !this.viewer.getRefreshing()) {
                        if (this.runSleep(10, 1)) continue;
                        return;
                    }
                    if (this.bsAtoms == null) {
                        this.viewer.refresh(1, "SpinThread:run()");
                    } else {
                        this.viewer.requestRepaintAndWait();
                    }
                    if (!this.isNav && (double)this.nDegrees >= (double)this.endDegrees - 0.001) {
                        this.transformManager.setSpinOff();
                    }
                    if (!this.runSleep(this.sleepTime, 0)) {
                        return;
                    }
                    n = 0;
                    break;
                }
                case -2: {
                    if (this.bsAtoms != null && this.endPositions != null) {
                        this.viewer.setAtomCoords(this.bsAtoms, 1146095626, this.endPositions);
                        this.bsAtoms = null;
                        this.endPositions = null;
                    }
                    if (!this.isReset) {
                        this.transformManager.setSpinOff();
                        this.viewer.startHoverWatcher(true);
                    }
                    this.resumeEval();
                    return;
                }
            }
        }
    }

    private void doTransform() {
        if (this.isNav) {
            this.transformManager.setNavigationOffsetRelative();
        } else if (this.transformManager.isSpinInternal || this.transformManager.isSpinFixed) {
            this.angle = (this.transformManager.isSpinInternal ? this.transformManager.internalRotationAxis : this.transformManager.fixedRotationAxis).angle / this.myFps;
            if (this.transformManager.isSpinInternal) {
                this.transformManager.rotateAxisAngleRadiansInternal(this.angle, this.bsAtoms);
            } else {
                this.transformManager.rotateAxisAngleRadiansFixed(this.angle, this.bsAtoms);
            }
            this.nDegrees = (float)((double)this.nDegrees + Math.abs((double)this.angle * 57.29577951308232));
        } else {
            if (this.transformManager.spinX != 0.0f) {
                this.transformManager.rotateXRadians(this.transformManager.spinX * ((float)Math.PI / 180) / this.myFps, null);
            }
            if (this.transformManager.spinY != 0.0f) {
                this.transformManager.rotateYRadians(this.transformManager.spinY * ((float)Math.PI / 180) / this.myFps, null);
            }
            if (this.transformManager.spinZ != 0.0f) {
                this.transformManager.rotateZRadians(this.transformManager.spinZ * ((float)Math.PI / 180) / this.myFps);
            }
        }
    }
}

