/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import org.jmol.api.JmolRendererInterface;
import org.jmol.shape.Object2d;
import org.jmol.shape.Shape;
import org.jmol.util.C;
import org.jmol.util.Escape;
import org.jmol.util.GData;
import org.jmol.util.JmolFont;
import org.jmol.util.SB;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Viewer;

public class Text
extends Object2d {
    public float fontScale;
    private String text;
    private String textUnformatted;
    public boolean doFormatText;
    public String[] lines;
    public JmolFont font;
    private byte fid;
    private int ascent;
    private int descent;
    private int lineHeight;
    private int textWidth;
    private int textHeight;
    private int[] widths;
    public Object image;
    float imageScale = 1.0f;
    private float xAdj;
    private float yAdj;

    public void setScalePixelsPerMicron(float f) {
        this.fontScale = 0.0f;
        this.scalePixelsPerMicron = f;
    }

    public String getText() {
        return this.text;
    }

    Text() {
    }

    public static Text newLabel(GData gData, JmolFont jmolFont, String string, short s, short s2, int n, float f, float[] fArray) {
        Text text = new Text();
        text.set(gData, jmolFont, s, n, true, f, fArray);
        text.setText(string);
        text.bgcolix = s2;
        return text;
    }

    static Text newEcho(Viewer viewer, GData gData, JmolFont jmolFont, String string, short s, int n, int n2, float f) {
        Text text = new Text();
        text.set(gData, jmolFont, s, n2, false, f, null);
        text.viewer = viewer;
        text.target = string;
        if (string.equals("error")) {
            n = 1;
        }
        text.valign = n;
        text.z = 2;
        text.zSlab = Integer.MIN_VALUE;
        return text;
    }

    private void set(GData gData, JmolFont jmolFont, short s, int n, boolean bl, float f, float[] fArray) {
        this.scalePixelsPerMicron = f;
        this.gdata = gData;
        this.isLabelOrHover = bl;
        this.colix = s;
        this.align = n;
        this.pymolOffset = fArray;
        this.setFont(jmolFont, bl);
    }

    private void getFontMetrics() {
        this.descent = this.font.getDescent();
        this.ascent = this.font.getAscent();
        this.lineHeight = this.ascent + this.descent;
    }

    public void setFontFromFid(byte by) {
        if (this.fid == by) {
            return;
        }
        this.fontScale = 0.0f;
        this.setFont(JmolFont.getFont3D(by), true);
    }

    public void setText(String string) {
        if (this.image != null) {
            this.getFontMetrics();
        }
        this.image = null;
        string = this.fixText(string);
        if (this.text != null && this.text.equals(string)) {
            return;
        }
        this.text = string;
        this.textUnformatted = string;
        boolean bl = this.doFormatText = this.viewer != null && string != null && (string.indexOf("%{") >= 0 || string.indexOf("@{") >= 0);
        if (!this.doFormatText) {
            this.recalc();
        }
    }

    public void setImage(Object object) {
        this.image = object;
        this.recalc();
    }

    public void setScale(float f) {
        this.imageScale = f;
        this.recalc();
    }

    void setFont(JmolFont jmolFont, boolean bl) {
        this.font = jmolFont;
        if (this.font == null) {
            return;
        }
        this.getFontMetrics();
        if (!bl) {
            return;
        }
        this.fid = this.font.fid;
        this.recalc();
    }

    public void setFontScale(float f) {
        if (this.fontScale == f) {
            return;
        }
        this.fontScale = f;
        if (this.fontScale != 0.0f) {
            this.setFont(this.gdata.getFont3DScaled(this.font, f), true);
        }
    }

    String fixText(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return null;
        }
        while ((n = string.indexOf("\n")) >= 0) {
            string = string.substring(0, n) + "|" + string.substring(n + 1);
        }
        return string;
    }

    protected void recalc() {
        if (this.image != null) {
            this.textHeight = 0;
            this.textWidth = 0;
            this.boxWidth = (float)this.viewer.apiPlatform.getImageWidth(this.image) * this.fontScale * this.imageScale;
            this.boxHeight = (float)this.viewer.apiPlatform.getImageHeight(this.image) * this.fontScale * this.imageScale;
            this.ascent = 0;
            return;
        }
        if (this.text == null) {
            this.text = null;
            this.lines = null;
            this.widths = null;
            return;
        }
        if (this.font == null) {
            return;
        }
        this.lines = TextFormat.split(this.text, '|');
        this.textWidth = 0;
        this.widths = new int[this.lines.length];
        int n = this.lines.length;
        while (--n >= 0) {
            this.widths[n] = this.stringWidth(this.lines[n]);
            this.textWidth = Math.max(this.textWidth, this.widths[n]);
        }
        this.textHeight = this.lines.length * this.lineHeight;
        this.boxWidth = this.textWidth + (this.fontScale >= 2.0f ? 16 : 8);
        this.boxHeight = this.textHeight + (this.fontScale >= 2.0f ? 16 : 8);
    }

    public void formatText() {
        this.text = this.viewer == null ? this.textUnformatted : this.viewer.formatText(this.textUnformatted);
        this.recalc();
    }

    public void setPosition(Viewer viewer, JmolRendererInterface jmolRendererInterface, float f, float f2, boolean bl, float[] fArray) {
        int n = jmolRendererInterface.getRenderWidth();
        int n2 = jmolRendererInterface.getRenderHeight();
        if (fArray == null) {
            fArray = this.boxXY;
        } else {
            this.boxXY = fArray;
        }
        this.setWindow(n, n2, f);
        if (f != 0.0f && this.scalePixelsPerMicron != 0.0f) {
            this.setFontScale(f / this.scalePixelsPerMicron);
        } else if (this.fontScale != f2) {
            this.setFontScale(f2);
        }
        if (this.doFormatText) {
            this.formatText();
        }
        float f3 = (float)this.offsetX * f2;
        float f4 = (float)this.offsetY * f2;
        this.xAdj = this.fontScale >= 2.0f ? 8 : 4;
        this.yAdj = (float)(this.ascent - this.lineHeight) + this.xAdj;
        if (this.isLabelOrHover) {
            fArray[0] = this.movableX;
            fArray[1] = this.movableY;
            if (this.pymolOffset != null) {
                boolean bl2;
                float f5 = viewer.scaleToScreen(this.z, 1000);
                this.z -= (int)(this.pymolOffset[3] * f5);
                f5 = viewer.scaleToScreen(this.z, 1000);
                boolean bl3 = bl2 = this.pymolOffset[1] >= -1.0f && this.pymolOffset[1] <= 1.0f && this.pymolOffset[2] >= -1.0f && this.pymolOffset[2] <= 1.0f;
                if (bl2) {
                    f3 = (float)this.textWidth * (this.pymolOffset[1] - 1.0f) / 2.0f;
                    f4 = (float)(-this.textHeight) * ((this.pymolOffset[2] - 1.0f) / 2.0f);
                    f4 += (float)this.descent;
                } else {
                    f3 = this.pymolOffset[1] * f5;
                    f4 = -this.pymolOffset[2] * f5;
                    f4 *= 1.05f;
                    f4 += (float)this.textHeight * 0.66f;
                }
                this.xAdj = this.fontScale >= 2.0f ? 8 : 4;
                this.yAdj = 0.0f;
                fArray[0] = (float)this.movableX - this.xAdj;
                fArray[1] = (float)this.movableY - this.yAdj;
                bl = true;
            }
            Text.setBoxXY(this.boxWidth, this.boxHeight, f3, f4, fArray, bl);
        } else {
            this.setPos(this.fontScale);
        }
        this.boxX = fArray[0];
        this.boxY = fArray[1];
        if (this.adjustForWindow) {
            this.setBoxOffsetsInWindow(0.0f, this.isLabelOrHover ? 16.0f * this.fontScale + (float)this.lineHeight : 0.0f, this.boxY - (float)this.textHeight);
        }
    }

    private void setPos(float f) {
        float f2;
        float f3;
        float f4;
        float f5;
        boolean bl;
        boolean bl2 = bl = this.xyz != null;
        if (this.valign == 0 || this.valign == 4) {
            f5 = this.movableXPercent != Integer.MAX_VALUE ? (float)(this.movableXPercent * this.windowWidth / 100) : (bl ? (float)this.movableX : (float)this.movableX * f);
            float f6 = (float)this.offsetX * f;
            f3 = f4 = f5 + f6;
            f2 = f4;
        } else {
            f2 = 5.0f * f;
            f4 = this.windowWidth / 2;
            f3 = (float)this.windowWidth - f2;
        }
        this.boxXY[0] = f2;
        switch (this.align) {
            case 2: {
                this.boxXY[0] = f4 - this.boxWidth / 2.0f;
                break;
            }
            case 3: {
                this.boxXY[0] = f3 - this.boxWidth;
            }
        }
        this.boxXY[1] = 0.0f;
        switch (this.valign) {
            case 1: {
                break;
            }
            case 3: {
                this.boxXY[1] = this.windowHeight / 2;
                break;
            }
            case 2: {
                this.boxXY[1] = this.windowHeight;
                break;
            }
            default: {
                f5 = this.movableYPercent != Integer.MAX_VALUE ? (float)(this.movableYPercent * this.windowHeight / 100) : (bl ? (float)this.movableY : (float)this.movableY * f);
                this.boxXY[1] = (bl ? f5 : (float)this.windowHeight - f5) + (float)this.offsetY * f;
            }
        }
        if (this.align == 2) {
            this.boxXY[1] = this.boxXY[1] - (this.image != null ? this.boxHeight : (this.xyz != null ? this.boxHeight : (float)this.ascent - this.boxHeight)) / 2.0f;
        } else if (this.image != null) {
            this.boxXY[1] = this.boxXY[1] - 0.0f;
        } else if (this.xyz != null) {
            this.boxXY[1] = this.boxXY[1] - (float)(this.ascent / 2);
        }
    }

    public static void setBoxXY(float f, float f2, float f3, float f4, float[] fArray, boolean bl) {
        float f5;
        if (f3 > 0.0f || bl) {
            f5 = f3;
        } else {
            f5 = -f;
            f5 = f3 == 0.0f ? (f5 /= 2.0f) : (f5 += f3);
        }
        float f6 = bl ? -f2 + f4 : (f4 < 0.0f ? -f2 + f4 : (f4 == 0.0f ? -f2 / 2.0f : f4));
        fArray[0] = fArray[0] + f5;
        fArray[1] = fArray[1] + f6;
        fArray[2] = f;
        fArray[3] = f2;
    }

    public String getState() {
        SB sB = new SB();
        if (this.text == null || this.isLabelOrHover || this.target.equals("error")) {
            return "";
        }
        boolean bl = this.image != null;
        String string = null;
        String string2 = "set echo ID " + Escape.eS(this.target);
        switch (this.valign) {
            case 0: {
                string = this.movableXPercent == Integer.MAX_VALUE || this.movableYPercent == Integer.MAX_VALUE ? (this.movableXPercent == Integer.MAX_VALUE ? this.movableX + " " : this.movableXPercent + "% ") + (this.movableYPercent == Integer.MAX_VALUE ? this.movableY + "" : this.movableYPercent + "%") : "[" + this.movableXPercent + " " + this.movableYPercent + "%]";
            }
            case 4: {
                if (string == null) {
                    string = Escape.eP(this.xyz);
                }
                sB.append("  ").append(string2).append(" ").append(string);
                if (this.align == 1) break;
                sB.append(";  ").append(string2).append(" ").append(hAlignNames[this.align]);
                break;
            }
            default: {
                sB.append("  set echo ").append(vAlignNames[this.valign]).append(" ").append(hAlignNames[this.align]);
            }
        }
        if (this.valign == 0 && this.movableZPercent != Integer.MAX_VALUE) {
            sB.append(";  ").append(string2).append(" depth ").appendI(this.movableZPercent);
        }
        if (bl) {
            sB.append("; ").append(string2).append(" IMAGE /*file*/");
        } else {
            sB.append("; echo ");
        }
        sB.append(Escape.eS(this.text));
        sB.append(";\n");
        if (bl && this.imageScale != 1.0f) {
            sB.append("  ").append(string2).append(" scale ").appendF(this.imageScale).append(";\n");
        }
        if (this.script != null) {
            sB.append("  ").append(string2).append(" script ").append(Escape.eS(this.script)).append(";\n");
        }
        if (this.modelIndex >= 0) {
            sB.append("  ").append(string2).append(" model ").append(this.viewer.getModelNumberDotted(this.modelIndex)).append(";\n");
        }
        sB.append("  " + Shape.getFontCommand("echo", this.font));
        if (this.scalePixelsPerMicron > 0.0f) {
            sB.append(" " + 10000.0f / this.scalePixelsPerMicron);
        }
        sB.append("; color echo");
        if (C.isColixTranslucent(this.colix)) {
            sB.append(" translucent " + C.getColixTranslucencyFractional(this.colix));
        }
        sB.append(" ").append(C.getHexCode(this.colix));
        if (this.bgcolix != 0) {
            sB.append("; color echo background");
            if (C.isColixTranslucent(this.bgcolix)) {
                sB.append(" translucent " + C.getColixTranslucencyFractional(this.bgcolix));
            }
            sB.append(" ").append(C.getHexCode(this.bgcolix));
        }
        sB.append(";\n");
        return sB.toString();
    }

    private int stringWidth(String string) {
        int n = 0;
        int n2 = 1;
        int n3 = 1;
        if (string == null) {
            return 0;
        }
        if (string.indexOf("<su") < 0) {
            return this.font.stringWidth(string);
        }
        int n4 = string.length();
        for (int i = 0; i < n4; ++i) {
            if (string.charAt(i) == '<') {
                String string2;
                if (i + 4 < n4 && ((string2 = string.substring(i, i + 5)).equals("<sub>") || string2.equals("<sup>"))) {
                    i += 4;
                    n2 = n3;
                    continue;
                }
                if (i + 5 < n4 && ((string2 = string.substring(i, i + 6)).equals("</sub>") || string2.equals("</sup>"))) {
                    i += 5;
                    n2 = 1;
                    continue;
                }
            }
            n += this.font.stringWidth(string.substring(i, i + 1)) * n2;
        }
        return n;
    }

    public void setXYA(float[] fArray, int n) {
        if (n == 0) {
            fArray[2] = this.boxX;
            switch (this.align) {
                case 2: {
                    fArray[2] = fArray[2] + this.boxWidth / 2.0f;
                    break;
                }
                case 3: {
                    fArray[2] = fArray[2] + (this.boxWidth - this.xAdj);
                    break;
                }
                default: {
                    fArray[2] = fArray[2] + this.xAdj;
                }
            }
            fArray[0] = fArray[2];
            fArray[1] = this.boxY + this.yAdj;
        }
        switch (this.align) {
            case 2: {
                fArray[0] = fArray[2] - (float)(this.widths[n] / 2);
                break;
            }
            case 3: {
                fArray[0] = fArray[2] - (float)this.widths[n];
            }
        }
        fArray[1] = fArray[1] + (float)this.lineHeight;
    }

    public String getCommand() {
        SB sB = new SB();
        sB.append("label ").append(Escape.eS(this.textUnformatted));
        if (this.pymolOffset == null) {
            return sB.toString();
        }
        sB.append(";set labelOffset ").append(Escape.eAF(this.pymolOffset));
        return sB.toString();
    }
}

