/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.Map;
import org.jmol.atomdata.RadiusData;
import org.jmol.constant.EnumPalette;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Group;
import org.jmol.modelset.ModelSet;
import org.jmol.util.BS;
import org.jmol.util.C;
import org.jmol.util.GData;
import org.jmol.util.JmolFont;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.P3;
import org.jmol.util.P3i;
import org.jmol.util.SB;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Shape {
    public static final float RADIUS_MAX = 4.0f;
    public Viewer viewer;
    public ModelSet modelSet;
    public GData gdata;
    public int shapeID;
    public int myVisibilityFlag;
    protected float translucentLevel;
    public boolean translucentAllowed = true;
    public boolean isBioShape;
    public BS bsSizeSet;
    public BS bsColixSet;

    public Viewer getViewer() {
        return this.viewer;
    }

    public final void initializeShape(Viewer viewer, GData gData, ModelSet modelSet, int n) {
        this.viewer = viewer;
        this.gdata = gData;
        this.shapeID = n;
        this.myVisibilityFlag = JC.getShapeVisibilityFlag(n);
        this.setModelSet(modelSet);
        this.initShape();
    }

    public abstract String getShapeState();

    public int getSize(int n) {
        return 0;
    }

    public int getSizeG(Group group) {
        return 0;
    }

    public void setModelSet(ModelSet modelSet) {
        this.modelSet = modelSet;
        this.initModelSet();
    }

    protected void initModelSet() {
    }

    public void initShape() {
    }

    public void merge(Shape shape) {
    }

    public void setShapeSizeRD(int n, RadiusData radiusData, BS bS) {
        if (radiusData == null) {
            this.setSize(n, bS);
        } else {
            this.setSizeRD(radiusData, bS);
        }
    }

    protected void setSize(int n, BS bS) {
    }

    protected void setSizeRD(RadiusData radiusData, BS bS) {
    }

    public boolean getPropertyData(String string, Object[] objectArray) {
        return false;
    }

    public abstract void setProperty(String var1, Object var2, BS var3);

    protected void setPropS(String string, Object object, BS bS) {
        if (string == "setProperties") {
            if (bS == null) {
                bS = this.viewer.getSelectionSet(false);
            }
            JmolList jmolList = (JmolList)object;
            while (jmolList.size() > 0) {
                Object[] objectArray = (Object[])jmolList.remove(0);
                this.setProperty(((String)objectArray[0]).intern(), objectArray[1], bS);
            }
            return;
        }
        if (string == "translucentLevel") {
            this.translucentLevel = ((Float)object).floatValue();
            return;
        }
        if (string == "refreshTrajectories") {
            return;
        }
        Logger.warn("unassigned " + JC.shapeClassBases[this.shapeID] + " + shape setProperty:" + string + ":" + object);
    }

    public Object getProperty(String string, int n) {
        return null;
    }

    public int getIndexFromName(String string) {
        return -1;
    }

    public boolean wasClicked(int n, int n2) {
        return false;
    }

    public void findNearestAtomIndex(int n, int n2, Atom[] atomArray, BS bS) {
    }

    public void checkBoundsMinMax(P3 p3, P3 p32) {
    }

    public void setModelClickability() {
    }

    public Map<String, Object> checkObjectClicked(int n, int n2, int n3, BS bS, boolean bl) {
        return null;
    }

    public boolean checkObjectHovered(int n, int n2, BS bS) {
        return false;
    }

    public boolean checkObjectDragged(int n, int n2, int n3, int n4, int n5, BS bS) {
        return false;
    }

    protected int coordinateInRange(int n, int n2, P3 p3, int n3, P3i p3i) {
        this.viewer.transformPtScr(p3, p3i);
        int n4 = (n - p3i.x) * (n - p3i.x) + (n2 - p3i.y) * (n2 - p3i.y);
        return n4 < n3 ? n4 : -1;
    }

    public short getColixI(short s, byte by, int n) {
        return this.getColixA(s, by, this.modelSet.atoms[n]);
    }

    protected short getColixA(short s, byte by, Atom atom) {
        return s == 2 ? this.viewer.getColixAtomPalette(atom, by) : s;
    }

    protected short getColixB(short s, int n, Bond bond) {
        return s == 2 ? this.viewer.getColixBondPalette(bond, n) : s;
    }

    public JmolList<Map<String, Object>> getShapeDetail() {
        return null;
    }

    public void setVisibilityFlags(BS bS) {
    }

    public static short getColix(short[] sArray, int n, Atom atom) {
        return C.getColixInherited(sArray == null || n >= sArray.length ? (short)0 : sArray[n], atom.getColix());
    }

    public static String getFontCommand(String string, JmolFont jmolFont) {
        if (jmolFont == null) {
            return "";
        }
        return "font " + string + " " + jmolFont.fontSizeNominal + " " + jmolFont.fontFace + " " + jmolFont.fontStyle;
    }

    public static String getColorCommandUnk(String string, short s, boolean bl) {
        return Shape.getColorCommand(string, EnumPalette.UNKNOWN.id, s, bl);
    }

    public static String getColorCommand(String string, byte by, short s, boolean bl) {
        if (by == EnumPalette.UNKNOWN.id && s == 0) {
            return "";
        }
        String string2 = by == EnumPalette.UNKNOWN.id && s == 0 ? "" : (bl ? Shape.getTranslucentLabel(s) + " " : "") + (by != EnumPalette.UNKNOWN.id && !EnumPalette.isPaletteVariable(by) ? EnumPalette.getPaletteName(by) : Shape.encodeColor(s));
        return "color " + string + " " + string2;
    }

    public static String encodeColor(short s) {
        return C.isColixColorInherited(s) ? "none" : C.getHexCode(s);
    }

    public static String getTranslucentLabel(short s) {
        return C.isColixTranslucent(s) ? "translucent " + C.getColixTranslucencyFractional(s) : "opaque";
    }

    protected static void appendCmd(SB sB, String string) {
        if (string.length() == 0) {
            return;
        }
        sB.append("  ").append(string).append(";\n");
    }
}

