/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.Hashtable;
import java.util.Map;
import org.jmol.api.SymmetryInterface;
import org.jmol.script.T;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Escape;
import org.jmol.util.JmolList;
import org.jmol.util.Matrix3f;
import org.jmol.util.Matrix4f;
import org.jmol.util.Measure;
import org.jmol.util.MeshSurface;
import org.jmol.util.Normix;
import org.jmol.util.P3;
import org.jmol.util.P4;
import org.jmol.util.Quaternion;
import org.jmol.util.SB;
import org.jmol.util.Tuple3f;
import org.jmol.util.V3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mesh
extends MeshSurface {
    public static final String PREVIOUS_MESH_ID = "+PREVIOUS_MESH+";
    public String[] title;
    public short meshColix;
    public short[] normixes;
    public JmolList<P3[]> lineData;
    public String thisID;
    public boolean isValid = true;
    public String scriptCommand;
    public String colorCommand;
    public P3 lattice;
    public boolean visible = true;
    public int lighting = 1073741958;
    public float scale = 1.0f;
    public boolean haveXyPoints;
    public int diameter;
    public float width;
    public final P3 ptCenter = P3.new3(0.0f, 0.0f, 0.0f);
    public Mesh linkedMesh;
    public Map<String, BS> vertexColorMap;
    public int color;
    public SymmetryInterface unitCell;
    public float scale3d = 0.0f;
    public int index;
    public int atomIndex = -1;
    public int modelIndex = -1;
    public int visibilityFlags;
    public boolean insideOut;
    public int checkByteCount;
    public boolean showContourLines = false;
    public boolean showPoints = false;
    public boolean drawTriangles = false;
    public boolean fillTriangles = true;
    public boolean showTriangles = false;
    public boolean frontOnly = false;
    public boolean isTwoSided = true;
    public boolean havePlanarContours = false;
    private BS bsTemp;
    public final V3 vAB = new V3();
    public final V3 vAC = new V3();
    public final V3 vTemp = new V3();
    public boolean colorDensity;
    public Object cappingObject;
    public Object slabbingObject;
    public int[] connections;
    public boolean recalcAltVertices;

    public void setVisibilityFlags(int n) {
        this.visibilityFlags = n;
    }

    public Mesh mesh1(String string, short s, int n) {
        if (PREVIOUS_MESH_ID.equals(string)) {
            string = null;
        }
        this.thisID = string;
        this.colix = s;
        this.index = n;
        return this;
    }

    public void clear(String string) {
        this.altVertices = null;
        this.bsDisplay = null;
        this.bsSlabDisplay = null;
        this.bsSlabGhost = null;
        this.cappingObject = null;
        this.colix = (short)23;
        this.colorDensity = false;
        this.connections = null;
        this.diameter = 0;
        this.drawTriangles = false;
        this.fillTriangles = true;
        this.frontOnly = false;
        this.havePlanarContours = false;
        this.haveXyPoints = false;
        this.isTriangleSet = false;
        this.isTwoSided = false;
        this.lattice = null;
        this.mat4 = null;
        this.normixes = null;
        this.scale3d = 0.0f;
        this.polygonIndexes = null;
        this.scale = 1.0f;
        this.showContourLines = false;
        this.showPoints = false;
        this.showTriangles = false;
        this.slabbingObject = null;
        this.slabOptions = null;
        this.title = null;
        this.unitCell = null;
        this.polygonCount = 0;
        this.vertexCount = 0;
        this.polygonCount0 = 0;
        this.vertexCount0 = 0;
        this.vertices = null;
        this.spanningVectors = null;
        this.meshType = string;
    }

    public void initialize(int n, P3[] p3Array, P4 p4) {
        if (p3Array == null) {
            p3Array = this.vertices;
        }
        V3[] v3Array = this.getNormals(p3Array, p4);
        this.setNormixes(v3Array);
        this.lighting = 1073741958;
        if (this.insideOut) {
            this.invertNormixes();
        }
        this.setLighting(n);
    }

    public void setNormixes(V3[] v3Array) {
        this.normixes = new short[this.normixCount];
        if (this.bsTemp == null) {
            this.bsTemp = Normix.newVertexBitSet();
        }
        if (this.haveXyPoints) {
            int n = this.normixCount;
            while (--n >= 0) {
                this.normixes[n] = 9999;
            }
        } else {
            int n = this.normixCount;
            while (--n >= 0) {
                this.normixes[n] = Normix.getNormixV(v3Array[n], this.bsTemp);
            }
        }
    }

    public V3[] getNormals(P3[] p3Array, P4 p4) {
        this.normixCount = this.isTriangleSet ? this.polygonCount : this.vertexCount;
        V3[] v3Array = new V3[this.normixCount];
        int n = this.normixCount;
        while (--n >= 0) {
            v3Array[n] = new V3();
        }
        if (p4 == null) {
            this.sumVertexNormals(p3Array, v3Array);
        } else {
            V3 v3 = V3.new3(p4.x, p4.y, p4.z);
            int n2 = this.normixCount;
            while (--n2 >= 0) {
                v3Array[n2] = v3;
            }
        }
        if (!this.isTriangleSet) {
            int n3 = this.normixCount;
            while (--n3 >= 0) {
                v3Array[n3].normalize();
            }
        }
        return v3Array;
    }

    public void setLighting(int n) {
        boolean bl = this.isTwoSided = n == 1073741964;
        if (n == this.lighting) {
            return;
        }
        this.flipLighting(this.lighting);
        this.lighting = n;
        this.flipLighting(this.lighting);
    }

    private void flipLighting(int n) {
        if (n == 1073741964) {
            int n2 = this.normixCount;
            while (--n2 >= 0) {
                this.normixes[n2] = ~this.normixes[n2];
            }
        } else if (n == 1073741958 == this.insideOut) {
            this.invertNormixes();
        }
    }

    private void invertNormixes() {
        Normix.setInverseNormixes();
        int n = this.normixCount;
        while (--n >= 0) {
            this.normixes[n] = Normix.getInverseNormix(this.normixes[n]);
        }
    }

    public void setTranslucent(boolean bl, float f) {
        this.colix = C.getColixTranslucent3(this.colix, bl, f);
    }

    protected void sumVertexNormals(P3[] p3Array, V3[] v3Array) {
        this.sumVertexNormals2(p3Array, v3Array);
    }

    protected void sumVertexNormals2(P3[] p3Array, V3[] v3Array) {
        int n = this.checkByteCount;
        float f = this.getMinDistance2ForVertexGrouping();
        int n2 = this.polygonCount;
        while (--n2 >= 0) {
            try {
                if (!this.setABC(n2)) continue;
                P3 p3 = p3Array[this.iA];
                P3 p32 = p3Array[this.iB];
                P3 p33 = p3Array[this.iC];
                if (p3.distanceSquared(p32) < f || p32.distanceSquared(p33) < f || p3.distanceSquared(p33) < f) continue;
                Measure.calcNormalizedNormal(p3, p32, p33, this.vTemp, this.vAB, this.vAC);
                if (this.isTriangleSet) {
                    v3Array[n2].setT(this.vTemp);
                    continue;
                }
                float f2 = this.vTemp.length();
                if (!((double)f2 > 0.9) || !((double)f2 < 1.1)) continue;
                int n3 = this.polygonIndexes[n2].length - n;
                while (--n3 >= 0) {
                    int n4 = this.polygonIndexes[n2][n3];
                    v3Array[n4].add(this.vTemp);
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }

    protected float getMinDistance2ForVertexGrouping() {
        return 1.0E-8f;
    }

    public String getState(String string) {
        SB sB = new SB();
        sB.append(string);
        if (!string.equals("mo")) {
            sB.append(" ID ").append(Escape.eS(this.thisID));
        }
        if (this.lattice != null) {
            sB.append(" lattice ").append(Escape.eP(this.lattice));
        }
        if (this.meshColix != 0) {
            sB.append(" color mesh ").append(C.getHexCode(this.meshColix));
        }
        sB.append(this.getRendering());
        if (!this.visible) {
            sB.append(" hidden");
        }
        if (this.bsDisplay != null) {
            sB.append(";\n  ").append(string);
            if (!string.equals("mo")) {
                sB.append(" ID ").append(Escape.eS(this.thisID));
            }
            sB.append(" display " + Escape.eBS(this.bsDisplay));
        }
        return sB.toString();
    }

    protected String getRendering() {
        SB sB = new SB();
        sB.append(this.fillTriangles ? " fill" : " noFill");
        sB.append(this.drawTriangles ? " mesh" : " noMesh");
        sB.append(this.showPoints ? " dots" : " noDots");
        sB.append(this.frontOnly ? " frontOnly" : " notFrontOnly");
        if (this.showContourLines) {
            sB.append(" contourlines");
        }
        if (this.showTriangles) {
            sB.append(" triangles");
        }
        sB.append(" ").append(T.nameOf(this.lighting));
        return sB.toString();
    }

    public P3[] getOffsetVertices(P4 p4) {
        if (this.altVertices != null && !this.recalcAltVertices) {
            return (P3[])this.altVertices;
        }
        this.altVertices = new P3[this.vertexCount];
        for (int i = 0; i < this.vertexCount; ++i) {
            this.altVertices[i] = P3.newP(this.vertices[i]);
        }
        V3 v3 = null;
        float f = 0.0f;
        if (this.scale3d != 0.0f && this.vertexValues != null && p4 != null) {
            v3 = V3.new3(p4.x, p4.y, p4.z);
            v3.normalize();
            v3.scale(this.scale3d);
            if (this.mat4 != null) {
                Matrix3f matrix3f = new Matrix3f();
                this.mat4.getRotationScale(matrix3f);
                matrix3f.transform(v3);
            }
        }
        for (int i = 0; i < this.vertexCount; ++i) {
            if (this.vertexValues != null && Float.isNaN(f = this.vertexValues[i])) continue;
            if (this.mat4 != null) {
                this.mat4.transform((P3)this.altVertices[i]);
            }
            P3 p3 = (P3)this.altVertices[i];
            if (v3 == null || f == 0.0f) continue;
            p3.scaleAdd2(f, v3, p3);
        }
        this.initialize(this.lighting, (P3[])this.altVertices, null);
        this.recalcAltVertices = false;
        return (P3[])this.altVertices;
    }

    public void setShowWithin(JmolList<P3> jmolList, float f, boolean bl) {
        if (jmolList.size() == 0) {
            this.bsDisplay = bl ? BSUtil.newBitSet2(0, this.vertexCount) : null;
            return;
        }
        this.bsDisplay = new BS();
        for (int i = 0; i < this.vertexCount; ++i) {
            if (!Mesh.checkWithin(this.vertices[i], jmolList, f, bl)) continue;
            this.bsDisplay.set(i);
        }
    }

    public static boolean checkWithin(P3 p3, JmolList<P3> jmolList, float f, boolean bl) {
        if (jmolList.size() != 0) {
            int n = jmolList.size();
            while (--n >= 0) {
                if (!(p3.distanceSquared((P3)jmolList.get(n)) <= f)) continue;
                return !bl;
            }
        }
        return bl;
    }

    public int getVertexIndexFromNumber(int n) {
        if (--n < 0) {
            n = this.vertexCount + n;
        }
        return this.vertexCount <= n ? this.vertexCount - 1 : (n < 0 ? 0 : n);
    }

    public BS getVisibleVertexBitSet() {
        return this.getVisibleVBS();
    }

    protected BS getVisibleVBS() {
        BS bS = new BS();
        if (this.polygonCount == 0 && this.bsSlabDisplay != null) {
            BSUtil.copy2(this.bsSlabDisplay, bS);
        } else {
            int n = this.polygonCount;
            while (--n >= 0) {
                int[] nArray;
                if (this.bsSlabDisplay != null && !this.bsSlabDisplay.get(n) || (nArray = this.polygonIndexes[n]) == null) continue;
                bS.set(nArray[0]);
                bS.set(nArray[1]);
                bS.set(nArray[2]);
            }
        }
        return bS;
    }

    BS getVisibleGhostBitSet() {
        BS bS = new BS();
        if (this.polygonCount == 0 && this.bsSlabGhost != null) {
            BSUtil.copy2(this.bsSlabGhost, bS);
        } else {
            int n = this.polygonCount;
            while (--n >= 0) {
                int[] nArray;
                if (this.bsSlabGhost != null && !this.bsSlabGhost.get(n) || (nArray = this.polygonIndexes[n]) == null) continue;
                bS.set(nArray[0]);
                bS.set(nArray[1]);
                bS.set(nArray[2]);
            }
        }
        return bS;
    }

    public void setTokenProperty(int n, boolean bl) {
        switch (n) {
            case 0x40000088: 
            case 1073742058: {
                this.frontOnly = n == 0x40000088 ? bl : !bl;
                return;
            }
            case 1073741862: 
            case 1073741958: 
            case 1073741964: {
                this.setLighting(n);
                return;
            }
            case 1073742042: 
            case 1113198595: {
                this.showPoints = n == 1113198595 ? bl : !bl;
                return;
            }
            case 1073742018: 
            case 0x400000E4: {
                this.drawTriangles = n == 1073742018 ? bl : !bl;
                return;
            }
            case 1073741938: 
            case 1073742046: {
                this.fillTriangles = n == 1073741938 ? bl : !bl;
                return;
            }
            case 1073742060: 
            case 1073742182: {
                this.showTriangles = n == 1073742182 ? bl : !bl;
                return;
            }
            case 0x4000004A: 
            case 1073742039: {
                this.showContourLines = n == 0x4000004A ? bl : !bl;
                return;
            }
        }
    }

    Object getInfo(boolean bl) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("id", this.thisID);
        hashtable.put("vertexCount", this.vertexCount);
        hashtable.put("polygonCount", this.polygonCount);
        hashtable.put("haveQuads", this.haveQuads);
        hashtable.put("haveValues", this.vertexValues != null);
        if (this.vertexCount > 0 && bl) {
            hashtable.put("vertices", ArrayUtil.arrayCopyPt(this.vertices, this.vertexCount));
        }
        if (this.vertexValues != null && bl) {
            hashtable.put("vertexValues", ArrayUtil.arrayCopyF(this.vertexValues, this.vertexCount));
        }
        if (this.polygonCount > 0 && bl) {
            hashtable.put("polygons", ArrayUtil.arrayCopyII(this.polygonIndexes, this.polygonCount));
        }
        return hashtable;
    }

    public P3[] getBoundingBox() {
        return null;
    }

    public SymmetryInterface getUnitCell() {
        return null;
    }

    public void rotateTranslate(Quaternion quaternion, Tuple3f tuple3f, boolean bl) {
        if (quaternion == null && tuple3f == null) {
            this.mat4 = null;
            return;
        }
        Matrix3f matrix3f = new Matrix3f();
        V3 v3 = new V3();
        if (this.mat4 == null) {
            this.mat4 = new Matrix4f();
            this.mat4.setIdentity();
        }
        this.mat4.getRotationScale(matrix3f);
        this.mat4.get(v3);
        if (quaternion == null) {
            if (bl) {
                v3.setT(tuple3f);
            } else {
                v3.add(tuple3f);
            }
        } else {
            matrix3f.mul(quaternion.getMatrix());
        }
        this.mat4 = Matrix4f.newMV(matrix3f, v3);
        this.recalcAltVertices = true;
    }

    public V3[] getNormalsTemp() {
        V3[] v3Array;
        if (this.normalsTemp == null) {
            this.normalsTemp = this.getNormals(this.vertices, null);
            v3Array = this.normalsTemp;
        } else {
            v3Array = this.normalsTemp;
        }
        return v3Array;
    }
}

