/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.jmol.api.JmolParallelProcessor;
import org.jmol.api.JmolScriptEvaluator;
import org.jmol.api.JmolScriptFunction;
import org.jmol.api.MinimizerInterface;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.RadiusData;
import org.jmol.constant.EnumAnimationMode;
import org.jmol.constant.EnumPalette;
import org.jmol.constant.EnumStereoMode;
import org.jmol.constant.EnumStructure;
import org.jmol.constant.EnumVdw;
import org.jmol.i18n.GT;
import org.jmol.io.JmolBinary;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomCollection;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Group;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.MeasurementData;
import org.jmol.modelset.ModelCollection;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.TickInfo;
import org.jmol.script.ContextToken;
import org.jmol.script.SV;
import org.jmol.script.ScriptCompiler;
import org.jmol.script.ScriptContext;
import org.jmol.script.ScriptException;
import org.jmol.script.ScriptFunction;
import org.jmol.script.ScriptInterruption;
import org.jmol.script.ScriptMathProcessor;
import org.jmol.script.T;
import org.jmol.shape.Object2d;
import org.jmol.util.ArrayUtil;
import org.jmol.util.AxisAngle4f;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.BoxInfo;
import org.jmol.util.C;
import org.jmol.util.ColorEncoder;
import org.jmol.util.ColorUtil;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.GData;
import org.jmol.util.JmolEdge;
import org.jmol.util.JmolFont;
import org.jmol.util.JmolList;
import org.jmol.util.JmolNode;
import org.jmol.util.Logger;
import org.jmol.util.Matrix3f;
import org.jmol.util.Matrix4f;
import org.jmol.util.Measure;
import org.jmol.util.MeshSurface;
import org.jmol.util.P3;
import org.jmol.util.P4;
import org.jmol.util.Parser;
import org.jmol.util.Point3fi;
import org.jmol.util.Quaternion;
import org.jmol.util.SB;
import org.jmol.util.TextFormat;
import org.jmol.util.Tuple3f;
import org.jmol.util.Tuple4f;
import org.jmol.util.V3;
import org.jmol.viewer.ActionManager;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JC;
import org.jmol.viewer.ShapeManager;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptEvaluator
implements JmolScriptEvaluator {
    private boolean allowJSThreads = true;
    private boolean listCommands;
    private boolean isJS;
    private boolean tQuiet;
    protected boolean chk;
    private boolean isCmdLine_C_Option;
    protected boolean isCmdLine_c_or_C_Option;
    private boolean historyDisabled;
    protected boolean logMessages;
    private boolean debugScript;
    private boolean executionStopped;
    private boolean executionPaused;
    private boolean executionStepping;
    private boolean executing;
    private long timeBeginExecution;
    private long timeEndExecution;
    private boolean mustResumeEval;
    private static final String EXPRESSION_KEY = "e_x_p_r_e_s_s_i_o_n";
    ShapeManager sm;
    private static final int scriptLevelMax = 100;
    private Thread currentThread = Thread.currentThread();
    protected Viewer viewer;
    protected ScriptCompiler compiler;
    private Map<String, Object> definedAtomSets;
    private SB outputBuffer;
    private String contextPath = "";
    private String scriptFileName;
    private String functionName;
    private boolean isStateScript;
    private int scriptLevel;
    private int scriptReportingLevel = 0;
    private int commandHistoryLevelMax = 0;
    private T[][] aatoken;
    private short[] lineNumbers;
    private int[][] lineIndices;
    private Map<String, SV> contextVariables;
    private String script;
    protected int pc;
    private String thisCommand;
    private String fullCommand;
    private T[] st;
    private int slen;
    private int iToken;
    private int lineEnd;
    private int pcEnd;
    private String scriptExtensions;
    private boolean forceNoAddHydrogens;
    private JmolParallelProcessor parallelProcessor;
    static int tryPt;
    private ScriptContext thisContext;
    private boolean error;
    private String errorMessage;
    protected String errorMessageUntranslated;
    protected String errorType;
    protected int iCommandError;
    private boolean ignoreError;
    static final int ERROR_axisExpected = 0;
    static final int ERROR_backgroundModelError = 1;
    static final int ERROR_badArgumentCount = 2;
    static final int ERROR_badMillerIndices = 3;
    static final int ERROR_badRGBColor = 4;
    static final int ERROR_booleanExpected = 5;
    static final int ERROR_booleanOrNumberExpected = 6;
    static final int ERROR_booleanOrWhateverExpected = 7;
    static final int ERROR_colorExpected = 8;
    static final int ERROR_colorOrPaletteRequired = 9;
    static final int ERROR_commandExpected = 10;
    static final int ERROR_coordinateOrNameOrExpressionRequired = 11;
    static final int ERROR_drawObjectNotDefined = 12;
    static final int ERROR_endOfStatementUnexpected = 13;
    static final int ERROR_expressionExpected = 14;
    static final int ERROR_expressionOrIntegerExpected = 15;
    static final int ERROR_filenameExpected = 16;
    static final int ERROR_fileNotFoundException = 17;
    static final int ERROR_incompatibleArguments = 18;
    static final int ERROR_insufficientArguments = 19;
    static final int ERROR_integerExpected = 20;
    static final int ERROR_integerOutOfRange = 21;
    static final int ERROR_invalidArgument = 22;
    static final int ERROR_invalidParameterOrder = 23;
    static final int ERROR_keywordExpected = 24;
    static final int ERROR_moCoefficients = 25;
    static final int ERROR_moIndex = 26;
    static final int ERROR_moModelError = 27;
    static final int ERROR_moOccupancy = 28;
    static final int ERROR_moOnlyOne = 29;
    static final int ERROR_multipleModelsDisplayedNotOK = 30;
    static final int ERROR_noData = 31;
    static final int ERROR_noPartialCharges = 32;
    static final int ERROR_noUnitCell = 33;
    static final int ERROR_numberExpected = 34;
    static final int ERROR_numberMustBe = 35;
    static final int ERROR_numberOutOfRange = 36;
    static final int ERROR_objectNameExpected = 37;
    static final int ERROR_planeExpected = 38;
    static final int ERROR_propertyNameExpected = 39;
    static final int ERROR_spaceGroupNotFound = 40;
    static final int ERROR_stringExpected = 41;
    static final int ERROR_stringOrIdentifierExpected = 42;
    static final int ERROR_tooManyPoints = 43;
    static final int ERROR_tooManyScriptLevels = 44;
    static final int ERROR_unrecognizedAtomProperty = 45;
    static final int ERROR_unrecognizedBondProperty = 46;
    static final int ERROR_unrecognizedCommand = 47;
    static final int ERROR_unrecognizedExpression = 48;
    static final int ERROR_unrecognizedObject = 49;
    static final int ERROR_unrecognizedParameter = 50;
    static final int ERROR_unrecognizedParameterWarning = 51;
    static final int ERROR_unrecognizedShowParameter = 52;
    static final int ERROR_what = 53;
    static final int ERROR_writeWhat = 54;
    static final int ERROR_multipleModelsNotOK = 55;
    static final int ERROR_cannotSet = 56;
    private T[] tempStatement;
    private boolean isBondSet;
    private Object expressionResult;
    private int theTok;
    private T theToken;
    private boolean coordinatesAreFractional;
    private P3 fractionalPoint;
    static int iProcess;
    private Object[] data;

    @Override
    public boolean getAllowJSThreads() {
        return this.allowJSThreads;
    }

    @Override
    public JmolScriptEvaluator setViewer(Viewer viewer) {
        this.viewer = viewer;
        this.compiler = this.compiler == null ? (ScriptCompiler)viewer.compiler : this.compiler;
        this.isJS = viewer.isSingleThreaded;
        this.definedAtomSets = viewer.definedAtomSets;
        return this;
    }

    @Override
    public void setCompiler() {
        this.compiler = new ScriptCompiler(this.viewer);
        this.viewer.compiler = this.compiler;
    }

    @Override
    public boolean compileScriptString(String string, boolean bl) {
        this.clearState(bl);
        this.contextPath = "[script]";
        return this.compileScript(null, string, this.debugScript);
    }

    @Override
    public boolean compileScriptFile(String string, boolean bl) {
        this.clearState(bl);
        this.contextPath = string;
        return this.compileScriptFileInternal(string, null, null, null);
    }

    @Override
    public void evaluateCompiledScript(boolean bl, boolean bl2, boolean bl3, boolean bl4, SB sB, boolean bl5) {
        boolean bl6 = this.isCmdLine_C_Option;
        this.isCmdLine_C_Option = bl2;
        this.executionPaused = false;
        this.executionStopped = false;
        this.executionStepping = false;
        this.executing = true;
        this.chk = this.isCmdLine_c_or_C_Option = bl;
        this.timeBeginExecution = System.currentTimeMillis();
        this.historyDisabled = bl3;
        this.outputBuffer = sB;
        this.currentThread = Thread.currentThread();
        this.allowJSThreads = bl5;
        this.listCommands = bl4;
        this.startEval();
        this.isCmdLine_C_Option = bl6;
        this.viewer.setStateScriptVersion(null);
    }

    private Object[] createFunction(String string, String string2, String string3) {
        ScriptEvaluator scriptEvaluator = new ScriptEvaluator();
        scriptEvaluator.setViewer(this.viewer);
        try {
            scriptEvaluator.compileScript(null, "function " + string + "(" + string2 + ") { return " + string3 + "}", false);
            JmolList<SV> jmolList = new JmolList<SV>();
            for (int i = 0; i < string2.length(); i += 2) {
                jmolList.addLast(SV.newVariable(3, Float.valueOf(0.0f)).setName(string2.substring(i, i + 1)));
            }
            return new Object[]{scriptEvaluator.aatoken[0][1].value, jmolList};
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean useThreads() {
        return !this.viewer.autoExit && this.viewer.haveDisplay && this.outputBuffer == null;
    }

    private void startEval() {
        this.viewer.pushHoldRepaintWhy("runEval");
        this.setScriptExtensions();
        this.executeCommands(false);
    }

    private void executeCommands(boolean bl) {
        boolean bl2 = false;
        try {
            if (!this.dispatchCommands(false, false)) {
                return;
            }
        }
        catch (Error error) {
            this.viewer.handleError(error, false);
            this.setErrorMessage("" + error + " " + this.viewer.getShapeErrorState());
            this.errorMessageUntranslated = "" + error;
            this.scriptStatusOrBuffer(this.errorMessage);
            bl2 = true;
        }
        catch (ScriptException scriptException) {
            if (scriptException instanceof ScriptInterruption) {
                return;
            }
            if (bl) {
                this.viewer.setStringProperty("_errormessage", "" + scriptException);
                return;
            }
            this.setErrorMessage(scriptException.toString());
            this.errorMessageUntranslated = scriptException.getErrorMessageUntranslated();
            this.scriptStatusOrBuffer(this.errorMessage);
            this.viewer.notifyError(this.errorMessage != null && this.errorMessage.indexOf("java.lang.OutOfMemoryError") >= 0 ? "Error" : "ScriptException", this.errorMessage, this.errorMessageUntranslated);
            bl2 = true;
        }
        if (bl2 || !this.isJS || !this.allowJSThreads) {
            this.viewer.setTainted(true);
            this.viewer.popHoldRepaintWhy("runEval");
        }
        this.timeEndExecution = System.currentTimeMillis();
        if (this.errorMessage == null && this.executionStopped) {
            this.setErrorMessage("execution interrupted");
        } else if (!this.tQuiet && !this.chk) {
            this.viewer.scriptStatus("Script completed");
        }
        this.historyDisabled = false;
        this.isCmdLine_c_or_C_Option = false;
        this.chk = false;
        this.executing = false;
        String string = this.getErrorMessageUntranslated();
        this.viewer.setErrorMessage(this.errorMessage, string);
        if (!this.tQuiet) {
            this.viewer.setScriptStatus("Jmol script terminated", this.errorMessage, 1 + this.getExecutionWalltime(), string);
        }
    }

    @Override
    public void resumeEval(ScriptContext scriptContext) {
        this.setErrorMessage(null);
        if (this.executionStopped || scriptContext == null || !scriptContext.mustResumeEval) {
            this.viewer.setTainted(true);
            this.viewer.popHoldRepaintWhy("runEval");
            this.viewer.queueOnHold = false;
            return;
        }
        if (!this.executionPaused) {
            ++scriptContext.pc;
        }
        this.thisContext = scriptContext;
        if (scriptContext.scriptLevel > 0) {
            this.scriptLevel = scriptContext.scriptLevel - 1;
        }
        this.restoreScriptContext(scriptContext, true, false, false);
        this.executeCommands(scriptContext.isTryCatch);
    }

    @Override
    public void runScriptBuffer(String string, SB sB) throws ScriptException {
        this.pushContext(null);
        this.contextPath = this.contextPath + " >> script() ";
        this.outputBuffer = sB;
        this.allowJSThreads = false;
        if (this.compileScript(null, string + "\u0001## EDITOR_IGNORE ##", false)) {
            this.dispatchCommands(false, false);
        }
        this.popContext(false, false);
    }

    @Override
    public ScriptContext checkScriptSilent(String string) {
        ScriptContext scriptContext = this.compiler.compile(null, string, false, true, false, true);
        if (scriptContext.errorType != null) {
            return scriptContext;
        }
        this.restoreScriptContext(scriptContext, false, false, false);
        this.chk = true;
        this.isCmdLine_C_Option = false;
        this.isCmdLine_c_or_C_Option = false;
        this.pc = 0;
        try {
            this.dispatchCommands(false, false);
        }
        catch (ScriptException scriptException) {
            this.setErrorMessage(scriptException.toString());
            scriptContext = this.getScriptContext();
        }
        this.chk = false;
        return scriptContext;
    }

    static SB getContextTrace(ScriptContext scriptContext, SB sB, boolean bl) {
        if (sB == null) {
            sB = new SB();
        }
        sB.append(ScriptEvaluator.setErrorLineMessage(scriptContext.functionName, scriptContext.scriptFileName, scriptContext.lineNumbers[scriptContext.pc], scriptContext.pc, ScriptEvaluator.statementAsString(scriptContext.statement, bl ? scriptContext.iToken : 9999, false)));
        if (scriptContext.parentContext != null) {
            ScriptEvaluator.getContextTrace(scriptContext.parentContext, sB, false);
        }
        return sB;
    }

    @Override
    public void setDebugging() {
        this.debugScript = this.viewer.getBoolean(603979824);
        this.logMessages = this.debugScript && Logger.debugging;
    }

    private int getExecutionWalltime() {
        return (int)(this.timeEndExecution - this.timeBeginExecution);
    }

    @Override
    public void haltExecution() {
        this.resumePausedExecution();
        this.executionStopped = true;
    }

    @Override
    public void pauseExecution(boolean bl) {
        if (this.chk || this.viewer.isHeadless()) {
            return;
        }
        if (bl && !this.isJS) {
            this.viewer.delayScript(this, -100);
        }
        this.viewer.popHoldRepaintWhy("pauseExecution");
        this.executionStepping = false;
        this.executionPaused = true;
    }

    @Override
    public void stepPausedExecution() {
        this.executionStepping = true;
        this.executionPaused = false;
    }

    @Override
    public void resumePausedExecution() {
        this.executionPaused = false;
        this.executionStepping = false;
    }

    @Override
    public boolean isExecuting() {
        return this.executing && !this.executionStopped;
    }

    @Override
    public boolean isPaused() {
        return this.executionPaused;
    }

    @Override
    public boolean isStepping() {
        return this.executionStepping;
    }

    @Override
    public boolean isStopped() {
        return this.executionStopped || !this.isJS && this.currentThread != Thread.currentThread();
    }

    @Override
    public String getNextStatement() {
        return this.pc < this.aatoken.length ? ScriptEvaluator.setErrorLineMessage(this.functionName, this.scriptFileName, this.getLinenumber(null), this.pc, ScriptEvaluator.statementAsString(this.aatoken[this.pc], -9999, this.logMessages)) : "";
    }

    private String getCommand(int n, boolean bl, boolean bl2) {
        if (n >= this.lineIndices.length) {
            return "";
        }
        if (bl) {
            int n2 = -1;
            int n3 = this.script.length();
            for (int i = 0; i < this.lineNumbers.length; ++i) {
                if (this.lineNumbers[i] == this.lineNumbers[n]) {
                    if (n2 < 0) {
                        n2 = this.lineIndices[i][0];
                    }
                    n3 = this.lineIndices[i][1];
                    continue;
                }
                if (this.lineNumbers[i] == 0 || this.lineNumbers[i] > this.lineNumbers[n]) break;
            }
            if (n3 == this.script.length() - 1 && this.script.endsWith("}")) {
                ++n3;
            }
            return n2 == this.script.length() || n3 < n2 ? "" : this.script.substring(Math.max(n2, 0), Math.min(this.script.length(), n3));
        }
        int n4 = this.lineIndices[n][0];
        int n5 = this.lineIndices[n][1];
        String string = "";
        if (n4 < 0 || n5 <= n4 || n5 > this.script.length()) {
            return "";
        }
        try {
            string = this.script.substring(n4, n5);
            if (string.indexOf("\\\n") >= 0) {
                string = TextFormat.simpleReplace(string, "\\\n", "  ");
            }
            if (string.indexOf("\\\r") >= 0) {
                string = TextFormat.simpleReplace(string, "\\\r", "  ");
            }
            if (string.length() > 0 && !string.endsWith(";")) {
                string = string + ";";
            }
        }
        catch (Exception exception) {
            Logger.error("darn problem in Eval getCommand: ichBegin=" + n4 + " ichEnd=" + n5 + " len = " + this.script.length() + "\n" + exception);
        }
        return string;
    }

    private void logDebugScript(int n) {
        if (this.logMessages) {
            if (this.st.length > 0) {
                Logger.debug(this.st[0].toString());
            }
            for (int i = 1; i < this.slen; ++i) {
                Logger.debug(this.st[i].toString());
            }
        }
        this.iToken = -9999;
        if (this.logMessages) {
            SB sB = new SB();
            String string = n > 0 ? "                          ".substring(0, n * 2) : "";
            sB.append(string).append(ScriptEvaluator.statementAsString(this.st, this.iToken, this.logMessages));
            this.viewer.scriptStatus(sB.toString());
        } else {
            String string = this.getCommand(this.pc, false, false);
            if (string != "") {
                this.viewer.scriptStatus(string);
            }
        }
    }

    @Override
    public Object evaluateExpression(Object object, boolean bl) {
        ScriptEvaluator scriptEvaluator = (ScriptEvaluator)new ScriptEvaluator().setViewer(this.viewer);
        try {
            scriptEvaluator.pushContext(null);
            scriptEvaluator.allowJSThreads = false;
        }
        catch (ScriptException scriptException) {
            // empty catch block
        }
        return scriptEvaluator.evaluate(object, bl);
    }

    private Object evaluate(Object object, boolean bl) {
        try {
            if (object instanceof String) {
                if (this.compileScript(null, "e_x_p_r_e_s_s_i_o_n = " + object, false)) {
                    this.contextVariables = this.viewer.getContextVariables();
                    this.setStatement(0);
                    return bl ? this.parameterExpressionList(2, -1, false).get(0) : this.parameterExpressionString(2, 0);
                }
            } else if (object instanceof T[]) {
                this.contextVariables = this.viewer.getContextVariables();
                BS bS = this.atomExpression((T[])object, 0, 0, true, false, true, false);
                return bl ? SV.newScriptVariableBs(bS, -1) : bS;
            }
        }
        catch (Exception exception) {
            Logger.error("Error evaluating: " + object + "\n" + exception);
        }
        return bl ? SV.getVariable("ERROR") : "ERROR";
    }

    @Override
    public boolean evaluateParallel(ScriptContext scriptContext, ShapeManager shapeManager) {
        ScriptEvaluator scriptEvaluator = new ScriptEvaluator();
        scriptEvaluator.setViewer(this.viewer);
        scriptEvaluator.historyDisabled = true;
        scriptEvaluator.compiler = new ScriptCompiler(this.viewer);
        scriptEvaluator.sm = shapeManager;
        try {
            scriptEvaluator.restoreScriptContext(scriptContext, true, false, false);
            scriptEvaluator.allowJSThreads = false;
            scriptEvaluator.dispatchCommands(false, false);
        }
        catch (Exception exception) {
            this.viewer.setStringProperty("_errormessage", "" + exception);
            if (scriptEvaluator.thisContext == null) {
                Logger.error("Error evaluating context");
                exception.printStackTrace();
            }
            return false;
        }
        return true;
    }

    @Override
    public BS getAtomBitSet(Object object) {
        if (object instanceof BS) {
            return (BS)object;
        }
        BS bS = new BS();
        try {
            this.pushContext(null);
            String string = "select (" + object + ")";
            string = TextFormat.replaceAllCharacters(string, "\n\r", "),(");
            string = TextFormat.simpleReplace(string, "()", "(none)");
            if (this.compileScript(null, string, false)) {
                this.st = this.aatoken[0];
                bS = this.atomExpression(this.st, 1, 0, false, false, true, true);
            }
            this.popContext(false, false);
        }
        catch (Exception exception) {
            Logger.error("getAtomBitSet " + object + "\n" + exception);
        }
        return bS;
    }

    @Override
    public JmolList<Integer> getAtomBitSetVector(int n, Object object) {
        JmolList<Integer> jmolList = new JmolList<Integer>();
        BS bS = this.getAtomBitSet(object);
        int n2 = bS.nextSetBit(0);
        while (n2 >= 0) {
            jmolList.addLast(n2);
            n2 = bS.nextSetBit(n2 + 1);
        }
        return jmolList;
    }

    private JmolList<SV> parameterExpressionList(int n, int n2, boolean bl) throws ScriptException {
        return (JmolList)this.parameterExpression(n, -1, null, true, true, n2, bl, null, null);
    }

    private String parameterExpressionString(int n, int n2) throws ScriptException {
        return (String)this.parameterExpression(n, n2, "", true, false, -1, false, null, null);
    }

    private boolean parameterExpressionBoolean(int n, int n2) throws ScriptException {
        return (Boolean)this.parameterExpression(n, n2, null, true, false, -1, false, null, null);
    }

    private SV parameterExpressionToken(int n) throws ScriptException {
        JmolList<SV> jmolList = this.parameterExpressionList(n, -1, false);
        return jmolList.size() > 0 ? (SV)jmolList.get(0) : SV.newVariable(4, "");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object parameterExpression(int n, int n2, String string, boolean bl, boolean bl2, int n3, boolean bl3, Map<String, SV> map, String string2) throws ScriptException {
        SV sV;
        boolean bl4 = string2 != null;
        boolean bl5 = n < 0;
        boolean bl6 = !bl2 && string == null;
        boolean bl7 = !bl2 && string != null && string.length() == 0;
        int n4 = 0;
        if (bl5) {
            n = -n;
        }
        int n5 = 0;
        ScriptMathProcessor scriptMathProcessor = new ScriptMathProcessor(this, bl3, bl2, false);
        if (n == 0 && n2 == 0) {
            n = 2;
        }
        if (n2 < n) {
            n2 = this.slen;
        }
        block35: for (int i = n; i < n2; ++i) {
            void var10_19;
            Object var10_20 = null;
            int n6 = this.getToken((int)i).tok;
            if (bl4 && this.tokAt(i + 1) != 0x100008) {
                SV sV2;
                SV sV3 = sV2 = map != null && map.containsKey(this.theToken.value) ? null : this.getBitsetPropertySelector(i, false);
                if (sV2 != null) {
                    scriptMathProcessor.addXVar(map.get(string2));
                    if (!scriptMathProcessor.addOpAllowMath(sV2, this.tokAt(i + 1) == 0x10100010)) {
                        this.error(22);
                    }
                    if ((sV2.intValue == 135368713 || sV2.intValue == 102436) && this.tokAt(this.iToken + 1) != 0x10100010) {
                        scriptMathProcessor.addOp(T.tokenLeftParen);
                        scriptMathProcessor.addOp(T.tokenRightParen);
                    }
                    i = this.iToken;
                    continue;
                }
            }
            block1 : switch (n6) {
                case 1060866: {
                    void var10_24;
                    if (this.tokAt(++i) == 0x100001) {
                        SV sV4 = this.parameterExpressionToken(++i);
                        i = this.iToken;
                    } else {
                        if (this.tokAt(i) == 2) {
                            BS bS = this.viewer.getAtomBits(1095763969, this.st[i].intValue);
                            break;
                        }
                        Object object = this.getParameter(SV.sValue(this.st[i]), 1073742190);
                    }
                    Object object = this.getParameter(((SV)var10_24).asString(), 1073742190);
                    break;
                }
                case 135369225: {
                    if (this.getToken((int)(++i)).tok != 0x10100010) {
                        this.error(22);
                    }
                    if (map == null) {
                        map = new Hashtable<String, SV>();
                    }
                    Object object3 = this.parameterExpression(++i, -1, null, bl, false, -1, false, map, string2);
                    boolean bl8 = (Boolean)object3;
                    int n7 = this.iToken;
                    if (this.getToken((int)n7++).tok != 0x10000F) {
                        this.error(22);
                    }
                    this.parameterExpressionBoolean(n7, -1);
                    int n8 = this.iToken;
                    if (this.tokAt(n8++) != 0x10000F) {
                        this.error(22);
                    }
                    this.parameterExpression(-n8, -1, null, bl, false, 1, false, map, string2);
                    int n9 = this.iToken;
                    if (this.tokAt(n9) != 0x10100011) {
                        this.error(22);
                    }
                    Object object2 = this.parameterExpression(bl8 ? n7 : n8, bl8 ? n8 : n9, "XXX", bl, false, 1, false, map, string2);
                    i = n9;
                    break;
                }
                case 135280132: 
                case 135369224: {
                    int n10;
                    int n11;
                    String[] stringArray;
                    Object object;
                    String string3;
                    boolean bl9;
                    Object object3;
                    boolean bl10 = n > 0;
                    boolean bl11 = bl9 = bl10 && n6 == 135369224;
                    if (bl10) {
                        if (this.getToken((int)(++i)).tok != 0x10100010 || !T.tokAttr(this.getToken((int)(++i)).tok, 0x40000000)) {
                            this.error(22);
                        }
                        string3 = this.parameterAsString(i);
                        if (this.getToken((int)(++i)).tok != 0x10000F) {
                            this.error(22);
                        }
                    } else {
                        string3 = "_x";
                    }
                    if (!((object = this.parameterExpressionToken((int)(-(++i))).value) instanceof BS)) {
                        this.error(22);
                    }
                    BS bS = (BS)object;
                    i = this.iToken;
                    if (bl10 && this.getToken((int)i++).tok != 0x10000F) {
                        this.error(22);
                    }
                    BS bS2 = new BS();
                    BS bS3 = new BS();
                    String[] stringArray2 = stringArray = bl9 ? new String[BSUtil.cardinalityOf(bS)] : null;
                    if (map == null) {
                        map = new Hashtable<String, SV>();
                    }
                    bS3.set(0);
                    SV sV5 = SV.newScriptVariableBs(bS3, 0);
                    map.put(string3, sV5.setName(string3));
                    int n12 = -1;
                    if (bl10) {
                        n12 = i - 1;
                        n11 = 0;
                        while (n11 >= 0 && ++n12 < n2) {
                            n10 = this.tokAt(n12);
                            if (n10 == 0x10100011) {
                                --n11;
                                continue;
                            }
                            if (n10 != 0x10100010) continue;
                            ++n11;
                        }
                    }
                    n11 = 0;
                    n10 = 0;
                    int n13 = bS.nextSetBit(0);
                    if (n13 < 0) {
                        this.iToken = n12 - 1;
                    } else if (!this.chk) {
                        while (n13 >= 0) {
                            if (n10 >= 0) {
                                bS3.clear(n10);
                            }
                            n10 = n13;
                            bS3.set(n13);
                            sV5.index = n13;
                            object3 = this.parameterExpression(i, n12, bl9 ? "XXX" : null, bl, bl9, n13, false, map, bl10 ? null : string3);
                            if (bl9) {
                                if (object3 == null || ((JmolList)object3).size() == 0) {
                                    this.error(22);
                                }
                                stringArray[n11++] = ((SV)((JmolList)object3).get(0)).asString();
                            } else if (((Boolean)object3).booleanValue()) {
                                bS2.set(n13);
                            }
                            n13 = bS.nextSetBit(n13 + 1);
                        }
                    }
                    if (bl9) {
                        String[] stringArray3 = stringArray;
                    } else {
                        if (!bl10) return this.bitsetVariableVector(bS2);
                        BS bS4 = bS2;
                    }
                    i = this.iToken + 1;
                    break;
                }
                case 0x10000F: {
                    break block35;
                }
                case 3: {
                    scriptMathProcessor.addXNum(SV.newVariable(3, this.theToken.value));
                    break;
                }
                case 2: 
                case 1048614: {
                    scriptMathProcessor.addXNum(SV.newScriptVariableInt(this.theToken.intValue));
                    break;
                }
                case 135266319: {
                    if (this.tokAt(this.iToken + 1) == 0x10100010) {
                        if (scriptMathProcessor.addOpAllowMath(this.theToken, true)) break;
                        this.error(22);
                        break;
                    }
                    scriptMathProcessor.addXVar(SV.newScriptVariableToken(this.theToken));
                    break;
                }
                case 4: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 0x100004: 
                case 0x100006: 
                case 0x10000C: 
                case 0x10000D: 
                case 135267335: 
                case 135267336: 
                case 0x40D00004: 
                case 1087373318: 
                case 1087373320: 
                case 1087375361: 
                case 1087375362: 
                case 1087375365: 
                case 1095761934: 
                case 1095761938: 
                case 1095766028: 
                case 1238369286: 
                case 1641025539: 
                case 1679429641: {
                    scriptMathProcessor.addXVar(SV.newScriptVariableToken(this.theToken));
                    break;
                }
                case 0x100007: {
                    this.ignoreError = true;
                    try {
                        P3 p3 = this.centerParameter(i);
                        scriptMathProcessor.addXVar(SV.newVariable(8, p3));
                    }
                    catch (Exception exception) {
                        scriptMathProcessor.addXStr("");
                    }
                    this.ignoreError = false;
                    i = this.iToken;
                    break;
                }
                case 0x10000A: {
                    if (this.tokAt(i + 1) == 4) {
                        Map<String, Object> map2 = this.getHash(i);
                    } else {
                        Object object = this.getPointOrPlane(i, false, true, true, false, 3, 4);
                    }
                    i = this.iToken;
                    break;
                }
                case 0x100001: {
                    if (this.tokAt(i + 1) == 0x100002) {
                        Hashtable hashtable = new Hashtable();
                        ++i;
                        break;
                    }
                    if (this.tokAt(i + 1) == 0x100003 && this.tokAt(i + 2) == 0x100002) {
                        n6 = 0x100003;
                        this.iToken += 2;
                    }
                }
                case 0x100003: {
                    void var10_37;
                    if (n6 == 0x100003) {
                        BS bS = this.viewer.getModelUndeletedAtomsBitSet(-1);
                    } else {
                        BS bS = this.atomExpression(this.st, i, 0, true, true, true, true);
                    }
                    i = this.iToken++;
                    if (n5 != 0 || !bl5) break;
                    return this.bitsetVariableVector(var10_37);
                }
                case 1073742195: {
                    scriptMathProcessor.addOp(this.theToken);
                    continue block35;
                }
                case 0x100002: {
                    ++i;
                    break block35;
                }
                case 0x10000E: {
                    if (!bl && n5 == 0 && n4 == 0) break block35;
                    this.error(22);
                    break;
                }
                case 0x10100030: {
                    if (!bl && n5 == 0 && n4 == 0) break block35;
                    if (scriptMathProcessor.addOp(this.theToken)) break;
                    this.error(22);
                    break;
                }
                case 0x100008: {
                    SV sV6 = this.getBitsetPropertySelector(i + 1, false);
                    if (sV6 == null) {
                        this.error(22);
                    }
                    boolean bl12 = sV6.intValue == 135368713;
                    boolean bl13 = true;
                    int n14 = this.tokAt(this.iToken + 2);
                    if (this.tokAt(this.iToken + 1) == 0x100008) {
                        switch (n14) {
                            case 0x100003: {
                                n14 = 480;
                                if (this.tokAt(this.iToken + 3) == 0x100008 && this.tokAt(this.iToken + 4) == 1276118529) {
                                    n14 = 224;
                                }
                            }
                            case 32: 
                            case 64: 
                            case 96: 
                            case 128: 
                            case 160: 
                            case 192: {
                                bl13 = bl12 || n14 == 480 || n14 == 224;
                                sV6.intValue |= n14;
                                this.getToken(this.iToken + 2);
                                break;
                            }
                        }
                    }
                    if (!scriptMathProcessor.addOpAllowMath(sV6, bl13 &= this.tokAt(this.iToken + 1) == 0x10100010 || bl12)) {
                        this.error(22);
                    }
                    i = this.iToken;
                    if (sV6.intValue != 135368713 || this.tokAt(i + 1) == 0x10100010) break;
                    scriptMathProcessor.addOp(T.tokenLeftParen);
                    scriptMathProcessor.addOp(T.tokenRightParen);
                    break;
                }
                default: {
                    void var10_42;
                    SV sV7;
                    boolean bl14;
                    if (T.tokAttr(this.theTok, 0x10100000) || T.tokAttr(this.theTok, 0x8100000) && this.tokAt(this.iToken + 1) == 0x10100010) {
                        if (!scriptMathProcessor.addOp(this.theToken)) {
                            if (n3 >= 0) break block35;
                            this.error(22);
                        }
                        switch (this.theTok) {
                            case 0x10100010: {
                                ++n5;
                                break block1;
                            }
                            case 0x10100011: {
                                if (--n5 > 0 || n4 != 0 || !bl5) break;
                                ++this.iToken;
                                break block35;
                            }
                            case 0x10100040: {
                                ++n4;
                                break block1;
                            }
                            case 0x10100041: {
                                if (--n4 != 0 || n5 != 0 || !bl5) break;
                                ++this.iToken;
                                break block35;
                            }
                        }
                        break;
                    }
                    String string4 = this.parameterAsString(i).toLowerCase();
                    boolean bl15 = bl14 = this.tokAt(i + 1) == 0x10100010;
                    if (this.chk) {
                        String string5 = string4;
                    } else if (!(bl14 || map != null && (sV7 = map.get(string4)) != null)) {
                        SV sV8 = this.getContextVariableAsVariable(string4);
                    }
                    if (var10_42 != null) break;
                    if (T.tokAttr(this.theTok, 0x40000000) && this.viewer.isFunction(string4)) {
                        if (!scriptMathProcessor.addOp(SV.newVariable(135368713, this.theToken.value))) {
                            this.error(22);
                        }
                        if (bl14) break;
                        scriptMathProcessor.addOp(T.tokenLeftParen);
                        scriptMathProcessor.addOp(T.tokenRightParen);
                        break;
                    }
                    scriptMathProcessor.addXVar(this.viewer.getOrSetNewVariable(string4, false));
                }
            }
            if (var10_19 == null) continue;
            if (var10_19 instanceof BS) {
                scriptMathProcessor.addXBs((BS)var10_19);
                continue;
            }
            scriptMathProcessor.addXObj(var10_19);
        }
        if ((sV = scriptMathProcessor.getResult(false)) == null) {
            if (!this.chk) {
                scriptMathProcessor.dumpStacks("null result");
            }
            this.error(13);
        }
        if (sV.tok == 135198) {
            return sV.value;
        }
        if (bl6) {
            return sV.asBoolean();
        }
        if (bl7) {
            if (sV.tok != 4) return sV.asString();
            sV.intValue = Integer.MAX_VALUE;
            return sV.asString();
        }
        switch (sV.tok) {
            case 0x10000C: 
            case 0x10000D: {
                boolean bl16;
                if (sV.intValue == 1) {
                    bl16 = true;
                    return bl16;
                }
                bl16 = false;
                return bl16;
            }
            case 2: {
                return sV.intValue;
            }
        }
        return sV.value;
    }

    private Map<String, Object> getHash(int n) throws ScriptException {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        ++n;
        while (n < this.slen && this.tokAt(n) != 0x10000E) {
            String string = this.stringParameter(n++);
            if (this.tokAt(n++) != 0x10100022) {
                this.error(22);
            }
            JmolList jmolList = (JmolList)this.parameterExpression(n, 0, null, false, true, -1, false, null, null);
            hashtable.put(string, jmolList.get(0));
            n = this.iToken;
            if (this.tokAt(n) != 0x10100030) break;
            ++n;
        }
        this.iToken = n;
        if (this.tokAt(n) != 0x10000E) {
            this.error(22);
        }
        return hashtable;
    }

    JmolList<SV> bitsetVariableVector(Object object) {
        JmolList<SV> jmolList = new JmolList<SV>();
        if (object instanceof BS) {
            jmolList.addLast(SV.newVariable(10, object));
        }
        return jmolList;
    }

    Object getBitsetIdent(BS bS, String stringArray, Object object, boolean bl, int n, boolean bl2) {
        int n2;
        Map<String, Object> map;
        int[] nArray;
        boolean bl3;
        boolean bl4;
        boolean bl5 = bl4 = !(object instanceof Bond.BondSet);
        if (bl4) {
            if (stringArray == null) {
                stringArray = this.viewer.getStandardLabelFormat(0);
            } else if (stringArray.length() == 0) {
                stringArray = "%[label]";
            }
        }
        int n3 = stringArray == null ? -1 : stringArray.indexOf("%");
        boolean bl6 = bl3 = n != Integer.MAX_VALUE;
        if (bS == null || this.chk || bl4 && n3 < 0) {
            String[] stringArray2;
            if (stringArray == null) {
                stringArray = "";
            }
            if (bl2) {
                String[] stringArray3 = new String[1];
                stringArray2 = stringArray3;
                stringArray3[0] = stringArray;
            } else {
                stringArray2 = stringArray;
            }
            return stringArray2;
        }
        ModelSet modelSet = this.viewer.modelSet;
        int n4 = 0;
        int[] nArray2 = nArray = bl4 || !bl ? null : ((Bond.BondSet)object).getAssociatedAtoms();
        if (nArray == null && stringArray != null && stringArray.indexOf("%D") > 0) {
            nArray = this.viewer.getAtomIndices(bS);
        }
        boolean bl7 = stringArray == null || stringArray.length() == 0;
        Map<String, Object> map2 = map = bl4 || bl7 ? null : LabelToken.getBondLabelValues();
        LabelToken[] labelTokenArray = bl7 ? null : (bl4 ? LabelToken.compile(this.viewer, (String)stringArray, '\u0000', null) : LabelToken.compile(this.viewer, (String)stringArray, '\u0001', map));
        int n5 = bl3 ? 1 : BSUtil.cardinalityOf(bS);
        String[] stringArray4 = new String[n5];
        int n6 = n2 = bl3 ? n : bS.nextSetBit(0);
        while (n2 >= 0) {
            String string;
            if (bl4) {
                string = bl7 ? modelSet.atoms[n2].getInfo() : LabelToken.formatLabelAtomArray(this.viewer, modelSet.atoms[n2], labelTokenArray, '\u0000', nArray);
            } else {
                Bond bond = modelSet.getBondAt(n2);
                string = bl7 ? bond.getIdentity() : LabelToken.formatLabelBond(this.viewer, bond, labelTokenArray, map, nArray);
            }
            string = TextFormat.formatStringI(string, "#", n4 + 1);
            stringArray4[n4++] = string;
            if (bl3) break;
            n2 = bS.nextSetBit(n2 + 1);
        }
        return n5 == 1 && !bl2 ? stringArray4[0] : stringArray4;
    }

    private SV getBitsetPropertySelector(int n, boolean bl) throws ScriptException {
        int n2 = this.getToken((int)n).tok;
        switch (n2) {
            case 32: 
            case 64: 
            case 96: 
            case 128: 
            case 160: 
            case 192: 
            case 1716520973: {
                break;
            }
            default: {
                if (T.tokAttrOr(n2, 0x40500000, 0x44100000)) break;
                if (n2 != 806354977 && !T.tokAttr(n2, 0x40000000)) {
                    return null;
                }
                String string = this.parameterAsString(n);
                if (!bl && this.viewer.isFunction(string)) {
                    n2 = 135368713;
                    break;
                }
                if (!string.endsWith("?")) {
                    return null;
                }
                n2 = 0x40000000;
            }
        }
        if (bl && !T.tokAttr(n2, 2048)) {
            return null;
        }
        return SV.newScriptVariableIntValue(0x101000D1, n2, this.parameterAsString(n).toLowerCase());
    }

    private float[] getBitsetPropertyFloat(BS bS, int n, float f, float f2) throws ScriptException {
        int n2;
        float[] fArray = (float[])this.getBitsetProperty(bS, n, null, null, null, null, false, Integer.MAX_VALUE, false);
        if (!Float.isNaN(f)) {
            for (n2 = 0; n2 < fArray.length; ++n2) {
                if (!(fArray[n2] < f)) continue;
                fArray[n2] = Float.NaN;
            }
        }
        if (!Float.isNaN(f2)) {
            for (n2 = 0; n2 < fArray.length; ++n2) {
                if (!(fArray[n2] > f2)) continue;
                fArray[n2] = Float.NaN;
            }
        }
        return fArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Object getBitsetProperty(BS bS, int n, P3 p3, P4 p4, Object object, Object object2, boolean bl, int n2, boolean bl2) throws ScriptException {
        int n3;
        int n4;
        JmolList<Object> jmolList;
        block143: {
            int n5;
            int n6;
            P3 p32;
            float[] fArray;
            block142: {
                double d;
                double d2;
                float f;
                int n7;
                int n8;
                P3 p33;
                boolean bl3;
                boolean bl4;
                int n9;
                block141: {
                    boolean bl5;
                    boolean bl6;
                    boolean bl7;
                    block138: {
                        int n10;
                        ModelSet modelSet;
                        P3 p34;
                        block140: {
                            int n11;
                            float[] fArray2;
                            SV sV;
                            BS bS2;
                            JmolList jmolList2;
                            String string;
                            int n12;
                            boolean bl8;
                            block139: {
                                bl8 = n2 != Integer.MAX_VALUE;
                                boolean bl9 = bl8 || !(object instanceof Bond.BondSet);
                                n9 = n & 0x1E0;
                                bl7 = n9 == 224;
                                n12 = this.viewer.getAtomCount();
                                fArray = n9 == 256 ? new float[n12] : null;
                                boolean bl10 = bl6 = n9 == 480 || bl7;
                                if ((n &= 0xFFFFFE1F) == 0) {
                                    n = bl9 ? 0x44100001 : 1678770178;
                                }
                                bl4 = false;
                                bl3 = false;
                                bl5 = false;
                                switch (n) {
                                    case 1146093582: 
                                    case 1146095626: 
                                    case 1146095627: 
                                    case 1146095628: 
                                    case 1146095629: 
                                    case 1146095631: 
                                    case 1766856708: {
                                        bl4 = true;
                                        break;
                                    }
                                    case 135368713: 
                                    case 1276118018: {
                                        break;
                                    }
                                    default: {
                                        bl3 = T.tokAttr(n, 1095761920) && !T.tokAttr(n, 1112539136);
                                        bl5 = !bl3 && T.tokAttr(n, 0x40D00000);
                                    }
                                }
                                p32 = n9 == 256 ? new P3() : null;
                                P3 p35 = p33 = bl4 || !bl9 ? new P3() : null;
                                if (bl6 || bl5 && !bl8 && n9 != 256 && n9 != 32) {
                                    n9 = 0x100003;
                                }
                                jmolList = n9 == 0x100003 ? new JmolList<Object>() : null;
                                BS bS3 = null;
                                string = null;
                                jmolList2 = null;
                                bS2 = null;
                                sV = null;
                                p34 = null;
                                fArray2 = null;
                                switch (n) {
                                    case 0x44100001: 
                                    case 1678770178: {
                                        int n13;
                                        if (this.chk) {
                                            return bS;
                                        }
                                        bS3 = n == 0x44100001 ? (bl9 ? bS : this.viewer.getAtomBits(1678770178, bS)) : (bl9 ? new Bond.BondSet(this.viewer.getBondsForSelectedAtoms(bS)) : bS);
                                        switch (n9) {
                                            case 32: {
                                                n13 = bS3.nextSetBit(0);
                                                break;
                                            }
                                            case 64: {
                                                n13 = bS3.length() - 1;
                                                break;
                                            }
                                            case 128: 
                                            case 160: 
                                            case 192: {
                                                return Float.valueOf(Float.NaN);
                                            }
                                            default: {
                                                return bS3;
                                            }
                                        }
                                        bS3.clearAll();
                                        if (n13 < 0) return bS3;
                                        bS3.set(n13);
                                        return bS3;
                                    }
                                    case 1087373321: {
                                        switch (n9) {
                                            case 0: 
                                            case 0x100003: {
                                                return this.getBitsetIdent(bS, null, object, bl, n2, bl6);
                                            }
                                        }
                                        return "";
                                    }
                                    case 135368713: {
                                        string = (String)((Object[])object2)[0];
                                        jmolList2 = (JmolList)((Object[])object2)[1];
                                        bS2 = BSUtil.newBitSet(n12);
                                        sV = SV.newVariable(10, bS2);
                                        break;
                                    }
                                    case 1112539148: 
                                    case 1112539149: {
                                        this.viewer.autoCalculate(n);
                                        break;
                                    }
                                    case 1276118018: {
                                        if (p3 != null || p4 != null) break;
                                        return new P3();
                                    }
                                    case 1766856708: {
                                        p34 = new P3();
                                        break;
                                    }
                                    case 1716520973: {
                                        fArray2 = this.viewer.getDataFloat((String)object2);
                                        break;
                                    }
                                }
                                n8 = 0;
                                n11 = 0;
                                n7 = 0;
                                f = 0.0f;
                                d2 = 0.0;
                                d = 0.0;
                                switch (n9) {
                                    case 32: {
                                        n7 = Integer.MAX_VALUE;
                                        f = Float.MAX_VALUE;
                                        break;
                                    }
                                    case 64: {
                                        n7 = Integer.MIN_VALUE;
                                        f = -3.4028235E38f;
                                        break;
                                    }
                                }
                                modelSet = this.viewer.modelSet;
                                int n14 = bl4 ? 3 : (bl5 ? 2 : (n6 = bl3 ? 1 : 0));
                                if (bl9) break block139;
                                n4 = bS == null ? 1 : 0;
                                n5 = n4 != 0 ? 0 : bS.nextSetBit(0);
                                n3 = this.viewer.getBondCount();
                                n10 = n5;
                                break block140;
                            }
                            n4 = bS != null ? 1 : 0;
                            n5 = -1;
                            if (bl8) {
                                n3 = n2;
                                n10 = n2 + 1;
                            } else if (n4 != 0) {
                                n3 = bS.nextSetBit(0);
                                n10 = Math.min(n12, bS.length());
                            } else {
                                n3 = 0;
                                n10 = n12;
                            }
                            if (this.chk) {
                                n10 = 0;
                            }
                            int n15 = n3;
                            while (n15 >= 0 && n15 < n10) {
                                block137: {
                                    ++n8;
                                    Atom atom = modelSet.atoms[n15];
                                    block25 : switch (n6) {
                                        case 0: {
                                            float f2 = Float.MAX_VALUE;
                                            switch (n) {
                                                case 135368713: {
                                                    bS2.set(n15);
                                                    f2 = SV.fValue(this.runFunctionRet(null, string, jmolList2, sV, true, true, false));
                                                    bS2.clear(n15);
                                                    break;
                                                }
                                                case 1716520973: {
                                                    f2 = fArray2 == null ? 0.0f : fArray2[n15];
                                                    break;
                                                }
                                                case 1276118018: {
                                                    if (p4 != null) {
                                                        f2 = Measure.distanceToPlane(p4, atom);
                                                        break;
                                                    }
                                                    f2 = atom.distance(p3);
                                                    break;
                                                }
                                                default: {
                                                    f2 = Atom.atomPropertyFloat(this.viewer, atom, n);
                                                }
                                            }
                                            if (f2 == Float.MAX_VALUE || Float.isNaN(f2) && n9 != 0x100003) {
                                                --n8;
                                                break block137;
                                            } else {
                                                switch (n9) {
                                                    case 32: {
                                                        if (!(f2 < f)) break;
                                                        f = f2;
                                                        break;
                                                    }
                                                    case 64: {
                                                        if (!(f2 > f)) break;
                                                        f = f2;
                                                        break;
                                                    }
                                                    case 256: {
                                                        fArray[n15] = f2;
                                                        break;
                                                    }
                                                    case 0x100003: {
                                                        jmolList.addLast(Float.valueOf(f2));
                                                        break;
                                                    }
                                                    case 160: 
                                                    case 192: {
                                                        d += (double)f2 * (double)f2;
                                                    }
                                                    default: {
                                                        d2 += (double)f2;
                                                        break;
                                                    }
                                                }
                                                break;
                                            }
                                        }
                                        case 1: {
                                            Object object3;
                                            int n16 = 0;
                                            switch (n) {
                                                case 1297090050: {
                                                    if (atom.getModelIndex() != n5) {
                                                        n5 = atom.getModelIndex();
                                                    }
                                                    if ((object3 = atom.getAtomSymmetry()) == null) break;
                                                    int n17 = 0;
                                                    switch (n9) {
                                                        case 32: {
                                                            n11 = Integer.MAX_VALUE;
                                                            break;
                                                        }
                                                        case 64: {
                                                            n11 = Integer.MIN_VALUE;
                                                            break;
                                                        }
                                                    }
                                                    int n18 = ((BS)object3).nextSetBit(0);
                                                    while (n18 >= 0) {
                                                        n16 += n18 + 1;
                                                        switch (n9) {
                                                            case 32: {
                                                                n11 = Math.min(n11, n18 + 1);
                                                                break;
                                                            }
                                                            case 64: {
                                                                n11 = Math.max(n11, n18 + 1);
                                                                break;
                                                            }
                                                        }
                                                        ++n17;
                                                        n18 = ((BS)object3).nextSetBit(n18 + 1);
                                                    }
                                                    switch (n9) {
                                                        case 32: 
                                                        case 64: {
                                                            n16 = n11;
                                                            break;
                                                        }
                                                    }
                                                    n8 += n17 - 1;
                                                    break;
                                                }
                                                case 1095761925: 
                                                case 1095766022: {
                                                    this.errorStr(45, T.nameOf(n));
                                                    break;
                                                }
                                                default: {
                                                    n16 = Atom.atomPropertyInt(atom, n);
                                                }
                                            }
                                            switch (n9) {
                                                case 32: {
                                                    if (n16 >= n7) break;
                                                    n7 = n16;
                                                    break;
                                                }
                                                case 64: {
                                                    if (n16 <= n7) break;
                                                    n7 = n16;
                                                    break;
                                                }
                                                case 256: {
                                                    fArray[n15] = n16;
                                                    break;
                                                }
                                                case 0x100003: {
                                                    jmolList.addLast(Integer.valueOf(n16));
                                                    break;
                                                }
                                                case 160: 
                                                case 192: {
                                                    d += (double)n16 * (double)n16;
                                                }
                                                default: {
                                                    d2 += (double)n16;
                                                    break;
                                                }
                                            }
                                            break;
                                        }
                                        case 2: {
                                            Object object3 = Atom.atomPropertyString(this.viewer, atom, n);
                                            switch (n9) {
                                                case 256: {
                                                    fArray[n15] = Parser.parseFloatStr((String)object3);
                                                    break block25;
                                                }
                                            }
                                            if (jmolList == null) {
                                                return object3;
                                            }
                                            jmolList.addLast(object3);
                                            break;
                                        }
                                        case 3: {
                                            Tuple3f tuple3f = Atom.atomPropertyTuple(atom, n);
                                            if (tuple3f == null) {
                                                this.errorStr(45, T.nameOf(n));
                                            }
                                            switch (n9) {
                                                case 256: {
                                                    fArray[n15] = (float)Math.sqrt(tuple3f.x * tuple3f.x + tuple3f.y * tuple3f.y + tuple3f.z * tuple3f.z);
                                                    break block25;
                                                }
                                                case 0x100003: {
                                                    jmolList.addLast(P3.newP(tuple3f));
                                                    break block25;
                                                }
                                            }
                                            p33.add(tuple3f);
                                        }
                                    }
                                    if (bl8) break block138;
                                }
                                n15 = n4 != 0 ? bS.nextSetBit(n15 + 1) : n15 + 1;
                            }
                            break block138;
                        }
                        while (n10 >= 0 && n10 < n3) {
                            ++n8;
                            Bond bond = modelSet.getBondAt(n10);
                            block72 : switch (n) {
                                case 1141899267: {
                                    float f3 = bond.getAtom1().distance(bond.getAtom2());
                                    switch (n9) {
                                        case 32: {
                                            if (!(f3 < f)) break;
                                            f = f3;
                                            break;
                                        }
                                        case 64: {
                                            if (!(f3 > f)) break;
                                            f = f3;
                                            break;
                                        }
                                        case 0x100003: {
                                            jmolList.addLast(Float.valueOf(f3));
                                            break;
                                        }
                                        case 160: 
                                        case 192: {
                                            d += (double)f3 * (double)f3;
                                        }
                                        default: {
                                            d2 += (double)f3;
                                            break;
                                        }
                                    }
                                    break;
                                }
                                case 1146095626: {
                                    switch (n9) {
                                        case 0x100003: {
                                            p33.setT(bond.getAtom1());
                                            p33.add(bond.getAtom2());
                                            p33.scale(0.5f);
                                            jmolList.addLast(P3.newP(p33));
                                            break block72;
                                        }
                                    }
                                    p33.add(bond.getAtom1());
                                    p33.add(bond.getAtom2());
                                    ++n8;
                                    break;
                                }
                                case 1766856708: {
                                    ColorUtil.colorPointFromInt(this.viewer.getColorArgbOrGray(bond.colix), p34);
                                    switch (n9) {
                                        case 0x100003: {
                                            jmolList.addLast(P3.newP(p34));
                                            break block72;
                                        }
                                    }
                                    p33.add(p34);
                                    break;
                                }
                                default: {
                                    this.errorStr(46, T.nameOf(n));
                                }
                            }
                            n10 = n4 != 0 ? n10 + 1 : bS.nextSetBit(n10 + 1);
                        }
                    }
                    if (n9 == 256) {
                        return fArray;
                    }
                    if (n9 != 0x100003) break block141;
                    if (bl2) {
                        return jmolList;
                    }
                    n4 = jmolList.size();
                    if (bl5 && !bl6 && n4 == 1) {
                        return jmolList.get(0);
                    }
                    if (bl7) break block142;
                    if (n == 1087373320) {
                        SB sB = new SB();
                        n3 = 0;
                        while (n3 < n4) {
                            sB.append((String)jmolList.get(n3));
                            ++n3;
                        }
                        return sB.toString();
                    }
                    break block143;
                }
                if (bl4) {
                    P3 p36;
                    if (n8 == 0) {
                        p36 = p33;
                        return p36;
                    }
                    p36 = P3.new3(p33.x / (float)n8, p33.y / (float)n8, p33.z / (float)n8);
                    return p36;
                }
                if (n8 == 0) return Float.valueOf(Float.NaN);
                if (n8 == 1 && n9 == 192) {
                    return Float.valueOf(Float.NaN);
                }
                if (bl3) {
                    switch (n9) {
                        case 32: 
                        case 64: {
                            return n7;
                        }
                        case 160: 
                        case 192: {
                            break;
                        }
                        case 128: {
                            return (int)d2;
                        }
                        default: {
                            if (d2 / (double)n8 != (double)((int)(d2 / (double)n8))) return Float.valueOf((float)(d2 / (double)n8));
                            return (int)(d2 / (double)n8);
                        }
                    }
                }
                switch (n9) {
                    case 32: 
                    case 64: {
                        d2 = f;
                        return Float.valueOf((float)d2);
                    }
                    case 128: {
                        return Float.valueOf((float)d2);
                    }
                    case 160: {
                        d2 = d;
                        return Float.valueOf((float)d2);
                    }
                    case 192: {
                        d2 = Math.sqrt((d - d2 * d2 / (double)n8) / (double)(n8 - 1));
                        return Float.valueOf((float)d2);
                    }
                }
                d2 /= (double)n8;
                return Float.valueOf((float)d2);
            }
            fArray = new float[n4];
            n5 = n4;
            block110: while (--n5 >= 0) {
                Object e = jmolList.get(n5);
                switch (n6) {
                    case 0: {
                        fArray[n5] = ((Float)e).floatValue();
                        break;
                    }
                    case 1: {
                        fArray[n5] = ((Integer)e).floatValue();
                        break;
                    }
                    case 2: {
                        fArray[n5] = Parser.parseFloatStr((String)e);
                        break;
                    }
                    case 3: {
                        fArray[n5] = ((P3)e).distance(p32);
                        continue block110;
                    }
                }
            }
            return fArray;
        }
        String[] stringArray = new String[n4];
        n3 = n4;
        while (--n3 >= 0) {
            Object e = jmolList.get(n3);
            if (e instanceof P3) {
                stringArray[n3] = Escape.eP((P3)e);
                continue;
            }
            stringArray[n3] = "" + jmolList.get(n3);
        }
        return stringArray;
    }

    private void setBitsetProperty(BS bS, int n, int n2, float f, T t) throws ScriptException {
        if (this.chk || BSUtil.cardinalityOf(bS) == 0) {
            return;
        }
        String[] stringArray = null;
        String string = null;
        float[] fArray = null;
        JmolList<SV> jmolList = null;
        int n3 = 0;
        boolean bl = T.tokAttr(n, 0x40D00000);
        if (t.tok == 7 && (n3 = (jmolList = ((SV)t).getList()).size()) == 0) {
            return;
        }
        switch (n) {
            case 1146095626: 
            case 1146095627: 
            case 1146095629: 
            case 1146095631: {
                switch (t.tok) {
                    case 8: {
                        this.viewer.setAtomCoords(bS, n, t.value);
                        break;
                    }
                    case 7: {
                        this.theToken = t;
                        this.viewer.setAtomCoords(bS, n, this.getPointArray(-1, n3));
                    }
                }
                return;
            }
            case 1766856708: {
                Object object = null;
                String string2 = "color";
                switch (t.tok) {
                    case 7: {
                        int[] nArray = new int[n3];
                        int n4 = n3;
                        while (--n4 >= 0) {
                            SV sV = (SV)jmolList.get(n4);
                            P3 p3 = SV.ptValue(sV);
                            if (p3 != null) {
                                nArray[n4] = ColorUtil.colorPtToInt(p3);
                            } else if (sV.tok == 2) {
                                nArray[n4] = sV.intValue;
                            } else {
                                nArray[n4] = ColorUtil.getArgbFromString(sV.asString());
                                if (nArray[n4] == 0) {
                                    nArray[n4] = sV.asInt();
                                }
                            }
                            if (nArray[n4] != 0) continue;
                            this.errorStr2(50, "ARRAY", sV.asString());
                        }
                        object = nArray;
                        string2 = "colorValues";
                        break;
                    }
                    case 8: {
                        object = ColorUtil.colorPtToInt((P3)t.value);
                        break;
                    }
                    case 4: {
                        object = t.value;
                        break;
                    }
                    default: {
                        object = SV.iValue(t);
                    }
                }
                this.setShapePropertyBs(0, string2, object, bS);
                return;
            }
            case 1288701960: 
            case 1826248715: {
                if (t.tok == 7) break;
                string = SV.sValue(t);
                break;
            }
            case 1087375365: 
            case 1095763976: {
                this.clearDefinedVariableAtomSets();
                bl = false;
            }
        }
        switch (t.tok) {
            case 7: {
                if (bl) {
                    stringArray = SV.listValue(t);
                    break;
                }
                fArray = SV.flistValue(t, n3);
                break;
            }
            case 4: {
                if (string != null) break;
                stringArray = Parser.getTokens(SV.sValue(t));
            }
        }
        if (stringArray != null) {
            n3 = stringArray.length;
            if (!bl) {
                fArray = new float[n3];
                int n5 = n3;
                while (--n5 >= 0) {
                    fArray[n5] = n == 1087375365 ? (float)Elements.elementNumberFromSymbol(stringArray[n5], false) : Parser.parseFloatStr(stringArray[n5]);
                }
            }
            if (t.tok != 7 && n3 == 1) {
                if (bl) {
                    string = stringArray[0];
                } else {
                    f = fArray[0];
                }
                n2 = (int)f;
                stringArray = null;
                fArray = null;
            }
        }
        this.viewer.setAtomProperty(bS, n, n2, f, string, fArray, stringArray);
    }

    @Override
    public Map<String, Object> getDefinedAtomSets() {
        return this.definedAtomSets;
    }

    @Override
    public Map<String, SV> getContextVariables() {
        return this.contextVariables;
    }

    @Override
    public String getScript() {
        return this.script;
    }

    private boolean compileScript(String string, String string2, boolean bl) {
        this.scriptFileName = string;
        string2 = this.fixScriptPath(string2, string);
        this.restoreScriptContext(this.compiler.compile(string, string2, false, false, bl, false), false, false, false);
        this.isStateScript = this.script.indexOf("# Jmol state version ") >= 0;
        this.forceNoAddHydrogens = this.isStateScript && this.script.indexOf("pdbAddHydrogens") < 0;
        String string3 = this.script;
        this.pc = this.setScriptExtensions();
        if (!this.chk && this.viewer.scriptEditorVisible && string2.indexOf("\u0001## EDITOR_IGNORE ##") < 0) {
            this.viewer.scriptStatus("");
        }
        this.script = string3;
        return !this.error;
    }

    private String fixScriptPath(String string, String string2) {
        if (string2 != null && string.indexOf("$SCRIPT_PATH$") >= 0) {
            String string3 = string2;
            int n = Math.max(string2.lastIndexOf("|"), string2.lastIndexOf("/"));
            string3 = string3.substring(0, n + 1);
            string = TextFormat.simpleReplace(string, "$SCRIPT_PATH$/", string3);
            string = TextFormat.simpleReplace(string, "$SCRIPT_PATH$", string3);
        }
        return string;
    }

    private int setScriptExtensions() {
        String string = this.scriptExtensions;
        if (string == null) {
            return 0;
        }
        int n = string.indexOf("##SCRIPT_STEP");
        if (n >= 0) {
            this.executionStepping = true;
        }
        if ((n = string.indexOf("##SCRIPT_START=")) < 0) {
            return 0;
        }
        if ((n = Parser.parseInt(string.substring(n + 15))) == Integer.MIN_VALUE) {
            return 0;
        }
        this.pc = 0;
        while (this.pc < this.lineIndices.length && this.lineIndices[this.pc][0] <= n && this.lineIndices[this.pc][1] < n) {
            ++this.pc;
        }
        if (this.pc > 0 && this.pc < this.lineIndices.length && this.lineIndices[this.pc][0] > n) {
            --this.pc;
        }
        return this.pc;
    }

    @Override
    public void runScript(String string) throws ScriptException {
        if (!this.viewer.isPreviewOnly()) {
            this.runScriptBuffer(string, this.outputBuffer);
        }
    }

    private boolean compileScriptFileInternal(String string, String string2, String string3, String string4) {
        String string5;
        if (string.toLowerCase().indexOf("javascript:") == 0) {
            return this.compileScript(string, this.viewer.jsEval(string.substring(11)), this.debugScript);
        }
        String[] stringArray = new String[2];
        stringArray[0] = string;
        if (!this.viewer.getFileAsStringBin(stringArray, Integer.MAX_VALUE, false)) {
            this.setErrorMessage("io error reading " + stringArray[0] + ": " + stringArray[1]);
            return false;
        }
        if (("\n" + stringArray[1]).indexOf("\nJmolManifest.txt\n") >= 0) {
            if (string.endsWith(".all.pngj") || string.endsWith(".all.png")) {
                string5 = "|state.spt";
                string = string + "|";
            } else {
                stringArray[0] = string = string + "|JmolManifest.txt";
                if (!this.viewer.getFileAsStringBin(stringArray, Integer.MAX_VALUE, false)) {
                    this.setErrorMessage("io error reading " + stringArray[0] + ": " + stringArray[1]);
                    return false;
                }
                string5 = JmolBinary.getManifestScriptPath(stringArray[1]);
            }
            if (string5 != null && string5.length() > 0) {
                stringArray[0] = string = string.substring(0, string.lastIndexOf("|")) + string5;
                if (!this.viewer.getFileAsStringBin(stringArray, Integer.MAX_VALUE, false)) {
                    this.setErrorMessage("io error reading " + stringArray[0] + ": " + stringArray[1]);
                    return false;
                }
            }
        }
        this.scriptFileName = string;
        stringArray[1] = JmolBinary.getEmbeddedScript(stringArray[1]);
        string5 = this.fixScriptPath(stringArray[1], stringArray[0]);
        if (string4 == null) {
            string4 = this.viewer.getFilePath(string, false);
            string4 = string4.substring(0, Math.max(string4.lastIndexOf("|"), string4.lastIndexOf("/")));
        }
        string5 = FileManager.setScriptFileReferences(string5, string2, string3, string4);
        return this.compileScript(string, string5, this.debugScript);
    }

    private Object getParameter(String string, int n) {
        Object object = this.getContextVariableAsVariable(string);
        if (object == null) {
            object = this.viewer.getParameter(string);
        }
        switch (n) {
            case 1073742190: {
                return SV.getVariable(object);
            }
            case 4: {
                if (!(object instanceof JmolList)) break;
                JmolList jmolList = (JmolList)object;
                SB sB = new SB();
                for (int i = 0; i < jmolList.size(); ++i) {
                    sB.append(((SV)jmolList.get(i)).asString()).appendC('\n');
                }
                return sB.toString();
            }
        }
        return object instanceof SV ? SV.oValue((SV)object) : object;
    }

    private String getParameterEscaped(String string) {
        SV sV = this.getContextVariableAsVariable(string);
        return sV == null ? "" + this.viewer.getParameterEscaped(string) : sV.escape();
    }

    private String getStringParameter(String string, boolean bl) {
        SV sV = this.getContextVariableAsVariable(string);
        if (sV != null) {
            return sV.asString();
        }
        String string2 = "" + this.viewer.getParameter(string);
        return string2.length() == 0 && bl ? string : string2;
    }

    private Object getNumericParameter(String string) {
        if (string.equalsIgnoreCase("_modelNumber")) {
            int n = this.viewer.getCurrentModelIndex();
            return n < 0 ? 0 : this.viewer.getModelFileNumber(n);
        }
        SV sV = this.getContextVariableAsVariable(string);
        if (sV == null) {
            Object object = this.viewer.getParameter(string);
            if (!(object instanceof String)) {
                return object;
            }
            sV = SV.newVariable(4, object);
        }
        return SV.nValue(sV);
    }

    private SV getContextVariableAsVariable(String string) {
        if (string.equals("expressionBegin")) {
            return null;
        }
        string = string.toLowerCase();
        if (this.contextVariables != null && this.contextVariables.containsKey(string)) {
            return this.contextVariables.get(string);
        }
        ScriptContext scriptContext = this.thisContext;
        while (scriptContext != null) {
            if (scriptContext.isFunction) {
                return null;
            }
            if (scriptContext.contextVariables != null && scriptContext.contextVariables.containsKey(string)) {
                return scriptContext.contextVariables.get(string);
            }
            scriptContext = scriptContext.parentContext;
        }
        return null;
    }

    private Object getStringObjectAsVariable(String string, String string2) {
        if (string == null || string.length() == 0) {
            return string;
        }
        Object object = SV.unescapePointOrBitsetAsVariable(string);
        if (object instanceof String && string2 != null) {
            object = this.viewer.setUserVariable(string2, SV.newVariable(4, object));
        }
        return object;
    }

    @Override
    public float evalFunctionFloat(Object object, Object object2, float[] fArray) {
        try {
            JmolList jmolList = (JmolList)object2;
            for (int i = 0; i < fArray.length; ++i) {
                ((SV)jmolList.get((int)i)).value = Float.valueOf(fArray[i]);
            }
            ScriptFunction scriptFunction = (ScriptFunction)object;
            return SV.fValue(this.runFunctionRet(scriptFunction, scriptFunction.name, jmolList, null, true, false, false));
        }
        catch (Exception exception) {
            return Float.NaN;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SV runFunctionRet(JmolScriptFunction jmolScriptFunction, String string, JmolList<SV> jmolList, SV sV, boolean bl, boolean bl2, boolean bl3) throws ScriptException {
        JmolScriptFunction jmolScriptFunction2;
        boolean bl4;
        if (jmolScriptFunction == null) {
            jmolScriptFunction = this.viewer.getFunction(string);
            if (jmolScriptFunction == null) {
                return null;
            }
            if (bl2) {
                this.contextPath = this.contextPath + " >> function " + string;
            }
        } else if (bl2) {
            this.contextPath = this.contextPath + " >> " + string;
        }
        this.pushContext(null);
        if (this.allowJSThreads) {
            this.allowJSThreads = bl3;
        }
        this.thisContext.isTryCatch = bl4 = jmolScriptFunction.getTok() == 364558;
        this.thisContext.isFunction = !bl4;
        this.functionName = string;
        if (bl4) {
            this.viewer.resetError();
            this.thisContext.displayLoadErrorsSave = this.viewer.displayLoadErrors;
            this.thisContext.tryPt = ++tryPt;
            this.viewer.displayLoadErrors = false;
            this.restoreFunction(jmolScriptFunction, jmolList, sV);
            this.contextVariables.put("_breakval", SV.newScriptVariableInt(Integer.MAX_VALUE));
            this.contextVariables.put("_errorval", SV.newVariable(4, ""));
            Map<String, SV> map = this.contextVariables;
            this.executeCommands(true);
            while (this.thisContext.tryPt != tryPt) {
                this.popContext(false, false);
            }
            this.processTry(map);
            return null;
        }
        if (jmolScriptFunction instanceof JmolParallelProcessor) {
            jmolScriptFunction2 = jmolScriptFunction;
            synchronized (jmolScriptFunction2) {
                this.parallelProcessor = (JmolParallelProcessor)((Object)jmolScriptFunction);
                this.restoreFunction(jmolScriptFunction, jmolList, sV);
                this.dispatchCommands(false, true);
                ((JmolParallelProcessor)((Object)jmolScriptFunction)).runAllProcesses(this.viewer);
            }
        } else {
            this.restoreFunction(jmolScriptFunction, jmolList, sV);
            this.dispatchCommands(false, true);
        }
        jmolScriptFunction2 = bl ? this.getContextVariableAsVariable("_retval") : null;
        this.popContext(false, false);
        return jmolScriptFunction2;
    }

    private void processTry(Map<String, SV> map) throws ScriptException {
        int n;
        this.viewer.displayLoadErrors = this.thisContext.displayLoadErrorsSave;
        this.popContext(false, false);
        String string = (String)this.viewer.getParameter("_errormessage");
        if (string.length() > 0) {
            map.put("_errorval", SV.newVariable(4, string));
            this.viewer.resetError();
        }
        map.put("_tryret", map.get("_retval"));
        SV sV = map.get("_tryret");
        if (sV.value != null || sV.intValue != Integer.MAX_VALUE) {
            this.returnCmd(sV);
            return;
        }
        String string2 = (String)map.get((Object)"_errorval").value;
        if (string2.length() == 0 && (n = map.get((Object)"_breakval").intValue) != Integer.MAX_VALUE) {
            this.breakCmd(this.pc - n);
            return;
        }
        if (this.pc + 1 < this.aatoken.length && this.aatoken[this.pc + 1][0].tok == 102412) {
            ContextToken contextToken = (ContextToken)this.aatoken[this.pc + 1][0];
            if (contextToken.contextVariables != null && contextToken.name0 != null) {
                contextToken.contextVariables.put(contextToken.name0, SV.newVariable(4, string2));
            }
            contextToken.intValue = (string2.length() > 0 ? 1 : -1) * Math.abs(contextToken.intValue);
        }
    }

    private void restoreFunction(JmolScriptFunction jmolScriptFunction, JmolList<SV> jmolList, SV sV) throws ScriptException {
        ScriptFunction scriptFunction = (ScriptFunction)jmolScriptFunction;
        this.aatoken = scriptFunction.aatoken;
        this.lineNumbers = scriptFunction.lineNumbers;
        this.lineIndices = scriptFunction.lineIndices;
        this.script = scriptFunction.script;
        this.pc = 0;
        if (scriptFunction.names != null) {
            this.contextVariables = new Hashtable<String, SV>();
            scriptFunction.setVariables(this.contextVariables, jmolList);
        }
        if (sV != null) {
            this.contextVariables.put("_x", sV);
        }
    }

    private void clearDefinedVariableAtomSets() {
        this.definedAtomSets.remove("# variable");
    }

    private void defineSets() {
        String string;
        int n;
        if (!this.definedAtomSets.containsKey("# static")) {
            for (n = 0; n < JC.predefinedStatic.length; ++n) {
                this.defineAtomSet(JC.predefinedStatic[n]);
            }
            this.defineAtomSet("# static");
        }
        if (this.definedAtomSets.containsKey("# variable")) {
            return;
        }
        for (n = 0; n < JC.predefinedVariable.length; ++n) {
            this.defineAtomSet(JC.predefinedVariable[n]);
        }
        n = Elements.elementNumberMax;
        while (--n >= 0) {
            string = " elemno=" + n;
            this.defineAtomSet("@" + Elements.elementNameFromNumber(n) + string);
            this.defineAtomSet("@_" + Elements.elementSymbolFromNumber(n) + string);
        }
        n = 4;
        while (--n >= 0) {
            string = "@" + Elements.altElementNameFromIndex(n) + " _e=" + Elements.altElementNumberFromIndex(n);
            this.defineAtomSet(string);
        }
        n = Elements.altElementMax;
        while (--n >= 4) {
            short s;
            short s2 = Elements.altElementNumberFromIndex(n);
            String string2 = " _e=" + s2;
            String string3 = "@_" + Elements.altElementSymbolFromIndex(n);
            this.defineAtomSet(string3 + string2);
            string3 = "@_" + Elements.altIsotopeSymbolFromIndex(n);
            this.defineAtomSet(string3 + string2);
            string3 = "@_" + Elements.altIsotopeSymbolFromIndex2(n);
            this.defineAtomSet(string3 + string2);
            string3 = "@" + Elements.altElementNameFromIndex(n);
            if (string3.length() > 1) {
                this.defineAtomSet(string3 + string2);
            }
            if ((s2 = (short)Elements.getNaturalIsotope(s = Elements.getElementNumber(s2))) <= 0) continue;
            string2 = Elements.elementSymbolFromNumber(s);
            this.defineAtomSet("@_" + string2 + s2 + " _e=" + s);
            this.defineAtomSet("@_" + s2 + string2 + " _e=" + s);
        }
        this.defineAtomSet("# variable");
    }

    private void defineAtomSet(String string) {
        if (string.indexOf("#") == 0) {
            this.definedAtomSets.put(string, Boolean.TRUE);
            return;
        }
        ScriptContext scriptContext = this.compiler.compile("#predefine", string, true, false, false, false);
        if (scriptContext.errorType != null) {
            this.viewer.scriptStatus("JmolConstants.java ERROR: predefined set compile error:" + string + "\ncompile error:" + scriptContext.errorMessageUntranslated);
            return;
        }
        if (scriptContext.aatoken.length != 1) {
            this.viewer.scriptStatus("JmolConstants.java ERROR: predefinition does not have exactly 1 command:" + string);
            return;
        }
        T[] tArray = scriptContext.aatoken[0];
        if (tArray.length <= 2) {
            this.viewer.scriptStatus("JmolConstants.java ERROR: bad predefinition length:" + string);
            return;
        }
        int n = tArray[1].tok;
        if (!T.tokAttr(n, 0x40000000) && !T.tokAttr(n, 0x300000)) {
            this.viewer.scriptStatus("JmolConstants.java ERROR: invalid variable name:" + string);
            return;
        }
        String string2 = ((String)tArray[1].value).toLowerCase();
        if (string2.startsWith("dynamic_")) {
            string2 = "!" + string2.substring(8);
        }
        this.definedAtomSets.put(string2, tArray);
    }

    private BS lookupIdentifierValue(String string) throws ScriptException {
        BS bS = this.lookupValue(string, false);
        if (bS != null) {
            return BSUtil.copy(bS);
        }
        bS = this.getAtomBits(0x40000000, string);
        return bS == null ? new BS() : bS;
    }

    private BS lookupValue(String string, boolean bl) throws ScriptException {
        if (this.chk) {
            return new BS();
        }
        this.defineSets();
        string = string.toLowerCase();
        Object object = this.definedAtomSets.get(string);
        boolean bl2 = false;
        if (object == null) {
            object = this.definedAtomSets.get("!" + string);
            boolean bl3 = bl2 = object != null;
        }
        if (object instanceof BS) {
            return (BS)object;
        }
        if (object instanceof T[]) {
            this.pushContext(null);
            BS bS = this.atomExpression((T[])object, -2, 0, true, false, true, true);
            this.popContext(false, false);
            if (!bl2) {
                this.definedAtomSets.put(string, bS);
            }
            return bS;
        }
        if (bl) {
            return null;
        }
        int n = string.length();
        if (n < 5) {
            return null;
        }
        if (string.charAt(n - 1) != 's') {
            return null;
        }
        string = string.endsWith("ies") ? string.substring(0, n - 3) + 'y' : string.substring(0, n - 1);
        return this.lookupValue(string, true);
    }

    @Override
    public void deleteAtomsInVariables(BS bS) {
        for (Map.Entry<String, Object> entry : this.definedAtomSets.entrySet()) {
            Object object = entry.getValue();
            if (!(object instanceof BS)) continue;
            BSUtil.deleteBits((BS)object, bS);
            if (entry.getKey().startsWith("!")) continue;
            this.viewer.setUserVariable("@" + entry.getKey(), SV.newVariable(10, object));
        }
    }

    private boolean setStatement(int n) throws ScriptException {
        int n2;
        this.st = this.aatoken[n];
        this.slen = this.st.length;
        if (this.slen == 0) {
            return true;
        }
        for (n2 = 1; n2 < this.slen; ++n2) {
            if (this.st[n2] == null) {
                this.slen = n2;
                return true;
            }
            if (this.st[n2].tok == 1060866) break;
        }
        if (n2 == this.slen) {
            return n2 == this.slen;
        }
        switch (this.st[0].tok) {
            case 102436: 
            case 135368713: 
            case 0x40000000: {
                if (this.tokAt(1) != 0x10100010) break;
                return true;
            }
        }
        T[] tArray = new T[this.slen];
        tArray[0] = this.st[0];
        boolean bl = false;
        int n3 = 1;
        for (n2 = 1; n2 < this.slen; ++n2) {
            if (this.st[n2] == null) continue;
            int n4 = this.getToken((int)n2).tok;
            switch (n4) {
                default: {
                    tArray[n3] = this.st[n2];
                    break;
                }
                case 0x100001: 
                case 0x100002: {
                    bl = n4 == 0x100001;
                    tArray[n3] = this.st[n2];
                    break;
                }
                case 1060866: {
                    Object object;
                    Object object2;
                    boolean bl2;
                    if (++n2 == this.slen) {
                        this.error(22);
                    }
                    boolean bl3 = this.theToken.intValue == 4;
                    String string = this.parameterAsString(n2);
                    boolean bl4 = this.tokAt(n2) == 0x100001;
                    boolean bl5 = bl2 = n3 == 1 && this.st[0] == T.tokenSetCmd;
                    if (bl4) {
                        object2 = this.parameterExpressionToken(++n2);
                        n2 = this.iToken;
                        object = ((SV)object2).tok == 7 ? object2 : SV.oValue((SV)object2);
                    } else {
                        object = this.tokAt(n2) == 2 ? this.viewer.getAtomBits(1095763969, this.st[n2].intValue) : this.getParameter(string, 0);
                        if (!bl && !bl2) {
                            bl4 = true;
                        }
                    }
                    n4 = this.tokAt(0);
                    bl3 |= T.tokAttr(n4, 20480) || n4 == 135271429;
                    if (object instanceof SV) {
                        tArray[n3] = (T)object;
                        if (bl && tArray[n3].tok == 7) {
                            object2 = SV.getBitSet((SV)object, true);
                            tArray[n3] = SV.newVariable(10, object2 == null ? this.getAtomBitSet(SV.sValue(tArray[n3])) : object2);
                        }
                    } else if (object instanceof Boolean) {
                        tArray[n3] = (Boolean)object != false ? T.tokenOn : T.tokenOff;
                    } else if (object instanceof Integer) {
                        tArray[n3] = T.tv(2, (Integer)object, object);
                    } else if (object instanceof Float) {
                        tArray[n3] = T.tv(3, ScriptEvaluator.getFloatEncodedInt("" + object), object);
                    } else if (object instanceof String) {
                        if (!bl3) {
                            if ((n4 != 1085443 || n3 > 1 && this.st[1].tok != 537022465) && T.tokAttr(n4, 36864)) {
                                object = this.getParameter((String)object, 1073742190);
                            }
                            if (object instanceof String) {
                                object = this.getStringObjectAsVariable((String)object, null);
                            }
                        }
                        if (object instanceof SV) {
                            tArray[n3] = (T)object;
                        } else {
                            String string2 = (String)object;
                            if (bl && !bl3) {
                                tArray[n3] = T.o(10, this.getAtomBitSet(string2));
                            } else {
                                if (!bl) {
                                    // empty if block
                                }
                                n4 = bl2 ? T.getTokFromName(string2) : (bl4 || bl3 || string2.length() == 0 || string2.indexOf(".") >= 0 || string2.indexOf(" ") >= 0 || string2.indexOf("=") >= 0 || string2.indexOf(";") >= 0 || string2.indexOf("[") >= 0 || string2.indexOf("{") >= 0 ? 4 : 0x40000000);
                                tArray[n3] = T.o(n4, object);
                            }
                        }
                    } else if (object instanceof BS) {
                        tArray[n3] = SV.newVariable(10, object);
                    } else if (object instanceof P3) {
                        tArray[n3] = SV.newVariable(8, object);
                    } else if (object instanceof P4) {
                        tArray[n3] = SV.newVariable(9, object);
                    } else if (object instanceof Matrix3f) {
                        tArray[n3] = SV.newVariable(11, object);
                    } else if (object instanceof Matrix4f) {
                        tArray[n3] = SV.newVariable(12, object);
                    } else if (object instanceof Map) {
                        tArray[n3] = SV.newVariable(6, object);
                    } else if (object instanceof JmolList) {
                        object2 = (JmolList)object;
                        BS bS = null;
                        for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
                            SV sV = (SV)((ArrayList)object2).get(i);
                            if (sV.tok != 10) {
                                bS = null;
                                break;
                            }
                            if (bS == null) {
                                bS = new BS();
                            }
                            bS.or((BS)sV.value);
                        }
                        tArray[n3] = bS == null ? SV.getVariable(object) : T.o(10, bS);
                    } else {
                        object2 = this.getObjectCenter(string, Integer.MIN_VALUE, Integer.MIN_VALUE);
                        if (object2 == null) {
                            this.error(22);
                        }
                        tArray[n3] = T.o(8, object2);
                    }
                    if (!bl2 || T.tokAttr(tArray[n3].tok, 0x20000000)) break;
                    this.error(22);
                }
            }
            ++n3;
        }
        this.st = tArray;
        for (n2 = n3; n2 < this.st.length; ++n2) {
            this.st[n2] = null;
        }
        this.slen = n3;
        return true;
    }

    private void clearState(boolean bl) {
        this.thisContext = null;
        this.scriptLevel = 0;
        this.setErrorMessage(null);
        this.contextPath = "";
        this.tQuiet = bl;
    }

    @Override
    public ScriptContext getThisContext() {
        return this.thisContext;
    }

    @Override
    public void pushContextDown() {
        --this.scriptLevel;
        this.pushContext2(null);
    }

    private void pushContext(ContextToken contextToken) throws ScriptException {
        if (this.scriptLevel == 100) {
            this.error(44);
        }
        this.pushContext2(contextToken);
    }

    private void pushContext2(ContextToken contextToken) {
        this.thisContext = this.getScriptContext();
        this.thisContext.token = contextToken;
        if (contextToken == null) {
            this.scriptLevel = ++this.thisContext.scriptLevel;
        } else {
            this.thisContext.scriptLevel = -1;
            this.contextVariables = new Hashtable<String, SV>();
            if (contextToken.contextVariables != null) {
                for (String string : contextToken.contextVariables.keySet()) {
                    ScriptCompiler.addContextVariable(this.contextVariables, string);
                }
            }
        }
        if (this.debugScript || this.isCmdLine_c_or_C_Option) {
            Logger.info("-->>-------------".substring(0, Math.max(17, this.scriptLevel + 5)) + this.scriptLevel + " " + this.scriptFileName + " " + contextToken + " " + this.thisContext);
        }
    }

    @Override
    public ScriptContext getScriptContext() {
        ScriptContext scriptContext = new ScriptContext();
        scriptContext.scriptLevel = this.scriptLevel;
        scriptContext.parentContext = this.thisContext;
        scriptContext.contextPath = this.contextPath;
        scriptContext.scriptFileName = this.scriptFileName;
        scriptContext.parallelProcessor = this.parallelProcessor;
        scriptContext.functionName = this.functionName;
        scriptContext.script = this.script;
        scriptContext.lineNumbers = this.lineNumbers;
        scriptContext.lineIndices = this.lineIndices;
        scriptContext.aatoken = this.aatoken;
        scriptContext.statement = this.st;
        scriptContext.statementLength = this.slen;
        scriptContext.pc = this.pc;
        scriptContext.lineEnd = this.lineEnd;
        scriptContext.pcEnd = this.pcEnd;
        scriptContext.iToken = this.iToken;
        scriptContext.outputBuffer = this.outputBuffer;
        scriptContext.contextVariables = this.contextVariables;
        scriptContext.isStateScript = this.isStateScript;
        scriptContext.errorMessage = this.errorMessage;
        scriptContext.errorType = this.errorType;
        scriptContext.iCommandError = this.iCommandError;
        scriptContext.chk = this.chk;
        scriptContext.executionStepping = this.executionStepping;
        scriptContext.executionPaused = this.executionPaused;
        scriptContext.scriptExtensions = this.scriptExtensions;
        scriptContext.mustResumeEval = this.mustResumeEval;
        scriptContext.allowJSThreads = this.allowJSThreads;
        return scriptContext;
    }

    void popContext(boolean bl, boolean bl2) {
        if (this.thisContext == null) {
            return;
        }
        if (this.thisContext.scriptLevel > 0) {
            this.scriptLevel = this.thisContext.scriptLevel - 1;
        }
        ScriptContext scriptContext = bl ? this.getScriptContext() : null;
        this.restoreScriptContext(this.thisContext, true, bl, bl2);
        if (scriptContext != null) {
            this.restoreScriptContext(scriptContext, true, false, true);
        }
        if (this.debugScript || this.isCmdLine_c_or_C_Option) {
            Logger.info("--<<-------------".substring(0, Math.max(17, this.scriptLevel + 5)) + this.scriptLevel + " " + this.scriptFileName + " " + (this.thisContext == null ? "" : "" + this.thisContext.token) + " " + this.thisContext);
        }
    }

    private void restoreScriptContext(ScriptContext scriptContext, boolean bl, boolean bl2, boolean bl3) {
        if (scriptContext == null) {
            return;
        }
        if (!bl2) {
            this.st = scriptContext.statement;
            this.slen = scriptContext.statementLength;
            this.pc = scriptContext.pc;
            this.lineEnd = scriptContext.lineEnd;
            this.pcEnd = scriptContext.pcEnd;
            if (bl3) {
                return;
            }
        }
        this.mustResumeEval = scriptContext.mustResumeEval;
        this.script = scriptContext.script;
        this.lineNumbers = scriptContext.lineNumbers;
        this.lineIndices = scriptContext.lineIndices;
        this.aatoken = scriptContext.aatoken;
        this.contextVariables = scriptContext.contextVariables;
        this.scriptExtensions = scriptContext.scriptExtensions;
        if (bl) {
            this.contextPath = scriptContext.contextPath;
            this.scriptFileName = scriptContext.scriptFileName;
            this.parallelProcessor = scriptContext.parallelProcessor;
            this.functionName = scriptContext.functionName;
            this.iToken = scriptContext.iToken;
            this.outputBuffer = scriptContext.outputBuffer;
            this.isStateScript = scriptContext.isStateScript;
            this.thisContext = scriptContext.parentContext;
            this.allowJSThreads = scriptContext.allowJSThreads;
        } else {
            this.error = scriptContext.errorType != null;
            this.errorMessage = scriptContext.errorMessage;
            this.errorMessageUntranslated = scriptContext.errorMessageUntranslated;
            this.iCommandError = scriptContext.iCommandError;
            this.errorType = scriptContext.errorType;
        }
    }

    private String getContext(boolean bl) {
        SB sB = new SB();
        ScriptContext scriptContext = this.thisContext;
        while (scriptContext != null) {
            if (bl) {
                if (scriptContext.contextVariables != null) {
                    sB.append(this.getScriptID(scriptContext));
                    sB.append(StateManager.getVariableList(scriptContext.contextVariables, 80, true, false));
                }
            } else {
                sB.append(ScriptEvaluator.setErrorLineMessage(scriptContext.functionName, scriptContext.scriptFileName, this.getLinenumber(scriptContext), scriptContext.pc, ScriptEvaluator.statementAsString(scriptContext.statement, -9999, this.logMessages)));
            }
            scriptContext = scriptContext.parentContext;
        }
        if (bl) {
            if (this.contextVariables != null) {
                sB.append(this.getScriptID(null));
                sB.append(StateManager.getVariableList(this.contextVariables, 80, true, false));
            }
        } else {
            sB.append(ScriptEvaluator.setErrorLineMessage(this.functionName, this.scriptFileName, this.getLinenumber(null), this.pc, ScriptEvaluator.statementAsString(this.st, -9999, this.logMessages)));
        }
        return sB.toString();
    }

    private int getLinenumber(ScriptContext scriptContext) {
        return scriptContext == null ? this.lineNumbers[this.pc] : scriptContext.lineNumbers[scriptContext.pc];
    }

    private String getScriptID(ScriptContext scriptContext) {
        String string = scriptContext == null ? this.functionName : "function " + scriptContext.functionName;
        String string2 = scriptContext == null ? this.scriptFileName : scriptContext.scriptFileName;
        return "\n# " + string + " (file " + string2 + ")\n";
    }

    @Override
    public void setException(ScriptException scriptException, String string, String string2) {
        scriptException.untranslated = string2 == null ? string : string2;
        this.errorType = string;
        this.iCommandError = this.pc;
        if (scriptException.message == null) {
            scriptException.message = "";
            return;
        }
        String string3 = ScriptEvaluator.getContextTrace(this.getScriptContext(), null, true).toString();
        while (this.thisContext != null && !this.thisContext.isTryCatch) {
            this.popContext(false, false);
        }
        scriptException.message = scriptException.message + string3;
        scriptException.untranslated = scriptException.untranslated + string3;
        if (this.thisContext != null || this.chk || string.indexOf("file recognized as a script file:") >= 0) {
            return;
        }
        Logger.error("eval ERROR: " + this.toString());
        if (this.viewer.autoExit) {
            this.viewer.exitJmol();
        }
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String getErrorMessageUntranslated() {
        return this.errorMessageUntranslated == null ? this.errorMessage : this.errorMessageUntranslated;
    }

    private void setErrorMessage(String string) {
        this.errorMessageUntranslated = null;
        if (string == null) {
            this.error = false;
            this.errorType = null;
            this.errorMessage = null;
            this.iCommandError = -1;
            return;
        }
        this.error = true;
        if (this.errorMessage == null) {
            this.errorMessage = GT._("script ERROR: ");
        }
        this.errorMessage = this.errorMessage + string;
    }

    private void planeExpected() throws ScriptException {
        this.errorMore(38, "{a b c d}", "\"xy\" \"xz\" \"yz\" \"x=...\" \"y=...\" \"z=...\"", "$xxxxx");
    }

    private void integerOutOfRange(int n, int n2) throws ScriptException {
        this.errorStr2(21, "" + n, "" + n2);
    }

    private void numberOutOfRange(float f, float f2) throws ScriptException {
        this.errorStr2(36, "" + f, "" + f2);
    }

    void errorAt(int n, int n2) throws ScriptException {
        this.iToken = n2;
        this.errorOrWarn(n, null, null, null, false);
    }

    void error(int n) throws ScriptException {
        this.errorOrWarn(n, null, null, null, false);
    }

    void errorStr(int n, String string) throws ScriptException {
        this.errorOrWarn(n, string, null, null, false);
    }

    void errorStr2(int n, String string, String string2) throws ScriptException {
        this.errorOrWarn(n, string, string2, null, false);
    }

    void errorMore(int n, String string, String string2, String string3) throws ScriptException {
        this.errorOrWarn(n, string, string2, string3, false);
    }

    private void warning(int n, String string, String string2) throws ScriptException {
        this.errorOrWarn(n, string, string2, null, true);
    }

    void errorOrWarn(int n, String string, String string2, String string3, boolean bl) throws ScriptException {
        String string4;
        String string5 = this.ignoreError ? null : ScriptEvaluator.errorString(n, string, string2, string3, true);
        String string6 = string4 = !this.ignoreError && GT.getDoTranslate() ? ScriptEvaluator.errorString(n, string, string2, string3, false) : null;
        if (!bl) {
            this.evalError(string5, string4);
        }
        this.showString(string5);
    }

    void evalError(String string, String string2) throws ScriptException {
        if (this.ignoreError) {
            throw new NullPointerException();
        }
        if (!this.chk) {
            this.setCursorWait(false);
            this.viewer.setBooleanProperty("refreshing", true);
            this.viewer.setStringProperty("_errormessage", string2);
        }
        throw new ScriptException(this, string, string2, true);
    }

    static String errorString(int n, String string, String string2, String string3, boolean bl) {
        String string4;
        boolean bl2 = false;
        if (!bl && (bl2 = GT.getDoTranslate())) {
            GT.setDoTranslate(false);
        }
        switch (n) {
            default: {
                string4 = "Unknown error message number: " + n;
                break;
            }
            case 0: {
                string4 = GT._("x y z axis expected");
                break;
            }
            case 1: {
                string4 = GT._("{0} not allowed with background model displayed");
                break;
            }
            case 2: {
                string4 = GT._("bad argument count");
                break;
            }
            case 3: {
                string4 = GT._("Miller indices cannot all be zero.");
                break;
            }
            case 4: {
                string4 = GT._("bad [R,G,B] color");
                break;
            }
            case 5: {
                string4 = GT._("boolean expected");
                break;
            }
            case 6: {
                string4 = GT._("boolean or number expected");
                break;
            }
            case 7: {
                string4 = GT._("boolean, number, or {0} expected");
                break;
            }
            case 56: {
                string4 = GT._("cannot set value");
                break;
            }
            case 8: {
                string4 = GT._("color expected");
                break;
            }
            case 9: {
                string4 = GT._("a color or palette name (Jmol, Rasmol) is required");
                break;
            }
            case 10: {
                string4 = GT._("command expected");
                break;
            }
            case 11: {
                string4 = GT._("{x y z} or $name or (atom expression) required");
                break;
            }
            case 12: {
                string4 = GT._("draw object not defined");
                break;
            }
            case 13: {
                string4 = GT._("unexpected end of script command");
                break;
            }
            case 14: {
                string4 = GT._("valid (atom expression) expected");
                break;
            }
            case 15: {
                string4 = GT._("(atom expression) or integer expected");
                break;
            }
            case 16: {
                string4 = GT._("filename expected");
                break;
            }
            case 17: {
                string4 = GT._("file not found");
                break;
            }
            case 18: {
                string4 = GT._("incompatible arguments");
                break;
            }
            case 19: {
                string4 = GT._("insufficient arguments");
                break;
            }
            case 20: {
                string4 = GT._("integer expected");
                break;
            }
            case 21: {
                string4 = GT._("integer out of range ({0} - {1})");
                break;
            }
            case 22: {
                string4 = GT._("invalid argument");
                break;
            }
            case 23: {
                string4 = GT._("invalid parameter order");
                break;
            }
            case 24: {
                string4 = GT._("keyword expected");
                break;
            }
            case 25: {
                string4 = GT._("no MO coefficient data available");
                break;
            }
            case 26: {
                string4 = GT._("An MO index from 1 to {0} is required");
                break;
            }
            case 27: {
                string4 = GT._("no MO basis/coefficient data available for this frame");
                break;
            }
            case 28: {
                string4 = GT._("no MO occupancy data available");
                break;
            }
            case 29: {
                string4 = GT._("Only one molecular orbital is available in this file");
                break;
            }
            case 30: {
                string4 = GT._("{0} require that only one model be displayed");
                break;
            }
            case 55: {
                string4 = GT._("{0} requires that only one model be loaded");
                break;
            }
            case 31: {
                string4 = GT._("No data available");
                break;
            }
            case 32: {
                string4 = GT._("No partial charges were read from the file; Jmol needs these to render the MEP data.");
                break;
            }
            case 33: {
                string4 = GT._("No unit cell");
                break;
            }
            case 34: {
                string4 = GT._("number expected");
                break;
            }
            case 35: {
                string4 = GT._("number must be ({0} or {1})");
                break;
            }
            case 36: {
                string4 = GT._("decimal number out of range ({0} - {1})");
                break;
            }
            case 37: {
                string4 = GT._("object name expected after '$'");
                break;
            }
            case 38: {
                string4 = GT._("plane expected -- either three points or atom expressions or {0} or {1} or {2}");
                break;
            }
            case 39: {
                string4 = GT._("property name expected");
                break;
            }
            case 40: {
                string4 = GT._("space group {0} was not found.");
                break;
            }
            case 41: {
                string4 = GT._("quoted string expected");
                break;
            }
            case 42: {
                string4 = GT._("quoted string or identifier expected");
                break;
            }
            case 43: {
                string4 = GT._("too many rotation points were specified");
                break;
            }
            case 44: {
                string4 = GT._("too many script levels");
                break;
            }
            case 45: {
                string4 = GT._("unrecognized atom property");
                break;
            }
            case 46: {
                string4 = GT._("unrecognized bond property");
                break;
            }
            case 47: {
                string4 = GT._("unrecognized command");
                break;
            }
            case 48: {
                string4 = GT._("runtime unrecognized expression");
                break;
            }
            case 49: {
                string4 = GT._("unrecognized object");
                break;
            }
            case 50: {
                string4 = GT._("unrecognized {0} parameter");
                break;
            }
            case 51: {
                string4 = GT._("unrecognized {0} parameter in Jmol state script (set anyway)");
                break;
            }
            case 52: {
                string4 = GT._("unrecognized SHOW parameter --  use {0}");
                break;
            }
            case 53: {
                string4 = "{0}";
                break;
            }
            case 54: {
                string4 = GT._("write what? {0} or {1} \"filename\"");
            }
        }
        if (string4.indexOf("{0}") < 0) {
            if (string != null) {
                string4 = string4 + ": " + string;
            }
        } else {
            if ((string4 = TextFormat.simpleReplace(string4, "{0}", string)).indexOf("{1}") >= 0) {
                string4 = TextFormat.simpleReplace(string4, "{1}", string2);
            } else if (string2 != null) {
                string4 = string4 + ": " + string2;
            }
            if (string4.indexOf("{2}") >= 0) {
                string4 = TextFormat.simpleReplace(string4, "{2}", string2);
            }
        }
        if (bl2) {
            GT.setDoTranslate(true);
        }
        return string4;
    }

    static String setErrorLineMessage(String string, String string2, int n, int n2, String string3) {
        String string4 = "\n----";
        if (string2 != null || string != null) {
            string4 = string4 + "line " + n + " command " + (n2 + 1) + " of " + (string == null ? string2 : (string.equals("try") ? "try" : "function " + string)) + ":";
        }
        string4 = string4 + "\n         " + string3;
        return string4;
    }

    public String toString() {
        SB sB = new SB();
        sB.append("Eval\n pc:");
        sB.appendI(this.pc);
        sB.append("\n");
        sB.appendI(this.aatoken.length);
        sB.append(" statements\n");
        for (int i = 0; i < this.aatoken.length; ++i) {
            sB.append("----\n");
            T[] tArray = this.aatoken[i];
            for (int j = 0; j < tArray.length; ++j) {
                sB.appendO(tArray[j]);
                sB.appendC('\n');
            }
            sB.appendC('\n');
        }
        sB.append("END\n");
        return sB.toString();
    }

    static String statementAsString(T[] tArray, int n, boolean bl) {
        if (tArray.length == 0) {
            return "";
        }
        SB sB = new SB();
        int n2 = tArray[0].tok;
        switch (n2) {
            case 0: {
                return (String)tArray[0].value;
            }
            case 0x119009: {
                if (tArray.length != 2 || tArray[1].tok != 135368713 && tArray[1].tok != 102436) break;
                return ((ScriptFunction)tArray[1].value).toString();
            }
        }
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = tArray.length > 1 && n2 == 1085443 && tArray[0].value.equals("") && (tArray[0].intValue == 61 || tArray[0].intValue == 35) && tArray[1].tok != 0x100001;
        int n3 = tArray.length;
        block32: for (int i = 0; i < n3; ++i) {
            T t = tArray[i];
            if (t == null) {
                n3 = i;
                break;
            }
            if (n == i - 1) {
                sB.append(" <<");
            }
            if (i != 0) {
                sB.appendC(' ');
            }
            if (i == 2 && bl5 && ((bl5 = t.tok != 269484436) || tArray[0].intValue == 35)) {
                sB.append(bl5 ? "= " : "== ");
                if (!bl5) continue;
            }
            if (n == i && t.tok != 0x100002) {
                sB.append(">> ");
            }
            switch (t.tok) {
                case 0x100001: {
                    if (!bl2) continue block32;
                    sB.append("{");
                    continue block32;
                }
                case 0x100002: {
                    if (bl4 && i == tArray.length - 1) {
                        bl2 = false;
                    }
                    if (!bl2) continue block32;
                    sB.append("}");
                    continue block32;
                }
                case 0x10100040: 
                case 0x10100041: {
                    break;
                }
                case 0x10000A: 
                case 0x10000E: {
                    bl3 = t.tok == 0x10000A;
                    break;
                }
                case 1060866: {
                    if (i <= 0 || !((String)t.value).equals("define")) break;
                    sB.append("@");
                    if (i + 1 >= tArray.length || tArray[i + 1].tok != 0x100001) continue block32;
                    if (!bl2) {
                        bl4 = true;
                    }
                    bl2 = true;
                    continue block32;
                }
                case 0x10000D: {
                    sB.append("true");
                    continue block32;
                }
                case 0x10000C: {
                    sB.append("false");
                    continue block32;
                }
                case 135280132: {
                    break;
                }
                case 2: {
                    sB.appendI(t.intValue);
                    continue block32;
                }
                case 8: 
                case 9: 
                case 10: {
                    sB.append(SV.sValue(t));
                    continue block32;
                }
                case 6: 
                case 7: {
                    sB.append(((SV)t).escape());
                    continue block32;
                }
                case 5: {
                    sB.appendC('^');
                    continue block32;
                }
                case 1048615: {
                    if (t.intValue != Integer.MAX_VALUE) {
                        sB.appendI(t.intValue);
                    } else {
                        sB.append(Group.getSeqcodeStringFor(ScriptEvaluator.getSeqCode(t)));
                    }
                    t = tArray[++i];
                    sB.appendC(' ');
                    sB.append(bl3 ? "-" : "- ");
                }
                case 1048614: {
                    if (t.intValue != Integer.MAX_VALUE) {
                        sB.appendI(t.intValue);
                        continue block32;
                    }
                    sB.append(Group.getSeqcodeStringFor(ScriptEvaluator.getSeqCode(t)));
                    continue block32;
                }
                case 0x100021: {
                    sB.append("*:");
                    sB.appendC((char)t.intValue);
                    continue block32;
                }
                case 0x10001F: {
                    sB.append("*%");
                    if (t.value == null) continue block32;
                    sB.append(t.value.toString());
                    continue block32;
                }
                case 0x100022: {
                    sB.append("*/");
                }
                case 3: 
                case 1048611: {
                    if (t.intValue < Integer.MAX_VALUE) {
                        sB.append(Escape.escapeModelFileNumber(t.intValue));
                        continue block32;
                    }
                    sB.append("" + t.value);
                    continue block32;
                }
                case 1048613: {
                    sB.appendC('[');
                    sB.append(Group.getGroup3For((short)t.intValue));
                    sB.appendC(']');
                    continue block32;
                }
                case 1048612: {
                    sB.appendC('[');
                    sB.appendO(t.value);
                    sB.appendC(']');
                    continue block32;
                }
                case 0x100020: {
                    sB.append("*.");
                    break;
                }
                case 1095761925: {
                    if (!(t.value instanceof P3)) break;
                    P3 p3 = (P3)t.value;
                    sB.append("cell=").append(Escape.eP(p3));
                    continue block32;
                }
                case 4: {
                    sB.append("\"").appendO(t.value).append("\"");
                    continue block32;
                }
                case 0x10100190: 
                case 0x10100191: 
                case 269484434: 
                case 269484435: 
                case 269484436: 
                case 269484438: {
                    if (t.intValue == 1716520973) {
                        sB.append((String)tArray[++i].value).append(" ");
                        break;
                    }
                    if (t.intValue == Integer.MAX_VALUE) break;
                    sB.append(T.nameOf(t.intValue)).append(" ");
                    break;
                }
                case 364558: {
                    continue block32;
                }
                case 0x119009: {
                    sB.append("end");
                    continue block32;
                }
                default: {
                    if (T.tokAttr(t.tok, 0x40000000) || !bl) break;
                    sB.appendC('\n').append(t.toString()).appendC('\n');
                    continue block32;
                }
            }
            if (t.value == null) continue;
            sB.append(t.value.toString());
        }
        if (n >= n3 - 1 && n != 9999) {
            sB.append(" <<");
        }
        return sB.toString();
    }

    private Object getShapeProperty(int n, String string) {
        return this.sm.getShapePropertyIndex(n, string, Integer.MIN_VALUE);
    }

    private boolean getShapePropertyData(int n, String string, Object[] objectArray) {
        return this.sm.getShapePropertyData(n, string, objectArray);
    }

    private Object getShapePropertyIndex(int n, String string, int n2) {
        return this.sm.getShapePropertyIndex(n, string, n2);
    }

    private void addShapeProperty(JmolList<Object[]> jmolList, String string, Object object) {
        if (this.chk) {
            return;
        }
        jmolList.addLast(new Object[]{string, object});
    }

    private void setObjectMad(int n, String string, int n2) {
        if (this.chk) {
            return;
        }
        this.viewer.setObjectMad(n, string, n2);
    }

    private void setObjectArgb(String string, int n) {
        if (this.chk) {
            return;
        }
        this.viewer.setObjectArgb(string, n);
    }

    private void setShapeProperty(int n, String string, Object object) {
        if (this.chk) {
            return;
        }
        this.sm.setShapePropertyBs(n, string, object, null);
    }

    private void setShapePropertyBs(int n, String string, Object object, BS bS) {
        if (this.chk) {
            return;
        }
        this.sm.setShapePropertyBs(n, string, object, bS);
    }

    private void setShapeSizeBs(int n, int n2, BS bS) {
        if (this.chk) {
            return;
        }
        this.sm.setShapeSizeBs(n, n2, null, bS);
    }

    private void setShapeSize(int n, RadiusData radiusData) {
        if (this.chk) {
            return;
        }
        this.sm.setShapeSizeBs(n, 0, radiusData, null);
    }

    private void setBooleanProperty(String string, boolean bl) {
        if (!this.chk) {
            this.viewer.setBooleanProperty(string, bl);
        }
    }

    private boolean setIntProperty(String string, int n) {
        if (!this.chk) {
            this.viewer.setIntProperty(string, n);
        }
        return true;
    }

    private boolean setFloatProperty(String string, float f) {
        if (!this.chk) {
            this.viewer.setFloatProperty(string, f);
        }
        return true;
    }

    private void setStringProperty(String string, String string2) {
        if (!this.chk) {
            this.viewer.setStringProperty(string, string2);
        }
    }

    private void showString(String string) {
        this.showStringPrint(string, false);
    }

    private void showStringPrint(String string, boolean bl) {
        if (this.chk || string == null) {
            return;
        }
        if (this.outputBuffer != null) {
            this.outputBuffer.append(string).appendC('\n');
        } else {
            this.viewer.showString(string, bl);
        }
    }

    private void scriptStatusOrBuffer(String string) {
        if (this.chk) {
            return;
        }
        if (this.outputBuffer != null) {
            this.outputBuffer.append(string).appendC('\n');
            return;
        }
        this.viewer.scriptStatus(string);
    }

    private BS atomExpressionAt(int n) throws ScriptException {
        if (!this.checkToken(n)) {
            this.errorAt(2, n);
        }
        return this.atomExpression(this.st, n, 0, true, false, true, true);
    }

    private BS atomExpression(T[] tArray, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws ScriptException {
        this.isBondSet = false;
        if (tArray != this.st) {
            this.tempStatement = this.st;
            this.st = tArray;
        }
        ScriptMathProcessor scriptMathProcessor = new ScriptMathProcessor(this, false, false, bl3);
        int n3 = Integer.MAX_VALUE;
        boolean bl5 = false;
        this.iToken = 1000;
        boolean bl6 = n < 0;
        boolean bl7 = false;
        int n4 = 0;
        int n5 = this.viewer.getAtomCount();
        if (bl6) {
            n = -n;
        }
        bl6 |= this.chk;
        if (n2 == 0 && tArray.length > n) {
            n2 = n + 1;
        }
        block38: for (int i = n; i < n2; ++i) {
            this.iToken = i;
            T t = tArray[i];
            if (t == null) break;
            Object object = t.value;
            switch (t.tok) {
                case 0x100001: {
                    n = i;
                    n2 = tArray.length;
                    ++n4;
                    continue block38;
                }
                case 0x100002: {
                    if (--n4 <= 0) break block38;
                    continue block38;
                }
                case 0x10000A: {
                    Object object2;
                    if (!this.isPoint3f(i) || (object2 = this.getPoint3f(i, true)) == null) continue block38;
                    scriptMathProcessor.addXPt((P3)object2);
                    i = this.iToken;
                    continue block38;
                }
                case 0x10000E: {
                    if (i <= 0 || tArray[i - 1].tok != 0x10000A) continue block38;
                    scriptMathProcessor.addXBs(new BS());
                    continue block38;
                }
                case 0x10100040: {
                    bl7 = true;
                    scriptMathProcessor.addOp(t);
                    continue block38;
                }
                case 0x10100041: {
                    bl7 = false;
                    scriptMathProcessor.addOp(t);
                    continue block38;
                }
                case 1060866: {
                    scriptMathProcessor.addXBs(this.getAtomBitSet(object));
                    continue block38;
                }
                case 135267841: {
                    scriptMathProcessor.addXVar(SV.newScriptVariableToken(t));
                    scriptMathProcessor.addXVar(SV.newVariable(9, this.hklParameter(i + 2)));
                    i = this.iToken;
                    continue block38;
                }
                case 135266319: {
                    scriptMathProcessor.addXVar(SV.newScriptVariableToken(t));
                    scriptMathProcessor.addXVar(SV.newVariable(9, this.planeParameter(i + 2)));
                    i = this.iToken;
                    continue block38;
                }
                case 0x100006: {
                    scriptMathProcessor.addXVar(SV.newScriptVariableToken(t));
                    scriptMathProcessor.addXPt(this.getPoint3f(i + 2, true));
                    i = this.iToken;
                    continue block38;
                }
                case 4: {
                    BS bS;
                    Object object2 = (String)object;
                    if (((String)object2).indexOf("({") == 0 && (bS = Escape.uB((String)object2)) != null) {
                        scriptMathProcessor.addXBs(bS);
                        continue block38;
                    }
                    scriptMathProcessor.addXVar(SV.newScriptVariableToken(t));
                    if (!((String)object2).equals("hkl")) continue block38;
                    scriptMathProcessor.addXVar(SV.newVariable(9, this.hklParameter(i + 2)));
                    i = this.iToken;
                    continue block38;
                }
                case 135266310: 
                case 135266324: 
                case 135267335: 
                case 135267336: 
                case 135402505: 
                case 0x10100030: 
                case 1238369286: {
                    scriptMathProcessor.addOp(t);
                    continue block38;
                }
                case 0x100003: {
                    scriptMathProcessor.addXBs(this.viewer.getModelUndeletedAtomsBitSet(-1));
                    continue block38;
                }
                case 0x10000B: {
                    scriptMathProcessor.addXBs(new BS());
                    continue block38;
                }
                case 0x10000C: 
                case 0x10000D: {
                    scriptMathProcessor.addXVar(SV.newScriptVariableToken(t));
                    continue block38;
                }
                case 1114638350: {
                    scriptMathProcessor.addXBs(BSUtil.copy(this.viewer.getSelectionSet(false)));
                    continue block38;
                }
                case 0x303008: {
                    BS bS = this.viewer.getSelectionSubset();
                    scriptMathProcessor.addXBs(bS == null ? this.viewer.getModelUndeletedAtomsBitSet(-1) : BSUtil.copy(bS));
                    continue block38;
                }
                case 3145770: {
                    scriptMathProcessor.addXBs(BSUtil.copy(this.viewer.getHiddenSet()));
                    continue block38;
                }
                case 1060869: {
                    scriptMathProcessor.addXBs(BSUtil.copy(this.viewer.getMotionFixedAtoms()));
                    continue block38;
                }
                case 3145768: {
                    scriptMathProcessor.addXBs(BSUtil.copyInvert(this.viewer.getHiddenSet(), n5));
                    continue block38;
                }
                case 0x300030: {
                    scriptMathProcessor.addXBs(this.viewer.getBaseModelBitSet());
                    continue block38;
                }
                case 3145774: {
                    if (!this.chk && !bl5) {
                        this.viewer.setModelVisibility();
                    }
                    bl5 = true;
                    scriptMathProcessor.addXBs(this.viewer.getVisibleSet());
                    continue block38;
                }
                case 3145766: {
                    if (!this.chk && bl) {
                        this.refresh();
                    }
                    scriptMathProcessor.addXBs(this.viewer.getClickableSet());
                    continue block38;
                }
                case 0x100020: {
                    int n6;
                    if (this.viewer.allowSpecAtom()) {
                        n6 = t.intValue;
                        if (n6 > 0) {
                            scriptMathProcessor.addXBs(this.compareInt(1095761922, 269484436, n6));
                            continue block38;
                        }
                        scriptMathProcessor.addXBs(this.getAtomBits(t.tok, object));
                        continue block38;
                    }
                    scriptMathProcessor.addXBs(this.lookupIdentifierValue("_" + object));
                    continue block38;
                }
                case 0x100009: 
                case 0x10001F: 
                case 1048612: 
                case 0x300004: 
                case 0x30000E: 
                case 0x300010: 
                case 3145746: 
                case 3145748: 
                case 3145750: 
                case 3145764: 
                case 3145772: 
                case 1089470478: 
                case 0x60300006: 
                case 1614417948: {
                    scriptMathProcessor.addXBs(this.getAtomBits(t.tok, object));
                    continue block38;
                }
                case 0x100022: 
                case 1048611: {
                    int n6 = t.intValue;
                    if (n6 == Integer.MAX_VALUE && object instanceof Integer) {
                        n6 = (Integer)object;
                        if (!this.viewer.haveFileSet()) {
                            scriptMathProcessor.addXBs(this.getAtomBits(0x100022, n6));
                            continue block38;
                        }
                        if (n6 <= 2147) {
                            n6 *= 1000000;
                        }
                    }
                    scriptMathProcessor.addXBs(this.bitSetForModelFileNumber(n6));
                    continue block38;
                }
                case 0x100021: 
                case 1048613: {
                    scriptMathProcessor.addXBs(this.getAtomBits(t.tok, t.intValue));
                    continue block38;
                }
                case 1048614: {
                    if (bl7) {
                        scriptMathProcessor.addXNum(SV.newScriptVariableInt(t.intValue));
                        continue block38;
                    }
                    scriptMathProcessor.addXBs(this.getAtomBits(1048614, ScriptEvaluator.getSeqCode(t)));
                    continue block38;
                }
                case 1048615: {
                    if (bl7) {
                        scriptMathProcessor.addXNum(SV.newScriptVariableInt(t.intValue));
                        scriptMathProcessor.addOp(T.tokenMinus);
                        scriptMathProcessor.addXNum(SV.newScriptVariableInt(tArray[++i].intValue));
                        continue block38;
                    }
                    int n7 = i + 3 < tArray.length && tArray[i + 2].tok == 0x10100080 && tArray[i + 3].tok == 0x100021 ? tArray[i + 3].intValue : 9;
                    scriptMathProcessor.addXBs(this.getAtomBits(1048615, new int[]{ScriptEvaluator.getSeqCode(t), ScriptEvaluator.getSeqCode(tArray[++i]), n7}));
                    if (n7 == 9) continue block38;
                    i += 2;
                    continue block38;
                }
                case 1095761925: {
                    P3 p3 = (P3)object;
                    scriptMathProcessor.addXBs(this.getAtomBits(1095761925, new int[]{(int)Math.floor(p3.x * 1000.0f), (int)Math.floor(p3.y * 1000.0f), (int)Math.floor(p3.z * 1000.0f)}));
                    continue block38;
                }
                case 3145758: {
                    scriptMathProcessor.addXBs(this.viewer.getModelUndeletedAtomsBitSet(this.viewer.getCurrentModelIndex()));
                    continue block38;
                }
                case 0x300002: 
                case 0x300007: 
                case 0x300008: 
                case 0x30000A: 
                case 3145754: 
                case 3145756: 
                case 137363468: 
                case 1115297793: 
                case 1613758476: 
                case 1613758488: {
                    scriptMathProcessor.addXBs(this.lookupIdentifierValue((String)object));
                    continue block38;
                }
                case 0x10100190: 
                case 0x10100191: 
                case 269484434: 
                case 269484435: 
                case 269484436: 
                case 269484438: {
                    float[] fArray;
                    boolean bl8;
                    String string;
                    if (i + 1 == tArray.length) {
                        this.error(22);
                    }
                    Object object3 = tArray[++i].value;
                    int n8 = t.tok;
                    int n9 = t.intValue;
                    String string2 = string = n9 == 1716520973 ? (String)object3 : null;
                    if (string != null) {
                        if (i + 1 == tArray.length) {
                            this.error(22);
                        }
                        object3 = tArray[++i].value;
                    }
                    if (n9 == 1095766022 && n8 != 269484436) {
                        this.error(22);
                    }
                    if (this.chk) {
                        scriptMathProcessor.addXBs(new BS());
                        continue block38;
                    }
                    boolean bl9 = n9 == 1095766028;
                    boolean bl10 = T.tokAttr(n9, 1095761920);
                    boolean bl11 = T.tokAttr(n9, 1112539136);
                    boolean bl12 = bl10 && bl11;
                    boolean bl13 = bl8 = !bl10 && T.tokAttr(n9, 0x40D00000);
                    if (n9 == 1087375365) {
                        bl8 = false;
                        bl10 = !false;
                    }
                    int n10 = tArray[i].tok;
                    n3 = tArray[i].intValue;
                    float f = Float.NaN;
                    if (object3 instanceof P3) {
                        if (n9 == 1766856708) {
                            n3 = ColorUtil.colorPtToInt((P3)object3);
                            n10 = 2;
                            bl10 = true;
                        }
                    } else if (object3 instanceof String) {
                        if (n9 == 1766856708) {
                            n3 = ColorUtil.getArgbFromString((String)object3);
                            if (n3 == 0 && T.tokAttr(n10, 0x40000000)) {
                                n3 = ((String)(object3 = this.getStringParameter((String)object3, true))).startsWith("{") ? ((object3 = Escape.uP((String)object3)) instanceof P3 ? ColorUtil.colorPtToInt((P3)object3) : 0) : ColorUtil.getArgbFromString((String)object3);
                            }
                            n10 = 2;
                            bl10 = true;
                        } else if (bl8) {
                            if (T.tokAttr(n10, 0x40000000)) {
                                object3 = this.getStringParameter((String)object3, true);
                            }
                        } else {
                            if (T.tokAttr(n10, 0x40000000)) {
                                object3 = this.getNumericParameter((String)object3);
                            }
                            if (object3 instanceof String) {
                                if (n9 == 1641025539 || n9 == 1238369286 || n9 == 1087375365) {
                                    bl10 = n3 != Integer.MAX_VALUE;
                                    bl8 = !bl10;
                                } else {
                                    object3 = SV.nValue(tArray[i]);
                                }
                            }
                            if (object3 instanceof Integer) {
                                n3 = (Integer)object3;
                                f = n3;
                            } else if (object3 instanceof Float && bl9) {
                                n3 = ModelCollection.modelFileNumberFromFloat(((Float)object3).floatValue());
                            }
                        }
                    }
                    if (bl8 && !(object3 instanceof String)) {
                        object3 = "" + object3;
                    }
                    if (object3 instanceof Integer || n10 == 2) {
                        if (bl9) {
                            if (n3 >= 1000000) {
                                n9 = -1095766028;
                            }
                        } else if (bl12) {
                            bl11 = false;
                        } else if (bl11) {
                            f = n3;
                        }
                    } else if (object3 instanceof Float) {
                        if (bl9) {
                            n9 = -1095766028;
                        } else {
                            f = ((Float)object3).floatValue();
                            if (bl12) {
                                bl10 = false;
                            } else if (bl10) {
                                n3 = (int)f;
                            }
                        }
                    } else if (!bl8) {
                        ++this.iToken;
                        this.error(22);
                    }
                    if (bl9 && n3 >= 1000000 && n3 % 1000000 == 0) {
                        n3 /= 1000000;
                        n9 = 1229984263;
                        bl9 = false;
                    }
                    if (n9 == -1095766028 && n8 == 269484436) {
                        scriptMathProcessor.addXBs(this.bitSetForModelFileNumber(n3));
                        continue block38;
                    }
                    if (object != null && ((String)object).indexOf("-") >= 0) {
                        if (bl10) {
                            n3 = -n3;
                        } else if (!Float.isNaN(f)) {
                            f = -f;
                        }
                    }
                    float[] fArray2 = fArray = n9 == 1716520973 ? this.viewer.getDataFloat(string) : null;
                    scriptMathProcessor.addXBs(bl10 ? this.compareInt(n9, n8, n3) : (bl8 ? this.compareString(n9, n8, (String)object3) : this.compareFloatData(n9, fArray, n8, f)));
                    continue block38;
                }
                case 2: 
                case 3: {
                    scriptMathProcessor.addXNum(SV.newScriptVariableToken(t));
                    continue block38;
                }
                case 10: {
                    BS bS = BSUtil.copy((BS)object);
                    scriptMathProcessor.addXBs(bS);
                    continue block38;
                }
                case 8: {
                    scriptMathProcessor.addXPt((P3)object);
                    continue block38;
                }
                default: {
                    if (T.tokAttr(t.tok, 0x10100000)) {
                        if (scriptMathProcessor.addOp(t)) continue block38;
                        this.error(22);
                        continue block38;
                    }
                    if (!(object instanceof String)) {
                        scriptMathProcessor.addXObj(object);
                        continue block38;
                    }
                    Object object3 = this.getParameter((String)object, 0);
                    if (bl7) {
                        scriptMathProcessor.addXObj(object3);
                        continue block38;
                    }
                    if (object3 instanceof String) {
                        object3 = this.getStringObjectAsVariable((String)object3, null);
                    }
                    if (object3 instanceof JmolList) {
                        BS bS = SV.unEscapeBitSetArray((JmolList)object3, true);
                        object3 = bS == null ? object : bS;
                    }
                    if (object3 instanceof String) {
                        object3 = this.lookupIdentifierValue((String)object);
                    }
                    scriptMathProcessor.addXObj(object3);
                }
            }
        }
        this.expressionResult = scriptMathProcessor.getResult(bl2);
        if (this.expressionResult == null) {
            if (bl2) {
                return null;
            }
            if (!this.chk) {
                scriptMathProcessor.dumpStacks("after getResult");
            }
            this.error(13);
        }
        this.expressionResult = ((SV)this.expressionResult).value;
        if (this.expressionResult instanceof String && (bl3 || ((String)this.expressionResult).startsWith("({"))) {
            Object object = this.expressionResult = this.chk ? new BS() : this.getAtomBitSet(this.expressionResult);
        }
        if (!bl3 && !(this.expressionResult instanceof BS)) {
            return null;
        }
        BS bS = this.expressionResult instanceof BS ? (BS)this.expressionResult : new BS();
        this.isBondSet = this.expressionResult instanceof Bond.BondSet;
        if (!this.isBondSet) {
            this.viewer.excludeAtoms(bS, bl6);
            if (bS.length() > this.viewer.getAtomCount()) {
                bS.clearAll();
            }
        }
        if (this.tempStatement != null) {
            this.st = this.tempStatement;
            this.tempStatement = null;
        }
        return bS;
    }

    private BS compareFloatData(int n, float[] fArray, int n2, float f) {
        BS bS = new BS();
        int n3 = this.viewer.getAtomCount();
        ModelSet modelSet = this.viewer.modelSet;
        Atom[] atomArray = modelSet.atoms;
        float f2 = 0.0f;
        this.viewer.autoCalculate(n);
        int n4 = n3;
        block3: while (--n4 >= 0) {
            boolean bl = false;
            Atom atom = atomArray[n4];
            switch (n) {
                default: {
                    f2 = Atom.atomPropertyFloat(this.viewer, atom, n);
                    break;
                }
                case 1716520973: {
                    if (fArray == null || fArray.length <= n4) continue block3;
                    f2 = fArray[n4];
                }
            }
            if (!(bl = ScriptEvaluator.compareFloat(n2, f2, f))) continue;
            bS.set(n4);
        }
        return bS;
    }

    private BS compareString(int n, int n2, String string) throws ScriptException {
        boolean bl;
        BS bS = new BS();
        Atom[] atomArray = this.viewer.modelSet.atoms;
        int n3 = this.viewer.getAtomCount();
        boolean bl2 = bl = n == 0x40D00004 && this.viewer.getBoolean(603979822);
        if (!bl) {
            string = string.toLowerCase();
        }
        int n4 = n3;
        while (--n4 >= 0) {
            String string2 = Atom.atomPropertyString(this.viewer, atomArray[n4], n);
            if (!bl) {
                string2 = string2.toLowerCase();
            }
            if (!this.compareStringValues(n2, string2, string)) continue;
            bS.set(n4);
        }
        return bS;
    }

    protected BS compareInt(int n, int n2, int n3) {
        int n4 = Integer.MAX_VALUE;
        BS bS = null;
        int n5 = n2;
        int n6 = n3;
        int n7 = this.viewer.getAtomCount();
        ModelSet modelSet = this.viewer.modelSet;
        Atom[] atomArray = modelSet.atoms;
        int n8 = -1;
        int n9 = 0;
        int n10 = -1;
        int[] nArray = null;
        int n11 = 0;
        switch (n) {
            case 1297090050: {
                switch (n5) {
                    case 0x10100190: 
                    case 0x10100191: {
                        n8 = Integer.MAX_VALUE;
                    }
                }
                break;
            }
            case 1095761923: {
                try {
                    switch (n2) {
                        case 269484435: {
                            return BSUtil.newBitSet2(0, n3);
                        }
                        case 269484434: {
                            return BSUtil.newBitSet2(0, n3 + 1);
                        }
                        case 0x10100191: {
                            return BSUtil.newBitSet2(n3, n7);
                        }
                        case 0x10100190: {
                            return BSUtil.newBitSet2(n3 + 1, n7);
                        }
                        case 269484436: {
                            return n3 < n7 ? BSUtil.newBitSet2(n3, n3 + 1) : new BS();
                        }
                    }
                    BS bS2 = BSUtil.setAll(n7);
                    if (n3 >= 0) {
                        bS2.clear(n3);
                    }
                    return bS2;
                }
                catch (Exception exception) {
                    return new BS();
                }
            }
        }
        BS bS3 = BSUtil.newBitSet(n7);
        block37: for (int i = 0; i < n7; ++i) {
            boolean bl = false;
            Atom atom = atomArray[i];
            switch (n) {
                default: {
                    n4 = Atom.atomPropertyInt(atom, n);
                    break;
                }
                case 1095766022: {
                    return BSUtil.copy(this.viewer.getConformation(-1, n3 - 1, false));
                }
                case 1297090050: {
                    int n12;
                    bS = atom.getAtomSymmetry();
                    if (bS == null) continue block37;
                    if (atom.getModelIndex() != n10) {
                        n10 = atom.getModelIndex();
                        nArray = modelSet.getModelCellRange(n10);
                        n11 = modelSet.getModelSymmetryCount(n10);
                    }
                    if (n6 >= 200) {
                        if (nArray == null) continue block37;
                        n3 = n6 % 1000;
                        n12 = n6 / 1000 - 1;
                        if (n12 < 0) {
                            bl = true;
                        } else if (n11 == 0 || n12 >= 0 && !(bl = bS.get(n12))) continue block37;
                        n5 = 0x10000B;
                        n4 = n12 < 0 ? atom.getCellTranslation(n3, nArray, n11) : atom.getSymmetryTranslation(n12, nArray, n11);
                    } else if (n11 > 0) {
                        if (n3 > n11 && n5 != 269484435 && n5 != 269484434) continue block37;
                        if (n5 == 269484438) {
                            if (n3 <= 0 || n3 > n11 || bS.get(n3)) continue block37;
                            bS3.set(i);
                            continue block37;
                        }
                    }
                    switch (n5) {
                        case 269484435: {
                            n8 = n3 - 1;
                            break;
                        }
                        case 269484434: {
                            n8 = n3;
                            break;
                        }
                        case 0x10100191: {
                            n9 = n3 - 1;
                            break;
                        }
                        case 0x10100190: {
                            n9 = n3;
                            break;
                        }
                        case 269484436: {
                            n8 = n3;
                            n9 = n3 - 1;
                            break;
                        }
                        case 269484438: {
                            boolean bl2 = bl = !bS.get(n3);
                        }
                    }
                    if (n9 < 0) {
                        n9 = 0;
                    }
                    if (n9 < n8 && (n12 = bS.nextSetBit(n9)) >= 0 && n12 < n8) {
                        bl = true;
                    }
                    if (bl && n4 != Integer.MAX_VALUE) break;
                    n2 = 0x10000B;
                }
            }
            switch (n2) {
                case 0x10000B: {
                    break;
                }
                case 269484435: {
                    bl = n4 < n3;
                    break;
                }
                case 269484434: {
                    bl = n4 <= n3;
                    break;
                }
                case 0x10100191: {
                    bl = n4 >= n3;
                    break;
                }
                case 0x10100190: {
                    bl = n4 > n3;
                    break;
                }
                case 269484436: {
                    bl = n4 == n3;
                    break;
                }
                case 269484438: {
                    boolean bl3 = bl = n4 != n3;
                }
            }
            if (!bl) continue;
            bS3.set(i);
        }
        return bS3;
    }

    private boolean compareStringValues(int n, String string, String string2) throws ScriptException {
        switch (n) {
            case 269484436: 
            case 269484438: {
                return TextFormat.isMatch(string, string2, true, true) == (n == 269484436);
            }
        }
        this.error(22);
        return false;
    }

    private static boolean compareFloat(int n, float f, float f2) {
        switch (n) {
            case 269484435: {
                return f < f2;
            }
            case 269484434: {
                return f <= f2;
            }
            case 0x10100191: {
                return f >= f2;
            }
            case 0x10100190: {
                return f > f2;
            }
            case 269484436: {
                return f == f2;
            }
            case 269484438: {
                return f != f2;
            }
        }
        return false;
    }

    private BS getAtomBits(int n, Object object) {
        return this.chk ? new BS() : this.viewer.getAtomBits(n, object);
    }

    private static int getSeqCode(T t) {
        return t.intValue != Integer.MAX_VALUE ? Group.getSeqcodeFor(t.intValue, ' ') : (Integer)t.value;
    }

    private int checkLast(int n) throws ScriptException {
        return this.checkLength(n + 1) - 1;
    }

    private int checkLength(int n) throws ScriptException {
        if (n >= 0) {
            return this.checkLengthErrorPt(n, 0);
        }
        if (this.slen > -n) {
            this.iToken = -n;
            this.error(2);
        }
        return this.slen;
    }

    private int checkLengthErrorPt(int n, int n2) throws ScriptException {
        if (this.slen != n) {
            this.iToken = n2 > 0 ? n2 : this.slen;
            this.error(n2 > 0 ? 22 : 2);
        }
        return this.slen;
    }

    private int checkLength23() throws ScriptException {
        this.iToken = this.slen;
        if (this.slen != 2 && this.slen != 3) {
            this.error(2);
        }
        return this.slen;
    }

    private int checkLength34() throws ScriptException {
        this.iToken = this.slen;
        if (this.slen != 3 && this.slen != 4) {
            this.error(2);
        }
        return this.slen;
    }

    private T getToken(int n) throws ScriptException {
        if (!this.checkToken(n)) {
            this.error(13);
        }
        this.theToken = this.st[n];
        this.theTok = this.theToken.tok;
        return this.theToken;
    }

    private int tokAt(int n) {
        return n < this.slen && this.st[n] != null ? this.st[n].tok : 0;
    }

    private static int tokAtArray(int n, T[] tArray) {
        return n < tArray.length && tArray[n] != null ? tArray[n].tok : 0;
    }

    private T tokenAt(int n, T[] tArray) {
        return n < tArray.length ? tArray[n] : null;
    }

    private boolean checkToken(int n) {
        this.iToken = n;
        return this.iToken < this.slen;
    }

    private int modelNumberParameter(int n) throws ScriptException {
        int n2 = 0;
        boolean bl = false;
        switch (this.tokAt(n)) {
            case 2: {
                bl = true;
            }
            case 3: {
                n2 = this.getToken((int)n).intValue;
                break;
            }
            case 4: {
                n2 = ScriptEvaluator.getFloatEncodedInt(this.stringParameter(n));
                break;
            }
            default: {
                this.error(22);
            }
        }
        return this.viewer.getModelNumberIndex(n2, bl, true);
    }

    private String optParameterAsString(int n) throws ScriptException {
        if (n >= this.slen) {
            return "";
        }
        return this.parameterAsString(n);
    }

    private String parameterAsString(int n) throws ScriptException {
        this.getToken(n);
        if (this.theToken == null) {
            this.error(13);
        }
        return SV.sValue(this.theToken);
    }

    private int intParameter(int n) throws ScriptException {
        if (this.checkToken(n) && this.getToken((int)n).tok == 2) {
            return this.theToken.intValue;
        }
        this.error(20);
        return 0;
    }

    private int intParameterRange(int n, int n2, int n3) throws ScriptException {
        int n4 = this.intParameter(n);
        if (n4 < n2 || n4 > n3) {
            this.integerOutOfRange(n2, n3);
        }
        return n4;
    }

    private boolean isFloatParameter(int n) {
        switch (this.tokAt(n)) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    private float floatParameterRange(int n, float f, float f2) throws ScriptException {
        float f3 = this.floatParameter(n);
        if (f3 < f || f3 > f2) {
            this.numberOutOfRange(f, f2);
        }
        return f3;
    }

    private float floatParameter(int n) throws ScriptException {
        if (this.checkToken(n)) {
            this.getToken(n);
            switch (this.theTok) {
                case 1048615: {
                    return -this.theToken.intValue;
                }
                case 2: 
                case 1048614: {
                    return this.theToken.intValue;
                }
                case 3: 
                case 1048611: {
                    return ((Float)this.theToken.value).floatValue();
                }
            }
        }
        this.error(34);
        return 0.0f;
    }

    private float[] floatParameterSet(int n, int n2, int n3) throws ScriptException {
        int n4 = this.tokAt(n);
        if (n4 == 1073742195) {
            n4 = this.tokAt(++n);
        }
        boolean bl = n4 == 0x10000A;
        boolean bl2 = n4 == 0x10100040;
        float[] fArray = null;
        JmolList<Float> jmolList = new JmolList<Float>();
        int n5 = 0;
        if (bl || bl2) {
            ++n;
        }
        String string = null;
        block0 : switch (this.tokAt(n)) {
            case 4: {
                string = SV.sValue(this.st[n]);
                string = TextFormat.replaceAllCharacter(string, "{},[]\"'", ' ');
                fArray = Parser.parseFloatArray(string);
                n5 = fArray.length;
                break;
            }
            case 7: {
                fArray = SV.flistValue(this.st[n++], 0);
                n5 = fArray.length;
                break;
            }
            default: {
                while (n5 < n3) {
                    n4 = this.tokAt(n);
                    if (bl && n4 == 0x10000E || bl2 && n4 == 0x10100041) break block0;
                    switch (n4) {
                        case 0x10000A: 
                        case 0x10000E: 
                        case 0x10100030: {
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 8: {
                            P3 p3 = this.getPoint3f(n, false);
                            jmolList.addLast(Float.valueOf(p3.x));
                            jmolList.addLast(Float.valueOf(p3.y));
                            jmolList.addLast(Float.valueOf(p3.z));
                            n5 += 3;
                            break;
                        }
                        case 9: {
                            P4 p4 = this.getPoint4f(n);
                            jmolList.addLast(Float.valueOf(p4.x));
                            jmolList.addLast(Float.valueOf(p4.y));
                            jmolList.addLast(Float.valueOf(p4.z));
                            jmolList.addLast(Float.valueOf(p4.w));
                            n5 += 4;
                            break;
                        }
                        default: {
                            jmolList.addLast(Float.valueOf(this.floatParameter(n)));
                            if (++n5 != n3 || !bl2 || this.tokAt(n + 1) != 0x10000E) break;
                            ++n;
                        }
                    }
                    ++n;
                }
                break block0;
            }
        }
        if (bl && this.tokAt(n++) != 0x10000E || bl2 && this.tokAt(n++) != 0x10100041) {
            this.error(22);
        }
        this.iToken = n - 1;
        if (n5 < n2 || n5 > n3) {
            this.error(22);
        }
        if (fArray == null) {
            fArray = new float[n5];
            for (int i = 0; i < n5; ++i) {
                fArray[i] = ((Float)jmolList.get(i)).floatValue();
            }
        }
        return fArray;
    }

    private boolean isArrayParameter(int n) {
        switch (this.tokAt(n)) {
            case 7: 
            case 11: 
            case 12: 
            case 0x10100040: 
            case 1073742195: {
                return true;
            }
        }
        return false;
    }

    private P3[] getPointArray(int n, int n2) throws ScriptException {
        P3[] p3Array = n2 < 0 ? null : new P3[n2];
        JmolList<P3> jmolList = n2 < 0 ? new JmolList<P3>() : null;
        int n3 = n < 0 ? 7 : this.getToken((int)n++).tok;
        switch (n3) {
            case 7: {
                JmolList<SV> jmolList2 = ((SV)this.theToken).getList();
                if (n2 >= 0 && jmolList2.size() != n2) {
                    this.error(22);
                }
                n2 = jmolList2.size();
                if (p3Array == null) {
                    p3Array = new P3[n2];
                }
                for (int i = 0; i < n2; ++i) {
                    p3Array[i] = SV.ptValue((SV)jmolList2.get(i));
                    if (p3Array[i] != null) continue;
                    this.error(22);
                }
                return p3Array;
            }
            case 1073742195: {
                n3 = this.tokAt(n++);
            }
        }
        if (n3 != 0x10100040) {
            this.error(22);
        }
        int n4 = 0;
        block9: while (n3 != 0x10100041 && n3 != 0) {
            n3 = this.getToken((int)n).tok;
            switch (n3) {
                case 0: 
                case 0x10100041: {
                    continue block9;
                }
                case 0x10100030: {
                    ++n;
                    continue block9;
                }
            }
            if (n2 >= 0 && n4 == n2) {
                n3 = 0;
                continue;
            }
            P3 p3 = this.getPoint3f(n, true);
            if (p3Array == null) {
                jmolList.addLast(p3);
            } else {
                p3Array[n4] = p3;
            }
            ++n4;
            n = this.iToken + 1;
        }
        if (n3 != 0x10100041) {
            this.error(22);
        }
        if (p3Array == null) {
            p3Array = jmolList.toArray(new P3[jmolList.size()]);
        }
        return p3Array;
    }

    private float[][] floatArraySet(int n, int n2, int n3) throws ScriptException {
        int n4;
        if ((n4 = this.tokAt(n++)) == 1073742195) {
            n4 = this.tokAt(n++);
        }
        if (n4 != 0x10100040) {
            this.error(22);
        }
        float[][] fArray = ArrayUtil.newFloat2(n2);
        int n5 = 0;
        block5: while (n4 != 0x10100041) {
            n4 = this.getToken((int)n).tok;
            switch (n4) {
                case 0x10100041: 
                case 1073742195: {
                    continue block5;
                }
                case 0x10100030: {
                    ++n;
                    continue block5;
                }
                case 0x10100040: {
                    ++n;
                    float[] fArray2 = new float[n3];
                    fArray[n5++] = fArray2;
                    for (int i = 0; i < n3; ++i) {
                        fArray2[i] = this.floatParameter(n++);
                        if (this.tokAt(n) != 0x10100030) continue;
                        ++n;
                    }
                    if (this.tokAt(n++) != 0x10100041) {
                        this.error(22);
                    }
                    n4 = 0;
                    if (n5 != n2 || this.tokAt(n) == 0x10100041) continue block5;
                    this.error(22);
                    continue block5;
                }
            }
            this.error(22);
        }
        return fArray;
    }

    private float[][][] floatArraySetXYZ(int n, int n2, int n3, int n4) throws ScriptException {
        int n5;
        if ((n5 = this.tokAt(n++)) == 1073742195) {
            n5 = this.tokAt(n++);
        }
        if (n5 != 0x10100040 || n2 <= 0) {
            this.error(22);
        }
        float[][][] fArray = ArrayUtil.newFloat3(n2, -1);
        int n6 = 0;
        block5: while (n5 != 0x10100041) {
            n5 = this.getToken((int)n).tok;
            switch (n5) {
                case 0x10100041: 
                case 1073742195: {
                    continue block5;
                }
                case 0x10100030: {
                    ++n;
                    continue block5;
                }
                case 0x10100040: {
                    fArray[n6++] = this.floatArraySet(n, n3, n4);
                    n = ++this.iToken;
                    n5 = 0;
                    if (n6 != n2 || this.tokAt(n) == 0x10100041) continue block5;
                    this.error(22);
                    continue block5;
                }
            }
            this.error(22);
        }
        return fArray;
    }

    private String stringParameter(int n) throws ScriptException {
        if (!this.checkToken(n) || this.getToken((int)n).tok != 4) {
            this.error(41);
        }
        return (String)this.theToken.value;
    }

    private String[] stringParameterSet(int n) throws ScriptException {
        int n2;
        switch (this.tokAt(n)) {
            case 4: {
                Object object;
                String string = this.stringParameter(n);
                if (string.startsWith("[\"") && (object = this.viewer.evaluateExpression(string)) instanceof String) {
                    return TextFormat.split((String)object, '\n');
                }
                return new String[]{string};
            }
            case 1073742195: {
                n += 2;
                break;
            }
            case 0x10100040: {
                ++n;
                break;
            }
            case 7: {
                return SV.listValue(this.getToken(n));
            }
            default: {
                this.error(22);
            }
        }
        JmolList<String> jmolList = new JmolList<String>();
        while ((n2 = this.tokAt(n)) != 0x10100041) {
            switch (n2) {
                case 0x10100030: {
                    break;
                }
                case 4: {
                    jmolList.addLast(this.stringParameter(n));
                    break;
                }
                default: {
                    this.error(22);
                }
            }
            ++n;
        }
        this.iToken = n;
        int n3 = jmolList.size();
        String[] stringArray = new String[n3];
        for (int i = 0; i < n3; ++i) {
            stringArray[i] = (String)jmolList.get(i);
        }
        return stringArray;
    }

    private String objectNameParameter(int n) throws ScriptException {
        if (!this.checkToken(n)) {
            this.error(37);
        }
        return this.parameterAsString(n);
    }

    private boolean booleanParameter(int n) throws ScriptException {
        if (this.slen == n) {
            return true;
        }
        switch (this.getToken((int)this.checkLast((int)n)).tok) {
            case 0x10000D: {
                return true;
            }
            case 0x10000C: {
                return false;
            }
        }
        this.error(5);
        return false;
    }

    private P3 atomCenterOrCoordinateParameter(int n) throws ScriptException {
        switch (this.getToken((int)n).tok) {
            case 10: 
            case 0x100001: {
                BS bS = this.atomExpression(this.st, n, 0, true, false, false, true);
                if (bS != null) {
                    return this.viewer.getAtomSetCenter(bS);
                }
                if (this.expressionResult instanceof P3) {
                    return (P3)this.expressionResult;
                }
                this.error(22);
                break;
            }
            case 8: 
            case 0x10000A: {
                return this.getPoint3f(n, true);
            }
        }
        this.error(22);
        return null;
    }

    private boolean isCenterParameter(int n) {
        int n2 = this.tokAt(n);
        return n2 == 0x100007 || n2 == 0x10000A || n2 == 0x100001 || n2 == 8 || n2 == 10;
    }

    private P3 centerParameter(int n) throws ScriptException {
        return this.centerParameterForModel(n, Integer.MIN_VALUE);
    }

    private P3 centerParameterForModel(int n, int n2) throws ScriptException {
        P3 p3 = null;
        this.expressionResult = null;
        if (this.checkToken(n)) {
            switch (this.getToken((int)n).tok) {
                case 0x100007: {
                    String string = this.objectNameParameter(++n);
                    int n3 = Integer.MIN_VALUE;
                    if (this.tokAt(n + 1) == 0x10100040) {
                        n3 = ((SV)this.parameterExpressionList(-n - 1, -1, true).get(0)).asInt();
                        if (this.getToken((int)(--this.iToken)).tok != 0x10100041) {
                            this.error(22);
                        }
                    }
                    if (this.chk) {
                        return new P3();
                    }
                    if (this.tokAt(n + 1) == 0x100008 && (this.tokAt(n + 2) == 1141899267 || this.tokAt(n + 2) == 1141899270)) {
                        n3 = Integer.MAX_VALUE;
                        this.iToken = n + 2;
                    }
                    if ((p3 = this.getObjectCenter(string, n3, n2)) != null) break;
                    this.errorStr(12, string);
                    break;
                }
                case 8: 
                case 10: 
                case 0x100001: 
                case 0x10000A: {
                    p3 = this.atomCenterOrCoordinateParameter(n);
                }
            }
        }
        if (p3 == null) {
            this.error(11);
        }
        return p3;
    }

    private P4 planeParameter(int n) throws ScriptException {
        boolean bl;
        Tuple4f tuple4f;
        block28: {
            V3 v3 = new V3();
            V3 v32 = new V3();
            tuple4f = null;
            boolean bl2 = bl = this.tokAt(n) == 0x101000A0;
            if (bl) {
                ++n;
            }
            if (n >= this.slen) break block28;
            switch (this.getToken((int)n).tok) {
                case 9: {
                    tuple4f = P4.newPt((P4)this.theToken.value);
                    break;
                }
                case 0x100007: {
                    String string = this.objectNameParameter(++n);
                    if (this.chk) {
                        return new P4();
                    }
                    int n2 = this.sm.getShapeIdFromObjectName(string);
                    switch (n2) {
                        case 22: {
                            this.setShapeProperty(22, "thisID", string);
                            P3[] p3Array = (P3[])this.getShapeProperty(22, "vertices");
                            if (p3Array != null && p3Array.length >= 3 && p3Array[0] != null && p3Array[1] != null) {
                                if (p3Array[2] == null) break;
                                tuple4f = new P4();
                                Measure.getPlaneThroughPoints(p3Array[0], p3Array[1], p3Array[2], new V3(), v3, v32, (P4)tuple4f);
                                break;
                            }
                            break block28;
                        }
                        case 24: {
                            this.setShapeProperty(24, "thisID", string);
                            tuple4f = (P4)this.getShapeProperty(24, "plane");
                        }
                    }
                    break;
                }
                case 1112541205: {
                    if (!this.checkToken(++n) || this.getToken((int)n++).tok != 269484436) {
                        this.evalError("x=?", null);
                    }
                    tuple4f = P4.new4(1.0f, 0.0f, 0.0f, -this.floatParameter(n));
                    break;
                }
                case 1112541206: {
                    if (!this.checkToken(++n) || this.getToken((int)n++).tok != 269484436) {
                        this.evalError("y=?", null);
                    }
                    tuple4f = P4.new4(0.0f, 1.0f, 0.0f, -this.floatParameter(n));
                    break;
                }
                case 1112541207: {
                    if (!this.checkToken(++n) || this.getToken((int)n++).tok != 269484436) {
                        this.evalError("z=?", null);
                    }
                    tuple4f = P4.new4(0.0f, 0.0f, 1.0f, -this.floatParameter(n));
                    break;
                }
                case 4: 
                case 0x40000000: {
                    String string = this.parameterAsString(n);
                    if (string.equalsIgnoreCase("xy")) {
                        return P4.new4(0.0f, 0.0f, 1.0f, 0.0f);
                    }
                    if (string.equalsIgnoreCase("xz")) {
                        return P4.new4(0.0f, 1.0f, 0.0f, 0.0f);
                    }
                    if (string.equalsIgnoreCase("yz")) {
                        return P4.new4(1.0f, 0.0f, 0.0f, 0.0f);
                    }
                    this.iToken += 2;
                    break;
                }
                case 0x10000A: {
                    if (!this.isPoint3f(n)) {
                        tuple4f = this.getPoint4f(n);
                        break;
                    }
                }
                case 10: 
                case 0x100001: {
                    P3 p3 = this.atomCenterOrCoordinateParameter(n);
                    if (this.getToken((int)(++this.iToken)).tok == 0x10100030) {
                        ++this.iToken;
                    }
                    P3 p32 = this.atomCenterOrCoordinateParameter(this.iToken);
                    if (this.getToken((int)(++this.iToken)).tok == 0x10100030) {
                        ++this.iToken;
                    }
                    P3 p33 = this.atomCenterOrCoordinateParameter(this.iToken);
                    n = this.iToken;
                    V3 v33 = new V3();
                    float f = Measure.getNormalThroughPoints(p3, p32, p33, v33, v3, v32);
                    tuple4f = new P4();
                    tuple4f.set(v33.x, v33.y, v33.z, f);
                    if (this.chk || !Logger.debugging) break;
                    Logger.debug("points: " + p3 + p32 + p33 + " defined plane: " + tuple4f);
                }
            }
        }
        if (tuple4f == null) {
            this.planeExpected();
        }
        if (bl) {
            tuple4f.scale(-1.0f);
        }
        return tuple4f;
    }

    private P4 hklParameter(int n) throws ScriptException {
        P3 p3;
        P4 p4;
        if (!this.chk && this.viewer.getCurrentUnitCell() == null) {
            this.error(33);
        }
        if ((p4 = this.getHklPlane(p3 = (P3)this.getPointOrPlane(n, false, true, false, true, 3, 3))) == null) {
            this.error(3);
        }
        if (!this.chk && Logger.debugging) {
            Logger.info("defined plane: " + p4);
        }
        return p4;
    }

    protected P4 getHklPlane(P3 p3) {
        V3 v3 = new V3();
        V3 v32 = new V3();
        P3 p32 = P3.new3(p3.x == 0.0f ? 1.0f : 1.0f / p3.x, 0.0f, 0.0f);
        P3 p33 = P3.new3(0.0f, p3.y == 0.0f ? 1.0f : 1.0f / p3.y, 0.0f);
        P3 p34 = P3.new3(0.0f, 0.0f, p3.z == 0.0f ? 1.0f : 1.0f / p3.z);
        if (p3.x == 0.0f && p3.y == 0.0f && p3.z == 0.0f) {
            return null;
        }
        if (p3.x == 0.0f && p3.y == 0.0f) {
            p32.set(1.0f, 0.0f, p34.z);
            p33.set(0.0f, 1.0f, p34.z);
        } else if (p3.y == 0.0f && p3.z == 0.0f) {
            p33.set(p32.x, 0.0f, 1.0f);
            p34.set(p32.x, 1.0f, 0.0f);
        } else if (p3.z == 0.0f && p3.x == 0.0f) {
            p34.set(0.0f, p33.y, 1.0f);
            p32.set(1.0f, p33.y, 0.0f);
        } else if (p3.x == 0.0f) {
            p32.set(1.0f, p33.y, 0.0f);
        } else if (p3.y == 0.0f) {
            p33.set(0.0f, 1.0f, p34.z);
        } else if (p3.z == 0.0f) {
            p34.set(p32.x, 0.0f, 1.0f);
        }
        this.viewer.toCartesian(p32, false);
        this.viewer.toCartesian(p33, false);
        this.viewer.toCartesian(p34, false);
        V3 v33 = new V3();
        float f = Measure.getNormalThroughPoints(p32, p33, p34, v33, v3, v32);
        P4 p4 = new P4();
        p4.set(v33.x, v33.y, v33.z, f);
        return p4;
    }

    private int getMadParameter() throws ScriptException {
        int n = 1;
        switch (this.getToken((int)1).tok) {
            case 1073742072: {
                this.restrictSelected(false, false);
                break;
            }
            case 0x10000D: {
                break;
            }
            case 0x10000C: {
                n = 0;
                break;
            }
            case 2: {
                int n2 = this.intParameterRange(1, 0, 750);
                n = n2 * 4 * 2;
                break;
            }
            case 3: {
                n = (int)Math.floor(this.floatParameterRange(1, -3.0f, 3.0f) * 1000.0f * 2.0f);
                if (n >= 0) break;
                this.restrictSelected(false, false);
                n = -n;
                break;
            }
            default: {
                this.error(6);
            }
        }
        return n;
    }

    private int getSetAxesTypeMad(int n) throws ScriptException {
        if (n == this.slen) {
            return 1;
        }
        switch (this.getToken((int)this.checkLast((int)n)).tok) {
            case 0x10000D: {
                return 1;
            }
            case 0x10000C: {
                return 0;
            }
            case 0x40000066: {
                return -1;
            }
            case 2: {
                return this.intParameterRange(n, -1, 19);
            }
            case 3: {
                float f = this.floatParameterRange(n, 0.0f, 2.0f);
                return (int)Math.floor(f * 1000.0f * 2.0f);
            }
        }
        this.errorStr(7, "\"DOTTED\"");
        return 0;
    }

    private boolean isColorParam(int n) {
        int n2 = this.tokAt(n);
        return n2 == 0x22000022 || n2 == 1073742195 || n2 == 0x10100040 || n2 == 7 || n2 == 8 || this.isPoint3f(n) || (n2 == 4 || T.tokAttr(n2, 0x40000000)) && ColorUtil.getArgbFromString((String)this.st[n].value) != 0;
    }

    private int getArgbParam(int n) throws ScriptException {
        return this.getArgbParamOrNone(n, false);
    }

    private int getArgbParamLast(int n, boolean bl) throws ScriptException {
        int n2 = this.getArgbParamOrNone(n, bl);
        this.checkLast(this.iToken);
        return n2;
    }

    private int getArgbParamOrNone(int n, boolean bl) throws ScriptException {
        P3 p3 = null;
        if (this.checkToken(n)) {
            switch (this.getToken((int)n).tok) {
                default: {
                    if (!T.tokAttr(this.theTok, 0x40000000)) break;
                }
                case 4: 
                case 0x22000022: {
                    return ColorUtil.getArgbFromString(this.parameterAsString(n));
                }
                case 1073742195: {
                    return this.getColorTriad(n + 2);
                }
                case 0x10100040: {
                    return this.getColorTriad(++n);
                }
                case 7: {
                    float[] fArray = SV.flistValue(this.theToken, 3);
                    if (fArray == null || fArray.length == 3) break;
                    p3 = P3.new3(fArray[0], fArray[1], fArray[2]);
                    break;
                }
                case 8: {
                    p3 = (P3)this.theToken.value;
                    break;
                }
                case 0x10000A: {
                    p3 = this.getPoint3f(n, false);
                    break;
                }
                case 0x10000B: {
                    if (!bl) break;
                    return 0;
                }
            }
        }
        if (p3 == null) {
            this.error(8);
        }
        return ColorUtil.colorPtToInt(p3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getColorTriad(int n) throws ScriptException {
        P3 p3;
        String string;
        int n2;
        block22: {
            float[] fArray = new float[3];
            n2 = 0;
            string = "";
            this.getToken(n);
            p3 = null;
            float f = 0.0f;
            switch (this.theTok) {
                case 2: 
                case 3: 
                case 1048614: {
                    break;
                }
                case 8: {
                    p3 = (P3)this.theToken.value;
                    break block22;
                }
                case 0x40000000: {
                    string = this.parameterAsString(n);
                    break block22;
                }
                default: {
                    this.error(4);
                    break block22;
                }
            }
            while (n < this.slen) {
                block23: {
                    switch (this.getToken((int)n).tok) {
                        case 0x10100030: {
                            break block23;
                        }
                        case 0x40000000: {
                            if (n2 != 1 || fArray[0] != 0.0f) {
                                this.error(4);
                            }
                            string = "0" + this.parameterAsString(n);
                            break block22;
                        }
                        case 3: {
                            if (n2 > 2) {
                                this.error(4);
                            }
                            f = this.floatParameter(n);
                            break;
                        }
                        case 2: {
                            if (n2 > 2) {
                                this.error(4);
                            }
                            f = this.theToken.intValue;
                            break;
                        }
                        case 1048614: {
                            if (n2 > 2) {
                                this.error(4);
                            }
                            f = (Integer)this.theToken.value % 256;
                            break;
                        }
                        case 0x10100041: {
                            if (n2 != 3) {
                                this.error(4);
                            }
                            --n;
                            p3 = P3.new3(fArray[0], fArray[1], fArray[2]);
                            break block22;
                        }
                        default: {
                            this.error(4);
                        }
                    }
                    fArray[n2++] = f;
                }
                ++n;
            }
            this.error(4);
        }
        if (this.getToken((int)(++n)).tok != 0x10100041) {
            this.error(4);
        }
        if (p3 != null) {
            return ColorUtil.colorPtToInt(p3);
        }
        n2 = ColorUtil.getArgbFromString("[" + string + "]");
        if (n2 == 0) {
            this.error(4);
        }
        return n2;
    }

    private boolean isPoint3f(int n) {
        boolean bl = this.tokAt(n) == 8;
        if (bl || this.tokAt(n) == 9 || this.isFloatParameter(n + 1) && this.isFloatParameter(n + 2) && this.isFloatParameter(n + 3) && this.isFloatParameter(n + 4)) {
            return bl;
        }
        this.ignoreError = true;
        int n2 = this.iToken;
        bl = true;
        try {
            this.getPoint3f(n, true);
        }
        catch (Exception exception) {
            bl = false;
        }
        this.ignoreError = false;
        this.iToken = n2;
        return bl;
    }

    private P3 getPoint3f(int n, boolean bl) throws ScriptException {
        return (P3)this.getPointOrPlane(n, false, bl, true, false, 3, 3);
    }

    private P4 getPoint4f(int n) throws ScriptException {
        return (P4)this.getPointOrPlane(n, false, false, false, false, 4, 4);
    }

    private Object getPointOrPlane(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2, int n3) throws ScriptException {
        float[] fArray = new float[6];
        int n4 = 0;
        this.coordinatesAreFractional = bl4;
        if (this.tokAt(n) == 8) {
            if (n2 <= 3 && n3 >= 3) {
                return this.getToken((int)n).value;
            }
            this.error(22);
        }
        if (this.tokAt(n) == 9) {
            if (n2 <= 4 && n3 >= 4) {
                return this.getToken((int)n).value;
            }
            this.error(22);
        }
        int n5 = 1;
        block9: for (int i = n; i < this.st.length; ++i) {
            switch (this.getToken((int)i).tok) {
                case 0x10000A: 
                case 0x10100030: 
                case 0x10100060: 
                case 0x10100080: {
                    continue block9;
                }
                case 0x10000E: {
                    break block9;
                }
                case 0x101000A0: {
                    n5 = -1;
                    continue block9;
                }
                case 1048615: {
                    if (n4 == 6) {
                        this.error(22);
                    }
                    fArray[n4++] = this.theToken.intValue;
                    n5 = -1;
                    continue block9;
                }
                case 2: 
                case 1048614: {
                    if (n4 == 6) {
                        this.error(22);
                    }
                    fArray[n4++] = this.theToken.intValue * n5;
                    n5 = 1;
                    continue block9;
                }
                case 0x100022: 
                case 0x101000B0: {
                    if (!bl2) {
                        this.error(22);
                    }
                    if (this.theTok == 0x101000B0) {
                        this.getToken(++i);
                    }
                    if (--n4 < 0 || bl) {
                        this.error(22);
                    }
                    if (this.theToken.value instanceof Integer || this.theTok == 2) {
                        int n6 = n4++;
                        fArray[n6] = fArray[n6] / (float)(this.theToken.intValue == Integer.MAX_VALUE ? (Integer)this.theToken.value : this.theToken.intValue);
                    } else if (this.theToken.value instanceof Float) {
                        int n7 = n4++;
                        fArray[n7] = fArray[n7] / ((Float)this.theToken.value).floatValue();
                    }
                    this.coordinatesAreFractional = true;
                    continue block9;
                }
                case 3: 
                case 1048611: {
                    if (bl) {
                        this.error(22);
                    }
                    if (n4 == 6) {
                        this.error(22);
                    }
                    fArray[n4++] = ((Float)this.theToken.value).floatValue();
                    continue block9;
                }
                default: {
                    this.error(22);
                }
            }
        }
        if (n4 < n2 || n4 > n3) {
            this.error(22);
        }
        if (n4 == 3) {
            P3 p3 = P3.new3(fArray[0], fArray[1], fArray[2]);
            if (this.coordinatesAreFractional && bl3) {
                this.fractionalPoint = P3.newP(p3);
                if (!this.chk) {
                    this.viewer.toCartesian(p3, !this.viewer.getBoolean(603979848));
                }
            }
            return p3;
        }
        if (n4 == 4) {
            if (this.coordinatesAreFractional) {
                this.error(22);
            }
            P4 p4 = P4.new4(fArray[0], fArray[1], fArray[2], fArray[3]);
            return p4;
        }
        return fArray;
    }

    private P3 xypParameter(int n) throws ScriptException {
        boolean bl;
        int n2 = this.tokAt(n);
        if (n2 == 1073742195) {
            n2 = this.tokAt(++n);
        }
        if (n2 != 0x10100040 || !this.isFloatParameter(++n)) {
            return null;
        }
        P3 p3 = new P3();
        p3.x = this.floatParameter(n);
        if (this.tokAt(++n) == 0x10100030) {
            ++n;
        }
        if (!this.isFloatParameter(n)) {
            return null;
        }
        p3.y = this.floatParameter(n);
        boolean bl2 = bl = this.tokAt(++n) == 269484210;
        if (bl) {
            ++n;
        }
        if (this.tokAt(n) != 0x10100041) {
            return null;
        }
        this.iToken = n;
        p3.z = (float)(bl ? -1 : 1) * Float.MAX_VALUE;
        return p3;
    }

    private boolean isCommandDisplayable(int n) {
        if (n >= this.aatoken.length || n >= this.pcEnd || this.aatoken[n] == null) {
            return false;
        }
        return this.lineIndices[n][1] > this.lineIndices[n][0];
    }

    private boolean checkContinue() throws ScriptException {
        if (this.executionStopped) {
            return false;
        }
        if (this.executionStepping && this.isCommandDisplayable(this.pc)) {
            this.viewer.setScriptStatus("Next: " + this.getNextStatement(), "stepping -- type RESUME to continue", 0, null);
            this.executionPaused = true;
        } else if (!this.executionPaused) {
            return true;
        }
        if (Logger.debugging) {
            Logger.info("script execution paused at command " + (this.pc + 1) + " level " + this.scriptLevel + ": " + this.thisCommand);
        }
        this.refresh();
        while (this.executionPaused) {
            this.viewer.popHoldRepaintWhy("pause");
            String string = this.viewer.getInsertedCommand();
            if (string != "") {
                this.resumePausedExecution();
                this.setErrorMessage(null);
                ScriptContext scriptContext = this.getScriptContext();
                --this.pc;
                try {
                    this.runScript(string);
                }
                catch (Exception exception) {
                    this.setErrorMessage("" + exception);
                }
                catch (Error error) {
                    this.setErrorMessage("" + error);
                }
                if (this.error) {
                    this.scriptStatusOrBuffer(this.errorMessage);
                    this.setErrorMessage(null);
                }
                this.restoreScriptContext(scriptContext, true, false, false);
                this.pauseExecution(false);
            }
            this.doDelay(-100);
            this.viewer.pushHoldRepaintWhy("pause");
        }
        this.notifyResumeStatus();
        return !this.error && !this.executionStopped;
    }

    @Override
    public void notifyResumeStatus() {
        if (!(this.chk || this.executionStopped || this.executionStepping)) {
            this.viewer.scriptStatus("script execution " + (this.error || this.executionStopped ? "interrupted" : "resumed"));
        }
        Logger.debug("script execution resumed");
    }

    private void doDelay(int n) throws ScriptException {
        if (!this.useThreads()) {
            return;
        }
        if (this.isJS && this.allowJSThreads) {
            throw new ScriptInterruption(this, "delay", n);
        }
        this.viewer.delayScript(this, n);
    }

    private boolean dispatchCommands(boolean bl, boolean bl2) throws ScriptException {
        long l = 0L;
        if (this.sm == null) {
            this.sm = this.viewer.getShapeManager();
        }
        this.logMessages = false;
        this.debugScript = false;
        if (!this.chk) {
            this.setDebugging();
        }
        if (this.logMessages) {
            l = System.currentTimeMillis();
            this.viewer.scriptStatus("Eval.dispatchCommands():" + l);
            this.viewer.scriptStatus(this.script);
        }
        if (this.pcEnd == 0) {
            this.pcEnd = Integer.MAX_VALUE;
        }
        if (this.lineEnd == 0) {
            this.lineEnd = Integer.MAX_VALUE;
        }
        if (this.aatoken == null) {
            return true;
        }
        this.commandLoop(bl2);
        if (this.chk) {
            return true;
        }
        String string = this.viewer.getInsertedCommand();
        if (string != "") {
            this.runScriptBuffer(string, null);
        } else if (bl && this.debugScript && this.viewer.getBoolean(603979879)) {
            this.viewer.scriptStatus("script <exiting>");
        }
        if (!this.isJS || !this.allowJSThreads || bl2) {
            return true;
        }
        if (this.mustResumeEval || this.thisContext == null) {
            boolean bl3 = this.thisContext == null;
            this.resumeEval(this.thisContext);
            this.mustResumeEval = false;
            return bl3;
        }
        return true;
    }

    private void commandLoop(boolean bl) throws ScriptException {
        String string = "";
        boolean bl2 = false;
        JmolList<T[]> jmolList = null;
        long l = System.currentTimeMillis();
        while (this.pc < this.aatoken.length && this.pc < this.pcEnd) {
            block111: {
                block114: {
                    block113: {
                        block112: {
                            block110: {
                                String string2;
                                if (!this.chk && this.isJS && this.allowJSThreads && !bl) {
                                    if (!this.executionPaused && System.currentTimeMillis() - l > 100L) {
                                        --this.pc;
                                        this.doDelay(-1);
                                    }
                                    l = System.currentTimeMillis();
                                }
                                if (!this.chk && !this.checkContinue() || this.lineNumbers[this.pc] > this.lineEnd) break;
                                T t = this.theToken = this.aatoken[this.pc].length == 0 ? null : this.aatoken[this.pc][0];
                                if (!(this.historyDisabled || this.chk || this.scriptLevel > this.commandHistoryLevelMax || this.tQuiet)) {
                                    string2 = this.getCommand(this.pc, true, true);
                                    if (!(this.theToken == null || string2.length() <= 0 || string2.equals(string) || this.theToken.tok != 135368713 && this.theToken.tok != 102436 && T.tokAttr(this.theToken.tok, 102400))) {
                                        string = string2;
                                        this.viewer.addCommand(string);
                                    }
                                }
                                if (!this.chk && (string2 = this.viewer.getInsertedCommand()) != "") {
                                    this.runScript(string2);
                                }
                                if (this.setStatement(this.pc)) break block110;
                                Logger.info(this.getCommand(this.pc, true, false) + " -- STATEMENT CONTAINING @{} SKIPPED");
                                break block111;
                            }
                            this.thisCommand = this.getCommand(this.pc, false, true);
                            this.fullCommand = this.thisCommand + this.getNextComment();
                            this.getToken(0);
                            this.iToken = 0;
                            if ((this.listCommands || !this.chk && this.scriptLevel > 0) && !this.isJS) {
                                int n = this.viewer.getInt(0x2000000A);
                                if (this.listCommands || n > 0) {
                                    if (n > 0) {
                                        this.viewer.delayScript(this, -n);
                                    }
                                    this.viewer.scriptEcho("$[" + this.scriptLevel + "." + this.lineNumbers[this.pc] + "." + (this.pc + 1) + "] " + this.thisCommand);
                                }
                            }
                            if (jmolList == null || this.theTok == 0x119009 && this.slen >= 2 && this.st[1].tok == 102439) break block112;
                            jmolList.addLast(this.st);
                            break block111;
                        }
                        if (!this.chk) break block113;
                        if (this.isCmdLine_c_or_C_Option) {
                            Logger.info(this.thisCommand);
                        }
                        if (this.slen != 1 || this.st[0].tok == 135368713 || this.st[0].tok == 102436) break block114;
                        break block111;
                    }
                    if (this.debugScript) {
                        this.logDebugScript(0);
                    }
                    if (this.scriptLevel == 0 && this.viewer.global.logCommands) {
                        this.viewer.log(this.thisCommand);
                    }
                    if (this.logMessages && this.theToken != null) {
                        Logger.debug(this.theToken.toString());
                    }
                }
                if (this.theToken != null) {
                    if (T.tokAttr(this.theToken.tok, 135168)) {
                        this.processShapeCommand(this.theToken.tok);
                    } else {
                        switch (this.theToken.tok) {
                            case 0: {
                                String string3;
                                if (this.chk || !this.viewer.getBoolean(603979879) || (string3 = (String)this.theToken.value) == null) break;
                                if (this.outputBuffer == null) {
                                    this.viewer.showMessage(string3);
                                }
                                this.scriptStatusOrBuffer(string3);
                                break;
                            }
                            case 266280: {
                                this.pushContext((ContextToken)this.theToken);
                                break;
                            }
                            case 266278: {
                                this.popContext(true, false);
                                break;
                            }
                            case 0x10100022: {
                                break;
                            }
                            case 20500: 
                            case 528410: {
                                if (this.viewer.isHeadless()) break;
                            }
                            case 102402: 
                            case 102406: 
                            case 102407: 
                            case 102408: 
                            case 102410: 
                            case 102411: 
                            case 102412: 
                            case 102413: 
                            case 364547: 
                            case 364548: 
                            case 0x119009: 
                            case 135369224: 
                            case 135369225: {
                                bl2 = this.flowControl(this.theToken.tok, bl2, jmolList);
                                if (this.theTok != 102439) break;
                                jmolList = null;
                                break;
                            }
                            case 4097: {
                                this.animation();
                                break;
                            }
                            case 4098: {
                                this.assign();
                                break;
                            }
                            case 1610616835: {
                                this.background(1);
                                break;
                            }
                            case 4100: {
                                this.bind();
                                break;
                            }
                            case 4101: {
                                this.bondorder();
                                break;
                            }
                            case 4102: {
                                this.calculate();
                                break;
                            }
                            case 135270422: {
                                this.cache();
                                break;
                            }
                            case 1069064: {
                                this.cd();
                                break;
                            }
                            case 12289: {
                                this.center(1);
                                break;
                            }
                            case 4105: {
                                this.centerAt();
                                break;
                            }
                            case 1766856708: {
                                this.color();
                                break;
                            }
                            case 135270405: {
                                this.compare();
                                break;
                            }
                            case 1095766022: {
                                this.configuration();
                                break;
                            }
                            case 4106: {
                                this.connect(1);
                                break;
                            }
                            case 528395: {
                                this.console();
                                break;
                            }
                            case 135270407: {
                                this.data();
                                break;
                            }
                            case 1060866: {
                                this.define();
                                break;
                            }
                            case 528397: {
                                this.delay();
                                break;
                            }
                            case 12291: {
                                this.delete();
                                break;
                            }
                            case 554176526: {
                                this.slab(true);
                                break;
                            }
                            case 1610625028: {
                                this.display(true);
                                break;
                            }
                            case 266255: 
                            case 266281: {
                                if (this.chk) break;
                                if (this.pc > 0 && this.theToken.tok == 266255) {
                                    this.viewer.clearScriptQueue();
                                }
                                this.executionStopped = this.pc > 0 || !this.viewer.global.useScriptQueue;
                                break;
                            }
                            case 266256: {
                                if (this.chk) {
                                    return;
                                }
                                this.viewer.exitJmol();
                                break;
                            }
                            case 1229984263: {
                                this.file();
                                break;
                            }
                            case 1060869: {
                                this.fixed();
                                break;
                            }
                            case 4114: {
                                this.font(-1, 0.0f);
                                break;
                            }
                            case 4115: 
                            case 1095766028: {
                                this.frame(1);
                                break;
                            }
                            case 102436: 
                            case 135368713: 
                            case 0x40000000: {
                                this.function();
                                break;
                            }
                            case 135270410: {
                                this.getProperty();
                                break;
                            }
                            case 20482: {
                                this.help();
                                break;
                            }
                            case 12294: {
                                this.display(false);
                                break;
                            }
                            case 1612189718: {
                                this.hbond();
                                break;
                            }
                            case 1610616855: {
                                this.history(1);
                                break;
                            }
                            case 544771: {
                                this.hover();
                                break;
                            }
                            case 266264: {
                                if (this.chk) break;
                                this.viewer.initialize(!this.isStateScript);
                                break;
                            }
                            case 4121: {
                                this.invertSelected();
                                break;
                            }
                            case 135287308: {
                                this.script(135287308, null);
                                break;
                            }
                            case 135271426: {
                                this.load();
                                break;
                            }
                            case 36869: {
                                this.log();
                                break;
                            }
                            case 0x10101C: {
                                this.mapProperty();
                                break;
                            }
                            case 20485: {
                                this.message();
                                break;
                            }
                            case 4126: {
                                this.minimize();
                                break;
                            }
                            case 4128: {
                                this.move();
                                break;
                            }
                            case 4130: {
                                this.moveto();
                                break;
                            }
                            case 4131: {
                                this.navigate();
                                break;
                            }
                            case 20487: {
                                this.pause();
                                break;
                            }
                            case 4133: 
                            case 1052714: 
                            case 0x8101011: {
                                this.plot(this.st);
                                break;
                            }
                            case 36865: {
                                this.print();
                                break;
                            }
                            case 102439: {
                                this.pushContext((ContextToken)this.theToken);
                                if (this.parallelProcessor == null) break;
                                jmolList = new JmolList<T[]>();
                                break;
                            }
                            case 135304707: {
                                this.prompt();
                                break;
                            }
                            case 4139: 
                            case 4165: {
                                this.undoRedoMove();
                                break;
                            }
                            case 266284: {
                                this.refresh();
                                break;
                            }
                            case 4141: {
                                this.reset();
                                break;
                            }
                            case 4142: {
                                this.restore();
                                break;
                            }
                            case 12295: {
                                this.restrict();
                                break;
                            }
                            case 266287: {
                                if (this.chk) break;
                                this.resumePausedExecution();
                                break;
                            }
                            case 36866: {
                                this.returnCmd(null);
                                break;
                            }
                            case 528432: {
                                this.rotate(false, false);
                                break;
                            }
                            case 4145: {
                                this.rotate(false, true);
                                break;
                            }
                            case 4146: {
                                this.save();
                                break;
                            }
                            case 1085443: {
                                this.set();
                                break;
                            }
                            case 135271429: {
                                this.script(135271429, null);
                                break;
                            }
                            case 135280132: {
                                this.select(1);
                                break;
                            }
                            case 1611141171: {
                                this.selectionHalo(1);
                                break;
                            }
                            case 4148: {
                                this.show();
                                break;
                            }
                            case 554176565: {
                                this.slab(false);
                                break;
                            }
                            case 1611141175: {
                                this.rotate(true, false);
                                break;
                            }
                            case 1611141176: {
                                this.ssbond();
                                break;
                            }
                            case 266298: {
                                if (!this.pause()) break;
                                this.stepPausedExecution();
                                break;
                            }
                            case 528443: {
                                this.stereo();
                                break;
                            }
                            case 1641025539: {
                                this.structure();
                                break;
                            }
                            case 0x303008: {
                                this.subset();
                                break;
                            }
                            case 4156: {
                                this.sync();
                                break;
                            }
                            case 536875070: {
                                this.timeout(1);
                                break;
                            }
                            case 4160: {
                                this.translate(false);
                                break;
                            }
                            case 4162: {
                                this.translate(true);
                                break;
                            }
                            case 4164: {
                                this.unbind();
                                break;
                            }
                            case 4166: {
                                this.vibration();
                                break;
                            }
                            case 135270421: {
                                this.write(null);
                                break;
                            }
                            case 1060873: {
                                this.zap(true);
                                break;
                            }
                            case 4168: {
                                this.zoom(false);
                                break;
                            }
                            case 4170: {
                                this.zoom(true);
                                break;
                            }
                            default: {
                                this.error(47);
                            }
                        }
                    }
                    this.setCursorWait(false);
                    if (this.executionStepping) {
                        this.executionPaused = this.isCommandDisplayable(this.pc + 1);
                    }
                }
            }
            ++this.pc;
        }
    }

    private void cache() throws ScriptException {
        this.checkLength(3);
        int n = this.tokAt(1);
        String string = this.parameterAsString(2);
        switch (n) {
            case 1073742119: 
            case 1276118017: {
                int n2;
                if (this.chk) break;
                if (n == 1073742119 && this.tokAt(2) == 0x100003) {
                    string = null;
                }
                this.showString((n2 = this.viewer.cacheFileByName(string, n == 1276118017)) < 0 ? "cache cleared" : n2 + " bytes " + (n == 1276118017 ? " cached" : " removed"));
                break;
            }
            default: {
                this.error(22);
            }
        }
    }

    private void setCursorWait(boolean bl) {
        if (!this.chk) {
            this.viewer.setCursor(bl ? 4 : 0);
        }
    }

    private void processShapeCommand(int n) throws ScriptException {
        int n2 = 0;
        switch (n) {
            case 1611272194: {
                n2 = 31;
                break;
            }
            case 1115297793: {
                n2 = 9;
                break;
            }
            case 1679429641: {
                n2 = 32;
                break;
            }
            case 1113200642: {
                n2 = 11;
                break;
            }
            case 135174: {
                n2 = 23;
                break;
            }
            case 135402505: {
                n2 = 25;
                break;
            }
            case 135175: {
                n2 = 17;
                break;
            }
            case 1113198595: {
                n2 = 16;
                break;
            }
            case 135176: {
                n2 = 22;
                break;
            }
            case 537022465: {
                n2 = 30;
                break;
            }
            case 1113198596: {
                n2 = 20;
                break;
            }
            case 1611272202: {
                n2 = 35;
                break;
            }
            case 1113198597: {
                n2 = 19;
                break;
            }
            case 1113200646: {
                n2 = 8;
                break;
            }
            case 135180: {
                n2 = 24;
                break;
            }
            case 1826248715: {
                n2 = 5;
                break;
            }
            case 135182: {
                n2 = 26;
                break;
            }
            case 0x20021010: 
            case 1746538509: {
                n2 = 6;
                break;
            }
            case 1113200647: {
                n2 = 13;
                break;
            }
            case 0x121012: {
                n2 = 27;
                break;
            }
            case 135190: {
                n2 = 29;
                break;
            }
            case 135188: {
                n2 = 28;
                break;
            }
            case 135192: {
                n2 = 21;
                break;
            }
            case 1113200649: {
                n2 = 14;
                break;
            }
            case 1113200650: {
                n2 = 15;
                break;
            }
            case 1113200651: {
                n2 = 0;
                break;
            }
            case 1113200652: {
                n2 = 7;
                break;
            }
            case 1650071565: {
                n2 = 12;
                break;
            }
            case 0x1A101A: {
                n2 = 4;
                break;
            }
            case 1113200654: {
                n2 = 10;
                break;
            }
            case 1614417948: {
                n2 = 33;
                break;
            }
            case 135198: {
                n2 = 18;
                break;
            }
            case 659488: {
                n2 = 1;
                break;
            }
            default: {
                this.error(47);
            }
        }
        if (this.sm.getShape(n2) == null && this.slen == 2) {
            switch (this.st[1].tok) {
                case 12291: 
                case 0x10000B: 
                case 0x10000C: {
                    return;
                }
            }
        }
        switch (n) {
            case 1113200642: 
            case 1113200647: 
            case 1113200649: 
            case 1113200650: 
            case 1113200654: 
            case 1115297793: 
            case 1650071565: {
                this.proteinShape(n2);
                return;
            }
            case 1113198595: 
            case 1113198597: {
                this.dots(n2);
                return;
            }
            case 1113198596: {
                this.ellipsoid();
                return;
            }
            case 1113200646: 
            case 1113200651: 
            case 1113200652: {
                this.setAtomShapeSize(n2, n == 1113200646 ? -1.0f : 1.0f);
                return;
            }
            case 1826248715: {
                this.label(1);
                return;
            }
            case 135182: {
                this.lcaoCartoon();
                return;
            }
            case 135192: {
                this.polyhedra();
                return;
            }
            case 0x1A101A: {
                this.struts();
                return;
            }
            case 135198: {
                this.vector();
                return;
            }
            case 659488: {
                this.wireframe();
                return;
            }
        }
        switch (n) {
            case 1611272194: {
                this.axes(1);
                return;
            }
            case 1679429641: {
                this.boundbox(1);
                return;
            }
            case 135174: {
                this.cgo();
                return;
            }
            case 135402505: {
                this.contact();
                return;
            }
            case 135175: {
                this.dipole();
                return;
            }
            case 135176: {
                this.draw();
                return;
            }
            case 537022465: {
                this.echo(1, null, false);
                return;
            }
            case 1611272202: {
                this.frank(1);
                return;
            }
            case 135180: 
            case 135188: 
            case 135190: {
                this.isosurface(n2);
                return;
            }
            case 0x20021010: 
            case 1746538509: {
                this.measure();
                return;
            }
            case 0x121012: {
                this.mo(false);
                return;
            }
            case 1614417948: {
                this.unitcell(1);
                return;
            }
        }
    }

    private boolean flowControl(int n, boolean bl, JmolList<T[]> jmolList) throws ScriptException {
        int n2;
        switch (n) {
            case 20500: {
                this.gotoCmd(this.parameterAsString(this.checkLast(1)));
                return bl;
            }
            case 528410: {
                if (!this.chk) {
                    this.pc = -1;
                }
                this.delay();
                return bl;
            }
        }
        boolean bl2 = n2 < 0 && !this.chk;
        boolean bl3 = true;
        int n3 = 0;
        switch (n) {
            case 102412: {
                ContextToken contextToken = (ContextToken)this.theToken;
                this.pushContext(contextToken);
                if (!bl2 && contextToken.name0 != null) {
                    this.contextVariables.put(contextToken.name0, contextToken.contextVariables.get(contextToken.name0));
                }
                bl3 = !bl2;
                break;
            }
            case 102410: 
            case 102411: 
            case 102413: {
                n3 = Math.abs(this.aatoken[Math.abs((int)n2)][0].intValue);
                switch (bl2 ? 0 : this.switchCmd((ContextToken)this.theToken, n)) {
                    case 0: {
                        n3 = -n3;
                        bl3 = false;
                        break;
                    }
                    case -1: {
                        bl3 = false;
                        break;
                    }
                }
                this.aatoken[this.pc][0].intValue = Math.abs(n2);
                this.theToken = this.aatoken[Math.abs(n2)][0];
                if (this.theToken.tok == 0x119009) break;
                this.theToken.intValue = n3;
                break;
            }
            case 102402: 
            case 135369225: {
                boolean bl4 = bl3 = !bl2 && this.ifCmd();
                if (this.chk) break;
                n3 = Math.abs(this.aatoken[Math.abs((int)n2)][0].intValue);
                this.aatoken[Math.abs((int)n2)][0].intValue = n3 = bl2 || bl3 ? -n3 : n3;
                if (n != 102412) break;
                this.aatoken[this.pc][0].intValue = -n2;
                break;
            }
            case 364547: {
                this.checkLength(1);
                if (n2 >= 0 || this.chk) break;
                this.pc = -n2 - 1;
                break;
            }
            case 364548: {
                this.checkLength(1);
                break;
            }
            case 102406: {
                if (!bl) {
                    this.pushContext((ContextToken)this.theToken);
                }
                bl = false;
                if (this.ifCmd() || this.chk) break;
                this.pc = n2;
                this.popContext(true, false);
                break;
            }
            case 102407: {
                if (!this.chk) {
                    this.breakCmd(n2);
                    break;
                }
                if (this.slen == 1) break;
                int n4 = this.intParameter(this.checkLast(1));
                if (this.chk) break;
                for (int i = 0; i < n4; ++i) {
                    this.popContext(true, false);
                }
                break;
            }
            case 102408: {
                bl = true;
                if (!this.chk) {
                    this.pc = n2 - 1;
                }
                if (this.slen <= 1) break;
                this.intParameter(this.checkLast(1));
                break;
            }
            case 135369224: {
                String string;
                Object object;
                JmolList<SV> jmolList2;
                T t = this.theToken;
                int[] nArray = new int[2];
                int n5 = 0;
                Cloneable cloneable = null;
                int n6 = 0;
                block37: for (int i = 1; i < this.slen && n5 < 2; ++i) {
                    switch (this.tokAt(i)) {
                        case 0x10000F: {
                            if (n6 > 0) {
                                --n6;
                                continue block37;
                            }
                            nArray[n5++] = i;
                            continue block37;
                        }
                        case 1073741980: {
                            n6 -= 2;
                            if (this.tokAt(++i) == 0x100001 || this.tokAt(i) == 10) {
                                cloneable = this.atomExpressionAt(i);
                                if (this.isBondSet) {
                                    cloneable = new Bond.BondSet((BS)cloneable);
                                }
                            } else {
                                jmolList2 = this.parameterExpressionList(-i, 1, false);
                                if (jmolList2 == null || jmolList2.size() < 1) {
                                    this.error(22);
                                }
                                object = (SV)jmolList2.get(0);
                                switch (((SV)object).tok) {
                                    case 10: {
                                        cloneable = SV.getBitSet((SV)object, false);
                                        break;
                                    }
                                    case 7: {
                                        cloneable = ((SV)object).getList();
                                        break;
                                    }
                                    default: {
                                        this.error(22);
                                    }
                                }
                            }
                            i = this.iToken;
                            continue block37;
                        }
                        case 135280132: {
                            n6 += 2;
                        }
                    }
                }
                if (bl) {
                    n5 = cloneable == null ? nArray[1] + 1 : 2;
                } else {
                    this.pushContext((ContextToken)t);
                    n5 = 2;
                }
                if (this.tokAt(n5) == 36868) {
                    ++n5;
                }
                int n7 = n6 = (string = this.parameterAsString(n5)).equals("--") || string.equals("++") ? 1 : 0;
                if (n6 != 0) {
                    string = this.parameterAsString(++n5);
                }
                jmolList2 = null;
                if (T.tokAttr(this.tokAt(n5), 0x40000000) || (jmolList2 = this.getContextVariableAsVariable(string)) != null) {
                    if (cloneable == null && n6 == 0 && this.getToken((int)(++n5)).tok != 269484436) {
                        this.error(22);
                    }
                    if (cloneable == null) {
                        if (n6 != 0) {
                            n5 -= 2;
                        }
                        this.setVariable(++n5, this.slen - 1, string, 0);
                    } else {
                        bl3 = true;
                        object = string + "_incr";
                        if (jmolList2 == null) {
                            jmolList2 = this.getContextVariableAsVariable((String)object);
                        }
                        if (jmolList2 == null) {
                            if (string.startsWith("_")) {
                                this.error(22);
                            }
                            jmolList2 = this.viewer.getOrSetNewVariable((String)object, true);
                        }
                        if (!bl || ((SV)((Object)jmolList2)).tok != 10 && ((SV)((Object)jmolList2)).tok != 7 || ((SV)((Object)jmolList2)).intValue == Integer.MAX_VALUE) {
                            if (bl) {
                                bl3 = false;
                            } else {
                                ((SV)((Object)jmolList2)).setv(SV.getVariable(cloneable), false);
                                ((SV)((Object)jmolList2)).intValue = 1;
                            }
                        } else {
                            ++((SV)((Object)jmolList2)).intValue;
                        }
                        boolean bl5 = bl3 && (cloneable instanceof BS ? SV.bsSelectVar((SV)((Object)jmolList2)).cardinality() == 1 : ((SV)((Object)jmolList2)).intValue <= ((SV)((Object)jmolList2)).getList().size()) ? true : (bl3 = false);
                        if (bl3) {
                            jmolList2 = SV.selectItemVar((SV)((Object)jmolList2));
                            SV sV = this.getContextVariableAsVariable(string);
                            if (sV == null) {
                                sV = this.viewer.getOrSetNewVariable(string, true);
                            }
                            sV.setv((SV)((Object)jmolList2), false);
                        }
                    }
                }
                if (cloneable == null) {
                    bl3 = this.parameterExpressionBoolean(nArray[0] + 1, nArray[1]);
                }
                ++n2;
                if (!bl3) {
                    this.popContext(true, false);
                }
                bl = false;
                break;
            }
            case 0x119009: {
                switch (this.getToken((int)this.checkLast((int)1)).tok) {
                    case 364558: {
                        ScriptFunction scriptFunction = (ScriptFunction)this.getToken((int)1).value;
                        if (this.chk) {
                            return false;
                        }
                        this.runFunctionRet(scriptFunction, "try", null, null, true, true, true);
                        return false;
                    }
                    case 102412: {
                        this.popContext(true, false);
                        break;
                    }
                    case 102436: 
                    case 135368713: {
                        this.viewer.addFunction((ScriptFunction)this.theToken.value);
                        return bl;
                    }
                    case 102439: {
                        this.addProcess(jmolList, n2, this.pc);
                        this.popContext(true, false);
                        break;
                    }
                    case 102410: {
                        if (n2 <= 0 || this.switchCmd((ContextToken)this.aatoken[n2][0], 0) != -1) break;
                        for (n2 = this.st[0].intValue; n2 < this.pc && ((n = this.aatoken[n2][0].tok) == 102413 || n == 102411); ++n2) {
                        }
                        boolean bl6 = bl3 = this.pc == n2;
                    }
                }
                if (bl3) {
                    bl3 = this.theTok == 102412 || this.theTok == 102439 || this.theTok == 135369225 || this.theTok == 102410;
                }
                boolean bl7 = bl = this.theTok == 135369224 || this.theTok == 102406;
            }
        }
        if (!bl3 && !this.chk) {
            this.pc = Math.abs(n2) - 1;
        }
        return bl;
    }

    private void gotoCmd(String string) throws ScriptException {
        int n;
        int n2;
        int n3 = string == null ? this.aatoken.length - 1 : -1;
        String string2 = null;
        block11: for (n2 = n3 + 1; n2 < this.aatoken.length; ++n2) {
            T[] tArray = this.aatoken[n2];
            n = tArray[0].tok;
            switch (n) {
                case 0: 
                case 20485: {
                    string2 = (String)tArray[tArray.length - 1].value;
                    if (n != 0) break;
                    string2 = string2.substring(string2.startsWith("#") ? 1 : 2);
                    break;
                }
                default: {
                    continue block11;
                }
            }
            if (!string2.equalsIgnoreCase(string)) continue;
            n3 = n2;
            break;
        }
        if (n3 < 0) {
            this.error(22);
        }
        if (string == null) {
            n3 = 0;
        }
        n2 = n3 < this.pc ? 1 : -1;
        int n4 = 0;
        block12: for (n = n3; n != this.pc; n += n2) {
            switch (this.aatoken[n][0].tok) {
                case 102406: 
                case 102412: 
                case 102439: 
                case 266280: 
                case 135369224: {
                    ++n4;
                    continue block12;
                }
                case 266278: {
                    --n4;
                    continue block12;
                }
                case 0x119009: {
                    switch (this.aatoken[n][1].tok) {
                        case 102406: 
                        case 102412: 
                        case 102439: 
                        case 135369224: {
                            --n4;
                        }
                    }
                }
            }
        }
        if (string == null) {
            n3 = Integer.MAX_VALUE;
            while (n4 > 0) {
                this.popContext(false, false);
                --n4;
            }
        }
        if (n4 != 0) {
            this.error(22);
        }
        if (!this.chk) {
            this.pc = n3 - 1;
        }
    }

    private void breakCmd(int n) {
        if (n < 0) {
            this.getContextVariableAsVariable((String)"_breakval").intValue = -n;
            this.pcEnd = this.pc;
            return;
        }
        this.pc = Math.abs(this.aatoken[n][0].intValue);
        int n2 = this.aatoken[n][0].tok;
        if (n2 == 102411 || n2 == 102413) {
            this.theToken = this.aatoken[this.pc--][0];
            int n3 = Math.abs(this.theToken.intValue);
            if (this.theToken.tok != 0x119009) {
                this.theToken.intValue = -n3;
            }
        } else {
            while (this.thisContext != null && !ScriptCompiler.isBreakableContext(this.thisContext.token.tok)) {
                this.popContext(true, false);
            }
            this.popContext(true, false);
        }
    }

    private void addProcess(JmolList<T[]> jmolList, int n, int n2) {
        if (this.parallelProcessor == null) {
            return;
        }
        T[][] tArrayArray = new T[n2][];
        for (int i = 0; i < jmolList.size(); ++i) {
            tArrayArray[i + 1 - n] = (T[])jmolList.get(i);
        }
        ScriptContext scriptContext = this.getScriptContext();
        scriptContext.aatoken = tArrayArray;
        scriptContext.pc = 1 - n;
        scriptContext.pcEnd = n2;
        this.parallelProcessor.addProcess("p" + ++iProcess, scriptContext);
    }

    private int switchCmd(ContextToken contextToken, int n) throws ScriptException {
        SV sV;
        if (n == 102410) {
            contextToken.addName("_var");
        }
        if ((sV = contextToken.contextVariables.get("_var")) == null) {
            return 1;
        }
        if (n == 0) {
            contextToken.contextVariables.remove("_var");
            return -1;
        }
        if (n == 102413) {
            return -1;
        }
        SV sV2 = this.parameterExpressionToken(1);
        if (n == 102411) {
            boolean bl = SV.areEqual(sV, sV2);
            if (bl) {
                contextToken.contextVariables.remove("_var");
            }
            return bl ? 1 : -1;
        }
        contextToken.contextVariables.put("_var", sV2);
        return 1;
    }

    private boolean ifCmd() throws ScriptException {
        return this.parameterExpressionBoolean(1, 0);
    }

    private void returnCmd(SV sV) throws ScriptException {
        SV sV2;
        SV sV3 = this.getContextVariableAsVariable("_retval");
        if (sV3 == null) {
            if (!this.chk) {
                this.gotoCmd(null);
            }
            return;
        }
        SV sV4 = sV2 = sV != null || this.slen == 1 ? null : this.parameterExpressionToken(1);
        if (this.chk) {
            return;
        }
        if (sV == null) {
            sV = sV2 == null ? SV.newScriptVariableInt(0) : sV2;
        }
        sV3.value = sV.value;
        sV3.intValue = sV.intValue;
        sV3.tok = sV.tok;
        this.gotoCmd(null);
    }

    private void help() throws ScriptException {
        if (this.chk) {
            return;
        }
        String string = this.optParameterAsString(1).toLowerCase();
        int n = 0;
        if (string.startsWith("mouse") && (n = string.indexOf(" ")) >= 0 && n == string.lastIndexOf(" ")) {
            this.showString(this.viewer.getBindingInfo(string.substring(n + 1)));
            return;
        }
        if (T.tokAttr(T.getTokFromName(string), 4096)) {
            string = "?command=" + string;
        }
        this.viewer.getHelp(string);
    }

    private void move() throws ScriptException {
        int n;
        if (this.slen > 11) {
            this.error(2);
        }
        V3 v3 = V3.new3(this.floatParameter(1), this.floatParameter(2), this.floatParameter(3));
        float f = this.floatParameter(4);
        V3 v32 = V3.new3(this.intParameter(5), this.intParameter(6), this.intParameter(7));
        float f2 = this.floatParameter(8);
        float f3 = this.floatParameter(9);
        int n2 = n = this.slen == 11 ? this.intParameter(10) : 30;
        if (this.chk) {
            return;
        }
        this.refresh();
        if (!this.useThreads()) {
            f3 = 0.0f;
        }
        this.viewer.move(this, v3, f, v32, f2, f3, n);
        if (f3 > 0.0f && this.isJS) {
            throw new ScriptInterruption(this, "move", 1);
        }
    }

    private void moveto() throws ScriptException {
        if (this.slen == 2 && this.tokAt(1) == 1073742162) {
            if (!this.chk) {
                this.viewer.stopMotion();
            }
            return;
        }
        if (this.slen == 2 && this.isFloatParameter(1)) {
            float f = this.floatParameter(1);
            if (this.chk) {
                return;
            }
            if (!this.useThreads()) {
                f = 0.0f;
            }
            if (f > 0.0f) {
                this.refresh();
            }
            this.viewer.moveTo(this, f, null, JC.axisZ, 0.0f, null, 100.0f, 0.0f, 0.0f, 0.0f, null, Float.NaN, Float.NaN, Float.NaN);
            if (this.isJS && f > 0.0f && this.viewer.global.waitForMoveTo) {
                throw new ScriptInterruption(this, "moveTo", 1);
            }
            return;
        }
        V3 v3 = V3.new3(Float.NaN, 0.0f, 0.0f);
        P3 p3 = null;
        int n = 1;
        float f = this.isFloatParameter(n) ? this.floatParameter(n++) : 2.0f;
        float f2 = 90.0f;
        BS bS = null;
        switch (this.getToken((int)n).tok) {
            case 0x8101011: {
                Quaternion quaternion;
                boolean bl = false;
                if (this.tokAt(++n) == 1073742029) {
                    bl = true;
                    ++n;
                }
                if (this.tokAt(n) == 10 || this.tokAt(n) == 0x100001) {
                    bl = true;
                    p3 = this.centerParameter(n);
                    if (!(this.expressionResult instanceof BS)) {
                        this.error(22);
                    }
                    bS = (BS)this.expressionResult;
                    quaternion = this.chk ? new Quaternion() : this.viewer.getAtomQuaternion(bS.nextSetBit(0));
                } else {
                    quaternion = this.getQuaternionParameter(n);
                }
                n = this.iToken + 1;
                if (quaternion == null) {
                    this.error(22);
                }
                AxisAngle4f axisAngle4f = quaternion.toAxisAngle4f();
                v3.set(axisAngle4f.x, axisAngle4f.y, axisAngle4f.z);
                f2 = (float)(bl ? -1 : 1) * (float)((double)axisAngle4f.angle * 180.0 / Math.PI);
                break;
            }
            case 8: 
            case 9: 
            case 0x10000A: {
                if (this.isPoint3f(n)) {
                    v3.setT(this.getPoint3f(n, true));
                    n = this.iToken + 1;
                    f2 = this.floatParameter(n++);
                    break;
                }
                P4 p4 = this.getPoint4f(n);
                n = this.iToken + 1;
                v3.set(p4.x, p4.y, p4.z);
                f2 = p4.x == 0.0f && p4.y == 0.0f && p4.z == 0.0f ? Float.NaN : p4.w;
                break;
            }
            case 1073741954: {
                v3.set(1.0f, 0.0f, 0.0f);
                f2 = 0.0f;
                this.checkLength(++n);
                break;
            }
            case 0x40000024: {
                v3.set(0.0f, 1.0f, 0.0f);
                f2 = 180.0f;
                this.checkLength(++n);
                break;
            }
            case 1073741996: {
                v3.set(0.0f, 1.0f, 0.0f);
                this.checkLength(++n);
                break;
            }
            case 1073742128: {
                v3.set(0.0f, -1.0f, 0.0f);
                this.checkLength(++n);
                break;
            }
            case 1074790748: {
                v3.set(1.0f, 0.0f, 0.0f);
                this.checkLength(++n);
                break;
            }
            case 1073741871: {
                v3.set(-1.0f, 0.0f, 0.0f);
                this.checkLength(++n);
                break;
            }
            default: {
                v3 = V3.new3(this.floatParameter(n++), this.floatParameter(n++), this.floatParameter(n++));
                f2 = this.floatParameter(n++);
            }
        }
        if (Float.isNaN(v3.x) || Float.isNaN(v3.y) || Float.isNaN(v3.z)) {
            v3.set(0.0f, 0.0f, 0.0f);
        } else if (v3.length() == 0.0f && f2 == 0.0f) {
            f2 = Float.NaN;
        }
        boolean bl = !this.viewer.isInPosition(v3, f2);
        float f3 = this.isFloatParameter(n) ? this.floatParameter(n++) : Float.NaN;
        float f4 = 0.0f;
        float f5 = 0.0f;
        if (this.isFloatParameter(n) && !this.isCenterParameter(n)) {
            f4 = this.floatParameter(n++);
            f5 = this.floatParameter(n++);
            if (!bl && Math.abs(f4 - this.viewer.getTranslationXPercent()) >= 1.0f) {
                bl = true;
            }
            if (!bl && Math.abs(f5 - this.viewer.getTranslationYPercent()) >= 1.0f) {
                bl = true;
            }
        }
        if (bS == null && n != this.slen) {
            p3 = this.centerParameter(n);
            if (this.expressionResult instanceof BS) {
                bS = (BS)this.expressionResult;
            }
            n = this.iToken + 1;
        }
        float f6 = Float.NaN;
        float f7 = this.viewer.getZoomSetting();
        if (p3 != null) {
            if (!bl && (double)p3.distance(this.viewer.getRotationCenter()) >= 0.1) {
                bl = true;
            }
            if (this.isFloatParameter(n)) {
                f6 = this.floatParameter(n++);
            }
            if (!this.isCenterParameter(n)) {
                if ((f6 == 0.0f || Float.isNaN(f6)) && (f3 == 0.0f || Float.isNaN(f3))) {
                    float f8 = Math.abs(this.getZoom(0, n, bS, f3 == 0.0f ? 0.0f : f7));
                    n = this.iToken + 1;
                    f3 = f8;
                } else if (!bl && (double)Math.abs(f6 - this.viewer.getFloat(0x2200002C)) >= 0.1) {
                    bl = true;
                }
            }
        }
        if (f3 == 0.0f || Float.isNaN(f3)) {
            f3 = 100.0f;
        }
        if (Float.isNaN(f6)) {
            f6 = 0.0f;
        }
        if (!bl && Math.abs(f3 - f7) >= 1.0f) {
            bl = true;
        }
        P3 p32 = null;
        float f9 = Float.NaN;
        float f10 = Float.NaN;
        float f11 = Float.NaN;
        if (n != this.slen) {
            p32 = this.centerParameter(n);
            n = this.iToken + 1;
            if (n != this.slen) {
                f9 = this.floatParameter(n++);
                f10 = this.floatParameter(n++);
            }
            if (n != this.slen) {
                f11 = this.floatParameter(n++);
            }
        }
        if (n != this.slen) {
            this.error(2);
        }
        if (this.chk) {
            return;
        }
        if (!bl) {
            f = 0.0f;
        }
        if (f > 0.0f) {
            this.refresh();
        }
        if (!this.useThreads()) {
            f = 0.0f;
        }
        this.viewer.moveTo(this, f, p3, v3, f2, null, f3, f4, f5, f6, p32, f9, f10, f11);
        if (this.isJS && f > 0.0f && this.viewer.global.waitForMoveTo) {
            throw new ScriptInterruption(this, "moveTo", 1);
        }
    }

    private void navigate() throws ScriptException {
        if (this.slen == 1) {
            this.setBooleanProperty("navigationMode", true);
            return;
        }
        V3 v3 = V3.new3(0.0f, 1.0f, 0.0f);
        JmolList<Object[]> jmolList = new JmolList<Object[]>();
        if (this.slen == 2) {
            switch (this.getToken((int)1).tok) {
                case 0x10000C: 
                case 0x10000D: {
                    if (this.chk) {
                        return;
                    }
                    this.setObjectMad(31, "axes", 1);
                    this.setShapeProperty(31, "position", P3.new3(50.0f, 50.0f, Float.MAX_VALUE));
                    this.setBooleanProperty("navigationMode", true);
                    this.viewer.setNavOn(this.theTok == 0x10000D);
                    return;
                }
                case 1073742162: {
                    if (!this.chk) {
                        this.viewer.setNavXYZ(0.0f, 0.0f, 0.0f);
                    }
                    return;
                }
                case 8: {
                    break;
                }
                default: {
                    this.error(22);
                }
            }
        }
        if (!this.chk && !this.viewer.getBoolean(603979886)) {
            this.setBooleanProperty("navigationMode", true);
        }
        block26: for (int i = 1; i < this.slen; ++i) {
            float f;
            float f2 = f = this.isFloatParameter(i) ? this.floatParameter(i++) : 2.0f;
            if (f < 0.0f) {
                this.error(22);
            }
            if (!this.chk && f > 0.0f) {
                this.refresh();
            }
            switch (this.getToken((int)i).tok) {
                case 8: 
                case 0x10000A: {
                    P3 p3 = this.getPoint3f(i, true);
                    ++this.iToken;
                    if (this.iToken != this.slen) {
                        this.error(22);
                    }
                    if (!this.chk) {
                        this.viewer.setNavXYZ(p3.x, p3.y, p3.z);
                    }
                    return;
                }
                case 554176526: {
                    float f3 = this.floatParameter(++i);
                    if (this.chk) continue block26;
                    jmolList.addLast(new Object[]{554176526, Float.valueOf(f), Float.valueOf(f3)});
                    continue block26;
                }
                case 12289: {
                    P3 p3 = this.centerParameter(++i);
                    i = this.iToken;
                    if (this.chk) continue block26;
                    jmolList.addLast(new Object[]{0x8100010, Float.valueOf(f), p3});
                    continue block26;
                }
                case 528432: {
                    switch (this.getToken((int)(++i)).tok) {
                        case 1112541205: {
                            v3.set(1.0f, 0.0f, 0.0f);
                            ++i;
                            break;
                        }
                        case 1112541206: {
                            v3.set(0.0f, 1.0f, 0.0f);
                            ++i;
                            break;
                        }
                        case 1112541207: {
                            v3.set(0.0f, 0.0f, 1.0f);
                            ++i;
                            break;
                        }
                        case 8: 
                        case 0x10000A: {
                            v3.setT(this.getPoint3f(i, true));
                            i = this.iToken + 1;
                            break;
                        }
                        case 0x40000000: {
                            this.error(22);
                        }
                    }
                    float f4 = this.floatParameter(i);
                    if (this.chk) continue block26;
                    jmolList.addLast(new Object[]{528432, Float.valueOf(f), v3, Float.valueOf(f4)});
                    continue block26;
                }
                case 4160: {
                    P3 p3;
                    float f5 = Float.NaN;
                    float f6 = Float.NaN;
                    if (this.isFloatParameter(++i)) {
                        f5 = this.floatParameter(i);
                        f6 = this.floatParameter(++i);
                    } else {
                        switch (this.tokAt(i)) {
                            case 1112541205: {
                                f5 = this.floatParameter(++i);
                                break;
                            }
                            case 1112541206: {
                                f6 = this.floatParameter(++i);
                                break;
                            }
                            default: {
                                p3 = this.centerParameter(i);
                                i = this.iToken;
                                if (this.chk) continue block26;
                                jmolList.addLast(new Object[]{4160, Float.valueOf(f), p3});
                                continue block26;
                            }
                        }
                    }
                    if (this.chk) continue block26;
                    jmolList.addLast(new Object[]{269484210, Float.valueOf(f), Float.valueOf(f5), Float.valueOf(f6)});
                    continue block26;
                }
                case 0x101000B0: {
                    continue block26;
                }
                case 1113200654: {
                    JmolList<P3[]> jmolList2 = new JmolList<P3[]>();
                    BS bS = this.atomExpressionAt(++i);
                    i = this.iToken;
                    if (this.chk) {
                        return;
                    }
                    this.viewer.getPolymerPointsAndVectors(bS, jmolList2);
                    int n = jmolList2.size();
                    if (n <= 0) continue block26;
                    P3[][] p3ArrayArray = new P3[n][];
                    for (int j = 0; j < n; ++j) {
                        p3ArrayArray[j] = (P3[])jmolList2.get(j);
                    }
                    jmolList.addLast(new Object[]{1113200654, Float.valueOf(f), p3ArrayArray});
                    continue block26;
                }
                case 0x40000104: {
                    Object object;
                    Object var15_17 = null;
                    if (this.getToken((int)(i + 1)).tok == 0x100007) {
                        ++i;
                        object = this.objectNameParameter(++i);
                        if (this.chk) {
                            return;
                        }
                        this.setShapeProperty(22, "thisID", object);
                        P3[] p3Array = (P3[])this.getShapeProperty(22, "vertices");
                        this.refresh();
                        if (p3Array == null) {
                            this.error(22);
                        }
                        int n = (int)(this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 0.0f);
                        int n2 = (int)(this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 2.1474836E9f);
                        jmolList.addLast(new Object[]{0x40000104, Float.valueOf(f), p3Array, var15_17, new int[]{n, n2}});
                        continue block26;
                    }
                    object = new JmolList();
                    while (this.isCenterParameter(i + 1)) {
                        ((JmolList)object).addLast(this.centerParameter(++i));
                        i = this.iToken;
                    }
                    if (((ArrayList)object).size() > 0) {
                        P3[] p3Array = ((ArrayList)object).toArray(new P3[((ArrayList)object).size()]);
                        if (this.chk) continue block26;
                        jmolList.addLast(new Object[]{0x40000104, Float.valueOf(f), p3Array, var15_17, new int[]{0, Integer.MAX_VALUE}});
                        continue block26;
                    }
                }
                default: {
                    this.error(22);
                }
            }
        }
        if (!this.chk) {
            this.viewer.navigateList(this, jmolList);
        }
    }

    private void bondorder() throws ScriptException {
        this.checkLength(-3);
        int n = 0;
        switch (this.getToken((int)1).tok) {
            case 2: 
            case 3: {
                n = JmolEdge.getBondOrderFromFloat(this.floatParameter(1));
                if (n != 131071) break;
                this.error(22);
                break;
            }
            default: {
                n = ScriptEvaluator.getBondOrderFromString(this.parameterAsString(1));
                if (n == 131071) {
                    this.error(22);
                }
                if (n != 33 || this.tokAt(2) != 3) break;
                n = ScriptEvaluator.getPartialBondOrderFromFloatEncodedInt(this.st[2].intValue);
            }
        }
        this.setShapeProperty(1, "bondOrder", n);
    }

    private void console() throws ScriptException {
        switch (this.getToken((int)1).tok) {
            case 0x10000C: {
                if (this.chk) break;
                this.viewer.showConsole(false);
                break;
            }
            case 0x10000D: {
                if (this.chk) break;
                this.viewer.showConsole(true);
                break;
            }
            case 1073741882: {
                if (this.chk) break;
                this.viewer.clearConsole();
                break;
            }
            case 135270421: {
                this.showString(this.stringParameter(2));
                break;
            }
            default: {
                this.error(22);
            }
        }
    }

    private void centerAt() throws ScriptException {
        String string = null;
        switch (this.getToken((int)1).tok) {
            case 0x40000002: {
                string = "absolute";
                break;
            }
            case 96: {
                string = "average";
                break;
            }
            case 1679429641: {
                string = "boundbox";
                break;
            }
            default: {
                this.error(22);
            }
        }
        P3 p3 = P3.new3(0.0f, 0.0f, 0.0f);
        if (this.slen == 5) {
            p3.x = this.floatParameter(2);
            p3.y = this.floatParameter(3);
            p3.z = this.floatParameter(4);
        } else if (this.isCenterParameter(2)) {
            p3 = this.centerParameter(2);
            this.checkLast(this.iToken);
        } else {
            this.checkLength(2);
        }
        if (!this.chk) {
            this.viewer.setCenterAt(string, p3);
        }
    }

    private void stereo() throws ScriptException {
        EnumStereoMode enumStereoMode = EnumStereoMode.DOUBLE;
        float f = -5.0f;
        boolean bl = false;
        int[] nArray = null;
        int n = 0;
        block6: for (int i = 1; i < this.slen; ++i) {
            if (this.isColorParam(i)) {
                if (n > 1) {
                    this.error(2);
                }
                if (n == 0) {
                    nArray = new int[2];
                }
                if (!bl) {
                    f = 3.0f;
                }
                nArray[n] = this.getArgbParam(i);
                if (n++ == 0) {
                    nArray[1] = ~nArray[0];
                }
                i = this.iToken;
                continue;
            }
            switch (this.getToken((int)i).tok) {
                case 0x10000D: {
                    this.iToken = 1;
                    this.checkLast(1);
                    this.iToken = 1;
                    continue block6;
                }
                case 0x10000C: {
                    this.iToken = 1;
                    this.checkLast(1);
                    enumStereoMode = EnumStereoMode.NONE;
                    continue block6;
                }
                case 2: 
                case 3: {
                    f = this.floatParameter(i);
                    bl = true;
                    continue block6;
                }
                case 0x40000000: {
                    if (!bl) {
                        f = 3.0f;
                    }
                    if ((enumStereoMode = EnumStereoMode.getStereoMode(this.parameterAsString(i))) != null) continue block6;
                }
                default: {
                    this.error(22);
                }
            }
        }
        if (this.chk) {
            return;
        }
        this.viewer.setStereoMode(nArray, enumStereoMode, f);
    }

    private void compare() throws ScriptException {
        BS[] bSArray;
        int n;
        boolean bl;
        BS bS;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        float f = Float.NaN;
        Quaternion[] quaternionArray = null;
        Quaternion[] quaternionArray2 = null;
        BS bS2 = null;
        BS bS3 = null;
        JmolList<BS[]> jmolList = null;
        JmolList<Object[]> jmolList2 = null;
        BS bS4 = this.tokAt(1) == 0x303008 ? null : this.atomExpressionAt(1);
        BS bS5 = bS = this.tokAt(++this.iToken) == 0x303008 ? null : this.atomExpressionAt(this.iToken);
        if (bS4 == null || bS == null) {
            this.error(22);
        }
        BS bS6 = null;
        boolean bl6 = false;
        String string = null;
        BS bS7 = BSUtil.copy(bS4);
        bS7.or(bS);
        boolean bl7 = bl = bS7.equals(bS4);
        block14: for (n = this.iToken + 1; n < this.slen; ++n) {
            switch (this.getToken((int)n).tok) {
                case 4115: {
                    bl7 = true;
                    continue block14;
                }
                case 135267336: {
                    bl6 = true;
                }
                case 135267335: {
                    string = this.stringParameter(++n);
                    continue block14;
                }
                case 2: 
                case 3: {
                    f = Math.abs(this.floatParameter(n));
                    if (!(f > 0.0f)) continue block14;
                    bl5 = true;
                    continue block14;
                }
                case 0x10100030: {
                    continue block14;
                }
                case 0x303008: {
                    bS6 = this.atomExpressionAt(++n);
                    n = this.iToken;
                    continue block14;
                }
                case 10: 
                case 0x100001: {
                    if (jmolList2 != null) {
                        this.error(22);
                    }
                    bS2 = this.atomExpressionAt(this.iToken);
                    int n2 = bl ? 0 : this.tokAt(this.iToken + 1);
                    BS bS8 = bS3 = n2 == 10 || n2 == 0x100001 ? this.atomExpressionAt(++this.iToken) : BSUtil.copy(bS2);
                    if (bS6 != null) {
                        bS2.and(bS6);
                        bS3.and(bS6);
                    }
                    bS3.and(bS);
                    if (jmolList == null) {
                        jmolList = new JmolList<BS[]>();
                    }
                    jmolList.addLast(new BS[]{bS2, bS3});
                    n = this.iToken;
                    continue block14;
                }
                case 7: {
                    if (jmolList != null) {
                        this.error(22);
                    }
                    bl2 = true;
                    quaternionArray = ScriptMathProcessor.getQuaternionArray(((SV)this.theToken).getList(), 1073742001);
                    this.getToken(++n);
                    quaternionArray2 = ScriptMathProcessor.getQuaternionArray(((SV)this.theToken).getList(), 1073742001);
                    if (jmolList2 == null) {
                        jmolList2 = new JmolList<Object[]>();
                    }
                    jmolList2.addLast(new Object[]{quaternionArray, quaternionArray2});
                    continue block14;
                }
                case 1073742077: {
                    bl2 = true;
                    continue block14;
                }
                case 0x8100010: 
                case 0x44100001: {
                    bl2 = false;
                    continue block14;
                }
                case 528432: {
                    bl3 = true;
                    continue block14;
                }
                case 4160: {
                    bl4 = true;
                    continue block14;
                }
                default: {
                    this.error(22);
                }
            }
        }
        if (this.chk) {
            return;
        }
        if (bl7) {
            f = 0.0f;
        }
        if (Float.isNaN(f) || f < 0.0f) {
            f = 1.0f;
        } else if (!bl3 && !bl4) {
            bl4 = true;
            bl3 = true;
        }
        bl5 = f != 0.0f;
        int n3 = n = !bl2 && string == null ? 1 : 0;
        if (jmolList == null && jmolList2 == null) {
            if (bS6 == null) {
                BS bS9 = bS2 = n != 0 ? this.viewer.getAtomBitSet("spine") : new BS();
                if (bS2.nextSetBit(0) < 0) {
                    bS2 = bS4;
                    bS3 = bS;
                } else {
                    bS3 = BSUtil.copy(bS2);
                    bS2.and(bS4);
                    bS3.and(bS);
                }
            } else {
                bS2 = BSUtil.copy(bS4);
                bS3 = BSUtil.copy(bS);
                bS2.and(bS6);
                bS3.and(bS6);
                bS2.and(bS4);
                bS3.and(bS);
            }
            jmolList = new JmolList();
            jmolList.addLast(new BS[]{bS2, bS3});
        }
        if (bl7) {
            BS bS10 = this.viewer.getModelBitSet(bS4, false);
            bSArray = new BS[bS10.cardinality()];
            int n4 = 0;
            int n5 = bS10.nextSetBit(0);
            while (n5 >= 0) {
                bSArray[n4] = this.viewer.getModelUndeletedAtomsBitSet(n5);
                n5 = bS10.nextSetBit(n5 + 1);
                ++n4;
            }
        } else {
            bSArray = new BS[]{bS4};
        }
        for (int i = 0; i < bSArray.length; ++i) {
            Serializable serializable;
            V3 v3;
            BS[] bSArray2;
            int n6;
            bS4 = bSArray[i];
            float[] fArray = new float[2];
            Quaternion quaternion = null;
            JmolList<Quaternion> jmolList3 = new JmolList<Quaternion>();
            P3[][] p3Array = null;
            JmolList<BS[]> jmolList4 = bl7 ? new JmolList<BS[]>() : jmolList;
            for (n6 = 0; n6 < jmolList.size(); ++n6) {
                bSArray2 = (BS[])jmolList.get(n6);
                if (bl7) {
                    bSArray2 = new BS[]{BSUtil.copy(bSArray2[0]), bSArray2[1]};
                    jmolList4.addLast(bSArray2);
                }
                bSArray2[0].and(bS4);
            }
            if (n != 0) {
                p3Array = this.viewer.getCenterAndPoints(jmolList4, true);
                quaternion = Measure.calculateQuaternionRotation(p3Array, fArray, true);
                float f2 = Float.isNaN(fArray[1]) ? Float.NaN : (float)Math.round(fArray[0] * 100.0f) / 100.0f;
                float f3 = Float.isNaN(fArray[1]) ? Float.NaN : (float)Math.round(fArray[1] * 100.0f) / 100.0f;
                this.showString("RMSD " + f2 + " --> " + f3 + " Angstroms");
            } else if (bl2) {
                if (jmolList2 == null) {
                    for (n6 = 0; n6 < jmolList4.size(); ++n6) {
                        bSArray2 = (BS[])jmolList4.get(n6);
                        quaternionArray = this.viewer.getAtomGroupQuaternions(bSArray2[0], Integer.MAX_VALUE);
                        quaternionArray2 = this.viewer.getAtomGroupQuaternions(bSArray2[1], Integer.MAX_VALUE);
                        for (int j = 0; j < quaternionArray.length && j < quaternionArray2.length; ++j) {
                            jmolList3.addLast(quaternionArray2[j].div(quaternionArray[j]));
                        }
                    }
                } else {
                    for (n6 = 0; n6 < quaternionArray.length && n6 < quaternionArray2.length; ++n6) {
                        jmolList3.addLast(quaternionArray2[n6].div(quaternionArray[n6]));
                    }
                }
                fArray[0] = 0.0f;
                quaternionArray = jmolList3.toArray(new Quaternion[jmolList3.size()]);
                quaternion = Quaternion.sphereMean(quaternionArray, fArray, 1.0E-4f);
                this.showString("RMSD = " + fArray[0] + " degrees");
            } else {
                Matrix4f matrix4f = new Matrix4f();
                float f4 = this.getSmilesCorrelation(bS4, bS, string, null, null, matrix4f, null, !bl6, false);
                if (Float.isNaN(f4)) {
                    this.error(22);
                }
                v3 = new V3();
                matrix4f.get(v3);
                serializable = new Matrix3f();
                matrix4f.getRotationScale((Matrix3f)serializable);
                quaternion = Quaternion.newM(serializable);
            }
            if (p3Array == null) {
                p3Array = this.viewer.getCenterAndPoints(jmolList4, true);
            }
            P3 p3 = new P3();
            float f5 = Float.NaN;
            v3 = null;
            if (bl4) {
                v3 = V3.newV(p3Array[1][0]);
                v3.sub(p3Array[0][0]);
                f5 = 0.0f;
            }
            if (bl3) {
                if (quaternion == null) {
                    this.evalError("option not implemented", null);
                }
                p3.setT(p3Array[0][0]);
                p3.add(quaternion.getNormal());
                f5 = quaternion.getTheta();
            }
            if (Float.isNaN(f5) || Float.isNaN(p3.x)) continue;
            serializable = null;
            if (bl3 && bl4 && f != 0.0f) {
                JmolList<P3> jmolList5 = this.viewer.getAtomPointVector(bS4);
                Matrix4f matrix4f = ScriptMathProcessor.getMatrix4f(quaternion.getMatrix(), v3);
                serializable = Measure.transformPoints(jmolList5, matrix4f, p3Array[0][0]);
            }
            if (!this.useThreads()) {
                bl5 = false;
            }
            this.viewer.rotateAboutPointsInternal(this, p3Array[0][0], p3, f5 / f, f5, bl5, bS4, v3, (JmolList<P3>)serializable);
            if (!bl5 || !this.isJS) continue;
            throw new ScriptInterruption(this, "compare", 1);
        }
    }

    float getSmilesCorrelation(BS bS, BS bS2, String string, JmolList<P3> jmolList, JmolList<P3> jmolList2, Matrix4f matrix4f, JmolList<BS> jmolList3, boolean bl, boolean bl2) throws ScriptException {
        float f = 0.1f;
        try {
            int n;
            int n2;
            if (jmolList == null) {
                jmolList = new JmolList();
                jmolList2 = new JmolList();
            }
            if (matrix4f == null) {
                matrix4f = new Matrix4f();
            }
            JmolNode[] jmolNodeArray = this.viewer.modelSet.atoms;
            int n3 = this.viewer.getAtomCount();
            int[][] nArray = this.viewer.getSmilesMatcher().getCorrelationMaps(string, jmolNodeArray, n3, bS, bl, true);
            if (nArray == null) {
                this.evalError(this.viewer.getSmilesMatcher().getLastException(), null);
            }
            if (nArray.length == 0) {
                return Float.NaN;
            }
            for (n2 = 0; n2 < nArray[0].length; ++n2) {
                jmolList.addLast((P3)((Object)jmolNodeArray[nArray[0][n2]]));
            }
            nArray = this.viewer.getSmilesMatcher().getCorrelationMaps(string, jmolNodeArray, n3, bS2, bl, false);
            if (nArray == null) {
                this.evalError(this.viewer.getSmilesMatcher().getLastException(), null);
            }
            if (nArray.length == 0) {
                return Float.NaN;
            }
            if (bl2) {
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    for (int i = 0; i < nArray[n2].length; ++i) {
                        jmolList2.addLast((P3)((Object)jmolNodeArray[nArray[n2][i]]));
                    }
                }
                return 0.0f;
            }
            float f2 = Float.MAX_VALUE;
            int[] nArray2 = null;
            for (n = 0; n < nArray.length; ++n) {
                jmolList2.clear();
                for (int i = 0; i < nArray[n].length; ++i) {
                    jmolList2.addLast((P3)((Object)jmolNodeArray[nArray[n][i]]));
                }
                float f3 = Measure.getTransformMatrix4(jmolList, jmolList2, matrix4f, null);
                Logger.info("getSmilesCorrelation stddev=" + f3);
                if (jmolList3 != null && f3 < f) {
                    BS bS3 = new BS();
                    for (int i = 0; i < nArray[n].length; ++i) {
                        bS3.set(nArray[n][i]);
                    }
                    jmolList3.addLast(bS3);
                }
                if (!(f3 < f2)) continue;
                nArray2 = nArray[n];
                f2 = f3;
            }
            for (n = 0; n < nArray2.length; ++n) {
                jmolList2.addLast((P3)((Object)jmolNodeArray[nArray2[n]]));
            }
            return f2;
        }
        catch (Exception exception) {
            this.evalError(exception.toString(), null);
            return 0.0f;
        }
    }

    Object getSmilesMatches(String string, String string2, BS bS, BS bS2, boolean bl, boolean bl2) throws ScriptException {
        Object object;
        BS[] bSArray;
        if (this.chk) {
            if (bl2) {
                return new BS();
            }
            return new String[]{"({})"};
        }
        if (string.length() == 0) {
            boolean bl3 = !bl2;
            String string3 = this.viewer.getSmiles(0, 0, bS, bl3, false, true, true);
            if (string3 == null) {
                this.evalError(this.viewer.getSmilesMatcher().getLastException(), null);
            }
            return string3;
        }
        boolean bl4 = true;
        if (bS2 == null) {
            bl4 = string2 == null;
            bSArray = bl4 ? this.viewer.getSmilesMatcher().getSubstructureSetArray(string, this.viewer.modelSet.atoms, this.viewer.getAtomCount(), bS, null, bl, false) : this.viewer.getSmilesMatcher().find(string, string2, bl, false);
            if (bSArray == null) {
                this.showStringPrint(this.viewer.getSmilesMatcher().getLastException(), false);
                if (!bl4 && !bl) {
                    return -1;
                }
                return "?";
            }
        } else {
            object = new JmolList<BS>();
            float f = this.getSmilesCorrelation(bS2, bS, string, null, null, null, (JmolList<BS>)object, bl, false);
            if (Float.isNaN(f)) {
                if (bl2) {
                    return new BS();
                }
                return new String[0];
            }
            this.showString("RMSD " + f + " Angstroms");
            bSArray = object.toArray(new BS[object.size()]);
        }
        if (bl2) {
            object = new BS();
            for (int i = 0; i < bSArray.length; ++i) {
                object.or(bSArray[i]);
            }
            if (bl4) {
                return object;
            }
            if (!bl) {
                return object.cardinality();
            }
            int[] nArray = new int[object.cardinality()];
            int n = 0;
            int n2 = object.nextSetBit(0);
            while (n2 >= 0) {
                nArray[n++] = n2 + 1;
                n2 = object.nextSetBit(n2 + 1);
            }
            return nArray;
        }
        object = new String[bSArray.length];
        for (int i = 0; i < bSArray.length; ++i) {
            object[i] = bl4 ? Escape.eBS(bSArray[i]) : Escape.eBond(bSArray[i]);
        }
        return object;
    }

    private void connect(int n) throws ScriptException {
        Object object;
        int n2;
        float[] fArray = new float[2];
        BS[] bSArray = new BS[2];
        bSArray[0] = bSArray[1] = this.viewer.getSelectionSet(false);
        float f = Float.NaN;
        int n3 = Integer.MIN_VALUE;
        int n4 = 0;
        int n5 = 131071;
        int n6 = 1073742026;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = null;
        float f2 = Float.MAX_VALUE;
        boolean bl4 = false;
        int n7 = 0;
        int n8 = 0;
        BS bS = new BS();
        boolean bl5 = false;
        int n9 = 0;
        int n10 = 0;
        float f3 = 0.0f;
        boolean bl6 = false;
        if (this.slen == 1) {
            if (!this.chk) {
                this.viewer.rebondState(this.isStateScript);
            }
            return;
        }
        block22: for (n2 = n; n2 < this.slen; ++n2) {
            switch (this.getToken((int)n2).tok) {
                case 0x10000C: 
                case 0x10000D: {
                    this.checkLength(2);
                    if (!this.chk) {
                        this.viewer.rebondState(this.isStateScript);
                    }
                    return;
                }
                case 2: 
                case 3: {
                    int n11;
                    if (n7 > 0) {
                        if (bl2 || bl4) {
                            this.error(23);
                        }
                        if ((n11 = JmolEdge.getBondOrderFromFloat(this.floatParameter(n2))) == 131071) {
                            this.error(22);
                        }
                        n5 = n11;
                        bl2 = true;
                        break;
                    }
                    if (++n8 > 2) {
                        this.error(2);
                    }
                    float f4 = this.floatParameter(n2);
                    if (this.tokAt(n2 + 1) == 269484210) {
                        f4 = -f4 / 100.0f;
                        ++n2;
                    }
                    fArray[n4++] = f4;
                    break;
                }
                case 10: 
                case 0x100001: {
                    int n12;
                    int n13;
                    if (n7 > 2 || bl5 && n7 > 0) {
                        this.error(2);
                    }
                    if (bl2 || bl4) {
                        this.error(23);
                    }
                    bSArray[n7++] = this.atomExpressionAt(n2);
                    bl5 = this.isBondSet;
                    if (n7 == 2) {
                        n13 = this.iToken;
                        for (n12 = n2; n12 < n13; ++n12) {
                            if (this.tokAt(n12) != 0x40000000 || !this.parameterAsString(n12).equals("_1")) continue;
                            n9 = n2;
                            break;
                        }
                        this.iToken = n13;
                    }
                    n2 = this.iToken;
                    break;
                }
                case 1087373318: {
                    bl6 = true;
                    break;
                }
                case 1766856708: {
                    int n13 = this.tokAt(n2 + 1);
                    if (n13 == 1073742180 || n13 == 1073742074) continue block22;
                    n10 = n2 + 1;
                    continue block22;
                }
                case 1073742074: 
                case 1073742180: {
                    if (string != null) {
                        this.error(22);
                    }
                    bl4 = true;
                    string = this.parameterAsString(n2);
                    if (this.theTok == 1073742180 && this.isFloatParameter(n2 + 1)) {
                        f2 = this.getTranslucentLevel(++n2);
                    }
                    n10 = n2 + 1;
                    break;
                }
                case 1074790662: {
                    int n12 = this.tokAt(2) == 1073741852 ? 1 : 0;
                    this.checkLength(n12 != 0 ? 3 : 2);
                    if (!this.chk) {
                        this.viewer.setPdbConectBonding(n12 != 0, this.isStateScript);
                    }
                    return;
                }
                case 0x40000006: 
                case 1073741852: 
                case 0x40000050: 
                case 1073742025: 
                case 1073742026: {
                    bl3 = true;
                    if (++n2 != this.slen) {
                        this.error(23);
                    }
                    n6 = this.theTok;
                    if (this.theTok != 1073741852 || n5 == 131071 || n5 == 2048 || n5 == 515) break;
                    this.error(22);
                    break;
                }
                case 0x1A101A: {
                    if (!bl4) {
                        n3 = 0xFFFFFF;
                        string = "translucent";
                        f2 = 0.5f;
                        f = this.viewer.getFloat(570425406);
                        bl4 = true;
                    }
                    if (!bl3) {
                        n6 = 1073742026;
                    }
                    bl3 = true;
                }
                case 0x40000000: 
                case 1076887572: 
                case 1612189718: {
                    int n11;
                    if (n2 > 0) {
                        if (n10 == n2) break;
                        if (this.isColorParam(n2)) {
                            n10 = -n2;
                            break;
                        }
                    }
                    if ((n11 = ScriptEvaluator.getBondOrderFromString((String)(object = this.parameterAsString(n2)))) == 131071) {
                        this.error(22);
                    }
                    if (bl2) {
                        this.error(18);
                    }
                    bl2 = true;
                    switch (n11) {
                        case 33: {
                            switch (this.tokAt(n2 + 1)) {
                                case 3: {
                                    n11 = ScriptEvaluator.getPartialBondOrderFromFloatEncodedInt(this.st[++n2].intValue);
                                    break;
                                }
                                case 2: {
                                    n11 = (short)this.intParameter(++n2);
                                }
                            }
                            break;
                        }
                        case 2048: {
                            if (this.tokAt(n2 + 1) != 2) break;
                            n11 = (short)(this.intParameter(++n2) << 11);
                            f3 = this.floatParameter(++n2);
                        }
                    }
                    n5 = n11;
                    break;
                }
                case 1666189314: {
                    f = this.floatParameter(++n2);
                    bl4 = true;
                    break;
                }
                case 12291: 
                case 0x10000B: {
                    if (++n2 != this.slen) {
                        this.error(23);
                    }
                    n6 = 12291;
                    bl = true;
                    bl4 = false;
                    break;
                }
                default: {
                    n10 = n2;
                }
            }
            if (n2 <= 0) continue;
            if (n10 == -n2 || n10 == n2 && this.isColorParam(n2)) {
                n3 = this.getArgbParam(n2);
                n2 = this.iToken;
                bl4 = true;
                continue;
            }
            if (n10 != n2) continue;
            this.error(22);
        }
        if (this.chk) {
            return;
        }
        if (n4 < 2) {
            if (n4 == 0) {
                fArray[0] = 1.0E8f;
            }
            fArray[1] = fArray[0];
            fArray[0] = 0.1f;
        }
        if (string != null || !Float.isNaN(f) || n3 != Integer.MIN_VALUE) {
            if (!bl2) {
                n5 = 65535;
            }
            if (!bl3) {
                n6 = 1073742025;
            }
        }
        n2 = 0;
        int n14 = 0;
        if (n9 > 0) {
            BS bS2 = new BS();
            this.definedAtomSets.put("_1", bS2);
            object = bSArray[0];
            int n15 = ((BS)object).nextSetBit(0);
            while (n15 >= 0) {
                bS2.set(n15);
                int[] nArray = this.viewer.makeConnections(fArray[0], fArray[1], n5, n6, bS2, this.atomExpressionAt(n9), bS, bl5, false, 0.0f);
                n2 += Math.abs(nArray[0]);
                n14 += nArray[1];
                bS2.clear(n15);
                n15 = ((BS)object).nextSetBit(n15 + 1);
            }
        } else {
            int[] nArray = this.viewer.makeConnections(fArray[0], fArray[1], n5, n6, bSArray[0], bSArray[1], bS, bl5, bl6, f3);
            n2 += Math.abs(nArray[0]);
            n14 += nArray[1];
        }
        if (bl) {
            if (!this.tQuiet && this.scriptLevel <= this.scriptReportingLevel) {
                this.scriptStatusOrBuffer(GT._("{0} connections deleted", n14));
            }
            return;
        }
        if (bl4) {
            this.viewer.selectBonds(bS);
            if (!Float.isNaN(f)) {
                this.setShapeSizeBs(1, Math.round(f * 2000.0f), null);
            }
            if (n3 != Integer.MIN_VALUE) {
                this.setShapePropertyBs(1, "color", n3, bS);
            }
            if (string != null) {
                if (f2 == Float.MAX_VALUE) {
                    f2 = this.viewer.getFloat(0x2200000A);
                }
                this.setShapeProperty(1, "translucentLevel", Float.valueOf(f2));
                this.setShapePropertyBs(1, "translucency", string, bS);
            }
            this.viewer.selectBonds(null);
        }
        if (!this.tQuiet && this.scriptLevel <= this.scriptReportingLevel) {
            this.scriptStatusOrBuffer(GT._("{0} new bonds; {1} modified", new Object[]{n2, n14}));
        }
    }

    private float getTranslucentLevel(int n) throws ScriptException {
        float f = this.floatParameter(n);
        return this.theTok == 2 && f > 0.0f && f < 9.0f ? f + 1.0f : f;
    }

    private void getProperty() throws ScriptException {
        BS bS;
        if (this.chk) {
            return;
        }
        String string = "";
        String string2 = this.optParameterAsString(1);
        String string3 = string2;
        if (string3.indexOf(".") >= 0) {
            string3 = string3.substring(0, string3.indexOf("."));
        }
        if (string3.indexOf("[") >= 0) {
            string3 = string3.substring(0, string3.indexOf("["));
        }
        int n = this.viewer.getPropertyNumber(string3);
        String string4 = this.optParameterAsString(2);
        int n2 = this.tokAt(2);
        BS bS2 = bS = n2 == 0x100001 || n2 == 10 ? this.atomExpressionAt(2) : null;
        if (string2.length() > 0 && n < 0) {
            string2 = "";
            string4 = "";
        } else if (n >= 0 && this.slen < 3) {
            string4 = this.viewer.getDefaultPropertyParam(n);
            if (string4.equals("(visible)")) {
                this.viewer.setModelVisibility();
                bS = this.viewer.getVisibleSet();
            }
        } else if (n == this.viewer.getPropertyNumber("fileContents")) {
            for (int i = 3; i < this.slen; ++i) {
                string4 = string4 + this.parameterAsString(i);
            }
        }
        string = (String)this.viewer.getProperty("readable", string2, bS == null ? string4 : bS);
        this.showString(string);
    }

    private void background(int n) throws ScriptException {
        this.getToken(n);
        if (this.theTok == 1073741979) {
            String string = this.parameterAsString(this.checkLast(++n));
            if (!this.chk && !string.equalsIgnoreCase("none") && string.length() > 0) {
                this.viewer.loadImage(string, null);
            }
            return;
        }
        if (this.isColorParam(n) || this.theTok == 0x10000B) {
            int n2 = this.getArgbParamLast(n, true);
            if (this.chk) {
                return;
            }
            this.setObjectArgb("background", n2);
            this.viewer.setBackgroundImage(null, null);
            return;
        }
        int n3 = this.getShapeType(this.theTok);
        this.colorShape(n3, n + 1, true);
    }

    private void center(int n) throws ScriptException {
        if (this.slen == 1) {
            this.viewer.setNewRotationCenter(null);
            return;
        }
        P3 p3 = this.centerParameter(n);
        if (p3 == null) {
            this.error(22);
        }
        if (!this.chk) {
            this.viewer.setNewRotationCenter(p3);
        }
    }

    private String setObjectProperty() throws ScriptException {
        String string = "";
        String string2 = this.getShapeNameParameter(2);
        Object[] objectArray = new Object[]{string2, null};
        if (this.chk) {
            return "";
        }
        int n = this.iToken;
        int n2 = this.tokAt(0);
        boolean bl = TextFormat.isWild(string2);
        int n3 = 17;
        do {
            if (n3 != 27 && this.getShapePropertyData(n3, "checkID", objectArray)) {
                this.setShapeProperty(n3, "thisID", string2);
                switch (n2) {
                    case 12291: {
                        this.setShapeProperty(n3, "delete", null);
                        break;
                    }
                    case 12294: 
                    case 1610625028: {
                        this.setShapeProperty(n3, "hidden", n2 == 1610625028 ? Boolean.FALSE : Boolean.TRUE);
                        break;
                    }
                    case 4148: {
                        string = string + (String)this.getShapeProperty(n3, "command") + "\n";
                        break;
                    }
                    case 1766856708: {
                        this.colorShape(n3, n + 1, false);
                    }
                }
                if (!bl) break;
            }
            if (n3 != 17) continue;
            n3 = 31;
        } while (--n3 >= 22);
        return string;
    }

    private void color() throws ScriptException {
        int n = 1;
        if (this.isColorParam(1)) {
            this.theTok = 0x44100001;
        } else {
            int n2 = 0;
            n = 2;
            int n3 = this.getToken((int)1).tok;
            switch (n3) {
                case 0x100007: {
                    this.setObjectProperty();
                    return;
                }
                case 0x10000B: 
                case 0x300002: 
                case 1073741946: 
                case 1073741992: 
                case 1073742030: 
                case 1073742074: 
                case 1073742116: 
                case 0x40000140: 
                case 1073742180: 
                case 1073742186: 
                case 1087373315: 
                case 0x40D00004: 
                case 1087373318: 
                case 1087373322: 
                case 1095761934: 
                case 1095761935: 
                case 1112539148: 
                case 1112539149: 
                case 1112541196: 
                case 1112541199: 
                case 1113200651: 
                case 1114638346: 
                case 1632634889: 
                case 1641025539: 
                case 1649412112: 
                case 1716520973: {
                    this.theTok = 0x44100001;
                    n = 1;
                    break;
                }
                case 4: {
                    boolean bl;
                    n = 1;
                    String string = this.stringParameter(n++);
                    if (this.isArrayParameter(n)) {
                        string = string + "=" + SV.sValue(SV.getVariableAS(this.stringParameterSet(n))).replace('\n', ' ');
                        n = this.iToken + 1;
                    }
                    boolean bl2 = bl = this.tokAt(n) == 1073742180;
                    if (!this.chk) {
                        this.viewer.setPropertyColorScheme(string, bl, true);
                    }
                    if (bl) {
                        ++n;
                    }
                    if (this.tokAt(n) == 1073742114 || this.tokAt(n) == 0x40000002) {
                        float f = this.floatParameter(++n);
                        float f2 = this.floatParameter(++n);
                        if (!this.chk) {
                            this.viewer.setCurrentColorRange(f, f2);
                        }
                    }
                    return;
                }
                case 0x40000002: 
                case 1073742114: {
                    float f = this.floatParameter(2);
                    float f3 = this.floatParameter(this.checkLast(3));
                    if (!this.chk) {
                        this.viewer.setCurrentColorRange(f, f3);
                    }
                    return;
                }
                case 1610616835: {
                    n2 = this.getArgbParamLast(2, true);
                    if (!this.chk) {
                        this.setObjectArgb("background", n2);
                    }
                    return;
                }
                case 10: 
                case 0x100001: {
                    n = -1;
                    this.theTok = 0x44100001;
                    break;
                }
                case 1073742134: {
                    n2 = this.getArgbParamLast(2, false);
                    if (!this.chk) {
                        this.viewer.setRubberbandArgb(n2);
                    }
                    return;
                }
                case 0x20000008: 
                case 1611141171: {
                    n = 2;
                    if (this.tokAt(2) == 1073742074) {
                        ++n;
                    }
                    n2 = this.getArgbParamLast(n, true);
                    if (this.chk) {
                        return;
                    }
                    this.sm.loadShape(8);
                    this.setShapeProperty(8, n3 == 1611141171 ? "argbSelection" : "argbHighlight", n2);
                    return;
                }
                case 0x40000000: 
                case 1611272194: 
                case 1613758476: 
                case 1614417948: 
                case 1679429641: {
                    String string = this.parameterAsString(1);
                    if (this.checkToken(2)) {
                        switch (this.getToken((int)2).tok) {
                            case 1073742116: {
                                n2 = 1073742116;
                                break;
                            }
                            case 0x10000B: 
                            case 1073741992: {
                                n2 = 1073741992;
                                break;
                            }
                            default: {
                                n2 = this.getArgbParam(2);
                            }
                        }
                    }
                    if (n2 == 0) {
                        this.error(9);
                    }
                    this.checkLast(this.iToken);
                    if (string.equalsIgnoreCase("axes") || StateManager.getObjectIdFromName(string) >= 0) {
                        this.setObjectArgb(string, n2);
                        return;
                    }
                    if (this.changeElementColor(string, n2)) {
                        return;
                    }
                    this.error(22);
                    break;
                }
                case 135180: 
                case 135402505: {
                    this.setShapeProperty(JC.shapeTokenIndex(n3), "thisID", "+PREVIOUS_MESH+");
                }
            }
        }
        this.colorShape(this.getShapeType(this.theTok), n, false);
    }

    private boolean changeElementColor(String string, int n) {
        int n2 = Elements.elementNumberMax;
        while (--n2 >= 0) {
            if (!string.equalsIgnoreCase(Elements.elementNameFromNumber(n2))) continue;
            if (!this.chk) {
                this.viewer.setElementArgb(n2, n);
            }
            return true;
        }
        n2 = Elements.altElementMax;
        while (--n2 >= 0) {
            if (!string.equalsIgnoreCase(Elements.altElementNameFromIndex(n2))) continue;
            if (!this.chk) {
                this.viewer.setElementArgb(Elements.altElementNumberFromIndex(n2), n);
            }
            return true;
        }
        if (string.charAt(0) != '_') {
            return false;
        }
        n2 = Elements.elementNumberMax;
        while (--n2 >= 0) {
            if (!string.equalsIgnoreCase("_" + Elements.elementSymbolFromNumber(n2))) continue;
            if (!this.chk) {
                this.viewer.setElementArgb(n2, n);
            }
            return true;
        }
        n2 = Elements.altElementMax;
        while (--n2 >= 4) {
            if (string.equalsIgnoreCase("_" + Elements.altElementSymbolFromIndex(n2))) {
                if (!this.chk) {
                    this.viewer.setElementArgb(Elements.altElementNumberFromIndex(n2), n);
                }
                return true;
            }
            if (!string.equalsIgnoreCase("_" + Elements.altIsotopeSymbolFromIndex(n2))) continue;
            if (!this.chk) {
                this.viewer.setElementArgb(Elements.altElementNumberFromIndex(n2), n);
            }
            return true;
        }
        return false;
    }

    private void colorShape(int n, int n2, boolean bl) throws ScriptException {
        int n3;
        String string = null;
        Object object = null;
        Integer n4 = null;
        BS bS = null;
        String string2 = "";
        boolean bl2 = false;
        boolean bl3 = n == 24 || n == 25;
        int n5 = 0;
        boolean bl4 = false;
        float f = Float.MAX_VALUE;
        if (n2 < 0) {
            bS = this.atomExpressionAt(-n2);
            n2 = this.iToken + 1;
            if (this.isBondSet) {
                bl4 = true;
                n = 1;
            }
        }
        if (bl) {
            this.getToken(n2);
        } else {
            bl = this.getToken((int)n2).tok == 1610616835;
            if (bl) {
                this.getToken(++n2);
            }
        }
        if (bl) {
            string2 = "bg";
        } else if (bl3) {
            switch (this.theTok) {
                case 1073742018: {
                    this.getToken(++n2);
                    string2 = "mesh";
                    break;
                }
                case 1073742094: {
                    n3 = this.getArgbParamOrNone(++n2, false);
                    n4 = n3 == 0 ? null : Integer.valueOf(n3);
                    n2 = this.iToken + 1;
                    this.getToken(n2);
                    break;
                }
                case 10: 
                case 0x100001: {
                    if (this.theToken.value instanceof Bond.BondSet) {
                        bS = (Bond.BondSet)this.theToken.value;
                        string2 = "vertex";
                    } else {
                        bS = this.atomExpressionAt(n2);
                        string2 = "atom";
                    }
                    f = Float.MIN_VALUE;
                    n2 = this.iToken + 1;
                    this.getToken(n2);
                }
            }
        }
        if (!this.chk && n == 27 && !this.mo(true)) {
            return;
        }
        int n6 = n3 = this.theTok == 1073742180 ? 1 : 0;
        if (n3 != 0 || this.theTok == 1073742074) {
            if (f == Float.MIN_VALUE) {
                this.error(22);
            }
            string = this.parameterAsString(n2++);
            if (n3 != 0 && this.isFloatParameter(n2)) {
                f = this.getTranslucentLevel(n2++);
            }
        }
        int n7 = 0;
        if (n2 < this.slen && this.tokAt(n2) != 0x10000D && this.tokAt(n2) != 0x10000C) {
            bl2 = true;
            n7 = this.getToken((int)n2).tok;
            if ((!bl3 || this.tokAt(n2 + 1) != 1074790746) && this.isColorParam(n2)) {
                int n8 = this.getArgbParamOrNone(n2, false);
                Integer n9 = object = n8 == 0 ? null : Integer.valueOf(n8);
                if (string == null && this.tokAt(n2 = this.iToken + 1) != 0) {
                    this.getToken(n2);
                    int n10 = n3 = this.theTok == 1073742180 ? 1 : 0;
                    if (n3 != 0 || this.theTok == 1073742074) {
                        string = this.parameterAsString(n2);
                        if (n3 != 0 && this.isFloatParameter(n2 + 1)) {
                            f = this.getTranslucentLevel(++n2);
                        }
                    } else if (this.isColorParam(n2)) {
                        n8 = this.getArgbParamOrNone(n2, false);
                        n4 = n8 == 0 ? null : Integer.valueOf(n8);
                    }
                }
            } else if (n == 26) {
                --this.iToken;
            } else {
                BS bS2;
                EnumPalette enumPalette;
                boolean bl5;
                String string3 = this.parameterAsString(n2).toLowerCase();
                boolean bl6 = string3.indexOf("byelement") == 0;
                boolean bl7 = bl5 = bl6 || string3.indexOf("byresidue") == 0;
                EnumPalette enumPalette2 = bl5 || bl3 ? EnumPalette.PROPERTY : (enumPalette = n7 == 1113200651 ? EnumPalette.CPK : EnumPalette.getPalette(string3));
                if (enumPalette == EnumPalette.UNKNOWN || (enumPalette == EnumPalette.TYPE || enumPalette == EnumPalette.ENERGY) && n != 2) {
                    this.error(22);
                }
                float[] fArray = null;
                BS bS3 = bS2 = enumPalette != EnumPalette.PROPERTY && enumPalette != EnumPalette.VARIABLE || !this.viewer.global.rangeSelected ? null : this.viewer.getSelectionSet(false);
                if (enumPalette == EnumPalette.PROPERTY) {
                    if (bl5) {
                        if (!this.chk) {
                            fArray = this.getBitsetPropertyFloat(bS2, (bl6 ? 1095763976 : 1095761930) | 0x100, Float.NaN, Float.NaN);
                        }
                    } else {
                        if (!bl5 && !bl3) {
                            ++n2;
                        }
                        if (string3.equals("property") && T.tokAttr(n7 = this.getToken((int)n2).tok, 0x40500000) && !T.tokAttr(n7, 0x40D00000) && !this.chk) {
                            fArray = this.getBitsetPropertyFloat(bS2, this.getToken((int)n2++).tok | 0x100, Float.NaN, Float.NaN);
                        }
                    }
                } else if (enumPalette == EnumPalette.VARIABLE) {
                    int n11 = ++n2;
                    ++n2;
                    string3 = this.parameterAsString(n11);
                    fArray = new float[this.viewer.getAtomCount()];
                    Parser.parseStringInfestedFloatArray("" + this.getParameter(string3, 4), null, fArray);
                    enumPalette = EnumPalette.PROPERTY;
                }
                if (enumPalette == EnumPalette.PROPERTY) {
                    Object object2;
                    String string4 = null;
                    if (this.tokAt(n2) == 4) {
                        string4 = this.parameterAsString(n2++).toLowerCase();
                        if (this.isArrayParameter(n2)) {
                            string4 = string4 + "=" + SV.sValue(SV.getVariableAS(this.stringParameterSet(n2))).replace('\n', ' ');
                            n2 = this.iToken + 1;
                        }
                    } else if (bl3 && this.isColorParam(n2)) {
                        string4 = this.getColorRange(n2);
                        n2 = this.iToken + 1;
                    }
                    if (string4 != null && !bl3) {
                        this.setStringProperty("propertyColorScheme", (n3 != 0 && f == Float.MAX_VALUE ? "translucent " : "") + string4);
                        bl5 = string4.indexOf("byelement") == 0 || string4.indexOf("byresidue") == 0;
                    }
                    Object object3 = 0.0f;
                    Object object4 = Float.MAX_VALUE;
                    if (!(bl5 || this.tokAt(n2) != 0x40000002 && this.tokAt(n2) != 1073742114)) {
                        object3 = this.floatParameter(n2 + 1);
                        object4 = this.floatParameter(n2 + 2);
                        n2 += 3;
                        if (object3 == object4 && bl3) {
                            object2 = (float[])this.getShapeProperty(n, "dataRange");
                            if (object2 != null) {
                                object3 = object2[0];
                                object4 = object2[1];
                            }
                        } else if (object3 == object4) {
                            object4 = Float.MAX_VALUE;
                        }
                    }
                    if (!this.chk) {
                        if (!bl3) {
                            if (fArray == null) {
                                this.viewer.setCurrentColorRange(string3);
                            } else {
                                this.viewer.setCurrentColorRangeData(fArray, bS2);
                            }
                        }
                        if (bl3) {
                            this.checkLength(n2);
                            bl2 = false;
                            object2 = this.viewer.getColorEncoder(string4);
                            if (object2 == null) {
                                return;
                            }
                            ((ColorEncoder)object2).isTranslucent = n3 != 0 && f == Float.MAX_VALUE;
                            ((ColorEncoder)object2).setRange((float)object3, (float)object4, object3 > object4);
                            if (object4 == Float.MAX_VALUE) {
                                ((ColorEncoder)object2).hi = object4;
                            }
                            this.setShapeProperty(n, "remapColor", object2);
                            this.showString(this.getIsosurfaceDataRange(n, ""));
                            if (f == Float.MAX_VALUE) {
                                return;
                            }
                        } else if (object4 != Float.MAX_VALUE) {
                            this.viewer.setCurrentColorRange((float)object3, (float)object4);
                        }
                    }
                } else {
                    ++n2;
                }
                this.checkLength(n2);
                object = enumPalette;
            }
        }
        if (this.chk || n < 0) {
            return;
        }
        switch (n) {
            case 4: {
                n5 = 32768;
                break;
            }
            case 2: {
                n5 = 30720;
                break;
            }
            case 3: {
                n5 = 256;
                break;
            }
            case 1: {
                n5 = 1023;
                break;
            }
            default: {
                n5 = 0;
            }
        }
        if (n5 == 0) {
            this.sm.loadShape(n);
            if (n == 5) {
                this.setShapeProperty(5, "setDefaults", this.viewer.getNoneSelected());
            }
        } else {
            if (bS != null) {
                this.viewer.selectBonds(bS);
                bS = null;
            }
            n = 1;
            this.setShapeProperty(n, "type", n5);
        }
        if (bl2) {
            switch (n7) {
                case 1112539148: 
                case 1112539149: {
                    this.viewer.autoCalculate(n7);
                    break;
                }
                case 1112541199: {
                    if (!this.viewer.global.rangeSelected) break;
                    this.viewer.clearBfactorRange();
                    break;
                }
                case 1087373318: {
                    this.viewer.calcSelectedGroupsCount();
                    break;
                }
                case 1073742030: 
                case 1095761935: {
                    this.viewer.calcSelectedMonomersCount();
                    break;
                }
                case 1095761934: {
                    this.viewer.calcSelectedMoleculesCount();
                }
            }
            if (n4 != null && (bl3 || n == 11 || n == 14)) {
                this.setShapeProperty(n, "colorPhase", new Object[]{n4, object});
            } else if (bS == null) {
                this.setShapeProperty(n, string2 + "color", object);
            } else {
                this.setShapePropertyBs(n, string2 + "color", object, bS);
            }
        }
        if (string != null) {
            this.setShapeTranslucency(n, string2, string, f, bS);
        }
        if (n5 != 0) {
            this.setShapeProperty(1, "type", 1023);
        }
        if (bl4) {
            this.viewer.selectBonds(null);
        }
        if (n == 0) {
            this.viewer.checkInheritedShapes();
        }
    }

    private void setShapeTranslucency(int n, String string, String string2, float f, BS bS) {
        if (f == Float.MAX_VALUE) {
            f = this.viewer.getFloat(0x2200000A);
        }
        this.setShapeProperty(n, "translucentLevel", Float.valueOf(f));
        if (string == null) {
            return;
        }
        if (bS == null) {
            this.setShapeProperty(n, string + "translucency", string2);
        } else if (!this.chk) {
            this.setShapePropertyBs(n, string + "translucency", string2, bS);
        }
    }

    private void cd() throws ScriptException {
        if (this.chk) {
            return;
        }
        String string = this.slen == 1 ? null : this.parameterAsString(1);
        this.showString(this.viewer.cd(string));
    }

    private void mapProperty() throws ScriptException {
        block19: {
            int n;
            Object object;
            Object[] objectArray;
            Object object2;
            String string;
            String string2;
            String string3;
            BS bS;
            BS bS2;
            int n2;
            int n3;
            int n4;
            block18: {
                block17: {
                    n4 = 0;
                    n3 = 0;
                    n2 = 0;
                    if (this.tokAt(1) != 1114638350) break block17;
                    bS2 = this.viewer.getSelectionSet(false);
                    bS = this.atomExpressionAt(2);
                    string3 = "selected";
                    string2 = "selected";
                    break block18;
                }
                bS2 = this.atomExpressionAt(1);
                if (this.tokAt(++this.iToken) != 0x100008 || !T.tokAttr(n4 = this.tokAt(++this.iToken), 0x40500000)) break block19;
                string2 = this.parameterAsString(this.iToken);
                bS = this.atomExpressionAt(++this.iToken);
                if (this.tokAt(++this.iToken) != 0x100008 || !T.tokAttr(n3 = this.tokAt(++this.iToken), 2048)) break block19;
                string3 = this.parameterAsString(this.iToken);
            }
            n2 = this.tokAt(this.iToken + 1);
            if (T.tokAttr(n2, 0x40500000)) {
                string = this.parameterAsString(++this.iToken);
            } else {
                n2 = 1095763969;
                string = T.nameOf(1095763969);
            }
            this.checkLast(this.iToken);
            if (this.chk) {
                return;
            }
            BS bS3 = null;
            this.showString("mapping " + string2.toUpperCase() + " for " + bS2.cardinality() + " atoms to " + string3.toUpperCase() + " for " + bS.cardinality() + " atoms using " + string.toUpperCase());
            if (T.tokAttrOr(n4, 1095761920, 1112539136) && T.tokAttrOr(n3, 1095761920, 1112539136) && T.tokAttrOr(n2, 1095761920, 1112539136)) {
                object2 = this.getBitsetPropertyFloat(bS2, n4 | 0xE0, Float.NaN, Float.NaN);
                objectArray = this.getBitsetPropertyFloat(bS2, n2 | 0xE0, Float.NaN, Float.NaN);
                object = this.getBitsetPropertyFloat(bS, n2 | 0xE0, Float.NaN, Float.NaN);
                n = n3 == 1716520973 ? 1 : 0;
                float[] fArray = new float[n != 0 ? this.viewer.getAtomCount() : ((float[])object).length];
                bS3 = new BS();
                if (((float[])object2).length == objectArray.length) {
                    int n5;
                    Hashtable<Float, Float> hashtable = new Hashtable<Float, Float>();
                    for (n5 = 0; n5 < ((float[])object2).length; ++n5) {
                        hashtable.put(Float.valueOf(objectArray[n5]), Float.valueOf(object2[n5]));
                    }
                    n5 = -1;
                    int n6 = 0;
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        n5 = bS.nextSetBit(n5 + 1);
                        Float f = (Float)hashtable.get(Float.valueOf((float)object[i]));
                        if (f == null) continue;
                        bS3.set(n5);
                        fArray[n != 0 ? n5 : n6] = f.floatValue();
                        ++n6;
                    }
                    if (n != 0) {
                        this.viewer.setData(string3, new Object[]{string3, fArray, bS3, 0}, this.viewer.getAtomCount(), 0, 0, Integer.MAX_VALUE, 0);
                    } else {
                        this.viewer.setAtomProperty(bS3, n3, 0, 0.0f, null, fArray, null);
                    }
                }
            }
            if (bS3 == null) {
                object2 = "{" + string + "=%[" + string + "]}." + string3 + " = %[" + string2 + "]";
                objectArray = (String[])this.getBitsetIdent(bS2, (String)object2, null, false, Integer.MAX_VALUE, false);
                object = new SB();
                for (n = 0; n < objectArray.length; ++n) {
                    if (objectArray[n].indexOf("null") >= 0) continue;
                    ((SB)object).append((String)objectArray[n]).appendC('\n');
                }
                if (Logger.debugging) {
                    Logger.info(((SB)object).toString());
                }
                BS bS4 = BSUtil.copy(this.viewer.getSelectionSubset());
                this.viewer.setSelectionSubset(bS);
                try {
                    this.runScript(((SB)object).toString());
                }
                catch (Exception exception) {
                    this.viewer.setSelectionSubset(bS4);
                    this.errorStr(-1, "Error: " + exception.toString());
                }
                catch (Error error) {
                    this.viewer.setSelectionSubset(bS4);
                    this.errorStr(-1, "Error: " + error.toString());
                }
                this.viewer.setSelectionSubset(bS4);
            }
            this.showString("DONE");
            return;
        }
        this.error(22);
    }

    private void data() throws ScriptException {
        String string = null;
        String string2 = null;
        boolean bl = false;
        this.iToken = this.slen;
        switch (this.iToken) {
            case 5: {
                string = this.parameterAsString(2);
            }
            case 2: 
            case 4: {
                string2 = this.parameterAsString(1);
                if (string2.equalsIgnoreCase("clear")) {
                    if (!this.chk) {
                        this.viewer.setData(null, null, 0, 0, 0, 0, 0);
                    }
                    return;
                }
                int n = string2.indexOf("@");
                if (n >= 0) {
                    string = "" + this.getParameter(string2.substring(n + 1), 4);
                    string2 = string2.substring(0, n).trim();
                    break;
                }
                if (string != null || (n = string2.indexOf(" ")) < 0) break;
                string = string2.substring(n + 1).trim();
                string2 = string2.substring(0, n).trim();
                bl = true;
                break;
            }
            default: {
                this.error(2);
            }
        }
        String string3 = string2 + " ";
        string3 = string3.substring(0, string3.indexOf(" ")).toLowerCase();
        if (string3.equals("model") || string3.equals("append")) {
            this.load();
            return;
        }
        if (this.chk) {
            return;
        }
        boolean bl2 = string2.toLowerCase().indexOf("(default)") >= 0;
        this.data = new Object[4];
        if (string3.equals("element_vdw")) {
            this.data[0] = string3;
            this.data[1] = string.replace(';', '\n');
            int n = Elements.elementNumberMax;
            int[] nArray = new int[n + 1];
            for (int i = 1; i <= n; ++i) {
                nArray[i] = i;
            }
            this.data[2] = nArray;
            this.data[3] = 0;
            this.viewer.setData("element_vdw", this.data, n, 0, 0, 0, 0);
            return;
        }
        if (string3.equals("connect_atoms")) {
            this.viewer.connect(Parser.parseFloatArray2d(string));
            return;
        }
        if (string3.indexOf("ligand_") == 0) {
            this.viewer.setLigandModel(string2.substring(7), string.trim());
            return;
        }
        if (string3.indexOf("data2d_") == 0) {
            this.data[0] = string2;
            this.data[1] = Parser.parseFloatArray2d(string);
            this.data[3] = 2;
            this.viewer.setData(string2, this.data, 0, 0, 0, 0, 0);
            return;
        }
        if (string3.indexOf("data3d_") == 0) {
            this.data[0] = string2;
            this.data[1] = Parser.parseFloatArray3d(string);
            this.data[3] = 3;
            this.viewer.setData(string2, this.data, 0, 0, 0, 0, 0);
            return;
        }
        String[] stringArray = Parser.getTokens(string2);
        if (!(string3.indexOf("property_") != 0 || stringArray.length == 2 && stringArray[1].equals("set"))) {
            int n;
            BS bS = this.viewer.getSelectionSet(false);
            this.data[0] = string3;
            int n2 = bl ? 0 : (Integer)this.viewer.getParameter("propertyAtomNumberField");
            int n3 = bl ? 0 : (Integer)this.viewer.getParameter("propertyAtomNumberColumnCount");
            int n4 = bl ? Integer.MIN_VALUE : (Integer)this.viewer.getParameter("propertyDataField");
            int n5 = n = bl ? 0 : (Integer)this.viewer.getParameter("propertyDataColumnCount");
            if (!bl && string2.indexOf(" ") >= 0) {
                if (stringArray.length == 3) {
                    string2 = stringArray[0];
                    n2 = Parser.parseInt(stringArray[1]);
                    n4 = Parser.parseInt(stringArray[2]);
                }
                if (stringArray.length == 5) {
                    string2 = stringArray[0];
                    n2 = Parser.parseInt(stringArray[1]);
                    n3 = Parser.parseInt(stringArray[2]);
                    n4 = Parser.parseInt(stringArray[3]);
                    n = Parser.parseInt(stringArray[4]);
                }
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            int n6 = this.viewer.getAtomCount();
            int[] nArray = null;
            BS bS2 = BSUtil.newBitSet(n6);
            if (n2 > 0) {
                int n7;
                nArray = new int[n6 + 2];
                for (n7 = 0; n7 <= n6; ++n7) {
                    nArray[n7] = -1;
                }
                n7 = bS.nextSetBit(0);
                while (n7 >= 0) {
                    int n8 = this.viewer.getAtomNumber(n7);
                    if (n8 <= n6 + 1 && n8 >= 0 && !bS2.get(n8)) {
                        bS2.set(n8);
                        nArray[n8] = n7;
                    }
                    n7 = bS.nextSetBit(n7 + 1);
                }
                this.data[2] = nArray;
            } else {
                this.data[2] = BSUtil.copy(bS);
            }
            this.data[1] = string;
            this.data[3] = 0;
            this.viewer.setData(string3, this.data, n6, n2, n3, n4, n);
            return;
        }
        int n = AtomCollection.getUserSettableType(string3);
        if (n >= 0) {
            this.viewer.setAtomData(n, string3, string, bl2);
            return;
        }
        this.data[0] = string2;
        this.data[1] = string;
        this.data[3] = 0;
        this.viewer.setData(string3, this.data, 0, 0, 0, 0, 0);
    }

    private void define() throws ScriptException {
        boolean bl;
        String string;
        if (this.slen < 3 || !(this.getToken((int)1).value instanceof String)) {
            this.error(22);
        }
        if (Parser.parseInt(string = ((String)this.getToken((int)1).value).toLowerCase()) != Integer.MIN_VALUE) {
            this.error(22);
        }
        if (this.chk) {
            return;
        }
        boolean bl2 = string.startsWith("site_");
        boolean bl3 = bl = string.indexOf("dynamic_") == 0;
        if (bl || bl2) {
            T[] tArray = new T[this.slen];
            int n = this.slen;
            while (--n >= 0) {
                tArray[n] = this.st[n];
            }
            this.definedAtomSets.put("!" + (bl2 ? string : string.substring(8)), tArray);
        } else {
            BS bS = this.atomExpressionAt(2);
            this.definedAtomSets.put(string, bS);
            if (!this.chk) {
                this.viewer.setUserVariable("@" + string, SV.newVariable(10, bS));
            }
        }
    }

    private void echo(int n, String string, boolean bl) throws ScriptException {
        if (this.chk) {
            return;
        }
        String string2 = this.optParameterAsString(n);
        if (this.viewer.getEchoStateActive()) {
            if (bl) {
                this.viewer.loadImage(string2, string);
                return;
            }
            if (string2.startsWith("\u0001")) {
                string2 = string2.substring(1);
                bl = true;
            }
            if (string2 != null) {
                this.setShapeProperty(30, "text", string2);
            }
        }
        if (!bl && this.viewer.getRefreshing()) {
            this.showString(this.viewer.formatText(string2));
        }
    }

    private void message() throws ScriptException {
        String string = this.parameterAsString(this.checkLast(1));
        if (this.chk) {
            return;
        }
        String string2 = this.viewer.formatText(string);
        if (this.outputBuffer == null) {
            this.viewer.showMessage(string2);
        }
        if (!string2.startsWith("_")) {
            this.scriptStatusOrBuffer(string2);
        }
    }

    private void log() throws ScriptException {
        if (this.slen == 1) {
            this.error(2);
        }
        if (this.chk) {
            return;
        }
        String string = this.parameterExpressionString(1, 0);
        if (this.tokAt(1) == 0x10000C) {
            this.setStringProperty("logFile", "");
        } else {
            this.viewer.log(string);
        }
    }

    private void label(int n) throws ScriptException {
        if (this.chk) {
            return;
        }
        this.sm.loadShape(5);
        String string = null;
        switch (this.getToken((int)n).tok) {
            case 0x10000D: {
                string = this.viewer.getStandardLabelFormat(0);
                break;
            }
            case 0x10000C: {
                break;
            }
            case 12294: 
            case 1610625028: {
                this.setShapeProperty(5, "display", this.theTok == 1610625028 ? Boolean.TRUE : Boolean.FALSE);
                return;
            }
            default: {
                string = this.parameterAsString(n);
            }
        }
        this.sm.setLabel(string, this.viewer.getSelectionSet(false));
    }

    private void hover() throws ScriptException {
        if (this.chk) {
            return;
        }
        String string = this.parameterAsString(1);
        if (string.equalsIgnoreCase("on")) {
            string = "%U";
        } else if (string.equalsIgnoreCase("off")) {
            string = null;
        }
        this.viewer.setHoverLabel(string);
    }

    private void load() throws ScriptException {
        String string;
        String string2;
        Object object;
        Object object2;
        int n;
        String string3;
        String string4;
        int n2;
        boolean bl = !this.chk || this.isCmdLine_C_Option;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n3 = this.tokAt(0) == 135270407 ? 0 : 1;
        boolean bl6 = this.viewer.getBoolean(603979792);
        String string5 = null;
        JmolList<Object> jmolList = null;
        int n4 = this.viewer.getModelCount() - (this.viewer.getFileName().equals("zapped") ? 1 : 0);
        int n5 = this.viewer.getAtomCount();
        SB sB = new SB().append("load");
        int n6 = 1;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (this.isStateScript) {
            hashtable.put("isStateScript", Boolean.TRUE);
            if (this.forceNoAddHydrogens) {
                hashtable.put("doNotAddHydrogens", Boolean.TRUE);
            }
        }
        String string6 = null;
        String[] stringArray = null;
        String[] stringArray2 = null;
        String string7 = null;
        String string8 = "";
        int n7 = 0;
        if (this.slen == 1) {
            n3 = 0;
        } else {
            string6 = this.parameterAsString(n3);
            if (this.slen == 2 && !this.chk && (string6.endsWith(".spt") || string6.endsWith(".png") || string6.endsWith(".pngj"))) {
                this.script(0, string6);
                return;
            }
            n2 = this.tokAt(n3);
            switch (n2) {
                case 1073742015: {
                    String string9 = this.parameterAsString(this.checkLast(2));
                    if (!this.chk) {
                        this.viewer.setMenu(string9, true);
                    }
                    return;
                }
                case 135270407: {
                    bl5 = true;
                    sB.append(" /*data*/ data");
                    string4 = this.stringParameter(++n3).toLowerCase();
                    sB.append(" ").append(Escape.eS(string4));
                    bl2 = string4.startsWith("append");
                    string3 = string4.indexOf("@") >= 0 ? "" + this.getParameter(string4.substring(string4.indexOf("@") + 1), 4) : this.parameterAsString(++n3);
                    string3 = Viewer.fixInlineString(string3, this.viewer.getInlineChar());
                    hashtable.put("fileData", string3);
                    hashtable.put("isData", Boolean.TRUE);
                    sB.appendC('\n');
                    sB.append(string3);
                    if (string4.indexOf("@") >= 0) break;
                    sB.append(" end ").append(Escape.eS(string4));
                    n3 += 2;
                    break;
                }
                case 0x4000000F: {
                    bl2 = true;
                    sB.append(" append");
                    string6 = this.optParameterAsString(++n3);
                    n2 = T.getTokFromName(string6);
                    break;
                }
                case 0x40000000: {
                    ++n3;
                    sB.append(" " + string6);
                    int n8 = n7 = n2 == 0x40000000 && Parser.isOneOf(string6.toLowerCase(), "xyz;vxyz;vibration;temperature;occupancy;partialcharge") ? T.getTokFromName(string6) : 0;
                    if (n7 == 0) break;
                    hashtable.put("atomDataOnly", Boolean.TRUE);
                    hashtable.put("modelNumber", 1);
                    if (n7 == 4166) {
                        n7 = 1146095631;
                    }
                    stringArray2 = this.viewer.getFileInfo();
                    bl2 = true;
                }
            }
            switch (n2) {
                case 1073741983: 
                case 1229984263: {
                    bl3 = n2 == 1073741983;
                    ++n3;
                    sB.append(" " + string6);
                    break;
                }
                case 135267336: {
                    bl4 = true;
                    ++n3;
                    break;
                }
                case 4156: {
                    hashtable.put("async", Boolean.TRUE);
                    ++n3;
                    break;
                }
                case 0x2000000E: 
                case 1095766028: {
                    ++n3;
                    sB.append(" " + string6);
                    if (n2 == 0x2000000E) {
                        hashtable.put("isTrajectory", Boolean.TRUE);
                    }
                    if (this.isPoint3f(n3)) {
                        P3 p3 = this.getPoint3f(n3, false);
                        n3 = this.iToken + 1;
                        hashtable.put("firstLastStep", new int[]{(int)p3.x, (int)p3.y, (int)p3.z});
                        sB.append(" " + Escape.eP(p3));
                        break;
                    }
                    if (this.tokAt(n3) == 10) {
                        BS bS = (BS)this.getToken((int)n3++).value;
                        hashtable.put("bsModels", bS);
                        sB.append(" " + Escape.eBS(bS));
                        break;
                    }
                    hashtable.put("firstLastStep", new int[]{0, -1, 1});
                    break;
                }
                case 0x40000000: {
                    break;
                }
                default: {
                    string6 = "fileset";
                }
            }
            if (this.getToken((int)n3).tok != 4) {
                this.error(16);
            }
        }
        int n9 = n3;
        string4 = null;
        if (this.tokAt(n9 + 1) == 1073741848) {
            string4 = this.stringParameter(n3 += 2);
            if (this.viewer.getPathForAllFiles() != "") {
                string4 = null;
                n9 = n3;
            }
        }
        string3 = null;
        String string10 = null;
        String string11 = null;
        if (this.slen == n3 + 1) {
            if (n3 == 0 || (string3 = this.parameterAsString(n9)).length() == 0) {
                string3 = this.viewer.getFullPathName();
            }
            if (string3 == null) {
                this.zap(false);
                return;
            }
            if (bl4) {
                string3 = "$" + string3;
            } else if (!bl3) {
                if (string3.indexOf("[]") >= 0) {
                    return;
                }
                if (string3.indexOf("[") == 0 && (stringArray = Escape.unescapeStringArray(string3)) != null) {
                    if (n3 == 1) {
                        sB.append(" files");
                    }
                    if (sB.indexOf(" files") < 0) {
                        this.error(22);
                    }
                    for (n = 0; n < stringArray.length; ++n) {
                        sB.append(" /*file*/").append(Escape.eS(stringArray[n]));
                    }
                }
            }
        } else if (this.getToken((int)(n3 + 1)).tok == 1073742010 || this.theTok == 2 || this.theTok == 7 || this.theTok == 0x10100040 || this.theTok == 1073742195 || this.theTok == 0x10000A || this.theTok == 8 || this.theTok == 0x40000100 || this.theTok == 1073741877 || this.theTok == 1073742163 || this.theTok == 1073742114 || this.theTok == 1073742152 || this.theTok == 1614417948 || this.theTok == 1073742066 || this.theTok == 0x40000074 && this.tokAt(n3 + 3) != 0x100006 || this.theTok == 0x4000000F || this.theTok == 0x40000000 && this.tokAt(n3 + 3) != 0x100006) {
            int n10;
            Object object3;
            string3 = this.parameterAsString(n9);
            if (string3.length() == 0 && (string3 = this.viewer.getFullPathName()) == null) {
                this.zap(false);
                return;
            }
            if (n9 == n3) {
                ++n3;
            }
            if (string3.indexOf("[]") >= 0) {
                return;
            }
            n2 = this.tokAt(n3);
            if (n2 == 1073742010) {
                String string12 = this.stringParameter(++n3);
                hashtable.put("manifest", string12);
                string8 = string8 + " MANIFEST " + Escape.eS(string12);
                n2 = this.tokAt(++n3);
            }
            switch (n2) {
                case 2: {
                    int n11 = this.intParameter(n3);
                    string8 = string8 + " " + n11;
                    if (n11 < 0) {
                        hashtable.put("vibrationNumber", -n11);
                    } else {
                        hashtable.put("modelNumber", n11);
                    }
                    n2 = this.tokAt(++n3);
                    break;
                }
                case 7: 
                case 0x10100040: 
                case 1073742195: {
                    object2 = this.floatParameterSet(n3, 1, Integer.MAX_VALUE);
                    n3 = this.iToken;
                    object = new BS();
                    for (int i = 0; i < ((float[])object2).length; ++i) {
                        if (!(object2[i] >= 1.0f) || object2[i] != (float)((int)object2[i])) continue;
                        object.set((int)object2[i] - 1);
                    }
                    hashtable.put("bsModels", object);
                    object3 = new int[object.cardinality()];
                    int n12 = 0;
                    n10 = object.nextSetBit(0);
                    while (n10 >= 0) {
                        object3[n12++] = n10 + 1;
                        n10 = object.nextSetBit(n10 + 1);
                    }
                    string8 = string8 + " " + Escape.eAI((int[])object3);
                    n2 = this.tokAt(n3);
                }
            }
            P3 p3 = null;
            if (n2 == 0x10000A || n2 == 8) {
                p3 = this.getPoint3f(n3, false);
                n3 = this.iToken + 1;
                n2 = this.tokAt(n3);
            }
            switch (n2) {
                case 1073741877: 
                case 0x40000100: 
                case 1073742114: 
                case 1073742152: 
                case 1073742163: 
                case 1614417948: {
                    if (p3 == null) {
                        p3 = P3.new3(555.0f, 555.0f, -1.0f);
                    }
                    this.iToken = n3 - 1;
                }
            }
            object2 = null;
            if (p3 != null) {
                hashtable.put("lattice", p3);
                n3 = this.iToken + 1;
                string8 = string8 + " {" + (int)p3.x + " " + (int)p3.y + " " + (int)p3.z + "}";
                if (this.tokAt(n3) == 0x40000100) {
                    hashtable.put("packed", Boolean.TRUE);
                    string8 = string8 + " PACKED";
                    ++n3;
                }
                if (this.tokAt(n3) == 1073741877) {
                    hashtable.put("centroid", Boolean.TRUE);
                    string8 = string8 + " CENTROID";
                    if (this.tokAt(++n3) == 0x40000100 && !hashtable.containsKey("packed")) {
                        hashtable.put("packed", Boolean.TRUE);
                        string8 = string8 + " PACKED";
                        ++n3;
                    }
                }
                if (this.tokAt(n3) == 1073742163) {
                    if (this.isPoint3f(++n3)) {
                        object3 = this.getPoint3f(n3, false);
                        if (((P3)object3).x != (float)((int)((P3)object3).x) || ((P3)object3).y != (float)((int)((P3)object3).y) || ((P3)object3).z != (float)((int)((P3)object3).z) || ((P3)object3).x < 1.0f || ((P3)object3).y < 1.0f || ((P3)object3).z < 1.0f) {
                            this.iToken = n3;
                            this.error(22);
                        }
                        object = object3;
                        n3 = this.iToken + 1;
                    } else {
                        object = this.stringParameter(n3++);
                    }
                    hashtable.put("supercell", object);
                }
                float f = 0.0f;
                if (this.tokAt(n3) == 1073742114) {
                    int n13 = ++n3;
                    ++n3;
                    f = this.floatParameter(n13);
                    string8 = string8 + " range " + f;
                }
                hashtable.put("symmetryRange", Float.valueOf(f));
                object3 = null;
                n10 = Integer.MIN_VALUE;
                if (this.tokAt(n3) == 1073742152) {
                    int n14 = ++n3;
                    ++n3;
                    object3 = TextFormat.simpleReplace(this.parameterAsString(n14), "''", "\"");
                    string8 = string8 + " spacegroup " + Escape.eS((String)object3);
                    if (((String)object3).equalsIgnoreCase("ignoreOperators")) {
                        n10 = -999;
                    } else {
                        if (((String)object3).length() == 0) {
                            SymmetryInterface symmetryInterface = this.viewer.getCurrentUnitCell();
                            if (symmetryInterface != null) {
                                object3 = symmetryInterface.getSpaceGroupName();
                            }
                        } else if (((String)object3).indexOf(",") >= 0 && p3.x < 9.0f && p3.y < 9.0f && p3.z == 0.0f) {
                            object3 = (String)object3 + "#doNormalize=0";
                        }
                        hashtable.put("spaceGroupName", object3);
                        n10 = -2;
                    }
                }
                float[] fArray = null;
                if (this.tokAt(n3) == 1614417948) {
                    if (this.optParameterAsString(++n3).length() == 0) {
                        SymmetryInterface symmetryInterface = this.viewer.getCurrentUnitCell();
                        if (symmetryInterface != null) {
                            fArray = symmetryInterface.getUnitCellAsArray(true);
                            object2 = symmetryInterface.getCartesianOffset();
                        }
                    } else {
                        fArray = this.floatParameterSet(n3, 6, 9);
                    }
                    if (fArray == null || fArray.length != 6 && fArray.length != 9) {
                        this.error(22);
                    }
                    string8 = string8 + " unitcell {";
                    for (int i = 0; i < fArray.length; ++i) {
                        string8 = string8 + (i == 0 ? "" : " ") + fArray[i];
                    }
                    string8 = string8 + "}";
                    hashtable.put("unitcell", fArray);
                    if (n10 == Integer.MIN_VALUE) {
                        n10 = -1;
                    }
                }
                n3 = this.iToken + 1;
                if (n10 != Integer.MIN_VALUE) {
                    hashtable.put("spaceGroupIndex", n10);
                }
            }
            if (object2 != null) {
                this.coordinatesAreFractional = false;
            } else if (this.tokAt(n3) == 1073742066) {
                object2 = this.getPoint3f(++n3, true);
            }
            if (object2 != null) {
                if (this.coordinatesAreFractional) {
                    ((Tuple3f)object2).setT(this.fractionalPoint);
                    hashtable.put("unitCellOffsetFractional", this.coordinatesAreFractional ? Boolean.TRUE : Boolean.FALSE);
                    string8 = string8 + " offset {" + ((P3)object2).x + " " + ((P3)object2).y + " " + ((P3)object2).z + "/1}";
                } else {
                    string8 = string8 + " offset " + Escape.eP((Tuple3f)object2);
                }
                hashtable.put("unitCellOffset", object2);
                n3 = this.iToken + 1;
            }
            if (this.tokAt(n3) == 0x4000000F) {
                if (this.tokAt(++n3) == 135270407) {
                    n3 += 2;
                    string10 = (String)this.getToken((int)n3++).value;
                    string11 = this.stringParameter(++n3);
                    ++n3;
                } else {
                    string11 = this.stringParameter(n3++);
                    string10 = this.stringParameter(n3++);
                }
                hashtable.put(string11, string10);
            }
            if (this.tokAt(n3) == 0x40000074) {
                string5 = this.stringParameter(++n3);
            }
        } else {
            if (n3 == 1) {
                ++n3;
                sB.append(" " + string6);
            }
            P3 p3 = null;
            object2 = null;
            object = new JmolList();
            block31: while (n3 < this.slen) {
                switch (this.tokAt(n3)) {
                    case 0x40000074: {
                        string5 = this.stringParameter(++n3);
                        ++n3;
                        continue block31;
                    }
                    case 0x100006: {
                        hashtable.remove("isTrajectory");
                        if (jmolList == null) {
                            jmolList = new JmolList<Object>();
                            p3 = P3.new3(0.0f, -1.0f, 1.0f);
                        }
                        if (this.isPoint3f(++n3)) {
                            p3 = this.getPoint3f(n3, false);
                            n3 = this.iToken + 1;
                            break;
                        }
                        if (this.tokAt(n3) != 10) break;
                        object2 = (BS)this.getToken((int)n3).value;
                        p3 = null;
                        n3 = this.iToken + 1;
                        break;
                    }
                    case 0x40000000: {
                        this.error(22);
                    }
                }
                string3 = this.parameterAsString(n3++);
                object.addLast(string3);
                if (p3 != null) {
                    jmolList.addLast(new int[]{(int)p3.x, (int)p3.y, (int)p3.z});
                    sB.append(" COORD " + Escape.eP(p3));
                } else if (object2 != null) {
                    jmolList.addLast(object2);
                    sB.append(" COORD " + Escape.eBS((BS)object2));
                }
                sB.append(" /*file*/$FILENAME" + object.size() + "$");
            }
            if (jmolList != null) {
                hashtable.put("firstLastSteps", jmolList);
            }
            n6 = object.size();
            stringArray = new String[n6];
            for (int i = 0; i < n6; ++i) {
                stringArray[i] = (String)object.get(i);
            }
            string3 = "fileSet";
        }
        if (!bl) {
            return;
        }
        if (string10 != null) {
            string8 = string8 + " APPEND data \"" + string11 + "\"\n" + string10 + (string10.endsWith("\n") ? "" : "\n") + "end \"" + string11 + "\"";
        }
        if (string5 == null) {
            string5 = this.viewer.getDefaultLoadFilter();
        }
        if (string5.length() > 0) {
            hashtable.put("filter", string5);
            if (string5.equalsIgnoreCase("2d")) {
                string5 = "2D-noMin";
            }
            string8 = string8 + " FILTER " + Escape.eS(string5);
        }
        n = 0;
        if (stringArray == null) {
            if (bl3) {
                hashtable.put("fileData", string3);
            } else if (string3.startsWith("@") && string3.length() > 1) {
                n = 1;
                object2 = this.getStringParameter(string3.substring(1), false);
                hashtable.put("fileData", object2);
                sB = new SB().append("{\n    var ").append(string3.substring(1)).append(" = ").append(Escape.eS((String)object2)).append(";\n    ").appendSB(sB);
            }
        }
        object2 = null;
        if (string4 != null) {
            if (string4.equals(".")) {
                string4 = this.viewer.getFilePath(string3, true);
            }
            if (string4.length() == 0 || this.viewer.getFilePath(string4, false).equalsIgnoreCase(this.viewer.getFilePath(string3, false))) {
                this.error(22);
            }
            if ((object2 = (Object)this.viewer.getOutputStream(string4, (String[])(object = new String[]{string4}))) == null) {
                Logger.error("Could not create output stream for " + object[0]);
            } else {
                hashtable.put("OutputStream", object2);
            }
        }
        if (stringArray == null && n7 == 0) {
            sB.append(" ");
            if (n != 0 || bl3) {
                sB.append(Escape.eS(string3));
            } else if (!bl5) {
                if (!string3.equals("string") && !string3.equals("string[]")) {
                    sB.append("/*file*/");
                }
                if (string4 != null) {
                    string4 = this.viewer.getFilePath(string4, false);
                }
                sB.append(string4 != null ? Escape.eS(string4) : "$FILENAME$");
            }
            if (string8.length() > 0) {
                sB.append(" /*options*/ ").append(string8);
            }
            if (n != 0) {
                sB.append("\n  }");
            }
            hashtable.put("loadScript", sB);
        }
        this.setCursorWait(true);
        string7 = this.viewer.loadModelFromFile(null, string3, stringArray, null, bl2, hashtable, sB, n7);
        if (object2 != null) {
            try {
                this.viewer.setFileInfo(new String[]{string4, string4, string4});
                Logger.info(GT._("file {0} created", string4));
                this.showString(this.viewer.getFilePath(string4, false) + " created");
                ((OutputStream)object2).close();
            }
            catch (IOException iOException) {
                Logger.error("error closing file " + iOException.toString());
            }
        }
        if (n7 > 0) {
            this.viewer.setFileInfo(stringArray2);
            if (string7 != null && !this.isCmdLine_c_or_C_Option) {
                this.evalError(string7, null);
            }
            return;
        }
        if (string7 != null && !this.isCmdLine_c_or_C_Option) {
            if (string7.indexOf("NOTE: file recognized as a script file: ") == 0) {
                string3 = string7.substring("NOTE: file recognized as a script file: ".length()).trim();
                this.script(0, string3);
                return;
            }
            this.evalError(string7, null);
        }
        if (bl2 && (bl6 || n6 > 1)) {
            this.viewer.setAnimationRange(-1, -1);
            this.viewer.setCurrentModelIndex(n4);
        }
        if (this.scriptLevel == 0 && !bl2 && n6 < 2) {
            this.showString((String)this.viewer.getModelSetAuxiliaryInfoValue("modelLoadNote"));
        }
        if (this.logMessages) {
            this.scriptStatusOrBuffer("Successfully loaded:" + (stringArray == null ? hashtable.get("fullPathName") : string6));
        }
        if ((object = this.viewer.getModelSetAuxiliaryInfo()) != null && object.containsKey("centroidMinMax") && this.viewer.getAtomCount() > 0) {
            this.viewer.setCentroid(bl2 ? n5 : 0, this.viewer.getAtomCount() - 1, (int[])object.get("centroidMinMax"));
        }
        String string13 = this.viewer.getDefaultLoadScript();
        String string14 = "";
        if (string13.length() > 0) {
            string14 = string14 + "\nUsing defaultLoadScript: " + string13;
        }
        if (object != null && this.viewer.allowEmbeddedScripts() && (string2 = (String)object.remove("jmolscript")) != null && string2.length() > 0) {
            string14 = string14 + "\nAdding embedded #jmolscript: " + string2;
            string13 = string13 + ";" + string2;
            this.setStringProperty("_loadScript", string13);
            string13 = "allowEmbeddedScripts = false;try{" + string13 + "} allowEmbeddedScripts = true;";
        }
        this.logLoadInfo(string14);
        String string15 = string = object == null ? null : (String)object.remove("sitescript");
        if (string != null) {
            string13 = string + ";" + string13;
        }
        if (string13.length() > 0 && !this.isCmdLine_c_or_C_Option) {
            this.runScript(string13);
        }
    }

    private void logLoadInfo(String string) {
        if (string.length() > 0) {
            Logger.info(string);
        }
        SB sB = new SB();
        int n = this.viewer.getModelCount();
        if (n > 1) {
            sB.append((this.viewer.isMovie() ? this.viewer.getFrameCount() + " frames" : n + " models") + "\n");
        }
        for (int i = 0; i < n; ++i) {
            Map map = (Map)this.viewer.getModelAuxiliaryInfoValue(i, "moData");
            if (map == null) continue;
            sB.appendI(((JmolList)map.get("mos")).size()).append(" molecular orbitals in model ").append(this.viewer.getModelNumberDotted(i)).append("\n");
        }
        if (sB.length() > 0) {
            this.showString(sB.toString());
        }
    }

    private String getFullPathName() throws ScriptException {
        String string;
        String string2 = string = !this.chk || this.isCmdLine_C_Option ? this.viewer.getFullPathName() : "test.xyz";
        if (string == null) {
            this.error(22);
        }
        return string;
    }

    private void measure() throws ScriptException {
        if (this.tokAt(1) == 135267335) {
            String string = this.stringParameter(this.slen == 3 ? 2 : 4);
            if (this.chk) {
                return;
            }
            JmolNode[] jmolNodeArray = this.viewer.modelSet.atoms;
            int n = this.viewer.getAtomCount();
            int[][] nArray = this.viewer.getSmilesMatcher().getCorrelationMaps(string, jmolNodeArray, n, this.viewer.getSelectionSet(false), true, false);
            if (nArray == null) {
                return;
            }
            this.setShapeProperty(6, "maps", nArray);
            return;
        }
        switch (this.slen) {
            case 1: 
            case 2: {
                switch (this.getToken((int)1).tok) {
                    case 0: 
                    case 0x10000D: {
                        this.setShapeProperty(6, "hideAll", Boolean.FALSE);
                        return;
                    }
                    case 0x10000C: {
                        this.setShapeProperty(6, "hideAll", Boolean.TRUE);
                        return;
                    }
                    case 1073742001: {
                        if (!this.chk) {
                            this.showStringPrint(this.viewer.getMeasurementInfoAsString(), false);
                        }
                        return;
                    }
                    case 12291: {
                        if (!this.chk) {
                            this.viewer.clearAllMeasurements();
                        }
                        return;
                    }
                    case 4: {
                        this.setShapeProperty(6, "setFormats", this.stringParameter(1));
                        return;
                    }
                }
                this.errorStr(24, "ON, OFF, DELETE");
                break;
            }
            case 3: {
                switch (this.getToken((int)1).tok) {
                    case 12291: {
                        if (this.getToken((int)2).tok == 0x100003) {
                            if (!this.chk) {
                                this.viewer.clearAllMeasurements();
                            }
                        } else {
                            int n = this.intParameter(2) - 1;
                            if (!this.chk) {
                                this.viewer.deleteMeasurement(n);
                            }
                        }
                        return;
                    }
                }
            }
        }
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int[] nArray = new int[5];
        float[] fArray = new float[]{Float.MAX_VALUE, Float.MAX_VALUE};
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        RadiusData radiusData = null;
        Boolean bl5 = null;
        int n6 = 269484114;
        String string = null;
        JmolList<Object> jmolList = new JmolList<Object>();
        BS bS = new BS();
        Object object = null;
        TickInfo tickInfo = null;
        int n7 = 0;
        block36: for (int i = 1; i < this.slen; ++i) {
            switch (this.getToken((int)i).tok) {
                case 0x40000000: {
                    this.errorStr(24, "ALL, ALLCONNECTED, DELETE");
                    continue block36;
                }
                default: {
                    this.error(15);
                    continue block36;
                }
                case 0x10100070: {
                    if (this.tokAt(i + 1) != 135266310) {
                        this.error(22);
                    }
                    ++i;
                    bl3 = true;
                    continue block36;
                }
                case 0x100003: 
                case 135266310: 
                case 0x4000000A: {
                    bl2 = this.theTok == 0x4000000A;
                    n4 = -1;
                    bl = true;
                    if (!bl2 || !bl3) continue block36;
                    this.error(22);
                    continue block36;
                }
                case 3: {
                    if (radiusData != null) {
                        this.error(22);
                    }
                    bl = true;
                    bl4 = true;
                    n5 = (n5 + 1) % 2;
                    fArray[n5] = this.floatParameter(i);
                    continue block36;
                }
                case 12291: {
                    if (n6 != 269484114) {
                        this.error(22);
                    }
                    n6 = 12291;
                    continue block36;
                }
                case 2: {
                    int n8 = this.intParameter(i);
                    if (bl) {
                        bl4 = true;
                        n5 = (n5 + 1) % 2;
                        fArray[n5] = n8;
                        continue block36;
                    }
                    n4 = this.viewer.getAtomIndexFromAtomNumber(n8);
                    if (!this.chk && n4 < 0) {
                        return;
                    }
                    if (object != null) {
                        this.error(22);
                    }
                    if ((nArray[0] = ++n) > 4) {
                        this.error(2);
                    }
                    nArray[n] = n4;
                    continue block36;
                }
                case 1095761933: {
                    n3 = this.intParameter(++i);
                    continue block36;
                }
                case 0x10000C: {
                    if (n6 != 269484114) {
                        this.error(22);
                    }
                    n6 = 0x10000C;
                    continue block36;
                }
                case 0x10000D: {
                    if (n6 != 269484114) {
                        this.error(22);
                    }
                    n6 = 0x10000D;
                    continue block36;
                }
                case 1073742114: {
                    bl = true;
                    bl4 = true;
                    n4 = -1;
                    continue block36;
                }
                case 1073741989: 
                case 1073741990: {
                    bl5 = this.theTok == 1073741989;
                    bl = true;
                    bl3 = this.theTok == 1073741990;
                    continue block36;
                }
                case 1649412112: {
                    if (n5 >= 0) {
                        this.error(22);
                    }
                    radiusData = this.encodeRadiusParameter(i, false, true);
                    radiusData.values = fArray;
                    i = this.iToken;
                    bl3 = true;
                    bl = true;
                    bl5 = false;
                    if (n7 != 1) continue block36;
                    ++n7;
                    ++n;
                    Object object2 = BSUtil.copy(bS);
                    BSUtil.invertInPlace((BS)object2, this.viewer.getAtomCount());
                    ((BS)object2).and(this.viewer.getAtomsWithinRadius(5.0f, bS, false, null));
                    jmolList.addLast(object2);
                    continue block36;
                }
                case 8: 
                case 10: 
                case 0x100001: 
                case 0x100007: 
                case 0x10000A: {
                    Object object2;
                    if (this.theTok == 10 || this.theTok == 0x100001) {
                        ++n7;
                    }
                    if (n4 >= 0) {
                        this.error(22);
                    }
                    this.expressionResult = Boolean.FALSE;
                    object = this.centerParameter(i);
                    if (this.expressionResult instanceof BS) {
                        bS = (BS)this.expressionResult;
                        object = bS;
                        if (!this.chk && bS.length() == 0) {
                            return;
                        }
                    }
                    if (object instanceof P3) {
                        object2 = new Point3fi();
                        ((Tuple3f)object2).setT((P3)object);
                        ((Point3fi)object2).modelIndex = (short)n3;
                        object = object2;
                    }
                    if ((n = ++n2) > 4) {
                        this.error(2);
                    }
                    i = this.iToken;
                    jmolList.addLast(object);
                    continue block36;
                }
                case 4: {
                    string = this.stringParameter(i);
                    continue block36;
                }
                case 1073742164: {
                    tickInfo = this.checkTicks(i, false, true, true);
                    i = this.iToken;
                    n6 = 1060866;
                }
            }
        }
        if (radiusData != null && (n5 >= 0 || n != 2) || n < 2 && (tickInfo == null || n == 1)) {
            this.error(2);
        }
        if (string != null && string.indexOf(n + ":") != 0) {
            string = n + ":" + string;
        }
        if (bl4 && fArray[1] < fArray[0]) {
            fArray[1] = fArray[0];
            float f = fArray[0] = fArray[1] == Float.MAX_VALUE ? Float.MAX_VALUE : -200.0f;
        }
        if (this.chk) {
            return;
        }
        if (object != null || tickInfo != null) {
            if (radiusData == null) {
                radiusData = new RadiusData(fArray, 0.0f, null, null);
            }
            if (object == null) {
                tickInfo.id = "default";
            }
            if (object != null && string != null && n6 == 269484114) {
                n6 = 1060866;
            }
            this.setShapeProperty(6, "measure", new MeasurementData(this.viewer, jmolList).set(n6, radiusData, string, null, tickInfo, bl2, bl3, bl5, bl));
            return;
        }
        switch (n6) {
            case 12291: {
                this.setShapeProperty(6, "delete", nArray);
                break;
            }
            case 0x10000D: {
                this.setShapeProperty(6, "show", nArray);
                break;
            }
            case 0x10000C: {
                this.setShapeProperty(6, "hide", nArray);
                break;
            }
            default: {
                this.setShapeProperty(6, string == null ? "toggle" : "toggleOn", nArray);
                if (string == null) break;
                this.setShapeProperty(6, "setFormats", string);
            }
        }
    }

    private String plot(T[] tArray) throws ScriptException {
        String string;
        Object object;
        int n;
        int n2 = this.viewer.getCurrentModelIndex();
        if (n2 < 0) {
            this.errorStr(30, "plot");
        }
        n2 = this.viewer.getJmolDataSourceFrame(n2);
        int n3 = tArray.length - 1;
        boolean bl = tArray != this.st;
        T[] tArray2 = this.st;
        if (bl) {
            this.st = tArray;
        }
        int n4 = bl ? 4148 : tArray[0].tok;
        int n5 = bl || n4 == 0x8101011 || n4 == 1052714 ? 0 : 1;
        String string2 = null;
        boolean bl2 = true;
        boolean bl3 = false;
        switch (n4) {
            case 4133: 
            case 1052714: 
            case 0x8101011: {
                break;
            }
            case 135176: {
                bl2 = false;
                bl3 = true;
                break;
            }
            case 4148: {
                bl2 = false;
                break;
            }
            case 135270421: {
                bl2 = false;
                if (ScriptEvaluator.tokAtArray(n3, tArray) == 4) {
                    string2 = this.stringParameter(n3--);
                    break;
                }
                if (ScriptEvaluator.tokAtArray(n3 - 1, tArray) == 0x100008) {
                    string2 = this.parameterAsString(n3 - 2) + "." + this.parameterAsString(n3);
                    n3 -= 3;
                    break;
                }
                this.st = tArray2;
                this.iToken = this.st.length;
                this.error(13);
            }
        }
        String string3 = "";
        Object[] objectArray = null;
        String string4 = "";
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        BS bS = BSUtil.copy(this.viewer.getSelectionSet(false));
        String string5 = "; select " + Escape.eBS(bS) + ";\n ";
        String string6 = this.optParameterAsString(n3).toLowerCase();
        P3 p3 = null;
        P3 p32 = null;
        int n9 = ScriptEvaluator.tokAtArray(n5, tArray);
        if (n9 == 4) {
            n9 = T.getTokFromName((String)tArray[n5].value);
        }
        switch (n9) {
            default: {
                this.iToken = 1;
                this.error(22);
                break;
            }
            case 135270407: {
                this.iToken = 1;
                string6 = "data";
                string5 = "";
                break;
            }
            case 1716520973: {
                this.iToken = n5 + 1;
                n6 = this.tokAt(this.iToken++);
                if (!T.tokAttr(n6, 0x40500000) || !T.tokAttr(n7 = this.tokAt(this.iToken++), 0x40500000)) {
                    this.error(22);
                }
                if (T.tokAttr(n8 = this.tokAt(this.iToken), 0x40500000)) {
                    ++this.iToken;
                } else {
                    n8 = 0;
                }
                if (this.tokAt(this.iToken) == 32) {
                    p3 = this.getPoint3f(++this.iToken, false);
                    ++this.iToken;
                }
                if (this.tokAt(this.iToken) == 64) {
                    p32 = this.getPoint3f(++this.iToken, false);
                    ++this.iToken;
                }
                string6 = "property " + T.nameOf(n6) + " " + T.nameOf(n7) + (n8 == 0 ? "" : " " + T.nameOf(n8));
                if (bS.nextSetBit(0) < 0) {
                    bS = this.viewer.getModelUndeletedAtomsBitSet(n2);
                }
                string4 = "select " + Escape.eBS(bS) + ";\n ";
                break;
            }
            case 1052714: {
                if (string6.equalsIgnoreCase("draw")) {
                    bl3 = true;
                    string6 = this.optParameterAsString(--n3).toLowerCase();
                }
                bl7 = n3 > n5 && string6.startsWith("r");
                string6 = "ramachandran" + (bl7 ? " r" : "") + (n4 == 135176 ? " draw" : "");
                break;
            }
            case 0x8101011: 
            case 137363468: {
                string3 = " \"" + this.viewer.getQuaternionFrame() + "\"";
                string4 = "set quaternionFrame" + string3 + ";\n  ";
                bl4 = true;
                if (string6.equalsIgnoreCase("draw")) {
                    bl3 = true;
                    string6 = this.optParameterAsString(--n3).toLowerCase();
                }
                bl5 = string6.startsWith("deriv") || string6.startsWith("diff");
                boolean bl8 = bl6 = bl5 && string6.indexOf("2") > 0;
                if (bl5) {
                    --n3;
                }
                if (string6.equalsIgnoreCase("helix") || string6.equalsIgnoreCase("axis")) {
                    bl3 = true;
                    bl5 = true;
                    n3 = -1;
                }
                if ((string6 = ((n3 <= n5 ? "" : this.optParameterAsString(n3)) + "w").substring(0, 1)).equals("a") || string6.equals("r")) {
                    bl5 = true;
                }
                if (!Parser.isOneOf(string6, "w;x;y;z;r;a")) {
                    this.evalError("QUATERNION [w,x,y,z,a,r] [difference][2]", null);
                }
                string6 = "quaternion " + string6 + (bl5 ? " difference" : "") + (bl6 ? "2" : "") + (bl3 ? " draw" : "");
            }
        }
        this.st = tArray2;
        if (this.chk) {
            return "";
        }
        if (bl2 && (n = this.viewer.getJmolDataFrameIndex(n2, string4 = string4 + "plot " + string6)) > 0 && n4 != 135270421 && n4 != 4148) {
            this.viewer.setCurrentModelIndexClear(n, true);
            return "";
        }
        float[] fArray = null;
        float[] fArray2 = null;
        float[] fArray3 = null;
        P3 p33 = P3.new3(1.0f, 1.0f, 1.0f);
        if (n9 == 1716520973) {
            int n10;
            fArray = this.getBitsetPropertyFloat(bS, n6 | 0xE0, p3 == null ? Float.NaN : p3.x, p32 == null ? Float.NaN : p32.x);
            fArray2 = this.getBitsetPropertyFloat(bS, n7 | 0xE0, p3 == null ? Float.NaN : p3.y, p32 == null ? Float.NaN : p32.y);
            if (n8 != 0) {
                fArray3 = this.getBitsetPropertyFloat(bS, n8 | 0xE0, p3 == null ? Float.NaN : p3.z, p32 == null ? Float.NaN : p32.z);
            }
            if (p3 == null) {
                p3 = P3.new3(ScriptEvaluator.getMinMax(fArray, false, n6), ScriptEvaluator.getMinMax(fArray2, false, n7), ScriptEvaluator.getMinMax(fArray3, false, n8));
            }
            if (p32 == null) {
                p32 = P3.new3(ScriptEvaluator.getMinMax(fArray, true, n6), ScriptEvaluator.getMinMax(fArray2, true, n7), ScriptEvaluator.getMinMax(fArray3, true, n8));
            }
            Logger.info("plot min/max: " + p3 + " " + p32);
            object = P3.newP(p32);
            ((Tuple3f)object).add(p3);
            ((Tuple3f)object).scale(0.5f);
            p33.setT(p32);
            p33.sub(p3);
            p33.set(p33.x / 200.0f, p33.y / 200.0f, p33.z / 200.0f);
            if (T.tokAttr(n6, 1095761920)) {
                p33.x = 1.0f;
                ((P3)object).x = 0.0f;
            } else if ((double)p33.x > 0.1 && p33.x <= 10.0f) {
                p33.x = 1.0f;
            }
            if (T.tokAttr(n7, 1095761920)) {
                p33.y = 1.0f;
                ((P3)object).y = 0.0f;
            } else if ((double)p33.y > 0.1 && p33.y <= 10.0f) {
                p33.y = 1.0f;
            }
            if (T.tokAttr(n8, 1095761920)) {
                p33.z = 1.0f;
                ((P3)object).z = 0.0f;
            } else if ((double)p33.z > 0.1 && p33.z <= 10.0f) {
                p33.z = 1.0f;
            }
            if (n8 == 0) {
                p33.z = 0.0f;
                p32.z = 0.0f;
                p3.z = 0.0f;
                ((P3)object).z = 0.0f;
            }
            for (n10 = 0; n10 < fArray.length; ++n10) {
                fArray[n10] = (fArray[n10] - ((P3)object).x) / p33.x;
            }
            for (n10 = 0; n10 < fArray2.length; ++n10) {
                fArray2[n10] = (fArray2[n10] - ((P3)object).y) / p33.y;
            }
            if (n8 != 0) {
                for (n10 = 0; n10 < fArray3.length; ++n10) {
                    fArray3[n10] = (fArray3[n10] - ((P3)object).z) / p33.z;
                }
            }
            objectArray = new Object[]{bS, fArray, fArray2, fArray3, p3, p32, p33, object};
        }
        if (n4 == 135270421) {
            return this.viewer.streamFileData(string2, "PLOT", string6, n2, objectArray);
        }
        Object object2 = object = string6.equals("data") ? "1 0 H 0 0 0 # Jmol PDB-encoded data" : this.viewer.getPdbData(n2, string6, objectArray);
        if (n4 == 4148) {
            return object;
        }
        if (Logger.debugging) {
            Logger.info((String)object);
        }
        if (n4 == 135176) {
            this.runScript((String)object);
            return "";
        }
        String[] stringArray = this.viewer.getFileInfo();
        boolean bl9 = this.viewer.getBoolean(603979792);
        this.viewer.setAppendNew(true);
        boolean bl10 = object != null && this.viewer.loadInline((String)object, true) == null;
        this.viewer.setAppendNew(bl9);
        this.viewer.setFileInfo(stringArray);
        if (!bl10) {
            return "";
        }
        int n11 = this.viewer.getModelCount();
        this.viewer.setJmolDataFrame(string4, n2, n11 - 1);
        if (n9 != 1716520973) {
            string4 = string4 + ";\n" + string5;
        }
        ModelCollection.StateScript stateScript = this.viewer.addStateScript(string4, true, false);
        float f = 150.0f;
        switch (n9) {
            default: {
                string = "frame 0.0; frame last; reset;select visible;wireframe only;";
                f = 10.0f;
                break;
            }
            case 1716520973: {
                this.viewer.setFrameTitle(n11 - 1, string6 + " plot for model " + this.viewer.getModelNumberDotted(n2));
                float f2 = 3.0f;
                string = "frame 0.0; frame last; reset;select visible; spacefill " + f2 + "; wireframe 0;" + "draw plotAxisX" + n11 + " {100 -100 -100} {-100 -100 -100} \"" + T.nameOf(n6) + "\";" + "draw plotAxisY" + n11 + " {-100 100 -100} {-100 -100 -100} \"" + T.nameOf(n7) + "\";";
                if (n8 == 0) break;
                string = string + "draw plotAxisZ" + n11 + " {-100 -100 100} {-100 -100 -100} \"" + T.nameOf(n8) + "\";";
                break;
            }
            case 1052714: {
                this.viewer.setFrameTitle(n11 - 1, "ramachandran plot for model " + this.viewer.getModelNumberDotted(n2));
                string = "frame 0.0; frame last; reset;select visible; color structure; spacefill 3.0; wireframe 0;draw ramaAxisX" + n11 + " {100 0 0} {-100 0 0} \"phi\";" + "draw ramaAxisY" + n11 + " {0 100 0} {0 -100 0} \"psi\";";
                break;
            }
            case 0x8101011: 
            case 137363468: {
                this.viewer.setFrameTitle(n11 - 1, string6.replace('w', ' ') + string3 + " for model " + this.viewer.getModelNumberDotted(n2));
                String string7 = C.getHexCode(this.viewer.getColixBackgroundContrast());
                string = "frame 0.0; frame last; reset;select visible; wireframe 0; spacefill 3.0; isosurface quatSphere" + n11 + " color " + string7 + " sphere 100.0 mesh nofill frontonly translucent 0.8;" + "draw quatAxis" + n11 + "X {100 0 0} {-100 0 0} color red \"x\";" + "draw quatAxis" + n11 + "Y {0 100 0} {0 -100 0} color green \"y\";" + "draw quatAxis" + n11 + "Z {0 0 100} {0 0 -100} color blue \"z\";" + "color structure;" + "draw quatCenter" + n11 + "{0 0 0} scale 0.02;";
            }
        }
        this.runScript(string + string5);
        stateScript.setModelIndex(this.viewer.getCurrentModelIndex());
        this.viewer.setRotationRadius(f, true);
        this.sm.loadShape(30);
        this.showString("frame " + this.viewer.getModelNumberDotted(n11 - 1) + (string6.length() > 0 ? " created: " + string6 + (bl4 ? string3 : "") : ""));
        return "";
    }

    private static float getMinMax(float[] fArray, boolean bl, int n) {
        if (fArray == null) {
            return 0.0f;
        }
        switch (n) {
            case 1112539142: 
            case 1112539143: 
            case 1112539144: {
                return bl ? 180 : -180;
            }
            case 1112539140: 
            case 1112539150: {
                return bl ? 360 : 0;
            }
            case 1112539148: {
                return bl ? 1 : -1;
            }
        }
        float f = bl ? -1.0E10f : 1.0E10f;
        int n2 = fArray.length;
        while (--n2 >= 0) {
            float f2 = fArray[n2];
            if (Float.isNaN(f2) || bl != f2 > f) continue;
            f = f2;
        }
        return f;
    }

    private boolean pause() throws ScriptException {
        if (this.chk || this.isJS && !this.allowJSThreads) {
            return false;
        }
        String string = this.optParameterAsString(1);
        if (!this.viewer.getBooleanProperty("_useCommandThread")) {
            // empty if block
        }
        if (this.viewer.autoExit || !this.viewer.haveDisplay && !this.viewer.isWebGL) {
            return false;
        }
        if (this.scriptLevel == 0 && this.pc == this.aatoken.length - 1) {
            this.viewer.scriptStatus("nothing to pause: " + string);
            return false;
        }
        string = string.length() == 0 ? ": RESUME to continue." : ": " + this.viewer.formatText(string);
        this.pauseExecution(true);
        this.viewer.scriptStatusMsg("script execution paused" + string, "script paused for RESUME");
        return true;
    }

    private void print() throws ScriptException {
        if (this.slen == 1) {
            this.error(2);
        }
        this.showStringPrint(this.parameterExpressionString(1, 0), true);
    }

    private void prompt() throws ScriptException {
        String string = null;
        if (this.slen == 1) {
            if (!this.chk) {
                string = ScriptEvaluator.getContextTrace(this.getScriptContext(), null, true).toString();
            }
        } else {
            string = this.parameterExpressionString(1, 0);
        }
        if (!this.chk) {
            this.viewer.prompt(string, "OK", null, true);
        }
    }

    private void refresh() {
        if (this.chk) {
            return;
        }
        this.viewer.setTainted(true);
        this.viewer.requestRepaintAndWait();
    }

    private void reset() throws ScriptException {
        if (this.slen == 3 && this.tokAt(1) == 135368713) {
            if (!this.chk) {
                this.viewer.removeFunction(this.stringParameter(2));
            }
            return;
        }
        this.checkLength(-2);
        if (this.chk) {
            return;
        }
        if (this.slen == 1) {
            this.viewer.reset(false);
            return;
        }
        switch (this.tokAt(1)) {
            case 135270422: {
                this.viewer.cacheClear();
                return;
            }
            case 0x40000070: {
                this.viewer.resetError();
                return;
            }
            case 1087373323: {
                this.viewer.resetShapes(true);
                return;
            }
            case 135368713: {
                this.viewer.clearFunctions();
                return;
            }
            case 1641025539: {
                BS bS = new BS();
                this.runScript(this.viewer.getDefaultStructure(null, bS));
                this.viewer.resetBioshapes(bS);
                return;
            }
            case 1649412112: {
                this.viewer.setData("element_vdw", new Object[]{null, ""}, 0, 0, 0, 0, 0);
                return;
            }
            case 1076887572: {
                this.viewer.resetAromatic();
                return;
            }
            case 1611141175: {
                this.viewer.reset(true);
                return;
            }
        }
        String string = this.parameterAsString(1);
        if (string.charAt(0) == '_') {
            this.error(22);
        }
        this.viewer.unsetProperty(string);
    }

    private void restrict() throws ScriptException {
        boolean bl = this.tokAt(1) == 1678770178;
        this.select(bl ? 2 : 1);
        this.restrictSelected(bl, true);
    }

    private void restrictSelected(boolean bl, boolean bl2) {
        if (this.chk) {
            return;
        }
        BS bS = BSUtil.copy(this.viewer.getSelectionSet(true));
        if (bl2) {
            this.viewer.invertSelection();
            BS bS2 = this.viewer.getSelectionSubset();
            if (bS2 != null) {
                bS = BSUtil.copy(this.viewer.getSelectionSet(true));
                bS.and(bS2);
                this.viewer.select(bS, false, null, true);
                BSUtil.invertInPlace(bS, this.viewer.getAtomCount());
                bS.and(bS2);
            }
        }
        BSUtil.andNot(bS, this.viewer.getDeletedAtoms());
        boolean bl3 = this.viewer.getBoolean(0x24000024);
        if (!bl) {
            this.setBooleanProperty("bondModeOr", true);
        }
        this.setShapeSizeBs(1, 0, null);
        this.setShapeProperty(1, "type", 32768);
        this.setShapeSizeBs(1, 0, null);
        this.setShapeProperty(1, "type", 1023);
        BS bS3 = this.viewer.getSelectionSet(false);
        int n = 21;
        while (--n >= 0) {
            if (n == 6 || this.sm.getShape(n) == null) continue;
            this.setShapeSizeBs(n, 0, bS3);
        }
        if (this.sm.getShape(21) != null) {
            this.setShapeProperty(21, "delete", bS3);
        }
        this.sm.setLabel(null, bS3);
        if (!bl) {
            this.setBooleanProperty("bondModeOr", bl3);
        }
        this.viewer.select(bS, false, null, true);
    }

    private void rotate(boolean bl, boolean bl2) throws ScriptException {
        float f;
        Object[] objectArray;
        if (this.slen == 2) {
            switch (this.getToken((int)1).tok) {
                case 0x10000D: {
                    if (!this.chk) {
                        this.viewer.setSpinOn(true);
                    }
                    return;
                }
                case 0x10000C: {
                    if (!this.chk) {
                        this.viewer.setSpinOn(false);
                    }
                    return;
                }
            }
        }
        BS bS = null;
        float f2 = Float.MIN_VALUE;
        int n = 0;
        float f3 = Float.MAX_VALUE;
        boolean bl3 = false;
        boolean bl4 = false;
        JmolList<P3> jmolList = null;
        P3[] p3Array = new P3[2];
        V3 v3 = V3.new3(0.0f, 1.0f, 0.0f);
        V3 v32 = null;
        Matrix4f matrix4f = null;
        Matrix3f matrix3f = null;
        int n2 = 1;
        Quaternion quaternion = null;
        boolean bl5 = false;
        JmolList<P3> jmolList2 = null;
        BS bS2 = null;
        P3 p3 = null;
        P4 p4 = null;
        boolean bl6 = this.viewer.getBoolean(603979806);
        block23: for (int i = 1; i < this.slen; ++i) {
            int n3 = this.getToken((int)i).tok;
            switch (n3) {
                case 8: 
                case 10: 
                case 0x100001: 
                case 0x100007: 
                case 0x10000A: {
                    if (!(n3 != 10 && n3 != 0x100001 || v32 == null && quaternion == null && n != 2)) {
                        bS = this.atomExpressionAt(i);
                        jmolList2 = null;
                        bl2 = true;
                        break;
                    }
                    bl4 = true;
                    if (n == 2) {
                        n = 0;
                    }
                    objectArray = this.centerParameterForModel(i, this.viewer.getCurrentModelIndex());
                    if (!this.chk && n3 == 0x100007 && this.tokAt(i + 2) != 0x10100040) {
                        bl3 = true;
                        v3 = this.getDrawObjectAxis(this.objectNameParameter(++i), this.viewer.getCurrentModelIndex());
                    }
                    p3Array[n++] = objectArray;
                    break;
                }
                case 1611141175: {
                    bl = true;
                    continue block23;
                }
                case 0x400000A4: 
                case 1073742029: {
                    bl3 = true;
                    continue block23;
                }
                case 1114638350: {
                    bl2 = true;
                    break;
                }
                case 0x10100030: {
                    continue block23;
                }
                case 2: 
                case 3: {
                    if (bl) {
                        if (f2 == Float.MIN_VALUE) {
                            f2 = this.floatParameter(i);
                            continue block23;
                        }
                        if (f3 == Float.MAX_VALUE) {
                            f3 = f2;
                            f2 = this.floatParameter(i);
                            continue block23;
                        }
                    } else {
                        if (f3 == Float.MAX_VALUE) {
                            f3 = this.floatParameter(i);
                            continue block23;
                        }
                        if (f2 == Float.MIN_VALUE) {
                            f2 = this.floatParameter(i);
                            bl = true;
                            continue block23;
                        }
                    }
                    this.error(22);
                    break;
                }
                case 0x101000A0: {
                    n2 = -1;
                    continue block23;
                }
                case 1112541205: {
                    bl4 = true;
                    v3.set(n2, 0.0f, 0.0f);
                    continue block23;
                }
                case 1112541206: {
                    bl4 = true;
                    v3.set(0.0f, n2, 0.0f);
                    continue block23;
                }
                case 1112541207: {
                    bl4 = true;
                    v3.set(0.0f, 0.0f, bl6 && !bl3 ? -n2 : n2);
                    continue block23;
                }
                case 9: 
                case 0x8101011: {
                    if (n3 == 0x8101011) {
                        ++i;
                    }
                    bl4 = true;
                    quaternion = this.getQuaternionParameter(i);
                    v3.setT(quaternion.getNormal());
                    f3 = quaternion.getTheta();
                    break;
                }
                case 135266307: {
                    bl4 = true;
                    if (this.isPoint3f(++i)) {
                        v3.setT(this.centerParameter(i));
                        break;
                    }
                    P4 p42 = this.getPoint4f(i);
                    v3.set(p42.x, p42.y, p42.z);
                    f3 = p42.w;
                    quaternion = Quaternion.newVA(v3, f3);
                    break;
                }
                case 0x100004: {
                    bl4 = true;
                    int n4 = this.atomExpressionAt(++i).nextSetBit(0);
                    int n5 = this.atomExpressionAt(++this.iToken).nextSetBit(0);
                    if (n4 < 0 || n5 < 0) {
                        return;
                    }
                    bS = this.viewer.getBranchBitSet(n5, n4);
                    bl2 = true;
                    bl3 = true;
                    p3Array[0] = this.viewer.getAtomPoint3f(n4);
                    p3Array[1] = this.viewer.getAtomPoint3f(n5);
                    n = 2;
                    break;
                }
                case 4160: {
                    v32 = V3.newV(this.centerParameter(++i));
                    bl2 = true;
                    bl3 = true;
                    break;
                }
                case 137363468: {
                    bl5 = true;
                    continue block23;
                }
                case 1297090050: {
                    Object[] objectArray2;
                    int n6 = this.intParameter(++i);
                    if (this.chk) continue block23;
                    Map<String, Object> map = this.viewer.getSpaceGroupInfo(null);
                    Object[] objectArray3 = objectArray2 = map == null ? null : (Object[])map.get("operations");
                    if (n6 == 0 || objectArray2 == null || objectArray2.length < Math.abs(n6)) {
                        this.error(22);
                    }
                    objectArray2 = (Object[])objectArray2[Math.abs(n6) - 1];
                    v32 = (V3)objectArray2[5];
                    p3 = (P3)objectArray2[6];
                    p3Array[0] = (P3)objectArray2[7];
                    if (objectArray2[8] != null) {
                        v3 = (V3)objectArray2[8];
                    }
                    f3 = ((Integer)objectArray2[9]).intValue();
                    if (n6 < 0) {
                        f3 = -f3;
                        if (v32 != null) {
                            v32.scale(-1.0f);
                        }
                    }
                    if (f3 == 0.0f && p3Array[0] != null) {
                        v3.normalize();
                        p4 = new P4();
                        Measure.getPlaneThroughPoint(p3Array[0], v3, p4);
                    }
                    quaternion = Quaternion.newVA(v3, f3);
                    n = p3Array[0] == null ? 0 : 1;
                    bl3 = true;
                    bl4 = true;
                    bl2 = true;
                    continue block23;
                }
                case 11: 
                case 12: 
                case 135270405: {
                    bl4 = true;
                    if (n3 == 135270405) {
                        float f4;
                        if ((jmolList = this.viewer.getAtomPointVector(bS2 = this.atomExpressionAt(++i))) == null) {
                            this.errorAt(22, i);
                        }
                        i = this.iToken;
                        if ((jmolList2 = this.getPointVector(this.getToken(++i), i)) == null || jmolList.size() != jmolList2.size()) {
                            this.errorAt(22, i);
                        }
                        matrix4f = new Matrix4f();
                        p3Array[0] = new P3();
                        n = 1;
                        float f5 = f4 = this.chk ? 0.0f : Measure.getTransformMatrix4(jmolList, jmolList2, matrix4f, p3Array[0]);
                        if ((double)f4 > 0.001) {
                            jmolList2 = null;
                        }
                    } else if (n3 == 12) {
                        matrix4f = (Matrix4f)this.theToken.value;
                    }
                    matrix3f = new Matrix3f();
                    if (matrix4f != null) {
                        v32 = new V3();
                        matrix4f.get(v32);
                        matrix4f.getRotationScale(matrix3f);
                    } else {
                        matrix3f = (Matrix3f)this.theToken.value;
                    }
                    quaternion = this.chk ? new Quaternion() : Quaternion.newM(matrix3f);
                    v3.setT(quaternion.getNormal());
                    f3 = quaternion.getTheta();
                    bl3 = true;
                    break;
                }
                default: {
                    this.error(22);
                }
            }
            i = this.iToken;
        }
        if (this.chk) {
            return;
        }
        if (bl2 && bS == null) {
            bS = this.viewer.getSelectionSet(false);
        }
        if (bS2 != null) {
            bl2 = true;
            if (bS == null) {
                bS = bS2;
            }
        }
        float f6 = f2 == Float.MIN_VALUE ? 10.0f : (f3 == Float.MAX_VALUE ? f2 : (f = f2 < 0.0f == f3 > 0.0f ? -f3 / f2 : f2));
        if (quaternion != null) {
            if (n == 0 && v32 != null) {
                p3Array[0] = this.viewer.getAtomSetCenter(bS != null ? bS : (bl2 ? this.viewer.getSelectionSet(false) : this.viewer.getModelUndeletedAtomsBitSet(-1)));
            }
            if (bl5 && v32 != null) {
                p3Array[1] = P3.newP(p3Array[0]);
                p3Array[1].add(v32);
                objectArray = (Object[])Measure.computeHelicalAxis(null, 135266306, p3Array[0], p3Array[1], quaternion);
                p3Array[0] = (P3)objectArray[0];
                float f7 = ((P3)objectArray[3]).x;
                if (f7 != 0.0f) {
                    v32 = (V3)objectArray[1];
                    v3 = V3.newV(v32);
                    if (f7 < 0.0f) {
                        v3.scale(-1.0f);
                    }
                }
                matrix4f = null;
            }
            if (bl && matrix4f == null) {
                matrix4f = ScriptMathProcessor.getMatrix4f(quaternion.getMatrix(), v32);
            }
            if (p3Array[0] != null) {
                n = 1;
            }
        }
        if (p3 != null) {
            this.viewer.invertAtomCoordPt(p3, bS);
            if (v3 == null) {
                return;
            }
        }
        if (p4 != null) {
            this.viewer.invertAtomCoordPlane(p4, bS);
            if (v3 == null) {
                return;
            }
        }
        if (n < 2) {
            if (!bl3) {
                if (bl && bS == null && !this.useThreads()) {
                    return;
                }
                if (this.viewer.rotateAxisAngleAtCenter(this, p3Array[0], v3, f, f3, bl, bS) && this.isJS && bl && bS == null) {
                    throw new ScriptInterruption(this, "rotate", 1);
                }
                return;
            }
            if (n == 0) {
                p3Array[0] = new P3();
            }
            p3Array[1] = P3.newP(p3Array[0]);
            p3Array[1].add(v3);
            n = 2;
        }
        if (n == 0) {
            p3Array[0] = new P3();
        }
        if (n < 2 || p3Array[0].distance(p3Array[1]) == 0.0f) {
            p3Array[1] = P3.newP(p3Array[0]);
            p3Array[1].y = (float)((double)p3Array[1].y + 1.0);
        }
        if (f3 == Float.MAX_VALUE) {
            f3 = 0.0f;
        }
        if (f3 != 0.0f && v32 != null && !bl4) {
            v32.scale(f3 / v32.length());
        }
        if (bl && v32 != null && (f3 == 0.0f || f2 == 0.0f)) {
            f3 = 0.01f;
            f = f2 == Float.MIN_VALUE ? 0.01f : (f2 < 0.0f ? -f3 / f2 : f2 * 0.01f / v32.length());
            f2 = 0.01f;
        }
        if (bS != null && bl && jmolList2 == null && matrix4f != null) {
            jmolList = this.viewer.getAtomPointVector(bS);
            jmolList2 = Measure.transformPoints(jmolList, matrix4f, p3Array[0]);
        }
        if (bS != null && !bl && jmolList2 != null) {
            this.viewer.setAtomCoords(bS, 1146095626, jmolList2);
        } else {
            if (!this.useThreads()) {
                return;
            }
            if (this.viewer.rotateAboutPointsInternal(this, p3Array[0], p3Array[1], f, f3, bl, bS, v32, jmolList2) && this.isJS && bl) {
                throw new ScriptInterruption(this, "rotate", 1);
            }
        }
    }

    private Quaternion getQuaternionParameter(int n) throws ScriptException {
        if (this.tokAt(n) == 7) {
            JmolList<SV> jmolList = ((SV)this.getToken(n)).getList();
            P4 p4 = null;
            if (jmolList.size() == 0 || (p4 = SV.pt4Value((SV)jmolList.get(0))) == null) {
                this.error(22);
            }
            return Quaternion.newP4(p4);
        }
        return Quaternion.newP4(this.getPoint4f(n));
    }

    JmolList<P3> getPointVector(T t, int n) throws ScriptException {
        switch (t.tok) {
            case 10: {
                return this.viewer.getAtomPointVector((BS)t.value);
            }
            case 7: {
                JmolList<P3> jmolList = new JmolList<P3>();
                JmolList<SV> jmolList2 = ((SV)t).getList();
                for (int i = 0; i < jmolList2.size(); ++i) {
                    P3 p3 = SV.ptValue((SV)jmolList2.get(i));
                    if (p3 == null) {
                        return null;
                    }
                    jmolList.addLast(p3);
                }
                return jmolList;
            }
        }
        if (n > 0) {
            return this.viewer.getAtomPointVector(this.atomExpressionAt(n));
        }
        return null;
    }

    private P3 getObjectCenter(String string, int n, int n2) {
        Object[] objectArray = new Object[]{string, n, n2};
        return this.getShapePropertyData(22, "getCenter", objectArray) || this.getShapePropertyData(24, "getCenter", objectArray) || this.getShapePropertyData(28, "getCenter", objectArray) || this.getShapePropertyData(25, "getCenter", objectArray) || this.getShapePropertyData(27, "getCenter", objectArray) ? (P3)objectArray[2] : null;
    }

    private P3[] getObjectBoundingBox(String string) {
        Object[] objectArray = new Object[]{string, null, null};
        return this.getShapePropertyData(24, "getBoundingBox", objectArray) || this.getShapePropertyData(28, "getBoundingBox", objectArray) || this.getShapePropertyData(25, "getBoundingBox", objectArray) || this.getShapePropertyData(27, "getBoundingBox", objectArray) ? (P3[])objectArray[2] : null;
    }

    private V3 getDrawObjectAxis(String string, int n) {
        Object[] objectArray = new Object[]{string, n, null};
        return this.getShapePropertyData(22, "getSpinAxis", objectArray) ? (V3)objectArray[2] : null;
    }

    private void script(int n, String string) throws ScriptException {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 2;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        JmolList<SV> jmolList = null;
        if (n == 135287308) {
            this.checkLength(2);
            if (!this.chk) {
                this.viewer.jsEval(this.parameterAsString(1));
            }
            return;
        }
        if (string == null) {
            n = this.tokAt(1);
            if (n != 4) {
                this.error(16);
            }
            if ((string = this.parameterAsString(1)).equalsIgnoreCase("applet")) {
                String string6 = this.parameterAsString(2);
                string2 = this.parameterExpressionString(3, 0);
                this.checkLast(this.iToken);
                if (this.chk) {
                    return;
                }
                if (string6.length() == 0 || string6.equals("all")) {
                    string6 = "*";
                }
                if (!string6.equals(".")) {
                    this.viewer.jsEval(string6 + "\u0001" + string2);
                    if (!string6.equals("*")) {
                        return;
                    }
                }
            } else {
                n = this.tokAt(this.slen - 1);
                boolean bl4 = bl3 = n == 266298;
                if (string.equalsIgnoreCase("inline")) {
                    string2 = this.parameterExpressionString(2, bl3 ? this.slen - 1 : 0);
                    n6 = this.iToken + 1;
                }
                while (string.equalsIgnoreCase("localPath") || string.equalsIgnoreCase("remotePath") || string.equalsIgnoreCase("scriptPath")) {
                    if (string.equalsIgnoreCase("localPath")) {
                        string3 = this.parameterAsString(n6++);
                    } else if (string.equalsIgnoreCase("scriptPath")) {
                        string5 = this.parameterAsString(n6++);
                    } else {
                        string4 = this.parameterAsString(n6++);
                    }
                    string = this.parameterAsString(n6++);
                }
                n = this.tokAt(n6);
                if (n == 1073741878) {
                    bl2 = true;
                    n = this.tokAt(++n6);
                }
                if (n == 1073742050) {
                    bl = false;
                    n = this.tokAt(++n6);
                }
                if (n == 1073741998 || n == 0x44100004) {
                    int n7 = ++n6;
                    n4 = n2 = Math.max(this.intParameter(n7), 0);
                    if (this.checkToken(++n6) && (n4 = this.getToken((int)n6).tok == 0x101000A0 ? (this.checkToken(++n6) ? this.intParameter(n6++) : 0) : -this.intParameter(n6++)) <= 0) {
                        this.error(22);
                    }
                } else if (n == 0x40000042 || n == 0x40000044) {
                    int n8 = ++n6;
                    n3 = Math.max(this.intParameter(n8) - 1, 0);
                    n5 = n3 + 1;
                    if (this.checkToken(++n6) && (n5 = this.getToken((int)n6).tok == 0x101000A0 ? (this.checkToken(++n6) ? this.intParameter(n6++) : 0) : -this.intParameter(n6++)) <= 0) {
                        this.error(22);
                    }
                }
                if (this.tokAt(n6) == 0x10100010) {
                    jmolList = this.parameterExpressionList(n6, -1, false);
                    n6 = this.iToken + 1;
                }
                this.checkLength(bl3 ? n6 + 1 : n6);
            }
        }
        if (this.chk && !this.isCmdLine_c_or_C_Option) {
            return;
        }
        if (this.isCmdLine_c_or_C_Option) {
            bl2 = true;
        }
        boolean bl5 = this.chk;
        boolean bl6 = this.isCmdLine_c_or_C_Option;
        if (bl2) {
            this.isCmdLine_c_or_C_Option = true;
            this.chk = true;
        }
        this.pushContext(null);
        this.contextPath = this.contextPath + " >> " + string;
        if (string2 == null ? this.compileScriptFileInternal(string, string3, string4, string5) : this.compileScript(null, string2, false)) {
            this.pcEnd = n5;
            this.lineEnd = n4;
            while (n3 < this.lineNumbers.length && this.lineNumbers[n3] < n2) {
                ++n3;
            }
            this.pc = n3;
            boolean bl7 = this.isCmdLine_C_Option;
            this.isCmdLine_C_Option &= bl;
            this.executionStepping |= bl3;
            this.contextVariables = new Hashtable<String, SV>();
            this.contextVariables.put("_arguments", jmolList == null ? SV.getVariableAI(new int[0]) : SV.getVariableList(jmolList));
            if (bl2) {
                this.listCommands = true;
            }
            this.dispatchCommands(false, false);
            this.isCmdLine_C_Option = bl7;
            this.popContext(false, false);
        } else {
            Logger.error(GT._("script ERROR: ") + this.errorMessage);
            this.popContext(false, false);
            if (bl6) {
                this.setErrorMessage(null);
            } else {
                this.evalError(null, null);
            }
        }
        this.chk = bl5;
        this.isCmdLine_c_or_C_Option = bl6;
    }

    private void function() throws ScriptException {
        JmolList<SV> jmolList;
        if (this.chk && !this.isCmdLine_c_or_C_Option) {
            return;
        }
        String string = (String)this.getToken((int)0).value;
        if (!this.viewer.isFunction(string)) {
            this.error(10);
        }
        JmolList<SV> jmolList2 = jmolList = this.slen == 1 || this.slen == 3 && this.tokAt(1) == 0x10100010 && this.tokAt(2) == 0x10100011 ? null : this.parameterExpressionList(1, -1, false);
        if (this.chk) {
            return;
        }
        this.runFunctionRet(null, string, jmolList, null, false, true, true);
    }

    private void sync() throws ScriptException {
        this.checkLength(-3);
        String string = "";
        String string2 = "";
        switch (this.slen) {
            case 1: {
                string2 = "*";
                string = "ON";
                break;
            }
            case 2: {
                string2 = this.parameterAsString(1);
                if (string2.indexOf("jmolApplet") == 0 || Parser.isOneOf(string2, "*;.;^")) {
                    string = "ON";
                    if (!this.chk) {
                        this.viewer.syncScript(string, string2, 0);
                    }
                    string2 = ".";
                    break;
                }
                if (this.tokAt(1) == 2) {
                    if (!this.chk) {
                        this.viewer.syncScript(null, null, this.intParameter(1));
                    }
                    return;
                }
                string = string2;
                string2 = "*";
                break;
            }
            case 3: {
                if (this.chk) {
                    return;
                }
                string2 = this.parameterAsString(1);
                String string3 = string = this.tokAt(2) == 528443 ? "GET_GRAPHICS" : this.parameterAsString(2);
                if (this.tokAt(1) != 2) break;
                this.viewer.syncScript(string, null, this.intParameter(1));
                return;
            }
        }
        if (this.chk) {
            return;
        }
        this.viewer.syncScript(string, string2, 0);
    }

    private void history(int n) throws ScriptException {
        if (this.slen == 1) {
            this.showString(this.viewer.getSetHistory(Integer.MAX_VALUE));
            return;
        }
        if (n == 2) {
            int n2 = this.intParameter(this.checkLast(2));
            if (n2 < 0) {
                this.error(22);
            }
            if (!this.chk) {
                this.viewer.getSetHistory(n2 == 0 ? 0 : -2 - n2);
            }
            return;
        }
        switch (this.getToken((int)this.checkLast((int)1)).tok) {
            case 0x10000D: 
            case 1073741882: {
                if (!this.chk) {
                    this.viewer.getSetHistory(Integer.MIN_VALUE);
                }
                return;
            }
            case 0x10000C: {
                if (this.chk) break;
                this.viewer.getSetHistory(0);
                break;
            }
            default: {
                this.errorStr(24, "ON, OFF, CLEAR");
            }
        }
    }

    private void display(boolean bl) throws ScriptException {
        boolean bl2;
        BS bS = null;
        Boolean bl3 = null;
        int n = 1;
        int n2 = this.tokAt(1);
        switch (n2) {
            case 1073742119: 
            case 1276118017: {
                bl3 = n2 == 1276118017;
                n2 = this.tokAt(++n);
            }
        }
        boolean bl4 = bl2 = n2 == 1087373318;
        if (bl2) {
            n2 = this.tokAt(++n);
        }
        switch (n2) {
            case 0x100007: {
                this.setObjectProperty();
                return;
            }
            case 0: {
                break;
            }
            default: {
                bS = this.slen == 4 && this.tokAt(2) == 1678770178 ? new Bond.BondSet(BSUtil.newBitSet2(0, this.viewer.modelSet.bondCount)) : this.atomExpressionAt(n);
            }
        }
        if (this.chk) {
            return;
        }
        if (bS instanceof Bond.BondSet) {
            this.viewer.displayBonds((Bond.BondSet)bS, bl);
            return;
        }
        this.viewer.displayAtoms(bS, bl, bl2, bl3, this.tQuiet);
    }

    private void delete() throws ScriptException {
        if (this.slen == 1) {
            this.zap(true);
            return;
        }
        if (this.tokAt(1) == 0x100007) {
            this.setObjectProperty();
            return;
        }
        BS bS = this.atomExpression(this.st, 1, 0, true, false, true, false);
        if (this.chk) {
            return;
        }
        int n = this.viewer.deleteAtoms(bS, false);
        if (!this.tQuiet && this.scriptLevel <= this.scriptReportingLevel) {
            this.scriptStatusOrBuffer(GT._("{0} atoms deleted", n));
        }
    }

    private void minimize() throws ScriptException {
        BS bS = null;
        int n = Integer.MAX_VALUE;
        float f = 0.0f;
        boolean bl = false;
        boolean bl2 = false;
        BS bS2 = null;
        MinimizerInterface minimizerInterface = this.viewer.getMinimizer(false);
        block12: for (int i = 1; i < this.slen; ++i) {
            switch (this.getToken((int)i).tok) {
                case 0x40000004: {
                    bl = true;
                    continue block12;
                }
                case 1073741874: 
                case 1073742162: {
                    this.checkLength(2);
                    if (this.chk || minimizerInterface == null) {
                        return;
                    }
                    minimizerInterface.setProperty(this.parameterAsString(i), null);
                    return;
                }
                case 1073741882: {
                    this.checkLength(2);
                    if (this.chk || minimizerInterface == null) {
                        return;
                    }
                    minimizerInterface.setProperty("clear", null);
                    return;
                }
                case 0x40000046: {
                    if (i != 1) {
                        this.error(22);
                    }
                    int n2 = 0;
                    float f2 = 0.0f;
                    int[] nArray = new int[5];
                    if (this.tokAt(++i) == 1073741882) {
                        this.checkLength(3);
                    } else {
                        while (n2 < 4 && !this.isFloatParameter(i)) {
                            nArray[++n2] = this.atomExpressionAt(i).nextSetBit(0);
                            i = this.iToken + 1;
                        }
                        nArray[0] = n2;
                        if (n2 == 1) {
                            this.error(22);
                        }
                        f2 = this.floatParameter(this.checkLast(i));
                    }
                    if (!this.chk) {
                        this.viewer.getMinimizer(true).setProperty("constraint", new Object[]{nArray, new int[n2], Float.valueOf(f2)});
                    }
                    return;
                }
                case 1073741905: {
                    f = this.floatParameter(++i);
                    continue block12;
                }
                case 1073741935: {
                    n = 0;
                    continue block12;
                }
                case 1060869: {
                    if (i != 1) {
                        this.error(22);
                    }
                    if ((bS2 = this.atomExpressionAt(++i)).nextSetBit(0) < 0) {
                        bS2 = null;
                    }
                    i = this.iToken;
                    if (!this.chk) {
                        this.viewer.getMinimizer(true).setProperty("fixed", bS2);
                    }
                    if (i + 1 != this.slen) continue block12;
                    return;
                }
                case 135280132: {
                    bS = this.atomExpressionAt(++i);
                    i = this.iToken;
                    continue block12;
                }
                case 0x40000144: {
                    bl2 = true;
                    continue block12;
                }
                case 266298: {
                    n = this.intParameter(++i);
                    continue block12;
                }
                default: {
                    this.error(22);
                }
            }
        }
        if (!this.chk) {
            this.viewer.minimize(n, f, bS, bS2, 0.0f, bl, bl2, false);
        }
    }

    private void select(int n) throws ScriptException {
        Object object;
        if (this.slen == 1) {
            this.viewer.select(null, false, null, this.tQuiet || this.scriptLevel > this.scriptReportingLevel);
            return;
        }
        if (this.slen == 2 && this.tokAt(1) == 1073742072) {
            return;
        }
        this.viewer.setNoneSelected(this.slen == 4 && this.tokAt(2) == 0x10000B);
        if (this.tokAt(2) == 10 && this.getToken((int)2).value instanceof Bond.BondSet || this.getToken((int)2).tok == 1678770178 && this.getToken((int)3).tok == 10) {
            if (this.slen == this.iToken + 2) {
                if (!this.chk) {
                    this.viewer.selectBonds((BS)this.theToken.value);
                }
                return;
            }
            this.error(22);
        }
        if (this.getToken((int)2).tok == 1746538509) {
            if (this.slen == 5 && this.getToken((int)3).tok == 10) {
                if (!this.chk) {
                    this.setShapeProperty(6, "select", this.theToken.value);
                }
                return;
            }
            this.error(22);
        }
        Object object2 = null;
        Boolean bl = null;
        boolean bl2 = false;
        if (this.getToken((int)1).intValue == 0) {
            object = this.parameterExpressionToken((int)0).value;
            if (!(object instanceof BS)) {
                this.error(22);
            }
            this.checkLast(this.iToken);
            object2 = (BS)object;
        } else {
            int n2 = this.tokAt(n);
            switch (n2) {
                case 1073742119: 
                case 1276118017: {
                    bl = n2 == 1276118017;
                    n2 = this.tokAt(++n);
                }
            }
            boolean bl3 = bl2 = n2 == 1087373318;
            if (bl2) {
                n2 = this.tokAt(++n);
            }
            object2 = this.atomExpressionAt(n);
        }
        if (this.chk) {
            return;
        }
        if (this.isBondSet) {
            this.viewer.selectBonds((BS)object2);
        } else {
            if (((BS)object2).length() > this.viewer.getAtomCount()) {
                object = this.viewer.getModelUndeletedAtomsBitSet(-1);
                ((BS)object).and((BS)object2);
                object2 = object;
            }
            this.viewer.select((BS)object2, bl2, bl, this.tQuiet || this.scriptLevel > this.scriptReportingLevel);
        }
    }

    private void subset() throws ScriptException {
        BS bS = null;
        if (!this.chk) {
            this.viewer.setSelectionSubset(null);
        }
        if (!(this.slen == 1 || this.slen == 4 && this.getToken((int)2).value.equals("off"))) {
            bS = this.atomExpressionAt(1);
        }
        if (!this.chk) {
            this.viewer.setSelectionSubset(bS);
        }
    }

    private void invertSelected() throws ScriptException {
        P3 p3 = null;
        P4 p4 = null;
        BS bS = null;
        int n = Integer.MIN_VALUE;
        switch (this.tokAt(1)) {
            case 0: {
                if (this.chk) {
                    return;
                }
                bS = this.viewer.getSelectionSet(false);
                p3 = this.viewer.getAtomSetCenter(bS);
                this.viewer.invertAtomCoordPt(p3, bS);
                return;
            }
            case 528443: {
                n = this.atomExpressionAt(2).nextSetBit(0);
                bS = this.atomExpressionAt(this.iToken + 1);
                break;
            }
            case 0x8100010: {
                p3 = this.centerParameter(2);
                break;
            }
            case 135266319: {
                p4 = this.planeParameter(2);
                break;
            }
            case 135267841: {
                p4 = this.hklParameter(2);
            }
        }
        this.checkLengthErrorPt(this.iToken + 1, 1);
        if (p4 == null && p3 == null && n == Integer.MIN_VALUE) {
            this.error(22);
        }
        if (this.chk) {
            return;
        }
        if (n == -1) {
            return;
        }
        this.viewer.invertSelected(p3, p4, n, bS);
    }

    private void translate(boolean bl) throws ScriptException {
        char c;
        BS bS = null;
        int n = 1;
        int n2 = 0;
        if (this.tokAt(1) == 1114638350) {
            bl = true;
            n2 = 1;
            n = 2;
        }
        if (this.isPoint3f(n)) {
            P3 p3 = this.getPoint3f(n, true);
            bS = !bl && this.iToken + 1 < this.slen ? this.atomExpressionAt(++this.iToken) : null;
            this.checkLast(this.iToken);
            if (!this.chk) {
                this.viewer.setAtomCoordsRelative(p3, bS);
            }
            return;
        }
        char c2 = this.parameterAsString(n).toLowerCase().charAt(0);
        if ("xyz".indexOf(c2) < 0) {
            this.error(0);
        }
        float f = this.floatParameter(++n);
        switch (this.tokAt(++n)) {
            case 0: 
            case 10: 
            case 0x100001: {
                c = '\u0000';
                break;
            }
            default: {
                c = (this.optParameterAsString(n).toLowerCase() + '\u0000').charAt(0);
            }
        }
        if (f == 0.0f && c != '\u0000') {
            return;
        }
        this.iToken = n2 + (c == '\u0000' ? 2 : 3);
        bS = bl ? this.viewer.getSelectionSet(false) : (this.iToken + 1 < this.slen ? this.atomExpressionAt(++this.iToken) : null);
        this.checkLast(this.iToken);
        if (!this.chk) {
            this.viewer.translate(c2, f, c, bS);
        }
    }

    private void zap(boolean bl) throws ScriptException {
        boolean bl2;
        if (this.slen == 1 || !bl) {
            this.viewer.zap(true, bl && !this.isStateScript, true);
            this.refresh();
            return;
        }
        BS bS = this.atomExpressionAt(1);
        if (this.chk) {
            return;
        }
        int n = this.viewer.deleteAtoms(bS, true);
        boolean bl3 = bl2 = this.tQuiet || this.scriptLevel > this.scriptReportingLevel;
        if (!bl2) {
            this.scriptStatusOrBuffer(GT._("{0} atoms deleted", n));
        }
        this.viewer.select(null, false, null, bl2);
    }

    private void zoom(boolean bl) throws ScriptException {
        float f;
        if (!bl) {
            int n = this.slen > 1 ? this.getToken((int)1).tok : 0x10000D;
            switch (n) {
                case 1073741980: 
                case 0x400000FF: {
                    break;
                }
                case 0x10000C: 
                case 0x10000D: {
                    if (this.slen > 2) {
                        this.error(2);
                    }
                    if (!this.chk) {
                        this.setBooleanProperty("zoomEnabled", n == 0x10000D);
                    }
                    return;
                }
            }
        }
        P3 p3 = null;
        int n = 1;
        float f2 = bl ? (this.isFloatParameter(n) ? this.floatParameter(n++) : 2.0f) : (f = 0.0f);
        if (f < 0.0f) {
            --n;
            f = 0.0f;
        }
        int n2 = 0;
        BS bS = null;
        if (this.isCenterParameter(n)) {
            n2 = n;
            p3 = this.centerParameter(n);
            if (this.expressionResult instanceof BS) {
                bS = (BS)this.expressionResult;
            }
            n = this.iToken + 1;
        } else if (this.tokAt(n) == 2 && this.getToken((int)n).intValue == 0) {
            bS = this.viewer.getAtomBitSet("visible");
            p3 = this.viewer.getAtomSetCenter(bS);
        }
        boolean bl2 = false;
        float f3 = this.viewer.getZoomSetting();
        float f4 = this.getZoom(n2, n, bS, f3);
        n = this.iToken + 1;
        float f5 = Float.NaN;
        float f6 = Float.NaN;
        if (n != this.slen) {
            f5 = this.floatParameter(n++);
            f6 = this.floatParameter(n++);
        }
        if (n != this.slen) {
            this.error(22);
        }
        if (f4 < 0.0f) {
            f4 = -f4;
            if (bl) {
                if (this.slen == 1 || bl2) {
                    f4 *= 2.0f;
                } else if (p3 == null) {
                    f4 /= 2.0f;
                }
            }
        }
        float f7 = this.viewer.getMaxZoomPercent();
        if (f4 < 5.0f || f4 > f7) {
            this.numberOutOfRange(5.0f, f7);
        }
        if (!this.viewer.isWindowCentered()) {
            if (p3 != null) {
                BS bS2 = this.atomExpressionAt(n2);
                if (!this.chk) {
                    this.viewer.setCenterBitSet(bS2, false);
                }
            }
            p3 = this.viewer.getRotationCenter();
            if (Float.isNaN(f5)) {
                f5 = this.viewer.getTranslationXPercent();
            }
            if (Float.isNaN(f6)) {
                f6 = this.viewer.getTranslationYPercent();
            }
        }
        if (this.chk) {
            return;
        }
        if (Float.isNaN(f5)) {
            f5 = 0.0f;
        }
        if (Float.isNaN(f6)) {
            f6 = 0.0f;
        }
        if (bl2 && Math.abs(f3 - f4) < 1.0f) {
            f = 0.0f;
        }
        this.viewer.moveTo(this, f, p3, JC.center, Float.NaN, null, f4, f5, f6, Float.NaN, null, Float.NaN, Float.NaN, Float.NaN);
        if (this.isJS && f > 0.0f && this.viewer.global.waitForMoveTo) {
            throw new ScriptInterruption(this, "zoomTo", 1);
        }
    }

    private float getZoom(int n, int n2, BS bS, float f) throws ScriptException {
        float f2;
        float f3 = f2 = this.isFloatParameter(n2) ? this.floatParameter(n2++) : Float.NaN;
        if (f2 == 0.0f || f == 0.0f) {
            float f4 = Float.NaN;
            if (bS == null) {
                P3[] p3Array;
                if (this.tokAt(n) == 0x100007 && ((p3Array = this.getObjectBoundingBox(this.objectNameParameter(n + 1))) == null || (f4 = p3Array[0].distance(p3Array[1]) / 2.0f) == 0.0f)) {
                    this.error(22);
                }
            } else {
                f4 = this.viewer.calcRotationRadiusBs(bS);
            }
            if (Float.isNaN(f4)) {
                this.error(22);
            }
            f = this.viewer.getFloat(0x2200002C) / f4 * 100.0f;
            f2 = Float.NaN;
        }
        if (f2 < 0.0f) {
            f2 += f;
        } else if (Float.isNaN(f2)) {
            int n3 = this.tokAt(n2);
            switch (n3) {
                case 1073741980: 
                case 0x400000FF: {
                    f2 = f * (n3 == 0x400000FF ? 0.5f : 2.0f);
                    ++n2;
                    break;
                }
                case 0x101000A1: 
                case 0x101000B0: 
                case 0x101000B1: {
                    float f5 = this.floatParameter(++n2);
                    ++n2;
                    switch (n3) {
                        case 0x101000B0: {
                            f2 = f / f5;
                            break;
                        }
                        case 0x101000B1: {
                            f2 = f * f5;
                            break;
                        }
                        case 0x101000A1: {
                            f2 = f + f5;
                        }
                    }
                    break;
                }
                default: {
                    f2 = bS == null ? -f : f;
                }
            }
        }
        this.iToken = n2 - 1;
        return f2;
    }

    private void delay() throws ScriptException {
        int n = 0;
        switch (this.getToken((int)1).tok) {
            case 0x10000D: {
                n = 1;
                break;
            }
            case 2: {
                n = this.intParameter(1) * 1000;
                break;
            }
            case 3: {
                n = (int)(this.floatParameter(1) * 1000.0f);
                break;
            }
            default: {
                this.error(34);
            }
        }
        if (this.chk || this.viewer.isHeadless() || this.viewer.autoExit) {
            return;
        }
        this.refresh();
        this.doDelay(Math.abs(n));
    }

    private void slab(boolean bl) throws ScriptException {
        boolean bl2 = false;
        P4 p4 = null;
        if (this.isCenterParameter(1) || this.tokAt(1) == 9) {
            p4 = this.planeParameter(1);
        } else {
            block0 : switch (this.getToken((int)1).tok) {
                case 2: {
                    int n = this.intParameter(this.checkLast(1));
                    if (!this.chk) {
                        if (bl) {
                            this.viewer.depthToPercent(n);
                        } else {
                            this.viewer.slabToPercent(n);
                        }
                    }
                    return;
                }
                case 0x10000D: {
                    this.checkLength(2);
                    bl2 = true;
                }
                case 0x10000C: {
                    this.checkLength(2);
                    this.setBooleanProperty("slabEnabled", bl2);
                    return;
                }
                case 4141: {
                    this.checkLength(2);
                    if (this.chk) {
                        return;
                    }
                    this.viewer.slabReset();
                    this.setBooleanProperty("slabEnabled", true);
                    return;
                }
                case 1085443: {
                    this.checkLength(2);
                    if (this.chk) {
                        return;
                    }
                    this.viewer.setSlabDepthInternal(bl);
                    this.setBooleanProperty("slabEnabled", true);
                    return;
                }
                case 0x101000A0: {
                    String string = this.parameterAsString(2);
                    if (string.equalsIgnoreCase("hkl")) {
                        p4 = this.hklParameter(3);
                    } else if (string.equalsIgnoreCase("plane")) {
                        p4 = this.planeParameter(3);
                    }
                    if (p4 == null) {
                        this.error(22);
                    }
                    p4.scale(-1.0f);
                    break;
                }
                case 135266319: {
                    switch (this.getToken((int)2).tok) {
                        case 0x10000B: {
                            break block0;
                        }
                    }
                    p4 = this.planeParameter(2);
                    break;
                }
                case 135267841: {
                    p4 = this.getToken((int)2).tok == 0x10000B ? null : this.hklParameter(2);
                    break;
                }
                case 1073742118: {
                    return;
                }
                default: {
                    this.error(22);
                }
            }
        }
        if (!this.chk) {
            this.viewer.slabInternal(p4, bl);
        }
    }

    private void ellipsoid() throws ScriptException {
        int n = 0;
        int n2 = 1;
        switch (this.getToken((int)1).tok) {
            case 0x10000D: {
                n = 50;
                break;
            }
            case 0x10000C: {
                break;
            }
            case 2: {
                n = this.intParameter(1);
                break;
            }
            case 1085443: {
                this.checkLength(3);
                this.sm.loadShape(20);
                this.setShapeProperty(20, "select", this.intParameterRange(2, 1, 3));
                return;
            }
            case 0x101000B1: 
            case 0x40000000: 
            case 1074790550: {
                this.sm.loadShape(20);
                if (this.theTok == 1074790550) {
                    ++n2;
                }
                this.setShapeId(20, n2, false);
                n2 = this.iToken;
                block19: while (++n2 < this.slen) {
                    String string = this.parameterAsString(n2);
                    Object object = null;
                    switch (this.tokAt(n2)) {
                        case 0x100007: {
                            string = "points";
                            Object[] objectArray = new Object[3];
                            objectArray[0] = this.objectNameParameter(++n2);
                            if (this.chk) continue block19;
                            this.getShapePropertyData(24, "getVertices", objectArray);
                            object = objectArray;
                            break;
                        }
                        case 10: 
                        case 0x100001: {
                            string = "atoms";
                            object = this.atomExpressionAt(n2);
                            n2 = this.iToken;
                            break;
                        }
                        case 1611272194: {
                            V3[] v3Array = new V3[3];
                            for (int i = 0; i < 3; ++i) {
                                v3Array[i] = new V3();
                                v3Array[i].setT(this.centerParameter(++n2));
                                n2 = this.iToken;
                            }
                            object = v3Array;
                            break;
                        }
                        case 12289: {
                            object = this.centerParameter(++n2);
                            n2 = this.iToken;
                            break;
                        }
                        case 1766856708: {
                            float f = Float.NaN;
                            if (this.tokAt(n2) == 1766856708) {
                                ++n2;
                            }
                            if ((this.theTok = this.tokAt(n2)) == 1073742180) {
                                object = "translucent";
                                f = this.isFloatParameter(++n2) ? this.getTranslucentLevel(n2++) : this.viewer.getFloat(0x2200000A);
                            } else if (this.theTok == 1073742074) {
                                object = "opaque";
                                ++n2;
                            }
                            if (this.isColorParam(n2)) {
                                this.setShapeProperty(20, "color", this.getArgbParam(n2));
                                n2 = this.iToken;
                            }
                            if (object == null) continue block19;
                            if (!Float.isNaN(f)) {
                                this.setShapeProperty(20, "translucentLevel", Float.valueOf(f));
                            }
                            string = "translucency";
                            break;
                        }
                        case 12291: {
                            object = Boolean.TRUE;
                            this.checkLength(3);
                            break;
                        }
                        case 1095761933: {
                            object = this.intParameter(++n2);
                            break;
                        }
                        case 0x10000D: {
                            object = Boolean.TRUE;
                            break;
                        }
                        case 0x10000C: {
                            string = "on";
                            object = Boolean.FALSE;
                            break;
                        }
                        case 1073742138: {
                            object = Float.valueOf(this.floatParameter(++n2));
                        }
                    }
                    if (object == null) {
                        this.error(22);
                    }
                    this.setShapeProperty(20, string.toLowerCase(), object);
                }
                this.setShapeProperty(20, "thisID", null);
                return;
            }
            default: {
                this.error(22);
            }
        }
        this.setShapeSizeBs(20, n, null);
    }

    private String getShapeNameParameter(int n) throws ScriptException {
        String string = this.parameterAsString(n);
        boolean bl = string.equals("*");
        if (string.length() == 0) {
            this.error(22);
        }
        if (bl) {
            switch (this.tokAt(n + 1)) {
                case 0: 
                case 12291: 
                case 0x10000C: 
                case 0x10000D: 
                case 3145768: 
                case 3145770: 
                case 1766856708: {
                    break;
                }
                default: {
                    if (this.setMeshDisplayProperty(-1, 0, this.tokAt(n + 1))) break;
                    string = string + this.optParameterAsString(++n);
                }
            }
        }
        if (this.tokAt(n + 1) == 0x101000B1) {
            string = string + this.parameterAsString(++n);
        }
        this.iToken = n;
        return string;
    }

    private String setShapeId(int n, int n2, boolean bl) throws ScriptException {
        if (bl) {
            this.error(22);
        }
        String string = this.getShapeNameParameter(n2).toLowerCase();
        this.setShapeProperty(n, "thisID", string);
        return string;
    }

    private void setAtomShapeSize(int n, float f) throws ScriptException {
        RadiusData radiusData = null;
        int n2 = this.tokAt(1);
        boolean bl = false;
        switch (n2) {
            case 1073742072: {
                this.restrictSelected(false, false);
                break;
            }
            case 0x10000D: {
                break;
            }
            case 0x10000C: {
                f = 0.0f;
                break;
            }
            case 3: {
                bl = this.floatParameter(1) < 0.0f;
            }
            default: {
                radiusData = this.encodeRadiusParameter(1, bl, true);
                if (!Float.isNaN(radiusData.value)) break;
                this.error(22);
            }
        }
        if (radiusData == null) {
            radiusData = new RadiusData(null, f, RadiusData.EnumType.FACTOR, EnumVdw.AUTO);
        }
        if (bl) {
            this.restrictSelected(false, false);
        }
        this.setShapeSize(n, radiusData);
    }

    private RadiusData encodeRadiusParameter(int n, boolean bl, boolean bl2) throws ScriptException {
        float f = Float.NaN;
        RadiusData.EnumType enumType = RadiusData.EnumType.ABSOLUTE;
        EnumVdw enumVdw = null;
        int n2 = n == -1 ? 1649412112 : this.getToken((int)n).tok;
        switch (n2) {
            case 1112539137: 
            case 1112539138: 
            case 1112541195: 
            case 1112541199: 
            case 1114638346: 
            case 1649412112: {
                f = 1.0f;
                enumType = RadiusData.EnumType.FACTOR;
                enumVdw = n2 == 1649412112 ? null : EnumVdw.getVdwType2(T.nameOf(n2));
                n2 = this.tokAt(++n);
            }
        }
        switch (n2) {
            case 4141: {
                return this.viewer.getDefaultRadiusData();
            }
            case 1073741852: 
            case 0x40000020: 
            case 0x40000022: 
            case 1073741992: 
            case 1073742116: {
                f = 1.0f;
                enumType = RadiusData.EnumType.FACTOR;
                this.iToken = n - 1;
                break;
            }
            case 2: 
            case 3: 
            case 0x101000A1: {
                if (n2 == 0x101000A1) {
                    ++n;
                } else {
                    if (this.tokAt(n + 1) == 269484210) {
                        f = Math.round(this.floatParameter(n));
                        this.iToken = ++n;
                        enumType = RadiusData.EnumType.FACTOR;
                        if (f < 0.0f || f > 200.0f) {
                            this.integerOutOfRange(0, 200);
                        }
                        f /= 100.0f;
                        break;
                    }
                    if (n2 == 2) {
                        f = this.intParameter(n);
                        if (f > 749.0f || f < -200.0f) {
                            this.integerOutOfRange(-200, 749);
                        }
                        if (f > 0.0f) {
                            f /= 250.0f;
                            enumType = RadiusData.EnumType.ABSOLUTE;
                            break;
                        }
                        f /= -100.0f;
                        enumType = RadiusData.EnumType.FACTOR;
                        break;
                    }
                }
                f = this.floatParameterRange(n, bl || !bl2 ? -16 : 0, 16.0f);
                if (n2 == 0x101000A1 || !bl2) {
                    enumType = RadiusData.EnumType.OFFSET;
                } else {
                    enumType = RadiusData.EnumType.ABSOLUTE;
                    enumVdw = EnumVdw.NADA;
                }
                if (!bl) break;
                f = -f;
                break;
            }
            default: {
                if (f != 1.0f) break;
                --n;
            }
        }
        if (enumVdw == null && (enumVdw = EnumVdw.getVdwType(this.optParameterAsString(++this.iToken))) == null) {
            this.iToken = n;
            enumVdw = EnumVdw.AUTO;
        }
        return new RadiusData(null, f, enumType, enumVdw);
    }

    private void structure() throws ScriptException {
        EnumStructure enumStructure = EnumStructure.getProteinStructureType(this.parameterAsString(1));
        if (enumStructure == EnumStructure.NOT) {
            this.error(22);
        }
        BS bS = null;
        switch (this.tokAt(2)) {
            case 10: 
            case 0x100001: {
                bS = this.atomExpressionAt(2);
                this.checkLast(this.iToken);
                break;
            }
            default: {
                this.checkLength(2);
            }
        }
        if (this.chk) {
            return;
        }
        this.clearDefinedVariableAtomSets();
        this.viewer.setProteinType(enumStructure, bS);
    }

    private void wireframe() throws ScriptException {
        int n = Integer.MIN_VALUE;
        if (this.tokAt(1) == 4141) {
            this.checkLast(1);
        } else {
            n = this.getMadParameter();
        }
        if (this.chk) {
            return;
        }
        this.setShapeProperty(1, "type", 1023);
        this.setShapeSizeBs(1, n == Integer.MIN_VALUE ? 300 : n, null);
    }

    private void ssbond() throws ScriptException {
        int n = this.getMadParameter();
        this.setShapeProperty(1, "type", 256);
        this.setShapeSizeBs(1, n, null);
        this.setShapeProperty(1, "type", 1023);
    }

    private void struts() throws ScriptException {
        boolean bl = this.tokAt(1) == 1073742072 || this.tokAt(1) == 0x10000D || this.slen == 1;
        int n = this.getMadParameter();
        if (bl) {
            n = Math.round(this.viewer.getFloat(570425406) * 2000.0f);
        }
        this.setShapeProperty(1, "type", 32768);
        this.setShapeSizeBs(1, n, null);
        this.setShapeProperty(1, "type", 1023);
    }

    private void hbond() throws ScriptException {
        if (this.slen == 2 && this.getToken((int)1).tok == 4102) {
            if (this.chk) {
                return;
            }
            int n = this.viewer.autoHbond(null, null, false);
            this.scriptStatusOrBuffer(GT._("{0} hydrogen bonds", Math.abs(n)));
            return;
        }
        if (this.slen == 2 && this.getToken((int)1).tok == 12291) {
            if (this.chk) {
                return;
            }
            this.connect(0);
            return;
        }
        int n = this.getMadParameter();
        this.setShapeProperty(1, "type", 30720);
        this.setShapeSizeBs(1, n, null);
        this.setShapeProperty(1, "type", 1023);
    }

    private void configuration() throws ScriptException {
        BS bS;
        if (this.slen == 1) {
            bS = this.viewer.setConformation();
            this.viewer.addStateScriptRet("select", null, this.viewer.getSelectionSet(false), null, "configuration", true, false);
        } else {
            int n = this.intParameter(this.checkLast(1));
            if (this.chk) {
                return;
            }
            bS = this.viewer.getConformation(this.viewer.getCurrentModelIndex(), n - 1, true);
            this.viewer.addStateScript("configuration " + n + ";", true, false);
        }
        if (this.chk) {
            return;
        }
        this.setShapeProperty(1, "type", 30720);
        this.setShapeSizeBs(1, 0, bS);
        this.viewer.autoHbond(bS, bS, true);
        this.viewer.select(bS, false, null, this.tQuiet);
    }

    private void vector() throws ScriptException {
        RadiusData.EnumType enumType = RadiusData.EnumType.SCREEN;
        float f = 1.0f;
        this.checkLength(-3);
        this.iToken = this.slen;
        block0 : switch (this.iToken) {
            case 1: {
                break;
            }
            case 2: {
                switch (this.getToken((int)1).tok) {
                    case 0x10000D: {
                        break block0;
                    }
                    case 0x10000C: {
                        f = 0.0f;
                        break block0;
                    }
                    case 2: {
                        f = this.intParameterRange(1, 0, 19);
                        break block0;
                    }
                    case 3: {
                        enumType = RadiusData.EnumType.ABSOLUTE;
                        f = this.floatParameterRange(1, 0.0f, 3.0f);
                        break block0;
                    }
                }
                this.error(6);
                break;
            }
            case 3: {
                if (this.tokAt(1) != 1073742138) break;
                this.setFloatProperty("vectorScale", this.floatParameterRange(2, -100.0f, 100.0f));
                return;
            }
        }
        this.setShapeSize(18, new RadiusData(null, f, enumType, null));
    }

    private void dipole() throws ScriptException {
        String string = null;
        Object object = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.sm.loadShape(17);
        if (this.tokAt(1) == 1073742001 && this.listIsosurface(17)) {
            return;
        }
        this.setShapeProperty(17, "init", null);
        if (this.slen == 1) {
            this.setShapeProperty(17, "thisID", null);
            return;
        }
        for (int i = 1; i < this.slen; ++i) {
            string = null;
            object = null;
            switch (this.getToken((int)i).tok) {
                case 0x10000D: {
                    string = "on";
                    break;
                }
                case 0x10000C: {
                    string = "off";
                    break;
                }
                case 12291: {
                    string = "delete";
                    break;
                }
                case 2: 
                case 3: {
                    string = "value";
                    object = Float.valueOf(this.floatParameter(i));
                    break;
                }
                case 10: {
                    string = "atomBitset";
                }
                case 0x100001: {
                    if (string == null) {
                        string = bl || bl2 ? "endSet" : "startSet";
                    }
                    object = this.atomExpressionAt(i);
                    i = this.iToken;
                    bl = true;
                    break;
                }
                case 8: 
                case 0x10000A: {
                    P3 p3 = this.getPoint3f(i, true);
                    i = this.iToken;
                    string = bl || bl2 ? "endCoord" : "startCoord";
                    object = p3;
                    bl2 = true;
                    break;
                }
                case 1678770178: {
                    string = "bonds";
                    break;
                }
                case 4102: {
                    string = "calculate";
                    break;
                }
                case 1074790550: {
                    this.setShapeId(17, ++i, bl3);
                    i = this.iToken;
                    break;
                }
                case 135267329: {
                    string = "cross";
                    object = Boolean.TRUE;
                    break;
                }
                case 1073742040: {
                    string = "cross";
                    object = Boolean.FALSE;
                    break;
                }
                case 1073742066: {
                    float f = this.floatParameter(++i);
                    if (this.theTok == 2) {
                        string = "offsetPercent";
                        object = (int)f;
                        break;
                    }
                    string = "offset";
                    object = Float.valueOf(f);
                    break;
                }
                case 0x400000F4: {
                    string = "offsetSide";
                    object = Float.valueOf(this.floatParameter(++i));
                    break;
                }
                case 1073742188: {
                    string = "value";
                    object = Float.valueOf(this.floatParameter(++i));
                    break;
                }
                case 1073742196: {
                    string = "width";
                    object = Float.valueOf(this.floatParameter(++i));
                    break;
                }
                default: {
                    if (this.theTok == 0x101000B1 || T.tokAttr(this.theTok, 0x40000000)) {
                        this.setShapeId(17, i, bl3);
                        i = this.iToken;
                        break;
                    }
                    this.error(22);
                }
            }
            boolean bl4 = bl3 = this.theTok != 12291 && this.theTok != 4102;
            if (string == null) continue;
            this.setShapeProperty(17, string, object);
        }
        if (bl2 || bl) {
            this.setShapeProperty(17, "set", null);
        }
    }

    private void animationMode() throws ScriptException {
        float f = 1.0f;
        float f2 = 1.0f;
        if (this.slen > 5) {
            this.error(2);
        }
        EnumAnimationMode enumAnimationMode = null;
        switch (this.getToken((int)2).tok) {
            case 1073742070: {
                enumAnimationMode = EnumAnimationMode.ONCE;
                f2 = 0.0f;
                f = 0.0f;
                break;
            }
            case 528410: {
                enumAnimationMode = EnumAnimationMode.LOOP;
                break;
            }
            case 1073742082: {
                enumAnimationMode = EnumAnimationMode.PALINDROME;
                break;
            }
            default: {
                this.error(22);
            }
        }
        if (this.slen >= 4) {
            f = f2 = this.floatParameter(3);
            if (this.slen == 5) {
                f2 = this.floatParameter(4);
            }
        }
        if (!this.chk) {
            this.viewer.setAnimationReplayMode(enumAnimationMode, f, f2);
        }
    }

    private void vibration() throws ScriptException {
        this.checkLength(-3);
        float f = 0.0f;
        switch (this.getToken((int)1).tok) {
            case 0x10000D: {
                this.checkLength(2);
                f = this.viewer.getFloat(0x22000044);
                break;
            }
            case 0x10000C: {
                this.checkLength(2);
                f = 0.0f;
                break;
            }
            case 2: 
            case 3: {
                this.checkLength(2);
                f = this.floatParameter(1);
                break;
            }
            case 1073742138: {
                this.setFloatProperty("vibrationScale", this.floatParameterRange(2, -10.0f, 10.0f));
                return;
            }
            case 1073742090: {
                this.setFloatProperty("vibrationPeriod", this.floatParameter(2));
                return;
            }
            case 0x40000000: {
                this.error(22);
                break;
            }
            default: {
                f = -1.0f;
            }
        }
        if (f < 0.0f) {
            this.error(22);
        }
        if (this.chk) {
            return;
        }
        if (f == 0.0f) {
            this.viewer.setVibrationOff();
            return;
        }
        this.viewer.setVibrationPeriod(-f);
    }

    private void animationDirection() throws ScriptException {
        int n = 2;
        int n2 = 0;
        switch (this.tokAt(n)) {
            case 0x101000A0: {
                n2 = -this.intParameter(++n);
                break;
            }
            case 0x101000A1: {
                n2 = this.intParameter(++n);
                break;
            }
            case 2: {
                n2 = this.intParameter(n);
                if (n2 <= 0) break;
                n2 = 0;
                break;
            }
            default: {
                this.error(22);
            }
        }
        this.checkLength(++n);
        if (n2 != 1 && n2 != -1) {
            this.errorStr2(35, "-1", "1");
        }
        if (!this.chk) {
            this.viewer.setAnimationDirection(n2);
        }
    }

    private void calculate() throws ScriptException {
        boolean bl = false;
        boolean bl2 = false;
        BS bS = null;
        int n = Integer.MIN_VALUE;
        this.iToken = this.slen;
        if (this.iToken >= 2) {
            this.clearDefinedVariableAtomSets();
            switch (this.getToken((int)1).tok) {
                case 0x40000000: {
                    this.checkLength(2);
                    break;
                }
                case 1076887572: {
                    this.checkLength(2);
                    if (!this.chk) {
                        this.viewer.assignAromaticBonds();
                    }
                    return;
                }
                case 1612189718: {
                    if (this.slen == 2) {
                        if (!this.chk) {
                            n = this.viewer.autoHbond(null, null, false);
                            break;
                        }
                        return;
                    }
                    BS bS2 = null;
                    bl2 = this.tokAt(++this.iToken) == 1641025539;
                    bS2 = bl2 ? this.viewer.getSelectionSet(false) : this.atomExpressionAt(this.iToken);
                    if (!bl2 && !(bl2 = this.tokAt(++this.iToken) == 1641025539)) {
                        bS = this.atomExpressionAt(this.iToken);
                    }
                    if (!this.chk) {
                        n = this.viewer.autoHbond(bS2, bS, false);
                        break;
                    }
                    return;
                }
                case 1613758476: {
                    BS bS3 = this.slen == 2 ? null : this.atomExpressionAt(2);
                    this.checkLast(this.iToken);
                    if (!this.chk) {
                        this.viewer.addHydrogens(bS3, false, false);
                    }
                    return;
                }
                case 1112541196: {
                    this.iToken = 1;
                    BS bS4 = this.slen == 2 ? null : this.atomExpressionAt(2);
                    this.checkLast(this.iToken);
                    if (!this.chk) {
                        this.viewer.calculatePartialCharges(bS4);
                    }
                    return;
                }
                case 1073742102: {
                    this.pointGroup();
                    return;
                }
                case 1112539148: {
                    this.checkLength(2);
                    if (!this.chk) {
                        this.viewer.calculateStraightness();
                        this.viewer.addStateScript("set quaternionFrame '" + this.viewer.getQuaternionFrame() + "'; calculate straightness", false, true);
                    }
                    return;
                }
                case 1641025539: {
                    BS bS5 = this.slen < 4 ? null : this.atomExpressionAt(2);
                    switch (this.tokAt(++this.iToken)) {
                        case 1052714: {
                            break;
                        }
                        case 1073741915: {
                            bl2 = true;
                            break;
                        }
                        case 0: {
                            bl2 = this.viewer.getBoolean(603979825);
                            break;
                        }
                        default: {
                            this.error(22);
                        }
                    }
                    if (!this.chk) {
                        this.showString(this.viewer.calculateStructures(bS5, bl2, true));
                    }
                    return;
                }
                case 0x1A101A: {
                    BS bS6 = this.iToken + 1 < this.slen ? this.atomExpressionAt(++this.iToken) : null;
                    bS = this.iToken + 1 < this.slen ? this.atomExpressionAt(++this.iToken) : null;
                    this.checkLength(++this.iToken);
                    if (!this.chk) {
                        n = this.viewer.calculateStruts(bS6, bS);
                        if (n > 0) {
                            this.setShapeProperty(1, "type", 32768);
                            this.setShapePropertyBs(1, "color", 0xFFFFFF, null);
                            this.setShapeTranslucency(1, "", "translucent", 0.5f, null);
                            this.setShapeProperty(1, "type", 1023);
                        }
                        this.showString(GT._("{0} struts added", n));
                    }
                    return;
                }
                case 3145756: {
                    bl = true;
                }
                case 1112539149: {
                    boolean bl3 = false;
                    switch (this.tokAt(2)) {
                        case 135266324: {
                            ++this.iToken;
                            break;
                        }
                        case 0: {
                            bl3 = !bl;
                            break;
                        }
                        case 0x40000080: {
                            bl3 = true;
                            ++this.iToken;
                            break;
                        }
                        default: {
                            bl3 = true;
                        }
                    }
                    BS bS7 = this.iToken + 1 < this.slen ? this.atomExpressionAt(++this.iToken) : this.viewer.getSelectionSet(false);
                    this.checkLength(++this.iToken);
                    if (!this.chk) {
                        this.viewer.calculateSurface(bS7, bl3 ? Float.MAX_VALUE : -1.0f);
                    }
                    return;
                }
            }
            if (n != Integer.MIN_VALUE) {
                this.scriptStatusOrBuffer(GT._("{0} hydrogen bonds", Math.abs(n)));
                return;
            }
        }
        this.errorStr2(53, "CALCULATE", "aromatic? hbonds? hydrogen? partialCharge? pointgroup? straightness? structure? struts? surfaceDistance FROM? surfaceDistance WITHIN?");
    }

    private void pointGroup() throws ScriptException {
        switch (this.tokAt(0)) {
            case 4102: {
                if (!this.chk) {
                    this.showString(this.viewer.calculatePointGroup());
                }
                return;
            }
            case 4148: {
                if (!this.chk) {
                    this.showString(this.viewer.getPointGroupAsString(false, null, 0, 0.0f));
                }
                return;
            }
        }
        int n = 2;
        String string = this.tokAt(n) == 1073742138 ? "" : this.optParameterAsString(n);
        float f = 1.0f;
        int n2 = 0;
        if (string.length() > 0 && this.isFloatParameter(++n)) {
            n2 = this.intParameter(n++);
        }
        if (this.tokAt(n) == 1073742138) {
            f = this.floatParameter(++n);
        }
        if (!this.chk) {
            this.runScript(this.viewer.getPointGroupAsString(true, string, n2, f));
        }
    }

    private void dots(int n) throws ScriptException {
        RadiusData radiusData;
        if (!this.chk) {
            this.sm.loadShape(n);
        }
        this.setShapeProperty(n, "init", null);
        float f = Float.NaN;
        RadiusData.EnumType enumType = RadiusData.EnumType.ABSOLUTE;
        int n2 = 1;
        block7: while (true) {
            switch (this.getToken((int)n2).tok) {
                case 1073742072: {
                    this.restrictSelected(false, false);
                    f = 1.0f;
                    enumType = RadiusData.EnumType.FACTOR;
                    break block7;
                }
                case 0x10000D: {
                    f = 1.0f;
                    enumType = RadiusData.EnumType.FACTOR;
                    break block7;
                }
                case 0x10000C: {
                    f = 0.0f;
                    break block7;
                }
                case 1073741976: {
                    this.setShapeProperty(n, "ignore", this.atomExpressionAt(n2 + 1));
                    n2 = this.iToken + 1;
                    continue block7;
                }
                case 2: {
                    int n3 = this.intParameter(n2);
                    if (this.tokAt(n2 + 1) != 1666189314) break block7;
                    ++n2;
                    this.setShapeProperty(n, "atom", n3);
                    this.setShapeProperty(n, "radius", Float.valueOf(this.floatParameter(++n2)));
                    if (this.tokAt(++n2) == 1766856708) {
                        this.setShapeProperty(n, "colorRGB", this.getArgbParam(++n2));
                        ++n2;
                    }
                    if (this.getToken((int)n2).tok != 10) {
                        this.error(22);
                    }
                    this.setShapeProperty(n, "dots", this.st[n2].value);
                    return;
                }
            }
            break;
        }
        RadiusData radiusData2 = radiusData = Float.isNaN(f) ? this.encodeRadiusParameter(n2, false, true) : new RadiusData(null, f, enumType, EnumVdw.AUTO);
        if (Float.isNaN(radiusData.value)) {
            this.error(22);
        }
        this.setShapeSize(n, radiusData);
    }

    private void proteinShape(int n) throws ScriptException {
        int n2 = 0;
        switch (this.getToken((int)1).tok) {
            case 1073742072: {
                if (this.chk) {
                    return;
                }
                this.restrictSelected(false, false);
                n2 = -1;
                break;
            }
            case 0x10000D: {
                n2 = -1;
                break;
            }
            case 0x10000C: {
                break;
            }
            case 1641025539: {
                n2 = -2;
                break;
            }
            case 1073741922: 
            case 1112541199: {
                n2 = -4;
                break;
            }
            case 2: {
                n2 = this.intParameterRange(1, 0, 1000) * 8;
                break;
            }
            case 3: {
                n2 = Math.round(this.floatParameterRange(1, -4.0f, 4.0f) * 2000.0f);
                if (n2 >= 0) break;
                this.restrictSelected(false, false);
                n2 = -n2;
                break;
            }
            case 10: {
                if (!this.chk) {
                    this.sm.loadShape(n);
                }
                this.setShapeProperty(n, "bitset", this.theToken.value);
                return;
            }
            default: {
                this.error(6);
            }
        }
        this.setShapeSizeBs(n, n2, null);
    }

    private void animation() throws ScriptException {
        boolean bl = false;
        switch (this.getToken((int)1).tok) {
            case 0x10000D: {
                bl = true;
            }
            case 0x10000C: {
                if (this.chk) break;
                this.viewer.setAnimationOn(bl);
                break;
            }
            case 1073742031: {
                int n = (int)this.floatParameter(2);
                if (this.chk) break;
                this.viewer.setAnimMorphCount(Math.abs(n));
                break;
            }
            case 1610625028: {
                this.iToken = 2;
                BS bS = this.tokAt(2) == 0x100003 ? null : this.atomExpressionAt(2);
                this.checkLength(this.iToken + 1);
                if (!this.chk) {
                    this.viewer.setAnimDisplay(bS);
                }
                return;
            }
            case 4115: {
                this.frame(2);
                break;
            }
            case 1073742024: {
                this.animationMode();
                break;
            }
            case 1073741918: {
                this.animationDirection();
                break;
            }
            case 1074790526: {
                this.setIntProperty("animationFps", this.intParameter(this.checkLast(2)));
                break;
            }
            default: {
                this.frameControl(1);
            }
        }
    }

    private void assign() throws ScriptException {
        P3 p3;
        int n = this.tokAt(1);
        int n2 = this.atomExpressionAt(2).nextSetBit(0);
        int n3 = -1;
        String string = null;
        if (n2 < 0) {
            return;
        }
        if (n == 4106) {
            n3 = this.atomExpressionAt(++this.iToken).nextSetBit(0);
        } else {
            string = this.parameterAsString(++this.iToken);
        }
        P3 p32 = p3 = ++this.iToken < this.slen ? this.centerParameter(this.iToken) : null;
        if (this.chk) {
            return;
        }
        switch (n) {
            case 0x44100001: {
                this.clearDefinedVariableAtomSets();
                this.viewer.assignAtom(n2, p3, string);
                break;
            }
            case 1678770178: {
                this.viewer.assignBond(n2, (string + "p").charAt(0));
                break;
            }
            case 4106: {
                this.viewer.assignConnect(n2, n3);
            }
        }
    }

    private void file() throws ScriptException {
        int n = this.intParameter(this.checkLast(1));
        if (this.chk) {
            return;
        }
        int n2 = this.viewer.getModelNumberIndex(n * 1000000 + 1, false, false);
        int n3 = -1;
        if (n2 >= 0) {
            n3 = this.viewer.getModelNumberIndex((n + 1) * 1000000 + 1, false, false);
            if (n3 < 0) {
                n3 = this.viewer.getModelCount();
            }
            --n3;
        }
        this.viewer.setAnimationOn(false);
        this.viewer.setAnimationDirection(1);
        this.viewer.setAnimationRange(n2, n3);
        this.viewer.setCurrentModelIndex(-1);
    }

    private void fixed() throws ScriptException {
        BS bS;
        BS bS2 = bS = this.slen == 1 ? null : this.atomExpressionAt(1);
        if (this.chk) {
            return;
        }
        this.viewer.setMotionFixedAtoms(bS);
    }

    private void frame(int n) throws ScriptException {
        int n2;
        int n3;
        boolean bl = true;
        if (this.slen == 1 && n == 1) {
            int n4;
            int n5 = this.viewer.getCurrentModelIndex();
            if (!this.chk && n5 >= 0 && (n4 = this.viewer.getJmolDataSourceFrame(n5)) >= 0) {
                this.viewer.setCurrentModelIndex(n4 == n5 ? Integer.MIN_VALUE : n4);
            }
            return;
        }
        switch (this.tokAt(1)) {
            case 10: 
            case 0x100001: {
                int n6 = this.atomExpressionAt(1).nextSetBit(0);
                this.checkLength(this.iToken + 1);
                if (this.chk || n6 < 0) {
                    return;
                }
                BS bS = new BS();
                bS.set(n6);
                this.viewer.setCurrentModelIndex(this.viewer.getModelBitSet(bS, false).nextSetBit(0));
                return;
            }
            case 0x40000050: {
                this.iToken = 1;
                int n7 = this.tokAt(2) == 2 ? this.intParameter(++this.iToken) : 1;
                this.checkLength(this.iToken + 1);
                if (!this.chk && n7 > 0) {
                    this.viewer.createModels(n7);
                }
                return;
            }
            case 1074790550: {
                this.checkLength(3);
                String string = this.stringParameter(2);
                if (!this.chk) {
                    this.viewer.setCurrentModelID(string);
                }
                return;
            }
            case 528397: {
                long l = 0L;
                this.checkLength(3);
                switch (this.getToken((int)2).tok) {
                    case 2: 
                    case 3: {
                        l = (long)(this.floatParameter(2) * 1000.0f);
                        break;
                    }
                    default: {
                        this.error(20);
                    }
                }
                if (!this.chk) {
                    this.viewer.setFrameDelayMs(l);
                }
                return;
            }
            case 1073742166: {
                if (this.checkLength23() > 0 && !this.chk) {
                    this.viewer.setFrameTitleObj(this.slen == 2 ? "@{_modelName}" : (this.tokAt(2) == 7 ? SV.listValue(this.st[2]) : this.parameterAsString(2)));
                }
                return;
            }
            case 0x40000008: {
                BS bS;
                BS bS2 = bS = this.slen == 2 || this.tokAt(2) == 0x10000B ? null : this.atomExpressionAt(2);
                if (!this.chk) {
                    this.viewer.setFrameOffsets(bS);
                }
                return;
            }
        }
        if (this.getToken((int)n).tok == 0x101000A0) {
            if (this.getToken((int)this.checkLast((int)(++n))).tok != 2 || this.intParameter(n) != 1) {
                this.error(22);
            }
            if (!this.chk) {
                this.viewer.setAnimation(1073742108);
            }
            return;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int[] nArray = new int[]{-1, -1};
        int n8 = 0;
        float f = 0.0f;
        boolean bl6 = this.viewer.haveFileSet();
        block20: for (n3 = n; n3 < this.slen; ++n3) {
            switch (this.getToken((int)n3).tok) {
                case 0x100003: 
                case 0x101000B1: {
                    this.checkLength(n + (bl3 ? 2 : 1));
                    bl4 = true;
                    continue block20;
                }
                case 0x101000A0: {
                    if (n8 != 1) {
                        this.error(22);
                    }
                    bl5 = true;
                    continue block20;
                }
                case 0x10000B: {
                    this.checkLength(n + 1);
                    continue block20;
                }
                case 3: {
                    float f2;
                    bl = false;
                    f = this.floatParameter(n3);
                    if (f2 < 0.0f) {
                        this.checkLength(n3 + 1);
                        if (!this.chk) {
                            this.viewer.morph(-f);
                        }
                        return;
                    }
                }
                case 2: 
                case 4: {
                    if (n8 == 2) {
                        this.error(22);
                    }
                    int n9 = n2 = this.theTok == 4 ? ScriptEvaluator.getFloatEncodedInt((String)this.theToken.value) : this.theToken.intValue;
                    if (n2 < 0 && n8 == 1) {
                        bl5 = true;
                        n2 = -n2;
                        if (bl6 && n2 < 1000000) {
                            n2 *= 1000000;
                        }
                    }
                    if (this.theTok == 3 && bl6 && f == (float)((int)f)) {
                        n2 = (int)f * 1000000;
                    }
                    if (n2 == Integer.MAX_VALUE) {
                        if (n3 == 1) {
                            int n10;
                            String string = this.theToken.value.toString();
                            int n11 = n10 = this.chk ? -1 : this.viewer.getModelIndexFromId(string);
                            if (n10 >= 0) {
                                this.checkLength(2);
                                this.viewer.setCurrentModelIndex(n10);
                                return;
                            }
                        }
                        n2 = 0;
                    }
                    if (n2 == -1) {
                        this.checkLength(n + 1);
                        if (!this.chk) {
                            this.viewer.setAnimation(1073742108);
                        }
                        return;
                    }
                    if (n2 >= 1000 && n2 < 1000000 && bl6) {
                        n2 = n2 / 1000 * 1000000 + n2 % 1000;
                    }
                    if (!bl && n2 == 0 && n8 == 0) {
                        bl4 = true;
                    }
                    if (n2 >= 1000000) {
                        bl = false;
                    }
                    nArray[n8++] = n2;
                    continue block20;
                }
                case 0x40000110: {
                    bl2 = true;
                    continue block20;
                }
                case 1073742114: {
                    bl3 = true;
                    continue block20;
                }
                default: {
                    this.frameControl(n);
                    return;
                }
            }
        }
        if (bl3 && n8 == 0) {
            bl4 = true;
        }
        if (this.chk) {
            return;
        }
        if (bl4) {
            this.viewer.setAnimationOn(false);
            this.viewer.setAnimationRange(-1, -1);
            if (!bl3) {
                this.viewer.setCurrentModelIndex(-1);
            }
            return;
        }
        if (n8 == 2 && !bl3) {
            bl5 = true;
        }
        if (bl6) {
            bl = false;
        } else if (bl) {
            for (n3 = 0; n3 < n8; ++n3) {
                if (nArray[n3] < 0) continue;
                int n12 = n3;
                nArray[n12] = nArray[n12] % 1000000;
            }
        }
        n3 = this.viewer.getModelNumberIndex(nArray[0], bl, false);
        n2 = -1;
        if (bl6 && n3 < 0 && nArray[0] != 0) {
            if (nArray[0] < 1000000) {
                nArray[0] = nArray[0] * 1000000;
            }
            if (n8 == 2 && nArray[1] < 1000000) {
                nArray[1] = nArray[1] * 1000000;
            }
            if (nArray[0] % 1000000 == 0) {
                nArray[0] = nArray[0] + 1;
                n3 = this.viewer.getModelNumberIndex(nArray[0], false, false);
                if (n3 >= 0) {
                    int n13 = n8 == 1 ? nArray[0] + 1000000 : (nArray[1] == 0 ? -1 : (nArray[1] % 1000000 == 0 ? nArray[1] + 1000001 : nArray[1] + 1));
                    n2 = this.viewer.getModelNumberIndex(n13, false, false);
                    if (n2 < 0) {
                        n2 = this.viewer.getModelCount();
                    }
                    --n2;
                    if (bl3) {
                        n8 = 2;
                    } else if (!bl5 && n2 != n3) {
                        bl5 = true;
                    }
                    bl3 = bl3 || n3 == n2;
                }
            } else {
                return;
            }
        }
        if (!bl2 && !bl3 || n3 >= 0) {
            this.viewer.setCurrentModelIndexClear(n3, false);
        }
        if (bl2 && n8 == 2 || bl3 || bl5) {
            if (n2 < 0) {
                n2 = this.viewer.getModelNumberIndex(nArray[1], bl, false);
            }
            this.viewer.setAnimationOn(false);
            this.viewer.setAnimationDirection(1);
            this.viewer.setAnimationRange(n3, n2);
            this.viewer.setCurrentModelIndexClear(bl5 && !bl3 ? -1 : (n3 >= 0 ? n3 : 0), false);
        }
        if (bl2) {
            this.viewer.setAnimation(266287);
        }
    }

    BS bitSetForModelFileNumber(int n) {
        int n2;
        BS bS = BSUtil.newBitSet(this.viewer.getAtomCount());
        if (this.chk) {
            return bS;
        }
        int n3 = this.viewer.getModelCount();
        boolean bl = this.viewer.haveFileSet();
        if (n < 1000000 && bl) {
            n *= 1000000;
        }
        if ((n2 = n % 1000000) == 0) {
            int n4;
            int n5 = this.viewer.getModelNumberIndex(n + 1, false, false);
            if (n5 < 0) {
                return bS;
            }
            int n6 = n4 = n == 0 ? n3 : this.viewer.getModelNumberIndex(n + 1000001, false, false);
            if (n5 < 0) {
                n5 = 0;
            }
            if (n4 < 0) {
                n4 = n3;
            }
            if (this.viewer.isTrajectory(n5)) {
                n4 = n5 + 1;
            }
            for (int i = n5; i < n4; ++i) {
                bS.or(this.viewer.getModelUndeletedAtomsBitSet(i));
            }
        } else {
            int n7 = this.viewer.getModelNumberIndex(n, false, true);
            if (n7 >= 0) {
                bS.or(this.viewer.getModelUndeletedAtomsBitSet(n7));
            }
        }
        return bS;
    }

    private void frameControl(int n) throws ScriptException {
        switch (this.getToken((int)this.checkLast((int)n)).tok) {
            case 20487: 
            case 266287: 
            case 1073741942: 
            case 1073741993: 
            case 1073742037: 
            case 0x40000110: 
            case 1073742098: 
            case 1073742108: 
            case 1073742126: {
                if (!this.chk) {
                    this.viewer.setAnimation(this.theTok);
                }
                return;
            }
        }
        this.error(22);
    }

    private int getShapeType(int n) throws ScriptException {
        int n2 = JC.shapeTokenIndex(n);
        if (n2 < 0) {
            this.error(49);
        }
        return n2;
    }

    private void font(int n, float f) throws ScriptException {
        String string = "SansSerif";
        String string2 = "Plain";
        int n2 = 0;
        float f2 = -1.0f;
        this.iToken = this.slen;
        switch (this.iToken) {
            case 6: {
                f2 = this.floatParameter(5);
                if (f2 >= 5.0f) {
                    f2 = this.viewer.getZoomSetting() / f2 / this.viewer.getScalePixelsPerAngstrom(false);
                }
            }
            case 5: {
                if (this.getToken((int)4).tok != 0x40000000) {
                    this.error(22);
                }
                string2 = this.parameterAsString(4);
            }
            case 4: {
                if (this.getToken((int)3).tok != 0x40000000) {
                    this.error(22);
                }
                string = this.parameterAsString(3);
                if (!this.isFloatParameter(2)) {
                    this.error(34);
                }
                f = this.floatParameter(2);
                n = this.getShapeType(this.getToken((int)1).tok);
                break;
            }
            case 3: {
                if (!this.isFloatParameter(2)) {
                    this.error(34);
                }
                if (n == -1) {
                    n = this.getShapeType(this.getToken((int)1).tok);
                    f = this.floatParameter(2);
                    break;
                }
                if (!(f >= 1.0f)) break;
                n2 = 5;
                f += (float)5;
                break;
            }
            default: {
                if (n == 5) {
                    f = 13.0f;
                    break;
                }
                this.error(2);
            }
        }
        if (n == 5) {
            if (f < 0.0f || f >= 1.0f && (f < 6.0f || f > 63.0f)) {
                this.integerOutOfRange(6 - n2, 63 - n2);
            }
            this.setShapeProperty(5, "setDefaults", this.viewer.getNoneSelected());
        }
        if (this.chk) {
            return;
        }
        if (GData.getFontStyleID(string) >= 0) {
            string2 = string;
            string = "SansSerif";
        }
        JmolFont jmolFont = this.viewer.getFont3D(string, string2, f);
        this.sm.loadShape(n);
        this.setShapeProperty(n, "font", jmolFont);
        if (f2 >= 0.0f) {
            this.setShapeProperty(n, "scalereference", Float.valueOf(f2));
        }
    }

    private void set() throws ScriptException {
        boolean bl;
        int n;
        Object object;
        String string;
        if (this.slen == 1) {
            this.showString(this.viewer.getAllSettings(null));
            return;
        }
        boolean bl2 = this.parameterAsString(0).equals("set");
        String string2 = this.optParameterAsString(1);
        if (bl2 && this.slen == 2 && string2.indexOf("?") >= 0) {
            this.showString(this.viewer.getAllSettings(string2.substring(0, string2.indexOf("?"))));
            return;
        }
        int n2 = this.getToken((int)1).tok;
        int n3 = 0;
        int n4 = Integer.MAX_VALUE;
        boolean bl3 = !this.chk && !this.tQuiet && this.scriptLevel <= this.scriptReportingLevel && !((String)this.st[0].value).equals("var");
        switch (n2) {
            case 1611272194: {
                this.axes(2);
                return;
            }
            case 1610616835: {
                this.background(2);
                return;
            }
            case 1679429641: {
                this.boundbox(2);
                return;
            }
            case 1611272202: {
                this.frank(2);
                return;
            }
            case 1610616855: {
                this.history(2);
                return;
            }
            case 1826248715: {
                this.label(2);
                return;
            }
            case 1614417948: {
                this.unitcell(2);
                return;
            }
            case 0x20000008: {
                this.sm.loadShape(8);
                this.setShapeProperty(8, "highlight", this.tokAt(2) == 0x10000C ? null : this.atomExpressionAt(2));
                return;
            }
            case 1610625028: 
            case 1611141171: {
                this.selectionHalo(2);
                return;
            }
            case 536875070: {
                this.timeout(2);
                return;
            }
        }
        switch (n2) {
            case 1641025539: {
                float[] fArray;
                EnumStructure enumStructure = EnumStructure.getProteinStructureType(this.parameterAsString(2));
                if (enumStructure == EnumStructure.NOT) {
                    this.error(22);
                }
                if ((fArray = this.floatParameterSet(3, 0, Integer.MAX_VALUE)).length % 4 != 0) {
                    this.error(22);
                }
                this.viewer.setStructureList(fArray, enumStructure);
                this.checkLast(this.iToken);
                return;
            }
            case 545259526: {
                n4 = this.getArgbParam(2);
                if (!this.chk) {
                    this.setObjectArgb("axes", n4);
                }
                return;
            }
            case 0x60000001: {
                this.setBondmode();
                return;
            }
            case 0x20000004: {
                if (this.chk) {
                    return;
                }
                int n5 = this.tokAt(2) == 0x10000C || this.tokAt(2) == 2 && this.intParameter(2) == 0 ? 4 : 5;
                Logger.setLogLevel(n5);
                this.setIntProperty("logLevel", n5);
                if (n5 == 4) {
                    this.viewer.setDebugScript(false);
                    if (bl3) {
                        this.viewer.showParameter("debugScript", true, 80);
                    }
                }
                this.setDebugging();
                if (bl3) {
                    this.viewer.showParameter("logLevel", true, 80);
                }
                return;
            }
            case 537022465: {
                this.setEcho();
                return;
            }
            case 0x60000002: {
                this.font(5, this.checkLength23() == 2 ? 0.0f : this.floatParameter(2));
                return;
            }
            case 1612189718: {
                this.setHbond();
                return;
            }
            case 0x20021010: 
            case 1746538509: {
                this.setMonitor();
                return;
            }
            case 1611141176: {
                this.setSsbond();
                return;
            }
            case 0x60000005: {
                this.setLabel("toggle");
                return;
            }
            case 0x20000012: {
                this.setUserColors();
                return;
            }
            case 553648188: {
                this.setZslab();
                return;
            }
        }
        boolean bl4 = true;
        switch (n2) {
            case 0x20000002: {
                int n6;
                if (this.slen <= 2) break;
                String string3 = this.stringSetting(2, false);
                boolean bl5 = false;
                if (string3.indexOf(".") < 0) {
                    n6 = Parser.parseInt(string3);
                    bl5 = true;
                } else {
                    n6 = ScriptEvaluator.getFloatEncodedInt(string3);
                }
                if (this.chk) {
                    return;
                }
                int n7 = this.viewer.getModelNumberIndex(n6, bl5, true);
                this.viewer.setBackgroundModelIndex(n7);
                return;
            }
            case 1649412112: {
                if (this.chk) {
                    return;
                }
                this.viewer.setAtomProperty(this.viewer.getModelUndeletedAtomsBitSet(-1), 1649412112, -1, Float.NaN, null, null, null);
                switch (this.tokAt(2)) {
                    case 1073742109: {
                        this.runScript("#VDW radii for PROBE;{_H}.vdw = 1.0;{_H and connected(_C) and not connected(within(smiles,'[a]'))}.vdw = 1.17;{_C}.vdw = 1.75;{_C and connected(3) and connected(_O)}.vdw = 1.65;{_N}.vdw = 1.55;{_O}.vdw = 1.4;{_P}.vdw = 1.8;{_S}.vdw = 1.8;message VDW radii for H, C, N, O, P, and S set according to Word, et al., J. Mol. Biol. (1999) 285, 1711-1733");
                        return;
                    }
                }
                n3 = 545259555;
            }
            case 545259555: {
                if (this.slen <= 2) break;
                String string4 = string = this.slen == 3 && EnumVdw.getVdwType(this.parameterAsString(2)) == null ? this.stringSetting(2, false) : this.parameterAsString(2);
                if (EnumVdw.getVdwType(string) == null) {
                    this.error(22);
                }
                this.setStringProperty(string2, string);
                break;
            }
            case 0x20000006: {
                if (this.slen <= 2) break;
                object = this.parameterExpressionToken(2);
                P3 p3 = ((SV)object).tok == 8 ? (P3)((SV)object).value : ((n = ((SV)object).asInt()) < 555 ? new P3() : this.viewer.getSymmetry().ijkToPoint3f(n + 111));
                if (this.chk) break;
                this.viewer.setDefaultLattice(p3);
                break;
            }
            case 545259545: 
            case 0x20800020: {
                if (this.slen <= 2) break;
                this.theTok = this.tokAt(2);
                string = this.theTok == 1073741992 || this.theTok == 1073742116 ? this.parameterAsString(this.checkLast(2)) : this.stringSetting(2, false);
                this.setStringProperty(string2, string);
                break;
            }
            case 1632634889: {
                n4 = this.intSetting(2);
                if (n4 == Integer.MIN_VALUE) {
                    this.error(22);
                }
                if (!this.chk) {
                    this.viewer.setFormalCharges(n4);
                }
                return;
            }
            case 553648148: {
                n4 = this.intSetting(2);
                if (this.chk) break;
                if (n4 != Integer.MIN_VALUE) {
                    this.commandHistoryLevelMax = n4;
                }
                this.setIntProperty(string2, n4);
                break;
            }
            case 545259564: {
                if (this.slen <= 2) break;
                this.setStringProperty(string2, this.stringSetting(2, bl2));
                break;
            }
            case 545259558: 
            case 545259568: {
                if (this.slen <= 2) break;
                this.setUnits(this.stringSetting(2, bl2), n2);
                break;
            }
            case 545259572: {
                if (!this.chk) {
                    this.viewer.setPicked(-1);
                }
                if (this.slen <= 2) break;
                this.setPicking();
                return;
            }
            case 545259574: {
                if (this.slen <= 2) break;
                this.setPickingStyle();
                return;
            }
            case 1716520973: {
                break;
            }
            case 553648168: {
                n4 = this.intSetting(2);
                if (this.chk || n4 == Integer.MIN_VALUE) break;
                this.scriptReportingLevel = n4;
                this.setIntProperty(string2, this.scriptReportingLevel);
                break;
            }
            case 0x2000000C: {
                n4 = this.intSetting(2);
                if (n4 == Integer.MIN_VALUE || n4 == 0 || n4 == 1) {
                    bl4 = false;
                    break;
                }
                n2 = 553648174;
                string2 = "specularPercent";
                this.setIntProperty(string2, n4);
                break;
            }
            case 1650071565: {
                n2 = 553648178;
                string2 = "strandCount";
                this.setIntProperty(string2, this.intSetting(2));
                break;
            }
            default: {
                bl4 = false;
            }
        }
        if (bl4 && !bl3) {
            return;
        }
        boolean bl6 = bl = !bl4 && !bl2 && this.getContextVariableAsVariable(string2) != null;
        if (!bl4 && !bl) {
            switch (n2) {
                case 1678770178: {
                    n3 = 603979928;
                    break;
                }
                case 0x60300006: {
                    n3 = 603979908;
                    break;
                }
                case 1613758476: {
                    n3 = 603979910;
                    break;
                }
                case 0x60000003: {
                    n3 = 603979878;
                    break;
                }
                case 1666189314: {
                    n3 = 0x22000032;
                    this.setFloatProperty("solventProbeRadius", this.floatSetting(2));
                    bl4 = true;
                    break;
                }
                case 0x60000004: {
                    n3 = 0x2200002E;
                    break;
                }
                case 1613758488: {
                    n3 = 603979948;
                    break;
                }
                case 1766856708: {
                    n3 = 545259545;
                    break;
                }
                case 1611141175: {
                    string = this.parameterAsString(2).toLowerCase();
                    switch ("x;y;z;fps".indexOf(string + ";")) {
                        case 0: {
                            n3 = 570425398;
                            break;
                        }
                        case 2: {
                            n3 = 570425400;
                            break;
                        }
                        case 4: {
                            n3 = 570425402;
                            break;
                        }
                        case 6: {
                            n3 = 570425396;
                            break;
                        }
                        default: {
                            this.errorStr2(50, "set SPIN ", string);
                        }
                    }
                    if (!this.chk) {
                        this.viewer.setSpin(string, (int)this.floatParameter(this.checkLast(3)));
                    }
                    bl4 = true;
                }
            }
        }
        if (n3 != 0) {
            n2 = n3;
            string2 = T.nameOf(n2);
        } else if (!bl4 && !bl) {
            if (string2.length() == 0 || string2.charAt(0) == '_') {
                this.error(56);
            }
            if (((String)(object = string2.toLowerCase())).indexOf("label") == 0 && Parser.isOneOf(string2.substring(5).toLowerCase(), "front;group;atom;offset;offsetexact;pointer;alignment;toggle;scalereference") && this.setLabel(string2.substring(5))) {
                return;
            }
            if (((String)object).endsWith("callback")) {
                n2 = 0x20000000;
            }
        }
        if (bl2 && !T.tokAttr(n2, 0x20000000)) {
            this.iToken = 1;
            if (!this.isStateScript) {
                this.errorStr2(50, "SET", string2);
            }
            this.warning(51, "SET", string2);
        }
        if (!bl4 && bl2) {
            switch (this.slen) {
                case 2: {
                    this.setBooleanProperty(string2, true);
                    bl4 = true;
                    break;
                }
                case 3: {
                    if (n4 == Integer.MAX_VALUE) break;
                    this.setIntProperty(string2, n4);
                    bl4 = true;
                }
            }
        }
        if (!bl4 && !bl2 && this.tokAt(2) == 0x10000B) {
            if (!this.chk) {
                this.viewer.removeUserVariable(string2.toLowerCase());
            }
            bl4 = true;
        }
        if (!bl4) {
            int n8 = this.tokAt(1) == 0x100001 ? 0 : this.tokAt(2);
            n = this.st[0].intValue;
            int n9 = n8 == 269484436 ? 3 : (n == 61 && !string2.equals("return") && n8 != 269484436 ? 0 : 2);
            this.setVariable(n9, 0, string2, n);
            if (!bl2) {
                return;
            }
        }
        if (bl3) {
            this.viewer.showParameter(string2, true, 80);
        }
    }

    private void setZslab() throws ScriptException {
        P3 p3 = null;
        if (this.isFloatParameter(2)) {
            this.checkLength(3);
            this.setIntProperty("zSlab", (int)this.floatParameter(2));
        } else {
            if (!this.isCenterParameter(2)) {
                this.error(22);
            }
            p3 = this.centerParameter(2);
            this.checkLength(this.iToken + 1);
        }
        if (!this.chk) {
            this.viewer.setZslabPoint(p3);
        }
    }

    private void setBondmode() throws ScriptException {
        boolean bl = false;
        switch (this.getToken((int)this.checkLast((int)2)).tok) {
            case 0x10100060: {
                break;
            }
            case 0x10100050: {
                bl = true;
                break;
            }
            default: {
                this.error(22);
            }
        }
        this.setBooleanProperty("bondModeOr", bl);
    }

    private void setEcho() throws ScriptException {
        String string = null;
        Object object = null;
        Object object2 = null;
        boolean bl = true;
        int n = 2;
        switch (this.getToken((int)2).tok) {
            case 0x10000C: {
                string = "allOff";
                object2 = "allOff";
                this.checkLength(++n);
                break;
            }
            case 0x10000B: {
                bl = false;
            }
            case 0x100003: {
                object2 = this.parameterAsString(2);
                this.checkLength(++n);
                break;
            }
            case 4: 
            case 12289: 
            case 0x40000000: 
            case 1073741871: 
            case 1073741996: 
            case 1073742019: 
            case 1073742128: 
            case 1074790550: 
            case 1074790748: {
                if (this.theTok == 1074790550) {
                    // empty if block
                }
                int n2 = ++n;
                ++n;
                object2 = this.parameterAsString(n2);
            }
        }
        if (!this.chk) {
            this.viewer.setEchoStateActive(bl);
            this.sm.loadShape(30);
            if (object2 != null) {
                this.setShapeProperty(30, string == null ? "target" : string, object2);
            }
        }
        if (n < this.slen) {
            block6 : switch (this.getToken((int)n++).tok) {
                case 0x40000008: {
                    string = "align";
                    switch (this.getToken((int)n).tok) {
                        case 12289: 
                        case 1073741996: 
                        case 1073742128: {
                            object = this.parameterAsString(n++);
                            break block6;
                        }
                    }
                    this.error(22);
                    break;
                }
                case 12289: 
                case 1073741996: 
                case 1073742128: {
                    string = "align";
                    object = this.parameterAsString(n - 1);
                    break;
                }
                case 554176526: {
                    string = "%zpos";
                    object = (int)this.floatParameter(n++);
                    break;
                }
                case 0x10000D: 
                case 3145768: 
                case 1610625028: {
                    string = "hidden";
                    object = Boolean.FALSE;
                    break;
                }
                case 12294: 
                case 3145770: {
                    string = "hidden";
                    object = Boolean.TRUE;
                    break;
                }
                case 1095766028: {
                    int n3;
                    int n4 = n3 = this.chk ? 0 : this.modelNumberParameter(n++);
                    if (n3 >= this.viewer.getModelCount()) {
                        this.error(22);
                    }
                    string = "model";
                    object = n3;
                    break;
                }
                case 0x10100040: 
                case 1073742195: {
                    string = "xypos";
                    object = this.xypParameter(--n);
                    if (object == null) {
                        --n;
                        break;
                    }
                    n = this.iToken + 1;
                    break;
                }
                case 2: {
                    int n5 = --n;
                    int n6 = this.intParameter(n5);
                    String string2 = "xpos";
                    if (this.tokAt(++n) == 269484210) {
                        string2 = "%xpos";
                    }
                    string = "ypos";
                    int n7 = ++n;
                    object = this.intParameter(n7);
                    if (this.tokAt(++n) == 269484210) {
                        string = "%ypos";
                        ++n;
                    }
                    this.checkLength(n);
                    this.setShapeProperty(30, string2, n6);
                    break;
                }
                case 0x10000C: {
                    string = "off";
                    break;
                }
                case 1073742138: {
                    string = "scale";
                    object = Float.valueOf(this.floatParameter(n++));
                    break;
                }
                case 135271429: {
                    string = "script";
                    object = this.parameterAsString(n++);
                    break;
                }
                case 4: 
                case 1073741979: {
                    boolean bl2;
                    boolean bl3 = bl2 = this.theTok == 1073741979;
                    if (bl2) {
                        ++n;
                    }
                    this.checkLength(n);
                    if (object2 == null && bl2) {
                        Object[] objectArray = new String[1];
                        this.getShapePropertyData(30, "currentTarget", objectArray);
                        object2 = objectArray[0];
                    }
                    this.echo(n - 1, (String)object2, bl2);
                    return;
                }
                default: {
                    if (this.isCenterParameter(n - 1)) {
                        string = "xyz";
                        object = this.centerParameter(n - 1);
                        n = this.iToken + 1;
                        break;
                    }
                    this.error(22);
                }
            }
        }
        this.checkLength(n);
        if (!this.chk && string != null) {
            this.setShapeProperty(30, string, object);
        }
    }

    private int intSetting(int n) throws ScriptException {
        if (n == this.slen) {
            return Integer.MIN_VALUE;
        }
        return this.parameterExpressionToken(n).asInt();
    }

    private float floatSetting(int n) throws ScriptException {
        if (n == this.slen) {
            return Float.NaN;
        }
        return SV.fValue(this.parameterExpressionToken(n));
    }

    private String stringSetting(int n, boolean bl) throws ScriptException {
        if (bl && this.slen == n + 1) {
            return this.parameterAsString(n);
        }
        return this.parameterExpressionToken(n).asString();
    }

    private boolean setLabel(String string) throws ScriptException {
        this.sm.loadShape(5);
        Object object = null;
        this.setShapeProperty(5, "setDefaults", this.viewer.getNoneSelected());
        if (string.equals("scalereference")) {
            float f = this.floatParameter(2);
            if (f >= 5.0f) {
                f = this.viewer.getZoomSetting() / f / this.viewer.getScalePixelsPerAngstrom(false);
            }
            object = Float.valueOf(f);
        } else if (string.equals("offset") || string.equals("offsetexact")) {
            if (this.isPoint3f(2)) {
                P3 p3 = this.getPoint3f(2, false);
                object = new float[]{1.0f, p3.x, p3.y, p3.z, 0.0f, 0.0f, 0.0f};
            } else if (this.isArrayParameter(2)) {
                object = this.floatParameterSet(2, 7, 7);
            } else {
                int n = this.intParameterRange(2, -127, 127);
                int n2 = this.intParameterRange(3, -127, 127);
                object = Object2d.getOffset(n, n2);
            }
        } else if (string.equals("alignment")) {
            switch (this.getToken((int)2).tok) {
                case 12289: 
                case 1073741996: 
                case 1073742128: {
                    string = "align";
                    object = this.theToken.value;
                    break;
                }
                default: {
                    this.error(22);
                    break;
                }
            }
        } else if (string.equals("pointer")) {
            int n = 0;
            switch (this.getToken((int)2).tok) {
                case 0x10000B: 
                case 0x10000C: {
                    break;
                }
                case 1610616835: {
                    n |= 2;
                }
                case 0x10000D: {
                    n |= 1;
                    break;
                }
                default: {
                    this.error(22);
                }
            }
            object = n;
        } else {
            boolean bl;
            if (string.equals("toggle")) {
                this.iToken = 1;
                BS bS = this.slen == 2 ? null : this.atomExpressionAt(2);
                this.checkLast(this.iToken);
                if (!this.chk) {
                    this.viewer.togglePickingLabel(bS);
                }
                return true;
            }
            this.iToken = 1;
            boolean bl2 = bl = this.slen == 2 || this.getToken((int)2).tok == 0x10000D;
            if (string.equals("front") || string.equals("group")) {
                if (!bl && this.tokAt(2) != 0x10000C) {
                    this.error(22);
                }
                if (!bl) {
                    string = "front";
                }
                object = bl ? Boolean.TRUE : Boolean.FALSE;
            } else if (string.equals("atom")) {
                if (!bl && this.tokAt(2) != 0x10000C) {
                    this.error(22);
                }
                string = "front";
                object = bl ? Boolean.FALSE : Boolean.TRUE;
            } else {
                return false;
            }
        }
        BS bS = this.iToken + 1 < this.slen ? this.atomExpressionAt(++this.iToken) : null;
        this.checkLast(this.iToken);
        if (this.chk) {
            return true;
        }
        if (bS == null) {
            this.setShapeProperty(5, string, object);
        } else {
            this.setShapePropertyBs(5, string, object, bS);
        }
        return true;
    }

    private void setMonitor() throws ScriptException {
        int n = this.tokAt(this.checkLast(2));
        switch (n) {
            case 0x10000C: 
            case 0x10000D: {
                this.setBooleanProperty("measurementlabels", n == 0x10000D);
                return;
            }
            case 2: 
            case 3: 
            case 0x40000066: {
                this.setShapeSizeBs(6, this.getSetAxesTypeMad(2), null);
                return;
            }
        }
        this.setUnits(this.parameterAsString(2), 545259568);
    }

    private boolean setUnits(String string, int n) throws ScriptException {
        if (n == 545259568 && Parser.isOneOf(string.toLowerCase(), "angstroms;au;bohr;nanometers;nm;picometers;pm;vanderwaals;vdw")) {
            if (!this.chk) {
                this.viewer.setUnits(string, true);
            }
        } else if (n == 545259558 && Parser.isOneOf(string.toLowerCase(), "kcal;kj")) {
            if (!this.chk) {
                this.viewer.setUnits(string, false);
            }
        } else {
            this.errorStr2(50, "set " + T.nameOf(n), string);
        }
        return true;
    }

    private void setSsbond() throws ScriptException {
        boolean bl = false;
        switch (this.tokAt(this.checkLast(2))) {
            case 1115297793: {
                bl = true;
                break;
            }
            case 3145754: {
                break;
            }
            default: {
                this.error(22);
            }
        }
        this.setBooleanProperty("ssbondsBackbone", bl);
    }

    private void setHbond() throws ScriptException {
        boolean bl = false;
        switch (this.tokAt(this.checkLast(2))) {
            case 1115297793: {
                bl = true;
            }
            case 3145754: {
                this.setBooleanProperty("hbondsBackbone", bl);
                break;
            }
            case 1073742150: {
                bl = true;
            }
            case 0x40000066: {
                this.setBooleanProperty("hbondsSolid", bl);
                break;
            }
            default: {
                this.error(22);
            }
        }
    }

    private void setPicking() throws ScriptException {
        if (this.slen == 2) {
            this.setStringProperty("picking", "identify");
            return;
        }
        if (this.slen > 4 || this.tokAt(2) == 4) {
            this.setStringProperty("picking", this.stringSetting(2, false));
            return;
        }
        int n = 2;
        String string = "SELECT";
        switch (this.getToken((int)2).tok) {
            case 135280132: 
            case 1611141175: 
            case 1746538509: {
                if (this.checkLength34() != 4) break;
                string = this.parameterAsString(2).toUpperCase();
                if (string.equals("SPIN")) {
                    this.setIntProperty("pickingSpinRate", this.intParameter(3));
                    break;
                }
                n = 3;
                break;
            }
            case 12291: {
                break;
            }
            default: {
                this.checkLength(3);
            }
        }
        String string2 = this.parameterAsString(n);
        switch (this.getToken((int)n).tok) {
            case 0x10000D: 
            case 1073742056: {
                string2 = "identify";
                break;
            }
            case 0x10000B: 
            case 0x10000C: {
                string2 = "off";
                break;
            }
            case 135280132: {
                string2 = "atom";
                break;
            }
            case 1826248715: {
                string2 = "label";
                break;
            }
            case 1678770178: {
                string2 = "bond";
                break;
            }
            case 12291: {
                this.checkLength(4);
                if (this.tokAt(3) != 1678770178) {
                    this.error(22);
                }
                string2 = "deleteBond";
            }
        }
        int n2 = string2.indexOf("_");
        n2 = n2 >= 0 ? n2 : string2.length();
        n2 = ActionManager.getPickingMode(string2.substring(0, n2));
        if (n2 < 0) {
            this.errorStr2(50, "SET PICKING " + string, string2);
        }
        this.setStringProperty("picking", string2);
    }

    private void setPickingStyle() throws ScriptException {
        if (this.slen > 4 || this.tokAt(2) == 4) {
            this.setStringProperty("pickingStyle", this.stringSetting(2, false));
            return;
        }
        int n = 2;
        boolean bl = false;
        String string = "SELECT";
        switch (this.getToken((int)2).tok) {
            case 1746538509: {
                bl = true;
                string = "MEASURE";
            }
            case 135280132: {
                if (this.checkLength34() != 4) break;
                n = 3;
                break;
            }
            default: {
                this.checkLength(3);
            }
        }
        String string2 = this.parameterAsString(n);
        switch (this.getToken((int)n).tok) {
            case 0x10000B: 
            case 0x10000C: {
                string2 = bl ? "measureoff" : "toggle";
                break;
            }
            case 0x10000D: {
                if (!bl) break;
                string2 = "measure";
            }
        }
        if (ActionManager.getPickingStyleIndex(string2) < 0) {
            this.errorStr2(50, "SET PICKINGSTYLE " + string, string2);
        }
        this.setStringProperty("pickingStyle", string2);
    }

    private void timeout(int n) throws ScriptException {
        String string = null;
        String string2 = null;
        int n2 = 0;
        if (this.slen == n) {
            this.showString(this.viewer.showTimeout(null));
            return;
        }
        block6: for (int i = n; i < this.slen; ++i) {
            switch (this.getToken((int)i).tok) {
                case 1074790550: {
                    string = this.parameterAsString(++i);
                    if (this.slen != 3) continue block6;
                    if (!this.chk) {
                        this.viewer.triggerTimeout(string);
                    }
                    return;
                }
                case 0x10000C: {
                    continue block6;
                }
                case 2: {
                    n2 = this.intParameter(i);
                    continue block6;
                }
                case 3: {
                    n2 = Math.round(this.floatParameter(i) * 1000.0f);
                    continue block6;
                }
                default: {
                    if (string == null) {
                        string = this.parameterAsString(i);
                        continue block6;
                    }
                    if (string2 == null) {
                        string2 = this.parameterAsString(i);
                        continue block6;
                    }
                    this.error(22);
                }
            }
        }
        if (!this.chk) {
            this.viewer.setTimeout(string, n2, string2);
        }
    }

    private void setUserColors() throws ScriptException {
        int n;
        JmolList<Integer> jmolList = new JmolList<Integer>();
        for (n = 2; n < this.slen; ++n) {
            int n2 = this.getArgbParam(n);
            jmolList.addLast(n2);
            n = this.iToken;
        }
        if (this.chk) {
            return;
        }
        n = jmolList.size();
        int[] nArray = new int[n];
        int n3 = n;
        while (--n3 >= 0) {
            nArray[n3] = (Integer)jmolList.get(n3);
        }
        this.viewer.setUserScale(nArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setVariable(int n, int n2, String string, int n3) throws ScriptException {
        boolean bl;
        int n4;
        Object object;
        boolean bl2;
        BS bS = null;
        String string2 = "";
        int n5 = 0;
        boolean bl3 = n3 == 91;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = string.startsWith("property_");
        SV sV = bl6 ? null : this.getContextVariableAsVariable(string);
        boolean bl7 = bl2 = sV != null;
        if (n > 0 && this.tokAt(n - 1) == 0x100001) {
            bS = this.atomExpressionAt(n - 1);
            n = this.iToken + 1;
            bl5 = true;
        }
        if (this.tokAt(n) == 0x100008) {
            bl4 = true;
            if ((object = this.getBitsetPropertySelector(++n, true)) == null) {
                this.error(22);
            }
            if (this.tokAt(++n) != 269484436) {
                this.error(22);
            }
            ++n;
            n5 = ((SV)object).intValue;
            string2 = (String)((SV)object).value;
        }
        if (bl5 && !bl4) {
            this.error(22);
        }
        if ((n4 = ((ArrayList)(object = (JmolList)this.parameterExpression(n, n2, string, true, true, -1, bl3, null, null))).size()) == 0 || !bl3 && n4 > 1 || bl3 && (n4 < 3 || n4 % 2 != 1)) {
            this.error(22);
        }
        if (this.chk) {
            return;
        }
        SV sV2 = (SV)((ArrayList)object).get(bl3 ? ((ArrayList)object).size() - 1 : 0);
        boolean bl8 = bl = !bl2 && !bl5 && !bl6 && (bl3 || bl4 || !(sV2.value instanceof String) && sV2.tok != 2 && !(sV2.value instanceof Integer) && !(sV2.value instanceof Float) && !(sV2.value instanceof Boolean));
        if (bl) {
            if (string.startsWith("_")) {
                this.errorStr(22, string);
            }
            sV = this.viewer.getOrSetNewVariable(string, true);
            bl2 = true;
        }
        if (!bl3) {
            if (bl4) {
                if (!bl5 && (bS = SV.getBitSet(sV, true)) == null) {
                    this.error(22);
                }
                if (!string2.startsWith("property_")) {
                    this.setBitsetProperty(bS, n5, sV2.asInt(), sV2.asFloat(), sV2);
                    return;
                }
                this.viewer.setData(string2, new Object[]{string2, sV2.tok == 7 ? (Object)SV.flistValue(sV2, ((JmolList)sV2.value).size() == bS.cardinality() ? bS.cardinality() : this.viewer.getAtomCount()) : sV2.asString(), BSUtil.copy(bS), sV2.tok == 7 ? 1 : 0}, this.viewer.getAtomCount(), 0, 0, sV2.tok == 7 ? Integer.MAX_VALUE : Integer.MIN_VALUE, 0);
                return;
            }
            if (bl2) {
                sV.setv(sV2, false);
                return;
            }
            Object object2 = SV.oValue(sV2);
            if (string.startsWith("property_")) {
                if (sV2.tok == 7) {
                    object2 = sV2.asString();
                }
                this.viewer.setData(string, new Object[]{string, "" + object2, BSUtil.copy(this.viewer.getSelectionSet(false)), 0}, this.viewer.getAtomCount(), 0, 0, Integer.MIN_VALUE, 0);
                return;
            }
            if (object2 instanceof Boolean) {
                this.setBooleanProperty(string, (Boolean)object2);
                return;
            }
            if (object2 instanceof Integer) {
                this.setIntProperty(string, (Integer)object2);
                return;
            }
            if (object2 instanceof Float) {
                this.setFloatProperty(string, ((Float)object2).floatValue());
                return;
            }
            if (object2 instanceof String) {
                this.setStringProperty(string, (String)object2);
                return;
            }
            if (object2 instanceof Bond.BondSet) {
                this.setStringProperty(string, Escape.eBond((BS)object2));
                return;
            }
            if (!(object2 instanceof BS || object2 instanceof P3 || object2 instanceof P4)) {
                Logger.error("ERROR -- return from propertyExpression was " + object2);
                return;
            }
            this.setStringProperty(string, Escape.e(object2));
            return;
        }
        SV sV3 = SV.newVariable(4, "").setv(sV2, false);
        int n6 = ((ArrayList)object).size() / 2;
        int n7 = 0;
        while (n7 < n6) {
            block34: {
                Object object3;
                SV sV4;
                boolean bl9;
                block33: {
                    bl9 = n7 + 1 == n6;
                    sV4 = (SV)((ArrayList)object).get(n7 * 2);
                    if (sV.tok == 10) {
                        sV.tok = 6;
                        sV.value = new Hashtable();
                    }
                    if (sV.tok != 6) break block33;
                    String string3 = sV4.asString();
                    object3 = (Map)sV.value;
                    if (bl9) {
                        object3.put(string3, sV3);
                        return;
                    }
                    sV = (SV)object3.get(string3);
                    break block34;
                }
                int n8 = sV4.asInt();
                if (sV.tok == 7) {
                    sV = SV.selectItemVar(sV);
                }
                switch (sV.tok) {
                    case 7: {
                        object3 = sV.getList();
                        if (n8 > ((ArrayList)object3).size() || bl9) break;
                        if (n8 <= 0) {
                            n8 = ((ArrayList)object3).size() + n8;
                        }
                        if (--n8 < 0) {
                            n8 = 0;
                        }
                        sV = (SV)((ArrayList)object3).get(n8);
                        break block34;
                    }
                    case 11: 
                    case 12: {
                        int n9;
                        int n10;
                        int n11 = n10 = sV.tok == 11 ? 3 : 4;
                        if (n6 == 1 && Math.abs(n8) >= 1 && Math.abs(n8) <= n10 && sV3.tok == 7 && sV3.getList().size() == n10) break;
                        if (n6 == 2 && (n9 = ((SV)((ArrayList)object).get(2)).asInt()) >= 1 && n9 <= n10 && (sV3.tok == 2 || sV3.tok == 3)) {
                            ++n7;
                            n8 = n8 * 10 + n9;
                            break;
                        }
                        sV.toArray();
                        --n7;
                        break block34;
                    }
                }
                sV.setSelectedValue(n8, sV3);
                return;
            }
            ++n7;
        }
    }

    private void axes(int n) throws ScriptException {
        TickInfo tickInfo = this.checkTicks(n, true, true, false);
        n = this.iToken + 1;
        int n2 = this.tokAt(n);
        String string = this.optParameterAsString(n).toLowerCase();
        if (this.slen == n + 1 && Parser.isOneOf(string, "window;unitcell;molecular")) {
            this.setBooleanProperty("axes" + string, true);
            return;
        }
        switch (n2) {
            case 12289: {
                P3 p3 = this.centerParameter(n + 1);
                this.setShapeProperty(31, "origin", p3);
                this.checkLast(this.iToken);
                return;
            }
            case 1073742138: {
                this.setFloatProperty("axesScale", this.floatParameter(this.checkLast(++n)));
                return;
            }
            case 1826248715: {
                n2 = this.tokAt(n + 1);
                switch (n2) {
                    case 0x10000C: 
                    case 0x10000D: {
                        this.checkLength(n + 2);
                        this.setShapeProperty(31, "labels" + (n2 == 0x10000D ? "On" : "Off"), null);
                        return;
                    }
                }
                String string2 = null;
                switch (this.slen - n) {
                    case 7: {
                        this.setShapeProperty(31, "labels", new String[]{this.parameterAsString(++n), this.parameterAsString(++n), this.parameterAsString(++n), this.parameterAsString(++n), this.parameterAsString(++n), this.parameterAsString(++n)});
                        break;
                    }
                    case 5: {
                        string2 = this.parameterAsString(n + 4);
                    }
                    case 4: {
                        this.setShapeProperty(31, "labels", new String[]{this.parameterAsString(++n), this.parameterAsString(++n), this.parameterAsString(++n), string2});
                        break;
                    }
                    default: {
                        this.error(2);
                    }
                }
                return;
            }
        }
        if (string.equals("position")) {
            P3 p3;
            if (this.tokAt(++n) == 0x10000C) {
                p3 = new P3();
            } else {
                p3 = this.xypParameter(n);
                if (p3 == null) {
                    this.error(22);
                }
                n = this.iToken;
            }
            this.setShapeProperty(31, "position", p3);
            return;
        }
        int n3 = this.getSetAxesTypeMad(n);
        if (this.chk) {
            return;
        }
        this.setObjectMad(31, "axes", n3);
        if (tickInfo != null) {
            this.setShapeProperty(31, "tickInfo", tickInfo);
        }
    }

    private void boundbox(int n) throws ScriptException {
        int n2;
        boolean bl;
        TickInfo tickInfo = this.checkTicks(n, false, true, false);
        n = this.iToken + 1;
        float f = 1.0f;
        if (this.tokAt(n) == 1073742138) {
            f = this.floatParameter(++n);
            if (!this.chk && f == 0.0f) {
                this.error(22);
            }
            if (++n == this.slen) {
                if (!this.chk) {
                    this.viewer.setBoundBox(null, null, true, f);
                }
                return;
            }
        }
        boolean bl2 = bl = this.tokAt(n) == 0x4000004E;
        if (bl) {
            ++n;
        }
        if (this.isCenterParameter(n)) {
            this.expressionResult = null;
            n2 = n;
            P3 p3 = this.centerParameter(n);
            n = this.iToken + 1;
            if (bl || this.isCenterParameter(n)) {
                P3 p32 = bl ? this.centerParameter(n) : this.getPoint3f(n, true);
                n = this.iToken + 1;
                if (!this.chk) {
                    this.viewer.setBoundBox(p3, p32, bl, f);
                }
            } else if (this.expressionResult != null && this.expressionResult instanceof BS) {
                if (!this.chk) {
                    this.viewer.calcBoundBoxDimensions((BS)this.expressionResult, f);
                }
            } else if (this.expressionResult == null && this.tokAt(n2) == 0x100007) {
                P3[] p3Array;
                if (this.chk) {
                    return;
                }
                if ((p3Array = this.getObjectBoundingBox(this.objectNameParameter(++n2))) == null) {
                    this.error(22);
                }
                this.viewer.setBoundBox(p3Array[0], p3Array[1], true, f);
                n = this.iToken + 1;
            } else {
                this.error(22);
            }
            if (n == this.slen) {
                return;
            }
        }
        n2 = this.getSetAxesTypeMad(n);
        if (this.chk) {
            return;
        }
        if (tickInfo != null) {
            this.setShapeProperty(32, "tickInfo", tickInfo);
        }
        this.setObjectMad(32, "boundbox", n2);
    }

    private TickInfo checkTicks(int n, boolean bl, boolean bl2, boolean bl3) throws ScriptException {
        this.iToken = n - 1;
        if (this.tokAt(n) != 1073742164) {
            return null;
        }
        String string = " ";
        switch (this.tokAt(n + 1)) {
            case 1112541205: 
            case 1112541206: 
            case 1112541207: {
                string = this.parameterAsString(++n).toLowerCase();
                break;
            }
            case 0x40000000: {
                this.error(22);
            }
        }
        if (this.tokAt(++n) == 0x10000B) {
            TickInfo tickInfo = new TickInfo(null);
            tickInfo.type = string;
            this.iToken = n;
            return tickInfo;
        }
        TickInfo tickInfo = new TickInfo((P3)this.getPointOrPlane(n, false, true, false, false, 3, 3));
        if (this.coordinatesAreFractional || this.tokAt(this.iToken + 1) == 1614417948) {
            tickInfo.scale = P3.new3(Float.NaN, Float.NaN, Float.NaN);
            bl2 = false;
        }
        if (this.tokAt(this.iToken + 1) == 1614417948) {
            ++this.iToken;
        }
        tickInfo.type = string;
        if (this.tokAt(this.iToken + 1) == 1288701960) {
            tickInfo.tickLabelFormats = this.stringParameterSet(this.iToken + 2);
        }
        if (!bl2) {
            return tickInfo;
        }
        if (this.tokAt(this.iToken + 1) == 1073742138) {
            if (this.isFloatParameter(this.iToken + 2)) {
                float f = this.floatParameter(this.iToken + 2);
                tickInfo.scale = P3.new3(f, f, f);
            } else {
                tickInfo.scale = this.getPoint3f(this.iToken + 2, true);
            }
        }
        if (bl3 && this.tokAt(this.iToken + 1) == 1073741942) {
            tickInfo.first = this.floatParameter(this.iToken + 2);
        }
        return tickInfo;
    }

    private void unitcell(int n) throws ScriptException {
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        P3 p3 = null;
        TickInfo tickInfo = this.checkTicks(n, true, false, false);
        n = this.iToken;
        String string = null;
        P3[] p3Array = null;
        switch (this.tokAt(n + 1)) {
            case 4: {
                string = this.objectNameParameter(++n);
                break;
            }
            case 0x100007: {
                ++n;
                string = this.objectNameParameter(++n);
                break;
            }
            default: {
                if (this.isArrayParameter(n + 1)) {
                    p3Array = this.getPointArray(++n, 4);
                    n = this.iToken;
                    break;
                }
                if (this.slen == n + 2) {
                    if (this.getToken((int)(n + 1)).tok != 2 || this.intParameter(n + 1) < 111) break;
                    n2 = this.intParameter(++n);
                    break;
                }
                if (this.slen <= n + 1) break;
                p3 = (P3)this.getPointOrPlane(++n, false, true, false, true, 3, 3);
                n = this.iToken;
            }
        }
        n3 = this.getSetAxesTypeMad(++n);
        this.checkLast(this.iToken);
        if (this.chk) {
            return;
        }
        if (n2 != Integer.MAX_VALUE) {
            this.viewer.setCurrentUnitCellOffset(n2);
        } else if (string != null) {
            this.viewer.setCurrentCage(string);
        } else if (p3Array != null) {
            this.viewer.setCurrentCagePts(p3Array);
        }
        this.setObjectMad(33, "unitCell", n3);
        if (p3 != null) {
            this.viewer.setCurrentUnitCellOffsetPt(p3);
        }
        if (tickInfo != null) {
            this.setShapeProperty(33, "tickInfo", tickInfo);
        }
    }

    private void frank(int n) throws ScriptException {
        this.setBooleanProperty("frank", this.booleanParameter(n));
    }

    private void selectionHalo(int n) throws ScriptException {
        boolean bl = false;
        switch (n == this.slen ? 0x10000D : this.getToken((int)n).tok) {
            case 0x10000D: 
            case 1114638350: {
                bl = true;
            }
            case 0x10000B: 
            case 0x10000C: 
            case 1073742056: {
                this.setBooleanProperty("selectionHalos", bl);
                break;
            }
            default: {
                this.error(22);
            }
        }
    }

    private void save() throws ScriptException {
        if (this.slen > 1) {
            String string = this.optParameterAsString(2);
            switch (this.tokAt(1)) {
                case 1073742132: {
                    if (!this.chk) {
                        this.viewer.saveOrientation(string);
                    }
                    return;
                }
                case 1073742077: {
                    if (!this.chk) {
                        this.viewer.saveOrientation(string);
                    }
                    return;
                }
                case 1678770178: {
                    if (!this.chk) {
                        this.viewer.saveBonds(string);
                    }
                    return;
                }
                case 1073742158: {
                    if (!this.chk) {
                        this.viewer.saveState(string);
                    }
                    return;
                }
                case 1641025539: {
                    if (!this.chk) {
                        this.viewer.saveStructure(string);
                    }
                    return;
                }
                case 0x100006: {
                    if (!this.chk) {
                        this.viewer.saveCoordinates(string, this.viewer.getSelectionSet(false));
                    }
                    return;
                }
                case 1073742140: {
                    if (!this.chk) {
                        this.viewer.saveSelection(string);
                    }
                    return;
                }
            }
        }
        this.errorStr2(53, "SAVE", "bonds? coordinates? orientation? selection? state? structure?");
    }

    private void restore() throws ScriptException {
        if (this.slen > 1) {
            String string = this.optParameterAsString(2);
            if (this.getToken((int)1).tok != 1073742077) {
                this.checkLength23();
            }
            switch (this.getToken((int)1).tok) {
                case 1073742132: {
                    float f;
                    float f2 = f = this.slen > 3 ? this.floatParameter(3) : 0.0f;
                    if (f < 0.0f) {
                        this.error(22);
                    }
                    if (!this.chk) {
                        this.viewer.restoreRotation(string, f);
                        if (this.isJS && f > 0.0f && this.viewer.global.waitForMoveTo) {
                            throw new ScriptInterruption(this, "restoreRotation", 1);
                        }
                    }
                    return;
                }
                case 1073742077: {
                    float f;
                    float f3 = f = this.slen > 3 ? this.floatParameter(3) : 0.0f;
                    if (f < 0.0f) {
                        this.error(22);
                    }
                    if (!this.chk) {
                        this.viewer.restoreOrientation(string, f);
                        if (this.isJS && f > 0.0f && this.viewer.global.waitForMoveTo) {
                            throw new ScriptInterruption(this, "restoreOrientation", 1);
                        }
                    }
                    return;
                }
                case 1678770178: {
                    if (!this.chk) {
                        this.viewer.restoreBonds(string);
                    }
                    return;
                }
                case 0x100006: {
                    if (this.chk) {
                        return;
                    }
                    String string2 = this.viewer.getSavedCoordinates(string);
                    if (string2 == null) {
                        this.error(22);
                    }
                    this.runScript(string2);
                    this.viewer.checkCoordinatesChanged();
                    return;
                }
                case 1073742158: {
                    if (this.chk) {
                        return;
                    }
                    String string3 = this.viewer.getSavedState(string);
                    if (string3 == null) {
                        this.error(22);
                    }
                    this.runScript(string3);
                    return;
                }
                case 1641025539: {
                    if (this.chk) {
                        return;
                    }
                    String string4 = this.viewer.getSavedStructure(string);
                    if (string4 == null) {
                        this.error(22);
                    }
                    this.runScript(string4);
                    return;
                }
                case 1073742140: {
                    if (!this.chk) {
                        this.viewer.restoreSelection(string);
                    }
                    return;
                }
            }
        }
        this.errorStr2(53, "RESTORE", "bonds? coords? orientation? selection? state? structure?");
    }

    String write(T[] tArray) throws ScriptException {
        Object object;
        boolean bl;
        boolean bl2;
        int n = 0;
        int n2 = 0;
        if (tArray == null) {
            tArray = this.st;
            n2 = 1;
            n = 1;
            bl2 = true;
            bl = this.viewer.isApplet() && !this.viewer.isSignedApplet() || !this.viewer.isRestricted(Viewer.ACCESS.ALL) || this.viewer.getPathForAllFiles().length() > 0;
        } else {
            bl2 = false;
            bl = true;
        }
        int n3 = bl2 ? this.slen : tArray.length;
        int n4 = 0;
        int n5 = 0;
        int n6 = -1;
        int n7 = -1;
        int n8 = Integer.MIN_VALUE;
        String string = this.viewer.getExportDriverList();
        String string2 = "PNGJ";
        String string3 = null;
        String string4 = "";
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String[] stringArray = new String[1];
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        BS bS = null;
        String[] stringArray2 = null;
        String string10 = "SPT";
        int n9 = bl2 && tArray.length == 1 ? 1073741884 : ScriptEvaluator.tokAtArray(n, tArray);
        switch (n9) {
            case 0: {
                break;
            }
            case 135271429: {
                if (!this.isArrayParameter(n + 1)) break;
                stringArray2 = this.stringParameterSet(++n);
                string6 = ".";
                string7 = ".";
                n2 = n = this.iToken + 1;
                n9 = this.tokAt(n);
                break;
            }
            default: {
                string10 = SV.sValue(this.tokenAt(n, tArray)).toUpperCase();
            }
        }
        switch (n9) {
            case 0: {
                break;
            }
            case 1052714: 
            case 0x8101011: 
            case 1716520973: {
                string9 = this.plot(tArray);
                if (bl2) break;
                return string9;
            }
            case 1073741983: {
                string10 = "INLINE";
                string3 = SV.sValue(this.tokenAt(++n, tArray));
                ++n;
                break;
            }
            case 1073742102: {
                string10 = "PGRP";
                string4 = SV.sValue(this.tokenAt(++n, tArray)).toLowerCase();
                if (!string4.equals("draw")) break;
                ++n;
                break;
            }
            case 0x100006: {
                ++n;
                bl3 = true;
                break;
            }
            case 135271429: 
            case 1073742158: {
                string8 = SV.sValue(this.tokenAt(++n, tArray)).toLowerCase();
                while (string8.equals("localpath") || string8.equals("remotepath")) {
                    if (string8.equals("localpath")) {
                        string6 = SV.sValue(this.tokenAt(++n, tArray));
                    } else {
                        string7 = SV.sValue(this.tokenAt(++n, tArray));
                    }
                    string8 = SV.sValue(this.tokenAt(++n, tArray)).toLowerCase();
                }
                string10 = "SPT";
                break;
            }
            case 135180: 
            case 135188: 
            case 0x121012: 
            case 135368713: 
            case 1073742015: 
            case 1073742018: 
            case 1229984263: 
            case 1610616855: {
                ++n;
                break;
            }
            case 1073741992: {
                string10 = "ZIPALL";
                ++n;
                break;
            }
            case 36868: {
                string10 = "VAR";
                n += 2;
                break;
            }
            case 4: 
            case 4115: 
            case 4166: 
            case 0x40000000: 
            case 1073741979: 
            case 1073742139: {
                switch (n9) {
                    case 1073741979: {
                        ++n;
                        break;
                    }
                    case 4166: {
                        n5 = this.intParameterRange(++n, 1, 10);
                        if (!this.chk) {
                            this.viewer.setVibrationOff();
                            if (!this.isJS) {
                                this.viewer.delayScript(this, 100);
                            }
                        }
                        ++n;
                        break;
                    }
                    case 4115: {
                        if (n + 1 < n3 && tArray[++n].tok == 0x100001 || tArray[n].tok == 10) {
                            object = this.atomExpression(tArray, n, 0, true, false, true, true);
                            n = this.iToken + 1;
                        } else {
                            object = this.viewer.getModelUndeletedAtomsBitSet(-1);
                        }
                        if (this.chk) break;
                        bS = this.viewer.getModelBitSet((BS)object, true);
                        break;
                    }
                    case 1073742139: {
                        string8 = SV.sValue(this.tokenAt(++n, tArray)).toUpperCase();
                        if (!Parser.isOneOf(string8, "PNG;PNGJ")) break;
                        string2 = string8;
                        ++n;
                        break;
                    }
                    default: {
                        T t = T.getTokenFromName(SV.sValue(tArray[n]).toLowerCase());
                        if (t != null) {
                            n9 = t.tok;
                            string10 = SV.sValue(t).toUpperCase();
                        }
                        if (Parser.isOneOf(string10, string.toUpperCase())) {
                            ++n;
                            string10 = string10.substring(0, 1).toUpperCase() + string10.substring(1).toLowerCase();
                            bl4 = true;
                            if (!bl2) break;
                            string5 = "Jmol." + string10;
                            break;
                        }
                        if (string10.equals("ZIP")) {
                            ++n;
                            break;
                        }
                        if (string10.equals("ZIPALL")) {
                            ++n;
                            break;
                        }
                        string10 = "(image)";
                    }
                }
                if (ScriptEvaluator.tokAtArray(n, tArray) != 2) break;
                n6 = SV.iValue(this.tokenAt(n++, tArray));
                n7 = SV.iValue(this.tokenAt(n++, tArray));
            }
        }
        if (string9 == null) {
            string8 = SV.sValue(this.tokenAt(n, tArray));
            if (string8.equalsIgnoreCase("clipboard")) {
                if (this.chk) {
                    return "";
                }
            } else if (Parser.isOneOf(string8.toLowerCase(), "png;pngj;pngt;jpg;jpeg;jpg64;jpeg64")) {
                if (ScriptEvaluator.tokAtArray(n + 1, tArray) == 2 && ScriptEvaluator.tokAtArray(n + 2, tArray) == 2) {
                    n6 = SV.iValue(this.tokenAt(++n, tArray));
                    n7 = SV.iValue(this.tokenAt(++n, tArray));
                }
                if (ScriptEvaluator.tokAtArray(n + 1, tArray) == 2) {
                    n8 = SV.iValue(this.tokenAt(++n, tArray));
                }
            } else if (Parser.isOneOf(string8.toLowerCase(), "xyz;xyzrn;xyzvib;mol;sdf;v2000;v3000;cd;pdb;pqr;cml")) {
                string10 = string8.toUpperCase();
                if (n + 1 == n3) {
                    ++n;
                }
            }
            if (string10.equals("(image)") && Parser.isOneOf(string8.toUpperCase(), "GIF;JPG;JPG64;JPEG;JPEG64;PNG;PNGJ;PNGT;PPM")) {
                string10 = string8.toUpperCase();
                ++n;
            }
            if (n + 2 == n3 && (string3 = SV.sValue(this.tokenAt(++n, tArray))).length() > 0 && string3.charAt(0) != '.') {
                string10 = string8.toUpperCase();
            }
            switch (ScriptEvaluator.tokAtArray(n, tArray)) {
                case 0: {
                    bl = true;
                    break;
                }
                case 1073741884: {
                    break;
                }
                case 4: 
                case 0x40000000: {
                    string5 = SV.sValue(this.tokenAt(n, tArray));
                    if (n == n3 - 3 && ScriptEvaluator.tokAtArray(n + 1, tArray) == 0x100008) {
                        string5 = string5 + "." + SV.sValue(this.tokenAt(n + 2, tArray));
                    }
                    if (string10 != "VAR" && n == n2) {
                        string10 = "IMAGE";
                    } else if (string5.length() > 0 && string5.charAt(0) == '.' && (n == n2 + 1 || n == n2 + 2)) {
                        string5 = SV.sValue(this.tokenAt(n - 1, tArray)) + string5;
                        if (string10 != "VAR" && n == n2 + 1) {
                            string10 = "IMAGE";
                        }
                    }
                    if (!string5.equalsIgnoreCase("clipboard") && this.viewer.isRestricted(Viewer.ACCESS.ALL)) break;
                    string5 = null;
                    break;
                }
                default: {
                    this.error(22);
                }
            }
            if (string10.equals("IMAGE") || string10.equals("FRAME") || string10.equals("VIBRATION")) {
                String string11 = string10 = string5 != null && string5.indexOf(".") >= 0 ? string5.substring(string5.lastIndexOf(".") + 1).toUpperCase() : "JPG";
            }
            if (string10.equals("MNU")) {
                string10 = "MENU";
            } else if (string10.equals("WRL") || string10.equals("VRML")) {
                string10 = "Vrml";
                bl4 = true;
            } else if (string10.equals("X3D")) {
                string10 = "X3d";
                bl4 = true;
            } else if (string10.equals("IDTF")) {
                string10 = "Idtf";
                bl4 = true;
            } else if (string10.equals("MA")) {
                string10 = "Maya";
                bl4 = true;
            } else if (string10.equals("JS")) {
                string10 = "Js";
                bl4 = true;
            } else if (string10.equals("OBJ")) {
                string10 = "Obj";
                bl4 = true;
            } else if (string10.equals("JVXL")) {
                string10 = "ISOSURFACE";
            } else if (string10.equals("XJVXL")) {
                string10 = "ISOSURFACE";
            } else if (string10.equals("JMOL")) {
                string10 = "ZIPALL";
            } else if (string10.equals("HIS")) {
                string10 = "HISTORY";
            }
            if (string10.equals("COORD")) {
                string10 = string5 != null && string5.indexOf(".") >= 0 ? string5.substring(string5.lastIndexOf(".") + 1).toUpperCase() : "XYZ";
            }
            bl5 = Parser.isOneOf(string10, "GIF;JPEG64;JPEG;JPG64;JPG;PPM;PNG;PNGJ;PNGT;SCENE");
            if (stringArray2 != null) {
                if (string10.equals("PNG")) {
                    string10 = "PNGJ";
                }
                if (!string10.equals("PNGJ") && !string10.equals("ZIPALL")) {
                    this.error(22);
                }
            }
            if (bl5 && bl) {
                string10 = "JPG64";
            } else if (!(bl5 || bl4 || Parser.isOneOf(string10, "SCENE;JMOL;ZIP;ZIPALL;SPT;HISTORY;MO;ISOSURFACE;MESH;PMESH;VAR;FILE;FUNCTION;CD;CML;XYZ;XYZRN;XYZVIB;MENU;MOL;PDB;PGRP;PQR;QUAT;RAMA;SDF;V2000;V3000;INLINE"))) {
                this.errorStr2(54, "COORDS|FILE|FUNCTIONS|HISTORY|IMAGE|INLINE|ISOSURFACE|JMOL|MENU|MO|POINTGROUP|QUATERNION [w,x,y,z] [derivative]|RAMACHANDRAN|SPT|STATE|VAR x|ZIP|ZIPALL  CLIPBOARD", "CML|GIF|JPG|JPG64|JMOL|JVXL|MESH|MOL|PDB|PMESH|PNG|PNGJ|PNGT|PPM|PQR|SDF|V2000|V3000|SPT|XJVXL|XYZ|XYZRN|XYZVIB|ZIP" + string.toUpperCase().replace(';', '|'));
            }
            if (this.chk) {
                return "";
            }
            object = null;
            boolean bl6 = false;
            if (string3 == null || bl4) {
                string3 = string10.intern();
                if (bl4) {
                    stringArray[0] = string5;
                    if ((string3 = this.viewer.generateOutputForExport(string3, (String[])(bl2 || string5 != null ? stringArray : null), n6, n7)) == null || string3.length() == 0) {
                        return "";
                    }
                    if (!bl2) {
                        return string3;
                    }
                    if ((string10.equals("Povray") || string10.equals("Idtf")) && stringArray[0] != null) {
                        String string12 = string10.equals("Idtf") ? ".tex" : ".ini";
                        string5 = stringArray[0] + string12;
                        string9 = this.viewer.createImageSet(string5, string12, string3, null, null, Integer.MIN_VALUE, 0, 0, null, 0, stringArray);
                        if (string10.equals("Idtf")) {
                            string3 = string3.substring(0, string3.indexOf("\\begin{comment}"));
                        }
                        string3 = "Created " + stringArray[0] + ":\n\n" + string3;
                    } else {
                        string9 = string3;
                    }
                    if (string9 != null) {
                        if (!string9.startsWith("OK")) {
                            this.evalError(string9, null);
                        }
                        this.scriptStatusOrBuffer(string3);
                    }
                    return "";
                }
                if (string3 == "MENU") {
                    string3 = this.viewer.getMenu("");
                } else if (string3 == "PGRP") {
                    string3 = this.viewer.getPointGroupAsString(string4.equals("draw"), null, 0, 1.0f);
                } else if (string3 == "PDB" || string3 == "PQR") {
                    if (bl) {
                        string3 = this.viewer.getPdbData(null, null);
                    } else {
                        bl6 = true;
                    }
                } else if (string3 == "FILE") {
                    if (bl) {
                        string3 = this.viewer.getCurrentFileAsString();
                    } else {
                        bl6 = true;
                    }
                    if ("?".equals(string5)) {
                        string5 = "?Jmol." + this.viewer.getParameter("_fileType");
                    }
                } else if ((string3 == "SDF" || string3 == "MOL" || string3 == "V2000" || string3 == "V3000" || string3 == "CD") && bl3) {
                    if ((string3 = this.viewer.getModelExtract("selected", true, false, string3)).startsWith("ERROR:")) {
                        object = string3;
                    }
                } else if (string3 == "XYZ" || string3 == "XYZRN" || string3 == "XYZVIB" || string3 == "MOL" || string3 == "SDF" || string3 == "V2000" || string3 == "V3000" || string3 == "CML" || string3 == "CD") {
                    if ((string3 = this.viewer.getData("selected", string3)).startsWith("ERROR:")) {
                        object = string3;
                    }
                } else if (string3 == "FUNCTION") {
                    string3 = this.viewer.getFunctionCalls(null);
                    string10 = "TXT";
                } else if (string3 == "VAR") {
                    string3 = ((SV)this.getParameter(SV.sValue(this.tokenAt(bl2 ? 2 : 1, tArray)), 1073742190)).asString();
                    string10 = "TXT";
                } else if (string3 == "SPT") {
                    if (bl3) {
                        BS bS2 = this.viewer.getTaintedAtoms((byte)2);
                        this.viewer.setAtomCoordsRelative(P3.new3(0.0f, 0.0f, 0.0f), null);
                        string3 = this.viewer.getStateInfo();
                        this.viewer.setTaintedAtoms(bS2, (byte)2);
                    } else {
                        string3 = this.viewer.getStateInfo();
                        if (string6 != null || string7 != null) {
                            string3 = FileManager.setScriptFileReferences(string3, string6, string7, null);
                        }
                    }
                } else if (string3 == "ZIP" || string3 == "ZIPALL") {
                    string3 = this.viewer.getStateInfo();
                    object = this.viewer.createZip(string5, string10, string3, stringArray2);
                } else if (string3 == "HISTORY") {
                    string3 = this.viewer.getSetHistory(Integer.MAX_VALUE);
                    string10 = "SPT";
                } else if (string3 == "MO") {
                    string3 = this.getMoJvxl(Integer.MAX_VALUE);
                    string10 = "XJVXL";
                } else if (string3 == "PMESH") {
                    string3 = this.getIsosurfaceJvxl(true, 28);
                    if (string3 == null) {
                        this.error(31);
                    }
                    string10 = "XJVXL";
                } else if (string3 == "ISOSURFACE" || string3 == "MESH") {
                    if ((string3 = this.getIsosurfaceJvxl(string3 == "MESH", 24)) == null) {
                        this.error(31);
                    }
                    String string13 = string10 = string3.indexOf("<?xml") >= 0 ? "XJVXL" : "JVXL";
                    if (!bl) {
                        this.showString((String)this.getShapeProperty(24, "jvxlFileInfo"));
                    }
                } else {
                    n4 = -1;
                    if (n8 < 0) {
                        n8 = -1;
                    }
                }
                if (string3 == null && !bl6) {
                    string3 = "";
                }
                if (n4 == 0 && !bl6) {
                    int n10 = object == null ? string3.length() : (n4 = object instanceof String ? ((String)object).length() : ((byte[])object).length);
                }
                if (bl5) {
                    this.refresh();
                    if (n6 < 0) {
                        n6 = this.viewer.getScreenWidth();
                    }
                    if (n7 < 0) {
                        n7 = this.viewer.getScreenHeight();
                    }
                }
            }
            if (!bl2) {
                return string3;
            }
            if (bl) {
                this.showStringPrint(string3, true);
                return "";
            }
            if (object != null && object instanceof String) {
                this.scriptStatusOrBuffer((String)object);
                return (String)object;
            }
            if (string10.equals("SCENE")) {
                object = string2;
            } else if (!(object != null || bl5 && string5 == null)) {
                object = string3;
            }
            string9 = bl6 ? this.viewer.streamFileData(string5, string10, string4, 0, null) : this.viewer.createImageSet(string5, string10, object instanceof String ? (String)object : null, object instanceof byte[] ? (byte[])object : null, stringArray2, n8, n6, n7, bS, n5, stringArray);
        }
        if (!this.chk && string9 != null) {
            if (!string9.startsWith("OK")) {
                this.evalError(string9, null);
            }
            this.scriptStatusOrBuffer(string9 + (bl5 ? "; width=" + n6 + "; height=" + n7 : ""));
            return string9;
        }
        return "";
    }

    private void show() throws ScriptException {
        int n;
        String string = null;
        String string2 = this.parameterAsString(1);
        String string3 = null;
        String string4 = null;
        int n2 = 2;
        T t = this.getToken(1);
        int n3 = n = t instanceof SV ? 0 : t.tok;
        if (n == 4 && (t = T.getTokenFromName(string2.toLowerCase())) != null) {
            n = t.tok;
        }
        if (n != 1297090050 && n != 1073742158) {
            this.checkLength(-3);
        }
        if (this.slen == 2 && string2.indexOf("?") >= 0) {
            this.showString(this.viewer.getAllSettings(string2.substring(0, string2.indexOf("?"))));
            return;
        }
        block0 : switch (n) {
            case 0: {
                if (this.chk) break;
                string3 = ((SV)this.theToken).escape();
                break;
            }
            case 135270422: {
                if (this.chk) break;
                string3 = Escape.e(this.viewer.cacheList());
                break;
            }
            case 1073741915: {
                this.checkLength(2);
                if (this.chk) break;
                string3 = this.viewer.calculateStructures(null, true, false);
                break;
            }
            case 545259570: {
                this.checkLength(2);
                if (this.chk) break;
                string3 = this.viewer.getPathForAllFiles();
                break;
            }
            case 135267336: 
            case 1073741879: 
            case 1073741929: 
            case 1073742038: {
                this.checkLength(n == 1073741879 ? 3 : 2);
                if (this.chk) {
                    return;
                }
                string3 = this.viewer.getSmiles(0, 0, this.viewer.getSelectionSet(false), false, true, false, false);
                switch (n) {
                    case 1073741929: {
                        if (string3.length() > 0) {
                            this.viewer.show2D(string3);
                            return;
                        }
                        string3 = "Could not show drawing -- Either insufficient atoms are selected or the model is a PDB file.";
                        break;
                    }
                    case 1073742038: {
                        if (string3.length() > 0) {
                            this.viewer.showNMR(string3);
                            return;
                        }
                        string3 = "Could not show nmr -- Either insufficient atoms are selected or the model is a PDB file.";
                        break;
                    }
                    case 1073741879: {
                        n2 = 3;
                        String string5 = null;
                        if (string3.length() > 0) {
                            char c = '/';
                            switch (this.getToken((int)2).tok) {
                                case 0x40000099: {
                                    c = 'I';
                                    break;
                                }
                                case 1073741978: {
                                    c = 'K';
                                    break;
                                }
                                case 1073742035: {
                                    c = 'N';
                                    break;
                                }
                                default: {
                                    string5 = this.parameterAsString(2);
                                }
                            }
                            string3 = this.viewer.getChemicalInfo(string3, c, string5);
                            if (string3.indexOf("FileNotFound") < 0) break block0;
                            string3 = "?";
                            break;
                        }
                        string3 = "Could not show name -- Either insufficient atoms are selected or the model is a PDB file.";
                    }
                }
                break;
            }
            case 1297090050: {
                int n4;
                if (this.slen > 3) {
                    P3 p3 = this.centerParameter(2);
                    P3 p32 = this.centerParameter(++this.iToken);
                    if (!this.chk) {
                        string3 = this.viewer.getSymmetryOperation(null, 0, p3, p32, false);
                    }
                    n2 = ++this.iToken;
                    break;
                }
                int n5 = n4 = this.checkLength23() == 2 ? 0 : this.intParameter(2);
                if (!this.chk) {
                    string3 = this.viewer.getSymmetryOperation(null, n4, null, null, false);
                }
                n2 = -3;
                break;
            }
            case 1649412112: {
                EnumVdw enumVdw = null;
                if (this.slen > 2 && (enumVdw = EnumVdw.getVdwType(this.parameterAsString(2))) == null) {
                    this.error(22);
                }
                if (!this.chk) {
                    this.showString(this.viewer.getDefaultVdwTypeNameOrData(0, enumVdw));
                }
                return;
            }
            case 135368713: {
                this.checkLength23();
                if (!this.chk) {
                    this.showString(this.viewer.getFunctionCalls(this.optParameterAsString(2)));
                }
                return;
            }
            case 1085443: {
                this.checkLength(2);
                if (!this.chk) {
                    this.showString(this.viewer.getAllSettings(null));
                }
                return;
            }
            case 1074790760: {
                n2 = this.slen;
                if (n2 == 2) {
                    if (!this.chk) {
                        this.viewer.showUrl(this.getFullPathName());
                    }
                    return;
                }
                string4 = this.parameterAsString(2);
                if (!this.chk) {
                    this.viewer.showUrl(string4);
                }
                return;
            }
            case 1766856708: {
                string2 = "defaultColorScheme";
                break;
            }
            case 0x60000004: {
                string2 = "scaleAngstromsPerInch";
                break;
            }
            case 1052714: 
            case 0x8101011: {
                if (this.chk) {
                    return;
                }
                int n6 = this.viewer.getCurrentModelIndex();
                if (n6 < 0) {
                    this.errorStr(30, "show " + this.theToken.value);
                }
                string3 = this.plot(this.st);
                n2 = this.slen;
                break;
            }
            case 1113200654: {
                if (this.chk) break;
                string3 = this.getContext(false);
                break;
            }
            case 0x40000040: {
                string4 = this.optParameterAsString(2);
                if (string4.length() > 0) {
                    n2 = 3;
                }
                if (this.chk) break;
                string = this.viewer.getColorSchemeList(string4);
                break;
            }
            case 1073742192: {
                if (this.chk) break;
                string3 = this.viewer.getAtomDefs(this.definedAtomSets) + this.viewer.getVariableList() + this.getContext(true);
                break;
            }
            case 0x2000000E: {
                if (this.chk) break;
                string3 = this.viewer.getTrajectoryState();
                break;
            }
            case 553648148: {
                string = "" + this.commandHistoryLevelMax;
                break;
            }
            case 553648150: {
                string = "" + Logger.getLogLevel();
                break;
            }
            case 603979824: {
                string = "" + this.viewer.getBoolean(603979824);
                break;
            }
            case 553648178: {
                string3 = "set strandCountForStrands " + this.viewer.getStrandCount(12) + "; set strandCountForMeshRibbon " + this.viewer.getStrandCount(13);
                break;
            }
            case 536875070: {
                n2 = this.slen;
                string3 = this.viewer.showTimeout(n2 == 2 ? null : this.parameterAsString(2));
                break;
            }
            case 0x20000006: {
                string = Escape.eP(this.viewer.getDefaultLattice());
                break;
            }
            case 4126: {
                if (this.chk) break;
                string3 = this.viewer.getMinimizationInfo();
                break;
            }
            case 1611272194: {
                switch (this.viewer.getAxesMode()) {
                    case UNITCELL: {
                        string3 = "set axesUnitcell";
                        break block0;
                    }
                    case BOUNDBOX: {
                        string3 = "set axesWindow";
                        break block0;
                    }
                }
                string3 = "set axesMolecular";
                break;
            }
            case 0x60000001: {
                string3 = "set bondMode " + (this.viewer.getBoolean(0x24000024) ? "OR" : "AND");
                break;
            }
            case 1650071565: {
                if (this.chk) break;
                string3 = "set strandCountForStrands " + this.viewer.getStrandCount(12) + "; set strandCountForMeshRibbon " + this.viewer.getStrandCount(13);
                break;
            }
            case 1612189718: {
                string3 = "set hbondsBackbone " + this.viewer.getBoolean(603979852) + ";set hbondsSolid " + this.viewer.getBoolean(603979854);
                break;
            }
            case 1611141175: {
                if (this.chk) break;
                string3 = this.viewer.getSpinState();
                break;
            }
            case 1611141176: {
                string3 = "set ssbondsBackbone " + this.viewer.getBoolean(603979952);
                break;
            }
            case 1610625028: 
            case 1611141171: {
                string3 = "selectionHalos " + (this.viewer.getSelectionHaloEnabled(false) ? "ON" : "OFF");
                break;
            }
            case 0x60300006: {
                string3 = "set selectHetero " + this.viewer.getBoolean(0x60300006);
                break;
            }
            case 0x40000004: {
                string3 = Escape.eAP(this.viewer.getAdditionalHydrogens(null, true, true, null));
                break;
            }
            case 1613758476: {
                string3 = "set selectHydrogens " + this.viewer.getBoolean(1613758476);
                break;
            }
            case 0x2000000C: 
            case 0x21000002: 
            case 553648142: 
            case 553648172: 
            case 553648176: 
            case 1073741995: {
                if (this.chk) break;
                string3 = this.viewer.getSpecularState();
                break;
            }
            case 4146: {
                if (this.chk) break;
                string3 = this.viewer.listSavedStates();
                break;
            }
            case 1614417948: {
                if (this.chk) break;
                string3 = this.viewer.getUnitCellInfoText();
                break;
            }
            case 0x100006: {
                n2 = this.slen;
                if (n2 == 2) {
                    if (this.chk) break;
                    string3 = this.viewer.getCoordinateState(this.viewer.getSelectionSet(false));
                    break;
                }
                String string6 = this.parameterAsString(2);
                if (this.chk) break;
                string3 = this.viewer.getSavedCoordinates(string6);
                break;
            }
            case 1073742158: {
                if (!this.chk) {
                    this.viewer.clearConsole();
                }
                if ((n2 = this.slen) == 2) {
                    if (this.chk) break;
                    string3 = this.viewer.getStateInfo();
                    break;
                }
                string4 = this.parameterAsString(2);
                if (string4.equals("/") && (n2 = this.slen) == 4) {
                    string4 = this.parameterAsString(3).toLowerCase();
                    if (this.chk) break;
                    String[] stringArray = TextFormat.split(this.viewer.getStateInfo(), '\n');
                    SB sB = new SB();
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i].toLowerCase().indexOf(string4) < 0) continue;
                        sB.append(stringArray[i]).appendC('\n');
                    }
                    string3 = sB.toString();
                    break;
                }
                if (this.tokAt(2) == 1229984263 && (n2 = this.slen) == 4) {
                    if (this.chk) break;
                    string3 = this.viewer.getEmbeddedFileState(this.parameterAsString(3));
                    break;
                }
                n2 = 3;
                if (this.chk) break;
                string3 = this.viewer.getSavedState(string4);
                break;
            }
            case 1641025539: {
                n2 = this.slen;
                if (n2 == 2) {
                    if (this.chk) break;
                    string3 = this.viewer.getProteinStructureState();
                    break;
                }
                String string7 = this.parameterAsString(2);
                if (this.chk) break;
                string3 = this.viewer.getSavedStructure(string7);
                break;
            }
            case 135270407: {
                String string8;
                n2 = this.slen;
                String string9 = string8 = n2 == 3 ? this.parameterAsString(2) : null;
                if (this.chk) break;
                Object[] objectArray = string8 == null ? this.data : this.viewer.getData(string8);
                string3 = objectArray == null ? "no data" : Escape.encapsulateData((String)objectArray[0], objectArray[1], (Integer)objectArray[3]);
                break;
            }
            case 1073742152: {
                Map<String, Object> map = null;
                n2 = this.slen;
                if (n2 == 2) {
                    if (!this.chk) {
                        map = this.viewer.getSpaceGroupInfo(null);
                    }
                } else {
                    String string10 = this.parameterAsString(2);
                    if (!this.chk) {
                        map = this.viewer.getSpaceGroupInfo(TextFormat.simpleReplace(string10, "''", "\""));
                    }
                }
                if (map == null) break;
                string3 = "" + map.get("spaceGroupInfo") + map.get("symmetryInfo");
                break;
            }
            case 0x100007: {
                n2 = 3;
                string3 = this.setObjectProperty();
                break;
            }
            case 1679429641: {
                if (this.chk) break;
                string3 = this.viewer.getBoundBoxCommand(true);
                break;
            }
            case 12289: {
                if (this.chk) break;
                string3 = "center " + Escape.eP(this.viewer.getRotationCenter());
                break;
            }
            case 135176: {
                if (this.chk) break;
                string3 = (String)this.getShapeProperty(22, "command");
                break;
            }
            case 1229984263: {
                if (!this.chk) {
                    this.viewer.clearConsole();
                }
                if (this.slen == 2) {
                    if (!this.chk) {
                        string3 = this.viewer.getCurrentFileAsString();
                    }
                    if (string3 != null) break;
                    string3 = "<unavailable>";
                    break;
                }
                n2 = 3;
                string = this.parameterAsString(2);
                if (this.chk) break;
                string3 = this.viewer.getFileAsString(string);
                break;
            }
            case 4115: {
                if (this.tokAt(2) == 0x100003) {
                    n2 = 3;
                    if (3 > 0) {
                        string3 = this.viewer.getModelFileInfoAll();
                        break;
                    }
                }
                string3 = this.viewer.getModelFileInfo();
                break;
            }
            case 1610616855: {
                int n7;
                n2 = this.slen;
                int n8 = n7 = n2 == 2 ? Integer.MAX_VALUE : this.intParameter(2);
                if (n7 < 1) {
                    this.error(22);
                }
                if (this.chk) break;
                this.viewer.clearConsole();
                if (this.scriptLevel == 0) {
                    this.viewer.removeCommand();
                }
                string3 = this.viewer.getSetHistory(n7);
                break;
            }
            case 135180: {
                if (this.chk) break;
                string3 = (String)this.getShapeProperty(24, "jvxlDataXml");
                break;
            }
            case 0x121012: {
                int n9;
                if (this.optParameterAsString(2).equalsIgnoreCase("list")) {
                    string3 = this.viewer.getMoInfo(-1);
                    n2 = 3;
                    break;
                }
                n2 = this.slen;
                int n10 = n9 = n2 == 2 ? Integer.MIN_VALUE : this.intParameter(2);
                if (this.chk) break;
                string3 = this.getMoJvxl(n9);
                break;
            }
            case 1095766028: {
                if (this.chk) break;
                string3 = this.viewer.getModelInfoAsString();
                break;
            }
            case 0x20021010: {
                if (this.chk) break;
                string3 = this.viewer.getMeasurementInfoAsString();
                break;
            }
            case 4130: 
            case 1073742132: 
            case 1073742178: {
                if (this.chk) break;
                string3 = this.viewer.getOrientationText(n, null);
                break;
            }
            case 1073742077: {
                n2 = 2;
                if (this.slen > 3) break;
                n = this.tokAt(2);
                switch (n) {
                    case 0: 
                    case 4130: 
                    case 1073742132: 
                    case 1073742178: {
                        if (this.chk) break;
                        string3 = this.viewer.getOrientationText(n, null);
                        break;
                    }
                    default: {
                        string4 = this.optParameterAsString(2);
                        string3 = this.viewer.getOrientationText(0, string4);
                    }
                }
                n2 = this.slen;
                break;
            }
            case 1073742088: {
                if (this.chk) break;
                string3 = this.viewer.getPDBHeader();
                break;
            }
            case 1073742102: {
                this.pointGroup();
                return;
            }
            case 1089470478: {
                if (this.chk) break;
                string3 = this.viewer.getSymmetryInfoAsString();
                break;
            }
            case 1073742176: {
                if (this.chk) break;
                string3 = "transform:\n" + this.viewer.getTransformText();
                break;
            }
            case 4168: {
                string3 = "zoom " + (this.viewer.getZoomEnabled() ? "" + this.viewer.getZoomSetting() : "off");
                break;
            }
            case 1611272202: {
                string3 = this.viewer.getShowFrank() ? "frank ON" : "frank OFF";
                break;
            }
            case 1666189314: {
                string2 = "solventProbeRadius";
                break;
            }
            case 1073741864: 
            case 1073741982: 
            case 1073742120: 
            case 0x40D00004: 
            case 1087373318: 
            case 1087373320: 
            case 1114638350: 
            case 0x44100001: {
                string3 = this.viewer.getChimeInfo(n);
                break;
            }
            case 20482: 
            case 537022465: 
            case 0x60000002: 
            case 1613758488: 
            case 1716520973: {
                string = "?";
                break;
            }
            case 0x40000000: {
                String string11;
                if (string2.equalsIgnoreCase("fileHeader")) {
                    if (this.chk) break;
                    string3 = this.viewer.getPDBHeader();
                    break;
                }
                if (string2.equalsIgnoreCase("menu")) {
                    if (this.chk) break;
                    string = this.viewer.getMenu("");
                    break;
                }
                if (!string2.equalsIgnoreCase("mouse")) break;
                n2 = this.slen;
                String string12 = string11 = n2 == 2 ? null : this.parameterAsString(2);
                if (this.chk) break;
                string3 = this.viewer.getBindingInfo(string11);
            }
        }
        this.checkLength(n2);
        if (this.chk) {
            return;
        }
        if (string3 != null) {
            this.showString(string3);
        } else if (string != null) {
            this.showString(string2 + " = " + string);
        } else if (string2 != null) {
            if (string2.indexOf(" ") >= 0) {
                this.showString(string2);
            } else {
                this.showString(string2 + " = " + this.getParameterEscaped(string2));
            }
        }
    }

    private String getIsosurfaceJvxl(boolean bl, int n) {
        if (this.chk) {
            return "";
        }
        return (String)this.getShapeProperty(n, bl ? "jvxlMeshX" : "jvxlDataXml");
    }

    private String getMoJvxl(int n) throws ScriptException {
        Integer n2;
        Map map;
        this.sm.loadShape(27);
        int n3 = this.viewer.getCurrentModelIndex();
        if (n3 < 0) {
            this.errorStr(30, "MO isosurfaces");
        }
        if ((map = (Map)this.viewer.getModelAuxiliaryInfoValue(n3, "moData")) == null) {
            this.error(27);
        }
        if ((n2 = (Integer)this.getShapeProperty(27, "moNumber")) == null || n2 == 0) {
            this.setShapeProperty(27, "init", n3);
        } else if (n == Integer.MAX_VALUE) {
            // empty if block
        }
        this.setShapeProperty(27, "moData", map);
        return (String)this.getShapePropertyIndex(27, "showMO", n);
    }

    private void cgo() throws ScriptException {
        this.sm.loadShape(23);
        if (this.tokAt(1) == 1073742001 && this.listIsosurface(23)) {
            return;
        }
        int n = 0;
        String string = this.initIsosurface(23);
        boolean bl = string != null;
        boolean bl2 = bl && this.getShapeProperty(23, "ID") == null;
        boolean bl3 = false;
        boolean bl4 = false;
        float[] fArray = null;
        float f = Float.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = 0;
        block10: for (int i = this.iToken; i < this.slen; ++i) {
            String string2 = null;
            Integer n4 = null;
            switch (this.getToken((int)i).tok) {
                case 7: 
                case 0x10100040: 
                case 1073742195: {
                    if (fArray != null || bl2) {
                        this.error(22);
                    }
                    fArray = this.floatParameterSet(i, 2, Integer.MAX_VALUE);
                    i = this.iToken;
                    continue block10;
                }
                case 1073742138: {
                    if (++i >= this.slen) {
                        this.error(34);
                    }
                    switch (this.getToken((int)i).tok) {
                        case 2: {
                            n3 = this.intParameter(i);
                            continue block10;
                        }
                        case 3: {
                            n3 = Math.round(this.floatParameter(i) * 100.0f);
                            continue block10;
                        }
                        default: {
                            this.error(34);
                            break;
                        }
                    }
                    break;
                }
                case 1073742074: 
                case 1073742180: 
                case 1766856708: {
                    if (this.theTok != 1766856708) {
                        --i;
                    }
                    if (this.tokAt(i + 1) == 1073742180) {
                        bl3 = true;
                        if (this.isFloatParameter(++i + 1)) {
                            f = this.getTranslucentLevel(++i);
                        }
                    } else if (this.tokAt(i + 1) == 1073742074) {
                        ++i;
                        bl3 = true;
                        f = 0.0f;
                    }
                    if (this.isColorParam(i + 1)) {
                        n2 = this.getArgbParam(++i);
                        i = this.iToken;
                    } else if (!bl3) {
                        this.error(22);
                    }
                    bl = true;
                    continue block10;
                }
                case 1074790550: {
                    string = this.setShapeId(23, ++i, bl);
                    bl2 = this.getShapeProperty(23, "ID") == null;
                    i = this.iToken;
                    break;
                }
                default: {
                    if (!this.setMeshDisplayProperty(23, 0, this.theTok)) {
                        if (this.theTok == 0x101000B1 || T.tokAttr(this.theTok, 0x40000000)) {
                            string = this.setShapeId(23, i, bl);
                            i = this.iToken;
                            break;
                        }
                        this.error(22);
                    }
                    if (n == 0) {
                        n = i;
                    }
                    i = this.iToken;
                    continue block10;
                }
            }
            boolean bl5 = bl = this.theTok != 12291;
            if (fArray != null && !bl4) {
                string2 = "points";
                n4 = n3;
                bl4 = true;
                n3 = 0;
            }
            if (string2 == null) continue;
            this.setShapeProperty(23, string2, n4);
        }
        this.finalizeObject(23, n2, bl3 ? f : Float.MAX_VALUE, n3, true, fArray, n);
    }

    private void finalizeObject(int n, int n2, float f, int n3, boolean bl, Object object, int n4) throws ScriptException {
        if (bl) {
            this.setShapeProperty(n, "set", object);
        }
        if (n2 != Integer.MIN_VALUE) {
            this.setShapeProperty(n, "color", n2);
        }
        if (f != Float.MAX_VALUE) {
            this.setShapeTranslucency(n, "", "translucent", f, null);
        }
        if (n3 != 0) {
            this.setShapeProperty(n, "scale", n3);
        }
        if (n4 > 0 && !this.setMeshDisplayProperty(n, n4, 0)) {
            this.error(22);
        }
    }

    private void draw() throws ScriptException {
        this.sm.loadShape(22);
        switch (this.tokAt(1)) {
            case 1073742001: {
                if (!this.listIsosurface(22)) break;
                return;
            }
            case 1073742102: {
                this.pointGroup();
                return;
            }
            case 1052714: 
            case 0x8101011: 
            case 137363468: {
                this.plot(this.st);
                return;
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n = 0;
        float f = Float.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = 0;
        String string = "";
        int n4 = 0;
        P3 p3 = null;
        String string2 = this.initIsosurface(22);
        boolean bl7 = string2 != null;
        boolean bl8 = bl7 && this.getShapeProperty(22, "ID") == null;
        int[] nArray = null;
        int n5 = 0;
        block70: for (int i = this.iToken; i < this.slen; ++i) {
            String string3 = null;
            Object object = null;
            block5 : switch (this.getToken((int)i).tok) {
                case 1614417948: 
                case 1679429641: {
                    if (this.chk) break;
                    JmolList<Object> jmolList = this.viewer.getPlaneIntersection(this.theTok, null, (float)n3 / 100.0f, 0);
                    n3 = 0;
                    string3 = "polygon";
                    object = jmolList;
                    bl = true;
                    break;
                }
                case 4106: {
                    nArray = new int[4];
                    n5 = 4;
                    float[] fArray = this.floatParameterSet(++i, 4, 4);
                    i = this.iToken;
                    for (int j = 0; j < 4; ++j) {
                        nArray[j] = (int)fArray[j];
                    }
                    bl = true;
                    break;
                }
                case 0x44100001: 
                case 1678770178: {
                    if (nArray == null || n5 > (this.theTok == 1095761924 ? 2 : 3)) {
                        n5 = 0;
                        nArray = new int[]{-1, -1, -1, -1};
                    }
                    nArray[n5++] = this.atomExpressionAt(++i).nextSetBit(0);
                    i = this.iToken;
                    nArray[n5++] = this.theTok == 1678770178 ? this.atomExpressionAt(++i).nextSetBit(0) : -1;
                    i = this.iToken;
                    bl = true;
                    break;
                }
                case 554176565: {
                    switch (this.getToken((int)(++i)).tok) {
                        case 0x100007: {
                            string3 = "slab";
                            object = this.objectNameParameter(++i);
                            i = this.iToken;
                            bl = true;
                            break block5;
                        }
                    }
                    this.error(22);
                    break;
                }
                case 135267842: {
                    switch (this.getToken((int)(++i)).tok) {
                        case 1614417948: 
                        case 1679429641: {
                            n = this.theTok;
                            bl5 = true;
                            continue block70;
                        }
                        case 0x100007: {
                            string3 = "intersect";
                            object = this.objectNameParameter(++i);
                            i = this.iToken;
                            bl5 = true;
                            bl = true;
                            break;
                        }
                        default: {
                            this.error(22);
                            break;
                        }
                    }
                    break;
                }
                case 1073742106: {
                    string3 = "polygon";
                    bl = true;
                    JmolList<Object> jmolList = new JmolList<Object>();
                    int n6 = 0;
                    int n7 = 0;
                    P3[] p3Array = null;
                    JmolList<SV> jmolList2 = null;
                    if (this.isArrayParameter(++i)) {
                        p3Array = this.getPointArray(i, -1);
                        n6 = p3Array.length;
                    } else {
                        n6 = Math.max(0, this.intParameter(i));
                        p3Array = new P3[n6];
                        for (int j = 0; j < n6; ++j) {
                            p3Array[j] = this.centerParameter(++this.iToken);
                        }
                    }
                    switch (this.getToken((int)(++this.iToken)).tok) {
                        case 11: 
                        case 12: {
                            SV sV = SV.newScriptVariableToken(this.theToken);
                            sV.toArray();
                            jmolList2 = sV.getList();
                            n7 = jmolList2.size();
                            break;
                        }
                        case 7: {
                            jmolList2 = ((SV)this.theToken).getList();
                            n7 = jmolList2.size();
                            break;
                        }
                        default: {
                            n7 = Math.max(0, this.intParameter(this.iToken));
                        }
                    }
                    int[][] nArray2 = ArrayUtil.newInt2(n7);
                    for (int j = 0; j < n7; ++j) {
                        float[] fArray;
                        float[] fArray2 = fArray = jmolList2 == null ? this.floatParameterSet(++this.iToken, 3, 4) : SV.flistValue((T)jmolList2.get(j), 0);
                        if (fArray.length < 3 || fArray.length > 4) {
                            this.error(22);
                        }
                        nArray2[j] = new int[]{(int)fArray[0], (int)fArray[1], (int)fArray[2], fArray.length == 3 ? 7 : (int)fArray[3]};
                    }
                    if (n6 > 0) {
                        jmolList.addLast(p3Array);
                        jmolList.addLast(nArray2);
                    } else {
                        jmolList = null;
                    }
                    object = jmolList;
                    i = this.iToken;
                    break;
                }
                case 1297090050: {
                    String string4 = null;
                    int n8 = 0;
                    P4 p4 = null;
                    P3 p32 = null;
                    switch (this.tokAt(++i)) {
                        case 4: {
                            string4 = this.stringParameter(i);
                            break;
                        }
                        case 12: {
                            string4 = SV.sValue(this.getToken(i));
                            break;
                        }
                        default: {
                            if (!this.isCenterParameter(i)) {
                                n8 = this.intParameter(i++);
                            }
                            if (this.isCenterParameter(i)) {
                                p3 = this.centerParameter(i);
                            }
                            if (this.isCenterParameter(this.iToken + 1)) {
                                p32 = this.centerParameter(++this.iToken);
                            }
                            if (this.chk) {
                                return;
                            }
                            i = this.iToken;
                        }
                    }
                    BS bS = null;
                    if (p3 == null && i + 1 < this.slen) {
                        p3 = this.centerParameter(++i);
                        bS = this.tokAt(i) == 10 || this.tokAt(i) == 0x100001 ? this.atomExpressionAt(i) : null;
                        i = this.iToken + 1;
                    }
                    this.checkLast(this.iToken);
                    if (!this.chk) {
                        this.runScript((String)this.viewer.getSymmetryInfo(bS, string4, n8, p3, p32, string2, 135176));
                    }
                    return;
                }
                case 4115: {
                    bl6 = true;
                    continue block70;
                }
                case 8: 
                case 9: 
                case 0x10000A: {
                    if (this.theTok == 9 || !this.isPoint3f(i)) {
                        object = this.getPoint4f(i);
                        if (bl6) {
                            this.checkLast(this.iToken);
                            if (!this.chk) {
                                this.runScript(Quaternion.newP4((P4)object).draw(string2 == null ? "frame" : string2, " " + string, p3 == null ? new P3() : p3, (float)n3 / 100.0f));
                            }
                            return;
                        }
                        string3 = "planedef";
                    } else {
                        p3 = this.getPoint3f(i, true);
                        object = p3;
                        string3 = "coord";
                    }
                    i = this.iToken;
                    bl = true;
                    break;
                }
                case 135266319: 
                case 135267841: {
                    Serializable serializable;
                    if (!bl && !bl5 && n == 0 && this.theTok != 135267841) {
                        string3 = "plane";
                        break;
                    }
                    P4 p4 = this.theTok == 135266319 ? this.planeParameter(++i) : this.hklParameter(++i);
                    i = this.iToken;
                    if (n != 0) {
                        if (this.chk) break;
                        serializable = this.viewer.getPlaneIntersection(n, p4, (float)n3 / 100.0f, 0);
                        n3 = 0;
                        string3 = "polygon";
                        object = serializable;
                    } else {
                        object = p4;
                        string3 = "planedef";
                    }
                    bl = true;
                    break;
                }
                case 0x400000B0: {
                    string3 = "lineData";
                    object = this.floatParameterSet(++i, 0, Integer.MAX_VALUE);
                    i = this.iToken;
                    bl = true;
                    break;
                }
                case 10: 
                case 0x100001: {
                    string3 = "atomSet";
                    object = this.atomExpressionAt(i);
                    if (bl6) {
                        p3 = this.centerParameter(i);
                    }
                    i = this.iToken;
                    bl = true;
                    break;
                }
                case 7: {
                    string3 = "modelBasedPoints";
                    object = SV.listValue(this.theToken);
                    bl = true;
                    break;
                }
                case 0x10100030: 
                case 1073742195: {
                    break;
                }
                case 0x10100040: {
                    object = this.xypParameter(i);
                    if (object != null) {
                        i = this.iToken;
                        string3 = "coord";
                        bl = true;
                        break;
                    }
                    if (bl3) {
                        this.error(22);
                    }
                    bl3 = true;
                    break;
                }
                case 0x10100041: {
                    if (!bl3) {
                        this.error(22);
                    }
                    bl3 = false;
                    break;
                }
                case 1141899269: {
                    string3 = "reverse";
                    break;
                }
                case 4: {
                    object = this.stringParameter(i);
                    string3 = "title";
                    break;
                }
                case 135198: {
                    string3 = "vector";
                    break;
                }
                case 1141899267: {
                    object = Float.valueOf(this.floatParameter(++i));
                    string3 = "length";
                    break;
                }
                case 3: {
                    object = Float.valueOf(this.floatParameter(i));
                    string3 = "length";
                    break;
                }
                case 1095761933: {
                    string3 = "modelIndex";
                    object = this.intParameter(++i);
                    break;
                }
                case 2: {
                    if (bl3) {
                        string3 = "modelIndex";
                        object = this.intParameter(i);
                        break;
                    }
                    n3 = this.intParameter(i);
                    break;
                }
                case 1073742138: {
                    if (++i >= this.slen) {
                        this.error(34);
                    }
                    switch (this.getToken((int)i).tok) {
                        case 2: {
                            n3 = this.intParameter(i);
                            continue block70;
                        }
                        case 3: {
                            n3 = Math.round(this.floatParameter(i) * 100.0f);
                            continue block70;
                        }
                        default: {
                            this.error(34);
                            break;
                        }
                    }
                    break;
                }
                case 1074790550: {
                    string2 = this.setShapeId(22, ++i, bl7);
                    bl8 = this.getShapeProperty(22, "ID") == null;
                    i = this.iToken;
                    break;
                }
                case 0x400000CC: {
                    string3 = "fixed";
                    object = Boolean.FALSE;
                    break;
                }
                case 1060869: {
                    string3 = "fixed";
                    object = Boolean.TRUE;
                    break;
                }
                case 1073742066: {
                    Serializable serializable = this.getPoint3f(++i, true);
                    i = this.iToken;
                    string3 = "offset";
                    object = serializable;
                    break;
                }
                case 1073741906: {
                    string3 = "crossed";
                    break;
                }
                case 1073742196: {
                    object = Float.valueOf(this.floatParameter(++i));
                    string3 = "width";
                    string = string3 + " " + object;
                    break;
                }
                case 1073741998: {
                    string3 = "line";
                    object = Boolean.TRUE;
                    break;
                }
                case 0x40000054: {
                    string3 = "curve";
                    break;
                }
                case 0x40100010: {
                    string3 = "arc";
                    break;
                }
                case 1073741846: {
                    string3 = "arrow";
                    break;
                }
                case 1073741880: {
                    string3 = "circle";
                    break;
                }
                case 1073741912: {
                    string3 = "cylinder";
                    break;
                }
                case 1073742194: {
                    string3 = "vertices";
                    break;
                }
                case 0x400000E0: {
                    string3 = "nohead";
                    break;
                }
                case 1073741861: {
                    string3 = "isbarb";
                    break;
                }
                case 1073742130: {
                    string3 = "rotate45";
                    break;
                }
                case 1073742092: {
                    string3 = "perp";
                    break;
                }
                case 1073741916: 
                case 1666189314: {
                    boolean bl9 = this.theTok == 1666189314;
                    float f2 = this.floatParameter(++i);
                    if (bl9) {
                        f2 *= 2.0f;
                    }
                    object = Float.valueOf(f2);
                    string3 = bl9 || this.tokAt(i) == 3 ? "width" : "diameter";
                    string = string3 + (this.tokAt(i) == 3 ? " " + f2 : " " + (int)f2);
                    break;
                }
                case 0x100007: {
                    if (this.tokAt(i + 2) == 0x10100040 || bl6) {
                        P3 p33 = p3 = this.centerParameter(i);
                        i = this.iToken;
                        string3 = "coord";
                        object = p33;
                        bl = true;
                        break;
                    }
                    object = this.objectNameParameter(++i);
                    string3 = "identifier";
                    bl = true;
                    break;
                }
                case 1073742074: 
                case 1073742180: 
                case 1766856708: {
                    if (this.theTok != 1766856708) {
                        --i;
                    }
                    if (this.tokAt(i + 1) == 1073742180) {
                        bl4 = true;
                        if (this.isFloatParameter(++i + 1)) {
                            f = this.getTranslucentLevel(++i);
                        }
                    } else if (this.tokAt(i + 1) == 1073742074) {
                        ++i;
                        bl4 = true;
                        f = 0.0f;
                    }
                    if (this.isColorParam(i + 1)) {
                        n2 = this.getArgbParam(++i);
                        i = this.iToken;
                    } else if (!bl4) {
                        this.error(22);
                    }
                    bl7 = true;
                    continue block70;
                }
                default: {
                    if (!this.setMeshDisplayProperty(22, 0, this.theTok)) {
                        if (this.theTok == 0x101000B1 || T.tokAttr(this.theTok, 0x40000000)) {
                            string2 = this.setShapeId(22, i, bl7);
                            i = this.iToken;
                            break;
                        }
                        this.error(22);
                    }
                    if (n4 == 0) {
                        n4 = i;
                    }
                    i = this.iToken;
                    continue block70;
                }
            }
            boolean bl10 = bl7 = this.theTok != 12291;
            if (bl && !bl2 && !bl6) {
                this.setShapeProperty(22, "points", n3);
                bl2 = true;
                n3 = 0;
            }
            if (bl && bl8) {
                this.error(22);
            }
            if (string3 == null) continue;
            this.setShapeProperty(22, string3, object);
        }
        this.finalizeObject(22, n2, bl4 ? f : Float.MAX_VALUE, n3, bl, nArray, n4);
    }

    private void polyhedra() throws ScriptException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n = 0;
        int n2 = 0;
        this.sm.loadShape(21);
        this.setShapeProperty(21, "init", null);
        String string = "centers";
        String string2 = "radius_";
        boolean bl6 = false;
        float f = Float.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        block15: for (int i = 1; i < this.slen; ++i) {
            String string3 = null;
            Object object = null;
            switch (this.getToken((int)i).tok) {
                case 12291: 
                case 0x10000C: 
                case 0x10000D: {
                    if (i + 1 != this.slen || bl || n2 > 1 || n2 == 0 && "to".equals(string)) {
                        this.error(18);
                    }
                    string3 = this.theTok == 0x10000C ? "off" : (this.theTok == 0x10000D ? "on" : "delete");
                    bl2 = true;
                    break;
                }
                case 0x10100030: 
                case 269484436: {
                    continue block15;
                }
                case 1678770178: {
                    if (n2 > 0) {
                        this.error(23);
                    }
                    bl = true;
                    string3 = "bonds";
                    break;
                }
                case 1666189314: {
                    string2 = "radius";
                    continue block15;
                }
                case 2: 
                case 3: {
                    if (n2 > 0 && !bl5) {
                        this.error(23);
                    }
                    if (this.theTok == 2 && string2 == "radius_") {
                        string3 = "nVertices";
                        object = this.intParameter(i);
                        bl = true;
                        break;
                    }
                    string3 = string2 == "radius_" ? "radius" : string2;
                    object = Float.valueOf(this.floatParameter(i));
                    string2 = "radius_";
                    bl5 = false;
                    bl = true;
                    break;
                }
                case 10: 
                case 0x100001: {
                    if (bl3) {
                        this.error(23);
                    }
                    if (++n2 > 2) {
                        this.error(2);
                    }
                    if ("to".equals(string)) {
                        bl = true;
                    }
                    string3 = string;
                    string = "to";
                    object = this.atomExpressionAt(i);
                    i = this.iToken;
                    break;
                }
                case 1074790746: {
                    if (n2 > 1) {
                        this.error(23);
                    }
                    if (this.tokAt(i + 1) == 10 || this.tokAt(i + 1) == 0x100001 && !bl) {
                        string3 = "toBitSet";
                        object = this.atomExpressionAt(++i);
                        i = this.iToken;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.error(19);
                    }
                    string = "to";
                    continue block15;
                }
                case 1073741937: {
                    if (!bl) {
                        this.error(19);
                    }
                    string2 = "faceCenterOffset";
                    bl5 = true;
                    continue block15;
                }
                case 0x40000064: {
                    if (!bl) {
                        this.error(19);
                    }
                    string2 = "distanceFactor";
                    bl5 = true;
                    continue block15;
                }
                case 1073742074: 
                case 1073742180: 
                case 1766856708: {
                    bl6 = false;
                    if (this.theTok != 1766856708) {
                        --i;
                    }
                    if (this.tokAt(i + 1) == 1073742180) {
                        bl6 = true;
                        if (this.isFloatParameter(++i + 1)) {
                            f = this.getTranslucentLevel(++i);
                        }
                    } else if (this.tokAt(i + 1) == 1073742074) {
                        ++i;
                        bl6 = true;
                        f = 0.0f;
                    }
                    if (this.isColorParam(i + 1)) {
                        n3 = this.getArgbParam(i);
                        i = this.iToken;
                        continue block15;
                    }
                    if (bl6) continue block15;
                    this.error(22);
                    continue block15;
                }
                case 1073741886: 
                case 1073741948: {
                    string3 = "collapsed";
                    Object object2 = object = this.theTok == 1073741886 ? Boolean.TRUE : Boolean.FALSE;
                    if (bl3) {
                        this.error(18);
                    }
                    bl3 = true;
                    break;
                }
                case 1073741934: 
                case 0x40000084: 
                case 1073742044: {
                    if (bl4) {
                        this.error(18);
                    }
                    string3 = this.parameterAsString(i);
                    bl4 = true;
                    break;
                }
                case 1073741964: {
                    n = this.theTok;
                    continue block15;
                }
                default: {
                    if (this.isColorParam(i)) {
                        n3 = this.getArgbParam(i);
                        i = this.iToken;
                        continue block15;
                    }
                    this.error(22);
                }
            }
            this.setShapeProperty(21, string3, object);
            if (!bl2) continue;
            return;
        }
        if (!(bl || bl3 || bl4 || n != 0)) {
            this.error(19);
        }
        if (bl) {
            this.setShapeProperty(21, "generate", null);
        }
        if (n3 != Integer.MIN_VALUE) {
            this.setShapeProperty(21, "colorThis", n3);
        }
        if (bl6) {
            this.setShapeTranslucency(21, "", "translucentThis", f, null);
        }
        if (n != 0) {
            this.setShapeProperty(21, "token", n);
        }
        this.setShapeProperty(21, "init", null);
    }

    private void contact() throws ScriptException {
        this.sm.loadShape(25);
        if (this.tokAt(1) == 1073742001 && this.listIsosurface(25)) {
            return;
        }
        int n = 0;
        this.iToken = 1;
        String string = this.initIsosurface(25);
        boolean bl = string != null;
        boolean bl2 = bl && this.getShapeProperty(25, "ID") == null;
        BS bS = null;
        BS bS2 = null;
        BS bS3 = null;
        RadiusData radiusData = null;
        float[] fArray = null;
        boolean bl3 = false;
        SB sB = new SB();
        int n2 = Integer.MAX_VALUE;
        int n3 = 135266319;
        int n4 = 0;
        float f = Float.NaN;
        float f2 = Float.NaN;
        boolean bl4 = true;
        Boolean bl5 = null;
        Object object = null;
        int n5 = 0;
        boolean bl6 = false;
        boolean bl7 = this.iToken > 1;
        block27: for (int i = this.iToken; i < this.slen; ++i) {
            int n6 = this.getToken((int)i).tok;
            switch (n6) {
                default: {
                    bl7 = true;
                    if (!this.setMeshDisplayProperty(25, 0, this.theTok)) {
                        if (this.theTok != 0x101000B1 && !T.tokAttr(this.theTok, 0x40000000)) {
                            this.error(22);
                        }
                        string = this.setShapeId(25, i, bl);
                        i = this.iToken;
                        break;
                    }
                    if (n == 0) {
                        n = i;
                    }
                    i = this.iToken;
                    continue block27;
                }
                case 1074790550: {
                    bl7 = true;
                    this.setShapeId(25, ++i, bl);
                    bl2 = this.getShapeProperty(25, "ID") == null;
                    i = this.iToken;
                    break;
                }
                case 1766856708: {
                    switch (this.tokAt(i + 1)) {
                        case 1073741914: {
                            n6 = 0;
                            bl3 = true;
                            sB.append(" color density");
                            ++i;
                            break;
                        }
                        case 1141899272: {
                            n6 = 0;
                            bl6 = true;
                            sB.append(" color type");
                            ++i;
                        }
                    }
                    if (n6 == 0) break;
                }
                case 1073742074: 
                case 1073742180: {
                    bl7 = true;
                    if (n5 == 0) {
                        n5 = i;
                    }
                    this.setMeshDisplayProperty(25, i, this.theTok);
                    i = this.iToken;
                    break;
                }
                case 554176565: {
                    bl7 = true;
                    object = this.getCapSlabObject(i, false);
                    this.setShapeProperty(25, "slab", object);
                    i = this.iToken;
                    break;
                }
                case 1073741914: {
                    bl3 = true;
                    sB.append(" density");
                    if (!this.isFloatParameter(i + 1)) break;
                    if (fArray == null) {
                        fArray = new float[]{-Math.abs(this.floatParameter(++i))};
                    }
                    sB.append(" " + -fArray[0]);
                    break;
                }
                case 1073742122: {
                    float f3 = this.floatParameter(++i);
                    if (!(f3 > 0.0f)) break;
                    sB.append(" resolution ").appendF(f3);
                    this.setShapeProperty(25, "resolution", Float.valueOf(f3));
                    break;
                }
                case 135266324: 
                case 1276118018: {
                    f = this.floatParameter(++i);
                    sB.append(" within ").appendF(f);
                    break;
                }
                case 2: 
                case 3: 
                case 0x101000A1: {
                    radiusData = this.encodeRadiusParameter(i, false, false);
                    sB.append(" ").appendO(radiusData);
                    i = this.iToken;
                    break;
                }
                case 1073741989: 
                case 1073741990: {
                    bl5 = n6 == 1073741989 ? Boolean.TRUE : Boolean.FALSE;
                    sB.append(" ").appendO(this.theToken.value);
                    break;
                }
                case 0x400000C4: {
                    n2 = this.intParameter(++i);
                    break;
                }
                case 1073741881: 
                case 1612189718: 
                case 1649412112: {
                    n4 = n6;
                    sB.append(" ").appendO(this.theToken.value);
                    break;
                }
                case 1073742136: {
                    if (this.isFloatParameter(i + 1)) {
                        f2 = this.floatParameter(++i);
                    }
                }
                case 3145756: 
                case 0x400000D4: 
                case 1074790451: {
                    bl4 = false;
                }
                case 4106: 
                case 135266319: 
                case 1073741961: 
                case 1276117510: {
                    n3 = n6;
                    sB.append(" ").appendO(this.theToken.value);
                    if (n6 != 1073742136) break;
                    sB.append(" ").appendF(f2);
                    break;
                }
                case 1073742083: {
                    fArray = this.floatParameterSet(++i, 1, 10);
                    i = this.iToken;
                    break;
                }
                case 10: 
                case 0x100001: {
                    if (bl2 || bS2 != null) {
                        this.error(22);
                    }
                    bS3 = BSUtil.copy(this.atomExpressionAt(i));
                    i = this.iToken;
                    if (bS == null) {
                        bS = bS3;
                    } else {
                        bS2 = bS3;
                    }
                    sB.append(" ").append(Escape.eBS(bS3));
                }
            }
            bl = this.theTok != 12291;
        }
        if (!bl7 && bS == null) {
            this.error(13);
        }
        if (this.chk) {
            return;
        }
        if (bS != null) {
            if (n4 == 1649412112 && radiusData == null) {
                radiusData = new RadiusData(null, 0.0f, RadiusData.EnumType.OFFSET, EnumVdw.AUTO);
            }
            RadiusData radiusData2 = radiusData == null ? new RadiusData(null, 0.26f, RadiusData.EnumType.OFFSET, EnumVdw.AUTO) : radiusData;
            bS2 = n3 == 0x400000D4 && bS2 == null && bl5 != null && bl5 != false ? bS : this.setContactBitSets(bS, bS2, bl4, f, radiusData2, true);
            switch (n3) {
                case 1073742136: 
                case 1074790451: {
                    BS bS4 = this.lookupIdentifierValue("solvent");
                    bS.andNot(bS4);
                    bS2.andNot(bS4);
                    bS2.andNot(bS);
                    break;
                }
                case 3145756: {
                    bS2.andNot(bS);
                    break;
                }
                case 0x400000D4: {
                    if (n2 == Integer.MAX_VALUE) {
                        n2 = 100;
                    }
                    this.setShapeProperty(25, "minset", n2);
                    sB.append(" minSet ").appendI(n2);
                    if (fArray != null) break;
                    fArray = new float[]{0.5f, 2.0f};
                }
            }
            if (bl5 != null) {
                fArray = fArray == null ? new float[2] : ArrayUtil.ensureLengthA(fArray, 2);
                fArray[1] = bl5 != false ? 1 : 2;
            }
            if (fArray != null) {
                sB.append(" parameters ").append(Escape.eAF(fArray));
            }
            this.setShapeProperty(25, "set", new Object[]{n4, n3, bl3, bl6, bS, bS2, radiusData, Float.valueOf(f2), fArray, sB.toString()});
            if (n5 > 0) {
                this.setMeshDisplayProperty(25, n5, 0);
            }
        }
        if (n > 0 && !this.setMeshDisplayProperty(25, n, 0)) {
            this.error(22);
        }
        if (object != null && bS != null) {
            this.setShapeProperty(25, "slab", object);
        }
        if (bS != null && (n3 == 0x400000D4 || bl4)) {
            Object object2 = this.getShapeProperty(25, "volume");
            if (Escape.isAD(object2)) {
                double[] dArray = (double[])object2;
                double d = 0.0;
                for (int i = 0; i < dArray.length; ++i) {
                    d += Math.abs(dArray[i]);
                }
                object2 = Float.valueOf((float)d);
            }
            int n7 = (Integer)this.getShapeProperty(25, "nSets");
            if (bl3 || n3 != 1276117510) {
                this.showString((n7 == 0 ? "" : n7 + " contacts with ") + "net volume " + object2 + " A^3");
            }
        }
    }

    BS setContactBitSets(BS bS, BS bS2, boolean bl, float f, RadiusData radiusData, boolean bl2) {
        int n;
        BS bS3;
        boolean bl3;
        if (bS2 == null) {
            bS2 = BSUtil.setAll(this.viewer.getAtomCount());
            BSUtil.andNot(bS2, this.viewer.getDeletedAtoms());
            bS2.andNot(bS);
            bl3 = false;
        } else {
            bS3 = BSUtil.copy(bS);
            bS3.or(bS2);
            n = this.viewer.getModelBitSet(bS3, false).cardinality();
            boolean bl4 = bl3 = n > 1;
            if (bl2 && n > 1 && !this.tQuiet) {
                this.showString(GT._("Note: More than one model is involved in this contact!"));
            }
        }
        if (!bS.equals(bS2)) {
            int n2 = n = !bl || bS.cardinality() < bS2.cardinality() ? 1 : 0;
            if (n != 0) {
                bS3 = this.viewer.getAtomsWithinRadius(f, bS, bl3, Float.isNaN(f) ? radiusData : null);
                bS2.and(bS3);
            }
            if (bl) {
                bS3 = this.viewer.getAtomsWithinRadius(f, bS2, bl3, Float.isNaN(f) ? radiusData : null);
                bS.and(bS3);
                if (n == 0) {
                    bS3 = this.viewer.getAtomsWithinRadius(f, bS, bl3, Float.isNaN(f) ? radiusData : null);
                    bS2.and(bS3);
                }
                bS3 = BSUtil.copy(bS2);
                bS3.and(bS);
                if (bS3.equals(bS)) {
                    bS2.andNot(bS);
                } else if (bS3.equals(bS2)) {
                    bS.andNot(bS2);
                }
            }
        }
        return bS2;
    }

    private void lcaoCartoon() throws ScriptException {
        this.sm.loadShape(26);
        if (this.tokAt(1) == 1073742001 && this.listIsosurface(26)) {
            return;
        }
        this.setShapeProperty(26, "init", this.fullCommand);
        if (this.slen == 1) {
            this.setShapeProperty(26, "lcaoID", null);
            return;
        }
        boolean bl = false;
        String string = null;
        block24: for (int i = 1; i < this.slen; ++i) {
            String string2 = null;
            Object object = null;
            switch (this.getToken((int)i).tok) {
                case 554176565: 
                case 1074790451: {
                    string2 = (String)this.theToken.value;
                    if (this.tokAt(i + 1) == 0x10000C) {
                        this.iToken = i + 1;
                    }
                    object = this.getCapSlabObject(i, true);
                    i = this.iToken;
                    break;
                }
                case 12289: {
                    this.isosurface(26);
                    return;
                }
                case 528432: {
                    float f = 0.0f;
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    switch (this.getToken((int)(++i)).tok) {
                        case 1112541205: {
                            f = this.floatParameter(++i) * ((float)Math.PI / 180);
                            break;
                        }
                        case 1112541206: {
                            f2 = this.floatParameter(++i) * ((float)Math.PI / 180);
                            break;
                        }
                        case 1112541207: {
                            f3 = this.floatParameter(++i) * ((float)Math.PI / 180);
                            break;
                        }
                        default: {
                            this.error(22);
                        }
                    }
                    string2 = "rotationAxis";
                    object = V3.new3(f, f2, f3);
                    break;
                }
                case 0x10000D: 
                case 3145768: 
                case 1610625028: {
                    string2 = "on";
                    break;
                }
                case 12294: 
                case 0x10000C: 
                case 3145770: {
                    string2 = "off";
                    break;
                }
                case 12291: {
                    string2 = "delete";
                    break;
                }
                case 10: 
                case 0x100001: {
                    string2 = "select";
                    object = this.atomExpressionAt(i);
                    i = this.iToken;
                    break;
                }
                case 1766856708: {
                    string = this.setColorOptions(null, i + 1, 26, -2);
                    if (string != null) {
                        this.setShapeProperty(26, "settranslucency", string);
                    }
                    i = this.iToken;
                    bl = true;
                    continue block24;
                }
                case 1073742074: 
                case 1073742180: {
                    this.setMeshDisplayProperty(26, i, this.theTok);
                    i = this.iToken;
                    bl = true;
                    continue block24;
                }
                case 4: 
                case 1113200651: {
                    object = this.parameterAsString(i).toLowerCase();
                    if (object.equals("spacefill")) {
                        object = "cpk";
                    }
                    string2 = "create";
                    if (!this.optParameterAsString(i + 1).equalsIgnoreCase("molecular")) break;
                    ++i;
                    string2 = "molecular";
                    break;
                }
                case 135280132: {
                    if (this.tokAt(i + 1) == 10 || this.tokAt(i + 1) == 0x100001) {
                        string2 = "select";
                        object = this.atomExpressionAt(i + 1);
                        i = this.iToken;
                        break;
                    }
                    string2 = "selectType";
                    if (!(object = this.parameterAsString(++i)).equals("spacefill")) break;
                    object = "cpk";
                    break;
                }
                case 1073742138: {
                    string2 = "scale";
                    object = Float.valueOf(this.floatParameter(++i));
                    break;
                }
                case 0x400000B4: 
                case 1073742006: {
                    string2 = "lonePair";
                    break;
                }
                case 1073742111: 
                case 1073742112: {
                    string2 = "radical";
                    break;
                }
                case 1073742029: {
                    string2 = "molecular";
                    break;
                }
                case 0x40000050: {
                    object = this.parameterAsString(++i);
                    string2 = "create";
                    if (!this.optParameterAsString(i + 1).equalsIgnoreCase("molecular")) break;
                    ++i;
                    string2 = "molecular";
                    break;
                }
                case 1074790550: {
                    object = this.getShapeNameParameter(++i);
                    i = this.iToken;
                    if (bl) {
                        this.error(22);
                    }
                    string2 = "lcaoID";
                    break;
                }
                default: {
                    if (this.theTok != 0x101000B1 && !T.tokAttr(this.theTok, 0x40000000)) break;
                    if (this.theTok != 0x101000B1) {
                        object = this.parameterAsString(i);
                    }
                    if (bl) {
                        this.error(22);
                    }
                    string2 = "lcaoID";
                }
            }
            if (this.theTok != 12291) {
                bl = true;
            }
            if (string2 == null) {
                this.error(22);
            }
            this.setShapeProperty(26, string2, object);
        }
        this.setShapeProperty(26, "clear", null);
    }

    private Object getCapSlabObject(int n, boolean bl) throws ScriptException {
        Object[] objectArray;
        if (n < 0) {
            return MeshSurface.getSlabWithinRange(n, 0.0f);
        }
        Object object = null;
        int n2 = this.tokAt(n);
        boolean bl2 = n2 == 554176565;
        int n3 = this.tokAt(n + 1);
        P4 p4 = null;
        P3[] p3Array = null;
        BS bS = null;
        Short s = null;
        Integer n4 = null;
        if (n3 == 1073742180) {
            float f;
            float f2 = f = this.isFloatParameter(++n + 1) ? this.floatParameter(++n) : 0.5f;
            if (this.isColorParam(n + 1)) {
                s = C.getColixTranslucent3(C.getColix(this.getArgbParam(n + 1)), f != 0.0f, f);
                n = this.iToken;
            } else {
                s = C.getColixTranslucent3((short)1, f != 0.0f, f);
            }
            n3 = this.tokAt(n + 1);
            switch (n3) {
                case 1073741938: 
                case 1073742018: {
                    n4 = n3;
                    n3 = this.tokAt(++n + 1);
                    break;
                }
                default: {
                    n4 = 1073741938;
                }
            }
        }
        switch (n3) {
            case 10: 
            case 0x100001: {
                object = this.atomExpressionAt(n + 1);
                n3 = 3;
                ++this.iToken;
                break;
            }
            case 0x10000C: {
                this.iToken = n + 1;
                return Integer.MIN_VALUE;
            }
            case 0x10000B: {
                this.iToken = n + 1;
                break;
            }
            case 0x100007: {
                ++n;
                object = new Object[]{Float.valueOf(1.0f), this.parameterAsString(++n)};
                n3 = 1073742018;
                break;
            }
            case 135266324: {
                ++n;
                if (this.tokAt(++n) == 1073742114) {
                    float f = this.floatParameter(++n);
                    float f3 = this.floatParameter(++n);
                    object = new Object[]{Float.valueOf(f), Float.valueOf(f3)};
                    n3 = 1073742114;
                    break;
                }
                if (this.isFloatParameter(n)) {
                    float f = this.floatParameter(n);
                    if (this.isCenterParameter(++n)) {
                        P3 p3 = this.centerParameter(n);
                        if (this.chk || !(this.expressionResult instanceof BS)) {
                            p3Array = new P3[]{p3};
                        } else {
                            Atom[] atomArray = this.viewer.modelSet.atoms;
                            bS = (BS)this.expressionResult;
                            p3Array = new P3[bS.cardinality()];
                            int n5 = 0;
                            int n6 = bS.nextSetBit(0);
                            while (n6 >= 0) {
                                p3Array[n5] = atomArray[n6];
                                n6 = bS.nextSetBit(n6 + 1);
                                ++n5;
                            }
                        }
                    } else {
                        p3Array = this.getPointArray(n, -1);
                    }
                    if (p3Array.length == 0) {
                        this.iToken = n;
                        this.error(22);
                    }
                    object = new Object[]{Float.valueOf(f), p3Array, bS};
                    break;
                }
                object = this.getPointArray(n, 4);
                n3 = 1679429641;
                break;
            }
            case 1679429641: {
                this.iToken = n + 1;
                object = BoxInfo.getCriticalPoints(this.viewer.getBoundBoxVertices(), null);
                break;
            }
            case 0x40000030: 
            case 1614417948: {
                this.iToken = n + 1;
                SymmetryInterface symmetryInterface = this.viewer.getCurrentUnitCell();
                if (symmetryInterface == null) {
                    if (n3 != 1614417948) break;
                    this.error(22);
                    break;
                }
                p3Array = BoxInfo.getCriticalPoints(symmetryInterface.getUnitCellVertices(), symmetryInterface.getCartesianOffset());
                int n7 = (int)symmetryInterface.getUnitCellInfoType(6);
                V3 v3 = null;
                V3 v32 = null;
                switch (n7) {
                    case 3: {
                        break;
                    }
                    case 1: {
                        v32 = V3.newV(p3Array[2]);
                        v32.sub(p3Array[0]);
                        v32.scale(1000.0f);
                    }
                    case 2: {
                        v3 = V3.newV(p3Array[1]);
                        v3.sub(p3Array[0]);
                        v3.scale(1000.0f);
                        p3Array[0].sub(v3);
                        p3Array[1].scale(2000.0f);
                        if (n7 != 1) break;
                        p3Array[0].sub(v32);
                        p3Array[2].scale(2000.0f);
                    }
                }
                object = p3Array;
                break;
            }
            default: {
                float f;
                if (!bl && bl2 && this.isFloatParameter(n + 1)) {
                    float f4 = this.floatParameter(++n);
                    if (!this.isFloatParameter(n + 1)) {
                        return (int)f4;
                    }
                    float f5 = this.floatParameter(++n);
                    object = new Object[]{Float.valueOf(f4), Float.valueOf(f5)};
                    n3 = 1073742114;
                    break;
                }
                p4 = this.planeParameter(++n);
                float f6 = f = this.isFloatParameter(this.iToken + 1) ? this.floatParameter(++this.iToken) : Float.NaN;
                if (!Float.isNaN(f)) {
                    p4.w -= f;
                }
                object = p4;
                n3 = 135266319;
            }
        }
        if (n4 == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = n4;
            objectArray = objectArray2;
            objectArray2[1] = s;
        }
        Object[] objectArray3 = objectArray;
        return MeshSurface.getSlabObject(n3, object, !bl2, objectArray3);
    }

    private boolean mo(boolean bl) throws ScriptException {
        int n = Integer.MAX_VALUE;
        boolean bl2 = false;
        BS bS = this.viewer.getVisibleFramesBitSet();
        JmolList<Object[]> jmolList = new JmolList<Object[]>();
        int n2 = 1;
        if (this.tokAt(1) == 1095766028 || this.tokAt(1) == 4115) {
            n2 = this.modelNumberParameter(2);
            if (n2 < 0) {
                this.error(22);
            }
            bS.clearAll();
            bS.set(n2);
            n2 = 3;
        }
        int n3 = bS.nextSetBit(0);
        while (n3 >= 0) {
            this.sm.loadShape(27);
            int n4 = n2;
            if (this.tokAt(n4) == 1073742001 && this.listIsosurface(27)) {
                return true;
            }
            this.setShapeProperty(27, "init", n3);
            String string = null;
            int n5 = (Integer)this.getShapeProperty(27, "moNumber");
            float[] fArray = (float[])this.getShapeProperty(27, "moLinearCombination");
            if (bl) {
                return true;
            }
            if (n5 == 0) {
                n5 = Integer.MAX_VALUE;
            }
            String string2 = null;
            Object object = null;
            switch (this.getToken((int)n4).tok) {
                case 554176565: 
                case 1074790451: {
                    string2 = (String)this.theToken.value;
                    object = this.getCapSlabObject(n4, false);
                    n4 = this.iToken;
                    break;
                }
                case 1073741914: {
                    string2 = "squareLinear";
                    object = Boolean.TRUE;
                    fArray = new float[]{1.0f};
                    n5 = 0;
                    n = 0;
                    break;
                }
                case 2: {
                    n5 = this.intParameter(n4);
                    fArray = this.moCombo(jmolList);
                    if (fArray != null || n5 >= 0) break;
                    fArray = new float[]{-100.0f, -n5};
                    break;
                }
                case 0x101000A0: {
                    switch (this.tokAt(++n4)) {
                        case 1073741973: 
                        case 1073742008: {
                            break;
                        }
                        default: {
                            this.error(22);
                        }
                    }
                    bl2 = true;
                }
                case 1073741973: 
                case 1073742008: {
                    n = this.moOffset(n4);
                    if (n == Integer.MAX_VALUE) {
                        this.error(22);
                    }
                    n5 = 0;
                    fArray = this.moCombo(jmolList);
                    break;
                }
                case 1073742037: {
                    n5 = 1073742037;
                    fArray = this.moCombo(jmolList);
                    break;
                }
                case 1073742108: {
                    n5 = 1073742108;
                    fArray = this.moCombo(jmolList);
                    break;
                }
                case 1766856708: {
                    this.setColorOptions(null, n4 + 1, 27, 2);
                    break;
                }
                case 135266319: {
                    string2 = "plane";
                    object = this.planeParameter(n4 + 1);
                    break;
                }
                case 0x8100010: {
                    this.addShapeProperty(jmolList, "randomSeed", this.tokAt(n4 + 2) == 2 ? Integer.valueOf(this.intParameter(n4 + 2)) : null);
                    string2 = "monteCarloCount";
                    object = this.intParameter(n4 + 1);
                    break;
                }
                case 1073742138: {
                    string2 = "scale";
                    object = Float.valueOf(this.floatParameter(n4 + 1));
                    break;
                }
                case 1073741910: {
                    if (this.tokAt(n4 + 1) == 0x101000A1) {
                        string2 = "cutoffPositive";
                        object = Float.valueOf(this.floatParameter(n4 + 2));
                        break;
                    }
                    string2 = "cutoff";
                    object = Float.valueOf(this.floatParameter(n4 + 1));
                    break;
                }
                case 0x20000004: {
                    string2 = "debug";
                    break;
                }
                case 1073742054: {
                    string2 = "plane";
                    break;
                }
                case 1073742104: 
                case 1073742122: {
                    string2 = "resolution";
                    object = Float.valueOf(this.floatParameter(n4 + 1));
                    break;
                }
                case 1073742156: {
                    string2 = "squareData";
                    object = Boolean.TRUE;
                    break;
                }
                case 1073742168: {
                    if (n4 + 1 >= this.slen || this.tokAt(n4 + 1) != 4) break;
                    string2 = "titleFormat";
                    object = this.parameterAsString(n4 + 1);
                    break;
                }
                case 0x40000000: {
                    this.error(22);
                    break;
                }
                default: {
                    if (this.isArrayParameter(n4)) {
                        fArray = this.floatParameterSet(n4, 1, Integer.MAX_VALUE);
                        if (this.tokAt(this.iToken + 1) != 1073742156) break;
                        this.addShapeProperty(jmolList, "squareLinear", Boolean.TRUE);
                        ++this.iToken;
                        break;
                    }
                    int n6 = this.iToken;
                    if (!this.setMeshDisplayProperty(27, 0, this.theTok)) {
                        this.error(22);
                    }
                    this.setShapeProperty(27, "setProperties", jmolList);
                    this.setMeshDisplayProperty(27, n6, this.tokAt(n6));
                    return true;
                }
            }
            if (string2 != null) {
                this.addShapeProperty(jmolList, string2, object);
            }
            if (n5 != Integer.MAX_VALUE || fArray != null) {
                if (this.tokAt(this.iToken + 1) == 4) {
                    string = this.parameterAsString(++this.iToken);
                }
                this.setCursorWait(true);
                this.setMoData(jmolList, n5, fArray, n, bl2, n3, string);
                this.addShapeProperty(jmolList, "finalize", null);
            }
            if (jmolList.size() > 0) {
                this.setShapeProperty(27, "setProperties", jmolList);
            }
            jmolList.clear();
            n3 = bS.nextSetBit(n3 + 1);
        }
        return true;
    }

    private float[] moCombo(JmolList<Object[]> jmolList) {
        if (this.tokAt(this.iToken + 1) != 1073742156) {
            return null;
        }
        this.addShapeProperty(jmolList, "squareLinear", Boolean.TRUE);
        ++this.iToken;
        return new float[0];
    }

    private int moOffset(int n) throws ScriptException {
        int n2;
        boolean bl = this.getToken((int)n).tok == 1073741973;
        int n3 = bl ? 0 : 1;
        if ((n2 = this.tokAt(++n)) == 2 && this.intParameter(n) < 0) {
            n3 += this.intParameter(n);
        } else if (n2 == 0x101000A1) {
            n3 += this.intParameter(++n);
        } else if (n2 == 0x101000A0) {
            n3 -= this.intParameter(++n);
        }
        return n3;
    }

    private void setMoData(JmolList<Object[]> jmolList, int n, float[] fArray, int n2, boolean bl, int n3, String string) throws ScriptException {
        Float f;
        Map map;
        int n4;
        if (this.chk) {
            return;
        }
        if (n3 < 0 && (n3 = this.viewer.getCurrentModelIndex()) < 0) {
            this.errorStr(30, "MO isosurfaces");
        }
        Map map2 = (Map)this.viewer.getModelAuxiliaryInfoValue(n3, "moData");
        JmolList jmolList2 = null;
        int n5 = 0;
        if (fArray == null || fArray.length < 2) {
            int n6;
            if (fArray != null && fArray.length == 1) {
                n2 = 0;
            }
            if (map2 == null) {
                this.error(27);
            }
            int n7 = map2.containsKey("lastMoNumber") ? (Integer)map2.get("lastMoNumber") : 0;
            int n8 = n6 = map2.containsKey("lastMoCount") ? (Integer)map2.get("lastMoCount") : 1;
            if (n == 1073742108) {
                n = n7 - 1;
            } else if (n == 1073742037) {
                n = n7 + n6;
            }
            jmolList2 = (JmolList)map2.get("mos");
            int n9 = n5 = jmolList2 == null ? 0 : jmolList2.size();
            if (n5 == 0) {
                this.error(25);
            }
            if (n5 == 1 && n > 1) {
                this.error(29);
            }
            if (n2 != Integer.MAX_VALUE) {
                if (map2.containsKey("HOMO")) {
                    n = (Integer)map2.get("HOMO") + n2;
                } else {
                    n = -1;
                    for (n4 = 0; n4 < n5; ++n4) {
                        map = (Map)jmolList2.get(n4);
                        f = (Float)map.get("occupancy");
                        if (f != null) {
                            if (!(f.floatValue() < 0.5f)) continue;
                            n = n4;
                            break;
                        }
                        f = (Float)map.get("energy");
                        if (f == null) break;
                        if (!(f.floatValue() > 0.0f)) continue;
                        n = n4;
                        break;
                    }
                    if (n < 0) {
                        this.error(28);
                    }
                    n += n2;
                }
                Logger.info("MO " + n);
            }
            if (n < 1 || n > n5) {
                this.errorStr(26, "" + n5);
            }
        }
        n = Math.abs(n);
        map2.put("lastMoNumber", n);
        map2.put("lastMoCount", 1);
        if (bl && fArray == null) {
            fArray = new float[]{-100.0f, n};
        }
        if (fArray != null && fArray.length < 2) {
            map = (Map)jmolList2.get(n - 1);
            f = (Float)map.get("energy");
            if (f == null) {
                fArray = new float[]{100.0f, n};
            } else {
                int n10;
                float f2 = f.floatValue();
                BS bS = BS.newN(n5);
                n4 = 0;
                boolean bl2 = fArray.length == 1 && fArray[0] == 1.0f;
                for (n10 = 0; n10 < n5; ++n10) {
                    f = (Float)((Map)jmolList2.get(n10)).get("energy");
                    if (f == null) continue;
                    float f3 = f.floatValue();
                    if (!(bl2 ? f3 <= f2 : f3 == f2)) continue;
                    bS.set(n10 + 1);
                    n4 += 2;
                }
                fArray = new float[n4];
                int n11 = 0;
                for (n10 = 0; n10 < n4; n10 += 2) {
                    fArray[n10] = 1.0f;
                    n11 = bS.nextSetBit(n11 + 1);
                    fArray[n10 + 1] = n11;
                }
                map2.put("lastMoNumber", bS.nextSetBit(0));
                map2.put("lastMoCount", n4 / 2);
            }
            this.addShapeProperty(jmolList, "squareLinear", Boolean.TRUE);
        }
        this.addShapeProperty(jmolList, "moData", map2);
        if (string != null) {
            this.addShapeProperty(jmolList, "title", string);
        }
        this.addShapeProperty(jmolList, "molecularOrbital", fArray != null ? fArray : (float[])Math.abs(n));
        this.addShapeProperty(jmolList, "clear", null);
    }

    private String initIsosurface(int n) throws ScriptException {
        this.setShapeProperty(n, "init", this.fullCommand);
        this.iToken = 0;
        int n2 = this.tokAt(1);
        int n3 = this.tokAt(2);
        if (n2 == 12291 || n3 == 12291 && this.tokAt(++this.iToken) == 0x100003) {
            this.setShapeProperty(n, "delete", null);
            this.iToken += 2;
            if (this.slen > this.iToken) {
                this.setShapeProperty(n, "init", this.fullCommand);
                this.setShapeProperty(n, "thisID", "+PREVIOUS_MESH+");
            }
            return null;
        }
        this.iToken = 1;
        if (!this.setMeshDisplayProperty(n, 0, n2)) {
            this.setShapeProperty(n, "thisID", "+PREVIOUS_MESH+");
            if (n != 22) {
                this.setShapeProperty(n, "title", new String[]{this.thisCommand});
            }
            if (n2 != 1074790550 && (n3 == 0x101000B1 || n2 == 0x101000B1 && this.setMeshDisplayProperty(n, 0, n3))) {
                String string = this.setShapeId(n, 1, false);
                ++this.iToken;
                return string;
            }
        }
        return null;
    }

    private String getNextComment() {
        String string = this.getCommand(this.pc + 1, false, true);
        return string.startsWith("#") ? string : "";
    }

    private boolean listIsosurface(int n) throws ScriptException {
        this.checkLength23();
        if (!this.chk) {
            this.showString((String)this.getShapeProperty(n, "list" + (this.tokAt(2) == 0 ? "" : " " + this.getToken((int)2).value)));
        }
        return true;
    }

    private void isosurface(int n) throws ScriptException {
        Object object;
        Object object2;
        int n2;
        this.sm.loadShape(n);
        if (this.tokAt(1) == 1073742001 && this.listIsosurface(n)) {
            return;
        }
        int n3 = 0;
        boolean bl = n == 24;
        boolean bl2 = n == 28;
        boolean bl3 = n == 29;
        boolean bl4 = n == 26;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        boolean bl14 = false;
        boolean bl15 = false;
        boolean bl16 = false;
        boolean bl17 = false;
        float[] fArray = null;
        String string = null;
        int n4 = -1;
        int n5 = 0;
        float f = Float.NaN;
        float f2 = Float.NaN;
        int n6 = 0;
        Boolean bl18 = null;
        int n7 = Integer.MAX_VALUE;
        BS bS = null;
        BS bS2 = null;
        BS bS3 = null;
        SB sB = new SB();
        P4 p4 = null;
        P3 p3 = null;
        String string2 = null;
        int n8 = this.chk ? 0 : Integer.MIN_VALUE;
        this.setCursorWait(true);
        boolean bl19 = this.initIsosurface(n) != null;
        boolean bl20 = bl19 && this.getShapeProperty(n, "ID") == null;
        boolean bl21 = false;
        boolean bl22 = false;
        Object object3 = null;
        String string3 = null;
        String string4 = null;
        Object object4 = null;
        short[] sArray = null;
        JmolList<Object[]> jmolList = new JmolList<Object[]>();
        boolean bl23 = false;
        if (bl2 || bl3) {
            this.addShapeProperty(jmolList, "fileType", "Pmesh");
        }
        block109: for (n2 = this.iToken; n2 < this.slen; ++n2) {
            object2 = null;
            object = null;
            this.getToken(n2);
            if (this.theTok == 0x40000000) {
                string2 = this.parameterAsString(n2);
            }
            block3 : switch (this.theTok) {
                case 603979871: {
                    Boolean bl24 = this.getToken((int)(++n2)).tok == 0x10000D ? Boolean.TRUE : (bl18 = this.theTok == 0x10000C ? Boolean.FALSE : null);
                    if (bl18 != null) continue block109;
                    this.error(22);
                    continue block109;
                }
                case 553648149: {
                    n7 = this.intParameter(++n2);
                    continue block109;
                }
                case 4128: {
                    object2 = "moveIsosurface";
                    if (this.tokAt(++n2) != 12) {
                        this.error(22);
                    }
                    object = this.getToken((int)n2++).value;
                    break;
                }
                case 1073742066: {
                    object2 = "offset";
                    object = this.centerParameter(++n2);
                    n2 = this.iToken;
                    break;
                }
                case 528432: {
                    object2 = "rotate";
                    this.iToken = ++n2;
                    object = this.tokAt(this.iToken) == 0x10000B ? null : this.getPoint4f(n2);
                    n2 = this.iToken;
                    break;
                }
                case 0x60000004: {
                    object2 = "scale3d";
                    object = Float.valueOf(this.floatParameter(++n2));
                    break;
                }
                case 1073742090: {
                    sB.append(" periodic");
                    object2 = "periodic";
                    break;
                }
                case 266298: 
                case 0x8100010: 
                case 1073742078: {
                    object2 = this.theToken.value.toString();
                    sB.append(" ").appendO(this.theToken.value);
                    object = this.centerParameter(++n2);
                    sB.append(" ").append(Escape.eP((P3)object));
                    n2 = this.iToken;
                    break;
                }
                case 1679429641: {
                    P3[] p3Array;
                    if (this.fullCommand.indexOf("# BBOX=") >= 0) {
                        String[] stringArray = TextFormat.split(Parser.getQuotedAttribute(this.fullCommand, "# BBOX"), ',');
                        p3Array = new P3[]{(P3)Escape.uP(stringArray[0]), (P3)Escape.uP(stringArray[1])};
                    } else if (this.isCenterParameter(n2 + 1)) {
                        p3Array = new P3[]{this.getPoint3f(n2 + 1, true), this.getPoint3f(this.iToken + 1, true)};
                        n2 = this.iToken;
                    } else {
                        p3Array = this.viewer.getBoundBoxVertices();
                    }
                    sB.append(" boundBox " + Escape.eP(p3Array[0]) + " " + Escape.eP(p3Array[p3Array.length - 1]));
                    object2 = "boundingBox";
                    object = p3Array;
                    break;
                }
                case 135188: {
                    bl2 = true;
                    sB.append(" pmesh");
                    object2 = "fileType";
                    object = "Pmesh";
                    break;
                }
                case 135267842: {
                    bS2 = this.atomExpressionAt(++n2);
                    if (this.chk) {
                        bS = new BS();
                    } else if (this.tokAt(this.iToken + 1) == 0x100001 || this.tokAt(this.iToken + 1) == 10) {
                        bS = this.atomExpressionAt(++this.iToken);
                        bS.and(this.viewer.getAtomsWithinRadius(5.0f, bS2, false, null));
                    } else {
                        bS = this.viewer.getAtomsWithinRadius(5.0f, bS2, true, null);
                        bS.andNot(this.viewer.getAtomBits(1095761934, bS2));
                    }
                    bS.andNot(bS2);
                    sB.append(" intersection ").append(Escape.eBS(bS2)).append(" ").append(Escape.eBS(bS));
                    n2 = this.iToken;
                    if (this.tokAt(n2 + 1) == 135368713) {
                        ++n2;
                        Object[] objectArray = (Object[])this.getToken((int)(++n2)).value;
                        sB.append(" function ").append(Escape.eS((String)objectArray));
                        if (!this.chk) {
                            this.addShapeProperty(jmolList, "func", objectArray.equals("a+b") || objectArray.equals("a-b") ? objectArray : this.createFunction("__iso__", "a,b", (String)objectArray));
                        }
                    } else {
                        bl17 = true;
                    }
                    object2 = "intersection";
                    object = new BS[]{bS2, bS};
                    break;
                }
                case 135266324: 
                case 1610625028: {
                    float f3;
                    boolean bl25;
                    boolean bl26 = bl25 = this.theTok == 1610625028;
                    if (bl25) {
                        sB.append(" display");
                        n3 = n2;
                        int n9 = this.tokAt(n2 + 1);
                        if (n9 == 0) continue block109;
                        ++n2;
                        this.addShapeProperty(jmolList, "token", 0x10000D);
                        if (n9 == 10 || n9 == 0x100003) {
                            object2 = "bsDisplay";
                            if (n9 == 0x100003) {
                                sB.append(" all");
                            } else {
                                object = this.st[n2].value;
                                sB.append(" ").append(Escape.eBS((BS)object));
                            }
                            this.checkLast(n2);
                            break;
                        }
                        if (n9 != 135266324) {
                            this.iToken = n2;
                            this.error(22);
                        }
                    } else {
                        n6 = n2;
                    }
                    P3 p32 = null;
                    bS = null;
                    boolean bl27 = false;
                    if (this.tokAt(n2 + 1) == 0x100001) {
                        f3 = this.floatParameter(n2 + 3);
                        if (this.isPoint3f(n2 + 4)) {
                            p32 = this.centerParameter(n2 + 4);
                            bl27 = true;
                            this.iToken += 2;
                        } else if (this.isPoint3f(n2 + 5)) {
                            p32 = this.centerParameter(n2 + 5);
                            bl27 = true;
                            this.iToken += 2;
                        } else {
                            bS = this.atomExpression(this.st, n2 + 5, this.slen, true, false, false, true);
                            if (bS == null) {
                                this.error(22);
                            }
                        }
                    } else {
                        f3 = this.floatParameter(++n2);
                        p32 = this.centerParameter(++n2);
                    }
                    if (bl25) {
                        this.checkLast(this.iToken);
                    }
                    n2 = this.iToken;
                    if (this.fullCommand.indexOf("# WITHIN=") >= 0) {
                        bS = Escape.uB(Parser.getQuotedAttribute(this.fullCommand, "# WITHIN"));
                    } else if (!bl27) {
                        BS bS4 = bS = this.expressionResult instanceof BS ? (BS)this.expressionResult : null;
                    }
                    if (this.chk) continue block109;
                    if (bS != null && n8 >= 0) {
                        bS.and(this.viewer.getModelUndeletedAtomsBitSet(n8));
                    }
                    if (p32 == null) {
                        p32 = this.viewer.getAtomSetCenter(bS);
                    }
                    this.getWithinDistanceVector(jmolList, f3, p32, bS, bl25);
                    sB.append(" within ").appendF(f3).append(" ").append(bS == null ? Escape.eP(p32) : Escape.eBS(bS));
                    continue block109;
                }
                case 1073742083: {
                    object2 = "parameters";
                    float[] fArray2 = this.floatParameterSet(++n2, 1, 10);
                    n2 = this.iToken;
                    object = fArray2;
                    sB.append(" parameters ").append(Escape.eAF(fArray2));
                    break;
                }
                case 1073742190: 
                case 1716520973: {
                    int n10;
                    int n11;
                    object3 = this.theToken.value;
                    boolean bl28 = this.theTok == 1073742190;
                    int n12 = this.tokAt(n2 + 1);
                    if (object4 == null) {
                        if (!(bl5 || bl7 || bl6)) {
                            this.addShapeProperty(jmolList, "sasurface", Float.valueOf(0.0f));
                            sB.append(" vdw");
                            bl5 = true;
                        }
                        object2 = "property";
                        if (bl18 == null) {
                            n11 = 1;
                            switch (n12) {
                                case 1095761923: 
                                case 1095761937: 
                                case 1095763969: 
                                case 1095763976: 
                                case 1766856708: {
                                    n11 = 0;
                                }
                            }
                            bl18 = n11 != 0 && this.viewer.getIsosurfacePropertySmoothing(false) == 1 ? Boolean.TRUE : Boolean.FALSE;
                        }
                        this.addShapeProperty(jmolList, "propertySmoothing", bl18);
                        sB.append(" isosurfacePropertySmoothing " + bl18);
                        if (bl18 == Boolean.TRUE) {
                            if (n7 == Integer.MAX_VALUE) {
                                n7 = this.viewer.getIsosurfacePropertySmoothing(true);
                            }
                            this.addShapeProperty(jmolList, "propertySmoothingPower", n7);
                            sB.append(" isosurfacePropertySmoothingPower " + n7);
                        }
                        if (this.viewer.global.rangeSelected) {
                            this.addShapeProperty(jmolList, "rangeSelected", Boolean.TRUE);
                        }
                    } else {
                        object2 = object4;
                    }
                    string2 = this.parameterAsString(n2);
                    sB.append(" ").append(string2);
                    if (string2.toLowerCase().indexOf("property_") == 0) {
                        fArray = new float[this.viewer.getAtomCount()];
                        if (this.chk) continue block109;
                        fArray = this.viewer.getDataFloat(string2);
                        if (fArray == null) {
                            this.error(22);
                        }
                        this.addShapeProperty(jmolList, (String)object2, fArray);
                        continue block109;
                    }
                    n11 = this.viewer.getAtomCount();
                    fArray = new float[n11];
                    if (bl28) {
                        String string5;
                        if ((string5 = this.parameterAsString(++n2)).length() == 0) {
                            fArray = this.floatParameterSet(n2, n11, n11);
                        } else {
                            fArray = new float[n11];
                            if (!this.chk) {
                                Parser.parseStringInfestedFloatArray("" + this.getParameter(string5, 4), null, fArray);
                            }
                        }
                        if (!this.chk) {
                            sB.append(" \"\" ").append(Escape.eAF(fArray));
                        }
                    } else {
                        this.getToken(++n2);
                        if (!this.chk) {
                            sB.append(" " + this.theToken.value);
                            Atom[] atomArray = this.viewer.modelSet.atoms;
                            this.viewer.autoCalculate(n12);
                            if (n12 != 1766856708) {
                                n10 = n11;
                                while (--n10 >= 0) {
                                    fArray[n10] = Atom.atomPropertyFloat(this.viewer, atomArray[n10], n12);
                                }
                            }
                        }
                        if (n12 == 1766856708) {
                            string4 = "inherit";
                        }
                        if (this.tokAt(n2 + 1) == 135266324) {
                            float f4 = this.floatParameter(n2 += 2);
                            sB.append(" within " + f4);
                            this.addShapeProperty(jmolList, "propertyDistanceMax", Float.valueOf(f4));
                        }
                    }
                    object = fArray;
                    break;
                }
                case 1095761933: 
                case 1095766028: {
                    if (bl5) {
                        this.error(22);
                    }
                    n8 = this.theTok == 1095761933 ? this.intParameter(++n2) : this.modelNumberParameter(++n2);
                    sB.append(" modelIndex " + n8);
                    if (n8 < 0) {
                        object2 = "fixed";
                        object = Boolean.TRUE;
                        break;
                    }
                    object2 = "modelIndex";
                    object = n8;
                    break;
                }
                case 135280132: {
                    int n10;
                    object2 = "select";
                    BS bS5 = this.atomExpressionAt(++n2);
                    object = bS5;
                    n2 = this.iToken;
                    int n13 = n10 = this.tokAt(n2 + 1) == 1073742072 ? 1 : 0;
                    if (n10 != 0) {
                        ++n2;
                        BS bS6 = BSUtil.copy(bS5);
                        BSUtil.invertInPlace(bS6, this.viewer.getAtomCount());
                        this.addShapeProperty(jmolList, "ignore", bS6);
                        sB.append(" ignore ").append(Escape.eBS(bS6));
                    }
                    if (bl5 || bl7) {
                        sB.append(" select " + Escape.eBS(bS5));
                        break;
                    }
                    bS2 = (BS)object;
                    if (n8 >= 0 || bS2.nextSetBit(0) < 0) break;
                    n8 = this.viewer.getAtomModelIndex(bS2.nextSetBit(0));
                    break;
                }
                case 1085443: {
                    n4 = this.intParameter(++n2);
                    break;
                }
                case 12289: {
                    object2 = "center";
                    object = this.centerParameter(++n2);
                    sB.append(" center " + Escape.eP((P3)object));
                    n2 = this.iToken;
                    break;
                }
                case 1073742147: 
                case 1766856708: {
                    boolean bl29;
                    bl19 = true;
                    boolean bl30 = bl29 = this.theTok == 1073742147;
                    if (bl29) {
                        sB.append(" sign");
                        this.addShapeProperty(jmolList, "sign", Boolean.TRUE);
                    } else {
                        if (this.tokAt(n2 + 1) == 1073741914) {
                            ++n2;
                            object2 = "colorDensity";
                            sB.append(" color density");
                            break;
                        }
                        if (this.getToken((int)(n2 + 1)).tok == 4) {
                            if ((string4 = this.parameterAsString(++n2)).indexOf(" ") > 0 && (sArray = C.getColixArray(string4)) == null) {
                                this.error(4);
                            }
                        } else if (this.theTok == 1073742018) {
                            ++n2;
                            sB.append(" color mesh");
                            int n14 = this.getArgbParam(++n2);
                            this.addShapeProperty(jmolList, "meshcolor", n14);
                            sB.append(" ").append(Escape.escapeColor(n14));
                            n2 = this.iToken;
                            continue block109;
                        }
                        if ((this.theTok = this.tokAt(n2 + 1)) == 1073742180 || this.theTok == 1073742074) {
                            sB.append(" color");
                            string3 = this.setColorOptions(sB, n2 + 1, 24, -2);
                            n2 = this.iToken;
                            continue block109;
                        }
                        switch (this.tokAt(n2 + 1)) {
                            case 0x40000002: 
                            case 1073742114: {
                                this.getToken(++n2);
                                sB.append(" color range");
                                this.addShapeProperty(jmolList, "rangeAll", null);
                                if (this.tokAt(n2 + 1) == 0x100003) {
                                    ++n2;
                                    sB.append(" all");
                                    continue block109;
                                }
                                float f5 = this.floatParameter(++n2);
                                float f6 = this.floatParameter(++n2);
                                this.addShapeProperty(jmolList, "red", Float.valueOf(f5));
                                this.addShapeProperty(jmolList, "blue", Float.valueOf(f6));
                                sB.append(" ").appendF(f5).append(" ").appendF(f6);
                                continue block109;
                            }
                            default: {
                                if (this.isColorParam(n2 + 1)) {
                                    int n15 = this.getArgbParam(n2 + 1);
                                    if (this.tokAt(n2 + 2) == 1074790746) {
                                        string4 = this.getColorRange(n2 + 1);
                                        n2 = this.iToken;
                                        break block3;
                                    }
                                }
                                sB.append(" color");
                            }
                        }
                    }
                    if (this.isColorParam(n2 + 1)) {
                        int n16 = this.getArgbParam(++n2);
                        sB.append(" ").append(Escape.escapeColor(n16));
                        n2 = this.iToken;
                        this.addShapeProperty(jmolList, "colorRGB", n16);
                        bl19 = true;
                        if (this.isColorParam(n2 + 1)) {
                            n16 = this.getArgbParam(++n2);
                            n2 = this.iToken;
                            this.addShapeProperty(jmolList, "colorRGB", n16);
                            sB.append(" ").append(Escape.escapeColor(n16));
                            bl8 = true;
                            continue block109;
                        }
                        if (!bl29) continue block109;
                        this.error(23);
                        continue block109;
                    }
                    if (bl29 || sArray != null) continue block109;
                    this.error(23);
                    continue block109;
                }
                case 135270422: {
                    if (!bl) {
                        this.error(22);
                    }
                    bl14 = !this.chk;
                    continue block109;
                }
                case 1229984263: {
                    if (this.tokAt(n2 + 1) == 4) continue block109;
                    this.error(23);
                    continue block109;
                }
                case 1112541195: 
                case 1649412112: {
                    sB.append(" ").appendO(this.theToken.value);
                    RadiusData radiusData = this.encodeRadiusParameter(n2, false, true);
                    sB.append(" ").appendO(radiusData);
                    if (Float.isNaN(radiusData.value)) {
                        radiusData.value = 100.0f;
                    }
                    object = radiusData;
                    object2 = "radius";
                    bl13 = true;
                    if (bl7) {
                        bl5 = false;
                    }
                    n2 = this.iToken;
                    break;
                }
                case 135266319: {
                    bl6 = true;
                    object2 = "plane";
                    object = this.planeParameter(++n2);
                    n2 = this.iToken;
                    sB.append(" plane ").append(Escape.eP4((P4)object));
                    break;
                }
                case 1073742138: {
                    object2 = "scale";
                    object = Float.valueOf(this.floatParameter(++n2));
                    sB.append(" scale ").appendO(object);
                    break;
                }
                case 0x100003: {
                    if (bl19) {
                        this.error(22);
                    }
                    object2 = "thisID";
                    break;
                }
                case 1113198596: {
                    bl5 = true;
                    ++n2;
                    try {
                        object = this.getPoint4f(n2);
                        object2 = "ellipsoid";
                        n2 = this.iToken;
                        sB.append(" ellipsoid ").append(Escape.eP4((P4)object));
                    }
                    catch (ScriptException scriptException) {
                        try {
                            object2 = "ellipsoid";
                            object = this.floatParameterSet(n2, 6, 6);
                            n2 = this.iToken;
                            sB.append(" ellipsoid ").append(Escape.eAF((float[])object));
                        }
                        catch (ScriptException scriptException2) {
                            bS = this.atomExpressionAt(n2);
                            sB.append(" ellipsoid ").append(Escape.eBS(bS));
                            int n17 = bS.nextSetBit(0);
                            Atom[] atomArray = this.viewer.modelSet.atoms;
                            if (n17 >= 0) {
                                object = atomArray[n17].getEllipsoid();
                            }
                            if (object == null) {
                                return;
                            }
                            n2 = this.iToken;
                            object2 = "ellipsoid";
                            if (this.chk) break;
                            this.addShapeProperty(jmolList, "center", this.viewer.getAtomPoint3f(n17));
                        }
                    }
                    break;
                }
                case 135267841: {
                    bl6 = true;
                    object2 = "plane";
                    object = this.hklParameter(++n2);
                    n2 = this.iToken;
                    sB.append(" plane ").append(Escape.eP4((P4)object));
                    break;
                }
                case 135182: {
                    int n18;
                    bl5 = true;
                    String string6 = this.parameterAsString(++n2);
                    this.addShapeProperty(jmolList, "lcaoType", string6);
                    sB.append(" lcaocartoon ").append(Escape.eS(string6));
                    switch (this.getToken((int)(++n2)).tok) {
                        case 10: 
                        case 0x100001: {
                            object2 = "lcaoCartoon";
                            bS = this.atomExpressionAt(n2);
                            n2 = this.iToken;
                            if (this.chk) continue block109;
                            n18 = bS.nextSetBit(0);
                            if (n18 < 0) {
                                this.error(14);
                            }
                            sB.append(" ({").appendI(n18).append("})");
                            n8 = this.viewer.getAtomModelIndex(n18);
                            this.addShapeProperty(jmolList, "modelIndex", n8);
                            V3[] v3Array = new V3[]{new V3(), new V3(), V3.newV(this.viewer.getAtomPoint3f(n18)), new V3()};
                            if (!string6.equalsIgnoreCase("s") && this.viewer.getHybridizationAndAxes(n18, v3Array[0], v3Array[1], string6) == null) {
                                return;
                            }
                            object = v3Array;
                            break;
                        }
                        default: {
                            this.error(14);
                            break;
                        }
                    }
                    break;
                }
                case 0x121012: {
                    int n19;
                    int n20;
                    boolean bl31;
                    boolean bl32;
                    int n18 = Integer.MAX_VALUE;
                    int n21 = Integer.MAX_VALUE;
                    boolean bl33 = bl32 = this.tokAt(n2 + 1) == 0x101000A0;
                    if (bl32) {
                        ++n2;
                    }
                    float[] fArray3 = null;
                    switch (this.tokAt(++n2)) {
                        case 0: {
                            this.error(2);
                            break;
                        }
                        case 1073741914: {
                            sB.append("mo [1] squared ");
                            this.addShapeProperty(jmolList, "squareLinear", Boolean.TRUE);
                            fArray3 = new float[]{1.0f};
                            n18 = 0;
                            n21 = 0;
                            ++n2;
                            break;
                        }
                        case 1073741973: 
                        case 1073742008: {
                            n21 = this.moOffset(n2);
                            n18 = 0;
                            n2 = this.iToken;
                            sB.append(" mo " + (bl32 ? "-" : "") + "HOMO ");
                            if (n21 > 0) {
                                sB.append("+");
                            }
                            if (n21 == 0) break;
                            sB.appendI(n21);
                            break;
                        }
                        case 2: {
                            n18 = this.intParameter(n2);
                            sB.append(" mo ").appendI(n18);
                            break;
                        }
                        default: {
                            if (!this.isArrayParameter(n2)) break;
                            fArray3 = this.floatParameterSet(n2, 1, Integer.MAX_VALUE);
                            n2 = this.iToken;
                        }
                    }
                    boolean bl34 = bl31 = this.tokAt(n2 + 1) == 1073742156;
                    if (bl31) {
                        this.addShapeProperty(jmolList, "squareLinear", Boolean.TRUE);
                        sB.append(" squared");
                        if (fArray3 == null) {
                            fArray3 = new float[]{};
                        }
                    } else if (this.tokAt(n2 + 1) == 0x8100010) {
                        ++n2;
                        n20 = this.intParameter(++n2);
                        n19 = this.tokAt(n2 + 1) == 2 ? this.intParameter(++n2) : (int)(-System.currentTimeMillis()) % 10000;
                        this.addShapeProperty(jmolList, "monteCarloCount", n20);
                        this.addShapeProperty(jmolList, "randomSeed", n19);
                        sB.append(" points ").appendI(n20).appendC(' ').appendI(n19);
                    }
                    this.setMoData(jmolList, n18, fArray3, n21, bl32, n8, null);
                    bl5 = true;
                    continue block109;
                }
                case 0x400000D4: {
                    object2 = "nci";
                    sB.append(" " + (String)object2);
                    int n20 = this.tokAt(n2 + 1);
                    int n19 = n20 != 1229984263 && n20 != 4 && n20 != 1073742033 ? 1 : 0;
                    object = n19 != 0;
                    if (n19 == 0) break;
                    bl5 = true;
                    break;
                }
                case 0x400000C0: 
                case 1073742022: {
                    boolean bl35 = this.theTok == 0x400000C0;
                    object2 = bl35 ? "mep" : "mlp";
                    sB.append(" " + (String)object2);
                    String string7 = null;
                    int n22 = -1;
                    bl5 = true;
                    if (this.tokAt(n2 + 1) == 2) {
                        n22 = this.intParameter(++n2);
                        sB.append(" " + n22);
                        this.addShapeProperty(jmolList, "mepCalcType", n22);
                    }
                    if (this.tokAt(n2 + 1) == 4) {
                        string7 = this.stringParameter(++n2);
                        sB.append(" /*file*/" + Escape.eS(string7));
                    } else if (this.tokAt(n2 + 1) == 1716520973) {
                        object4 = object2;
                        continue block109;
                    }
                    if (!this.chk) {
                        try {
                            fArray = string7 == null && bl35 ? this.viewer.getPartialCharges() : this.viewer.getAtomicPotentials(bl35, bS2, bS3, string7);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!this.chk && fArray == null) {
                        this.error(32);
                    }
                    object = fArray;
                    break;
                }
                case 1313866247: {
                    bl11 = !this.chk;
                    sB.append(" volume");
                    break;
                }
                case 1074790550: {
                    this.setShapeId(n, ++n2, bl19);
                    bl20 = this.getShapeProperty(n, "ID") == null;
                    n2 = this.iToken;
                    break;
                }
                case 0x40000040: {
                    if (this.tokAt(n2 + 1) == 1073742180) {
                        bl21 = true;
                        ++n2;
                    }
                    if ((string4 = this.parameterAsString(++n2).toLowerCase()).equals("sets")) {
                        sB.append(" colorScheme \"sets\"");
                        break;
                    }
                    if (!this.isColorParam(n2)) break;
                    string4 = this.getColorRange(n2);
                    n2 = this.iToken;
                    break;
                }
                case 0x40000004: {
                    object2 = "addHydrogens";
                    object = Boolean.TRUE;
                    sB.append(" addHydrogens");
                    break;
                }
                case 0x4000000C: {
                    object2 = "angstroms";
                    sB.append(" angstroms");
                    break;
                }
                case 0x4000000E: {
                    object2 = "anisotropy";
                    object = this.getPoint3f(++n2, false);
                    sB.append(" anisotropy").append(Escape.eP((P3)object));
                    n2 = this.iToken;
                    break;
                }
                case 1073741842: {
                    bl10 = !this.chk;
                    sB.append(" area");
                    break;
                }
                case 1073741850: 
                case 1073742076: {
                    bl5 = true;
                    if (bl8 && !bl9) {
                        sB.append(" phase \"_orb\"");
                        this.addShapeProperty(jmolList, "phase", "_orb");
                    }
                    float[] fArray4 = new float[7];
                    fArray4[0] = this.intParameter(++n2);
                    fArray4[1] = this.intParameter(++n2);
                    fArray4[2] = this.intParameter(++n2);
                    fArray4[3] = this.isFloatParameter(n2 + 1) ? this.floatParameter(++n2) : 6.0f;
                    sB.append(" atomicOrbital ").appendI((int)fArray4[0]).append(" ").appendI((int)fArray4[1]).append(" ").appendI((int)fArray4[2]).append(" ").appendF(fArray4[3]);
                    if (this.tokAt(n2 + 1) == 0x8100010) {
                        fArray4[4] = this.intParameter(n2 += 2);
                        fArray4[5] = this.tokAt(n2 + 1) == 3 ? this.floatParameter(++n2) : 0.0f;
                        fArray4[6] = this.tokAt(n2 + 1) == 2 ? this.intParameter(++n2) : (int)(-System.currentTimeMillis()) % 10000;
                        sB.append(" points ").appendI((int)fArray4[4]).appendC(' ').appendF(fArray4[5]).appendC(' ').appendI((int)fArray4[6]);
                    }
                    object2 = "hydrogenOrbital";
                    object = fArray4;
                    break;
                }
                case 1073741866: {
                    sB.append(" binary");
                    continue block109;
                }
                case 1073741868: {
                    sB.append(" blockData");
                    object2 = "blockData";
                    object = Boolean.TRUE;
                    break;
                }
                case 554176565: 
                case 1074790451: {
                    bl16 = true;
                    object2 = (String)this.theToken.value;
                    object = this.getCapSlabObject(n2, false);
                    n2 = this.iToken;
                    break;
                }
                case 0x40000034: {
                    float f7;
                    if (!bl) {
                        this.error(22);
                    }
                    bl12 = true;
                    if (this.chk) continue block109;
                    float f8 = this.isFloatParameter(n2 + 1) ? this.floatParameter(++n2) : 1.2f;
                    float f9 = f7 = this.isFloatParameter(n2 + 1) ? this.floatParameter(++n2) : 10.0f;
                    if (f7 > 10.0f) {
                        this.integerOutOfRange(0, 10);
                    }
                    sB.append(" cavity ").appendF(f8).append(" ").appendF(f7);
                    this.addShapeProperty(jmolList, "envelopeRadius", Float.valueOf(f7));
                    this.addShapeProperty(jmolList, "cavityRadius", Float.valueOf(f8));
                    object2 = "cavity";
                    break;
                }
                case 0x40000048: 
                case 0x4000004C: {
                    P3 p33;
                    object2 = "contour";
                    sB.append(" contour");
                    switch (this.tokAt(n2 + 1)) {
                        case 0x40000060: {
                            object = this.floatParameterSet(n2 + 2, 1, Integer.MAX_VALUE);
                            sB.append(" discrete ").append(Escape.eAF((float[])object));
                            n2 = this.iToken;
                            break block3;
                        }
                        case 1073741981: {
                            p33 = this.getPoint3f(n2 + 2, false);
                            if (p33.z <= 0.0f || p33.y < p33.x) {
                                this.error(22);
                            }
                            if (p33.z == (float)((int)p33.z) && p33.z > p33.y - p33.x) {
                                p33.z = (p33.y - p33.x) / p33.z;
                            }
                            object = p33;
                            n2 = this.iToken;
                            sB.append(" increment ").append(Escape.eP(p33));
                            break block3;
                        }
                    }
                    object = this.tokAt(n2 + 1) == 2 ? this.intParameter(++n2) : 0;
                    sB.append(" ").appendO(object);
                    break;
                }
                case 2: 
                case 3: 
                case 0x101000A1: 
                case 1073741910: {
                    sB.append(" cutoff ");
                    if (this.theTok == 1073741910) {
                        ++n2;
                    }
                    if (this.tokAt(n2) == 0x101000A1) {
                        object2 = "cutoffPositive";
                        f2 = this.floatParameter(++n2);
                        object = Float.valueOf(f2);
                        sB.append("+").appendO(object);
                        break;
                    }
                    if (this.isFloatParameter(n2)) {
                        object2 = "cutoff";
                        f2 = this.floatParameter(n2);
                        object = Float.valueOf(f2);
                        sB.appendO(object);
                        break;
                    }
                    object2 = "cutoffRange";
                    object = this.floatParameterSet(n2, 2, 2);
                    this.addShapeProperty(jmolList, "cutoff", Float.valueOf(0.0f));
                    sB.append(Escape.eAF((float[])object));
                    n2 = this.iToken;
                    break;
                }
                case 1073741928: {
                    object2 = "downsample";
                    object = this.intParameter(++n2);
                    sB.append(" downsample ").appendO(object);
                    break;
                }
                case 1073741930: {
                    object2 = "eccentricity";
                    object = this.getPoint4f(++n2);
                    sB.append(" eccentricity ").append(Escape.eP4((P4)object));
                    n2 = this.iToken;
                    break;
                }
                case 1074790508: {
                    sB.append(" ed");
                    this.setMoData(jmolList, -1, null, 0, false, n8, null);
                    bl5 = true;
                    continue block109;
                }
                case 0x20000004: 
                case 1073742041: {
                    sB.append(" ").appendO(this.theToken.value);
                    object2 = "debug";
                    object = this.theTok == 0x20000004 ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 1060869: {
                    sB.append(" fixed");
                    object2 = "fixed";
                    object = Boolean.TRUE;
                    break;
                }
                case 1073741962: {
                    sB.append(" fullPlane");
                    object2 = "fullPlane";
                    object = Boolean.TRUE;
                    break;
                }
                case 1073741966: 
                case 0x40000090: {
                    boolean bl36 = this.theTok == 0x40000090;
                    object2 = "" + this.theToken.value;
                    JmolList<Object> jmolList2 = new JmolList<Object>();
                    object = jmolList2;
                    bl5 = true;
                    bl15 = true;
                    sB.append(" ").append((String)object2);
                    String string8 = this.parameterAsString(++n2);
                    if (string8.equals("=")) {
                        sB.append(" =");
                        string8 = this.parameterAsString(++n2);
                        sB.append(" ").append(Escape.eS(string8));
                        jmolList2.addLast(string8);
                        if (this.chk) break;
                        this.addShapeProperty(jmolList, "func", this.createFunction("__iso__", "x,y,z", string8));
                        break;
                    }
                    String string9 = Parser.getQuotedAttribute(this.fullCommand, "# DATA" + (bl15 ? "2" : ""));
                    if (string9 == null) {
                        string9 = "inline";
                    } else {
                        string8 = string9;
                    }
                    boolean bl37 = string8.indexOf("data2d_") == 0;
                    boolean bl38 = string8.indexOf("data3d_") == 0;
                    bl22 = string8.equals("inline");
                    sB.append(" inline");
                    jmolList2.addLast(string8);
                    P3 p34 = this.getPoint3f(++n2, false);
                    sB.append(" ").append(Escape.eP(p34));
                    jmolList2.addLast(p34);
                    int n23 = ++this.iToken;
                    P4 p42 = this.getPoint4f(n23);
                    jmolList2.addLast(p42);
                    sB.append(" ").append(Escape.eP4(p42));
                    int n24 = (int)p42.x;
                    int n25 = ++this.iToken;
                    p42 = this.getPoint4f(n25);
                    jmolList2.addLast(p42);
                    sB.append(" ").append(Escape.eP4(p42));
                    int n26 = (int)p42.x;
                    p42 = this.getPoint4f(++this.iToken);
                    jmolList2.addLast(p42);
                    sB.append(" ").append(Escape.eP4(p42));
                    int n27 = (int)p42.x;
                    if (n24 == 0 || n26 == 0 || n27 == 0) {
                        this.error(22);
                    }
                    if (!this.chk) {
                        float[][] fArray5 = null;
                        float[][][] fArray6 = null;
                        if (bl36) {
                            if (bl22) {
                                n24 = Math.abs(n24);
                                n26 = Math.abs(n26);
                                n27 = Math.abs(n27);
                                fArray6 = this.floatArraySetXYZ(++this.iToken, n24, n26, n27);
                            } else {
                                fArray6 = bl38 ? this.viewer.getDataFloat3D(string8) : this.viewer.functionXYZ(string8, n24, n26, n27);
                            }
                            n24 = Math.abs(n24);
                            n26 = Math.abs(n26);
                            n27 = Math.abs(n27);
                            if (fArray6 == null) {
                                this.iToken = n23;
                                this.errorStr(53, "xyzdata is null.");
                            }
                            if (fArray6.length != n24 || fArray6[0].length != n26 || fArray6[0][0].length != n27) {
                                this.iToken = n23;
                                this.errorStr(53, "xyzdata[" + fArray6.length + "][" + fArray6[0].length + "][" + fArray6[0][0].length + "] is not of size [" + n24 + "][" + n26 + "][" + n27 + "]");
                            }
                            jmolList2.addLast(fArray6);
                            sB.append(" ").append(Escape.e(fArray6));
                        } else {
                            if (bl22) {
                                n24 = Math.abs(n24);
                                n26 = Math.abs(n26);
                                fArray5 = this.floatArraySet(++this.iToken, n24, n26);
                            } else if (bl37) {
                                fArray5 = this.viewer.getDataFloat2D(string8);
                                n24 = fArray5 == null ? 0 : fArray5.length;
                                n26 = 3;
                            } else {
                                fArray5 = this.viewer.functionXY(string8, n24, n26);
                                n24 = Math.abs(n24);
                                n26 = Math.abs(n26);
                            }
                            if (fArray5 == null) {
                                this.iToken = n23;
                                this.errorStr(53, "fdata is null.");
                            }
                            if (fArray5.length != n24 && !bl37) {
                                this.iToken = n23;
                                this.errorStr(53, "fdata length is not correct: " + fArray5.length + " " + n24 + ".");
                            }
                            for (int i = 0; i < n24; ++i) {
                                if (fArray5[i] == null) {
                                    this.iToken = n25;
                                    this.errorStr(53, "fdata[" + i + "] is null.");
                                }
                                if (fArray5[i].length == n26) continue;
                                this.iToken = n25;
                                this.errorStr(53, "fdata[" + i + "] is not the right length: " + fArray5[i].length + " " + n26 + ".");
                            }
                            jmolList2.addLast(fArray5);
                            sB.append(" ").append(Escape.e(fArray5));
                        }
                    }
                    n2 = this.iToken;
                    break;
                }
                case 1073741970: {
                    object2 = "gridPoints";
                    sB.append(" gridPoints");
                    break;
                }
                case 1073741976: {
                    object2 = "ignore";
                    bS3 = this.atomExpressionAt(++n2);
                    object = bS3;
                    sB.append(" ignore ").append(Escape.eBS(bS3));
                    n2 = this.iToken;
                    break;
                }
                case 0x400000A0: {
                    object2 = "insideOut";
                    sB.append(" insideout");
                    break;
                }
                case 1073741986: 
                case 0x400000A4: 
                case 0x40000114: {
                    sB.append(" ").appendO(this.theToken.value);
                    object2 = "pocket";
                    object = this.theTok == 0x40000114 ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 1073742002: {
                    object2 = "lobe";
                    object = this.getPoint4f(++n2);
                    n2 = this.iToken;
                    sB.append(" lobe ").append(Escape.eP4((P4)object));
                    bl5 = true;
                    break;
                }
                case 0x400000B4: 
                case 1073742006: {
                    object2 = "lp";
                    object = this.getPoint4f(++n2);
                    n2 = this.iToken;
                    sB.append(" lp ").append(Escape.eP4((P4)object));
                    bl5 = true;
                    break;
                }
                case 0x10101C: {
                    if (bl7 || this.slen == n2 + 1) {
                        this.error(22);
                    }
                    bl7 = true;
                    if ((bl12 || bl13 || bl17) && !bl5) {
                        bl5 = true;
                        this.addShapeProperty(jmolList, "bsSolvent", bl13 || bl17 ? new BS() : this.lookupIdentifierValue("solvent"));
                        this.addShapeProperty(jmolList, "sasurface", Float.valueOf(0.0f));
                    }
                    if (sB.length() == 0) {
                        p4 = (P4)this.getShapeProperty(24, "plane");
                        if (p4 == null) {
                            if (this.getShapeProperty(24, "contours") != null) {
                                this.addShapeProperty(jmolList, "nocontour", null);
                            }
                        } else {
                            this.addShapeProperty(jmolList, "plane", p4);
                            sB.append("plane ").append(Escape.eP4(p4));
                            bl6 = true;
                            p4 = null;
                        }
                    } else if (!bl5 && !bl6) {
                        this.error(22);
                    }
                    sB.append("; isosurface map");
                    this.addShapeProperty(jmolList, "map", bl5 ? Boolean.TRUE : Boolean.FALSE);
                    break;
                }
                case 1073742014: {
                    object2 = "maxset";
                    object = this.intParameter(++n2);
                    sB.append(" maxSet ").appendO(object);
                    break;
                }
                case 0x400000C4: {
                    object2 = "minset";
                    object = this.intParameter(++n2);
                    sB.append(" minSet ").appendO(object);
                    break;
                }
                case 1073742112: {
                    bl5 = true;
                    object2 = "rad";
                    object = this.getPoint4f(++n2);
                    n2 = this.iToken;
                    sB.append(" radical ").append(Escape.eP4((P4)object));
                    break;
                }
                case 0x400000CC: {
                    object2 = "fixed";
                    object = Boolean.FALSE;
                    sB.append(" modelBased");
                    break;
                }
                case 1073742029: 
                case 1073742136: 
                case 1613758488: {
                    float f10;
                    object3 = this.theToken.value;
                    if (this.theTok == 1073742029) {
                        object2 = "molecular";
                        sB.append(" molecular");
                        f10 = 1.4f;
                    } else {
                        this.addShapeProperty(jmolList, "bsSolvent", this.lookupIdentifierValue("solvent"));
                        object2 = this.theTok == 1073742136 ? "sasurface" : "solvent";
                        sB.append(" ").appendO(this.theToken.value);
                        f10 = this.isFloatParameter(n2 + 1) ? this.floatParameter(++n2) : this.viewer.getFloat(0x22000032);
                        sB.append(" ").appendF(f10);
                    }
                    object = Float.valueOf(f10);
                    if (this.tokAt(n2 + 1) == 1073741961) {
                        this.addShapeProperty(jmolList, "doFullMolecular", null);
                        sB.append(" full");
                        ++n2;
                    }
                    bl5 = true;
                    break;
                }
                case 1073742033: {
                    this.addShapeProperty(jmolList, "fileType", "Mrc");
                    sB.append(" mrc");
                    continue block109;
                }
                case 0x400000EE: 
                case 0x400000F0: {
                    this.addShapeProperty(jmolList, "fileType", "Obj");
                    sB.append(" obj");
                    continue block109;
                }
                case 1073742034: {
                    this.addShapeProperty(jmolList, "fileType", "Msms");
                    sB.append(" msms");
                    continue block109;
                }
                case 1073742094: {
                    if (bl5) {
                        this.error(22);
                    }
                    object2 = "phase";
                    bl9 = true;
                    object = this.tokAt(n2 + 1) == 4 ? this.stringParameter(++n2) : "_orb";
                    sB.append(" phase ").append(Escape.eS((String)object));
                    break;
                }
                case 1073742104: 
                case 1073742122: {
                    object2 = "resolution";
                    object = Float.valueOf(this.floatParameter(++n2));
                    sB.append(" resolution ").appendO(object);
                    break;
                }
                case 1073742124: {
                    object2 = "reverseColor";
                    object = Boolean.TRUE;
                    sB.append(" reversecolor");
                    break;
                }
                case 1073742146: {
                    object2 = "sigma";
                    f = this.floatParameter(++n2);
                    object = Float.valueOf(f);
                    sB.append(" sigma ").appendO(object);
                    break;
                }
                case 1113198597: {
                    object2 = "geodesic";
                    object = Float.valueOf(this.floatParameter(++n2));
                    sB.append(" geosurface ").appendO(object);
                    bl5 = true;
                    break;
                }
                case 1073742154: {
                    object2 = "sphere";
                    object = Float.valueOf(this.floatParameter(++n2));
                    sB.append(" sphere ").appendO(object);
                    bl5 = true;
                    break;
                }
                case 1073742156: {
                    object2 = "squareData";
                    object = Boolean.TRUE;
                    sB.append(" squared");
                    break;
                }
                case 1073741983: {
                    object2 = !bl5 && !bl6 && !bl7 ? "readFile" : "mapColor";
                    string2 = this.stringParameter(++n2);
                    if (string2 == null) {
                        this.error(22);
                    }
                    if (bl2) {
                        string2 = TextFormat.replaceAllCharacter(string2, "{,}|", ' ');
                    }
                    if (this.logMessages) {
                        Logger.debug("pmesh inline data:\n" + string2);
                    }
                    object = this.chk ? null : string2;
                    this.addShapeProperty(jmolList, "fileName", "");
                    sB.append(" INLINE ").append(Escape.eS(string2));
                    bl5 = true;
                    break;
                }
                case 4: {
                    String[] stringArray;
                    String string10;
                    boolean bl39 = !bl5 && !bl6;
                    object2 = bl39 && !bl7 ? "readFile" : "mapColor";
                    String string11 = this.parameterAsString(n2);
                    if (string11.startsWith("=") && string11.length() > 1) {
                        String[] stringArray2 = (String[])this.viewer.setLoadFormat(string11, '_', false);
                        string11 = stringArray2[0];
                        String string12 = string10 = !bl39 || !Float.isNaN(f2) ? null : stringArray2[1];
                        if (string10 != null && !this.chk && (f2 = SV.fValue(SV.getVariable(this.viewer.evaluateExpression(string10)))) > 0.0f) {
                            if (!Float.isNaN(f)) {
                                f2 *= f;
                                f = Float.NaN;
                                this.addShapeProperty(jmolList, "sigma", Float.valueOf(f));
                            }
                            this.addShapeProperty(jmolList, "cutoff", Float.valueOf(f2));
                            sB.append(" cutoff ").appendF(f2);
                        }
                        if (n6 == 0) {
                            object3 = "=xxxx";
                            if (n8 < 0) {
                                n8 = this.viewer.getCurrentModelIndex();
                            }
                            bS = this.viewer.getModelUndeletedAtomsBitSet(n8);
                            this.getWithinDistanceVector(jmolList, 2.0f, null, bS, false);
                            sB.append(" within 2.0 ").append(Escape.eBS(bS));
                        }
                        if (bl39) {
                            bl23 = true;
                        }
                    }
                    if (bl39 && this.viewer.getParameter("_fileType").equals("Pdb") && Float.isNaN(f) && Float.isNaN(f2)) {
                        this.addShapeProperty(jmolList, "sigma", Float.valueOf(-1.0f));
                        sB.append(" sigma -1.0");
                    }
                    if (string11.length() == 0) {
                        if (n8 < 0) {
                            n8 = this.viewer.getCurrentModelIndex();
                        }
                        string11 = this.getFullPathName();
                        object = this.viewer.getModelAuxiliaryInfoValue(n8, "jmolSurfaceInfo");
                    }
                    int n28 = -1;
                    if (object == null && this.tokAt(n2 + 1) == 2) {
                        n28 = this.intParameter(++n2);
                        this.addShapeProperty(jmolList, "fileIndex", n28);
                    }
                    string10 = this.tokAt(n2 + 1) == 4 ? this.stringParameter(++n2) : null;
                    bl5 = true;
                    if (this.chk) break;
                    String string13 = null;
                    if (object == null) {
                        if (this.fullCommand.indexOf("# FILE" + n5 + "=") >= 0) {
                            string11 = Parser.getQuotedAttribute(this.fullCommand, "# FILE" + n5);
                            if (this.tokAt(n2 + 1) == 1073741848) {
                                n2 += 2;
                            }
                        } else if (this.tokAt(n2 + 1) == 1073741848) {
                            this.iToken = n2 += 2;
                            string13 = this.viewer.getFilePath(this.stringParameter(n2), false);
                            stringArray = this.viewer.getFullPathNameOrError(string13);
                            string13 = stringArray[0];
                            if (this.viewer.getPathForAllFiles() != "") {
                                string11 = string13;
                                string13 = null;
                            } else {
                                this.addShapeProperty(jmolList, "localName", string13);
                                this.viewer.setPrivateKeyForShape(n);
                            }
                        }
                    }
                    if (!string11.startsWith("cache://")) {
                        stringArray = this.viewer.getFullPathNameOrError(string11);
                        string11 = stringArray[0];
                        if (stringArray[1] != null) {
                            this.errorStr(17, string11 + ":" + stringArray[1]);
                        }
                    }
                    Logger.info("reading isosurface data from " + string11);
                    if (string10 != null) {
                        object = this.viewer.cacheGet(string11 + "#jmolSurfaceInfo");
                        this.addShapeProperty(jmolList, "calculationType", string10);
                    }
                    if (object == null) {
                        this.addShapeProperty(jmolList, "fileName", string11);
                        if (string13 != null) {
                            string11 = string13;
                        }
                        if (n28 >= 0) {
                            sB.append(" ").appendI(n28);
                        }
                    }
                    sB.append(" /*file*/").append(Escape.eS(string11));
                    if (string10 == null) break;
                    sB.append(" ").append(Escape.eS(string10));
                    break;
                }
                case 4106: {
                    object2 = "connections";
                    switch (this.tokAt(++n2)) {
                        case 10: 
                        case 0x100001: {
                            object = new int[]{this.atomExpressionAt(n2).nextSetBit(0)};
                            break;
                        }
                        default: {
                            object = new int[]{(int)this.floatParameterSet(n2, 1, 1)[0]};
                        }
                    }
                    n2 = this.iToken;
                    break;
                }
                case 1073741999: {
                    object2 = "link";
                    sB.append(" link");
                    break;
                }
                case 0x400000AA: {
                    if (n != 24) {
                        this.error(22);
                    }
                    P3 p33 = this.getPoint3f(this.iToken + 1, false);
                    n2 = this.iToken;
                    if (p33.x <= 0.0f || p33.y <= 0.0f || p33.z <= 0.0f) break;
                    p33.x = (int)p33.x;
                    p33.y = (int)p33.y;
                    p33.z = (int)p33.z;
                    sB.append(" lattice ").append(Escape.eP(p33));
                    if (bl7) {
                        object2 = "mapLattice";
                        object = p33;
                        break;
                    }
                    p3 = p33;
                    break;
                }
                default: {
                    if (this.theTok == 0x40000000) {
                        object2 = "thisID";
                        object = string2;
                    }
                    if (!this.setMeshDisplayProperty(n, 0, this.theTok)) {
                        if (T.tokAttr(this.theTok, 0x40000000) && !bl19) {
                            this.setShapeId(n, n2, bl19);
                            n2 = this.iToken;
                            break;
                        }
                        this.error(22);
                    }
                    if (n3 == 0) {
                        n3 = n2;
                    }
                    n2 = this.slen - 1;
                }
            }
            boolean bl40 = bl19 = this.theTok != 12291;
            if (bl20 && bl5) {
                this.error(22);
            }
            if (object2 == null) continue;
            this.addShapeProperty(jmolList, (String)object2, object);
        }
        if (!this.chk) {
            ColorEncoder colorEncoder;
            if ((bl12 || bl13) && !bl5) {
                bl5 = true;
                this.addShapeProperty(jmolList, "bsSolvent", bl13 ? new BS() : this.lookupIdentifierValue("solvent"));
                this.addShapeProperty(jmolList, "sasurface", Float.valueOf(0.0f));
            }
            if (bl6 && !bl5 && !bl7) {
                this.addShapeProperty(jmolList, "nomap", Float.valueOf(0.0f));
                bl5 = true;
            }
            if (n4 >= 0) {
                this.addShapeProperty(jmolList, "getSurfaceSets", n4 - 1);
            }
            if (sArray != null) {
                this.addShapeProperty(jmolList, "colorDiscrete", sArray);
            } else if ("sets".equals(string4)) {
                this.addShapeProperty(jmolList, "setColorScheme", null);
            } else if (string4 != null && (colorEncoder = this.viewer.getColorEncoder(string4)) != null) {
                colorEncoder.isTranslucent = bl21;
                colorEncoder.hi = Float.MAX_VALUE;
                this.addShapeProperty(jmolList, "remapColor", colorEncoder);
            }
            if (bl5 && !bl4 && sB.indexOf(";") != 0) {
                jmolList.add(0, new Object[]{"newObject", null});
                int n29 = n2 = bS2 == null ? 1 : 0;
                if (n2 != 0) {
                    bS2 = BSUtil.copy(this.viewer.getSelectionSet(false));
                }
                if (n8 < 0) {
                    n8 = this.viewer.getCurrentModelIndex();
                }
                bS2.and(this.viewer.getModelUndeletedAtomsBitSet(n8));
                if (object3 != null) {
                    object2 = this.viewer.getModelBitSet(bS2, false);
                    if (((BS)object2).cardinality() != 1) {
                        this.errorStr(30, "ISOSURFACE " + object3);
                    }
                    if (n2 != 0) {
                        jmolList.add(0, new Object[]{"select", bS2});
                        if (sB.indexOf("; isosurface map") == 0) {
                            sB = new SB().append("; isosurface map select ").append(Escape.eBS(bS2)).append(sB.substring(16));
                        }
                    }
                }
            }
            if (bl17 && !bl16) {
                if (!bl5) {
                    this.addShapeProperty(jmolList, "sasurface", Float.valueOf(0.0f));
                }
                if (!bl7) {
                    this.addShapeProperty(jmolList, "map", Boolean.TRUE);
                    this.addShapeProperty(jmolList, "select", bS);
                    this.addShapeProperty(jmolList, "sasurface", Float.valueOf(0.0f));
                }
                this.addShapeProperty(jmolList, "slab", this.getCapSlabObject(-100, false));
            }
            this.setShapeProperty(n, "setProperties", jmolList);
            if (bl23) {
                this.setShapeProperty(n, "token", 1073742018);
                this.setShapeProperty(n, "token", 1073742046);
                this.setShapeProperty(n, "token", 0x40000088);
                sB.append(" mesh nofill frontOnly");
            }
        }
        if (p3 != null) {
            this.setShapeProperty(24, "lattice", p3);
        }
        if (n3 > 0 && !this.setMeshDisplayProperty(n, n3, 0)) {
            this.error(22);
        }
        if (this.chk) {
            return;
        }
        Object object5 = null;
        object2 = null;
        if (bl10) {
            object5 = this.getShapeProperty(n, "area");
            if (object5 instanceof Float) {
                this.viewer.setFloatProperty("isosurfaceArea", ((Float)object5).floatValue());
            } else {
                this.viewer.setUserVariable("isosurfaceArea", SV.getVariableAD((double[])object5));
            }
        }
        if (bl11) {
            Object object6 = object2 = bl11 ? this.getShapeProperty(n, "volume") : null;
            if (object2 instanceof Float) {
                this.viewer.setFloatProperty("isosurfaceVolume", ((Float)object2).floatValue());
            } else {
                this.viewer.setUserVariable("isosurfaceVolume", SV.getVariableAD((double[])object2));
            }
        }
        if (!bl4) {
            object = null;
            if (bl7 && !bl5) {
                this.setShapeProperty(n, "finalize", sB.toString());
            } else if (bl5) {
                string = sB.toString();
                this.setShapeProperty(n, "finalize", (string.indexOf("; isosurface map") == 0 ? "" : " select " + Escape.eBS(bS2) + " ") + string);
                object = (String)this.getShapeProperty(n, "ID");
                if (object != null && !this.tQuiet) {
                    float[] fArray7;
                    f2 = ((Float)this.getShapeProperty(n, "cutoff")).floatValue();
                    if (Float.isNaN(f2) && !Float.isNaN(f)) {
                        Logger.error("sigma not supported");
                    }
                    object = (String)object + " created";
                    if (bl) {
                        object = (String)object + " with cutoff=" + f2;
                    }
                    if ((fArray7 = (float[])this.getShapeProperty(n, "minMaxInfo"))[0] != Float.MAX_VALUE) {
                        object = (String)object + " min=" + fArray7[0] + " max=" + fArray7[1];
                    }
                    object = (String)object + "; " + JC.shapeClassBases[n].toLowerCase() + " count: " + this.getShapeProperty(n, "count");
                    object = (String)object + this.getIsosurfaceDataRange(n, "\n");
                }
            }
            if (bl10 || bl11) {
                String string14;
                String string15;
                String string16 = bl10 ? "isosurfaceArea = " + (object5 instanceof Float ? "" + object5 : Escape.eAD((double[])object5)) : (string15 = null);
                String string17 = bl11 ? "isosurfaceVolume = " + (object2 instanceof Float ? "" + object2 : Escape.eAD((double[])object2)) : (string14 = null);
                if (object == null) {
                    if (bl10) {
                        this.showString(string15);
                    }
                    if (bl11) {
                        this.showString(string14);
                    }
                } else {
                    if (bl10) {
                        object = (String)object + "\n" + string15;
                    }
                    if (bl11) {
                        object = (String)object + "\n" + string14;
                    }
                }
            }
            if (object != null) {
                this.showString((String)object);
            }
        }
        if (string3 != null) {
            this.setShapeProperty(n, "translucency", string3);
        }
        this.setShapeProperty(n, "clear", null);
        if (bl14) {
            object = (String)this.getShapeProperty(n, "ID");
            this.viewer.cachePut("cache://isosurface_" + (String)object, this.getShapeProperty(n, "jvxlDataXml"));
            this.runScript("isosurface ID \"" + (String)object + "\" delete;isosurface ID \"" + (String)object + "\"" + (n8 >= 0 ? " model " + n8 : "") + " \"cache://isosurface_" + this.getShapeProperty(n, "ID") + "\"");
        }
    }

    private String setColorOptions(SB sB, int n, int n2, int n3) throws ScriptException {
        this.getToken(n);
        String string = "opaque";
        if (this.theTok == 1073742180) {
            string = "translucent";
            if (n3 < 0) {
                float f = this.isFloatParameter(n + 1) ? this.floatParameter(++n) : Float.MAX_VALUE;
                this.setShapeTranslucency(n2, null, "translucent", f, null);
                if (sB != null) {
                    sB.append(" translucent");
                    if (f != Float.MAX_VALUE) {
                        sB.append(" ").appendF(f);
                    }
                }
            } else {
                this.setMeshDisplayProperty(n2, n, this.theTok);
            }
        } else if (this.theTok == 1073742074) {
            if (n3 >= 0) {
                this.setMeshDisplayProperty(n2, n, this.theTok);
            }
        } else {
            --this.iToken;
        }
        n3 = Math.abs(n3);
        for (int i = 0; i < n3; ++i) {
            if (this.isColorParam(this.iToken + 1)) {
                int n4 = this.getArgbParam(++this.iToken);
                this.setShapeProperty(n2, "colorRGB", n4);
                if (sB == null) continue;
                sB.append(" ").append(Escape.escapeColor(n4));
                continue;
            }
            if (this.iToken >= n) break;
            this.error(22);
        }
        return string;
    }

    private String getColorRange(int n) throws ScriptException {
        int n2 = this.getArgbParam(n);
        if (this.tokAt(++this.iToken) != 1074790746) {
            this.error(22);
        }
        int n3 = this.getArgbParam(++this.iToken);
        int n4 = this.tokAt(this.iToken + 1) == 2 ? this.intParameter(++this.iToken) : 0;
        return ColorEncoder.getColorSchemeList(ColorEncoder.getPaletteAtoB(n2, n3, n4));
    }

    private String getIsosurfaceDataRange(int n, String string) {
        float[] fArray = (float[])this.getShapeProperty(n, "dataRange");
        return fArray != null && fArray[0] != Float.MAX_VALUE && fArray[0] != fArray[1] ? string + "isosurface" + " full data range " + fArray[0] + " to " + fArray[1] + " with color scheme spanning " + fArray[2] + " to " + fArray[3] : "";
    }

    private void getWithinDistanceVector(JmolList<Object[]> jmolList, float f, P3 p3, BS bS, boolean bl) {
        JmolList<P3> jmolList2 = new JmolList<P3>();
        P3[] p3Array = new P3[2];
        if (bS == null) {
            P3 p32 = P3.new3(f, f, f);
            P3 p33 = P3.newP(p3);
            p33.sub(p32);
            p32.add(p3);
            p3Array[0] = p33;
            p3Array[1] = p32;
            jmolList2.addLast(p3);
        } else {
            BoxInfo boxInfo = this.viewer.getBoxInfo(bS, -Math.abs(f));
            p3Array[0] = boxInfo.getBboxVertices()[0];
            p3Array[1] = boxInfo.getBboxVertices()[7];
            if (bS.cardinality() == 1) {
                jmolList2.addLast(this.viewer.getAtomPoint3f(bS.nextSetBit(0)));
            }
        }
        if (jmolList2.size() == 1 && !bl) {
            this.addShapeProperty(jmolList, "withinDistance", Float.valueOf(f));
            this.addShapeProperty(jmolList, "withinPoint", jmolList2.get(0));
        }
        this.addShapeProperty(jmolList, bl ? "displayWithin" : "withinPoints", new Object[]{Float.valueOf(f), p3Array, bS, jmolList2});
    }

    private boolean setMeshDisplayProperty(int n, int n2, int n3) throws ScriptException {
        boolean bl;
        String string = null;
        Integer n4 = null;
        boolean bl2 = n == 25;
        boolean bl3 = bl = n2 == 0;
        if (!bl) {
            n3 = this.getToken((int)n2).tok;
        }
        switch (n3) {
            case 1766856708: {
                if (!bl2) break;
                ++this.iToken;
            }
            case 1073742074: 
            case 1073742180: {
                if (!bl) {
                    this.colorShape(n, this.iToken, false);
                }
                return true;
            }
            case 0: 
            case 12291: 
            case 12294: 
            case 0x10000C: 
            case 0x10000D: 
            case 3145768: 
            case 3145770: 
            case 1610625028: {
                if (this.iToken == 1 && n >= 0 && this.tokAt(2) == 0) {
                    this.setShapeProperty(n, "thisID", null);
                }
                if (n3 == 0) {
                    return this.iToken == 1;
                }
                if (bl) {
                    return true;
                }
                switch (n3) {
                    case 12291: {
                        this.setShapeProperty(n, "delete", null);
                        return true;
                    }
                    case 12294: 
                    case 3145770: {
                        n3 = 0x10000C;
                        break;
                    }
                    case 3145768: {
                        n3 = 0x10000D;
                        break;
                    }
                    case 1610625028: {
                        if (n2 + 1 != this.slen) break;
                        n3 = 0x10000D;
                    }
                }
            }
            case 1073741862: 
            case 0x4000004A: 
            case 1073741938: 
            case 1073741958: 
            case 0x40000088: 
            case 1073741964: 
            case 1073742018: 
            case 1073742039: 
            case 1073742042: 
            case 1073742046: 
            case 0x400000E4: 
            case 1073742058: 
            case 1073742060: 
            case 1073742182: 
            case 1113198595: {
                string = "token";
                n4 = n3;
            }
        }
        if (string == null) {
            return false;
        }
        if (bl) {
            return true;
        }
        this.setShapeProperty(n, string, n4);
        if (this.tokAt(this.iToken + 1) != 0 && !this.setMeshDisplayProperty(n, ++this.iToken, 0)) {
            --this.iToken;
        }
        return true;
    }

    private void bind() throws ScriptException {
        String string = this.stringParameter(1);
        String string2 = this.parameterAsString(2);
        P3 p3 = null;
        P3 p32 = null;
        this.checkLength(3);
        if (!this.chk) {
            this.viewer.bindAction(string, string2, p3, p32);
        }
    }

    private void unbind() throws ScriptException {
        if (this.slen != 1) {
            this.checkLength23();
        }
        String string = this.optParameterAsString(1);
        String string2 = this.optParameterAsString(2);
        if (string.length() == 0 || this.tokAt(1) == 0x100003) {
            string = null;
        }
        if (string2.length() == 0 || this.tokAt(2) == 0x100003) {
            string2 = null;
        }
        if (string2 == null && string != null && ActionManager.getActionFromName(string) >= 0) {
            string2 = string;
            string = null;
        }
        if (!this.chk) {
            this.viewer.unBindAction(string, string2);
        }
    }

    private void undoRedoMove() throws ScriptException {
        int n = 1;
        int n2 = 2;
        switch (this.tokAt(1)) {
            case 0: {
                n2 = 1;
                break;
            }
            case 0x100003: {
                n = 0;
                break;
            }
            case 2: {
                n = this.intParameter(1);
                break;
            }
            default: {
                this.error(22);
            }
        }
        this.checkLength(n2);
        if (!this.chk) {
            this.viewer.undoMoveAction(this.tokAt(0), n);
        }
    }

    BS getAtomsNearSurface(float f, String string) {
        Object[] objectArray = new Object[]{string, null, null};
        if (this.chk) {
            return new BS();
        }
        if (this.getShapePropertyData(24, "getVertices", objectArray)) {
            return this.viewer.getAtomsNearPts(f, (P3[])objectArray[1], (BS)objectArray[2]);
        }
        objectArray[1] = 0;
        objectArray[2] = -1;
        if (this.getShapePropertyData(22, "getCenter", objectArray)) {
            return this.viewer.getAtomsNearPt(f, (P3)objectArray[2]);
        }
        return new BS();
    }

    static int getFloatEncodedInt(String string) {
        int n = string.indexOf(".");
        if (n < 1 || string.charAt(0) == '-' || string.endsWith(".") || string.contains(".0")) {
            return Integer.MAX_VALUE;
        }
        int n2 = 0;
        int n3 = 0;
        if (n > 0) {
            try {
                n2 = Integer.parseInt(string.substring(0, n));
                if (n2 < 0) {
                    n2 = -n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                n2 = -1;
            }
        }
        if (n < string.length() - 1) {
            try {
                n3 = Integer.parseInt(string.substring(n + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return (n2 = n2 * 1000000 + n3) < 0 ? Integer.MAX_VALUE : n2;
    }

    static int getPartialBondOrderFromFloatEncodedInt(int n) {
        return (n / 1000000 % 6 << 5) + (n % 1000000 & 0x1F);
    }

    static int getBondOrderFromString(String string) {
        return string.indexOf(32) < 0 ? JmolEdge.getBondOrderFromString(string) : (string.toLowerCase().indexOf("partial ") == 0 ? ScriptEvaluator.getPartialBondOrderFromString(string.substring(8).trim()) : 131071);
    }

    private static int getPartialBondOrderFromString(String string) {
        return ScriptEvaluator.getPartialBondOrderFromFloatEncodedInt(ScriptEvaluator.getFloatEncodedInt(string));
    }

    @Override
    public BS addHydrogensInline(BS bS, JmolList<Atom> jmolList, P3[] p3Array) throws Exception {
        int n = this.viewer.getAtomModelIndex(bS.nextSetBit(0));
        if (n != this.viewer.modelSet.modelCount - 1) {
            return new BS();
        }
        BS bS2 = this.viewer.getModelUndeletedAtomsBitSet(n);
        this.viewer.setAppendNew(false);
        int n2 = this.viewer.modelSet.getAtomCount();
        int n3 = this.viewer.modelSet.getAtomCountInModel(n);
        SB sB = new SB();
        for (int i = 0; i < jmolList.size(); ++i) {
            Atom atom = (Atom)jmolList.get(i);
            sB.append(";  connect 0 100 ").append("({" + n2++ + "}) ").append("({" + atom.index + "}) group;");
        }
        SB sB2 = new SB();
        sB2.appendI(p3Array.length).append("\n").append("Viewer.AddHydrogens").append("#noautobond").append("\n");
        for (int i = 0; i < p3Array.length; ++i) {
            sB2.append("H ").appendF(p3Array[i].x).append(" ").appendF(p3Array[i].y).append(" ").appendF(p3Array[i].z).append(" - - - - ").appendI(++n3).appendC('\n');
        }
        this.viewer.loadInlineScript(sB2.toString(), '\n', true, null);
        this.runScriptBuffer(sB.toString(), null);
        BS bS3 = this.viewer.getModelUndeletedAtomsBitSet(n);
        bS3.andNot(bS2);
        return bS3;
    }
}

